/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.sql.execute.ExecPreparedStatement;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.sql.execute.ResultSetStatisticsFactory;
import org.apache.derby.iapi.sql.execute.RunTimeStatistics;
import org.apache.derby.impl.sql.execute.AnyResultSet;
import org.apache.derby.impl.sql.execute.CurrentOfResultSet;
import org.apache.derby.impl.sql.execute.DeleteCascadeResultSet;
import org.apache.derby.impl.sql.execute.DeleteResultSet;
import org.apache.derby.impl.sql.execute.DeleteVTIResultSet;
import org.apache.derby.impl.sql.execute.DependentResultSet;
import org.apache.derby.impl.sql.execute.DistinctScalarAggregateResultSet;
import org.apache.derby.impl.sql.execute.DistinctScanResultSet;
import org.apache.derby.impl.sql.execute.GroupedAggregateResultSet;
import org.apache.derby.impl.sql.execute.HashJoinResultSet;
import org.apache.derby.impl.sql.execute.HashLeftOuterJoinResultSet;
import org.apache.derby.impl.sql.execute.HashScanResultSet;
import org.apache.derby.impl.sql.execute.HashTableResultSet;
import org.apache.derby.impl.sql.execute.IndexRowToBaseRowResultSet;
import org.apache.derby.impl.sql.execute.InsertResultSet;
import org.apache.derby.impl.sql.execute.InsertVTIResultSet;
import org.apache.derby.impl.sql.execute.LastIndexKeyResultSet;
import org.apache.derby.impl.sql.execute.MaterializedResultSet;
import org.apache.derby.impl.sql.execute.NestedLoopJoinResultSet;
import org.apache.derby.impl.sql.execute.NestedLoopLeftOuterJoinResultSet;
import org.apache.derby.impl.sql.execute.NormalizeResultSet;
import org.apache.derby.impl.sql.execute.OnceResultSet;
import org.apache.derby.impl.sql.execute.ProjectRestrictResultSet;
import org.apache.derby.impl.sql.execute.RowResultSet;
import org.apache.derby.impl.sql.execute.ScalarAggregateResultSet;
import org.apache.derby.impl.sql.execute.ScrollInsensitiveResultSet;
import org.apache.derby.impl.sql.execute.SetOpResultSet;
import org.apache.derby.impl.sql.execute.SortResultSet;
import org.apache.derby.impl.sql.execute.TableScanResultSet;
import org.apache.derby.impl.sql.execute.UnionResultSet;
import org.apache.derby.impl.sql.execute.UpdateResultSet;
import org.apache.derby.impl.sql.execute.VTIResultSet;
import org.apache.derby.impl.sql.execute.rts.RealAnyResultSetStatistics;
import org.apache.derby.impl.sql.execute.rts.RealCurrentOfStatistics;
import org.apache.derby.impl.sql.execute.rts.RealDeleteCascadeResultSetStatistics;
import org.apache.derby.impl.sql.execute.rts.RealDeleteResultSetStatistics;
import org.apache.derby.impl.sql.execute.rts.RealDeleteVTIResultSetStatistics;
import org.apache.derby.impl.sql.execute.rts.RealDistinctScalarAggregateStatistics;
import org.apache.derby.impl.sql.execute.rts.RealDistinctScanStatistics;
import org.apache.derby.impl.sql.execute.rts.RealGroupedAggregateStatistics;
import org.apache.derby.impl.sql.execute.rts.RealHashJoinStatistics;
import org.apache.derby.impl.sql.execute.rts.RealHashLeftOuterJoinStatistics;
import org.apache.derby.impl.sql.execute.rts.RealHashScanStatistics;
import org.apache.derby.impl.sql.execute.rts.RealHashTableStatistics;
import org.apache.derby.impl.sql.execute.rts.RealIndexRowToBaseRowStatistics;
import org.apache.derby.impl.sql.execute.rts.RealInsertResultSetStatistics;
import org.apache.derby.impl.sql.execute.rts.RealInsertVTIResultSetStatistics;
import org.apache.derby.impl.sql.execute.rts.RealLastIndexKeyScanStatistics;
import org.apache.derby.impl.sql.execute.rts.RealMaterializedResultSetStatistics;
import org.apache.derby.impl.sql.execute.rts.RealNestedLoopJoinStatistics;
import org.apache.derby.impl.sql.execute.rts.RealNestedLoopLeftOuterJoinStatistics;
import org.apache.derby.impl.sql.execute.rts.RealNoRowsResultSetStatistics;
import org.apache.derby.impl.sql.execute.rts.RealNormalizeResultSetStatistics;
import org.apache.derby.impl.sql.execute.rts.RealOnceResultSetStatistics;
import org.apache.derby.impl.sql.execute.rts.RealProjectRestrictStatistics;
import org.apache.derby.impl.sql.execute.rts.RealRowResultSetStatistics;
import org.apache.derby.impl.sql.execute.rts.RealScalarAggregateStatistics;
import org.apache.derby.impl.sql.execute.rts.RealScrollInsensitiveResultSetStatistics;
import org.apache.derby.impl.sql.execute.rts.RealSetOpResultSetStatistics;
import org.apache.derby.impl.sql.execute.rts.RealSortStatistics;
import org.apache.derby.impl.sql.execute.rts.RealTableScanStatistics;
import org.apache.derby.impl.sql.execute.rts.RealUnionResultSetStatistics;
import org.apache.derby.impl.sql.execute.rts.RealUpdateResultSetStatistics;
import org.apache.derby.impl.sql.execute.rts.RealVTIStatistics;
import org.apache.derby.impl.sql.execute.rts.ResultSetStatistics;
import org.apache.derby.impl.sql.execute.rts.RunTimeStatisticsImpl;

public class RealResultSetStatisticsFactory
implements ResultSetStatisticsFactory {
    public RunTimeStatistics getRunTimeStatistics(Activation activation, ResultSet rs, NoPutResultSet[] subqueryTrackingArray) throws StandardException {
        ExecPreparedStatement preStmt = activation.getPreparedStatement();
        if (preStmt == null) {
            return null;
        }
        ResultSetStatistics topResultSetStatistics = rs instanceof NoPutResultSet ? this.getResultSetStatistics((NoPutResultSet)rs) : this.getResultSetStatistics(rs);
        int subqueryTrackingArrayLength = subqueryTrackingArray == null ? 0 : subqueryTrackingArray.length;
        ResultSetStatistics[] subqueryRSS = new ResultSetStatistics[subqueryTrackingArrayLength];
        boolean anyAttached = false;
        for (int index = 0; index < subqueryTrackingArrayLength; ++index) {
            if (subqueryTrackingArray[index] == null || subqueryTrackingArray[index].getPointOfAttachment() != -1) continue;
            subqueryRSS[index] = this.getResultSetStatistics(subqueryTrackingArray[index]);
            anyAttached = true;
        }
        if (!anyAttached) {
            subqueryRSS = null;
        }
        return new RunTimeStatisticsImpl(preStmt.getSPSName(), activation.getCursorName(), preStmt.getSource(), preStmt.getCompileTimeInMillis(), preStmt.getParseTimeInMillis(), preStmt.getBindTimeInMillis(), preStmt.getOptimizeTimeInMillis(), preStmt.getGenerateTimeInMillis(), rs.getExecuteTime(), preStmt.getBeginCompileTimestamp(), preStmt.getEndCompileTimestamp(), rs.getBeginExecutionTimestamp(), rs.getEndExecutionTimestamp(), subqueryRSS, topResultSetStatistics);
    }

    public ResultSetStatistics getResultSetStatistics(ResultSet rs) {
        if (!rs.returnsRows()) {
            return this.getNoRowsResultSetStatistics(rs);
        }
        if (rs instanceof NoPutResultSet) {
            return this.getResultSetStatistics((NoPutResultSet)rs);
        }
        return null;
    }

    public ResultSetStatistics getNoRowsResultSetStatistics(ResultSet rs) {
        RealNoRowsResultSetStatistics retval = null;
        if (rs instanceof InsertResultSet) {
            InsertResultSet irs = (InsertResultSet)rs;
            retval = new RealInsertResultSetStatistics(irs.rowCount, irs.constants.deferred, irs.constants.irgs.length, irs.userSpecifiedBulkInsert, irs.bulkInsertPerformed, irs.constants.lockMode == 7, irs.getExecuteTime(), this.getResultSetStatistics(irs.savedSource));
            irs.savedSource = null;
        } else if (rs instanceof InsertVTIResultSet) {
            InsertVTIResultSet iVTIrs = (InsertVTIResultSet)rs;
            retval = new RealInsertVTIResultSetStatistics(iVTIrs.rowCount, iVTIrs.constants.deferred, iVTIrs.getExecuteTime(), this.getResultSetStatistics(iVTIrs.savedSource));
            iVTIrs.savedSource = null;
        } else if (rs instanceof UpdateResultSet) {
            UpdateResultSet urs = (UpdateResultSet)rs;
            retval = new RealUpdateResultSetStatistics(urs.rowCount, urs.constants.deferred, urs.constants.irgs.length, urs.constants.lockMode == 7, urs.getExecuteTime(), this.getResultSetStatistics(urs.savedSource));
            urs.savedSource = null;
        } else if (rs instanceof DeleteCascadeResultSet) {
            DeleteCascadeResultSet dcrs = (DeleteCascadeResultSet)rs;
            int dependentTrackingArrayLength = dcrs.dependentResultSets == null ? 0 : dcrs.dependentResultSets.length;
            ResultSetStatistics[] dependentTrackingArray = new ResultSetStatistics[dependentTrackingArrayLength];
            boolean anyAttached = false;
            for (int index = 0; index < dependentTrackingArrayLength; ++index) {
                if (dcrs.dependentResultSets[index] == null) continue;
                dependentTrackingArray[index] = this.getResultSetStatistics(dcrs.dependentResultSets[index]);
                anyAttached = true;
            }
            if (!anyAttached) {
                dependentTrackingArray = null;
            }
            retval = new RealDeleteCascadeResultSetStatistics(dcrs.rowCount, dcrs.constants.deferred, dcrs.constants.irgs.length, dcrs.constants.lockMode == 7, dcrs.getExecuteTime(), this.getResultSetStatistics(dcrs.savedSource), dependentTrackingArray);
            dcrs.savedSource = null;
        } else if (rs instanceof DeleteResultSet) {
            DeleteResultSet drs = (DeleteResultSet)rs;
            retval = new RealDeleteResultSetStatistics(drs.rowCount, drs.constants.deferred, drs.constants.irgs.length, drs.constants.lockMode == 7, drs.getExecuteTime(), this.getResultSetStatistics(drs.savedSource));
            drs.savedSource = null;
        } else if (rs instanceof DeleteVTIResultSet) {
            DeleteVTIResultSet dVTIrs = (DeleteVTIResultSet)rs;
            retval = new RealDeleteVTIResultSetStatistics(dVTIrs.rowCount, dVTIrs.getExecuteTime(), this.getResultSetStatistics(dVTIrs.savedSource));
            dVTIrs.savedSource = null;
        }
        return retval;
    }

    public ResultSetStatistics getResultSetStatistics(NoPutResultSet rs) {
        if (rs instanceof ProjectRestrictResultSet) {
            ProjectRestrictResultSet prrs = (ProjectRestrictResultSet)rs;
            int subqueryTrackingArrayLength = prrs.subqueryTrackingArray == null ? 0 : prrs.subqueryTrackingArray.length;
            ResultSetStatistics[] subqueryTrackingArray = new ResultSetStatistics[subqueryTrackingArrayLength];
            boolean anyAttached = false;
            for (int index = 0; index < subqueryTrackingArrayLength; ++index) {
                if (prrs.subqueryTrackingArray[index] == null || prrs.subqueryTrackingArray[index].getPointOfAttachment() != prrs.resultSetNumber) continue;
                subqueryTrackingArray[index] = this.getResultSetStatistics(prrs.subqueryTrackingArray[index]);
                anyAttached = true;
            }
            if (!anyAttached) {
                subqueryTrackingArray = null;
            }
            return new RealProjectRestrictStatistics(prrs.numOpens, prrs.rowsSeen, prrs.rowsFiltered, prrs.constructorTime, prrs.openTime, prrs.nextTime, prrs.closeTime, prrs.resultSetNumber, prrs.restrictionTime, prrs.projectionTime, subqueryTrackingArray, prrs.restriction != null, prrs.doesProjection, prrs.optimizerEstimatedRowCount, prrs.optimizerEstimatedCost, this.getResultSetStatistics(prrs.source));
        }
        if (rs instanceof SortResultSet) {
            SortResultSet srs = (SortResultSet)rs;
            return new RealSortStatistics(srs.numOpens, srs.rowsSeen, srs.rowsFiltered, srs.constructorTime, srs.openTime, srs.nextTime, srs.closeTime, srs.resultSetNumber, srs.rowsInput, srs.rowsReturned, srs.distinct, srs.isInSortedOrder, srs.sortProperties, srs.optimizerEstimatedRowCount, srs.optimizerEstimatedCost, this.getResultSetStatistics(srs.source));
        }
        if (rs instanceof DistinctScalarAggregateResultSet) {
            DistinctScalarAggregateResultSet dsars = (DistinctScalarAggregateResultSet)rs;
            return new RealDistinctScalarAggregateStatistics(dsars.numOpens, dsars.rowsSeen, dsars.rowsFiltered, dsars.constructorTime, dsars.openTime, dsars.nextTime, dsars.closeTime, dsars.resultSetNumber, dsars.rowsInput, dsars.optimizerEstimatedRowCount, dsars.optimizerEstimatedCost, this.getResultSetStatistics(dsars.source));
        }
        if (rs instanceof ScalarAggregateResultSet) {
            ScalarAggregateResultSet sars = (ScalarAggregateResultSet)rs;
            return new RealScalarAggregateStatistics(sars.numOpens, sars.rowsSeen, sars.rowsFiltered, sars.constructorTime, sars.openTime, sars.nextTime, sars.closeTime, sars.resultSetNumber, sars.singleInputRow, sars.rowsInput, sars.optimizerEstimatedRowCount, sars.optimizerEstimatedCost, this.getResultSetStatistics(sars.source));
        }
        if (rs instanceof GroupedAggregateResultSet) {
            GroupedAggregateResultSet gars = (GroupedAggregateResultSet)rs;
            return new RealGroupedAggregateStatistics(gars.numOpens, gars.rowsSeen, gars.rowsFiltered, gars.constructorTime, gars.openTime, gars.nextTime, gars.closeTime, gars.resultSetNumber, gars.rowsInput, gars.hasDistinctAggregate, gars.isInSortedOrder, gars.sortProperties, gars.optimizerEstimatedRowCount, gars.optimizerEstimatedCost, this.getResultSetStatistics(gars.source));
        }
        if (rs instanceof TableScanResultSet) {
            boolean instantaneousLocks = false;
            TableScanResultSet tsrs = (TableScanResultSet)rs;
            String startPosition = null;
            String stopPosition = null;
            String isolationLevel = null;
            String lockString = null;
            String lockRequestString = null;
            switch (tsrs.isolationLevel) {
                case 5: {
                    isolationLevel = MessageService.getTextMessage("42Z80.U");
                    break;
                }
                case 4: {
                    isolationLevel = MessageService.getTextMessage("42Z92");
                    break;
                }
                case 3: {
                    instantaneousLocks = true;
                }
                case 2: {
                    isolationLevel = MessageService.getTextMessage("42Z81.U");
                    break;
                }
                case 1: {
                    isolationLevel = MessageService.getTextMessage("42Z9A");
                }
            }
            lockString = tsrs.forUpdate ? MessageService.getTextMessage("42Z82.U") : (instantaneousLocks ? MessageService.getTextMessage("42Z83.U") : MessageService.getTextMessage("42Z84.U"));
            switch (tsrs.lockMode) {
                case 7: {
                    lockRequestString = lockString + " " + MessageService.getTextMessage("42Z85.U");
                    break;
                }
                case 6: {
                    lockRequestString = lockString + " " + MessageService.getTextMessage("42Z86.U");
                }
            }
            if (tsrs.indexName != null) {
                startPosition = tsrs.startPositionString;
                if (startPosition == null) {
                    startPosition = tsrs.printStartPosition();
                }
                if ((stopPosition = tsrs.stopPositionString) == null) {
                    stopPosition = tsrs.printStopPosition();
                }
            }
            return new RealTableScanStatistics(tsrs.numOpens, tsrs.rowsSeen, tsrs.rowsFiltered, tsrs.constructorTime, tsrs.openTime, tsrs.nextTime, tsrs.closeTime, tsrs.resultSetNumber, tsrs.tableName, tsrs.userSuppliedOptimizerOverrides, tsrs.indexName, tsrs.isConstraint, TableScanResultSet.printQualifiers(tsrs.qualifiers), tsrs.getScanProperties(), startPosition, stopPosition, isolationLevel, lockRequestString, tsrs.rowsPerRead, tsrs.coarserLock, tsrs.optimizerEstimatedRowCount, tsrs.optimizerEstimatedCost);
        }
        if (rs instanceof LastIndexKeyResultSet) {
            LastIndexKeyResultSet lrs = (LastIndexKeyResultSet)rs;
            String isolationLevel = null;
            String lockRequestString = null;
            switch (lrs.isolationLevel) {
                case 5: {
                    isolationLevel = MessageService.getTextMessage("42Z80.U");
                    break;
                }
                case 4: {
                    isolationLevel = MessageService.getTextMessage("42Z92");
                    break;
                }
                case 2: 
                case 3: {
                    isolationLevel = MessageService.getTextMessage("42Z81.U");
                    break;
                }
                case 1: {
                    isolationLevel = MessageService.getTextMessage("42Z9A");
                }
            }
            switch (lrs.lockMode) {
                case 7: {
                    lockRequestString = MessageService.getTextMessage("42Z87.U");
                    break;
                }
                case 6: {
                    lockRequestString = MessageService.getTextMessage("42Z88.U");
                }
            }
            return new RealLastIndexKeyScanStatistics(lrs.numOpens, lrs.constructorTime, lrs.openTime, lrs.nextTime, lrs.closeTime, lrs.resultSetNumber, lrs.tableName, lrs.indexName, isolationLevel, lockRequestString, lrs.optimizerEstimatedRowCount, lrs.optimizerEstimatedCost);
        }
        if (rs instanceof HashLeftOuterJoinResultSet) {
            HashLeftOuterJoinResultSet hlojrs = (HashLeftOuterJoinResultSet)rs;
            return new RealHashLeftOuterJoinStatistics(hlojrs.numOpens, hlojrs.rowsSeen, hlojrs.rowsFiltered, hlojrs.constructorTime, hlojrs.openTime, hlojrs.nextTime, hlojrs.closeTime, hlojrs.resultSetNumber, hlojrs.rowsSeenLeft, hlojrs.rowsSeenRight, hlojrs.rowsReturned, hlojrs.restrictionTime, hlojrs.optimizerEstimatedRowCount, hlojrs.optimizerEstimatedCost, hlojrs.userSuppliedOptimizerOverrides, this.getResultSetStatistics(hlojrs.leftResultSet), this.getResultSetStatistics(hlojrs.rightResultSet), hlojrs.emptyRightRowsReturned);
        }
        if (rs instanceof NestedLoopLeftOuterJoinResultSet) {
            NestedLoopLeftOuterJoinResultSet nllojrs = (NestedLoopLeftOuterJoinResultSet)rs;
            return new RealNestedLoopLeftOuterJoinStatistics(nllojrs.numOpens, nllojrs.rowsSeen, nllojrs.rowsFiltered, nllojrs.constructorTime, nllojrs.openTime, nllojrs.nextTime, nllojrs.closeTime, nllojrs.resultSetNumber, nllojrs.rowsSeenLeft, nllojrs.rowsSeenRight, nllojrs.rowsReturned, nllojrs.restrictionTime, nllojrs.optimizerEstimatedRowCount, nllojrs.optimizerEstimatedCost, nllojrs.userSuppliedOptimizerOverrides, this.getResultSetStatistics(nllojrs.leftResultSet), this.getResultSetStatistics(nllojrs.rightResultSet), nllojrs.emptyRightRowsReturned);
        }
        if (rs instanceof HashJoinResultSet) {
            HashJoinResultSet hjrs = (HashJoinResultSet)rs;
            return new RealHashJoinStatistics(hjrs.numOpens, hjrs.rowsSeen, hjrs.rowsFiltered, hjrs.constructorTime, hjrs.openTime, hjrs.nextTime, hjrs.closeTime, hjrs.resultSetNumber, hjrs.rowsSeenLeft, hjrs.rowsSeenRight, hjrs.rowsReturned, hjrs.restrictionTime, hjrs.oneRowRightSide, hjrs.optimizerEstimatedRowCount, hjrs.optimizerEstimatedCost, hjrs.userSuppliedOptimizerOverrides, this.getResultSetStatistics(hjrs.leftResultSet), this.getResultSetStatistics(hjrs.rightResultSet));
        }
        if (rs instanceof NestedLoopJoinResultSet) {
            NestedLoopJoinResultSet nljrs = (NestedLoopJoinResultSet)rs;
            return new RealNestedLoopJoinStatistics(nljrs.numOpens, nljrs.rowsSeen, nljrs.rowsFiltered, nljrs.constructorTime, nljrs.openTime, nljrs.nextTime, nljrs.closeTime, nljrs.resultSetNumber, nljrs.rowsSeenLeft, nljrs.rowsSeenRight, nljrs.rowsReturned, nljrs.restrictionTime, nljrs.oneRowRightSide, nljrs.optimizerEstimatedRowCount, nljrs.optimizerEstimatedCost, nljrs.userSuppliedOptimizerOverrides, this.getResultSetStatistics(nljrs.leftResultSet), this.getResultSetStatistics(nljrs.rightResultSet));
        }
        if (rs instanceof IndexRowToBaseRowResultSet) {
            IndexRowToBaseRowResultSet irtbrrs = (IndexRowToBaseRowResultSet)rs;
            return new RealIndexRowToBaseRowStatistics(irtbrrs.numOpens, irtbrrs.rowsSeen, irtbrrs.rowsFiltered, irtbrrs.constructorTime, irtbrrs.openTime, irtbrrs.nextTime, irtbrrs.closeTime, irtbrrs.resultSetNumber, irtbrrs.indexName, irtbrrs.accessedHeapCols, irtbrrs.optimizerEstimatedRowCount, irtbrrs.optimizerEstimatedCost, this.getResultSetStatistics(irtbrrs.source));
        }
        if (rs instanceof RowResultSet) {
            RowResultSet rrs = (RowResultSet)rs;
            return new RealRowResultSetStatistics(rrs.numOpens, rrs.rowsSeen, rrs.rowsFiltered, rrs.constructorTime, rrs.openTime, rrs.nextTime, rrs.closeTime, rrs.resultSetNumber, rrs.rowsReturned, rrs.optimizerEstimatedRowCount, rrs.optimizerEstimatedCost);
        }
        if (rs instanceof SetOpResultSet) {
            SetOpResultSet srs = (SetOpResultSet)rs;
            return new RealSetOpResultSetStatistics(srs.getOpType(), srs.numOpens, srs.rowsSeen, srs.rowsFiltered, srs.constructorTime, srs.openTime, srs.nextTime, srs.closeTime, srs.getResultSetNumber(), srs.getRowsSeenLeft(), srs.getRowsSeenRight(), srs.getRowsReturned(), srs.optimizerEstimatedRowCount, srs.optimizerEstimatedCost, this.getResultSetStatistics(srs.getLeftSourceInput()), this.getResultSetStatistics(srs.getRightSourceInput()));
        }
        if (rs instanceof UnionResultSet) {
            UnionResultSet urs = (UnionResultSet)rs;
            return new RealUnionResultSetStatistics(urs.numOpens, urs.rowsSeen, urs.rowsFiltered, urs.constructorTime, urs.openTime, urs.nextTime, urs.closeTime, urs.resultSetNumber, urs.rowsSeenLeft, urs.rowsSeenRight, urs.rowsReturned, urs.optimizerEstimatedRowCount, urs.optimizerEstimatedCost, this.getResultSetStatistics(urs.source1), this.getResultSetStatistics(urs.source2));
        }
        if (rs instanceof AnyResultSet) {
            AnyResultSet ars = (AnyResultSet)rs;
            return new RealAnyResultSetStatistics(ars.numOpens, ars.rowsSeen, ars.rowsFiltered, ars.constructorTime, ars.openTime, ars.nextTime, ars.closeTime, ars.resultSetNumber, ars.subqueryNumber, ars.pointOfAttachment, ars.optimizerEstimatedRowCount, ars.optimizerEstimatedCost, this.getResultSetStatistics(ars.source));
        }
        if (rs instanceof OnceResultSet) {
            OnceResultSet ors = (OnceResultSet)rs;
            return new RealOnceResultSetStatistics(ors.numOpens, ors.rowsSeen, ors.rowsFiltered, ors.constructorTime, ors.openTime, ors.nextTime, ors.closeTime, ors.resultSetNumber, ors.subqueryNumber, ors.pointOfAttachment, ors.optimizerEstimatedRowCount, ors.optimizerEstimatedCost, this.getResultSetStatistics(ors.source));
        }
        if (rs instanceof NormalizeResultSet) {
            NormalizeResultSet nrs = (NormalizeResultSet)rs;
            return new RealNormalizeResultSetStatistics(nrs.numOpens, nrs.rowsSeen, nrs.rowsFiltered, nrs.constructorTime, nrs.openTime, nrs.nextTime, nrs.closeTime, nrs.resultSetNumber, nrs.optimizerEstimatedRowCount, nrs.optimizerEstimatedCost, this.getResultSetStatistics(nrs.source));
        }
        if (rs instanceof MaterializedResultSet) {
            MaterializedResultSet mrs = (MaterializedResultSet)rs;
            return new RealMaterializedResultSetStatistics(mrs.numOpens, mrs.rowsSeen, mrs.rowsFiltered, mrs.constructorTime, mrs.openTime, mrs.nextTime, mrs.closeTime, mrs.createTCTime, mrs.fetchTCTime, mrs.resultSetNumber, mrs.optimizerEstimatedRowCount, mrs.optimizerEstimatedCost, this.getResultSetStatistics(mrs.source));
        }
        if (rs instanceof ScrollInsensitiveResultSet) {
            ScrollInsensitiveResultSet sirs = (ScrollInsensitiveResultSet)rs;
            return new RealScrollInsensitiveResultSetStatistics(sirs.numOpens, sirs.rowsSeen, sirs.rowsFiltered, sirs.constructorTime, sirs.openTime, sirs.nextTime, sirs.closeTime, sirs.numFromHashTable, sirs.numToHashTable, sirs.resultSetNumber, sirs.optimizerEstimatedRowCount, sirs.optimizerEstimatedCost, this.getResultSetStatistics(sirs.source));
        }
        if (rs instanceof CurrentOfResultSet) {
            CurrentOfResultSet cors = (CurrentOfResultSet)rs;
            return new RealCurrentOfStatistics(cors.numOpens, cors.rowsSeen, cors.rowsFiltered, cors.constructorTime, cors.openTime, cors.nextTime, cors.closeTime, cors.resultSetNumber);
        }
        if (rs instanceof HashScanResultSet) {
            boolean instantaneousLocks = false;
            HashScanResultSet hsrs = (HashScanResultSet)rs;
            String startPosition = null;
            String stopPosition = null;
            String isolationLevel = null;
            String lockString = null;
            switch (hsrs.isolationLevel) {
                case 5: {
                    isolationLevel = MessageService.getTextMessage("42Z80.U");
                    break;
                }
                case 4: {
                    isolationLevel = MessageService.getTextMessage("42Z92");
                    break;
                }
                case 3: {
                    instantaneousLocks = true;
                }
                case 2: {
                    isolationLevel = MessageService.getTextMessage("42Z81.U");
                }
            }
            lockString = hsrs.forUpdate ? MessageService.getTextMessage("42Z82.U") : (instantaneousLocks ? MessageService.getTextMessage("42Z83.U") : MessageService.getTextMessage("42Z84.U"));
            switch (hsrs.lockMode) {
                case 7: {
                    lockString = lockString + " " + MessageService.getTextMessage("42Z85.U");
                    break;
                }
                case 6: {
                    lockString = lockString + " " + MessageService.getTextMessage("42Z86.U");
                }
            }
            if (hsrs.indexName != null) {
                startPosition = hsrs.startPositionString;
                if (startPosition == null) {
                    startPosition = hsrs.printStartPosition();
                }
                if ((stopPosition = hsrs.stopPositionString) == null) {
                    stopPosition = hsrs.printStopPosition();
                }
            }
            if (rs instanceof DistinctScanResultSet) {
                return new RealDistinctScanStatistics(hsrs.numOpens, hsrs.rowsSeen, hsrs.rowsFiltered, hsrs.constructorTime, hsrs.openTime, hsrs.nextTime, hsrs.closeTime, hsrs.resultSetNumber, hsrs.tableName, hsrs.indexName, hsrs.isConstraint, hsrs.hashtableSize, hsrs.keyColumns, HashScanResultSet.printQualifiers(hsrs.scanQualifiers), HashScanResultSet.printQualifiers(hsrs.nextQualifiers), hsrs.getScanProperties(), startPosition, stopPosition, isolationLevel, lockString, hsrs.optimizerEstimatedRowCount, hsrs.optimizerEstimatedCost);
            }
            return new RealHashScanStatistics(hsrs.numOpens, hsrs.rowsSeen, hsrs.rowsFiltered, hsrs.constructorTime, hsrs.openTime, hsrs.nextTime, hsrs.closeTime, hsrs.resultSetNumber, hsrs.tableName, hsrs.indexName, hsrs.isConstraint, hsrs.hashtableSize, hsrs.keyColumns, HashScanResultSet.printQualifiers(hsrs.scanQualifiers), HashScanResultSet.printQualifiers(hsrs.nextQualifiers), hsrs.getScanProperties(), startPosition, stopPosition, isolationLevel, lockString, hsrs.optimizerEstimatedRowCount, hsrs.optimizerEstimatedCost);
        }
        if (rs instanceof HashTableResultSet) {
            HashTableResultSet htrs = (HashTableResultSet)rs;
            int subqueryTrackingArrayLength = htrs.subqueryTrackingArray == null ? 0 : htrs.subqueryTrackingArray.length;
            ResultSetStatistics[] subqueryTrackingArray = new ResultSetStatistics[subqueryTrackingArrayLength];
            boolean anyAttached = false;
            for (int index = 0; index < subqueryTrackingArrayLength; ++index) {
                if (htrs.subqueryTrackingArray[index] == null || htrs.subqueryTrackingArray[index].getPointOfAttachment() != htrs.resultSetNumber) continue;
                subqueryTrackingArray[index] = this.getResultSetStatistics(htrs.subqueryTrackingArray[index]);
                anyAttached = true;
            }
            if (!anyAttached) {
                subqueryTrackingArray = null;
            }
            return new RealHashTableStatistics(htrs.numOpens, htrs.rowsSeen, htrs.rowsFiltered, htrs.constructorTime, htrs.openTime, htrs.nextTime, htrs.closeTime, htrs.resultSetNumber, htrs.hashtableSize, htrs.keyColumns, HashScanResultSet.printQualifiers(htrs.nextQualifiers), htrs.scanProperties, htrs.optimizerEstimatedRowCount, htrs.optimizerEstimatedCost, subqueryTrackingArray, this.getResultSetStatistics(htrs.source));
        }
        if (rs instanceof VTIResultSet) {
            VTIResultSet vtirs = (VTIResultSet)rs;
            return new RealVTIStatistics(vtirs.numOpens, vtirs.rowsSeen, vtirs.rowsFiltered, vtirs.constructorTime, vtirs.openTime, vtirs.nextTime, vtirs.closeTime, vtirs.resultSetNumber, vtirs.javaClassName, vtirs.optimizerEstimatedRowCount, vtirs.optimizerEstimatedCost);
        }
        if (rs instanceof DependentResultSet) {
            boolean instantaneousLocks = false;
            DependentResultSet dsrs = (DependentResultSet)rs;
            String startPosition = null;
            String stopPosition = null;
            String isolationLevel = null;
            String lockString = null;
            String lockRequestString = null;
            switch (dsrs.isolationLevel) {
                case 5: {
                    isolationLevel = MessageService.getTextMessage("42Z80.U");
                    break;
                }
                case 4: {
                    isolationLevel = MessageService.getTextMessage("42Z92");
                    break;
                }
                case 3: {
                    instantaneousLocks = true;
                }
                case 2: {
                    isolationLevel = MessageService.getTextMessage("42Z81.U");
                    break;
                }
                case 1: {
                    isolationLevel = MessageService.getTextMessage("42Z9A");
                }
            }
            lockString = dsrs.forUpdate ? MessageService.getTextMessage("42Z82.U") : (instantaneousLocks ? MessageService.getTextMessage("42Z83.U") : MessageService.getTextMessage("42Z84.U"));
            switch (dsrs.lockMode) {
                case 7: {
                    lockRequestString = lockString + " " + MessageService.getTextMessage("42Z85.U");
                    break;
                }
                case 6: {
                    lockRequestString = lockString + " " + MessageService.getTextMessage("42Z86.U");
                }
            }
            startPosition = dsrs.startPositionString;
            if (startPosition == null) {
                startPosition = dsrs.printStartPosition();
            }
            if ((stopPosition = dsrs.stopPositionString) == null) {
                stopPosition = dsrs.printStopPosition();
            }
            return new RealTableScanStatistics(dsrs.numOpens, dsrs.rowsSeen, dsrs.rowsFiltered, dsrs.constructorTime, dsrs.openTime, dsrs.nextTime, dsrs.closeTime, dsrs.resultSetNumber, dsrs.tableName, null, dsrs.indexName, dsrs.isConstraint, dsrs.printQualifiers(), dsrs.getScanProperties(), startPosition, stopPosition, isolationLevel, lockRequestString, dsrs.rowsPerRead, dsrs.coarserLock, dsrs.optimizerEstimatedRowCount, dsrs.optimizerEstimatedCost);
        }
        return null;
    }
}

