/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.execute.NoPutResultSetImpl;

class NormalizeResultSet
extends NoPutResultSetImpl
implements CursorResultSet {
    public NoPutResultSet source;
    private ExecRow normalizedRow;
    private int numCols;
    private int startCol;
    private ResultDescription resultDescription;
    private DataTypeDescriptor[] desiredTypes;

    public NormalizeResultSet(NoPutResultSet source, Activation activation, int resultSetNumber, int erdNumber, double optimizerEstimatedRowCount, double optimizerEstimatedCost, boolean forUpdate) throws StandardException {
        super(activation, resultSetNumber, optimizerEstimatedRowCount, optimizerEstimatedCost);
        this.source = source;
        if (!(activation.getPreparedStatement().getSavedObject(erdNumber) instanceof ResultDescription)) {
            SanityManager.THROWASSERT("activation.getPreparedStatement().getSavedObject(erdNumber) expected to be instanceof ResultDescription");
        }
        SanityManager.ASSERT(source != null, "NRS(), source expected to be non-null");
        this.resultDescription = (ResultDescription)activation.getPreparedStatement().getSavedObject(erdNumber);
        this.numCols = this.resultDescription.getColumnCount();
        this.startCol = forUpdate ? (this.numCols - 1) / 2 + 1 : 1;
        this.normalizedRow = activation.getExecutionFactory().getValueRow(this.numCols);
        this.constructorTime += this.getElapsedMillis(this.beginTime);
    }

    public void openCore() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        SanityManager.ASSERT(!this.isOpen, "NormalizeResultSet already open");
        SanityManager.ASSERT(this.source != null, "NRS().openCore(), source expected to be non-null");
        this.source.openCore();
        this.isOpen = true;
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    public void reopenCore() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        SanityManager.ASSERT(this.isOpen, "NormalizeResultSet already open");
        this.source.reopenCore();
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    public ExecRow getNextRowCore() throws StandardException {
        ExecRow sourceRow = null;
        ExecRow result = null;
        this.beginTime = this.getCurrentTimeMillis();
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S.0", "next");
        }
        sourceRow = this.source.getNextRowCore();
        if (sourceRow != null) {
            result = this.normalizeRow(sourceRow);
            ++this.rowsSeen;
        }
        this.currentRow = result;
        this.setCurrentRow(result);
        this.nextTime += this.getElapsedMillis(this.beginTime);
        return result;
    }

    public void close() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            this.currentRow = null;
            this.source.close();
            super.close();
        } else {
            SanityManager.DEBUG("CloseRepeatInfo", "Close of NormalizeResultSet repeated");
        }
        this.closeTime += this.getElapsedMillis(this.beginTime);
    }

    public long getTimeSpent(int type) {
        long totTime = this.constructorTime + this.openTime + this.nextTime + this.closeTime;
        if (type == 0) {
            return totTime - this.source.getTimeSpent(1);
        }
        return totTime;
    }

    public RowLocation getRowLocation() throws StandardException {
        SanityManager.ASSERT(this.source instanceof CursorResultSet, "source is not a cursorresultset");
        return ((CursorResultSet)((Object)this.source)).getRowLocation();
    }

    public ExecRow getCurrentRow() {
        return this.currentRow;
    }

    private ExecRow normalizeRow(ExecRow sourceRow) throws StandardException {
        int whichCol;
        if (this.desiredTypes == null) {
            this.desiredTypes = new DataTypeDescriptor[this.numCols];
            for (whichCol = 1; whichCol <= this.numCols; ++whichCol) {
                DataTypeDescriptor dtd;
                this.desiredTypes[whichCol - 1] = dtd = this.resultDescription.getColumnDescriptor(whichCol).getType();
            }
        }
        for (whichCol = 1; whichCol <= this.numCols; ++whichCol) {
            DataValueDescriptor normalizedCol;
            DataValueDescriptor sourceCol = sourceRow.getColumn(whichCol);
            if (sourceCol == null) continue;
            if (whichCol < this.startCol) {
                normalizedCol = sourceCol;
            } else {
                try {
                    normalizedCol = this.desiredTypes[whichCol - 1].normalize(sourceCol, this.normalizedRow.getColumn(whichCol));
                }
                catch (StandardException se) {
                    if (se.getMessageId().startsWith("23502")) {
                        ResultColumnDescriptor columnDescriptor = this.resultDescription.getColumnDescriptor(whichCol);
                        throw StandardException.newException("23502", columnDescriptor.getName());
                    }
                    throw se;
                }
            }
            this.normalizedRow.setColumn(whichCol, normalizedCol);
        }
        return this.normalizedRow;
    }

    public void updateRow(ExecRow row) throws StandardException {
        this.source.updateRow(row);
    }

    public void markRowAsDeleted() throws StandardException {
        this.source.markRowAsDeleted();
    }
}

