/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.sql.SQLWarning;
import java.sql.Timestamp;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.services.stream.HeaderPrintWriter;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.conn.StatementContext;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionContext;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.sql.execute.ResultSetStatisticsFactory;
import org.apache.derby.iapi.types.DataValueDescriptor;

abstract class NoRowsResultSetImpl
implements ResultSet {
    final Activation activation;
    private boolean dumpedStats;
    NoPutResultSet[] subqueryTrackingArray;
    private final boolean statisticsTimingOn;
    private boolean isOpen;
    protected String indent;
    protected String subIndent;
    protected int sourceDepth;
    final LanguageConnectionContext lcc;
    protected long beginTime;
    protected long endTime;
    protected long beginExecutionTime;
    protected long endExecutionTime;

    NoRowsResultSetImpl(Activation activation) throws StandardException {
        this.activation = activation;
        if (activation == null) {
            SanityManager.THROWASSERT("activation is null in result set " + this.getClass());
        }
        this.lcc = activation.getLanguageConnectionContext();
        this.statisticsTimingOn = this.lcc.getStatisticsTiming();
        this.beginExecutionTime = this.beginTime = this.getCurrentTimeMillis();
        StatementContext sc = this.lcc.getStatementContext();
        sc.setTopResultSet(this, null);
        if (this.subqueryTrackingArray == null) {
            this.subqueryTrackingArray = sc.getSubqueryTrackingArray();
        }
    }

    void setup() throws StandardException {
        this.isOpen = true;
    }

    public final boolean returnsRows() {
        return false;
    }

    public int modifiedRowCount() {
        return 0;
    }

    public ResultDescription getResultDescription() {
        return null;
    }

    public final Activation getActivation() {
        return this.activation;
    }

    public ExecRow getAbsoluteRow(int row) throws StandardException {
        throw StandardException.newException("XCL01.S", "absolute");
    }

    public ExecRow getRelativeRow(int row) throws StandardException {
        throw StandardException.newException("XCL01.S", "relative");
    }

    public ExecRow setBeforeFirstRow() throws StandardException {
        throw StandardException.newException("XCL01.S", "beforeFirst");
    }

    public ExecRow getFirstRow() throws StandardException {
        throw StandardException.newException("XCL01.S", "first");
    }

    public ExecRow getNextRow() throws StandardException {
        throw StandardException.newException("XCL01.S", "next");
    }

    public ExecRow getPreviousRow() throws StandardException {
        throw StandardException.newException("XCL01.S", "previous");
    }

    public ExecRow getLastRow() throws StandardException {
        throw StandardException.newException("XCL01.S", "last");
    }

    public ExecRow setAfterLastRow() throws StandardException {
        throw StandardException.newException("XCL01.S", "afterLast");
    }

    public final void clearCurrentRow() {
    }

    public boolean checkRowPosition(int isType) {
        return false;
    }

    public int getRowNumber() {
        return 0;
    }

    public void close() throws StandardException {
        this.isOpen = false;
    }

    public boolean isClosed() {
        return !this.isOpen;
    }

    public void finish() throws StandardException {
        if (!this.dumpedStats) {
            if (this.lcc.getRunTimeStatisticsMode() && !this.doesCommit()) {
                HeaderPrintWriter istream;
                this.endExecutionTime = this.getCurrentTimeMillis();
                ExecutionContext ec = this.lcc.getExecutionContext();
                ResultSetStatisticsFactory rssf = ec.getResultSetStatisticsFactory();
                this.lcc.setRunTimeStatisticsObject(rssf.getRunTimeStatistics(this.activation, this, this.subqueryTrackingArray));
                HeaderPrintWriter headerPrintWriter = istream = this.lcc.getLogQueryPlan() ? Monitor.getStream() : null;
                if (istream != null) {
                    istream.printlnWithHeader("(XID = " + this.lcc.getTransactionExecute().getTransactionIdString() + "), " + "(SESSIONID = " + this.lcc.getInstanceNumber() + "), " + this.lcc.getRunTimeStatisticsObject().getStatementText() + " ******* " + this.lcc.getRunTimeStatisticsObject().getStatementExecutionPlanText());
                }
            }
            this.dumpedStats = true;
        }
        int staLength = this.subqueryTrackingArray == null ? 0 : this.subqueryTrackingArray.length;
        for (int index = 0; index < staLength; ++index) {
            if (this.subqueryTrackingArray[index] == null || this.subqueryTrackingArray[index].isClosed()) continue;
            this.subqueryTrackingArray[index].close();
        }
    }

    public long getExecuteTime() {
        return this.endTime - this.beginTime;
    }

    public Timestamp getBeginExecutionTimestamp() {
        if (this.beginExecutionTime == 0L) {
            return null;
        }
        return new Timestamp(this.beginExecutionTime);
    }

    public Timestamp getEndExecutionTimestamp() {
        if (this.endExecutionTime == 0L) {
            return null;
        }
        return new Timestamp(this.endExecutionTime);
    }

    public String getQueryPlanText(int depth) {
        return MessageService.getTextMessage("42Z47.U", this.getClass().getName());
    }

    public long getTimeSpent(int type) {
        return 0L;
    }

    public final NoPutResultSet[] getSubqueryTrackingArray(int numSubqueries) {
        if (this.subqueryTrackingArray == null) {
            this.subqueryTrackingArray = new NoPutResultSet[numSubqueries];
        }
        return this.subqueryTrackingArray;
    }

    public ResultSet getAutoGeneratedKeysResultset() {
        return null;
    }

    public String getCursorName() {
        return null;
    }

    protected final long getCurrentTimeMillis() {
        if (this.statisticsTimingOn) {
            return System.currentTimeMillis();
        }
        return 0L;
    }

    public static void evaluateACheckConstraint(GeneratedMethod checkGM, String checkName, long heapConglom, Activation activation) throws StandardException {
        DataValueDescriptor checkBoolean;
        if (checkGM != null && (checkBoolean = (DataValueDescriptor)checkGM.invoke(activation)) != null && !checkBoolean.isNull() && !checkBoolean.getBoolean()) {
            DataDictionary dd = activation.getLanguageConnectionContext().getDataDictionary();
            ConglomerateDescriptor cd = dd.getConglomerateDescriptor(heapConglom);
            TableDescriptor td = dd.getTableDescriptor(cd.getTableID());
            StandardException se = StandardException.newException("23513", (Object)td.getQualifiedName(), (Object)checkName);
            throw se;
        }
    }

    public static void evaluateCheckConstraints(GeneratedMethod checkGM, Activation activation) throws StandardException {
        if (checkGM != null) {
            checkGM.invoke(activation);
        }
    }

    public boolean doesCommit() {
        return false;
    }

    public SQLWarning getWarnings() {
        return null;
    }
}

