/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.execute.ExecAggregator;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.sql.execute.OrderableAggregator;

public final class MaxMinAggregator
extends OrderableAggregator {
    private boolean isMax;

    public void setup(String aggregateName) {
        super.setup(aggregateName);
        this.isMax = aggregateName.equals("MAX");
    }

    protected void accumulate(DataValueDescriptor addend) throws StandardException {
        if (this.value == null || this.isMax && this.value.compare(addend) < 0 || !this.isMax && this.value.compare(addend) > 0) {
            this.value = addend.getClone();
        }
    }

    public ExecAggregator newAggregator() {
        MaxMinAggregator ma = new MaxMinAggregator();
        ma.isMax = this.isMax;
        return ma;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeBoolean(this.isMax);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.isMax = in.readBoolean();
    }

    public int getTypeFormatId() {
        return 152;
    }
}

