/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.execute.NoPutResultSetImpl;

abstract class JoinResultSet
extends NoPutResultSetImpl
implements CursorResultSet {
    public int rowsSeenLeft;
    public int rowsSeenRight;
    public int rowsReturned;
    public long restrictionTime;
    protected boolean isRightOpen;
    protected ExecRow leftRow;
    protected ExecRow rightRow;
    protected ExecRow mergedRow;
    public NoPutResultSet leftResultSet;
    protected int leftNumCols;
    public NoPutResultSet rightResultSet;
    protected int rightNumCols;
    protected GeneratedMethod restriction;
    public boolean oneRowRightSide;
    public boolean notExistsRightSide;
    String userSuppliedOptimizerOverrides;

    JoinResultSet(NoPutResultSet leftResultSet, int leftNumCols, NoPutResultSet rightResultSet, int rightNumCols, Activation activation, GeneratedMethod restriction, int resultSetNumber, boolean oneRowRightSide, boolean notExistsRightSide, double optimizerEstimatedRowCount, double optimizerEstimatedCost, String userSuppliedOptimizerOverrides) {
        super(activation, resultSetNumber, optimizerEstimatedRowCount, optimizerEstimatedCost);
        this.leftResultSet = leftResultSet;
        this.leftNumCols = leftNumCols;
        this.rightResultSet = rightResultSet;
        this.rightNumCols = rightNumCols;
        this.restriction = restriction;
        this.oneRowRightSide = oneRowRightSide;
        this.notExistsRightSide = notExistsRightSide;
        this.constructorTime += this.getElapsedMillis(this.beginTime);
        this.userSuppliedOptimizerOverrides = userSuppliedOptimizerOverrides;
    }

    void clearScanState() {
        this.leftRow = null;
        this.rightRow = null;
        this.mergedRow = null;
    }

    public void openCore() throws StandardException {
        this.clearScanState();
        this.beginTime = this.getCurrentTimeMillis();
        SanityManager.ASSERT(!this.isOpen, "JoinResultSet already open");
        this.isOpen = true;
        this.leftResultSet.openCore();
        this.leftRow = this.leftResultSet.getNextRowCore();
        if (this.leftRow != null) {
            this.openRight();
            ++this.rowsSeenLeft;
        }
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    public void reopenCore() throws StandardException {
        this.clearScanState();
        this.leftResultSet.reopenCore();
        this.leftRow = this.leftResultSet.getNextRowCore();
        if (this.leftRow != null) {
            this.openRight();
            ++this.rowsSeenLeft;
        } else if (this.isRightOpen) {
            this.closeRight();
        }
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    public void close() throws StandardException {
        this.clearScanState();
        if (this.isOpen) {
            this.leftResultSet.close();
            if (this.isRightOpen) {
                this.closeRight();
            }
            super.close();
        } else {
            SanityManager.DEBUG("CloseRepeatInfo", "Close of JoinResultSet repeated");
        }
    }

    public void finish() throws StandardException {
        this.leftResultSet.finish();
        this.rightResultSet.finish();
        super.finish();
    }

    public RowLocation getRowLocation() {
        SanityManager.THROWASSERT("Join used in positioned update/delete");
        return null;
    }

    public ExecRow getCurrentRow() {
        SanityManager.THROWASSERT("Join used in positioned update/delete");
        return null;
    }

    protected void openRight() throws StandardException {
        if (this.isRightOpen) {
            this.rightResultSet.reopenCore();
        } else {
            this.rightResultSet.openCore();
            this.isRightOpen = true;
        }
    }

    protected void closeRight() throws StandardException {
        SanityManager.ASSERT(this.isRightOpen, "isRightOpen is expected to be true");
        this.rightResultSet.close();
        this.isRightOpen = false;
    }
}

