/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.catalog.types.ReferencedColumnsDescriptorImpl;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.DynamicCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.GenericPreparedStatement;
import org.apache.derby.impl.sql.execute.NoPutResultSetImpl;
import org.apache.derby.impl.sql.execute.TableScanResultSet;
import org.apache.derby.impl.sql.execute.TemporaryRowHolderResultSet;

class IndexRowToBaseRowResultSet
extends NoPutResultSetImpl
implements CursorResultSet {
    private long conglomId;
    public NoPutResultSet source;
    private GeneratedMethod resultRowAllocator;
    private GeneratedMethod restriction;
    private long baseConglomId;
    public FormatableBitSet accessedHeapCols;
    private FormatableBitSet accessedAllCols;
    public String indexName;
    private int[] indexCols;
    private DynamicCompiledOpenConglomInfo dcoci;
    private StaticCompiledOpenConglomInfo scoci;
    private ConglomerateController baseCC;
    private boolean closeBaseCCHere;
    private ExecRow resultRow;
    private boolean forUpdate;
    private DataValueDescriptor[] rowArray;
    RowLocation baseRowLocation;
    boolean copiedFromSource;
    public long restrictionTime;
    protected boolean currentRowPrescanned;
    private boolean sourceIsForUpdateIndexScan;

    IndexRowToBaseRowResultSet(long conglomId, int scociItem, Activation a, NoPutResultSet source, GeneratedMethod resultRowAllocator, int resultSetNumber, String indexName, int heapColRefItem, int allColRefItem, int heapOnlyColRefItem, int indexColMapItem, GeneratedMethod restriction, boolean forUpdate, double optimizerEstimatedRowCount, double optimizerEstimatedCost) throws StandardException {
        super(a, resultSetNumber, optimizerEstimatedRowCount, optimizerEstimatedCost);
        GenericPreparedStatement gp = (GenericPreparedStatement)a.getPreparedStatement();
        Object[] saved = gp.getSavedObjects();
        this.scoci = (StaticCompiledOpenConglomInfo)saved[scociItem];
        TransactionController tc = this.activation.getTransactionController();
        this.dcoci = tc.getDynamicCompiledConglomInfo(conglomId);
        this.source = source;
        this.resultRowAllocator = resultRowAllocator;
        this.indexName = indexName;
        this.forUpdate = forUpdate;
        this.restriction = restriction;
        if (heapColRefItem != -1) {
            this.accessedHeapCols = (FormatableBitSet)saved[heapColRefItem];
        }
        if (allColRefItem != -1) {
            this.accessedAllCols = (FormatableBitSet)saved[allColRefItem];
        }
        this.indexCols = ((ReferencedColumnsDescriptorImpl)saved[indexColMapItem]).getReferencedColumnPositions();
        this.resultRow = (ExecRow)resultRowAllocator.invoke(this.activation);
        this.getCompactRow(this.resultRow, this.accessedAllCols, null, false);
        if (this.accessedHeapCols == null) {
            this.rowArray = this.resultRow.getRowArray();
        } else {
            DataValueDescriptor[] resultRowArray = this.resultRow.getRowArray();
            FormatableBitSet heapOnly = (FormatableBitSet)saved[heapOnlyColRefItem];
            int heapOnlyLen = heapOnly.getLength();
            this.rowArray = new DataValueDescriptor[heapOnlyLen];
            int minLen = Math.min(resultRowArray.length, heapOnlyLen);
            for (int i = 0; i < minLen; ++i) {
                if (resultRowArray[i] == null || !heapOnly.isSet(i)) continue;
                this.rowArray[i] = resultRowArray[i];
            }
        }
        this.constructorTime += this.getElapsedMillis(this.beginTime);
    }

    public void openCore() throws StandardException {
        boolean lockingRequired = false;
        SanityManager.ASSERT(!this.isOpen, "IndexRowToBaseRowResultSet already open");
        this.beginTime = this.getCurrentTimeMillis();
        this.source.openCore();
        if (this.source instanceof TableScanResultSet && ((TableScanResultSet)this.source).indexCols != null) {
            this.sourceIsForUpdateIndexScan = true;
        }
        if (this.source.requiresRelocking()) {
            lockingRequired = true;
        }
        TransactionController tc = this.activation.getTransactionController();
        int openMode = this.forUpdate ? 4 : 0;
        int isolationLevel = this.source.getScanIsolationLevel();
        if (!lockingRequired) {
            openMode |= 0x2000;
        }
        if (this.forUpdate) {
            this.baseCC = this.activation.getHeapConglomerateController();
        }
        if (this.baseCC == null) {
            this.baseCC = tc.openCompiledConglomerate(this.activation.getResultSetHoldability(), openMode, 6, isolationLevel, this.scoci, this.dcoci);
            this.closeBaseCCHere = true;
        }
        this.isOpen = true;
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    public void reopenCore() throws StandardException {
        SanityManager.ASSERT(this.isOpen, "IndexRowToBaseRowResultSet already open");
        this.beginTime = this.getCurrentTimeMillis();
        this.source.reopenCore();
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    public ExecRow getNextRowCore() throws StandardException {
        ExecRow sourceRow = null;
        ExecRow retval = null;
        boolean restrict = false;
        long beginRT = 0L;
        this.beginTime = this.getCurrentTimeMillis();
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S.0", "next");
        }
        if (this.sourceIsForUpdateIndexScan && ((TableScanResultSet)this.source).futureForUpdateRows != null) {
            this.currentRowPrescanned = false;
            TableScanResultSet src = (TableScanResultSet)this.source;
            if (src.futureRowResultSet == null) {
                src.futureRowResultSet = (TemporaryRowHolderResultSet)src.futureForUpdateRows.getResultSet();
                src.futureRowResultSet.openCore();
            }
            ExecRow ridRow = src.futureRowResultSet.getNextRowCore();
            this.currentRow = null;
            if (ridRow != null) {
                src.futureRowResultSet.deleteCurrentRow();
                this.baseRowLocation = (RowLocation)ridRow.getColumn(1);
                this.baseCC.fetch(this.baseRowLocation, this.compactRow.getRowArray(), this.accessedAllCols);
                this.currentRow = this.compactRow;
                this.currentRowPrescanned = true;
            } else if (src.sourceDrained) {
                this.currentRowPrescanned = true;
            }
            if (this.currentRowPrescanned) {
                this.setCurrentRow(this.currentRow);
                this.nextTime += this.getElapsedMillis(this.beginTime);
                return this.currentRow;
            }
        }
        do {
            if ((sourceRow = this.source.getNextRowCore()) != null) {
                SanityManager.ASSERT(sourceRow.getColumn(sourceRow.nColumns()) instanceof RowLocation, "Last column of source row is not a RowLocation");
                this.baseRowLocation = (RowLocation)sourceRow.getColumn(sourceRow.nColumns());
                boolean row_exists = this.baseCC.fetch(this.baseRowLocation, this.rowArray, this.accessedHeapCols);
                if (row_exists) {
                    if (!this.copiedFromSource) {
                        this.copiedFromSource = true;
                        for (int index = 0; index < this.indexCols.length; ++index) {
                            if (this.indexCols[index] == -1) continue;
                            this.compactRow.setColumn(index + 1, sourceRow.getColumn(this.indexCols[index] + 1));
                        }
                    }
                    this.setCurrentRow(this.compactRow);
                    DataValueDescriptor restrictBoolean = (DataValueDescriptor)(this.restriction == null ? null : this.restriction.invoke(this.activation));
                    this.restrictionTime += this.getElapsedMillis(beginRT);
                    boolean bl = restrict = restrictBoolean == null || !restrictBoolean.isNull() && restrictBoolean.getBoolean();
                }
                if (!restrict || !row_exists) {
                    ++this.rowsFiltered;
                    this.clearCurrentRow();
                    this.baseRowLocation = null;
                } else {
                    this.currentRow = this.compactRow;
                }
                ++this.rowsSeen;
                retval = this.currentRow;
                continue;
            }
            this.clearCurrentRow();
            this.baseRowLocation = null;
            retval = null;
        } while (sourceRow != null && !restrict);
        this.nextTime += this.getElapsedMillis(this.beginTime);
        return retval;
    }

    public void close() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            this.clearCurrentRow();
            if (this.closeBaseCCHere && this.baseCC != null) {
                this.baseCC.close();
            }
            this.baseCC = null;
            this.source.close();
            super.close();
        } else {
            SanityManager.DEBUG("CloseRepeatInfo", "Close of IndexRowToBaseRowResultSet repeated");
        }
        this.closeTime += this.getElapsedMillis(this.beginTime);
    }

    public long getTimeSpent(int type) {
        long totTime = this.constructorTime + this.openTime + this.nextTime + this.closeTime;
        if (type == 0) {
            return totTime - this.source.getTimeSpent(1);
        }
        return totTime;
    }

    public RowLocation getRowLocation() throws StandardException {
        return this.baseRowLocation;
    }

    public void positionScanAtRowLocation(RowLocation rl) throws StandardException {
        this.baseRowLocation = rl;
        this.source.positionScanAtRowLocation(rl);
    }

    public ExecRow getCurrentRow() throws StandardException {
        ExecRow sourceRow = null;
        SanityManager.ASSERT(this.isOpen, "IndexRowToBaseRowResultSet is expected to be open");
        if (this.currentRowPrescanned) {
            return this.currentRow;
        }
        if (this.currentRow == null) {
            return null;
        }
        sourceRow = this.activation.getExecutionFactory().getValueRow(this.indexCols.length);
        sourceRow.setRowArray(this.rowArray);
        boolean row_exists = this.baseCC.fetch(this.baseRowLocation, this.rowArray, null);
        if (row_exists) {
            this.setCurrentRow(sourceRow);
        } else {
            this.clearCurrentRow();
        }
        return this.currentRow;
    }

    public boolean isForUpdate() {
        return this.source.isForUpdate();
    }
}

