/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.impl.sql.execute.ValueRow;

public class IndexRow
extends ValueRow
implements ExecIndexRow {
    private boolean[] orderedNulls;

    public IndexRow() {
    }

    public IndexRow(int ncols) {
        super(ncols);
        this.orderedNulls = new boolean[ncols];
    }

    public void orderedNulls(int columnPosition) {
        this.orderedNulls[columnPosition] = true;
    }

    public boolean areNullsOrdered(int columnPosition) {
        return this.orderedNulls[columnPosition];
    }

    public void execRowToExecIndexRow(ExecRow valueRow) {
        SanityManager.THROWASSERT("execRowToExecIndexRow() not expected to be called for IndexRow");
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        int colCount = this.nColumns();
        this.orderedNulls = new boolean[colCount];
        for (int ictr = 0; ictr < colCount; ++ictr) {
            this.orderedNulls[ictr] = in.readBoolean();
        }
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        int colCount = this.nColumns();
        for (int ictr = 0; ictr < colCount; ++ictr) {
            out.writeBoolean(this.orderedNulls[ictr]);
        }
    }

    public int getTypeFormatId() {
        return 238;
    }

    ExecRow cloneMe() {
        return new IndexRow(this.nColumns());
    }
}

