/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.List;
import java.util.Properties;
import org.apache.derby.catalog.types.ReferencedColumnsDescriptorImpl;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableArrayHolder;
import org.apache.derby.iapi.services.io.FormatableIntHolder;
import org.apache.derby.iapi.services.io.Storable;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.StatementContext;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.store.access.BackingStoreHashtable;
import org.apache.derby.iapi.store.access.KeyHasher;
import org.apache.derby.iapi.store.access.Qualifier;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.execute.NoPutResultSetImpl;

class HashTableResultSet
extends NoPutResultSetImpl
implements CursorResultSet {
    public long restrictionTime;
    public long projectionTime;
    public int hashtableSize;
    public Properties scanProperties;
    public NoPutResultSet source;
    public GeneratedMethod singleTableRestriction;
    public Qualifier[][] nextQualifiers;
    private GeneratedMethod projection;
    private int[] projectMapping;
    private boolean runTimeStatsOn;
    private ExecRow mappedResultRow;
    public boolean reuseResult;
    public int[] keyColumns;
    private boolean removeDuplicates;
    private long maxInMemoryRowCount;
    private int initialCapacity;
    private float loadFactor;
    private boolean skipNullKeyColumns;
    private boolean firstNext = true;
    private int numFetchedOnNext;
    private int entryVectorSize;
    private List entryVector;
    private boolean hashTableBuilt;
    private boolean firstIntoHashtable = true;
    private ExecRow nextCandidate;
    private ExecRow projRow;
    private BackingStoreHashtable ht;

    HashTableResultSet(NoPutResultSet s, Activation a, GeneratedMethod str, Qualifier[][] nextQualifiers, GeneratedMethod p, int resultSetNumber, int mapRefItem, boolean reuseResult, int keyColItem, boolean removeDuplicates, long maxInMemoryRowCount, int initialCapacity, float loadFactor, boolean skipNullKeyColumns, double optimizerEstimatedRowCount, double optimizerEstimatedCost) throws StandardException {
        super(a, resultSetNumber, optimizerEstimatedRowCount, optimizerEstimatedCost);
        this.source = s;
        SanityManager.ASSERT(this.source != null, "HTRS(), source expected to be non-null");
        this.singleTableRestriction = str;
        this.nextQualifiers = nextQualifiers;
        this.projection = p;
        this.projectMapping = ((ReferencedColumnsDescriptorImpl)a.getPreparedStatement().getSavedObject(mapRefItem)).getReferencedColumnPositions();
        FormatableArrayHolder fah = (FormatableArrayHolder)a.getPreparedStatement().getSavedObject(keyColItem);
        FormatableIntHolder[] fihArray = (FormatableIntHolder[])fah.getArray(FormatableIntHolder.class);
        this.keyColumns = new int[fihArray.length];
        for (int index = 0; index < fihArray.length; ++index) {
            this.keyColumns[index] = fihArray[index].getInt();
        }
        this.reuseResult = reuseResult;
        this.removeDuplicates = removeDuplicates;
        this.maxInMemoryRowCount = maxInMemoryRowCount;
        this.initialCapacity = initialCapacity;
        this.loadFactor = loadFactor;
        this.skipNullKeyColumns = skipNullKeyColumns;
        if (this.projection == null) {
            this.mappedResultRow = this.activation.getExecutionFactory().getValueRow(this.projectMapping.length);
        }
        this.constructorTime += this.getElapsedMillis(this.beginTime);
        this.runTimeStatsOn = this.getLanguageConnectionContext().getRunTimeStatisticsMode();
    }

    public void openCore() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        SanityManager.ASSERT(this.source != null, "HTRS().openCore(), source expected to be non-null");
        SanityManager.ASSERT(!this.isOpen, "HashTableResultSet already open");
        TransactionController tc = this.activation.getTransactionController();
        if (!this.hashTableBuilt) {
            this.source.openCore();
            this.ht = new BackingStoreHashtable(tc, this, this.keyColumns, this.removeDuplicates, (int)this.optimizerEstimatedRowCount, this.maxInMemoryRowCount, this.initialCapacity, this.loadFactor, this.skipNullKeyColumns, false);
            if (this.runTimeStatsOn) {
                this.hashtableSize = this.ht.size();
                if (this.scanProperties == null) {
                    this.scanProperties = new Properties();
                }
                try {
                    if (this.ht != null) {
                        this.ht.getAllRuntimeStats(this.scanProperties);
                    }
                }
                catch (StandardException standardException) {
                    // empty catch block
                }
            }
            this.isOpen = true;
            this.hashTableBuilt = true;
        }
        this.resetProbeVariables();
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    public void reopenCore() throws StandardException {
        SanityManager.ASSERT(this.isOpen, "HashTableResultSet already open");
        this.beginTime = this.getCurrentTimeMillis();
        this.resetProbeVariables();
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    private void resetProbeVariables() throws StandardException {
        this.firstNext = true;
        this.numFetchedOnNext = 0;
        this.entryVector = null;
        this.entryVectorSize = 0;
        if (this.nextQualifiers != null) {
            this.clearOrderableCache(this.nextQualifiers);
        }
    }

    public ExecRow getNextRowCore() throws StandardException {
        ExecRow result = null;
        DataValueDescriptor[] columns = null;
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            do {
                if (this.firstNext) {
                    Object hashEntry;
                    this.firstNext = false;
                    if (this.keyColumns.length == 1) {
                        hashEntry = this.ht.get(this.nextQualifiers[0][0].getOrderable());
                    } else {
                        KeyHasher mh = new KeyHasher(this.keyColumns.length);
                        for (int index = 0; index < this.keyColumns.length; ++index) {
                            mh.setObject(index, this.nextQualifiers[0][index].getOrderable());
                        }
                        hashEntry = this.ht.get(mh);
                    }
                    if (hashEntry instanceof List) {
                        this.entryVector = (List)hashEntry;
                        this.entryVectorSize = this.entryVector.size();
                        columns = (DataValueDescriptor[])this.entryVector.get(0);
                    } else {
                        this.entryVector = null;
                        this.entryVectorSize = 0;
                        columns = (DataValueDescriptor[])hashEntry;
                    }
                } else if (this.numFetchedOnNext < this.entryVectorSize) {
                    columns = (DataValueDescriptor[])this.entryVector.get(this.numFetchedOnNext);
                }
                if (columns != null) {
                    int index;
                    for (int i = 0; i < columns.length; ++i) {
                        if (columns[0] instanceof Storable) continue;
                        SanityManager.THROWASSERT("columns[" + i + "] expected to be Storable, not " + columns[i].getClass().getName());
                    }
                    boolean qualifies = true;
                    SanityManager.ASSERT(this.nextQualifiers.length == 1);
                    for (index = 0; index < this.nextQualifiers[0].length; ++index) {
                        Qualifier q = this.nextQualifiers[0][index];
                        qualifies = columns[q.getColumnId()].compare(q.getOperator(), q.getOrderable(), q.getOrderedNulls(), q.getUnknownRV());
                        if (q.negateCompareResult()) {
                            boolean bl = qualifies = !qualifies;
                        }
                        if (!qualifies) break;
                    }
                    if (qualifies) {
                        for (index = 0; index < columns.length; ++index) {
                            this.nextCandidate.setColumn(index + 1, columns[index]);
                        }
                        result = this.doProjection(this.nextCandidate);
                    } else {
                        result = null;
                    }
                    ++this.numFetchedOnNext;
                    continue;
                }
                result = null;
            } while (result == null && this.numFetchedOnNext < this.entryVectorSize);
        }
        this.currentRow = result;
        this.setCurrentRow(result);
        this.nextTime += this.getElapsedMillis(this.beginTime);
        if (this.runTimeStatsOn) {
            if (!this.isTopResultSet) {
                StatementContext sc = this.activation.getLanguageConnectionContext().getStatementContext();
                this.subqueryTrackingArray = sc.getSubqueryTrackingArray();
            }
            this.nextTime += this.getElapsedMillis(this.beginTime);
        }
        return result;
    }

    public long getTimeSpent(int type) {
        long totTime = this.constructorTime + this.openTime + this.nextTime + this.closeTime;
        if (type == 0) {
            return totTime - this.source.getTimeSpent(1);
        }
        return totTime;
    }

    public void close() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            this.clearCurrentRow();
            this.source.close();
            super.close();
            if (this.hashTableBuilt) {
                this.ht.close();
                this.ht = null;
                this.hashTableBuilt = false;
            }
        } else {
            SanityManager.DEBUG("CloseRepeatInfo", "Close of ProjectRestrictResultSet repeated");
        }
        this.closeTime += this.getElapsedMillis(this.beginTime);
    }

    public RowLocation getRowLocation() throws StandardException {
        SanityManager.ASSERT(this.source instanceof CursorResultSet, "source not instance of CursorResultSet");
        return ((CursorResultSet)((Object)this.source)).getRowLocation();
    }

    public ExecRow getCurrentRow() throws StandardException {
        ExecRow candidateRow = null;
        ExecRow result = null;
        boolean restrict = false;
        SanityManager.ASSERT(this.isOpen, "PRRS is expected to be open");
        if (this.currentRow == null) {
            return null;
        }
        candidateRow = ((CursorResultSet)((Object)this.source)).getCurrentRow();
        if (candidateRow != null) {
            this.setCurrentRow(candidateRow);
            DataValueDescriptor restrictBoolean = (DataValueDescriptor)(this.singleTableRestriction == null ? null : this.singleTableRestriction.invoke(this.activation));
            boolean bl = restrict = restrictBoolean == null || !restrictBoolean.isNull() && restrictBoolean.getBoolean();
        }
        if (candidateRow != null && restrict) {
            result = this.doProjection(candidateRow);
        }
        this.currentRow = result;
        if (result == null) {
            this.clearCurrentRow();
        }
        return this.currentRow;
    }

    private ExecRow doProjection(ExecRow sourceRow) throws StandardException {
        if (this.reuseResult && this.projRow != null) {
            return this.projRow;
        }
        ExecRow result = this.projection != null ? (ExecRow)this.projection.invoke(this.activation) : this.mappedResultRow;
        for (int index = 0; index < this.projectMapping.length; ++index) {
            if (this.projectMapping[index] == -1) continue;
            result.setColumn(index + 1, sourceRow.getColumn(this.projectMapping[index]));
        }
        this.setCurrentRow(result);
        if (this.reuseResult) {
            this.projRow = result;
        }
        return result;
    }

    public DataValueDescriptor[] getNextRowFromRowSource() throws StandardException {
        ExecRow execRow = this.source.getNextRowCore();
        while (execRow != null) {
            boolean restrict = false;
            ++this.rowsSeen;
            DataValueDescriptor restrictBoolean = (DataValueDescriptor)(this.singleTableRestriction == null ? null : this.singleTableRestriction.invoke(this.activation));
            boolean bl = restrict = restrictBoolean == null || !restrictBoolean.isNull() && restrictBoolean.getBoolean();
            if (!restrict) {
                execRow = this.source.getNextRowCore();
                continue;
            }
            if (this.targetResultSet != null) {
                this.clonedExecRow = this.targetResultSet.preprocessSourceRow(execRow);
            }
            if (this.firstIntoHashtable) {
                this.nextCandidate = this.activation.getExecutionFactory().getValueRow(execRow.nColumns());
                this.firstIntoHashtable = false;
            }
            return execRow.getRowArray();
        }
        return null;
    }

    public boolean isForUpdate() {
        if (this.source == null) {
            return false;
        }
        return this.source.isForUpdate();
    }
}

