/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableArrayHolder;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.store.access.ColumnOrdering;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.SortController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.execute.AggregateSortObserver;
import org.apache.derby.impl.sql.execute.GenericAggregateResultSet;
import org.apache.derby.impl.sql.execute.GenericAggregator;

class GroupedAggregateResultSet
extends GenericAggregateResultSet
implements CursorResultSet {
    public int rowsInput;
    public int rowsReturned;
    private ColumnOrdering[] order;
    private ExecIndexRow sortTemplateRow;
    public boolean hasDistinctAggregate;
    public boolean isInSortedOrder;
    private int maxRowSize;
    private ScanController scanController;
    private ExecIndexRow sourceExecIndexRow;
    private ExecIndexRow sortResultRow;
    private ExecIndexRow currSortedRow;
    private boolean nextCalled;
    private long distinctAggSortId;
    private boolean dropDistinctAggSort;
    private long genericSortId;
    private boolean dropGenericSort;
    private TransactionController tc;
    public Properties sortProperties = new Properties();

    GroupedAggregateResultSet(NoPutResultSet s, boolean isInSortedOrder, int aggregateItem, int orderingItem, Activation a, GeneratedMethod ra, int maxRowSize, int resultSetNumber, double optimizerEstimatedRowCount, double optimizerEstimatedCost) throws StandardException {
        super(s, aggregateItem, a, ra, resultSetNumber, optimizerEstimatedRowCount, optimizerEstimatedCost);
        this.isInSortedOrder = isInSortedOrder;
        this.sortTemplateRow = this.getExecutionFactory().getIndexableRow((ExecRow)this.rowAllocator.invoke(this.activation));
        this.order = (ColumnOrdering[])((FormatableArrayHolder)a.getPreparedStatement().getSavedObject(orderingItem)).getArray(ColumnOrdering.class);
        SanityManager.DEBUG("AggregateTrace", "execution time: " + a.getPreparedStatement().getSavedObject(aggregateItem));
        this.constructorTime += this.getElapsedMillis(this.beginTime);
    }

    public void openCore() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        SanityManager.ASSERT(!this.isOpen, "GroupedAggregateResultSet already open");
        this.sortResultRow = this.getExecutionFactory().getIndexableRow(this.sortTemplateRow.getClone());
        this.sourceExecIndexRow = this.getExecutionFactory().getIndexableRow(this.sortTemplateRow.getClone());
        this.source.openCore();
        if (this.isInSortedOrder) {
            this.currSortedRow = this.getNextRowFromRS();
            if (this.currSortedRow != null) {
                this.currSortedRow = (ExecIndexRow)this.currSortedRow.getClone();
                this.initializeVectorAggregation(this.currSortedRow);
            }
        } else {
            this.scanController = this.loadSorter();
        }
        this.isOpen = true;
        ++this.numOpens;
        this.openTime += this.getElapsedMillis(this.beginTime);
    }

    private ScanController loadSorter() throws StandardException {
        ExecIndexRow inputRow;
        SortController sorter;
        long sortId;
        int inputRowCountEstimate = (int)this.optimizerEstimatedRowCount;
        boolean inOrder = this.isInSortedOrder;
        this.tc = this.getTransactionController();
        ColumnOrdering[] currentOrdering = this.order;
        if (this.aggInfoList.hasDistinct()) {
            ExecRow sourceRow;
            this.hasDistinctAggregate = true;
            GenericAggregator[] aggsNoDistinct = this.getSortAggregators(this.aggInfoList, true, this.activation.getLanguageConnectionContext(), this.source);
            AggregateSortObserver sortObserver = new AggregateSortObserver(true, aggsNoDistinct, this.aggregates, this.sortTemplateRow);
            sortId = this.tc.createSort(null, this.sortTemplateRow.getRowArray(), this.order, sortObserver, false, inputRowCountEstimate, this.maxRowSize);
            sorter = this.tc.openSort(sortId);
            this.distinctAggSortId = sortId;
            this.dropDistinctAggSort = true;
            while ((sourceRow = this.source.getNextRowCore()) != null) {
                sorter.insert(sourceRow.getRowArray());
                ++this.rowsInput;
            }
            this.source.close();
            this.sortProperties = sorter.getSortInfo().getAllSortInfo(this.sortProperties);
            sorter.completedInserts();
            this.scanController = this.tc.openSortScan(sortId, this.activation.getResultSetHoldability());
            inOrder = true;
            inputRowCountEstimate = this.rowsInput;
            if (this.order.length == 1) {
                return this.scanController;
            }
            ColumnOrdering[] newOrder = new ColumnOrdering[this.order.length - 1];
            System.arraycopy(this.order, 0, newOrder, 0, this.order.length - 1);
            currentOrdering = newOrder;
        }
        AggregateSortObserver sortObserver = new AggregateSortObserver(true, this.aggregates, this.aggregates, this.sortTemplateRow);
        sortId = this.tc.createSort(null, this.sortTemplateRow.getRowArray(), currentOrdering, sortObserver, inOrder, inputRowCountEstimate, this.maxRowSize);
        sorter = this.tc.openSort(sortId);
        this.genericSortId = sortId;
        this.dropGenericSort = true;
        while ((inputRow = this.getNextRowFromRS()) != null) {
            sorter.insert(inputRow.getRowArray());
        }
        this.source.close();
        this.sortProperties = sorter.getSortInfo().getAllSortInfo(this.sortProperties);
        sorter.completedInserts();
        return this.tc.openSortScan(sortId, this.activation.getResultSetHoldability());
    }

    public ExecRow getNextRowCore() throws StandardException {
        if (!this.isOpen) {
            return null;
        }
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isInSortedOrder) {
            if (this.currSortedRow == null) {
                this.nextTime += this.getElapsedMillis(this.beginTime);
                return null;
            }
            ExecIndexRow nextRow = this.getNextRowFromRS();
            while (nextRow != null) {
                if (!this.sameGroupingValues(this.currSortedRow, nextRow)) {
                    ExecIndexRow result = this.currSortedRow;
                    this.currSortedRow = (ExecIndexRow)nextRow.getClone();
                    this.initializeVectorAggregation(this.currSortedRow);
                    this.nextTime += this.getElapsedMillis(this.beginTime);
                    ++this.rowsReturned;
                    return this.finishAggregation(result);
                }
                this.initializeVectorAggregation(nextRow);
                this.mergeVectorAggregates(nextRow, this.currSortedRow);
                nextRow = this.getNextRowFromRS();
            }
            ExecIndexRow result = this.currSortedRow;
            this.currSortedRow = null;
            this.nextTime += this.getElapsedMillis(this.beginTime);
            return this.finishAggregation(result);
        }
        ExecIndexRow sortResult = null;
        sortResult = this.getNextRowFromRS();
        if (sortResult != null) {
            this.setCurrentRow(sortResult);
        }
        if (sortResult != null) {
            sortResult = this.finishAggregation(sortResult);
            this.currentRow = sortResult;
        }
        if (sortResult != null) {
            ++this.rowsReturned;
        }
        this.nextTime += this.getElapsedMillis(this.beginTime);
        return sortResult;
    }

    private boolean sameGroupingValues(ExecRow currRow, ExecRow newRow) throws StandardException {
        for (int index = 0; index < this.order.length; ++index) {
            DataValueDescriptor newOrderable;
            DataValueDescriptor currOrderable = currRow.getColumn(this.order[index].getColumnId() + 1);
            if (currOrderable.compare(2, newOrderable = newRow.getColumn(this.order[index].getColumnId() + 1), true, true)) continue;
            return false;
        }
        return true;
    }

    public void close() throws StandardException {
        this.beginTime = this.getCurrentTimeMillis();
        if (this.isOpen) {
            this.clearCurrentRow();
            this.sortResultRow = null;
            this.sourceExecIndexRow = null;
            this.closeSource();
            if (this.dropDistinctAggSort) {
                this.tc.dropSort(this.distinctAggSortId);
                this.dropDistinctAggSort = false;
            }
            if (this.dropGenericSort) {
                this.tc.dropSort(this.genericSortId);
                this.dropGenericSort = false;
            }
            super.close();
        } else {
            SanityManager.DEBUG("CloseRepeatInfo", "Close of SortResultSet repeated");
        }
        this.closeTime += this.getElapsedMillis(this.beginTime);
        this.isOpen = false;
    }

    public long getTimeSpent(int type) {
        long totTime = this.constructorTime + this.openTime + this.nextTime + this.closeTime;
        if (type == 0) {
            return totTime - this.originalSource.getTimeSpent(1);
        }
        return totTime;
    }

    public RowLocation getRowLocation() throws StandardException {
        if (!this.isOpen) {
            return null;
        }
        RowLocation rl = this.scanController.newRowLocationTemplate();
        this.scanController.fetchLocation(rl);
        return rl;
    }

    public ExecRow getCurrentRow() throws StandardException {
        SanityManager.ASSERT(this.isOpen, "SortResultSet expected to be open");
        return this.currentRow;
    }

    private ExecIndexRow getNextRowFromRS() throws StandardException {
        return this.scanController == null ? this.getRowFromResultSet() : this.getRowFromSorter();
    }

    private ExecIndexRow getRowFromResultSet() throws StandardException {
        ExecIndexRow inputRow = null;
        ExecRow sourceRow = this.source.getNextRowCore();
        if (sourceRow != null) {
            ++this.rowsInput;
            this.sourceExecIndexRow.execRowToExecIndexRow(sourceRow);
            inputRow = this.sourceExecIndexRow;
        }
        return inputRow;
    }

    private ExecIndexRow getRowFromSorter() throws StandardException {
        ExecIndexRow inputRow = null;
        if (this.scanController.next()) {
            this.currentRow = this.sortResultRow;
            inputRow = this.getExecutionFactory().getIndexableRow(this.currentRow);
            this.scanController.fetch(inputRow.getRowArray());
        }
        return inputRow;
    }

    public void closeSource() throws StandardException {
        if (this.scanController == null) {
            this.source.close();
        } else {
            this.scanController.close();
            this.scanController = null;
        }
    }

    private void initializeVectorAggregation(ExecRow row) throws StandardException {
        int size = this.aggregates.length;
        SanityManager.ASSERT(row != null, "Null row passed to initializeVectorAggregation");
        for (int i = 0; i < size; ++i) {
            GenericAggregator currAggregate = this.aggregates[i];
            currAggregate.initialize(row);
            currAggregate.accumulate(row, row);
        }
    }

    private void mergeVectorAggregates(ExecRow newRow, ExecRow currRow) throws StandardException {
        for (int i = 0; i < this.aggregates.length; ++i) {
            GenericAggregator currAggregate = this.aggregates[i];
            currAggregate.merge(newRow, currRow);
        }
    }
}

