/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.Properties;
import java.util.Vector;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.jdbc.ConnectionContext;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.loader.GeneratedMethod;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.ModuleSupportable;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.IndexRowGenerator;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionContext;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.sql.execute.ResultSetFactory;
import org.apache.derby.iapi.sql.execute.RowChanger;
import org.apache.derby.iapi.sql.execute.ScanQualifier;
import org.apache.derby.iapi.store.access.DynamicCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.Qualifier;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.GenericColumnDescriptor;
import org.apache.derby.impl.sql.GenericResultDescription;
import org.apache.derby.impl.sql.execute.GenericConstantActionFactory;
import org.apache.derby.impl.sql.execute.GenericExecutionContext;
import org.apache.derby.impl.sql.execute.GenericQualifier;
import org.apache.derby.impl.sql.execute.GenericResultSetFactory;
import org.apache.derby.impl.sql.execute.GenericScanQualifier;
import org.apache.derby.impl.sql.execute.IndexRow;
import org.apache.derby.impl.sql.execute.IndexValueRow;
import org.apache.derby.impl.sql.execute.InternalTriggerExecutionContext;
import org.apache.derby.impl.sql.execute.RowChangerImpl;
import org.apache.derby.impl.sql.execute.ValueRow;

public class GenericExecutionFactory
implements ModuleControl,
ModuleSupportable,
ExecutionFactory {
    private ResultSetFactory rsFactory;
    private GenericConstantActionFactory genericConstantActionFactory;

    public boolean canSupport(Properties startParams) {
        return Monitor.isDesiredType(startParams, 130);
    }

    public void boot(boolean create, Properties startParams) throws StandardException {
    }

    public void stop() {
    }

    public ResultSetFactory getResultSetFactory() {
        if (this.rsFactory == null) {
            this.rsFactory = new GenericResultSetFactory();
        }
        return this.rsFactory;
    }

    public GenericConstantActionFactory getConstantActionFactory() {
        if (this.genericConstantActionFactory == null) {
            this.genericConstantActionFactory = new GenericConstantActionFactory();
        }
        return this.genericConstantActionFactory;
    }

    public ExecutionContext newExecutionContext(ContextManager cm) {
        return new GenericExecutionContext(cm, this);
    }

    public ScanQualifier[][] getScanQualifier(int numQualifiers) {
        GenericScanQualifier[] sqArray = new GenericScanQualifier[numQualifiers];
        for (int ictr = 0; ictr < numQualifiers; ++ictr) {
            sqArray[ictr] = new GenericScanQualifier();
        }
        ScanQualifier[][] ret_sqArray = new ScanQualifier[][]{sqArray};
        return ret_sqArray;
    }

    public ResultDescription getResultDescription(ResultColumnDescriptor[] columns, String statementType) {
        return new GenericResultDescription(columns, statementType);
    }

    public ResultColumnDescriptor getResultColumnDescriptor(ResultColumnDescriptor compileRCD) {
        return new GenericColumnDescriptor(compileRCD);
    }

    public void releaseScanQualifier(ScanQualifier[][] qualifiers) {
    }

    public Qualifier getQualifier(int columnId, int operator, GeneratedMethod orderableGetter, Activation activation, boolean orderedNulls, boolean unknownRV, boolean negateCompareResult, int variantType) {
        return new GenericQualifier(columnId, operator, orderableGetter, activation, orderedNulls, unknownRV, negateCompareResult, variantType);
    }

    public RowChanger getRowChanger(long heapConglom, StaticCompiledOpenConglomInfo heapSCOCI, DynamicCompiledOpenConglomInfo heapDCOCI, IndexRowGenerator[] irgs, long[] indexCIDS, StaticCompiledOpenConglomInfo[] indexSCOCIs, DynamicCompiledOpenConglomInfo[] indexDCOCIs, int numberOfColumns, TransactionController tc, int[] changedColumnIds, int[] streamStorableHeapColIds, Activation activation) throws StandardException {
        return new RowChangerImpl(heapConglom, heapSCOCI, heapDCOCI, irgs, indexCIDS, indexSCOCIs, indexDCOCIs, numberOfColumns, changedColumnIds, tc, null, streamStorableHeapColIds, activation);
    }

    public RowChanger getRowChanger(long heapConglom, StaticCompiledOpenConglomInfo heapSCOCI, DynamicCompiledOpenConglomInfo heapDCOCI, IndexRowGenerator[] irgs, long[] indexCIDS, StaticCompiledOpenConglomInfo[] indexSCOCIs, DynamicCompiledOpenConglomInfo[] indexDCOCIs, int numberOfColumns, TransactionController tc, int[] changedColumnIds, FormatableBitSet baseRowReadList, int[] baseRowReadMap, int[] streamStorableColIds, Activation activation) throws StandardException {
        return new RowChangerImpl(heapConglom, heapSCOCI, heapDCOCI, irgs, indexCIDS, indexSCOCIs, indexDCOCIs, numberOfColumns, changedColumnIds, tc, baseRowReadList, baseRowReadMap, activation);
    }

    public InternalTriggerExecutionContext getTriggerExecutionContext(LanguageConnectionContext lcc, ConnectionContext cc, String statementText, int dmlType, int[] changedColIds, String[] changedColNames, UUID targetTableId, String targetTableName, Vector aiCounters) throws StandardException {
        return new InternalTriggerExecutionContext(lcc, cc, statementText, dmlType, changedColIds, changedColNames, targetTableId, targetTableName, aiCounters);
    }

    public ExecRow getValueRow(int numColumns) {
        return new ValueRow(numColumns);
    }

    public ExecIndexRow getIndexableRow(int numColumns) {
        return new IndexRow(numColumns);
    }

    public ExecIndexRow getIndexableRow(ExecRow valueRow) {
        if (valueRow instanceof ExecIndexRow) {
            return (ExecIndexRow)valueRow;
        }
        return new IndexValueRow(valueRow);
    }
}

