/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextImpl;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.sql.execute.ExecutionContext;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.sql.execute.ResultSetStatisticsFactory;

class GenericExecutionContext
extends ContextImpl
implements ExecutionContext {
    private ResultSetStatisticsFactory rssFactory;
    private ExecutionFactory execFactory;

    public ResultSetStatisticsFactory getResultSetStatisticsFactory() throws StandardException {
        if (this.rssFactory == null) {
            this.rssFactory = (ResultSetStatisticsFactory)Monitor.bootServiceModule(false, this.execFactory, "org.apache.derby.iapi.sql.execute.ResultSetStatisticsFactory", null);
        }
        return this.rssFactory;
    }

    public ExecutionFactory getExecutionFactory() {
        return this.execFactory;
    }

    public void cleanupOnError(Throwable error) throws StandardException {
        if (error instanceof StandardException) {
            StandardException se = (StandardException)error;
            int severity = se.getSeverity();
            if (severity >= 40000) {
                this.popMe();
                return;
            }
            if (severity > 20000) {
                return;
            }
            return;
        }
    }

    GenericExecutionContext(ContextManager cm, ExecutionFactory ef) {
        super(cm, "ExecutionContext");
        this.execFactory = ef;
    }
}

