/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.ViewDescriptor;
import org.apache.derby.impl.sql.execute.DDLConstantAction;

class DropViewConstantAction
extends DDLConstantAction {
    private String fullTableName;
    private String tableName;
    private SchemaDescriptor sd;

    DropViewConstantAction(String fullTableName, String tableName, SchemaDescriptor sd) {
        this.fullTableName = fullTableName;
        this.tableName = tableName;
        this.sd = sd;
        SanityManager.ASSERT(sd != null, "SchemaDescriptor is null");
    }

    public String toString() {
        return "DROP VIEW " + this.fullTableName;
    }

    public void executeConstantAction(Activation activation) throws StandardException {
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        dd.startWriting(lcc);
        TableDescriptor td = dd.getTableDescriptor(this.tableName, this.sd);
        if (td == null) {
            throw StandardException.newException("X0X05.S", this.fullTableName);
        }
        if (td.getTableType() != 2) {
            throw StandardException.newException("X0Y16.S", this.fullTableName);
        }
        ViewDescriptor vd = dd.getViewDescriptor(td);
        vd.drop(lcc, this.sd, td);
    }
}

