/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.Enumeration;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptorList;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.DefaultDescriptor;
import org.apache.derby.iapi.sql.dictionary.GenericDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ReferencedKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TriggerDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.execute.DDLSingleTableConstantAction;

class DropTableConstantAction
extends DDLSingleTableConstantAction {
    private final long conglomerateNumber;
    private final String fullTableName;
    private final String tableName;
    private final SchemaDescriptor sd;
    private final boolean cascade;

    DropTableConstantAction(String fullTableName, String tableName, SchemaDescriptor sd, long conglomerateNumber, UUID tableId, int behavior) {
        super(tableId);
        this.fullTableName = fullTableName;
        this.tableName = tableName;
        this.sd = sd;
        this.conglomerateNumber = conglomerateNumber;
        this.cascade = behavior == 0;
        SanityManager.ASSERT(sd != null, "SchemaDescriptor is null");
    }

    public String toString() {
        return "DROP TABLE " + this.fullTableName;
    }

    public void executeConstantAction(Activation activation) throws StandardException {
        TableDescriptor td;
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        DependencyManager dm = dd.getDependencyManager();
        TransactionController tc = lcc.getTransactionExecute();
        if (this.sd != null && this.sd.getSchemaName().equals("SESSION")) {
            td = lcc.getTableDescriptorForDeclaredGlobalTempTable(this.tableName);
            if (td == null) {
                td = dd.getTableDescriptor(this.tableName, this.sd);
            }
            if (td == null) {
                throw StandardException.newException("X0X05.S", this.fullTableName);
            }
            if (td.getTableType() == 3) {
                dm.invalidateFor(td, 1, lcc);
                tc.dropConglomerate(td.getHeapConglomerateId());
                lcc.dropDeclaredGlobalTempTable(this.tableName);
                return;
            }
        }
        if (this.conglomerateNumber != 0L) {
            this.lockTableForDDL(tc, this.conglomerateNumber, true);
        }
        dd.startWriting(lcc);
        td = dd.getTableDescriptor(this.tableId);
        if (td == null) {
            throw StandardException.newException("X0X05.S", this.fullTableName);
        }
        long heapId = td.getHeapConglomerateId();
        this.lockTableForDDL(tc, heapId, true);
        GenericDescriptorList tdl = dd.getTriggerDescriptors(td);
        Enumeration descs = tdl.elements();
        while (descs.hasMoreElements()) {
            TriggerDescriptor trd = (TriggerDescriptor)descs.nextElement();
            trd.drop(lcc);
        }
        ColumnDescriptorList cdl = td.getColumnDescriptorList();
        int cdlSize = cdl.size();
        for (int index = 0; index < cdlSize; ++index) {
            ColumnDescriptor cd = cdl.elementAt(index);
            if (cd.getDefaultInfo() == null) continue;
            DefaultDescriptor defaultDesc = cd.getDefaultDescriptor(dd);
            dm.clearDependencies(lcc, defaultDesc);
        }
        dd.dropAllColumnDescriptors(this.tableId, tc);
        dd.dropAllTableAndColPermDescriptors(this.tableId, tc);
        this.dropAllConstraintDescriptors(td, activation);
        ConglomerateDescriptor[] cds = td.getConglomerateDescriptors();
        long[] dropped = new long[cds.length - 1];
        int numDropped = 0;
        for (int index = 0; index < cds.length; ++index) {
            int i;
            ConglomerateDescriptor cd = cds[index];
            if (cd.getConglomerateNumber() == heapId) continue;
            long thisConglom = cd.getConglomerateNumber();
            for (i = 0; i < numDropped && dropped[i] != thisConglom; ++i) {
            }
            if (i != numDropped) continue;
            dropped[numDropped++] = thisConglom;
            tc.dropConglomerate(thisConglom);
            dd.dropStatisticsDescriptors(td.getUUID(), cd.getUUID(), tc);
        }
        dm.invalidateFor(td, 1, lcc);
        dd.dropTableDescriptor(td, this.sd, tc);
        dd.dropAllConglomerateDescriptors(td, tc);
        tc.dropConglomerate(heapId);
    }

    private void dropAllConstraintDescriptors(TableDescriptor td, Activation activation) throws StandardException {
        ConstraintDescriptor cd;
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        DependencyManager dm = dd.getDependencyManager();
        TransactionController tc = lcc.getTransactionExecute();
        ConstraintDescriptorList cdl = dd.getConstraintDescriptors(td);
        int index = 0;
        while (index < cdl.size()) {
            cd = cdl.elementAt(index);
            if (cd instanceof ReferencedKeyConstraintDescriptor) {
                ++index;
                continue;
            }
            dm.invalidateFor(cd, 19, lcc);
            cd.drop(lcc, true);
        }
        while (cdl.size() > 0) {
            cd = cdl.elementAt(0);
            if (!(cd instanceof ReferencedKeyConstraintDescriptor)) {
                SanityManager.THROWASSERT("Constraint descriptor not an instance of ReferencedKeyConstraintDescriptor as expected.  Is a " + cd.getClass().getName());
            }
            cd.drop(lcc, false);
            if (this.cascade) {
                ConstraintDescriptorList fkcdl = dd.getForeignKeys(cd.getUUID());
                for (int inner = 0; inner < fkcdl.size(); ++inner) {
                    ConstraintDescriptor fkcd = fkcdl.elementAt(inner);
                    dm.invalidateFor(fkcd, 19, lcc);
                    fkcd.drop(lcc, true);
                    activation.addWarning(StandardException.newWarning("01500", fkcd.getConstraintName(), fkcd.getTableDescriptor().getName()));
                }
            }
            dm.invalidateFor(cd, 19, lcc);
            dm.clearDependencies(lcc, cd);
        }
    }
}

