/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.execute.DDLConstantAction;

class DropStatisticsConstantAction
extends DDLConstantAction {
    private final String objectName;
    private final boolean forTable;
    private final SchemaDescriptor sd;
    private final String fullTableName;

    DropStatisticsConstantAction(SchemaDescriptor sd, String fullTableName, String objectName, boolean forTable) {
        this.objectName = objectName;
        this.sd = sd;
        this.forTable = forTable;
        this.fullTableName = fullTableName;
    }

    public void executeConstantAction(Activation activation) throws StandardException {
        TableDescriptor td;
        ConglomerateDescriptor cd = null;
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        DependencyManager dm = dd.getDependencyManager();
        TransactionController tc = lcc.getTransactionExecute();
        dd.startWriting(lcc);
        if (this.forTable) {
            td = dd.getTableDescriptor(this.objectName, this.sd);
        } else {
            cd = dd.getConglomerateDescriptor(this.objectName, this.sd, false);
            td = dd.getTableDescriptor(cd.getTableID());
        }
        dm.invalidateFor(td, 39, lcc);
        dd.dropStatisticsDescriptors(td.getUUID(), cd != null ? cd.getUUID() : null, tc);
    }

    public String toString() {
        return "DROP STATISTICS FOR " + (this.forTable ? "table " : "index ") + this.fullTableName;
    }
}

