/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.impl.sql.execute.DDLConstantAction;

class DropSchemaConstantAction
extends DDLConstantAction {
    private final String schemaName;

    DropSchemaConstantAction(String schemaName) {
        this.schemaName = schemaName;
    }

    public String toString() {
        return "DROP SCHEMA " + this.schemaName;
    }

    public void executeConstantAction(Activation activation) throws StandardException {
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        dd.startWriting(lcc);
        SchemaDescriptor sd = dd.getSchemaDescriptor(this.schemaName, null, true);
        sd.drop(lcc);
    }
}

