/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.sql.execute.TemporaryRowHolder;
import org.apache.derby.impl.sql.execute.DeleteResultSet;
import org.apache.derby.impl.sql.execute.FKInfo;
import org.apache.derby.impl.sql.execute.UpdateResultSet;

public class DeleteCascadeResultSet
extends DeleteResultSet {
    public ResultSet[] dependentResultSets;
    private int noDependents = 0;
    private CursorResultSet parentSource;
    private FKInfo parentFKInfo;
    private long fkIndexConglomNumber;
    private String resultSetId;
    private boolean mainNodeForTable = true;
    private boolean affectedRows = false;
    private int tempRowHolderId;

    public DeleteCascadeResultSet(NoPutResultSet source, Activation activation, int constantActionItem, ResultSet[] dependentResultSets, String resultSetId) throws StandardException {
        super(source, constantActionItem == -1 ? activation.getConstantAction() : (ConstantAction)activation.getPreparedStatement().getSavedObject(constantActionItem), activation);
        if (constantActionItem == -1) {
            ConstantAction passedInConstantAction = activation.getConstantAction();
        } else {
            ConstantAction passedInConstantAction = (ConstantAction)activation.getPreparedStatement().getSavedObject(constantActionItem);
            this.resultDescription = this.constants.resultDescription;
        }
        this.cascadeDelete = true;
        this.resultSetId = resultSetId;
        if (dependentResultSets != null) {
            this.noDependents = dependentResultSets.length;
            this.dependentResultSets = dependentResultSets;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws StandardException {
        try {
            this.setup();
            if (this.isMultipleDeletePathsExist()) {
                this.setRowHoldersTypeToUniqueStream();
                while (this.collectAffectedRows(false)) {
                }
            } else {
                this.collectAffectedRows(false);
            }
            if (!this.affectedRows) {
                this.activation.addWarning(StandardException.newWarning("02000"));
            }
            this.runFkChecker(true);
            Hashtable mntHashTable = new Hashtable();
            this.mergeRowHolders(mntHashTable);
            this.fireBeforeTriggers(mntHashTable);
            this.deleteDeferredRows();
            this.runFkChecker(false);
            this.rowChangerFinish();
            this.fireAfterTriggers();
        }
        finally {
            this.cleanUp();
            this.activation.clearParentResultSets();
        }
        this.endTime = this.getCurrentTimeMillis();
    }

    void setup() throws StandardException {
        if (this.lcc.getRunTimeStatisticsMode()) {
            this.savedSource = this.source;
        }
        super.setup();
        this.activation.setParentResultSet(this.rowHolder, this.resultSetId);
        Vector sVector = this.activation.getParentResultSet(this.resultSetId);
        this.tempRowHolderId = sVector.size() - 1;
        for (int i = 0; i < this.noDependents; ++i) {
            if (this.dependentResultSets[i] instanceof UpdateResultSet) {
                ((UpdateResultSet)this.dependentResultSets[i]).setup();
                continue;
            }
            ((DeleteCascadeResultSet)this.dependentResultSets[i]).setup();
        }
    }

    boolean collectAffectedRows(boolean rowsFound) throws StandardException {
        if (super.collectAffectedRows()) {
            this.affectedRows = true;
            rowsFound = true;
        }
        for (int i = 0; i < this.noDependents; ++i) {
            if (this.dependentResultSets[i] instanceof UpdateResultSet) {
                if (!((UpdateResultSet)this.dependentResultSets[i]).collectAffectedRows()) continue;
                rowsFound = true;
                continue;
            }
            if (!((DeleteCascadeResultSet)this.dependentResultSets[i]).collectAffectedRows(rowsFound)) continue;
            rowsFound = true;
        }
        return rowsFound;
    }

    void fireBeforeTriggers(Hashtable msht) throws StandardException {
        if (!this.mainNodeForTable && !msht.containsKey(this.resultSetId)) {
            this.mainNodeForTable = true;
            msht.put(this.resultSetId, this.resultSetId);
        }
        for (int i = 0; i < this.noDependents; ++i) {
            if (this.dependentResultSets[i] instanceof UpdateResultSet) {
                ((UpdateResultSet)this.dependentResultSets[i]).fireBeforeTriggers();
                continue;
            }
            ((DeleteCascadeResultSet)this.dependentResultSets[i]).fireBeforeTriggers(msht);
        }
        if (this.mainNodeForTable && this.constants.deferred) {
            super.fireBeforeTriggers();
        }
    }

    void fireAfterTriggers() throws StandardException {
        for (int i = 0; i < this.noDependents && this.affectedRows; ++i) {
            if (this.dependentResultSets[i] instanceof UpdateResultSet) {
                ((UpdateResultSet)this.dependentResultSets[i]).fireAfterTriggers();
                continue;
            }
            ((DeleteCascadeResultSet)this.dependentResultSets[i]).fireAfterTriggers();
        }
        if (this.mainNodeForTable && this.constants.deferred) {
            super.fireAfterTriggers();
        }
    }

    void deleteDeferredRows() throws StandardException {
        for (int i = 0; i < this.noDependents; ++i) {
            if (this.dependentResultSets[i] instanceof UpdateResultSet) {
                ((UpdateResultSet)this.dependentResultSets[i]).updateDeferredRows();
                continue;
            }
            ((DeleteCascadeResultSet)this.dependentResultSets[i]).deleteDeferredRows();
        }
        if (this.mainNodeForTable) {
            super.deleteDeferredRows();
        }
    }

    void runFkChecker(boolean restrictCheckOnly) throws StandardException {
        for (int i = 0; i < this.noDependents; ++i) {
            if (this.dependentResultSets[i] instanceof UpdateResultSet) {
                ((UpdateResultSet)this.dependentResultSets[i]).runChecker(restrictCheckOnly);
                continue;
            }
            ((DeleteCascadeResultSet)this.dependentResultSets[i]).runFkChecker(restrictCheckOnly);
        }
        if (this.mainNodeForTable) {
            super.runFkChecker(restrictCheckOnly);
        }
    }

    public void cleanUp() throws StandardException {
        super.cleanUp();
        for (int i = 0; i < this.noDependents; ++i) {
            if (this.dependentResultSets[i] instanceof UpdateResultSet) {
                ((UpdateResultSet)this.dependentResultSets[i]).cleanUp();
                continue;
            }
            ((DeleteCascadeResultSet)this.dependentResultSets[i]).cleanUp();
        }
        this.endTime = this.getCurrentTimeMillis();
    }

    private void rowChangerFinish() throws StandardException {
        this.rc.finish();
        for (int i = 0; i < this.noDependents; ++i) {
            if (this.dependentResultSets[i] instanceof UpdateResultSet) {
                ((UpdateResultSet)this.dependentResultSets[i]).rowChangerFinish();
                continue;
            }
            ((DeleteCascadeResultSet)this.dependentResultSets[i]).rowChangerFinish();
        }
    }

    private void mergeRowHolders(Hashtable msht) throws StandardException {
        if (msht.containsKey(this.resultSetId) || this.rowCount == 0) {
            this.mainNodeForTable = false;
        } else {
            this.mergeResultSets();
            this.mainNodeForTable = true;
            msht.put(this.resultSetId, this.resultSetId);
        }
        for (int i = 0; i < this.noDependents; ++i) {
            if (this.dependentResultSets[i] instanceof UpdateResultSet) {
                return;
            }
            ((DeleteCascadeResultSet)this.dependentResultSets[i]).mergeRowHolders(msht);
        }
    }

    private void mergeResultSets() throws StandardException {
        Vector sVector = this.activation.getParentResultSet(this.resultSetId);
        int size = sVector.size();
        if (size > 1) {
            ExecRow row = null;
            int rowHolderId = 0;
            while (rowHolderId < size) {
                if (rowHolderId == this.tempRowHolderId) {
                    ++rowHolderId;
                    continue;
                }
                TemporaryRowHolder currentRowHolder = (TemporaryRowHolder)sVector.elementAt(rowHolderId);
                CursorResultSet rs = currentRowHolder.getResultSet();
                rs.open();
                while ((row = rs.getNextRow()) != null) {
                    this.rowHolder.insert(row);
                }
                rs.close();
                ++rowHolderId;
            }
        }
    }

    public void finish() throws StandardException {
        super.finish();
        this.activation.clearParentResultSets();
    }

    private boolean isMultipleDeletePathsExist() {
        Hashtable parentResultSets = this.activation.getParentResultSets();
        Enumeration e = parentResultSets.keys();
        while (e.hasMoreElements()) {
            String rsId = (String)e.nextElement();
            Vector sVector = this.activation.getParentResultSet(rsId);
            int size = sVector.size();
            if (size <= 1) continue;
            return true;
        }
        return false;
    }

    private void setRowHoldersTypeToUniqueStream() {
        Hashtable parentResultSets = this.activation.getParentResultSets();
        Enumeration e = parentResultSets.keys();
        while (e.hasMoreElements()) {
            String rsId = (String)e.nextElement();
            Vector sVector = this.activation.getParentResultSet(rsId);
            int size = sVector.size();
            for (int rowHolderId = 0; rowHolderId < size; ++rowHolderId) {
                TemporaryRowHolder currentRowHolder = (TemporaryRowHolder)sVector.elementAt(rowHolderId);
                currentRowHolder.setRowHolderTypeToUniqueStream();
            }
        }
    }
}

