/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.Iterator;
import java.util.List;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.depend.Dependent;
import org.apache.derby.iapi.sql.dictionary.ColPermsDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.PermissionsDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.StatementColumnPermission;
import org.apache.derby.iapi.sql.dictionary.StatementPermission;
import org.apache.derby.iapi.sql.dictionary.StatementRoutinePermission;
import org.apache.derby.iapi.sql.dictionary.StatementSchemaPermission;
import org.apache.derby.iapi.sql.dictionary.StatementTablePermission;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.execute.CreateSchemaConstantAction;

abstract class DDLConstantAction
implements ConstantAction {
    DDLConstantAction() {
    }

    static SchemaDescriptor getAndCheckSchemaDescriptor(DataDictionary dd, UUID schemaId, String statementType) throws StandardException {
        SchemaDescriptor sd = dd.getSchemaDescriptor(schemaId, null);
        return sd;
    }

    static SchemaDescriptor getSchemaDescriptorForCreate(DataDictionary dd, Activation activation, String schemaName) throws StandardException {
        TransactionController tc = activation.getLanguageConnectionContext().getTransactionExecute();
        SchemaDescriptor sd = dd.getSchemaDescriptor(schemaName, tc, false);
        if (sd == null || sd.getUUID() == null) {
            block3: {
                CreateSchemaConstantAction csca = new CreateSchemaConstantAction(schemaName, null);
                try {
                    csca.executeConstantAction(activation);
                }
                catch (StandardException se) {
                    if (se.getMessageId().equals("X0Y68.S")) break block3;
                    throw se;
                }
            }
            sd = dd.getSchemaDescriptor(schemaName, tc, true);
        }
        return sd;
    }

    final void lockTableForDDL(TransactionController tc, long heapConglomerateNumber, boolean exclusiveMode) throws StandardException {
        ConglomerateController cc = tc.openConglomerate(heapConglomerateNumber, false, exclusiveMode ? 68 : 64, 7, 5);
        cc.close();
    }

    protected String constructToString(String statementType, String objectName) {
        return statementType + objectName;
    }

    protected void storeConstraintDependenciesOnPrivileges(Activation activation, Dependent dependent, UUID refTableUUID) throws StandardException {
        List requiredPermissionsList;
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        DependencyManager dm = dd.getDependencyManager();
        if (!lcc.getAuthorizationId().equals(dd.getAuthorizationDatabaseOwner()) && (requiredPermissionsList = activation.getPreparedStatement().getRequiredPermissionsList()) != null && !requiredPermissionsList.isEmpty()) {
            Iterator iter = requiredPermissionsList.iterator();
            while (iter.hasNext()) {
                StatementColumnPermission statementColumnPermission;
                StatementTablePermission statementTablePermission;
                StatementPermission statPerm = (StatementPermission)iter.next();
                if (!(statPerm instanceof StatementTablePermission) ? statPerm instanceof StatementSchemaPermission || statPerm instanceof StatementRoutinePermission : (statementTablePermission = (StatementTablePermission)statPerm).getPrivType() != 2 || !statementTablePermission.getTableUUID().equals(refTableUUID)) continue;
                PermissionsDescriptor permDesc = statPerm.getPermissionDescriptor(lcc.getAuthorizationId(), dd);
                if (permDesc == null) {
                    permDesc = statPerm.getPermissionDescriptor("PUBLIC", dd);
                    if (permDesc.checkOwner(lcc.getAuthorizationId())) break;
                    dm.addDependency(dependent, permDesc, lcc.getContextManager());
                    break;
                }
                if (permDesc.checkOwner(lcc.getAuthorizationId())) break;
                dm.addDependency(dependent, permDesc, lcc.getContextManager());
                if (!(permDesc instanceof ColPermsDescriptor) || (permDesc = (statementColumnPermission = (StatementColumnPermission)statPerm).getPUBLIClevelColPermsDescriptor(lcc.getAuthorizationId(), dd)) == null) break;
                dm.addDependency(dependent, permDesc, lcc.getContextManager());
                break;
            }
        }
    }

    protected void storeViewTriggerDependenciesOnPrivileges(Activation activation, Dependent dependent) throws StandardException {
        List requiredPermissionsList;
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        DependencyManager dm = dd.getDependencyManager();
        if (!lcc.getAuthorizationId().equals(dd.getAuthorizationDatabaseOwner()) && (requiredPermissionsList = activation.getPreparedStatement().getRequiredPermissionsList()) != null && !requiredPermissionsList.isEmpty()) {
            Iterator iter = requiredPermissionsList.iterator();
            while (iter.hasNext()) {
                StatementColumnPermission statementColumnPermission;
                StatementPermission statPerm = (StatementPermission)iter.next();
                if (statPerm instanceof StatementSchemaPermission) continue;
                PermissionsDescriptor permDesc = statPerm.getPermissionDescriptor(lcc.getAuthorizationId(), dd);
                if (permDesc == null) {
                    permDesc = statPerm.getPermissionDescriptor("PUBLIC", dd);
                    if (permDesc.checkOwner(lcc.getAuthorizationId())) continue;
                    dm.addDependency(dependent, permDesc, lcc.getContextManager());
                    continue;
                }
                if (permDesc.checkOwner(lcc.getAuthorizationId())) continue;
                dm.addDependency(dependent, permDesc, lcc.getContextManager());
                if (!(permDesc instanceof ColPermsDescriptor) || (permDesc = (statementColumnPermission = (StatementColumnPermission)statPerm).getPUBLIClevelColPermsDescriptor(lcc.getAuthorizationId(), dd)) == null) continue;
                dm.addDependency(dependent, permDesc, lcc.getContextManager());
            }
        }
    }
}

