/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.sql.Timestamp;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SPSDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TriggerDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.execute.DDLSingleTableConstantAction;

class CreateTriggerConstantAction
extends DDLSingleTableConstantAction {
    private String triggerName;
    private String triggerSchemaName;
    private TableDescriptor triggerTable;
    private UUID triggerTableId;
    private int eventMask;
    private boolean isBefore;
    private boolean isRow;
    private boolean isEnabled;
    private boolean referencingOld;
    private boolean referencingNew;
    private UUID whenSPSId;
    private String whenText;
    private UUID actionSPSId;
    private String actionText;
    private String originalActionText;
    private String oldReferencingName;
    private String newReferencingName;
    private UUID spsCompSchemaId;
    private Timestamp creationTimestamp;
    private int[] referencedCols;

    CreateTriggerConstantAction(String triggerSchemaName, String triggerName, int eventMask, boolean isBefore, boolean isRow, boolean isEnabled, TableDescriptor triggerTable, UUID whenSPSId, String whenText, UUID actionSPSId, String actionText, UUID spsCompSchemaId, Timestamp creationTimestamp, int[] referencedCols, String originalActionText, boolean referencingOld, boolean referencingNew, String oldReferencingName, String newReferencingName) {
        super(triggerTable.getUUID());
        this.triggerName = triggerName;
        this.triggerSchemaName = triggerSchemaName;
        this.triggerTable = triggerTable;
        this.eventMask = eventMask;
        this.isBefore = isBefore;
        this.isRow = isRow;
        this.isEnabled = isEnabled;
        this.whenSPSId = whenSPSId;
        this.whenText = whenText;
        this.actionSPSId = actionSPSId;
        this.actionText = actionText;
        this.spsCompSchemaId = spsCompSchemaId;
        this.creationTimestamp = creationTimestamp;
        this.referencedCols = referencedCols;
        this.originalActionText = originalActionText;
        this.referencingOld = referencingOld;
        this.referencingNew = referencingNew;
        this.oldReferencingName = oldReferencingName;
        this.newReferencingName = newReferencingName;
        SanityManager.ASSERT(triggerSchemaName != null, "triggerSchemaName sd is null");
        SanityManager.ASSERT(triggerName != null, "trigger name is null");
        SanityManager.ASSERT(triggerTable != null, "triggerTable is null");
        SanityManager.ASSERT(actionText != null, "actionText is null");
    }

    public void executeConstantAction(Activation activation) throws StandardException {
        String tabName;
        SPSDescriptor whenspsd = null;
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        DependencyManager dm = dd.getDependencyManager();
        TransactionController tc = lcc.getTransactionExecute();
        dd.startWriting(lcc);
        SchemaDescriptor triggerSd = CreateTriggerConstantAction.getSchemaDescriptorForCreate(dd, activation, this.triggerSchemaName);
        if (this.spsCompSchemaId == null) {
            SchemaDescriptor def = lcc.getDefaultSchema();
            if (def.getUUID() == null) {
                def = dd.getSchemaDescriptor(def.getDescriptorName(), tc, false);
            }
            if (def != null) {
                this.spsCompSchemaId = def.getUUID();
            }
        }
        if (this.triggerTable != null) {
            this.triggerTableId = this.triggerTable.getUUID();
            tabName = this.triggerTable.getName();
        } else {
            tabName = "with UUID " + this.triggerTableId;
        }
        this.triggerTable = dd.getTableDescriptor(this.triggerTableId);
        if (this.triggerTable == null) {
            throw StandardException.newException("X0X05.S", tabName);
        }
        this.lockTableForDDL(tc, this.triggerTable.getHeapConglomerateId(), true);
        this.triggerTable = dd.getTableDescriptor(this.triggerTableId);
        if (this.triggerTable == null) {
            throw StandardException.newException("X0X05.S", tabName);
        }
        dm.invalidateFor(this.triggerTable, 28, lcc);
        UUID tmpTriggerId = dd.getUUIDFactory().createUUID();
        this.actionSPSId = this.actionSPSId == null ? dd.getUUIDFactory().createUUID() : this.actionSPSId;
        DataDescriptorGenerator ddg = dd.getDataDescriptorGenerator();
        TriggerDescriptor triggerd = ddg.newTriggerDescriptor(triggerSd, tmpTriggerId, this.triggerName, this.eventMask, this.isBefore, this.isRow, this.isEnabled, this.triggerTable, whenspsd == null ? null : whenspsd.getUUID(), this.actionSPSId, this.creationTimestamp == null ? new Timestamp(System.currentTimeMillis()) : this.creationTimestamp, this.referencedCols, this.originalActionText, this.referencingOld, this.referencingNew, this.oldReferencingName, this.newReferencingName);
        dd.addDescriptor(triggerd, triggerSd, 13, false, tc);
        if (this.whenText != null) {
            whenspsd = this.createSPS(lcc, ddg, dd, tc, tmpTriggerId, triggerSd, this.whenSPSId, this.spsCompSchemaId, this.whenText, true, this.triggerTable);
        }
        SPSDescriptor actionspsd = this.createSPS(lcc, ddg, dd, tc, tmpTriggerId, triggerSd, this.actionSPSId, this.spsCompSchemaId, this.actionText, false, this.triggerTable);
        if (whenspsd != null) {
            dm.addDependency(triggerd, whenspsd, lcc.getContextManager());
        }
        dm.addDependency(triggerd, actionspsd, lcc.getContextManager());
        dm.addDependency(triggerd, this.triggerTable, lcc.getContextManager());
        dm.addDependency(actionspsd, this.triggerTable, lcc.getContextManager());
        this.storeViewTriggerDependenciesOnPrivileges(activation, triggerd);
    }

    private SPSDescriptor createSPS(LanguageConnectionContext lcc, DataDescriptorGenerator ddg, DataDictionary dd, TransactionController tc, UUID triggerId, SchemaDescriptor sd, UUID spsId, UUID compSchemaId, String text, boolean isWhen, TableDescriptor triggerTable) throws StandardException {
        if (text == null) {
            return null;
        }
        String spsName = "TRIGGER" + (isWhen ? "WHEN_" : "ACTN_") + triggerId + "_" + triggerTable.getUUID().toString();
        SPSDescriptor spsd = new SPSDescriptor(dd, spsName, spsId == null ? dd.getUUIDFactory().createUUID() : spsId, sd.getUUID(), compSchemaId == null ? lcc.getDefaultSchema().getUUID() : compSchemaId, 'T', true, text, true);
        spsd.prepareAndRelease(lcc, triggerTable);
        dd.addSPSDescriptor(spsd, tc, true);
        return spsd;
    }

    public String toString() {
        return this.constructToString("CREATE TRIGGER ", this.triggerName);
    }
}

