/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.Properties;
import org.apache.derby.catalog.UUID;
import org.apache.derby.catalog.types.StatisticsImpl;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.IndexRowGenerator;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.StatisticsDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.ColumnOrdering;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.GroupFetchScanController;
import org.apache.derby.iapi.store.access.RowLocationRetRowSource;
import org.apache.derby.iapi.store.access.RowSource;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.SortController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.execute.BasicSortObserver;
import org.apache.derby.impl.sql.execute.CardinalityCounter;
import org.apache.derby.impl.sql.execute.IndexColumnOrder;
import org.apache.derby.impl.sql.execute.IndexConstantAction;
import org.apache.derby.impl.sql.execute.RowUtil;
import org.apache.derby.impl.sql.execute.UniqueIndexSortObserver;

class CreateIndexConstantAction
extends IndexConstantAction {
    private boolean unique;
    private String indexType;
    private String[] columnNames;
    private boolean[] isAscending;
    private boolean isConstraint;
    private UUID conglomerateUUID;
    private Properties properties;
    private ExecRow indexTemplateRow;

    CreateIndexConstantAction(boolean unique, String indexType, String schemaName, String indexName, String tableName, UUID tableId, String[] columnNames, boolean[] isAscending, boolean isConstraint, UUID conglomerateUUID, Properties properties) {
        super(tableId, indexName, tableName, schemaName);
        this.unique = unique;
        this.indexType = indexType;
        this.columnNames = columnNames;
        this.isAscending = isAscending;
        this.isConstraint = isConstraint;
        this.conglomerateUUID = conglomerateUUID;
        this.properties = properties;
    }

    public String toString() {
        return "CREATE INDEX " + this.indexName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeConstantAction(Activation activation) throws StandardException {
        IndexRowGenerator indexRowGenerator = null;
        int maxBaseColumnPosition = -1;
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        DependencyManager dm = dd.getDependencyManager();
        TransactionController tc = lcc.getTransactionExecute();
        boolean forCreateTable = activation.getForCreateTable();
        dd.startWriting(lcc);
        SchemaDescriptor sd = dd.getSchemaDescriptor(this.schemaName, tc, true);
        TableDescriptor td = activation.getDDLTableDescriptor();
        if (td == null) {
            td = this.tableId != null ? dd.getTableDescriptor(this.tableId) : dd.getTableDescriptor(this.tableName, sd);
        }
        if (td == null) {
            throw StandardException.newException("X0Y38.S", (Object)this.indexName, (Object)this.tableName);
        }
        if (td.getTableType() == 1) {
            throw StandardException.newException("X0Y28.S", (Object)this.indexName, (Object)this.tableName);
        }
        this.lockTableForDDL(tc, td.getHeapConglomerateId(), false);
        if (!forCreateTable) {
            dm.invalidateFor(td, 3, lcc);
        }
        int[] baseColumnPositions = new int[this.columnNames.length];
        for (int i = 0; i < this.columnNames.length; ++i) {
            ClassFactory cf;
            ColumnDescriptor columnDescriptor = td.getColumnDescriptor(this.columnNames[i]);
            if (columnDescriptor == null) {
                throw StandardException.newException("42X14", (Object)this.columnNames[i], (Object)this.tableName);
            }
            TypeId typeId = columnDescriptor.getType().getTypeId();
            boolean isIndexable = typeId.orderable(cf = lcc.getLanguageConnectionFactory().getClassFactory());
            if (isIndexable && typeId.userType()) {
                String userClass = typeId.getCorrespondingJavaTypeName();
                try {
                    if (cf.isApplicationClass(cf.loadApplicationClass(userClass))) {
                        isIndexable = false;
                    }
                }
                catch (ClassNotFoundException cnfe) {
                    isIndexable = false;
                }
            }
            if (!isIndexable) {
                throw StandardException.newException("X0X67.S", typeId.getSQLTypeName());
            }
            baseColumnPositions[i] = columnDescriptor.getPosition();
            if (maxBaseColumnPosition >= baseColumnPositions[i]) continue;
            maxBaseColumnPosition = baseColumnPositions[i];
        }
        ConglomerateDescriptor[] congDescs = td.getConglomerateDescriptors();
        boolean duplicate = false;
        long conglomId = 0L;
        for (int i = 0; i < congDescs.length; ++i) {
            int j;
            ConglomerateDescriptor cd = congDescs[i];
            if (!cd.isIndex()) continue;
            IndexRowGenerator irg = cd.getIndexDescriptor();
            int[] bcps = irg.baseColumnPositions();
            boolean[] ia = irg.isAscending();
            if (bcps.length == baseColumnPositions.length && (irg.isUnique() || !this.unique) && this.indexType.equals(irg.indexType())) {
                for (j = 0; j < bcps.length && bcps[j] == baseColumnPositions[j] && ia[j] == this.isAscending[j]; ++j) {
                }
            }
            if (j != baseColumnPositions.length) continue;
            if (!this.isConstraint) {
                activation.addWarning(StandardException.newWarning("01504", cd.getConglomerateName()));
                return;
            }
            conglomId = cd.getConglomerateNumber();
            indexRowGenerator = cd.getIndexDescriptor();
            this.conglomerateUUID = dd.getUUIDFactory().createUUID();
            duplicate = true;
            break;
        }
        DataDescriptorGenerator ddg = dd.getDataDescriptorGenerator();
        if (duplicate) {
            ConglomerateDescriptor cgd = ddg.newConglomerateDescriptor(conglomId, this.indexName, true, indexRowGenerator, this.isConstraint, this.conglomerateUUID, td.getUUID(), sd.getUUID());
            dd.addDescriptor(cgd, sd, 0, false, tc);
            ConglomerateDescriptorList cdl = td.getConglomerateDescriptorList();
            cdl.add(cgd);
        }
        Properties indexProperties = this.properties != null ? this.properties : new Properties();
        indexProperties.put("baseConglomerateId", Long.toString(td.getHeapConglomerateId()));
        indexProperties.put("nUniqueColumns", Integer.toString(this.unique ? baseColumnPositions.length : baseColumnPositions.length + 1));
        indexProperties.put("rowLocationColumn", Integer.toString(baseColumnPositions.length));
        indexProperties.put("nKeyFields", Integer.toString(baseColumnPositions.length + 1));
        if (!duplicate) {
            indexRowGenerator = new IndexRowGenerator(this.indexType, this.unique, baseColumnPositions, this.isAscending, baseColumnPositions.length);
        }
        RowSource rowSource = null;
        long sortId = 0L;
        boolean needToDropSort = false;
        int bulkFetchSize = forCreateTable ? 1 : 16;
        int numColumns = td.getNumberOfColumns();
        int approximateRowSize = 0;
        FormatableBitSet bitSet = new FormatableBitSet(numColumns + 1);
        for (int index = 0; index < baseColumnPositions.length; ++index) {
            bitSet.set(baseColumnPositions[index]);
        }
        FormatableBitSet zeroBasedBitSet = RowUtil.shift(bitSet, 1);
        GroupFetchScanController scan = tc.openGroupFetchScan(td.getHeapConglomerateId(), false, 0, 7, 5, zeroBasedBitSet, null, 0, null, null, 0);
        ExecRow[] baseRows = new ExecRow[bulkFetchSize];
        ExecIndexRow[] indexRows = new ExecIndexRow[bulkFetchSize];
        ExecRow[] compactBaseRows = new ExecRow[bulkFetchSize];
        try {
            int numColumnOrderings;
            for (int i = 0; i < bulkFetchSize; ++i) {
                baseRows[i] = activation.getExecutionFactory().getValueRow(maxBaseColumnPosition);
                indexRows[i] = indexRowGenerator.getIndexRowTemplate();
                compactBaseRows[i] = activation.getExecutionFactory().getValueRow(baseColumnPositions.length);
            }
            this.indexTemplateRow = indexRows[0];
            ColumnDescriptorList cdl = td.getColumnDescriptorList();
            int cdlSize = cdl.size();
            int numSet = 0;
            for (int index = 0; index < cdlSize; ++index) {
                if (!zeroBasedBitSet.get(index)) continue;
                ++numSet;
                ColumnDescriptor cd = cdl.elementAt(index);
                DataTypeDescriptor dts = cd.getType();
                for (int i = 0; i < bulkFetchSize; ++i) {
                    baseRows[i].setColumn(index + 1, dts.getNull());
                    compactBaseRows[i].setColumn(numSet, baseRows[i].getColumn(index + 1));
                }
                approximateRowSize += dts.getTypeId().getApproximateLengthInBytes(dts);
            }
            RowLocation[] rl = new RowLocation[bulkFetchSize];
            for (int i = 0; i < bulkFetchSize; ++i) {
                rl[i] = scan.newRowLocationTemplate();
                indexRowGenerator.getIndexRow(compactBaseRows[i], rl[i], indexRows[i], bitSet);
            }
            if (duplicate) {
                return;
            }
            BasicSortObserver sortObserver = null;
            if (this.unique) {
                numColumnOrderings = baseColumnPositions.length;
                String indexOrConstraintName = this.indexName;
                if (this.conglomerateUUID != null) {
                    ConglomerateDescriptor cd = dd.getConglomerateDescriptor(this.conglomerateUUID);
                    if (this.isConstraint && cd != null && cd.getUUID() != null && td != null) {
                        ConstraintDescriptor conDesc = dd.getConstraintDescriptor(td, cd.getUUID());
                        indexOrConstraintName = conDesc.getConstraintName();
                    }
                }
                sortObserver = new UniqueIndexSortObserver(true, this.isConstraint, indexOrConstraintName, this.indexTemplateRow, true, td.getName());
            } else {
                numColumnOrderings = baseColumnPositions.length + 1;
                sortObserver = new BasicSortObserver(true, false, this.indexTemplateRow, true);
            }
            ColumnOrdering[] order = new ColumnOrdering[numColumnOrderings];
            for (int i = 0; i < numColumnOrderings; ++i) {
                order[i] = new IndexColumnOrder(i, this.unique || i < numColumnOrderings - 1 ? this.isAscending[i] : true);
            }
            sortId = tc.createSort(null, this.indexTemplateRow.getRowArrayClone(), order, sortObserver, false, scan.getEstimatedRowCount(), approximateRowSize);
            needToDropSort = true;
            rowSource = this.loadSorter(baseRows, indexRows, tc, scan, sortId, rl);
            conglomId = tc.createAndLoadConglomerate(this.indexType, this.indexTemplateRow.getRowArray(), order, indexRowGenerator.getColumnCollationIds(td.getColumnDescriptorList()), indexProperties, 0, (RowLocationRetRowSource)rowSource, null);
        }
        finally {
            if (scan != null) {
                scan.close();
            }
            if (rowSource != null) {
                rowSource.closeRowSource();
            }
            if (needToDropSort) {
                tc.dropSort(sortId);
            }
        }
        ConglomerateController indexController = tc.openConglomerate(conglomId, false, 0, 7, 5);
        if (!indexController.isKeyed()) {
            indexController.close();
            throw StandardException.newException("X0X85.S", (Object)this.indexName, (Object)this.indexType);
        }
        indexController.close();
        ConglomerateDescriptor cgd = ddg.newConglomerateDescriptor(conglomId, this.indexName, true, indexRowGenerator, this.isConstraint, this.conglomerateUUID, td.getUUID(), sd.getUUID());
        dd.addDescriptor(cgd, sd, 0, false, tc);
        ConglomerateDescriptorList cdl = td.getConglomerateDescriptorList();
        cdl.add(cgd);
        CardinalityCounter cCount = (CardinalityCounter)rowSource;
        long numRows = cCount.getRowCount();
        if (numRows > 0L) {
            long[] c = cCount.getCardinality();
            for (int i = 0; i < c.length; ++i) {
                StatisticsDescriptor statDesc = new StatisticsDescriptor(dd, dd.getUUIDFactory().createUUID(), cgd.getUUID(), td.getUUID(), "I", new StatisticsImpl(numRows, c[i]), i + 1);
                dd.addDescriptor(statDesc, null, 14, true, tc);
            }
        }
    }

    ExecRow getIndexTemplateRow() {
        return this.indexTemplateRow;
    }

    private void statementExceptionCleanup(ScanController scan, ConglomerateController indexController) throws StandardException {
        if (indexController != null) {
            indexController.close();
        }
        if (scan != null) {
            scan.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RowLocationRetRowSource loadSorter(ExecRow[] baseRows, ExecIndexRow[] indexRows, TransactionController tc, GroupFetchScanController scan, long sortId, RowLocation[] rl) throws StandardException {
        long rowCount = 0L;
        SortController sorter = tc.openSort(sortId);
        try {
            int bulkFetchSize = baseRows.length;
            SanityManager.ASSERT(bulkFetchSize == indexRows.length, "number of base rows and index rows does not match");
            SanityManager.ASSERT(bulkFetchSize == rl.length, "number of base rows and row locations does not match");
            DataValueDescriptor[][] baseRowArray = new DataValueDescriptor[bulkFetchSize][];
            for (int i = 0; i < bulkFetchSize; ++i) {
                baseRowArray[i] = baseRows[i].getRowArray();
            }
            int bulkFetched = 0;
            while ((bulkFetched = scan.fetchNextGroup(baseRowArray, rl)) > 0) {
                for (int i = 0; i < bulkFetched; ++i) {
                    sorter.insert(indexRows[i].getRowArray());
                    ++rowCount;
                }
            }
            scan.setEstimatedRowCount(rowCount);
        }
        finally {
            sorter.completedInserts();
        }
        return new CardinalityCounter(tc.openSortRowSource(sortId));
    }
}

