/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.sql.SQLWarning;
import java.sql.Timestamp;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.services.stream.HeaderPrintWriter;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.conn.StatementContext;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataValueDescriptor;

abstract class BasicNoPutResultSetImpl
implements NoPutResultSet {
    protected boolean isOpen;
    protected boolean finished;
    protected ExecRow currentRow;
    protected boolean isTopResultSet;
    protected LanguageConnectionContext lcc;
    private SQLWarning warnings;
    public int numOpens;
    public int rowsSeen;
    public int rowsFiltered;
    protected long startExecutionTime;
    protected long endExecutionTime;
    public long beginTime;
    public long constructorTime;
    public long openTime;
    public long nextTime;
    public long closeTime;
    public double optimizerEstimatedRowCount;
    public double optimizerEstimatedCost;
    private StatementContext statementContext;
    public NoPutResultSet[] subqueryTrackingArray;
    ExecRow compactRow;
    protected Activation activation;
    private boolean statisticsTimingOn;
    ResultDescription resultDescription;
    private transient ExecutionFactory exFactory;
    private transient TransactionController tc;
    private int[] baseColumnMap;

    BasicNoPutResultSetImpl(ResultDescription resultDescription, Activation activation, double optimizerEstimatedRowCount, double optimizerEstimatedCost) {
        this.activation = activation;
        this.statisticsTimingOn = activation != null && this.getLanguageConnectionContext().getStatisticsTiming();
        this.beginTime = this.startExecutionTime = this.getCurrentTimeMillis();
        this.resultDescription = resultDescription;
        this.optimizerEstimatedRowCount = optimizerEstimatedRowCount;
        this.optimizerEstimatedCost = optimizerEstimatedCost;
    }

    public final Activation getActivation() {
        return this.activation;
    }

    public abstract void openCore() throws StandardException;

    public void reopenCore() throws StandardException {
        this.close();
        this.openCore();
    }

    public abstract ExecRow getNextRowCore() throws StandardException;

    public int getPointOfAttachment() {
        SanityManager.THROWASSERT("getPointOfAttachment() not expected to be called for " + this.getClass().getName());
        return -1;
    }

    public void markAsTopResultSet() {
        this.isTopResultSet = true;
    }

    public int getScanIsolationLevel() {
        SanityManager.THROWASSERT("getScanIsolationLevel() not expected to be called for " + this.getClass().getName());
        return 0;
    }

    public double getEstimatedRowCount() {
        return this.optimizerEstimatedRowCount;
    }

    public boolean requiresRelocking() {
        SanityManager.THROWASSERT("requiresRelocking() not expected to be called for " + this.getClass().getName());
        return false;
    }

    public final void open() throws StandardException {
        if (!this.isTopResultSet) {
            SanityManager.THROWASSERT(this + "expected to be the top ResultSet");
        }
        this.finished = false;
        this.attachStatementContext();
        try {
            this.openCore();
        }
        catch (StandardException se) {
            this.activation.checkStatementValidity();
            throw se;
        }
        this.activation.checkStatementValidity();
    }

    public ExecRow getAbsoluteRow(int row) throws StandardException {
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S.0", "absolute");
        }
        this.attachStatementContext();
        if (!this.isTopResultSet) {
            SanityManager.THROWASSERT(this + "expected to be the top ResultSet");
        }
        SanityManager.THROWASSERT("getAbsoluteRow() not expected to be called for " + this.getClass().getName());
        return null;
    }

    public ExecRow getRelativeRow(int row) throws StandardException {
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S.0", "relative");
        }
        this.attachStatementContext();
        if (!this.isTopResultSet) {
            SanityManager.THROWASSERT(this + "expected to be the top ResultSet");
        }
        SanityManager.THROWASSERT("getRelativeRow() not expected to be called for " + this.getClass().getName());
        return null;
    }

    public ExecRow setBeforeFirstRow() throws StandardException {
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S.0", "first");
        }
        if (!this.isTopResultSet) {
            SanityManager.THROWASSERT(this + "expected to be the top ResultSet");
        }
        SanityManager.THROWASSERT("setBeforeFirstRow() not expected to be called for " + this.getClass().getName());
        return null;
    }

    public boolean checkRowPosition(int isType) throws StandardException {
        return false;
    }

    public int getRowNumber() {
        return 0;
    }

    public ExecRow getFirstRow() throws StandardException {
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S.0", "first");
        }
        this.attachStatementContext();
        if (!this.isTopResultSet) {
            SanityManager.THROWASSERT(this + "expected to be the top ResultSet");
        }
        SanityManager.THROWASSERT("getFirstRow() not expected to be called for " + this.getClass().getName());
        return null;
    }

    public final ExecRow getNextRow() throws StandardException {
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S.0", "next");
        }
        if (!this.isTopResultSet) {
            SanityManager.THROWASSERT(this + "expected to be the top ResultSet");
        }
        this.attachStatementContext();
        return this.getNextRowCore();
    }

    public ExecRow getPreviousRow() throws StandardException {
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S.0", "previous");
        }
        this.attachStatementContext();
        if (!this.isTopResultSet) {
            SanityManager.THROWASSERT(this + "expected to be the top ResultSet");
        }
        SanityManager.THROWASSERT("getPreviousRow() not expected to be called.");
        return null;
    }

    public ExecRow getLastRow() throws StandardException {
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S.0", "last");
        }
        this.attachStatementContext();
        if (!this.isTopResultSet) {
            SanityManager.THROWASSERT(this + "expected to be the top ResultSet");
        }
        SanityManager.THROWASSERT("getLastRow() not expected to be called.");
        return null;
    }

    public ExecRow setAfterLastRow() throws StandardException {
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S.0", "last");
        }
        if (!this.isTopResultSet) {
            SanityManager.THROWASSERT(this + "expected to be the top ResultSet");
        }
        SanityManager.THROWASSERT("setAfterLastRow() not expected to be called.");
        return null;
    }

    public boolean returnsRows() {
        return true;
    }

    public final int modifiedRowCount() {
        return 0;
    }

    public void cleanUp() throws StandardException {
        if (this.isOpen) {
            this.close();
        }
    }

    public boolean isClosed() {
        return !this.isOpen;
    }

    public void finish() throws StandardException {
        this.finishAndRTS();
    }

    protected final void finishAndRTS() throws StandardException {
        if (!this.finished) {
            LanguageConnectionContext lcc;
            if (this.isTopResultSet && (lcc = this.getLanguageConnectionContext()).getRunTimeStatisticsMode()) {
                HeaderPrintWriter istream;
                this.endExecutionTime = this.getCurrentTimeMillis();
                lcc.setRunTimeStatisticsObject(lcc.getExecutionContext().getResultSetStatisticsFactory().getRunTimeStatistics(this.activation, this, this.subqueryTrackingArray));
                HeaderPrintWriter headerPrintWriter = istream = lcc.getLogQueryPlan() ? Monitor.getStream() : null;
                if (istream != null) {
                    istream.printlnWithHeader("(XID = " + lcc.getTransactionExecute().getTransactionIdString() + "), " + "(SESSIONID = " + lcc.getInstanceNumber() + "), " + lcc.getRunTimeStatisticsObject().getStatementText() + " ******* " + lcc.getRunTimeStatisticsObject().getStatementExecutionPlanText());
                }
            }
            if (!this.isClosed()) {
                this.close();
            }
            this.finished = true;
            if (this.isTopResultSet && this.activation.isSingleExecution()) {
                this.activation.close();
            }
        }
    }

    public ResultDescription getResultDescription() {
        return this.resultDescription;
    }

    public long getExecuteTime() {
        return this.getTimeSpent(1);
    }

    public Timestamp getBeginExecutionTimestamp() {
        if (this.startExecutionTime == 0L) {
            return null;
        }
        return new Timestamp(this.startExecutionTime);
    }

    public Timestamp getEndExecutionTimestamp() {
        if (this.endExecutionTime == 0L) {
            return null;
        }
        return new Timestamp(this.endExecutionTime);
    }

    public final NoPutResultSet[] getSubqueryTrackingArray(int numSubqueries) {
        if (this.subqueryTrackingArray == null) {
            this.subqueryTrackingArray = new NoPutResultSet[numSubqueries];
        }
        return this.subqueryTrackingArray;
    }

    protected final long getCurrentTimeMillis() {
        if (this.statisticsTimingOn) {
            return System.currentTimeMillis();
        }
        return 0L;
    }

    public ResultSet getAutoGeneratedKeysResultset() {
        return null;
    }

    protected final long getElapsedMillis(long beginTime) {
        if (this.statisticsTimingOn) {
            return System.currentTimeMillis() - beginTime;
        }
        return 0L;
    }

    protected final String dumpTimeStats(String indent, String subIndent) {
        return indent + MessageService.getTextMessage("42Z30.U") + " " + this.getTimeSpent(0) + "\n" + indent + MessageService.getTextMessage("42Z31.U") + " " + this.getTimeSpent(1) + "\n" + indent + MessageService.getTextMessage("42Z32.U") + "\n" + subIndent + MessageService.getTextMessage("42Z33.U") + " " + this.constructorTime + "\n" + subIndent + MessageService.getTextMessage("42Z34.U") + " " + this.openTime + "\n" + subIndent + MessageService.getTextMessage("42Z35.U") + " " + this.nextTime + "\n" + subIndent + MessageService.getTextMessage("42Z36.U") + " " + this.closeTime;
    }

    protected void attachStatementContext() throws StandardException {
        if (this.isTopResultSet) {
            if (this.statementContext == null || !this.statementContext.onStack()) {
                this.statementContext = this.getLanguageConnectionContext().getStatementContext();
            }
            this.statementContext.setTopResultSet(this, this.subqueryTrackingArray);
            if (this.subqueryTrackingArray == null) {
                this.subqueryTrackingArray = this.statementContext.getSubqueryTrackingArray();
            }
        }
    }

    protected final LanguageConnectionContext getLanguageConnectionContext() {
        if (this.lcc == null) {
            this.lcc = this.activation != null ? this.activation.getLanguageConnectionContext() : (LanguageConnectionContext)ContextService.getContext("LanguageConnectionContext");
        }
        return this.lcc;
    }

    public int resultSetNumber() {
        SanityManager.THROWASSERT("resultSetNumber() should not be called on a " + this.getClass().getName());
        return 0;
    }

    final ExecutionFactory getExecutionFactory() {
        if (this.exFactory == null) {
            this.exFactory = this.activation.getExecutionFactory();
        }
        SanityManager.ASSERT(this.exFactory != null, "unable to get execution factory");
        return this.exFactory;
    }

    final TransactionController getTransactionController() {
        if (this.tc == null) {
            this.tc = this.getLanguageConnectionContext().getTransactionExecute();
        }
        return this.tc;
    }

    protected ExecRow getCompactRow(ExecRow candidate, FormatableBitSet accessedCols, FormatableBitSet otherCols, boolean isKeyed) throws StandardException {
        int numCandidateCols = candidate.nColumns();
        if (accessedCols == null) {
            this.compactRow = candidate;
            this.baseColumnMap = new int[numCandidateCols];
            for (int i = 0; i < this.baseColumnMap.length; ++i) {
                this.baseColumnMap[i] = i;
            }
        } else {
            FormatableBitSet allCols;
            if (otherCols == null) {
                allCols = accessedCols;
            } else {
                allCols = new FormatableBitSet(accessedCols);
                allCols.or(otherCols);
            }
            int numCols = allCols.getNumBitsSet();
            this.baseColumnMap = new int[numCols];
            if (this.compactRow == null) {
                ExecutionFactory ex = this.lcc.getLanguageConnectionFactory().getExecutionFactory();
                this.compactRow = isKeyed ? ex.getIndexableRow(numCols) : ex.getValueRow(numCols);
            }
            int position = 0;
            int i = allCols.anySetBit();
            while (i != -1 && i < numCandidateCols) {
                DataValueDescriptor sc = candidate.getColumn(i + 1);
                if (sc != null) {
                    this.compactRow.setColumn(position + 1, sc);
                }
                this.baseColumnMap[position] = i;
                ++position;
                i = allCols.anySetBit(i);
            }
        }
        return this.compactRow;
    }

    protected ExecRow setCompactRow(ExecRow candidateRow, ExecRow compactRow) {
        ExecRow retval;
        if (this.baseColumnMap == null) {
            retval = candidateRow;
        } else {
            retval = compactRow;
            this.setCompatRow(compactRow, candidateRow.getRowArray());
        }
        return retval;
    }

    protected final void setCompatRow(ExecRow compactRow, Object[] sourceRow) {
        DataValueDescriptor[] destRow = compactRow.getRowArray();
        int[] lbcm = this.baseColumnMap;
        for (int i = 0; i < lbcm.length; ++i) {
            destRow[i] = sourceRow[lbcm[i]];
        }
    }

    public boolean isForUpdate() {
        return false;
    }

    public void checkCancellationFlag() throws StandardException {
        StatementContext localStatementContext = this.getLanguageConnectionContext().getStatementContext();
        if (localStatementContext == null) {
            return;
        }
        if (localStatementContext.isCancelled()) {
            throw StandardException.newException("XCL52.S");
        }
    }

    protected final void addWarning(SQLWarning w) {
        ResultSet rs;
        if (this.isTopResultSet) {
            if (this.warnings == null) {
                this.warnings = w;
            } else {
                this.warnings.setNextWarning(w);
            }
            return;
        }
        if (this.activation != null && (rs = this.activation.getResultSet()) instanceof BasicNoPutResultSetImpl) {
            ((BasicNoPutResultSetImpl)rs).addWarning(w);
        }
    }

    public final SQLWarning getWarnings() {
        SQLWarning w = this.warnings;
        this.warnings = null;
        return w;
    }
}

