/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.Enumeration;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import org.apache.derby.catalog.DependableFinder;
import org.apache.derby.catalog.IndexDescriptor;
import org.apache.derby.catalog.UUID;
import org.apache.derby.catalog.types.ReferencedColumnsDescriptorImpl;
import org.apache.derby.catalog.types.StatisticsImpl;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.io.StreamStorable;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.PreparedStatement;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.dictionary.CheckConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptorList;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.DefaultDescriptor;
import org.apache.derby.iapi.sql.dictionary.DependencyDescriptor;
import org.apache.derby.iapi.sql.dictionary.GenericDescriptorList;
import org.apache.derby.iapi.sql.dictionary.IndexLister;
import org.apache.derby.iapi.sql.dictionary.IndexRowGenerator;
import org.apache.derby.iapi.sql.dictionary.ReferencedKeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.StatisticsDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TriggerDescriptor;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.execute.ExecIndexRow;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.ColumnOrdering;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.GroupFetchScanController;
import org.apache.derby.iapi.store.access.RowLocationRetRowSource;
import org.apache.derby.iapi.store.access.RowUtil;
import org.apache.derby.iapi.store.access.ScanController;
import org.apache.derby.iapi.store.access.SortController;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.impl.sql.catalog.DDColumnDependableFinder;
import org.apache.derby.impl.sql.execute.BasicSortObserver;
import org.apache.derby.impl.sql.execute.CardinalityCounter;
import org.apache.derby.impl.sql.execute.ColumnInfo;
import org.apache.derby.impl.sql.execute.ConstraintConstantAction;
import org.apache.derby.impl.sql.execute.CreateConstraintConstantAction;
import org.apache.derby.impl.sql.execute.DDLSingleTableConstantAction;
import org.apache.derby.impl.sql.execute.DropConstraintConstantAction;
import org.apache.derby.impl.sql.execute.IndexColumnOrder;

class AlterTableConstantAction
extends DDLSingleTableConstantAction
implements RowLocationRetRowSource {
    private SchemaDescriptor sd;
    private String tableName;
    private UUID schemaId;
    private int tableType;
    private ColumnInfo[] columnInfo;
    private ConstraintConstantAction[] constraintActions;
    private char lockGranularity;
    private long tableConglomerateId;
    private boolean compressTable;
    private int behavior;
    private boolean sequential;
    private boolean truncateTable;
    private boolean doneScan;
    private boolean[] needToDropSort;
    private boolean[] validRow;
    private int bulkFetchSize = 16;
    private int currentCompressRow;
    private int numIndexes;
    private int rowCount;
    private long estimatedRowCount;
    private long[] indexConglomerateNumbers;
    private long[] sortIds;
    private FormatableBitSet indexedCols;
    private ConglomerateController compressHeapCC;
    private ExecIndexRow[] indexRows;
    private ExecRow[] baseRow;
    private ExecRow currentRow;
    private GroupFetchScanController compressHeapGSC;
    private IndexRowGenerator[] compressIRGs;
    private DataValueDescriptor[][] baseRowArray;
    private RowLocation[] compressRL;
    private SortController[] sorters;
    private int droppedColumnPosition;
    private ColumnOrdering[][] ordering;
    private int[][] collation;
    private TableDescriptor td;
    private LanguageConnectionContext lcc;
    private DataDictionary dd;
    private DependencyManager dm;
    private TransactionController tc;
    private Activation activation;

    AlterTableConstantAction(SchemaDescriptor sd, String tableName, UUID tableId, long tableConglomerateId, int tableType, ColumnInfo[] columnInfo, ConstraintConstantAction[] constraintActions, char lockGranularity, boolean compressTable, int behavior, boolean sequential, boolean truncateTable) {
        super(tableId);
        this.sd = sd;
        this.tableName = tableName;
        this.tableConglomerateId = tableConglomerateId;
        this.tableType = tableType;
        this.columnInfo = columnInfo;
        this.constraintActions = constraintActions;
        this.lockGranularity = lockGranularity;
        this.compressTable = compressTable;
        this.behavior = behavior;
        this.sequential = sequential;
        this.truncateTable = truncateTable;
        SanityManager.ASSERT(sd != null, "schema descriptor is null");
    }

    public String toString() {
        if (this.truncateTable) {
            return "TRUNCATE TABLE " + this.tableName;
        }
        return "ALTER TABLE " + this.tableName;
    }

    public void executeConstantAction(Activation activation) throws StandardException {
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        DependencyManager dm = dd.getDependencyManager();
        TransactionController tc = lcc.getTransactionExecute();
        int numRows = 0;
        boolean tableScanned = false;
        dd.startWriting(lcc);
        if (this.tableConglomerateId == 0L) {
            this.td = dd.getTableDescriptor(this.tableId);
            if (this.td == null) {
                throw StandardException.newException("X0X05.S", this.tableName);
            }
            this.tableConglomerateId = this.td.getHeapConglomerateId();
        }
        this.lockTableForDDL(tc, this.tableConglomerateId, true);
        this.td = dd.getTableDescriptor(this.tableId);
        if (this.td == null) {
            throw StandardException.newException("X0X05.S", this.tableName);
        }
        if (this.truncateTable) {
            dm.invalidateFor(this.td, 42, lcc);
        } else {
            dm.invalidateFor(this.td, 12, lcc);
        }
        activation.setDDLTableDescriptor(this.td);
        if (this.sd == null) {
            this.sd = AlterTableConstantAction.getAndCheckSchemaDescriptor(dd, this.schemaId, "ALTER TABLE");
        }
        if (this.truncateTable) {
            dm.invalidateFor(this.td, 42, lcc);
        } else {
            dm.invalidateFor(this.td, 12, lcc);
        }
        if (this.columnInfo != null) {
            int ix;
            boolean tableNeedsScanning = false;
            for (ix = 0; ix < this.columnInfo.length; ++ix) {
                if (this.columnInfo[ix].action != 0 || this.columnInfo[ix].dataType.isNullable() || this.columnInfo[ix].defaultInfo != null || this.columnInfo[ix].autoincInc != 0L) continue;
                tableNeedsScanning = true;
            }
            if (tableNeedsScanning) {
                numRows = this.getSemiRowCount(tc);
                if (numRows > 0) {
                    throw StandardException.newException("X0Y57.S", this.td.getQualifiedName());
                }
                tableScanned = true;
            }
            for (ix = 0; ix < this.columnInfo.length; ++ix) {
                ColumnDescriptorList cdl = new ColumnDescriptorList();
                if (this.columnInfo[ix].action == 0) {
                    this.addNewColumnToTable(activation, lcc, dd, tc, ix);
                    continue;
                }
                if (this.columnInfo[ix].action == 5 || this.columnInfo[ix].action == 6 || this.columnInfo[ix].action == 7) {
                    this.modifyColumnDefault(activation, ix);
                    continue;
                }
                if (this.columnInfo[ix].action == 2) {
                    this.modifyColumnType(activation, ix);
                    continue;
                }
                if (this.columnInfo[ix].action == 3) {
                    this.modifyColumnConstraint(activation, this.columnInfo[ix].name, true);
                    continue;
                }
                if (this.columnInfo[ix].action == 4) {
                    boolean[] nullCols;
                    String[] colNames;
                    if (!tableScanned) {
                        tableScanned = true;
                        numRows = this.getSemiRowCount(tc);
                    }
                    if (!this.validateNotNullConstraint(colNames = new String[]{this.columnInfo[ix].name}, nullCols = new boolean[1], numRows, lcc, "X0Y80.S")) continue;
                    this.modifyColumnConstraint(activation, this.columnInfo[ix].name, false);
                    continue;
                }
                if (this.columnInfo[ix].action == 1) {
                    this.dropColumnFromTable(activation, ix);
                    continue;
                }
                SanityManager.THROWASSERT("Unexpected action in AlterTableConstantAction");
            }
        }
        if (this.constraintActions != null) {
            for (int conIndex = 0; conIndex < this.constraintActions.length; ++conIndex) {
                ConstraintConstantAction cca = this.constraintActions[conIndex];
                if (cca instanceof CreateConstraintConstantAction) {
                    int constraintType = cca.getConstraintType();
                    switch (constraintType) {
                        case 2: {
                            ConstraintDescriptorList cdl = dd.getConstraintDescriptors(this.td);
                            if (cdl.getPrimaryKey() != null) {
                                throw StandardException.newException("X0Y58.S", this.td.getQualifiedName());
                            }
                            if (tableScanned) break;
                            tableScanned = true;
                            numRows = this.getSemiRowCount(tc);
                            break;
                        }
                        case 4: {
                            if (!tableScanned) {
                                tableScanned = true;
                                numRows = this.getSemiRowCount(tc);
                            }
                            if (numRows <= 0) break;
                            ConstraintConstantAction.validateConstraint(cca.getConstraintName(), ((CreateConstraintConstantAction)cca).getConstraintText(), this.td, lcc, true);
                        }
                    }
                } else if (!(cca instanceof DropConstraintConstantAction)) {
                    SanityManager.THROWASSERT("constraintActions[" + conIndex + "] expected to be instanceof " + "DropConstraintConstantAction not " + cca.getClass().getName());
                }
                this.constraintActions[conIndex].executeConstantAction(activation);
            }
        }
        if (this.lockGranularity != '\u0000') {
            if (this.lockGranularity != 'T' && this.lockGranularity != 'R') {
                SanityManager.THROWASSERT("lockGranularity expected to be 'T'or 'R', not " + this.lockGranularity);
            }
            this.td.setLockGranularity(this.lockGranularity);
            dd.updateLockGranularity(this.td, this.sd, this.lockGranularity, tc);
        }
        if (this.compressTable) {
            this.compressTable(activation);
        }
        if (this.truncateTable) {
            this.truncateTable(activation);
        }
    }

    private void addNewColumnToTable(Activation activation, LanguageConnectionContext lcc, DataDictionary dd, TransactionController tc, int ix) throws StandardException {
        ColumnDescriptor columnDescriptor = this.td.getColumnDescriptor(this.columnInfo[ix].name);
        int colNumber = this.td.getMaxColumnID() + ix;
        DataDescriptorGenerator ddg = dd.getDataDescriptorGenerator();
        if (columnDescriptor != null) {
            throw StandardException.newException("X0Y32.S", columnDescriptor.getDescriptorType(), (Object)this.columnInfo[ix].name, (Object)this.td.getDescriptorType(), (Object)this.td.getQualifiedName());
        }
        DataValueDescriptor storableDV = this.columnInfo[ix].defaultValue != null ? this.columnInfo[ix].defaultValue : this.columnInfo[ix].dataType.getNull();
        tc.addColumnToConglomerate(this.td.getHeapConglomerateId(), colNumber, storableDV, this.columnInfo[ix].dataType.getCollationType());
        UUID defaultUUID = this.columnInfo[ix].newDefaultUUID;
        if (this.columnInfo[ix].defaultInfo != null && defaultUUID == null) {
            defaultUUID = dd.getUUIDFactory().createUUID();
        }
        columnDescriptor = new ColumnDescriptor(this.columnInfo[ix].name, colNumber + 1, this.columnInfo[ix].dataType, this.columnInfo[ix].defaultValue, this.columnInfo[ix].defaultInfo, this.td, defaultUUID, this.columnInfo[ix].autoincStart, this.columnInfo[ix].autoincInc);
        dd.addDescriptor(columnDescriptor, this.td, 2, false, tc);
        this.td.getColumnDescriptorList().add(columnDescriptor);
        if (columnDescriptor.isAutoincrement()) {
            this.updateNewAutoincrementColumn(activation, this.columnInfo[ix].name, this.columnInfo[ix].autoincStart, this.columnInfo[ix].autoincInc);
        }
        if (columnDescriptor.hasNonNullDefault()) {
            this.updateNewColumnToDefault(activation, this.columnInfo[ix].name, this.columnInfo[ix].defaultInfo.getDefaultText(), lcc);
        }
        dd.updateSYSCOLPERMSforAddColumnToUserTable(this.td.getUUID(), tc);
    }

    private void dropColumnFromTable(Activation activation, int ix) throws StandardException {
        ConstraintDescriptor cd;
        int i;
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        DependencyManager dm = dd.getDependencyManager();
        TransactionController tc = lcc.getTransactionExecute();
        ColumnDescriptor columnDescriptor = this.td.getColumnDescriptor(this.columnInfo[ix].name);
        if (columnDescriptor == null) {
            throw StandardException.newException("42X14", (Object)this.columnInfo[ix].name, (Object)this.td.getQualifiedName());
        }
        DataDescriptorGenerator ddg = dd.getDataDescriptorGenerator();
        ColumnDescriptorList tab_cdl = this.td.getColumnDescriptorList();
        int size = tab_cdl.size();
        if (size == 1) {
            throw StandardException.newException("X0Y25.S", dm.getActionString(37), (Object)("THE *LAST* COLUMN " + this.columnInfo[ix].name), (Object)"TABLE", (Object)this.td.getQualifiedName());
        }
        this.droppedColumnPosition = columnDescriptor.getPosition();
        boolean cascade = this.behavior == 0;
        FormatableBitSet toDrop = new FormatableBitSet(size + 1);
        toDrop.set(this.droppedColumnPosition);
        this.td.setReferencedColumnMap(toDrop);
        dm.invalidateFor(this.td, cascade ? 37 : 46, lcc);
        if (columnDescriptor.getDefaultInfo() != null) {
            dm.clearDependencies(lcc, columnDescriptor.getDefaultDescriptor(dd));
        }
        GenericDescriptorList tdl = dd.getTriggerDescriptors(this.td);
        Enumeration descs = tdl.elements();
        while (descs.hasMoreElements()) {
            int j;
            TriggerDescriptor trd = (TriggerDescriptor)descs.nextElement();
            int[] referencedCols = trd.getReferencedCols();
            if (referencedCols == null) continue;
            int refColLen = referencedCols.length;
            boolean changed = false;
            for (j = 0; j < refColLen; ++j) {
                if (referencedCols[j] > this.droppedColumnPosition) {
                    changed = true;
                    continue;
                }
                if (referencedCols[j] != this.droppedColumnPosition) continue;
                if (cascade) {
                    trd.drop(lcc);
                    activation.addWarning(StandardException.newWarning("01502", trd.getName(), this.td.getName()));
                    break;
                }
                throw StandardException.newException("X0Y25.S", dm.getActionString(37), (Object)this.columnInfo[ix].name, (Object)"TRIGGER", (Object)trd.getName());
            }
            if (j != refColLen || !changed) continue;
            dd.dropTriggerDescriptor(trd, tc);
            for (j = 0; j < refColLen; ++j) {
                if (referencedCols[j] <= this.droppedColumnPosition) continue;
                int n = j;
                referencedCols[n] = referencedCols[n] - 1;
            }
            dd.addDescriptor(trd, this.sd, 13, false, tc);
        }
        ConstraintDescriptorList csdl = dd.getConstraintDescriptors(this.td);
        int csdl_size = csdl.size();
        int tbr_size = 0;
        ConstraintDescriptor[] toBeRemoved = new ConstraintDescriptor[csdl_size];
        for (i = csdl_size - 1; i >= 0; --i) {
            int j;
            cd = csdl.elementAt(i);
            int[] referencedColumns = cd.getReferencedColumns();
            int numRefCols = referencedColumns.length;
            boolean changed = false;
            for (j = 0; j < numRefCols; ++j) {
                if (referencedColumns[j] > this.droppedColumnPosition) {
                    changed = true;
                }
                if (referencedColumns[j] == this.droppedColumnPosition) break;
            }
            if (j == numRefCols) {
                if (!(cd instanceof CheckConstraintDescriptor) || !changed) continue;
                dd.dropConstraintDescriptor(cd, tc);
                for (j = 0; j < numRefCols; ++j) {
                    if (referencedColumns[j] <= this.droppedColumnPosition) continue;
                    int n = j;
                    referencedColumns[n] = referencedColumns[n] - 1;
                }
                ((CheckConstraintDescriptor)cd).setReferencedColumnsDescriptor(new ReferencedColumnsDescriptorImpl(referencedColumns));
                dd.addConstraintDescriptor(cd, tc);
                continue;
            }
            if (!cascade) {
                throw StandardException.newException("X0Y25.S", dm.getActionString(37), (Object)this.columnInfo[ix].name, (Object)"CONSTRAINT", (Object)cd.getConstraintName());
            }
            if (cd instanceof ReferencedKeyConstraintDescriptor) {
                toBeRemoved[tbr_size++] = cd;
                continue;
            }
            dm.invalidateFor(cd, 19, lcc);
            cd.drop(lcc, true);
            activation.addWarning(StandardException.newWarning("01500", cd.getConstraintName(), this.td.getName()));
        }
        for (i = tbr_size - 1; i >= 0; --i) {
            cd = toBeRemoved[i];
            cd.drop(lcc, false);
            activation.addWarning(StandardException.newWarning("01500", cd.getConstraintName(), this.td.getName()));
            if (cascade) {
                ConstraintDescriptorList fkcdl = dd.getForeignKeys(cd.getUUID());
                for (int j = 0; j < fkcdl.size(); ++j) {
                    ConstraintDescriptor fkcd = fkcdl.elementAt(j);
                    dm.invalidateFor(fkcd, 19, lcc);
                    fkcd.drop(lcc, true);
                    activation.addWarning(StandardException.newWarning("01500", fkcd.getConstraintName(), fkcd.getTableDescriptor().getName()));
                }
            }
            dm.invalidateFor(cd, 19, lcc);
            dm.clearDependencies(lcc, cd);
        }
        this.td = dd.getTableDescriptor(this.tableId);
        this.compressTable(activation);
        dd.dropColumnDescriptor(this.td.getUUID(), this.columnInfo[ix].name, tc);
        TupleDescriptor[] cdlArray = new ColumnDescriptor[size - columnDescriptor.getPosition()];
        int i2 = columnDescriptor.getPosition();
        int j = 0;
        while (i2 < size) {
            ColumnDescriptor cd2 = tab_cdl.elementAt(i2);
            dd.dropColumnDescriptor(this.td.getUUID(), cd2.getColumnName(), tc);
            cd2.setPosition(i2);
            if (cd2.isAutoincrement()) {
                cd2.setAutoinc_create_or_modify_Start_Increment(0);
            }
            cdlArray[j] = cd2;
            ++i2;
            ++j;
        }
        dd.addDescriptorArray(cdlArray, this.td, 2, false, tc);
        List deps = dd.getProvidersDescriptorList(this.td.getObjectID().toString());
        ListIterator depsIterator = deps.listIterator();
        while (depsIterator.hasNext()) {
            DependencyDescriptor depDesc = (DependencyDescriptor)depsIterator.next();
            DependableFinder finder = depDesc.getProviderFinder();
            if (!(finder instanceof DDColumnDependableFinder)) continue;
            DDColumnDependableFinder colFinder = (DDColumnDependableFinder)finder;
            FormatableBitSet oldColumnBitMap = new FormatableBitSet(colFinder.getColumnBitMap());
            FormatableBitSet newColumnBitMap = new FormatableBitSet(oldColumnBitMap);
            newColumnBitMap.clear();
            int bitLen = oldColumnBitMap.getLength();
            for (int i3 = 0; i3 < bitLen; ++i3) {
                if (i3 < this.droppedColumnPosition && oldColumnBitMap.isSet(i3)) {
                    newColumnBitMap.set(i3);
                }
                if (i3 <= this.droppedColumnPosition || !oldColumnBitMap.isSet(i3)) continue;
                newColumnBitMap.set(i3 - 1);
            }
            if (newColumnBitMap.equals(oldColumnBitMap)) continue;
            dd.dropStoredDependency(depDesc, tc);
            colFinder.setColumnBitMap(newColumnBitMap.getByteArray());
            dd.addDescriptor(depDesc, null, 6, true, tc);
        }
        dd.updateSYSCOLPERMSforDropColumn(this.td.getUUID(), tc, columnDescriptor);
    }

    private void modifyColumnType(Activation activation, int ix) throws StandardException {
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        TransactionController tc = lcc.getTransactionExecute();
        ColumnDescriptor columnDescriptor = this.td.getColumnDescriptor(this.columnInfo[ix].name);
        ColumnDescriptor newColumnDescriptor = null;
        newColumnDescriptor = new ColumnDescriptor(this.columnInfo[ix].name, columnDescriptor.getPosition(), this.columnInfo[ix].dataType, columnDescriptor.getDefaultValue(), columnDescriptor.getDefaultInfo(), this.td, columnDescriptor.getDefaultUUID(), this.columnInfo[ix].autoincStart, this.columnInfo[ix].autoincInc);
        dd.dropColumnDescriptor(this.td.getUUID(), this.columnInfo[ix].name, tc);
        dd.addDescriptor(newColumnDescriptor, this.td, 2, false, tc);
    }

    private void modifyColumnConstraint(Activation activation, String colName, boolean nullability) throws StandardException {
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        TransactionController tc = lcc.getTransactionExecute();
        ColumnDescriptor columnDescriptor = this.td.getColumnDescriptor(colName);
        ColumnDescriptor newColumnDescriptor = null;
        DataTypeDescriptor dataType = columnDescriptor.getType().getNullabilityType(nullability);
        newColumnDescriptor = new ColumnDescriptor(colName, columnDescriptor.getPosition(), dataType, columnDescriptor.getDefaultValue(), columnDescriptor.getDefaultInfo(), this.td, columnDescriptor.getDefaultUUID(), columnDescriptor.getAutoincStart(), columnDescriptor.getAutoincInc());
        dd.dropColumnDescriptor(this.td.getUUID(), colName, tc);
        dd.addDescriptor(newColumnDescriptor, this.td, 2, false, tc);
    }

    private void modifyColumnDefault(Activation activation, int ix) throws StandardException {
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        DependencyManager dm = dd.getDependencyManager();
        TransactionController tc = lcc.getTransactionExecute();
        ColumnDescriptor columnDescriptor = this.td.getColumnDescriptor(this.columnInfo[ix].name);
        DataDescriptorGenerator ddg = dd.getDataDescriptorGenerator();
        int columnPosition = columnDescriptor.getPosition();
        if (columnDescriptor.hasNonNullDefault()) {
            DefaultDescriptor defaultDescriptor = new DefaultDescriptor(dd, this.columnInfo[ix].oldDefaultUUID, this.td.getUUID(), columnPosition);
            dm.invalidateFor(defaultDescriptor, 31, lcc);
            dm.clearDependencies(lcc, defaultDescriptor);
        }
        UUID defaultUUID = this.columnInfo[ix].newDefaultUUID;
        if (this.columnInfo[ix].defaultInfo != null && defaultUUID == null) {
            defaultUUID = dd.getUUIDFactory().createUUID();
        }
        columnDescriptor = new ColumnDescriptor(this.columnInfo[ix].name, columnPosition, this.columnInfo[ix].dataType, this.columnInfo[ix].defaultValue, this.columnInfo[ix].defaultInfo, this.td, defaultUUID, this.columnInfo[ix].autoincStart, this.columnInfo[ix].autoincInc, this.columnInfo[ix].autoinc_create_or_modify_Start_Increment);
        dd.dropColumnDescriptor(this.td.getUUID(), this.columnInfo[ix].name, tc);
        dd.addDescriptor(columnDescriptor, this.td, 2, false, tc);
        if (this.columnInfo[ix].action == 6) {
            long maxValue = this.getColumnMax(activation, this.td, this.columnInfo[ix].name, this.columnInfo[ix].autoincInc, this.columnInfo[ix].autoincStart);
            dd.setAutoincrementValue(tc, this.td.getUUID(), this.columnInfo[ix].name, maxValue, true);
        } else if (this.columnInfo[ix].action == 5) {
            dd.setAutoincrementValue(tc, this.td.getUUID(), this.columnInfo[ix].name, this.columnInfo[ix].autoincStart, false);
        }
    }

    private void compressTable(Activation activation) throws StandardException {
        Properties properties = new Properties();
        this.lcc = activation.getLanguageConnectionContext();
        this.dd = this.lcc.getDataDictionary();
        this.dm = this.dd.getDependencyManager();
        this.tc = this.lcc.getTransactionExecute();
        this.activation = activation;
        if (this.lockGranularity != '\u0000') {
            SanityManager.THROWASSERT("lockGranularity expected to be '\u0000', not " + this.lockGranularity);
        }
        SanityManager.ASSERT(!this.compressTable || this.columnInfo == null, "columnInfo expected to be null");
        SanityManager.ASSERT(this.constraintActions == null, "constraintActions expected to be null");
        ExecRow emptyHeapRow = this.td.getEmptyExecRow();
        int[] collation_ids = this.td.getColumnCollationIds();
        this.compressHeapCC = this.tc.openConglomerate(this.td.getHeapConglomerateId(), false, 4, 7, 5);
        this.dm.invalidateFor(this.td, 33, this.lcc);
        RowLocation rl = this.compressHeapCC.newRowLocationTemplate();
        this.compressHeapCC.getInternalTablePropertySet(properties);
        this.compressHeapCC.close();
        this.compressHeapCC = null;
        this.baseRow = new ExecRow[this.bulkFetchSize];
        this.baseRowArray = new DataValueDescriptor[this.bulkFetchSize][];
        this.validRow = new boolean[this.bulkFetchSize];
        this.getAffectedIndexes(activation);
        this.compressRL = new RowLocation[this.bulkFetchSize];
        this.indexRows = new ExecIndexRow[this.numIndexes];
        if (!this.compressTable) {
            ExecRow newRow = activation.getExecutionFactory().getValueRow(emptyHeapRow.nColumns() - 1);
            int[] new_collation_ids = new int[collation_ids.length - 1];
            for (int i = 0; i < newRow.nColumns(); ++i) {
                newRow.setColumn(i + 1, i < this.droppedColumnPosition - 1 ? emptyHeapRow.getColumn(i + 1) : emptyHeapRow.getColumn(i + 1 + 1));
                new_collation_ids[i] = collation_ids[i < this.droppedColumnPosition - 1 ? i : i + 1];
            }
            emptyHeapRow = newRow;
            collation_ids = new_collation_ids;
        }
        this.setUpAllSorts(emptyHeapRow, rl);
        this.openBulkFetchScan(this.td.getHeapConglomerateId());
        this.estimatedRowCount = this.compressHeapGSC.getEstimatedRowCount();
        for (int i = 0; i < this.bulkFetchSize; ++i) {
            this.baseRow[i] = this.td.getEmptyExecRow();
            this.baseRowArray[i] = this.baseRow[i].getRowArray();
            this.compressRL[i] = this.compressHeapGSC.newRowLocationTemplate();
        }
        long newHeapConglom = this.tc.createAndLoadConglomerate("heap", emptyHeapRow.getRowArray(), null, collation_ids, properties, 0, this, null);
        this.closeBulkFetchScan();
        ScanController compressHeapSC = this.tc.openScan(newHeapConglom, false, 4, 7, 5, null, null, 0, null, null, 0);
        compressHeapSC.setEstimatedRowCount(this.rowCount);
        compressHeapSC.close();
        compressHeapSC = null;
        this.dd.startWriting(this.lcc);
        if (this.compressIRGs.length > 0) {
            this.updateAllIndexes(newHeapConglom, this.dd);
        }
        long oldHeapConglom = this.td.getHeapConglomerateId();
        ConglomerateDescriptor cd = this.td.getConglomerateDescriptor(oldHeapConglom);
        this.dd.updateConglomerateDescriptor(cd, newHeapConglom, this.tc);
        this.tc.dropConglomerate(oldHeapConglom);
        this.cleanUp();
    }

    private void truncateTable(Activation activation) throws StandardException {
        Properties properties = new Properties();
        this.lcc = activation.getLanguageConnectionContext();
        this.dd = this.lcc.getDataDictionary();
        this.dm = this.dd.getDependencyManager();
        this.tc = this.lcc.getTransactionExecute();
        this.activation = activation;
        if (this.lockGranularity != '\u0000') {
            SanityManager.THROWASSERT("lockGranularity expected to be '\u0000', not " + this.lockGranularity);
        }
        SanityManager.ASSERT(this.columnInfo == null, "columnInfo expected to be null");
        SanityManager.ASSERT(this.constraintActions == null, "constraintActions expected to be null");
        ConstraintDescriptorList cdl = this.dd.getConstraintDescriptors(this.td);
        for (int index = 0; index < cdl.size(); ++index) {
            ReferencedKeyConstraintDescriptor rfcd;
            ConstraintDescriptor cd = cdl.elementAt(index);
            if (!(cd instanceof ReferencedKeyConstraintDescriptor) || !(rfcd = (ReferencedKeyConstraintDescriptor)cd).hasNonSelfReferencingFK(1)) continue;
            throw StandardException.newException("XCL48.S", this.td.getName());
        }
        GenericDescriptorList tdl = this.dd.getTriggerDescriptors(this.td);
        Enumeration descs = tdl.elements();
        while (descs.hasMoreElements()) {
            TriggerDescriptor trd = (TriggerDescriptor)descs.nextElement();
            if (!trd.listensForEvent(2) || !trd.isEnabled()) continue;
            throw StandardException.newException("XCL49.S", (Object)this.td.getName(), (Object)trd.getName());
        }
        ExecRow emptyHeapRow = this.td.getEmptyExecRow();
        this.compressHeapCC = this.tc.openConglomerate(this.td.getHeapConglomerateId(), false, 4, 7, 5);
        this.dm.invalidateFor(this.td, 42, this.lcc);
        RowLocation rl = this.compressHeapCC.newRowLocationTemplate();
        this.compressHeapCC.getInternalTablePropertySet(properties);
        this.compressHeapCC.close();
        this.compressHeapCC = null;
        long newHeapConglom = this.tc.createConglomerate("heap", emptyHeapRow.getRowArray(), null, this.td.getColumnCollationIds(), properties, 0);
        this.getAffectedIndexes(activation);
        if (this.numIndexes > 0) {
            this.indexRows = new ExecIndexRow[this.numIndexes];
            this.ordering = new ColumnOrdering[this.numIndexes][];
            for (int index = 0; index < this.numIndexes; ++index) {
                this.indexRows[index] = this.compressIRGs[index].getIndexRowTemplate();
                this.compressIRGs[index].getIndexRow(emptyHeapRow, rl, this.indexRows[index], null);
                int[] baseColumnPositions = this.compressIRGs[index].baseColumnPositions();
                boolean[] isAscending = this.compressIRGs[index].isAscending();
                int numColumnOrderings = baseColumnPositions.length + 1;
                this.ordering[index] = new ColumnOrdering[numColumnOrderings];
                this.collation[index] = new int[baseColumnPositions.length + 1];
                for (int ii = 0; ii < numColumnOrderings - 1; ++ii) {
                    this.ordering[index][ii] = new IndexColumnOrder(ii, isAscending[ii]);
                }
                this.ordering[index][numColumnOrderings - 1] = new IndexColumnOrder(numColumnOrderings - 1);
            }
        }
        this.dd.startWriting(this.lcc);
        if (this.numIndexes > 0) {
            long[] newIndexCongloms = new long[this.numIndexes];
            for (int index = 0; index < this.numIndexes; ++index) {
                this.updateIndex(newHeapConglom, this.dd, index, newIndexCongloms);
            }
        }
        long oldHeapConglom = this.td.getHeapConglomerateId();
        ConglomerateDescriptor cd = this.td.getConglomerateDescriptor(oldHeapConglom);
        this.dd.updateConglomerateDescriptor(cd, newHeapConglom, this.tc);
        this.tc.dropConglomerate(oldHeapConglom);
        this.cleanUp();
    }

    private void updateAllIndexes(long newHeapConglom, DataDictionary dd) throws StandardException {
        long[] newIndexCongloms = new long[this.numIndexes];
        if (this.sequential) {
            if (this.numIndexes >= 1) {
                this.updateIndex(newHeapConglom, dd, 0, newIndexCongloms);
            }
            for (int index = 1; index < this.numIndexes; ++index) {
                this.openBulkFetchScan(newHeapConglom);
                while (this.getNextRowFromRowSource() != null) {
                    this.objectifyStreamingColumns();
                    this.insertIntoSorter(index, this.compressRL[this.currentCompressRow - 1]);
                }
                this.updateIndex(newHeapConglom, dd, index, newIndexCongloms);
                this.closeBulkFetchScan();
            }
        } else {
            for (int index = 0; index < this.numIndexes; ++index) {
                this.updateIndex(newHeapConglom, dd, index, newIndexCongloms);
            }
        }
    }

    private void updateIndex(long newHeapConglom, DataDictionary dd, int index, long[] newIndexCongloms) throws StandardException {
        Properties properties = new Properties();
        ConglomerateDescriptor cd = this.td.getConglomerateDescriptor(this.indexConglomerateNumbers[index]);
        ConglomerateController indexCC = this.tc.openConglomerate(this.indexConglomerateNumbers[index], false, 4, 7, 5);
        indexCC.getInternalTablePropertySet(properties);
        int indexRowLength = this.indexRows[index].nColumns();
        properties.put("baseConglomerateId", Long.toString(newHeapConglom));
        if (cd.getIndexDescriptor().isUnique()) {
            properties.put("nUniqueColumns", Integer.toString(indexRowLength - 1));
        } else {
            properties.put("nUniqueColumns", Integer.toString(indexRowLength));
        }
        properties.put("rowLocationColumn", Integer.toString(indexRowLength - 1));
        properties.put("nKeyFields", Integer.toString(indexRowLength));
        indexCC.close();
        CardinalityCounter cCount = null;
        boolean statisticsExist = false;
        if (!this.truncateTable) {
            long numRows;
            this.sorters[index].completedInserts();
            this.sorters[index] = null;
            if (this.td.statisticsExist(cd)) {
                cCount = new CardinalityCounter(this.tc.openSortRowSource(this.sortIds[index]));
                statisticsExist = true;
            } else {
                cCount = new CardinalityCounter(this.tc.openSortRowSource(this.sortIds[index]));
            }
            newIndexCongloms[index] = this.tc.createAndLoadConglomerate("BTREE", this.indexRows[index].getRowArray(), this.ordering[index], this.collation[index], properties, 0, cCount, null);
            if (statisticsExist) {
                dd.dropStatisticsDescriptors(this.td.getUUID(), cd.getUUID(), this.tc);
            }
            if ((numRows = cCount.getRowCount()) > 0L) {
                long[] c = cCount.getCardinality();
                for (int i = 0; i < c.length; ++i) {
                    StatisticsDescriptor statDesc = new StatisticsDescriptor(dd, dd.getUUIDFactory().createUUID(), cd.getUUID(), this.td.getUUID(), "I", new StatisticsImpl(numRows, c[i]), i + 1);
                    dd.addDescriptor(statDesc, null, 14, true, this.tc);
                }
            }
        } else {
            newIndexCongloms[index] = this.tc.createConglomerate("BTREE", this.indexRows[index].getRowArray(), this.ordering[index], this.collation[index], properties, 0);
            if (this.td.statisticsExist(cd)) {
                dd.dropStatisticsDescriptors(this.td.getUUID(), cd.getUUID(), this.tc);
            }
        }
        dd.updateConglomerateDescriptor(this.td.getConglomerateDescriptors(this.indexConglomerateNumbers[index]), newIndexCongloms[index], this.tc);
        this.tc.dropConglomerate(this.indexConglomerateNumbers[index]);
    }

    private void getAffectedIndexes(Activation activation) throws StandardException {
        Object[] compressIndexResult;
        IndexLister indexLister = this.td.getIndexLister();
        this.compressIRGs = indexLister.getIndexRowGenerators();
        this.numIndexes = this.compressIRGs.length;
        this.indexConglomerateNumbers = indexLister.getIndexConglomerateNumbers();
        if (!this.compressTable && !this.truncateTable) {
            for (int i = 0; i < this.compressIRGs.length; ++i) {
                ConglomerateDescriptor cd;
                int j;
                int[] baseColumnPositions = this.compressIRGs[i].baseColumnPositions();
                for (j = 0; j < baseColumnPositions.length && baseColumnPositions[j] != this.droppedColumnPosition; ++j) {
                }
                if (j == baseColumnPositions.length) continue;
                if (baseColumnPositions.length == 1 || this.behavior == 0 && this.compressIRGs[i].isUnique()) {
                    --this.numIndexes;
                    cd = this.td.getConglomerateDescriptor(this.indexConglomerateNumbers[i]);
                    cd.drop(activation.getLanguageConnectionContext(), this.td);
                    this.compressIRGs[i] = null;
                    continue;
                }
                if (!this.compressIRGs[i].isUnique()) continue;
                cd = this.td.getConglomerateDescriptor(this.indexConglomerateNumbers[i]);
                throw StandardException.newException("X0Y25.S", this.dm.getActionString(37), (Object)this.columnInfo[0].name, (Object)"UNIQUE INDEX", (Object)cd.getConglomerateName());
            }
            IndexRowGenerator[] newIRGs = new IndexRowGenerator[this.numIndexes];
            long[] newIndexConglomNumbers = new long[this.numIndexes];
            int i = 0;
            int j = 0;
            while (i < this.numIndexes) {
                while (this.compressIRGs[j] == null) {
                    ++j;
                }
                int[] baseColumnPositions = this.compressIRGs[j].baseColumnPositions();
                newIRGs[i] = this.compressIRGs[j];
                newIndexConglomNumbers[i] = this.indexConglomerateNumbers[j];
                boolean[] isAscending = this.compressIRGs[j].isAscending();
                boolean reMakeArrays = false;
                int size = baseColumnPositions.length;
                for (int k = 0; k < size; ++k) {
                    if (baseColumnPositions[k] > this.droppedColumnPosition) {
                        int n = k;
                        baseColumnPositions[n] = baseColumnPositions[n] - 1;
                        continue;
                    }
                    if (baseColumnPositions[k] != this.droppedColumnPosition) continue;
                    baseColumnPositions[k] = 0;
                    reMakeArrays = true;
                }
                if (reMakeArrays) {
                    int[] newBCP = new int[--size];
                    boolean[] newIsAscending = new boolean[size];
                    int step = 0;
                    for (int k = 0; k < size; ++k) {
                        if (step == 0 && baseColumnPositions[k + step] == 0) {
                            ++step;
                        }
                        newBCP[k] = baseColumnPositions[k + step];
                        newIsAscending[k] = isAscending[k + step];
                    }
                    IndexDescriptor id = this.compressIRGs[j].getIndexDescriptor();
                    id.setBaseColumnPositions(newBCP);
                    id.setIsAscending(newIsAscending);
                    id.setNumberOfOrderedColumns(id.numberOfOrderedColumns() - 1);
                }
                ++i;
                ++j;
            }
            this.compressIRGs = newIRGs;
            this.indexConglomerateNumbers = newIndexConglomNumbers;
        }
        if ((compressIndexResult = this.compressIndexArrays(this.indexConglomerateNumbers, this.compressIRGs)) != null) {
            this.indexConglomerateNumbers = (long[])compressIndexResult[1];
            this.compressIRGs = (IndexRowGenerator[])compressIndexResult[2];
            this.numIndexes = this.indexConglomerateNumbers.length;
        }
        this.indexedCols = new FormatableBitSet(this.compressTable || this.truncateTable ? this.td.getNumberOfColumns() + 1 : this.td.getNumberOfColumns());
        for (int index = 0; index < this.numIndexes; ++index) {
            int[] colIds = this.compressIRGs[index].getIndexDescriptor().baseColumnPositions();
            for (int index2 = 0; index2 < colIds.length; ++index2) {
                this.indexedCols.set(colIds[index2]);
            }
        }
    }

    private void setUpAllSorts(ExecRow sourceRow, RowLocation rl) throws StandardException {
        int index;
        this.ordering = new ColumnOrdering[this.numIndexes][];
        this.collation = new int[this.numIndexes][];
        this.needToDropSort = new boolean[this.numIndexes];
        this.sortIds = new long[this.numIndexes];
        int[] base_table_collation_ids = this.td.getColumnCollationIds();
        for (index = 0; index < this.numIndexes; ++index) {
            this.indexRows[index] = this.compressIRGs[index].getIndexRowTemplate();
            this.compressIRGs[index].getIndexRow(sourceRow, rl, this.indexRows[index], null);
            this.collation[index] = this.compressIRGs[index].getColumnCollationIds(this.td.getColumnDescriptorList());
            int[] baseColumnPositions = this.compressIRGs[index].baseColumnPositions();
            boolean[] isAscending = this.compressIRGs[index].isAscending();
            int numColumnOrderings = baseColumnPositions.length + 1;
            boolean reuseWrappers = this.numIndexes == 1;
            BasicSortObserver sortObserver = new BasicSortObserver(false, false, this.indexRows[index], reuseWrappers);
            this.ordering[index] = new ColumnOrdering[numColumnOrderings];
            for (int ii = 0; ii < numColumnOrderings - 1; ++ii) {
                this.ordering[index][ii] = new IndexColumnOrder(ii, isAscending[ii]);
            }
            this.ordering[index][numColumnOrderings - 1] = new IndexColumnOrder(numColumnOrderings - 1);
            this.sortIds[index] = this.tc.createSort(null, this.indexRows[index].getRowArrayClone(), this.ordering[index], sortObserver, false, this.estimatedRowCount, -1);
        }
        this.sorters = new SortController[this.numIndexes];
        for (index = 0; index < this.numIndexes; ++index) {
            this.sorters[index] = this.tc.openSort(this.sortIds[index]);
            this.needToDropSort[index] = true;
        }
    }

    public FormatableBitSet getValidColumns() {
        return null;
    }

    public DataValueDescriptor[] getNextRowFromRowSource() throws StandardException {
        this.currentRow = null;
        if (!(this.doneScan || this.currentCompressRow != this.bulkFetchSize && this.validRow[this.currentCompressRow])) {
            int index;
            int bulkFetched = 0;
            bulkFetched = this.compressHeapGSC.fetchNextGroup(this.baseRowArray, this.compressRL);
            this.doneScan = bulkFetched != this.bulkFetchSize;
            this.currentCompressRow = 0;
            this.rowCount += bulkFetched;
            for (index = 0; index < bulkFetched; ++index) {
                this.validRow[index] = true;
            }
            for (index = bulkFetched; index < this.bulkFetchSize; ++index) {
                this.validRow[index] = false;
            }
        }
        if (this.validRow[this.currentCompressRow]) {
            if (this.compressTable) {
                this.currentRow = this.baseRow[this.currentCompressRow];
            } else {
                if (this.currentRow == null) {
                    this.currentRow = this.activation.getExecutionFactory().getValueRow(this.baseRowArray[this.currentCompressRow].length - 1);
                }
                for (int i = 0; i < this.currentRow.nColumns(); ++i) {
                    this.currentRow.setColumn(i + 1, i < this.droppedColumnPosition - 1 ? this.baseRow[this.currentCompressRow].getColumn(i + 1) : this.baseRow[this.currentCompressRow].getColumn(i + 1 + 1));
                }
            }
            ++this.currentCompressRow;
        }
        if (this.currentRow != null) {
            if (this.compressIRGs.length > 0) {
                this.currentRow = this.currentRow.getClone(this.indexedCols);
            }
            return this.currentRow.getRowArray();
        }
        return null;
    }

    public boolean needsToClone() {
        return true;
    }

    public void closeRowSource() {
    }

    public boolean needsRowLocation() {
        return this.numIndexes > 0;
    }

    public void rowLocation(RowLocation rl) throws StandardException {
        if (this.compressIRGs.length > 0) {
            this.objectifyStreamingColumns();
            int maxIndex = this.compressIRGs.length;
            if (maxIndex > 1 && this.sequential) {
                maxIndex = 1;
            }
            for (int index = 0; index < maxIndex; ++index) {
                this.insertIntoSorter(index, rl);
            }
        }
    }

    private void objectifyStreamingColumns() throws StandardException {
        for (int i = 0; i < this.currentRow.getRowArray().length; ++i) {
            if (!this.indexedCols.get(i + 1) || !(this.currentRow.getRowArray()[i] instanceof StreamStorable)) continue;
            this.currentRow.getRowArray()[i].getObject();
        }
    }

    private void insertIntoSorter(int index, RowLocation rl) throws StandardException {
        this.indexRows[index].getNewObjectArray();
        this.compressIRGs[index].getIndexRow(this.currentRow, (RowLocation)rl.cloneObject(), this.indexRows[index], null);
        this.sorters[index].insert(this.indexRows[index].getRowArray());
    }

    private void cleanUp() throws StandardException {
        int index;
        if (this.compressHeapCC != null) {
            this.compressHeapCC.close();
            this.compressHeapCC = null;
        }
        if (this.compressHeapGSC != null) {
            this.closeBulkFetchScan();
        }
        if (this.sorters != null) {
            for (index = 0; index < this.compressIRGs.length; ++index) {
                if (this.sorters[index] != null) {
                    this.sorters[index].completedInserts();
                }
                this.sorters[index] = null;
            }
        }
        if (this.needToDropSort != null) {
            for (index = 0; index < this.needToDropSort.length; ++index) {
                if (!this.needToDropSort[index]) continue;
                this.tc.dropSort(this.sortIds[index]);
                this.needToDropSort[index] = false;
            }
        }
    }

    private int getSemiRowCount(TransactionController tc) throws StandardException {
        int numRows = 0;
        ScanController sc = tc.openScan(this.td.getHeapConglomerateId(), false, 0, 7, 5, RowUtil.EMPTY_ROW_BITSET, null, 1, null, null, -1);
        while (sc.next() && ++numRows != 2) {
        }
        sc.close();
        return numRows;
    }

    private void updateNewColumnToDefault(Activation activation, String columnName, String defaultText, LanguageConnectionContext lcc) throws StandardException {
        String updateStmt = "UPDATE \"" + this.td.getSchemaName() + "\".\"" + this.td.getName() + "\" SET \"" + columnName + "\" = " + defaultText;
        AlterTableConstantAction.executeUpdate(lcc, updateStmt);
    }

    private static void executeUpdate(LanguageConnectionContext lcc, String updateStmt) throws StandardException {
        PreparedStatement ps = lcc.prepareInternalStatement(updateStmt);
        ResultSet rs = ps.execute(lcc, true, 0L);
        rs.close();
        rs.finish();
    }

    private long getColumnMax(Activation activation, TableDescriptor td, String columnName, long increment, long initial) throws StandardException {
        String maxStr = increment > 0L ? "MAX" : "MIN";
        String maxStmt = "SELECT " + maxStr + "(\"" + columnName + "\")" + "FROM \"" + td.getSchemaName() + "\".\"" + td.getName() + "\"";
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        PreparedStatement ps = lcc.prepareInternalStatement(maxStmt);
        ResultSet rs = ps.execute(lcc, false, 0L);
        DataValueDescriptor[] rowArray = rs.getNextRow().getRowArray();
        rs.close();
        rs.finish();
        return rowArray[0].getLong();
    }

    private void dropAllColumnDefaults(UUID tableId, DataDictionary dd) throws StandardException {
        ColumnDescriptorList cdl = this.td.getColumnDescriptorList();
        int cdlSize = cdl.size();
        for (int index = 0; index < cdlSize; ++index) {
            ColumnDescriptor cd = cdl.elementAt(index);
            if (cd.getDefaultInfo() == null) continue;
            DefaultDescriptor defaultDesc = cd.getDefaultDescriptor(dd);
            this.dm.clearDependencies(this.lcc, defaultDesc);
        }
    }

    private void openBulkFetchScan(long heapConglomNumber) throws StandardException {
        this.doneScan = false;
        this.compressHeapGSC = this.tc.openGroupFetchScan(heapConglomNumber, false, 0, 7, 5, null, null, 0, null, null, 0);
    }

    private void closeBulkFetchScan() throws StandardException {
        this.compressHeapGSC.close();
        this.compressHeapGSC = null;
    }

    private void updateNewAutoincrementColumn(Activation activation, String columnName, long initial, long increment) throws StandardException {
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        lcc.setAutoincrementUpdate(true);
        lcc.autoincrementCreateCounter(this.td.getSchemaName(), this.td.getName(), columnName, new Long(initial), increment, 0);
        String updateStmt = "UPDATE \"" + this.td.getSchemaName() + "\".\"" + this.td.getName() + "\" SET \"" + columnName + "\" = " + "org.apache.derby.iapi.db.ConnectionInfo::" + "nextAutoincrementValue(" + "'" + this.td.getSchemaName() + "'" + "," + "'" + this.td.getName() + "'" + "," + "'" + columnName + "'" + ")";
        try {
            AlterTableConstantAction.executeUpdate(lcc, updateStmt);
        }
        catch (StandardException se) {
            if (se.getMessageId().equals("22003")) {
                throw StandardException.newException("42Z24", se, (Object)this.td.getName(), (Object)columnName);
            }
            throw se;
        }
        finally {
            lcc.autoincrementFlushCache(this.td.getUUID());
            lcc.setAutoincrementUpdate(false);
        }
    }

    private boolean validateNotNullConstraint(String[] columnNames, boolean[] nullCols, int numRows, LanguageConnectionContext lcc, String errorMsg) throws StandardException {
        boolean foundNullable = false;
        StringBuffer constraintText = new StringBuffer();
        for (int colCtr = 0; colCtr < columnNames.length; ++colCtr) {
            ColumnDescriptor cd = this.td.getColumnDescriptor(columnNames[colCtr]);
            if (cd == null) {
                throw StandardException.newException("42X14", (Object)columnNames[colCtr], (Object)this.td.getName());
            }
            if (!cd.getType().isNullable()) continue;
            if (numRows > 0) {
                if (foundNullable) {
                    constraintText.append(" AND ");
                }
                constraintText.append(columnNames[colCtr] + " IS NOT NULL ");
            }
            foundNullable = true;
            nullCols[colCtr] = true;
        }
        if (foundNullable && numRows > 0 && !ConstraintConstantAction.validateConstraint(null, constraintText.toString(), this.td, lcc, false)) {
            if (errorMsg.equals("X0Y63.S")) {
                throw StandardException.newException("X0Y63.S", this.td.getQualifiedName());
            }
            throw StandardException.newException("X0Y80.S", (Object)this.td.getQualifiedName(), (Object)columnNames[0]);
        }
        return foundNullable;
    }

    private Object[] compressIndexArrays(long[] indexCIDS, IndexRowGenerator[] irgs) {
        long[] workSpace = new long[indexCIDS.length];
        int j = 0;
        int k = indexCIDS.length - 1;
        for (int i = 0; i < indexCIDS.length; ++i) {
            int m;
            for (m = 0; m < j; ++m) {
                if (indexCIDS[i] != workSpace[m]) continue;
                workSpace[k--] = i;
                break;
            }
            if (m != j) continue;
            workSpace[j++] = indexCIDS[i];
        }
        if (j < indexCIDS.length) {
            long[] newIndexCIDS = new long[j];
            IndexRowGenerator[] newIrgs = new IndexRowGenerator[j];
            int[] duplicateIndexes = new int[indexCIDS.length - j];
            k = 0;
            int n = indexCIDS.length - 1;
            for (int m = 0; m < indexCIDS.length; ++m) {
                if (m < j) {
                    newIndexCIDS[m] = workSpace[m];
                } else {
                    duplicateIndexes[indexCIDS.length - m - 1] = (int)workSpace[m];
                }
                if (n >= j && m == (int)workSpace[n]) {
                    --n;
                    continue;
                }
                newIrgs[k] = irgs[m];
                ++k;
            }
            Object[] returnValue = new Object[]{duplicateIndexes, newIndexCIDS, newIrgs};
            return returnValue;
        }
        return null;
    }
}

