/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.GroupByList;
import org.apache.derby.impl.sql.compile.HasNodeVisitor;
import org.apache.derby.impl.sql.compile.JavaToSQLValueNode;
import org.apache.derby.impl.sql.compile.SubqueryNode;
import org.apache.derby.impl.sql.compile.ValueNode;

public class VerifyAggregateExpressionsVisitor
implements Visitor {
    private GroupByList groupByList;

    public VerifyAggregateExpressionsVisitor(GroupByList groupByList) {
        this.groupByList = groupByList;
    }

    public Visitable visit(Visitable node) throws StandardException {
        if (node instanceof ColumnReference) {
            ColumnReference cr = (ColumnReference)node;
            if (this.groupByList == null) {
                throw StandardException.newException("42Y35", cr.getSQLColumnName());
            }
            if (this.groupByList.findGroupingColumn(cr) == null) {
                throw StandardException.newException("42Y30");
            }
        } else if (node instanceof SubqueryNode) {
            SubqueryNode subq = (SubqueryNode)node;
            if (subq.getSubqueryType() != 17 || subq.hasCorrelatedCRs()) {
                throw StandardException.newException(this.groupByList == null ? "42Y29" : "42Y30");
            }
            HasNodeVisitor visitor = new HasNodeVisitor(AggregateNode.class);
            subq.accept(visitor);
            if (visitor.hasNode()) {
                throw StandardException.newException(this.groupByList == null ? "42Y29" : "42Y30");
            }
        } else if (node instanceof JavaToSQLValueNode) {
            throw StandardException.newException(this.groupByList == null ? "42Y29" : "42Y30");
        }
        return node;
    }

    public boolean skipChildren(Visitable node) throws StandardException {
        return node instanceof AggregateNode || node instanceof SubqueryNode || node instanceof ValueNode && this.groupByList != null && this.groupByList.findGroupingColumn((ValueNode)node) != null;
    }

    public boolean stopTraversal() {
        return false;
    }
}

