/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.OptimizablePredicateList;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.compile.RowOrdering;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.RowResultSetNode;
import org.apache.derby.impl.sql.compile.SelectNode;
import org.apache.derby.impl.sql.compile.SetOperatorNode;

public class UnionNode
extends SetOperatorNode {
    private boolean addNewNodesCalled;
    boolean tableConstructor;
    boolean topTableConstructor;

    public void init(Object leftResult, Object rightResult, Object all, Object tableConstructor, Object tableProperties) throws StandardException {
        super.init(leftResult, rightResult, all, tableProperties);
        this.tableConstructor = (Boolean)tableConstructor;
    }

    public void markTopTableConstructor() {
        this.topTableConstructor = true;
    }

    boolean tableConstructor() {
        return this.tableConstructor;
    }

    public void rejectParameters() throws StandardException {
        if (!this.tableConstructor()) {
            super.rejectParameters();
        }
    }

    void setTableConstructorTypes(ResultColumnList typeColumns) throws StandardException {
        SanityManager.ASSERT(this.resultColumns.size() <= typeColumns.size(), "More columns in ResultColumnList than in base table.");
        if (this.tableConstructor()) {
            ResultSetNode rsn = this;
            while (rsn instanceof UnionNode) {
                UnionNode union = rsn;
                SanityManager.ASSERT(union.rightResultSet instanceof RowResultSetNode, "A " + union.rightResultSet.getClass().getName() + " is on the right of a union in a table constructor");
                ((RowResultSetNode)union.rightResultSet).setTableConstructorTypes(typeColumns);
                rsn = union.leftResultSet;
            }
            SanityManager.ASSERT(rsn instanceof RowResultSetNode, "A " + rsn.getClass().getName() + " is at the left end of a table constructor");
            ((RowResultSetNode)rsn).setTableConstructorTypes(typeColumns);
        }
    }

    public CostEstimate optimizeIt(Optimizer optimizer, OptimizablePredicateList predList, CostEstimate outerCost, RowOrdering rowOrdering) throws StandardException {
        if (predList != null && !this.getCurrentAccessPath().getJoinStrategy().isHashJoin()) {
            for (int i = predList.size() - 1; i >= 0; --i) {
                if (!this.pushOptPredicate(predList.getOptPredicate(i))) continue;
                predList.removeOptPredicate(i);
            }
        }
        this.updateBestPlanMap((short)1, this);
        this.leftResultSet = this.optimizeSource(optimizer, this.leftResultSet, this.getLeftOptPredicateList(), outerCost);
        this.rightResultSet = this.optimizeSource(optimizer, this.rightResultSet, this.getRightOptPredicateList(), outerCost);
        CostEstimate costEstimate = this.getCostEstimate(optimizer);
        costEstimate.setCost(this.leftResultSet.getCostEstimate().getEstimatedCost(), this.leftResultSet.getCostEstimate().rowCount(), this.leftResultSet.getCostEstimate().singleScanRowCount() + this.rightResultSet.getCostEstimate().singleScanRowCount());
        costEstimate.add(this.rightResultSet.costEstimate, costEstimate);
        this.getCurrentAccessPath().getJoinStrategy().estimateCost(this, predList, null, outerCost, optimizer, costEstimate);
        optimizer.considerCost(this, predList, costEstimate, outerCost);
        return costEstimate;
    }

    public void pushExpressions(PredicateList predicateList) throws StandardException {
        if (this.leftResultSet instanceof UnionNode) {
            ((UnionNode)this.leftResultSet).pushExpressions(predicateList);
        } else if (this.leftResultSet instanceof SelectNode) {
            predicateList.pushExpressionsIntoSelect((SelectNode)this.leftResultSet, true);
        }
        if (this.rightResultSet instanceof UnionNode) {
            ((UnionNode)this.rightResultSet).pushExpressions(predicateList);
        } else if (this.rightResultSet instanceof SelectNode) {
            predicateList.pushExpressionsIntoSelect((SelectNode)this.rightResultSet, true);
        }
    }

    public Optimizable modifyAccessPath(JBitSet outerTables) throws StandardException {
        Optimizable retOptimizable = super.modifyAccessPath(outerTables);
        if (this.addNewNodesCalled) {
            return retOptimizable;
        }
        return (Optimizable)((Object)this.addNewNodes());
    }

    public ResultSetNode modifyAccessPaths() throws StandardException {
        ResultSetNode retRSN = super.modifyAccessPaths();
        if (this.addNewNodesCalled) {
            return retRSN;
        }
        return this.addNewNodes();
    }

    private ResultSetNode addNewNodes() throws StandardException {
        ResultSetNode treeTop = this;
        if (this.addNewNodesCalled) {
            return this;
        }
        this.addNewNodesCalled = true;
        if (!this.all) {
            if (!this.columnTypesAndLengthsMatch()) {
                treeTop = this.genNormalizeResultSetNode(this, false);
            }
            treeTop = (ResultSetNode)this.getNodeFactory().getNode(124, treeTop.genProjectRestrict(), Boolean.FALSE, this.tableProperties, this.getContextManager());
            ((FromTable)treeTop).setTableNumber(this.tableNumber);
            treeTop.setReferencedTableMap((JBitSet)this.referencedTableMap.clone());
            this.all = true;
        }
        if (this.orderByList != null) {
            treeTop = (ResultSetNode)this.getNodeFactory().getNode(140, treeTop, this.orderByList, this.tableProperties, this.getContextManager());
        }
        return treeTop;
    }

    public String toString() {
        return "tableConstructor: " + this.tableConstructor + "\n" + super.toString();
    }

    public void bindExpressions(FromList fromListParam) throws StandardException {
        super.bindExpressions(fromListParam);
        if (this.topTableConstructor && !this.insertSource) {
            RowResultSetNode rrsn;
            SetOperatorNode setOperator;
            DataTypeDescriptor[] types = new DataTypeDescriptor[this.leftResultSet.getResultColumns().size()];
            int numTypes = 0;
            ResultSetNode rsn = this;
            while (rsn instanceof SetOperatorNode) {
                setOperator = rsn;
                SanityManager.ASSERT(setOperator.rightResultSet instanceof RowResultSetNode, "A " + setOperator.rightResultSet.getClass().getName() + " is on the right side of a setOperator in a table constructor");
                rrsn = (RowResultSetNode)setOperator.rightResultSet;
                numTypes += this.getParamColumnTypes(types, rrsn);
                rsn = setOperator.leftResultSet;
            }
            SanityManager.ASSERT(rsn instanceof RowResultSetNode);
            if ((numTypes += this.getParamColumnTypes(types, (RowResultSetNode)rsn)) < types.length) {
                throw StandardException.newException("42Y10");
            }
            rsn = this;
            while (rsn instanceof SetOperatorNode) {
                setOperator = rsn;
                rrsn = (RowResultSetNode)setOperator.rightResultSet;
                this.setParamColumnTypes(types, rrsn);
                rsn = setOperator.leftResultSet;
            }
            this.setParamColumnTypes(types, (RowResultSetNode)rsn);
        }
    }

    public void generate(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        SanityManager.ASSERT(this.all, "all expected to be true");
        this.assignResultSetNumber();
        this.costEstimate = this.getFinalCostEstimate();
        acb.pushGetResultSetFactoryExpression(mb);
        this.leftResultSet.generate(acb, mb);
        if (!this.resultColumns.isExactTypeAndLengthMatch(this.leftResultSet.getResultColumns())) {
            acb.pushGetResultSetFactoryExpression(mb);
            mb.swap();
            this.generateNormalizationResultSet(acb, mb, this.getCompilerContext().getNextResultSetNumber(), this.makeResultDescription());
        }
        this.rightResultSet.generate(acb, mb);
        if (!this.resultColumns.isExactTypeAndLengthMatch(this.rightResultSet.getResultColumns())) {
            acb.pushGetResultSetFactoryExpression(mb);
            mb.swap();
            this.generateNormalizationResultSet(acb, mb, this.getCompilerContext().getNextResultSetNumber(), this.makeResultDescription());
        }
        mb.push(this.resultSetNumber);
        mb.push(this.costEstimate.rowCount());
        mb.push(this.costEstimate.getEstimatedCost());
        mb.callMethod((short)185, null, "getUnionResultSet", "org.apache.derby.iapi.sql.execute.NoPutResultSet", 5);
    }

    public CostEstimate getFinalCostEstimate() throws StandardException {
        if (this.finalCostEstimate != null) {
            return this.finalCostEstimate;
        }
        CostEstimate leftCE = this.leftResultSet.getFinalCostEstimate();
        CostEstimate rightCE = this.rightResultSet.getFinalCostEstimate();
        this.finalCostEstimate = this.getNewCostEstimate();
        this.finalCostEstimate.setCost(leftCE.getEstimatedCost(), leftCE.rowCount(), leftCE.singleScanRowCount() + rightCE.singleScanRowCount());
        this.finalCostEstimate.add(rightCE, this.finalCostEstimate);
        return this.finalCostEstimate;
    }

    String getOperatorName() {
        return "UNION";
    }
}

