/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.BinaryOperatorNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;

public class TimestampOperatorNode
extends BinaryOperatorNode {
    public void init(Object date, Object time) {
        this.leftOperand = (ValueNode)date;
        this.rightOperand = (ValueNode)time;
        this.operator = "timestamp";
        this.methodName = "getTimestamp";
    }

    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector aggregateVector) throws StandardException {
        this.leftOperand = this.leftOperand.bindExpression(fromList, subqueryList, aggregateVector);
        this.rightOperand = this.rightOperand.bindExpression(fromList, subqueryList, aggregateVector);
        if (this.leftOperand.requiresTypeFromContext()) {
            this.leftOperand.setType(DataTypeDescriptor.getBuiltInDataTypeDescriptor(91));
        }
        if (this.rightOperand.requiresTypeFromContext()) {
            this.rightOperand.setType(DataTypeDescriptor.getBuiltInDataTypeDescriptor(92));
        }
        TypeId leftTypeId = this.leftOperand.getTypeId();
        TypeId rightTypeId = this.rightOperand.getTypeId();
        if (!this.leftOperand.requiresTypeFromContext() && !leftTypeId.isStringTypeId() && leftTypeId.getJDBCTypeId() != 91) {
            throw StandardException.newException("42Y95", (Object)this.operator, (Object)leftTypeId.getSQLTypeName(), (Object)rightTypeId.getSQLTypeName());
        }
        if (!this.rightOperand.requiresTypeFromContext() && !rightTypeId.isStringTypeId() && rightTypeId.getJDBCTypeId() != 92) {
            throw StandardException.newException("42Y95", (Object)this.operator, (Object)leftTypeId.getSQLTypeName(), (Object)rightTypeId.getSQLTypeName());
        }
        this.setType(DataTypeDescriptor.getBuiltInDataTypeDescriptor(93));
        return this.genSQLJavaSQLTree();
    }

    public void generateExpression(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        acb.pushDataValueFactory(mb);
        this.leftOperand.generateExpression(acb, mb);
        mb.cast("org.apache.derby.iapi.types.DataValueDescriptor");
        this.rightOperand.generateExpression(acb, mb);
        mb.cast("org.apache.derby.iapi.types.DataValueDescriptor");
        mb.callMethod((short)185, null, this.methodName, "org.apache.derby.iapi.types.DateTimeDataValue", 2);
    }
}

