/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.compile.TypeCompiler;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.iapi.util.ReuseFactory;
import org.apache.derby.impl.sql.compile.CastNode;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;

public class TernaryOperatorNode
extends ValueNode {
    String operator;
    String methodName;
    int operatorType;
    ValueNode receiver;
    ValueNode leftOperand;
    ValueNode rightOperand;
    String resultInterfaceType;
    String receiverInterfaceType;
    String leftInterfaceType;
    String rightInterfaceType;
    int trimType;
    public static final int TRIM = 0;
    public static final int LOCATE = 1;
    public static final int SUBSTRING = 2;
    public static final int LIKE = 3;
    public static final int TIMESTAMPADD = 4;
    public static final int TIMESTAMPDIFF = 5;
    static final String[] TernaryOperators = new String[]{"trim", "LOCATE", "substring", "like", "TIMESTAMPADD", "TIMESTAMPDIFF"};
    static final String[] TernaryMethodNames = new String[]{"ansiTrim", "locate", "substring", "like", "timestampAdd", "timestampDiff"};
    static final String[] TernaryResultType = new String[]{"org.apache.derby.iapi.types.StringDataValue", "org.apache.derby.iapi.types.NumberDataValue", "org.apache.derby.iapi.types.ConcatableDataValue", "org.apache.derby.iapi.types.BooleanDataValue", "org.apache.derby.iapi.types.DateTimeDataValue", "org.apache.derby.iapi.types.NumberDataValue"};
    static final String[][] TernaryArgType = new String[][]{{"org.apache.derby.iapi.types.StringDataValue", "org.apache.derby.iapi.types.StringDataValue", "java.lang.Integer"}, {"org.apache.derby.iapi.types.StringDataValue", "org.apache.derby.iapi.types.StringDataValue", "org.apache.derby.iapi.types.NumberDataValue"}, {"org.apache.derby.iapi.types.ConcatableDataValue", "org.apache.derby.iapi.types.NumberDataValue", "org.apache.derby.iapi.types.NumberDataValue"}, {"org.apache.derby.iapi.types.DataValueDescriptor", "org.apache.derby.iapi.types.DataValueDescriptor", "org.apache.derby.iapi.types.DataValueDescriptor"}, {"org.apache.derby.iapi.types.DateTimeDataValue", "java.lang.Integer", "org.apache.derby.iapi.types.NumberDataValue"}, {"org.apache.derby.iapi.types.DateTimeDataValue", "java.lang.Integer", "org.apache.derby.iapi.types.DateTimeDataValue"}};

    public void init(Object receiver, Object leftOperand, Object rightOperand, Object operatorType, Object trimType) {
        this.receiver = (ValueNode)receiver;
        this.leftOperand = (ValueNode)leftOperand;
        this.rightOperand = (ValueNode)rightOperand;
        this.operatorType = (Integer)operatorType;
        this.operator = TernaryOperators[this.operatorType];
        this.methodName = TernaryMethodNames[this.operatorType];
        this.resultInterfaceType = TernaryResultType[this.operatorType];
        this.receiverInterfaceType = TernaryArgType[this.operatorType][0];
        this.leftInterfaceType = TernaryArgType[this.operatorType][1];
        this.rightInterfaceType = TernaryArgType[this.operatorType][2];
        if (trimType != null) {
            this.trimType = (Integer)trimType;
        }
    }

    public String toString() {
        return "operator: " + this.operator + "\n" + "methodName: " + this.methodName + "\n" + "resultInterfaceType: " + this.resultInterfaceType + "\n" + "receiverInterfaceType: " + this.receiverInterfaceType + "\n" + "leftInterfaceType: " + this.leftInterfaceType + "\n" + "rightInterfaceType: " + this.rightInterfaceType + "\n" + super.toString();
    }

    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.receiver != null) {
            this.printLabel(depth, "receiver: ");
            this.receiver.treePrint(depth + 1);
        }
        if (this.leftOperand != null) {
            this.printLabel(depth, "leftOperand: ");
            this.leftOperand.treePrint(depth + 1);
        }
        if (this.rightOperand != null) {
            this.printLabel(depth, "rightOperand: ");
            this.rightOperand.treePrint(depth + 1);
        }
    }

    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector aggregateVector) throws StandardException {
        this.receiver = this.receiver.bindExpression(fromList, subqueryList, aggregateVector);
        this.leftOperand = this.leftOperand.bindExpression(fromList, subqueryList, aggregateVector);
        if (this.rightOperand != null) {
            this.rightOperand = this.rightOperand.bindExpression(fromList, subqueryList, aggregateVector);
        }
        if (this.operatorType == 0) {
            this.trimBind();
        } else if (this.operatorType == 1) {
            this.locateBind();
        } else if (this.operatorType == 2) {
            this.substrBind();
        } else if (this.operatorType == 4) {
            this.timestampAddBind();
        } else if (this.operatorType == 5) {
            this.timestampDiffBind();
        }
        return this;
    }

    public ValueNode preprocess(int numTables, FromList outerFromList, SubqueryList outerSubqueryList, PredicateList outerPredicateList) throws StandardException {
        this.receiver = this.receiver.preprocess(numTables, outerFromList, outerSubqueryList, outerPredicateList);
        this.leftOperand = this.leftOperand.preprocess(numTables, outerFromList, outerSubqueryList, outerPredicateList);
        if (this.rightOperand != null) {
            this.rightOperand = this.rightOperand.preprocess(numTables, outerFromList, outerSubqueryList, outerPredicateList);
        }
        return this;
    }

    public void generateExpression(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        int nargs = 0;
        String receiverType = null;
        LocalField field = acb.newFieldDeclaration(2, this.resultInterfaceType);
        this.receiver.generateExpression(acb, mb);
        if (this.operatorType == 0) {
            mb.push(this.trimType);
            this.leftOperand.generateExpression(acb, mb);
            mb.cast(this.leftInterfaceType);
            mb.getField(field);
            nargs = 3;
            receiverType = this.receiverInterfaceType;
        } else if (this.operatorType == 1) {
            this.leftOperand.generateExpression(acb, mb);
            mb.upCast(this.leftInterfaceType);
            this.rightOperand.generateExpression(acb, mb);
            mb.upCast(this.rightInterfaceType);
            mb.getField(field);
            nargs = 3;
        } else if (this.operatorType == 2) {
            this.leftOperand.generateExpression(acb, mb);
            mb.upCast(this.leftInterfaceType);
            if (this.rightOperand != null) {
                this.rightOperand.generateExpression(acb, mb);
                mb.upCast(this.rightInterfaceType);
            } else {
                mb.pushNull(this.rightInterfaceType);
            }
            mb.getField(field);
            mb.push(this.receiver.getTypeServices().getMaximumWidth());
            nargs = 4;
            receiverType = this.receiverInterfaceType;
        } else if (this.operatorType == 4 || this.operatorType == 5) {
            Object intervalType = this.leftOperand.getConstantValueAsObject();
            SanityManager.ASSERT(intervalType != null && intervalType instanceof Integer, "Invalid interval type used for " + this.operator);
            mb.push((Integer)intervalType);
            this.rightOperand.generateExpression(acb, mb);
            mb.upCast(TernaryArgType[this.operatorType][2]);
            acb.getCurrentDateExpression(mb);
            mb.getField(field);
            nargs = 4;
            receiverType = this.receiverInterfaceType;
        }
        mb.callMethod((short)185, receiverType, this.methodName, this.resultInterfaceType, nargs);
        mb.putField(field);
    }

    public void setLeftOperand(ValueNode newLeftOperand) {
        this.leftOperand = newLeftOperand;
    }

    public ValueNode getLeftOperand() {
        return this.leftOperand;
    }

    public void setRightOperand(ValueNode newRightOperand) {
        this.rightOperand = newRightOperand;
    }

    public ValueNode getRightOperand() {
        return this.rightOperand;
    }

    public boolean categorize(JBitSet referencedTabs, boolean simplePredsOnly) throws StandardException {
        boolean pushable = this.receiver.categorize(referencedTabs, simplePredsOnly);
        boolean bl = pushable = this.leftOperand.categorize(referencedTabs, simplePredsOnly) && pushable;
        if (this.rightOperand != null) {
            pushable = this.rightOperand.categorize(referencedTabs, simplePredsOnly) && pushable;
        }
        return pushable;
    }

    public ValueNode remapColumnReferencesToExpressions() throws StandardException {
        this.receiver = this.receiver.remapColumnReferencesToExpressions();
        this.leftOperand = this.leftOperand.remapColumnReferencesToExpressions();
        if (this.rightOperand != null) {
            this.rightOperand = this.rightOperand.remapColumnReferencesToExpressions();
        }
        return this;
    }

    public boolean isConstantExpression() {
        return this.receiver.isConstantExpression() && this.leftOperand.isConstantExpression() && (this.rightOperand == null || this.rightOperand.isConstantExpression());
    }

    public boolean constantExpression(PredicateList whereClause) {
        return this.receiver.constantExpression(whereClause) && this.leftOperand.constantExpression(whereClause) && (this.rightOperand == null || this.rightOperand.constantExpression(whereClause));
    }

    public Visitable accept(Visitor v) throws StandardException {
        Visitable returnNode = v.visit(this);
        if (v.skipChildren(this)) {
            return returnNode;
        }
        if (this.receiver != null && !v.stopTraversal()) {
            this.receiver = (ValueNode)this.receiver.accept(v);
        }
        if (this.leftOperand != null && !v.stopTraversal()) {
            this.leftOperand = (ValueNode)this.leftOperand.accept(v);
        }
        if (this.rightOperand != null && !v.stopTraversal()) {
            this.rightOperand = (ValueNode)this.rightOperand.accept(v);
        }
        return returnNode;
    }

    private ValueNode trimBind() throws StandardException {
        TypeId leftCTI;
        TypeId resultType = TypeId.getBuiltInTypeId(12);
        if (this.receiver.requiresTypeFromContext()) {
            this.receiver.setType(this.getVarcharDescriptor());
            if (!this.leftOperand.requiresTypeFromContext()) {
                this.receiver.getTypeServices().setCollationDerivation(this.leftOperand.getTypeServices().getCollationDerivation());
                this.receiver.getTypeServices().setCollationType(this.leftOperand.getTypeServices().getCollationType());
            } else {
                this.receiver.setCollationUsingCompilationSchema(1);
            }
        }
        if (this.leftOperand.requiresTypeFromContext()) {
            this.leftOperand.setType(this.getVarcharDescriptor());
            this.leftOperand.getTypeServices().setCollationDerivation(this.receiver.getTypeServices().getCollationDerivation());
            this.leftOperand.getTypeServices().setCollationType(this.receiver.getTypeServices().getCollationType());
        }
        this.bindToBuiltIn();
        TypeId receiverType = this.receiver.getTypeId();
        if (receiverType.userType()) {
            this.throwBadType("trim", receiverType.getSQLTypeName());
        }
        this.receiver = this.castArgToString(this.receiver);
        if (receiverType.getTypeFormatId() == 444 || receiverType.getTypeFormatId() == 448) {
            resultType = receiverType;
        }
        if ((leftCTI = this.leftOperand.getTypeId()).userType()) {
            this.throwBadType("trim", leftCTI.getSQLTypeName());
        }
        this.leftOperand = this.castArgToString(this.leftOperand);
        this.setResultType(resultType);
        this.getTypeServices().setCollationDerivation(this.receiver.getTypeServices().getCollationDerivation());
        this.getTypeServices().setCollationType(this.receiver.getTypeServices().getCollationType());
        return this;
    }

    private void setResultType(TypeId resultType) throws StandardException {
        this.setType(new DataTypeDescriptor(resultType, true, this.receiver.getTypeServices().getMaximumWidth()));
    }

    public ValueNode locateBind() throws StandardException {
        if (this.receiver.requiresTypeFromContext()) {
            if (this.leftOperand.requiresTypeFromContext()) {
                this.receiver.setType(this.getVarcharDescriptor());
                this.receiver.setCollationUsingCompilationSchema(1);
            } else if (this.leftOperand.getTypeId().isStringTypeId()) {
                this.receiver.setType(this.leftOperand.getTypeServices());
            }
        }
        if (this.leftOperand.requiresTypeFromContext()) {
            if (this.receiver.requiresTypeFromContext()) {
                this.leftOperand.setType(this.getVarcharDescriptor());
            } else if (this.receiver.getTypeId().isStringTypeId()) {
                this.leftOperand.setType(this.receiver.getTypeServices());
            }
            this.leftOperand.getTypeServices().setCollationDerivation(this.receiver.getTypeServices().getCollationDerivation());
            this.leftOperand.getTypeServices().setCollationType(this.receiver.getTypeServices().getCollationType());
        }
        if (this.rightOperand.requiresTypeFromContext()) {
            this.rightOperand.setType(new DataTypeDescriptor(TypeId.INTEGER_ID, true));
        }
        this.bindToBuiltIn();
        TypeId secondOperandType = this.leftOperand.getTypeId();
        TypeId offsetType = this.rightOperand.getTypeId();
        TypeId firstOperandType = this.receiver.getTypeId();
        if (!firstOperandType.isStringTypeId() || !secondOperandType.isStringTypeId() || offsetType.getJDBCTypeId() != 4) {
            throw StandardException.newException("42884", (Object)"LOCATE", (Object)"FUNCTION");
        }
        this.setType(new DataTypeDescriptor(TypeId.INTEGER_ID, this.receiver.getTypeServices().isNullable()));
        return this;
    }

    protected ValueNode castArgToString(ValueNode vn) throws StandardException {
        TypeCompiler vnTC = vn.getTypeCompiler();
        if (!vn.getTypeId().isStringTypeId()) {
            DataTypeDescriptor dtd = DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, true, vnTC.getCastToCharWidth(vn.getTypeServices()));
            dtd.setCollationType(this.getSchemaDescriptor(null).getCollationType());
            dtd.setCollationDerivation(1);
            ValueNode newNode = (ValueNode)this.getNodeFactory().getNode(60, vn, dtd, this.getContextManager());
            ((CastNode)newNode).bindCastNodeOnly();
            return newNode;
        }
        return vn;
    }

    public ValueNode substrBind() throws StandardException {
        TypeId resultType = TypeId.getBuiltInTypeId(12);
        if (this.receiver.requiresTypeFromContext()) {
            this.receiver.setType(this.getVarcharDescriptor());
            this.receiver.setCollationUsingCompilationSchema(1);
        }
        if (this.leftOperand.requiresTypeFromContext()) {
            this.leftOperand.setType(new DataTypeDescriptor(TypeId.INTEGER_ID, true));
        }
        if (this.rightOperand != null && this.rightOperand.requiresTypeFromContext()) {
            this.rightOperand.setType(new DataTypeDescriptor(TypeId.INTEGER_ID, true));
        }
        this.bindToBuiltIn();
        if (!this.leftOperand.getTypeId().isNumericTypeId() || this.rightOperand != null && !this.rightOperand.getTypeId().isNumericTypeId()) {
            throw StandardException.newException("42884", (Object)"SUBSTR", (Object)"FUNCTION");
        }
        TypeId receiverType = this.receiver.getTypeId();
        switch (receiverType.getJDBCTypeId()) {
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                break;
            }
            default: {
                this.throwBadType("SUBSTR", receiverType.getSQLTypeName());
            }
        }
        if (receiverType.getTypeFormatId() == 444 || receiverType.getTypeFormatId() == 448) {
            resultType = receiverType;
        }
        int resultLen = this.receiver.getTypeServices().getMaximumWidth();
        if (this.rightOperand != null && this.rightOperand instanceof ConstantNode && ((ConstantNode)this.rightOperand).getValue().getInt() < resultLen) {
            resultLen = ((ConstantNode)this.rightOperand).getValue().getInt();
        }
        this.setType(new DataTypeDescriptor(resultType, true, resultLen));
        this.getTypeServices().setCollationDerivation(this.receiver.getTypeServices().getCollationDerivation());
        this.getTypeServices().setCollationType(this.receiver.getTypeServices().getCollationType());
        return this;
    }

    private ValueNode timestampAddBind() throws StandardException {
        int jdbcType;
        if (!this.bindParameter(this.rightOperand, 4) && (jdbcType = this.rightOperand.getTypeId().getJDBCTypeId()) != -6 && jdbcType != 5 && jdbcType != 4 && jdbcType != -5) {
            throw StandardException.newException("42X45", (Object)this.rightOperand.getTypeId().getSQLTypeName(), (Object)ReuseFactory.getInteger(2), (Object)this.operator);
        }
        this.bindDateTimeArg(this.receiver, 3);
        this.setType(DataTypeDescriptor.getBuiltInDataTypeDescriptor(93));
        return this;
    }

    private ValueNode timestampDiffBind() throws StandardException {
        this.bindDateTimeArg(this.rightOperand, 2);
        this.bindDateTimeArg(this.receiver, 3);
        this.setType(DataTypeDescriptor.getBuiltInDataTypeDescriptor(-5));
        return this;
    }

    private void bindDateTimeArg(ValueNode arg, int argNumber) throws StandardException {
        if (!this.bindParameter(arg, 93) && !arg.getTypeId().isDateTimeTimeStampTypeId()) {
            throw StandardException.newException("42X45", (Object)arg.getTypeId().getSQLTypeName(), (Object)ReuseFactory.getInteger(argNumber), (Object)this.operator);
        }
    }

    private boolean bindParameter(ValueNode arg, int jdbcType) throws StandardException {
        if (arg.requiresTypeFromContext() && arg.getTypeId() == null) {
            arg.setType(new DataTypeDescriptor(TypeId.getBuiltInTypeId(jdbcType), true));
            return true;
        }
        return false;
    }

    public ValueNode getReceiver() {
        return this.receiver;
    }

    private void throwBadType(String funcName, String type) throws StandardException {
        throw StandardException.newException("42X25", (Object)funcName, (Object)type);
    }

    protected void bindToBuiltIn() throws StandardException {
        if (this.receiver.getTypeId().userType()) {
            this.receiver = this.receiver.genSQLJavaSQLTree();
        }
        if (this.leftOperand.getTypeId().userType()) {
            this.leftOperand = this.leftOperand.genSQLJavaSQLTree();
        }
        if (this.rightOperand != null && this.rightOperand.getTypeId().userType()) {
            this.rightOperand = this.rightOperand.genSQLJavaSQLTree();
        }
    }

    private DataTypeDescriptor getVarcharDescriptor() {
        return new DataTypeDescriptor(TypeId.getBuiltInTypeId(12), true);
    }

    protected boolean isEquivalent(ValueNode o) throws StandardException {
        if (this.isSameNodeType(o)) {
            TernaryOperatorNode other = (TernaryOperatorNode)o;
            return other.methodName.equals(this.methodName) && other.receiver.isEquivalent(this.receiver) && other.leftOperand.isEquivalent(this.leftOperand) && (this.rightOperand == null && other.rightOperand == null || other.rightOperand != null && other.rightOperand.isEquivalent(this.rightOperand));
        }
        return false;
    }
}

