/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Hashtable;
import java.util.Vector;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.depend.ProviderInfo;
import org.apache.derby.iapi.sql.depend.ProviderList;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptorList;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.impl.sql.compile.ColumnDefinitionNode;
import org.apache.derby.impl.sql.compile.ConstraintDefinitionNode;
import org.apache.derby.impl.sql.compile.CreateTableNode;
import org.apache.derby.impl.sql.compile.DDLStatementNode;
import org.apache.derby.impl.sql.compile.FKConstraintDefinitionNode;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.ModifyColumnNode;
import org.apache.derby.impl.sql.compile.QueryTreeNodeVector;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.TableElementNode;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.execute.ColumnInfo;
import org.apache.derby.impl.sql.execute.ConstraintConstantAction;
import org.apache.derby.impl.sql.execute.ConstraintInfo;
import org.apache.derby.impl.sql.execute.IndexConstantAction;

public class TableElementList
extends QueryTreeNodeVector {
    private int numColumns;
    private TableDescriptor td;

    public void addTableElement(TableElementNode tableElement) {
        this.addElement(tableElement);
        if (tableElement instanceof ColumnDefinitionNode || tableElement.getElementType() == 7) {
            ++this.numColumns;
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("");
        for (int index = 0; index < this.size(); ++index) {
            buffer.append(this.elementAt(index).toString()).append("\n");
        }
        return buffer.toString();
    }

    void setCollationTypesOnCharacterStringColumns(SchemaDescriptor sd) {
        int size = this.size();
        int collationType = sd.getCollationType();
        for (int index = 0; index < size; ++index) {
            ColumnDefinitionNode cdn;
            TableElementNode tableElement = (TableElementNode)this.elementAt(index);
            if (!(tableElement instanceof ColumnDefinitionNode) || !(cdn = (ColumnDefinitionNode)this.elementAt(index)).getDataTypeServices().getTypeId().isStringTypeId()) continue;
            cdn.getDataTypeServices().setCollationType(collationType);
            cdn.getDataTypeServices().setCollationDerivation(1);
        }
    }

    void validate(DDLStatementNode ddlStmt, DataDictionary dd, TableDescriptor td) throws StandardException {
        ConstraintDescriptorList cdl;
        this.td = td;
        int numAutoCols = 0;
        int size = this.size();
        Hashtable columnHT = new Hashtable(size + 2, 0.999f);
        Hashtable constraintHT = new Hashtable(size + 2, 0.999f);
        Vector<Object> constraintsVector = new Vector<Object>();
        if (td != null && (cdl = dd.getConstraintDescriptors(td)) != null) {
            for (int i = 0; i < cdl.size(); ++i) {
                ConstraintDescriptor cd = cdl.elementAt(i);
                if (cd.getConstraintType() != 2 && cd.getConstraintType() != 3) continue;
                constraintsVector.addElement(cd);
            }
        }
        int tableType = 0;
        if (ddlStmt instanceof CreateTableNode) {
            tableType = ((CreateTableNode)ddlStmt).tableType;
        }
        for (int index = 0; index < size; ++index) {
            String dropConstraintName;
            TableElementNode cdn;
            TableElementNode tableElement = (TableElementNode)this.elementAt(index);
            if (tableElement instanceof ColumnDefinitionNode) {
                cdn = (ColumnDefinitionNode)this.elementAt(index);
                if (tableType == 3 && (((ColumnDefinitionNode)cdn).getDataTypeServices().getTypeId().isLongConcatableTypeId() || ((ColumnDefinitionNode)cdn).getDataTypeServices().getTypeId().isUserDefinedTypeId())) {
                    throw StandardException.newException("42962", ((ColumnDefinitionNode)cdn).getColumnName());
                }
                this.checkForDuplicateColumns(ddlStmt, columnHT, ((ColumnDefinitionNode)cdn).getColumnName());
                ((ColumnDefinitionNode)cdn).checkUserType(td);
                ((ColumnDefinitionNode)cdn).bindAndValidateDefault(dd, td);
                ((ColumnDefinitionNode)cdn).validateAutoincrement(dd, td, tableType);
                if (tableElement instanceof ModifyColumnNode) {
                    ModifyColumnNode mcdn = (ModifyColumnNode)cdn;
                    mcdn.checkExistingConstraints(td);
                    mcdn.useExistingCollation(td);
                } else if (((ColumnDefinitionNode)cdn).isAutoincrementColumn()) {
                    ++numAutoCols;
                }
            } else if (tableElement.getElementType() == 7) {
                String colName = tableElement.getName();
                if (td.getColumnDescriptor(colName) != null) break;
                throw StandardException.newException("42X14", (Object)colName, (Object)td.getQualifiedName());
            }
            if (!tableElement.hasConstraint()) continue;
            cdn = (ConstraintDefinitionNode)tableElement;
            ((ConstraintDefinitionNode)cdn).bind(ddlStmt, dd);
            if (((ConstraintDefinitionNode)cdn).getConstraintType() == 2 || ((ConstraintDefinitionNode)cdn).getConstraintType() == 3) {
                String destName = null;
                String[] destColumnNames = null;
                for (int i = 0; i < constraintsVector.size(); ++i) {
                    Object destConstraint = constraintsVector.elementAt(i);
                    if (destConstraint instanceof ConstraintDefinitionNode) {
                        ConstraintDefinitionNode destCDN = (ConstraintDefinitionNode)destConstraint;
                        destName = destCDN.getConstraintMoniker();
                        destColumnNames = destCDN.getColumnList().getColumnNames();
                    } else if (destConstraint instanceof ConstraintDescriptor) {
                        ConstraintDescriptor destCD = (ConstraintDescriptor)destConstraint;
                        destName = destCD.getConstraintName();
                        destColumnNames = destCD.getColumnDescriptors().getColumnNames();
                    }
                    if (!this.columnsMatch(((ConstraintDefinitionNode)cdn).getColumnList().getColumnNames(), destColumnNames)) continue;
                    throw StandardException.newException("42Z93", (Object)((ConstraintDefinitionNode)cdn).getConstraintMoniker(), (Object)destName);
                }
                constraintsVector.addElement(cdn);
            }
            if (cdn instanceof ConstraintDefinitionNode) {
                this.checkForDuplicateConstraintNames(ddlStmt, constraintHT, ((ConstraintDefinitionNode)cdn).getConstraintMoniker());
            }
            if (((ConstraintDefinitionNode)cdn).getConstraintType() == 5 && (dropConstraintName = ((ConstraintDefinitionNode)cdn).getConstraintMoniker()) != null) {
                String dropSchemaName = ((ConstraintDefinitionNode)cdn).getDropSchemaName();
                SchemaDescriptor sd = dropSchemaName == null ? td.getSchemaDescriptor() : this.getSchemaDescriptor(dropSchemaName);
                ConstraintDescriptor cd = dd.getConstraintDescriptorByName(td, sd, dropConstraintName, false);
                if (cd == null) {
                    throw StandardException.newException("42X86", (Object)(sd.getSchemaName() + "." + dropConstraintName), (Object)td.getQualifiedName());
                }
                this.getCompilerContext().createDependency(cd);
            }
            if (((ConstraintDefinitionNode)cdn).hasPrimaryKeyConstraint()) {
                this.verifyUniqueColumnList(ddlStmt, (ConstraintDefinitionNode)cdn);
                if (td == null) {
                    this.setColumnListToNotNull((ConstraintDefinitionNode)cdn);
                    continue;
                }
                this.checkForNullColumns((ConstraintDefinitionNode)cdn, td);
                continue;
            }
            if (((ConstraintDefinitionNode)cdn).hasUniqueKeyConstraint()) {
                this.verifyUniqueColumnList(ddlStmt, (ConstraintDefinitionNode)cdn);
                this.checkForNullColumns((ConstraintDefinitionNode)cdn, td);
                continue;
            }
            if (!((ConstraintDefinitionNode)cdn).hasForeignKeyConstraint()) continue;
            this.verifyUniqueColumnList(ddlStmt, (ConstraintDefinitionNode)cdn);
        }
        if (numAutoCols > 1) {
            throw StandardException.newException("428C1");
        }
    }

    public int countConstraints(int constraintType) {
        int numConstraints = 0;
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ConstraintDefinitionNode cdn;
            TableElementNode element = (TableElementNode)this.elementAt(index);
            if (!(element instanceof ConstraintDefinitionNode) || constraintType != (cdn = (ConstraintDefinitionNode)element).getConstraintType()) continue;
            ++numConstraints;
        }
        return numConstraints;
    }

    public int countNumberOfColumns() {
        return this.numColumns;
    }

    public int genColumnInfos(ColumnInfo[] colInfos) {
        int numConstraints = 0;
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            if (((TableElementNode)this.elementAt(index)).getElementType() == 7) {
                colInfos[index] = new ColumnInfo(((TableElementNode)this.elementAt(index)).getName(), null, null, null, null, null, 1, 0L, 0L, 0L);
                break;
            }
            if (!(this.elementAt(index) instanceof ColumnDefinitionNode)) {
                SanityManager.ASSERT(this.elementAt(index) instanceof ConstraintDefinitionNode, "elementAt(index) expected to be instanceof ConstraintDefinitionNode");
                ++numConstraints;
                continue;
            }
            ColumnDefinitionNode coldef = (ColumnDefinitionNode)this.elementAt(index);
            colInfos[index - numConstraints] = new ColumnInfo(coldef.getColumnName(), coldef.getDataTypeServices(), coldef.getDefaultValue(), coldef.getDefaultInfo(), null, coldef.getOldDefaultUUID(), coldef.getAction(), coldef.isAutoincrementColumn() ? coldef.getAutoincrementStart() : 0L, coldef.isAutoincrementColumn() ? coldef.getAutoincrementIncrement() : 0L, coldef.isAutoincrementColumn() ? coldef.getAutoinc_create_or_modify_Start_Increment() : -1L);
            if (!coldef.hasConstraint()) continue;
            ++numConstraints;
        }
        return numConstraints;
    }

    public void appendNewColumnsToRCL(FromBaseTable table) throws StandardException {
        int size = this.size();
        ResultColumnList rcl = table.getResultColumns();
        TableName exposedName = table.getTableName();
        for (int index = 0; index < size; ++index) {
            if (!(this.elementAt(index) instanceof ColumnDefinitionNode)) continue;
            ColumnDefinitionNode cdn = (ColumnDefinitionNode)this.elementAt(index);
            ValueNode valueNode = (ValueNode)this.getNodeFactory().getNode(94, cdn.getColumnName(), exposedName, cdn.getDataTypeServices(), this.getContextManager());
            ResultColumn resultColumn = (ResultColumn)this.getNodeFactory().getNode(80, cdn.getDataTypeServices(), valueNode, this.getContextManager());
            resultColumn.setName(cdn.getColumnName());
            rcl.addElement(resultColumn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void bindAndValidateCheckConstraints(FromList fromList) throws StandardException {
        FromBaseTable table = (FromBaseTable)fromList.elementAt(0);
        int size = this.size();
        CompilerContext cc = this.getCompilerContext();
        Vector aggregateVector = new Vector();
        for (int index = 0; index < size; ++index) {
            ConstraintDefinitionNode cdn;
            TableElementNode element = (TableElementNode)this.elementAt(index);
            if (!(element instanceof ConstraintDefinitionNode) || (cdn = (ConstraintDefinitionNode)element).getConstraintType() != 4) continue;
            ValueNode checkTree = cdn.getCheckCondition();
            int previousReliability = cc.getReliability();
            try {
                ProviderList apl = new ProviderList();
                ProviderList prevAPL = cc.getCurrentAuxiliaryProviderList();
                cc.setCurrentAuxiliaryProviderList(apl);
                cc.setReliability(1657);
                checkTree = checkTree.bindExpression(fromList, null, aggregateVector);
                if (aggregateVector.size() != 0) {
                    throw StandardException.newException("42Y01", cdn.getConstraintText());
                }
                checkTree = checkTree.checkIsBoolean();
                cdn.setCheckCondition(checkTree);
                if (apl.size() > 0) {
                    cdn.setAuxiliaryProviderList(apl);
                }
                cc.setCurrentAuxiliaryProviderList(prevAPL);
            }
            finally {
                cc.setReliability(previousReliability);
            }
            ResultColumnList rcl = table.getResultColumns();
            int numReferenced = rcl.countReferencedColumns();
            int[] checkColumnReferences = new int[numReferenced];
            rcl.recordColumnReferences(checkColumnReferences, 1);
            cdn.setCheckColumnReferences(checkColumnReferences);
            ResultColumnList refRCL = (ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager());
            rcl.copyReferencedColumnsToNewList(refRCL);
            if (cdn.getColumnList() != null) {
                String colName = ((ResultColumn)cdn.getColumnList().elementAt(0)).getName();
                if (numReferenced > 1 || !colName.equals(((ResultColumn)refRCL.elementAt(0)).getName())) {
                    throw StandardException.newException("42621", colName);
                }
            }
            cdn.setColumnList(refRCL);
            rcl.clearColumnReferences();
        }
    }

    void genConstraintActions(ConstraintConstantAction[] conActions, String tableName, SchemaDescriptor tableSd, DataDictionary dd) throws StandardException {
        int size = this.size();
        int conActionIndex = 0;
        for (int index = 0; index < size; ++index) {
            String[] columnNames = null;
            TableElementNode ten = (TableElementNode)this.elementAt(index);
            IndexConstantAction indexAction = null;
            if (!ten.hasConstraint() || ten instanceof ColumnDefinitionNode) continue;
            ConstraintDefinitionNode constraintDN = (ConstraintDefinitionNode)ten;
            if (constraintDN.getColumnList() != null) {
                columnNames = new String[constraintDN.getColumnList().size()];
                constraintDN.getColumnList().exportNames(columnNames);
            }
            int constraintType = constraintDN.getConstraintType();
            String constraintText = constraintDN.getConstraintText();
            String constraintName = constraintDN.getConstraintMoniker();
            if (constraintDN.requiresBackingIndex()) {
                indexAction = this.genIndexAction(constraintDN.requiresUniqueIndex(), null, constraintDN, columnNames, true, tableSd, tableName, constraintType, dd);
            }
            if (constraintType == 5) {
                conActions[conActionIndex] = this.getGenericConstantActionFactory().getDropConstraintConstantAction(constraintName, constraintDN.getDropSchemaName(), tableName, this.td.getUUID(), tableSd.getSchemaName(), indexAction, constraintDN.getDropBehavior(), constraintDN.getVerifyType());
                continue;
            }
            ProviderList apl = constraintDN.getAuxiliaryProviderList();
            ConstraintInfo refInfo = null;
            ProviderInfo[] providerInfos = null;
            if (constraintDN instanceof FKConstraintDefinitionNode) {
                refInfo = ((FKConstraintDefinitionNode)constraintDN).getReferencedConstraintInfo();
            }
            if (apl != null && apl.size() > 0) {
                DependencyManager dm = dd.getDependencyManager();
                providerInfos = dm.getPersistentProviderInfos(apl);
            } else {
                providerInfos = new ProviderInfo[]{};
            }
            conActions[conActionIndex++] = this.getGenericConstantActionFactory().getCreateConstraintConstantAction(constraintName, constraintType, tableName, this.td != null ? this.td.getUUID() : (UUID)null, tableSd.getSchemaName(), columnNames, indexAction, constraintText, true, refInfo, providerInfos);
        }
    }

    private boolean columnsMatch(String[] columnNames1, String[] columnNames2) {
        boolean match = true;
        if (columnNames1.length != columnNames2.length) {
            return false;
        }
        int srcSize = columnNames1.length;
        int destSize = columnNames2.length;
        for (int srcCount = 0; srcCount < srcSize; ++srcCount) {
            match = false;
            for (int destCount = 0; destCount < destSize; ++destCount) {
                if (!columnNames1[srcCount].equals(columnNames2[destCount])) continue;
                match = true;
                break;
            }
            if (match) continue;
            return false;
        }
        return true;
    }

    private IndexConstantAction genIndexAction(boolean isUnique, String indexName, ConstraintDefinitionNode cdn, String[] columnNames, boolean isConstraint, SchemaDescriptor sd, String tableName, int constraintType, DataDictionary dd) throws StandardException {
        if (indexName == null) {
            indexName = cdn.getBackingIndexName(dd);
        }
        if (constraintType == 5) {
            return this.getGenericConstantActionFactory().getDropIndexConstantAction(null, indexName, tableName, sd.getSchemaName(), this.td.getUUID(), this.td.getHeapConglomerateId());
        }
        boolean[] isAscending = new boolean[columnNames.length];
        for (int i = 0; i < isAscending.length; ++i) {
            isAscending[i] = true;
        }
        return this.getGenericConstantActionFactory().getCreateIndexConstantAction(isUnique, "BTREE", sd.getSchemaName(), indexName, tableName, this.td != null ? this.td.getUUID() : (UUID)null, columnNames, isAscending, isConstraint, cdn.getBackingIndexUUID(), cdn.getProperties());
    }

    private void checkForDuplicateColumns(DDLStatementNode ddlStmt, Hashtable ht, String colName) throws StandardException {
        String object = ht.put(colName, colName);
        if (object != null && ddlStmt instanceof CreateTableNode) {
            throw StandardException.newException("42X12", colName);
        }
    }

    private void checkForDuplicateConstraintNames(DDLStatementNode ddlStmt, Hashtable ht, String constraintName) throws StandardException {
        if (constraintName == null) {
            return;
        }
        String object = ht.put(constraintName, constraintName);
        if (object != null && ddlStmt instanceof CreateTableNode) {
            throw StandardException.newException("42X91", constraintName);
        }
    }

    private void verifyUniqueColumnList(DDLStatementNode ddlStmt, ConstraintDefinitionNode cdn) throws StandardException {
        String invalidColName;
        if (ddlStmt instanceof CreateTableNode && (invalidColName = cdn.getColumnList().verifyCreateConstraintColumnList(this)) != null) {
            throw StandardException.newException("42X93", (Object)ddlStmt.getRelativeName(), (Object)invalidColName);
        }
        invalidColName = cdn.getColumnList().verifyUniqueNames(false);
        if (invalidColName != null) {
            throw StandardException.newException("42X92", invalidColName);
        }
    }

    private void setColumnListToNotNull(ConstraintDefinitionNode cdn) {
        ResultColumnList rcl = cdn.getColumnList();
        int rclSize = rcl.size();
        for (int index = 0; index < rclSize; ++index) {
            String colName = ((ResultColumn)rcl.elementAt(index)).getName();
            DataTypeDescriptor dtd = this.getColumnDataTypeDescriptor(colName);
            dtd.setNullability(false);
        }
    }

    private void checkForNullColumns(ConstraintDefinitionNode cdn, TableDescriptor td) throws StandardException {
        ResultColumnList rcl = cdn.getColumnList();
        int rclSize = rcl.size();
        for (int index = 0; index < rclSize; ++index) {
            String colName = ((ResultColumn)rcl.elementAt(index)).getName();
            DataTypeDescriptor dtd = td == null ? this.getColumnDataTypeDescriptor(colName) : this.getColumnDataTypeDescriptor(colName, td);
            if (dtd == null || !dtd.isNullable()) continue;
            throw StandardException.newException("42831", colName);
        }
    }

    private DataTypeDescriptor getColumnDataTypeDescriptor(String colName) {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ColumnDefinitionNode cdn;
            TableElementNode tableElement = (TableElementNode)this.elementAt(index);
            if (!(tableElement instanceof ColumnDefinitionNode) || !colName.equals((cdn = (ColumnDefinitionNode)tableElement).getColumnName())) continue;
            return cdn.getDataTypeServices();
        }
        return null;
    }

    private DataTypeDescriptor getColumnDataTypeDescriptor(String colName, TableDescriptor td) {
        ColumnDescriptor cd = td.getColumnDescriptor(colName);
        if (cd != null) {
            return cd.getType();
        }
        return this.getColumnDataTypeDescriptor(colName);
    }

    public boolean containsColumnName(String colName) {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            TableElementNode tableElement = (TableElementNode)this.elementAt(index);
            if (!(tableElement instanceof ColumnDefinitionNode) || !colName.equals(((ColumnDefinitionNode)tableElement).getName())) continue;
            return true;
        }
        return false;
    }
}

