/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;

public class SpecialFunctionNode
extends ValueNode {
    String sqlName;
    private String methodName;
    private String methodType;

    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector aggregateVector) throws StandardException {
        DataTypeDescriptor dtd;
        int nodeType = this.getNodeType();
        switch (nodeType) {
            case 109: 
            case 110: 
            case 125: 
            case 126: {
                switch (nodeType) {
                    case 110: {
                        this.sqlName = "USER";
                        break;
                    }
                    case 109: {
                        this.sqlName = "CURRENT_USER";
                        break;
                    }
                    case 125: {
                        this.sqlName = "SESSION_USER";
                        break;
                    }
                    case 126: {
                        this.sqlName = "SYSTEM_USER";
                    }
                }
                this.methodName = "getAuthorizationId";
                this.methodType = "java.lang.String";
                dtd = DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, false, 128);
                dtd.setCollationDerivation(1);
                dtd.setCollationType(0);
                break;
            }
            case 6: {
                this.sqlName = "CURRENT SCHEMA";
                this.methodName = "getCurrentSchemaName";
                this.methodType = "java.lang.String";
                dtd = DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, false, 128);
                dtd.setCollationDerivation(1);
                dtd.setCollationType(0);
                break;
            }
            case 5: {
                this.sqlName = "IDENTITY_VAL_LOCAL";
                this.methodName = "getIdentityValue";
                this.methodType = "java.lang.Long";
                dtd = DataTypeDescriptor.getSQLDataTypeDescriptor("java.math.BigDecimal", 31, 0, true, 31);
                break;
            }
            case 4: {
                this.sqlName = "CURRENT ISOLATION";
                this.methodName = "getCurrentIsolationLevelStr";
                this.methodType = "java.lang.String";
                dtd = DataTypeDescriptor.getBuiltInDataTypeDescriptor(1, 2);
                dtd.setCollationDerivation(1);
                dtd.setCollationType(0);
                break;
            }
            default: {
                SanityManager.THROWASSERT("Invalid type for SpecialFunctionNode " + nodeType);
                dtd = null;
            }
        }
        this.checkReliability(this.sqlName, 64);
        this.setType(dtd);
        return this;
    }

    protected int getOrderableVariantType() {
        return 2;
    }

    public void generateExpression(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        mb.pushThis();
        mb.callMethod((short)185, "org.apache.derby.iapi.sql.Activation", "getLanguageConnectionContext", "org.apache.derby.iapi.sql.conn.LanguageConnectionContext", 0);
        mb.callMethod((short)185, null, this.methodName, this.methodType, 0);
        String fieldType = this.getTypeCompiler().interfaceName();
        LocalField field = acb.newFieldDeclaration(2, fieldType);
        acb.generateDataValue(mb, this.getTypeCompiler(), this.getTypeServices().getCollationType(), field);
    }

    public String toString() {
        return super.toString() + this.sqlName;
    }

    protected boolean isEquivalent(ValueNode o) {
        if (this.isSameNodeType(o)) {
            SpecialFunctionNode other = (SpecialFunctionNode)o;
            return this.methodName.equals(other.methodName);
        }
        return false;
    }
}

