/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.compile.AccessPath;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.OptimizablePredicateList;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.GroupByList;
import org.apache.derby.impl.sql.compile.Predicate;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;

abstract class SingleChildResultSetNode
extends FromTable {
    ResultSetNode childResult;
    protected boolean hasTrulyTheBestAccessPath;

    SingleChildResultSetNode() {
    }

    public void init(Object childResult, Object tableProperties) {
        super.init(null, tableProperties);
        this.childResult = (ResultSetNode)childResult;
        if (this.childResult.getReferencedTableMap() != null) {
            this.referencedTableMap = (JBitSet)this.childResult.getReferencedTableMap().clone();
        }
    }

    public AccessPath getTrulyTheBestAccessPath() {
        if (this.hasTrulyTheBestAccessPath) {
            return super.getTrulyTheBestAccessPath();
        }
        if (this.childResult instanceof Optimizable) {
            return ((Optimizable)((Object)this.childResult)).getTrulyTheBestAccessPath();
        }
        return super.getTrulyTheBestAccessPath();
    }

    public ResultSetNode getChildResult() {
        return this.childResult;
    }

    void setChildResult(ResultSetNode childResult) {
        this.childResult = childResult;
    }

    public void pullOptPredicates(OptimizablePredicateList optimizablePredicates) throws StandardException {
        if (this.childResult instanceof Optimizable) {
            ((Optimizable)((Object)this.childResult)).pullOptPredicates(optimizablePredicates);
        }
    }

    public boolean forUpdate() {
        if (this.childResult instanceof Optimizable) {
            return ((Optimizable)((Object)this.childResult)).forUpdate();
        }
        return super.forUpdate();
    }

    public void initAccessPaths(Optimizer optimizer) {
        super.initAccessPaths(optimizer);
        if (this.childResult instanceof Optimizable) {
            ((Optimizable)((Object)this.childResult)).initAccessPaths(optimizer);
        }
    }

    public void updateBestPlanMap(short action, Object planKey) throws StandardException {
        super.updateBestPlanMap(action, planKey);
        if (this.childResult instanceof Optimizable) {
            ((Optimizable)((Object)this.childResult)).updateBestPlanMap(action, planKey);
        } else if (this.childResult.getOptimizerImpl() != null) {
            this.childResult.getOptimizerImpl().updateBestPlanMaps(action, planKey);
        }
    }

    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.childResult != null) {
            this.printLabel(depth, "childResult: ");
            this.childResult.treePrint(depth + 1);
        }
    }

    public boolean referencesTarget(String name, boolean baseTable) throws StandardException {
        return this.childResult.referencesTarget(name, baseTable);
    }

    public boolean referencesSessionSchema() throws StandardException {
        return this.childResult.referencesSessionSchema();
    }

    public void setLevel(int level) {
        super.setLevel(level);
        if (this.childResult instanceof FromTable) {
            ((FromTable)this.childResult).setLevel(level);
        }
    }

    boolean subqueryReferencesTarget(String name, boolean baseTable) throws StandardException {
        return this.childResult.subqueryReferencesTarget(name, baseTable);
    }

    public ResultSetNode preprocess(int numTables, GroupByList gbl, FromList fromList) throws StandardException {
        this.childResult = this.childResult.preprocess(numTables, gbl, fromList);
        this.referencedTableMap = (JBitSet)this.childResult.getReferencedTableMap().clone();
        return this;
    }

    public ResultSetNode addNewPredicate(Predicate predicate) throws StandardException {
        this.childResult = this.childResult.addNewPredicate(predicate);
        return this;
    }

    public void pushExpressions(PredicateList predicateList) throws StandardException {
        if (this.childResult instanceof FromTable) {
            ((FromTable)this.childResult).pushExpressions(predicateList);
        }
    }

    public boolean flattenableInFromSubquery(FromList fromList) {
        return false;
    }

    public ResultSetNode ensurePredicateList(int numTables) throws StandardException {
        return this;
    }

    public ResultSetNode optimize(DataDictionary dataDictionary, PredicateList predicates, double outerRows) throws StandardException {
        this.childResult = this.childResult.optimize(dataDictionary, predicates, outerRows);
        Optimizer optimizer = this.getOptimizer((FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager()), predicates, dataDictionary, null);
        this.costEstimate = optimizer.newCostEstimate();
        this.costEstimate.setCost(this.childResult.getCostEstimate().getEstimatedCost(), this.childResult.getCostEstimate().rowCount(), this.childResult.getCostEstimate().singleScanRowCount());
        return this;
    }

    public ResultSetNode modifyAccessPaths() throws StandardException {
        this.childResult = this.childResult.modifyAccessPaths();
        return this;
    }

    public ResultSetNode changeAccessPath() throws StandardException {
        this.childResult = this.childResult.changeAccessPath();
        return this;
    }

    protected FromTable getFromTableByName(String name, String schemaName, boolean exactMatch) throws StandardException {
        return this.childResult.getFromTableByName(name, schemaName, exactMatch);
    }

    void decrementLevel(int decrement) {
        super.decrementLevel(decrement);
        this.childResult.decrementLevel(decrement);
    }

    public int updateTargetLockMode() {
        return this.childResult.updateTargetLockMode();
    }

    boolean isOrderedOn(ColumnReference[] crs, boolean permuteOrdering, Vector fbtVector) throws StandardException {
        return this.childResult.isOrderedOn(crs, permuteOrdering, fbtVector);
    }

    public boolean isOneRowResultSet() throws StandardException {
        return this.childResult.isOneRowResultSet();
    }

    public boolean isNotExists() {
        return this.childResult.isNotExists();
    }

    protected boolean reflectionNeededForProjection() {
        return !this.resultColumns.allExpressionsAreColumns(this.childResult);
    }

    void replaceDefaults(TableDescriptor ttd, ResultColumnList tcl) throws StandardException {
        this.childResult.replaceDefaults(ttd, tcl);
    }

    void adjustForSortElimination() {
        this.childResult.adjustForSortElimination();
    }

    public CostEstimate getFinalCostEstimate() throws StandardException {
        if (this.costEstimate == null) {
            return this.childResult.getFinalCostEstimate();
        }
        return this.costEstimate;
    }

    public Visitable accept(Visitor v) throws StandardException {
        if (v.skipChildren(this)) {
            return v.visit(this);
        }
        Visitable returnNode = super.accept(v);
        if (this.childResult != null && !v.stopTraversal()) {
            this.childResult = (ResultSetNode)this.childResult.accept(v);
        }
        return returnNode;
    }
}

