/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.CastNode;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.UnaryOperatorNode;
import org.apache.derby.impl.sql.compile.ValueNode;

public class SimpleStringOperatorNode
extends UnaryOperatorNode {
    public void init(Object operand, Object methodName) {
        super.init(operand, methodName, methodName);
    }

    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector aggregateVector) throws StandardException {
        this.bindOperand(fromList, subqueryList, aggregateVector);
        TypeId operandType = this.operand.getTypeId();
        switch (operandType.getJDBCTypeId()) {
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                break;
            }
            case 1111: 
            case 2000: {
                throw StandardException.newException("42X25", (Object)this.methodName, (Object)operandType.getSQLTypeName());
            }
            default: {
                DataTypeDescriptor dtd = DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, true, this.operand.getTypeCompiler().getCastToCharWidth(this.operand.getTypeServices()));
                dtd.setCollationType(this.getSchemaDescriptor(null).getCollationType());
                dtd.setCollationDerivation(1);
                this.operand = (ValueNode)this.getNodeFactory().getNode(60, this.operand, dtd, this.getContextManager());
                ((CastNode)this.operand).bindCastNodeOnly();
                operandType = this.operand.getTypeId();
            }
        }
        this.setType(new DataTypeDescriptor(operandType, this.operand.getTypeServices().isNullable(), this.operand.getTypeCompiler().getCastToCharWidth(this.operand.getTypeServices())));
        this.getTypeServices().setCollationDerivation(this.operand.getTypeServices().getCollationDerivation());
        this.getTypeServices().setCollationType(this.operand.getTypeServices().getCollationType());
        return this;
    }

    void bindParameter() throws StandardException {
        this.operand.setType(DataTypeDescriptor.getBuiltInDataTypeDescriptor(12));
        this.operand.setCollationUsingCompilationSchema(1);
    }

    public String getReceiverInterfaceName() {
        return "org.apache.derby.iapi.types.StringDataValue";
    }
}

