/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.MiscellaneousStatementNode;
import org.apache.derby.impl.sql.compile.ParameterNode;

public class SetSchemaNode
extends MiscellaneousStatementNode {
    private String name;
    private int type;

    public void init(Object schemaName, Object type) {
        this.name = (String)schemaName;
        if (type != null) {
            this.type = (Integer)type;
        }
    }

    public String toString() {
        return super.toString() + (this.type == 1 ? "schemaName: \nUSER\n" : (this.type == 2 ? "schemaName: \n?\n" : "schemaName: \n" + this.name + "\n"));
    }

    public String statementToString() {
        return "SET SCHEMA";
    }

    public ConstantAction makeConstantAction() throws StandardException {
        return this.getGenericConstantActionFactory().getSetSchemaConstantAction(this.name, this.type);
    }

    public void generate(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        if (this.type == 2) {
            this.generateParameterValueSet(acb);
        }
        acb.pushGetResultSetFactoryExpression(mb);
        acb.pushThisAsActivation(mb);
        mb.callMethod((short)185, null, "getMiscResultSet", "org.apache.derby.iapi.sql.ResultSet", 1);
    }

    void generateParameterValueSet(ActivationClassBuilder acb) throws StandardException {
        Vector parameterList = this.getCompilerContext().getParameterList();
        SanityManager.ASSERT(parameterList != null && parameterList.size() == 1);
        ParameterNode.generateParameterValueSet(acb, 1, parameterList);
    }

    int activationKind() {
        Vector parameterList = this.getCompilerContext().getParameterList();
        if (this.type == 2) {
            return 2;
        }
        return 0;
    }
}

