/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.HashMap;
import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.OptimizablePredicate;
import org.apache.derby.iapi.sql.compile.OptimizablePredicateList;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.BaseTableNumbersVisitor;
import org.apache.derby.impl.sql.compile.CollectNodesVisitor;
import org.apache.derby.impl.sql.compile.DMLStatementNode;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.FromVTI;
import org.apache.derby.impl.sql.compile.GroupByList;
import org.apache.derby.impl.sql.compile.OrderByList;
import org.apache.derby.impl.sql.compile.Predicate;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.RemapCRsVisitor;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.RowResultSetNode;
import org.apache.derby.impl.sql.compile.TableOperatorNode;
import org.apache.derby.impl.sql.compile.UnionNode;

abstract class SetOperatorNode
extends TableOperatorNode {
    boolean all;
    OrderByList orderByList;
    private PredicateList leftOptPredicates;
    private PredicateList rightOptPredicates;
    private PredicateList pushedPredicates;
    private HashMap leftScopedPreds;
    private HashMap rightScopedPreds;

    SetOperatorNode() {
    }

    public void init(Object leftResult, Object rightResult, Object all, Object tableProperties) throws StandardException {
        super.init(leftResult, rightResult, tableProperties);
        this.all = (Boolean)all;
        this.resultColumns = this.leftResultSet.getResultColumns().copyListAndObjects();
    }

    public Optimizable modifyAccessPath(JBitSet outerTables, PredicateList predList) throws StandardException {
        if (predList != null && !this.getTrulyTheBestAccessPath().getJoinStrategy().isHashJoin()) {
            for (int i = predList.size() - 1; i >= 0; --i) {
                if (!this.pushOptPredicate(predList.getOptPredicate(i))) continue;
                predList.removeOptPredicate(i);
            }
        }
        CostEstimate ce = this.getFinalCostEstimate();
        ResultSetNode topNode = (ResultSetNode)((Object)this.modifyAccessPath(outerTables));
        CollectNodesVisitor cnv = new CollectNodesVisitor(UnionNode.class);
        this.accept(cnv);
        Vector unions = cnv.getList();
        boolean genPRN = false;
        for (int i = unions.size() - 1; i >= 0; --i) {
            if (!((UnionNode)unions.get(i)).hasUnPushedPredicates()) continue;
            genPRN = true;
            break;
        }
        if (genPRN) {
            ResultSetNode prnRSN = (ResultSetNode)this.getNodeFactory().getNode(151, topNode, topNode.getResultColumns(), null, this.pushedPredicates, null, null, null, this.getContextManager());
            prnRSN.costEstimate = ce.cloneMe();
            prnRSN.setReferencedTableMap(topNode.getReferencedTableMap());
            topNode = prnRSN;
        }
        return (Optimizable)((Object)topNode);
    }

    public boolean pushOptPredicate(OptimizablePredicate optimizablePredicate) throws StandardException {
        if (!(this instanceof UnionNode)) {
            return false;
        }
        Predicate pred = (Predicate)optimizablePredicate;
        if (!pred.pushableToSubqueries()) {
            return false;
        }
        boolean canPush = false;
        JBitSet tableNums = new JBitSet(this.getReferencedTableMap().size());
        BaseTableNumbersVisitor btnVis = new BaseTableNumbersVisitor(tableNums);
        this.leftResultSet.accept(btnVis);
        boolean bl = canPush = tableNums.getFirstSetBit() != -1;
        if (!canPush) {
            return false;
        }
        tableNums.clearAll();
        this.rightResultSet.accept(btnVis);
        boolean bl2 = canPush = tableNums.getFirstSetBit() != -1;
        if (!canPush) {
            return false;
        }
        tableNums.clearAll();
        this.accept(btnVis);
        int[] whichRC = new int[]{-1};
        Predicate scopedPred = null;
        if (this.leftScopedPreds == null) {
            this.leftScopedPreds = new HashMap();
        } else {
            scopedPred = (Predicate)this.leftScopedPreds.get(pred);
        }
        if (scopedPred == null) {
            scopedPred = pred.getPredScopedForResultSet(tableNums, this.leftResultSet, whichRC);
            this.leftScopedPreds.put(pred, scopedPred);
        }
        this.getLeftOptPredicateList().addOptPredicate(scopedPred);
        scopedPred = null;
        if (this.rightScopedPreds == null) {
            this.rightScopedPreds = new HashMap();
        } else {
            scopedPred = (Predicate)this.rightScopedPreds.get(pred);
        }
        if (scopedPred == null) {
            scopedPred = pred.getPredScopedForResultSet(tableNums, this.rightResultSet, whichRC);
            this.rightScopedPreds.put(pred, scopedPred);
        }
        this.getRightOptPredicateList().addOptPredicate(scopedPred);
        if (this.pushedPredicates == null) {
            this.pushedPredicates = new PredicateList();
        }
        this.pushedPredicates.addOptPredicate(pred);
        return true;
    }

    public void pullOptPredicates(OptimizablePredicateList optimizablePredicates) throws StandardException {
        if (this.pushedPredicates == null) {
            return;
        }
        if (this.leftOptPredicates != null) {
            this.leftOptPredicates.removeAllElements();
        }
        if (this.rightOptPredicates != null) {
            this.rightOptPredicates.removeAllElements();
        }
        Predicate pred = null;
        RemapCRsVisitor rcrv = new RemapCRsVisitor(false);
        for (int i = 0; i < this.pushedPredicates.size(); ++i) {
            pred = (Predicate)this.pushedPredicates.getOptPredicate(i);
            if (pred.isScopedForPush()) {
                pred.getAndNode().accept(rcrv);
                continue;
            }
            optimizablePredicates.addOptPredicate(pred);
        }
        this.pushedPredicates.removeAllElements();
    }

    protected boolean hasUnPushedPredicates() {
        return this.leftOptPredicates != null && this.leftOptPredicates.size() > 0 || this.rightOptPredicates != null && this.rightOptPredicates.size() > 0;
    }

    public String toString() {
        return "all: " + this.all + "\n" + "orderByList: " + (this.orderByList != null ? this.orderByList.toString() : "null") + "\n" + super.toString();
    }

    public void bindResultColumns(FromList fromListParam) throws StandardException {
        super.bindResultColumns(fromListParam);
        this.buildRCL();
    }

    public void bindResultColumns(TableDescriptor targetTableDescriptor, FromVTI targetVTI, ResultColumnList targetColumnList, DMLStatementNode statement, FromList fromListParam) throws StandardException {
        super.bindResultColumns(targetTableDescriptor, targetVTI, targetColumnList, statement, fromListParam);
        this.buildRCL();
    }

    private void buildRCL() throws StandardException {
        if (this.leftResultSet.getResultColumns().visibleSize() != this.rightResultSet.getResultColumns().visibleSize()) {
            throw StandardException.newException("42X58", this.getOperatorName());
        }
        this.resultColumns = this.leftResultSet.getResultColumns().copyListAndObjects();
        this.resultColumns.setUnionResultExpression(this.rightResultSet.getResultColumns(), this.tableNumber, this.level, this.getOperatorName());
    }

    public void bindUntypedNullsToResultColumns(ResultColumnList rcl) throws StandardException {
        if (rcl == null) {
            ResultColumnList lrcl = this.rightResultSet.getResultColumns();
            ResultColumnList rrcl = this.leftResultSet.getResultColumns();
            this.leftResultSet.bindUntypedNullsToResultColumns(rrcl);
            this.rightResultSet.bindUntypedNullsToResultColumns(lrcl);
        } else {
            this.leftResultSet.bindUntypedNullsToResultColumns(rcl);
            this.rightResultSet.bindUntypedNullsToResultColumns(rcl);
        }
    }

    int getParamColumnTypes(DataTypeDescriptor[] types, RowResultSetNode rrsn) throws StandardException {
        int numTypes = 0;
        for (int i = 0; i < types.length; ++i) {
            ResultColumn rc;
            if (types[i] != null || (rc = (ResultColumn)rrsn.getResultColumns().elementAt(i)).getExpression().requiresTypeFromContext()) continue;
            types[i] = rc.getExpressionType();
            ++numTypes;
        }
        return numTypes;
    }

    void setParamColumnTypes(DataTypeDescriptor[] types, RowResultSetNode rrsn) throws StandardException {
        ResultColumnList rrcl = rrsn.getResultColumns();
        int rrclSize = rrcl.size();
        for (int index = 0; index < rrclSize; ++index) {
            ResultColumn rc = (ResultColumn)rrcl.elementAt(index);
            if (!rc.getExpression().requiresTypeFromContext()) continue;
            rc.getExpression().setType(types[index]);
        }
    }

    public void bindTargetExpressions(FromList fromListParam) throws StandardException {
        this.leftResultSet.bindTargetExpressions(fromListParam);
        this.rightResultSet.bindTargetExpressions(fromListParam);
    }

    void pushOrderByList(OrderByList orderByList) {
        this.orderByList = orderByList;
    }

    public ResultSetNode preprocess(int numTables, GroupByList gbl, FromList fromList) throws StandardException {
        SetOperatorNode newTop = this;
        this.leftResultSet = this.leftResultSet.preprocess(numTables, gbl, fromList);
        this.rightResultSet = this.rightResultSet.preprocess(numTables, gbl, fromList);
        this.referencedTableMap = (JBitSet)this.leftResultSet.getReferencedTableMap().clone();
        this.referencedTableMap.or(this.rightResultSet.getReferencedTableMap());
        if (!this.all && this.orderByList != null && this.orderByList.allAscending() && this.orderByList.isInOrderPrefix(this.resultColumns)) {
            this.orderByList = null;
        }
        return newTop;
    }

    public ResultSetNode ensurePredicateList(int numTables) throws StandardException {
        return this.genProjectRestrict(numTables);
    }

    public void verifySelectStarSubquery(FromList outerFromList, int subqueryType) throws StandardException {
        this.leftResultSet.verifySelectStarSubquery(outerFromList, subqueryType);
        this.rightResultSet.verifySelectStarSubquery(outerFromList, subqueryType);
    }

    protected FromTable getFromTableByName(String name, String schemaName, boolean exactMatch) throws StandardException {
        return this.leftResultSet.getFromTableByName(name, schemaName, exactMatch);
    }

    public ResultSetNode setResultToBooleanTrueNode(boolean onlyConvertAlls) throws StandardException {
        FromList fromList = (FromList)this.getNodeFactory().getNode(37, this.getContextManager());
        fromList.addFromTable(this);
        fromList.markAsTransparent();
        ResultColumnList rcl = (ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager());
        ResultColumn allResultColumn = (ResultColumn)this.getNodeFactory().getNode(16, null, this.getContextManager());
        rcl.addResultColumn(allResultColumn);
        ResultSetNode result = (ResultSetNode)this.getNodeFactory().getNode(129, rcl, null, fromList, null, null, null, this.getContextManager());
        return result.setResultToBooleanTrueNode(onlyConvertAlls);
    }

    public boolean flattenableInFromSubquery(FromList fromList) {
        return false;
    }

    public boolean performMaterialization(JBitSet outerTables) throws StandardException {
        return false;
    }

    abstract String getOperatorName();

    PredicateList getLeftOptPredicateList() throws StandardException {
        if (this.leftOptPredicates == null) {
            this.leftOptPredicates = (PredicateList)this.getNodeFactory().getNode(8, this.getContextManager());
        }
        return this.leftOptPredicates;
    }

    PredicateList getRightOptPredicateList() throws StandardException {
        if (this.rightOptPredicates == null) {
            this.rightOptPredicates = (PredicateList)this.getNodeFactory().getNode(8, this.getContextManager());
        }
        return this.rightOptPredicates;
    }
}

