/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.impl.sql.compile.DDLStatementNode;

public class SavepointNode
extends DDLStatementNode {
    private String savepointName;
    private int savepointStatementType;

    public void init(Object objectName, Object savepointStatementType) throws StandardException {
        this.initAndCheck(null);
        this.savepointName = (String)objectName;
        this.savepointStatementType = (Integer)savepointStatementType;
        if (this.savepointStatementType > 3 || this.savepointStatementType < 1) {
            SanityManager.THROWASSERT("Unexpected value for savepointStatementType = " + this.savepointStatementType + ". Expected value between 1-3");
        }
    }

    public String toString() {
        String tempString = "savepointName: \n" + this.savepointName + "\n";
        tempString = tempString + "savepointStatementType: " + "\n" + this.savepointStatementType + "\n";
        return super.toString() + tempString;
    }

    public String statementToString() {
        if (this.savepointStatementType == 1) {
            return "SAVEPOINT";
        }
        if (this.savepointStatementType == 2) {
            return "ROLLBACK WORK TO SAVEPOINT";
        }
        return "RELEASE TO SAVEPOINT";
    }

    public boolean needsSavepoint() {
        return false;
    }

    public ConstantAction makeConstantAction() throws StandardException {
        return this.getGenericConstantActionFactory().getSavepointConstantAction(this.savepointName, this.savepointStatementType);
    }
}

