/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.io.FormatableProperties;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.NodeFactory;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataTypeUtilities;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.types.XML;
import org.apache.derby.iapi.util.ReuseFactory;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.CastNode;
import org.apache.derby.impl.sql.compile.CharConstantNode;
import org.apache.derby.impl.sql.compile.CharStream;
import org.apache.derby.impl.sql.compile.ColumnDefinitionNode;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.ConstraintDefinitionNode;
import org.apache.derby.impl.sql.compile.CountAggregateDefinition;
import org.apache.derby.impl.sql.compile.CursorNode;
import org.apache.derby.impl.sql.compile.DMLModStatementNode;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.GroupByColumn;
import org.apache.derby.impl.sql.compile.GroupByList;
import org.apache.derby.impl.sql.compile.HasNodeVisitor;
import org.apache.derby.impl.sql.compile.JavaToSQLValueNode;
import org.apache.derby.impl.sql.compile.JoinNode;
import org.apache.derby.impl.sql.compile.MaxMinAggregateDefinition;
import org.apache.derby.impl.sql.compile.MethodCallNode;
import org.apache.derby.impl.sql.compile.OrderByColumn;
import org.apache.derby.impl.sql.compile.OrderByList;
import org.apache.derby.impl.sql.compile.ParameterNode;
import org.apache.derby.impl.sql.compile.ParseException;
import org.apache.derby.impl.sql.compile.PrivilegeNode;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.RoutineDesignator;
import org.apache.derby.impl.sql.compile.SQLParserConstants;
import org.apache.derby.impl.sql.compile.SQLParserTokenManager;
import org.apache.derby.impl.sql.compile.SelectNode;
import org.apache.derby.impl.sql.compile.StatementNode;
import org.apache.derby.impl.sql.compile.SubqueryNode;
import org.apache.derby.impl.sql.compile.SumAvgAggregateDefinition;
import org.apache.derby.impl.sql.compile.TableElementList;
import org.apache.derby.impl.sql.compile.TableElementNode;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.TableOperatorNode;
import org.apache.derby.impl.sql.compile.TablePrivilegesNode;
import org.apache.derby.impl.sql.compile.Token;
import org.apache.derby.impl.sql.compile.TransactionStatementNode;
import org.apache.derby.impl.sql.compile.TriggerReferencingStruct;
import org.apache.derby.impl.sql.compile.UnionNode;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.compile.ValueNodeList;

public class SQLParser
implements SQLParserConstants {
    private static final String[] SAVEPOINT_CLAUSE_NAMES = new String[]{"UNIQUE", "ON ROLLBACK RETAIN LOCKS", "ON ROLLBACK RETAIN CURSORS"};
    private static final String[] ROUTINE_CLAUSE_NAMES = new String[]{null, "SPECIFIC", "RESULT SET", "LANGUAGE", "EXTERNAL NAME", "PARAMETER STYLE", "SQL", "ON NULL INPUT"};
    private static final int[] JAVA_ROUTINE_CLAUSES = new int[]{3, 4, 5};
    private static final String[] TEMPORARY_TABLE_CLAUSE_NAMES = new String[]{"NOT LOGGED", "ON COMMIT", "ON ROLLBACK"};
    private static final int DEFAULT_STRING_COLUMN_LENGTH = 1;
    private static final int ON_OR_USING_CLAUSE_SIZE = 2;
    private static final int ON_CLAUSE = 0;
    private static final int USING_CLAUSE = 1;
    private static final int OPTIONAL_TABLE_CLAUSES_SIZE = 3;
    private static final int OPTIONAL_TABLE_CLAUSES_TABLE_PROPERTIES = 0;
    private static final int OPTIONAL_TABLE_CLAUSES_DERIVED_RCL = 1;
    private static final int OPTIONAL_TABLE_CLAUSES_CORRELATION_NAME = 2;
    private static final int MAX_UTF8_LENGTH = 65535;
    private static final int NO_SET_OP = 0;
    private static final int UNION_OP = 1;
    private static final int UNION_ALL_OP = 2;
    private static final int EXCEPT_OP = 3;
    private static final int EXCEPT_ALL_OP = 4;
    private static final int INTERSECT_OP = 5;
    private static final int INTERSECT_ALL_OP = 6;
    private Object[] paramDefaults;
    private String statementSQLText;
    private NodeFactory nodeFactory;
    private ContextManager cm;
    private CompilerContext compilerContext;
    private int parameterNumber;
    private Vector parameterList;
    private Boolean lastTokenDelimitedIdentifier = Boolean.FALSE;
    private Boolean nextToLastTokenDelimitedIdentifier = Boolean.FALSE;
    private Token lastIdentifierToken;
    private Token nextToLastIdentifierToken;
    static final String SINGLEQUOTES = "''";
    static final String DOUBLEQUOTES = "\"\"";
    static final String DEFAULT_INDEX_TYPE = "BTREE";
    boolean explicitNotNull = false;
    boolean explicitNull = false;
    Vector explicitlyNullableColumnsList = new Vector();
    private static final String[] ESCAPED_SYSFUN_FUNCTIONS = new String[]{"ACOS", "ASIN", "ATAN", "COS", "SIN", "TAN", "PI", "DEGREES", "RADIANS", "EXP", "LOG", "LOG10", "CEILING", "FLOOR", "SIGN", "RAND", "COT"};
    public SQLParserTokenManager token_source;
    public Token token;
    public Token jj_nt;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[315];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private static int[] jj_la1_3;
    private static int[] jj_la1_4;
    private static int[] jj_la1_5;
    private static int[] jj_la1_6;
    private static int[] jj_la1_7;
    private static int[] jj_la1_8;
    private static int[] jj_la1_9;
    private static int[] jj_la1_10;
    private static int[] jj_la1_11;
    private static int[] jj_la1_12;
    private static int[] jj_la1_13;
    private static int[] jj_la1_14;
    private final JJCalls[] jj_2_rtns = new JJCalls[52];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    final void setCompilerContext(CompilerContext cc) {
        this.compilerContext = cc;
        this.cm = cc.getContextManager();
    }

    private final NodeFactory getNodeFactory() throws StandardException {
        if (this.nodeFactory == null) {
            this.nodeFactory = this.getCompilerContext().getNodeFactory();
        }
        return this.nodeFactory;
    }

    private final CompilerContext getCompilerContext() {
        return this.compilerContext;
    }

    private DataTypeDescriptor getDataTypeServices(int type, int precision, int scale, int length) {
        return new DataTypeDescriptor(TypeId.getBuiltInTypeId(type), precision, scale, true, length);
    }

    private DataTypeDescriptor getJavaClassDataTypeDescriptor(String javaClassName) {
        return new DataTypeDescriptor(TypeId.getUserDefinedTypeId(javaClassName, this.lastTokenDelimitedIdentifier), true);
    }

    private LanguageConnectionContext getLanguageConnectionContext() {
        return (LanguageConnectionContext)this.getContextManager().getContext("LanguageConnectionContext");
    }

    private void checkVersion(int version, String feature) throws StandardException {
        this.getLanguageConnectionContext().getDataDictionary().checkVersion(version, feature);
    }

    private void checkSqlStandardAccess(String command) throws StandardException {
        if (this.getLanguageConnectionContext().usesSqlAuthorization()) {
            return;
        }
        throw StandardException.newException("42Z60", (Object)command, (Object)"derby.database.sqlAuthorization", (Object)"TRUE");
    }

    private void checkInternalFeature(String feature) throws StandardException {
        CompilerContext cc = this.getCompilerContext();
        if ((cc.getReliability() & 0x400) != 0) {
            throw StandardException.newException("42X01", feature);
        }
    }

    private void checkTypeLimits(int type, int length) throws StandardException {
        boolean valid = true;
        switch (type) {
            case -2: 
            case 1: {
                if (length <= 254) break;
                valid = false;
                break;
            }
            case -3: 
            case 12: {
                if (length <= 32672) break;
                valid = false;
                break;
            }
        }
        if (!valid) {
            DataTypeDescriptor charDTD = DataTypeDescriptor.getBuiltInDataTypeDescriptor(type, length);
            throw StandardException.newException("42611", charDTD.getSQLstring());
        }
    }

    private final ContextManager getContextManager() {
        return this.cm;
    }

    private static String compressQuotes(String source, String quotes) {
        String result = source;
        int index = result.indexOf(quotes);
        while (index != -1) {
            result = result.substring(0, index + 1) + result.substring(index + 2);
            index = result.indexOf(quotes, index + 1);
        }
        return result;
    }

    private static void verifyImageLength(String image) throws StandardException {
        if (image.length() > 65535) {
            throw StandardException.newException("42Z99");
        }
    }

    private static String normalizeDelimitedID(String str) {
        str = SQLParser.compressQuotes(str, DOUBLEQUOTES);
        return str;
    }

    private static boolean isDATETIME(int val) {
        return val == 276 || val == 331 || val == 332;
    }

    ValueNode multOp(ValueNode leftOperand, ValueNode rightOperand, int multiplicativeOperator) throws StandardException {
        if (leftOperand == null) {
            return rightOperand;
        }
        switch (multiplicativeOperator) {
            case 3: {
                return (ValueNode)this.nodeFactory.getNode(49, leftOperand, rightOperand, this.getContextManager());
            }
            case 4: {
                return (ValueNode)this.nodeFactory.getNode(40, leftOperand, rightOperand, this.getContextManager());
            }
            case 5: {
                return (ValueNode)this.nodeFactory.getNode(50, leftOperand, rightOperand, this.getContextManager());
            }
        }
        SanityManager.THROWASSERT("Unexpected multiplicative operator " + multiplicativeOperator);
        return null;
    }

    private void setUpAndLinkParameters() throws StandardException {
        CompilerContext cc = this.getCompilerContext();
        cc.setParameterList(this.parameterList);
        DataTypeDescriptor[] descriptors = cc.getParameterTypes();
        int paramCount = -1;
        int plSize = this.parameterList.size();
        for (int index = 0; index < plSize; ++index) {
            ++paramCount;
            ParameterNode newNode = (ParameterNode)this.parameterList.elementAt(index);
            newNode.setDescriptors(descriptors);
        }
    }

    void initUnnamedParameterList() {
        this.parameterList = new Vector();
    }

    ParameterNode makeParameterNode() throws StandardException {
        DataValueDescriptor sdv = null;
        if (this.paramDefaults != null && this.parameterNumber < this.paramDefaults.length) {
            sdv = (DataValueDescriptor)this.paramDefaults[this.parameterNumber];
        }
        ParameterNode parm = (ParameterNode)this.nodeFactory.getNode(88, ReuseFactory.getInteger(this.parameterNumber), sdv, this.getContextManager());
        ++this.parameterNumber;
        this.parameterList.addElement(parm);
        return parm;
    }

    ParameterNode lookupUnnamedParameter(int paramNumber) {
        ParameterNode unnamedParameter = (ParameterNode)this.parameterList.elementAt(paramNumber);
        return unnamedParameter;
    }

    ValueNode getNumericNode(String num) throws StandardException {
        ContextManager cm = this.getContextManager();
        try {
            return (ValueNode)this.nodeFactory.getNode(70, new Integer(num), cm);
        }
        catch (NumberFormatException nfe) {
            try {
                return (ValueNode)this.nodeFactory.getNode(71, new Long(num), cm);
            }
            catch (NumberFormatException numberFormatException) {
                return (ValueNode)this.nodeFactory.getNode(67, num, cm);
            }
        }
    }

    private boolean isBuiltInAlias() {
        boolean retval = false;
        switch (this.token.kind) {
            case 263: 
            case 264: 
            case 295: 
            case 351: 
            case 373: 
            case 374: 
            case 406: 
            case 411: {
                retval = true;
                break;
            }
            default: {
                retval = false;
            }
        }
        return retval;
    }

    boolean commonDatatypeName(boolean checkFollowingToken) {
        return this.commonDatatypeName(1, checkFollowingToken);
    }

    boolean commonDatatypeName(int start, boolean checkFollowingToken) {
        boolean retval = false;
        switch (this.getToken((int)start).kind) {
            case 74: 
            case 75: 
            case 82: 
            case 83: 
            case 109: 
            case 110: 
            case 121: 
            case 136: 
            case 160: 
            case 161: 
            case 180: 
            case 186: 
            case 207: 
            case 221: 
            case 254: 
            case 267: 
            case 270: 
            case 276: 
            case 302: 
            case 331: 
            case 332: 
            case 340: 
            case 347: 
            case 352: 
            case 381: {
                retval = true;
                break;
            }
            case 348: {
                if (checkFollowingToken) {
                    switch (this.getToken((int)(start + 1)).kind) {
                        case 74: 
                        case 75: 
                        case 253: 
                        case 254: 
                        case 381: {
                            retval = true;
                        }
                    }
                    break;
                }
                retval = true;
                break;
            }
            case 178: {
                if (checkFollowingToken) {
                    switch (this.getToken((int)(start + 1)).kind) {
                        case 82: 
                        case 83: {
                            retval = true;
                        }
                    }
                    break;
                }
                retval = true;
            }
        }
        return retval;
    }

    private StatementNode getDeleteNode(FromTable fromTable, TableName tableName, ValueNode whereClause) throws StandardException {
        FromList fromList = (FromList)this.nodeFactory.getNode(37, this.getContextManager());
        fromList.addFromTable(fromTable);
        SelectNode resultSet = (SelectNode)this.nodeFactory.getNode(129, null, null, fromList, whereClause, null, null, this.getContextManager());
        StatementNode retval = (StatementNode)this.nodeFactory.getNode(101, tableName, resultSet, this.getContextManager());
        this.setUpAndLinkParameters();
        return retval;
    }

    private StatementNode getUpdateNode(FromTable fromTable, TableName tableName, ResultColumnList setClause, ValueNode whereClause) throws StandardException {
        FromList fromList = (FromList)this.nodeFactory.getNode(37, this.getContextManager());
        fromList.addFromTable(fromTable);
        SelectNode resultSet = (SelectNode)this.nodeFactory.getNode(129, setClause, null, fromList, whereClause, null, null, this.getContextManager());
        StatementNode retval = (StatementNode)this.nodeFactory.getNode(102, tableName, resultSet, this.getContextManager());
        this.setUpAndLinkParameters();
        return retval;
    }

    private ValueNode getTrimOperatorNode(Integer trimSpec, ValueNode trimChar, ValueNode trimSource, ContextManager cm) throws StandardException {
        if (trimChar == null) {
            trimChar = (CharConstantNode)this.nodeFactory.getNode(61, " ", this.getContextManager());
        }
        return (ValueNode)this.nodeFactory.getNode(127, trimSource, trimChar, null, ReuseFactory.getInteger(0), trimSpec, cm == null ? this.getContextManager() : cm);
    }

    private boolean ansiTrimSpecFollows() {
        return this.getToken((int)2).kind == 169 || this.getToken((int)2).kind == 240 || this.getToken((int)2).kind == 76;
    }

    private boolean remainingPredicateFollows() {
        boolean retval = false;
        switch (this.getToken((int)1).kind) {
            case 73: 
            case 153: 
            case 171: 
            case 431: 
            case 432: 
            case 433: 
            case 434: 
            case 435: 
            case 436: 
            case 437: {
                retval = true;
                break;
            }
            case 183: {
                switch (this.getToken((int)2).kind) {
                    case 73: 
                    case 153: 
                    case 171: {
                        retval = true;
                    }
                }
            }
        }
        return retval;
    }

    private boolean dropFollows() {
        return this.getToken((int)1).kind == 122;
    }

    private boolean escapedValueFunctionFollows() {
        if (this.getToken((int)1).kind != 418) {
            return false;
        }
        return this.getToken((int)2).kind == 370;
    }

    private String getEscapedSYSFUN(String name) {
        name = StringUtil.SQLToUpperCase(name);
        for (int i = 0; i < ESCAPED_SYSFUN_FUNCTIONS.length; ++i) {
            if (!ESCAPED_SYSFUN_FUNCTIONS[i].equals(name)) continue;
            return name;
        }
        return null;
    }

    private boolean columnMethodInvocationFollows() {
        int tokKind = this.getToken((int)1).kind;
        if (tokKind == 0) {
            return false;
        }
        if (this.getToken((int)1).image.charAt(0) == '?') {
            return false;
        }
        if (tokKind == 102 || tokKind == 103 || tokKind == 104 || tokKind == 101 && SQLParser.isDATETIME(this.getToken((int)2).kind)) {
            return false;
        }
        if (this.getToken((int)2).kind != 426) {
            return false;
        }
        tokKind = this.getToken((int)4).kind;
        if (tokKind == 420) {
            return true;
        }
        if (tokKind != 426) {
            return false;
        }
        tokKind = this.getToken((int)6).kind;
        if (tokKind == 420) {
            return true;
        }
        if (tokKind != 426) {
            return false;
        }
        tokKind = this.getToken((int)8).kind;
        return tokKind == 420;
    }

    private boolean aggregateFollows() {
        boolean retval = false;
        switch (this.getToken((int)1).kind) {
            case 71: 
            case 174: 
            case 175: 
            case 229: {
                retval = true;
                break;
            }
            case 99: {
                if (this.getToken((int)2).kind == 420) {
                    retval = true;
                }
            }
            default: {
                if (this.getToken((int)2).kind != 420 || this.getToken((int)3).kind != 120) break;
                retval = true;
            }
        }
        return retval;
    }

    private boolean miscBuiltinFollows() {
        boolean retval = false;
        int tokKind = this.getToken((int)1).kind;
        if (this.getToken((int)0).kind == 341) {
            retval = true;
        }
        switch (tokKind) {
            case 102: 
            case 103: 
            case 104: 
            case 345: {
                retval = true;
                break;
            }
            case 101: {
                if (!SQLParser.isDATETIME(this.getToken((int)2).kind)) break;
                retval = true;
                break;
            }
            case 81: 
            case 420: {
                retval = false;
                break;
            }
            default: {
                if (this.getToken((int)2).kind != 420) break;
                retval = true;
            }
        }
        return retval;
    }

    private boolean subqueryFollows() {
        boolean retval = false;
        int i = 1;
        while (true) {
            int tokKind;
            if ((tokKind = this.getToken((int)i).kind) != 420) {
                if (tokKind != 218 && tokKind != 252) break;
                retval = true;
                break;
            }
            ++i;
        }
        return retval;
    }

    private boolean rowValueConstructorListFollows() {
        boolean retval = false;
        if (this.getToken((int)1).kind == 420) {
            int nesting = 1;
            int i = 2;
            while (true) {
                int tokKind = this.getToken((int)i).kind;
                if (i == 2 && (tokKind == 184 || tokKind == 112)) {
                    retval = true;
                    break;
                }
                if (nesting == 1 && tokKind == 424) {
                    retval = true;
                    break;
                }
                if (tokKind == 0) break;
                if (tokKind == 420) {
                    ++nesting;
                } else if (tokKind == 421) {
                    --nesting;
                }
                if (nesting == 0) break;
                ++i;
            }
        }
        return retval;
    }

    private boolean derbyPropertiesListFollows() {
        return this.getToken((int)1).kind == 53;
    }

    private boolean newInvocationFollows(int startToken) {
        boolean retval = false;
        if (this.getToken((int)startToken).kind == 379) {
            int i = 2 + startToken;
            while (true) {
                int tokKind;
                if ((tokKind = this.getToken((int)i).kind) == 420) {
                    retval = true;
                    break;
                }
                if (tokKind != 426) break;
                i += 2;
            }
        }
        return retval;
    }

    boolean javaClassFollows() {
        boolean retval = false;
        int i = 2;
        while (true) {
            int tokKind;
            if ((tokKind = this.getToken((int)i).kind) == 429) {
                retval = true;
                break;
            }
            if (tokKind != 426) break;
            i += 2;
        }
        return retval;
    }

    private boolean fromNewInvocationFollows() {
        boolean retval = false;
        return this.getToken((int)1).kind == 140 && this.newInvocationFollows(2);
    }

    private boolean joinedTableExpressionFollows() {
        boolean retval = false;
        int tokKind1 = this.getToken((int)1).kind;
        int tokKind2 = this.getToken((int)2).kind;
        if (tokKind1 == 166) {
            retval = true;
        } else if (tokKind1 == 156 && tokKind2 == 166) {
            retval = true;
        } else if ((tokKind1 == 170 || tokKind1 == 212) && tokKind2 == 194) {
            if (this.getToken((int)3).kind == 166) {
                retval = true;
            }
        } else if ((tokKind1 == 170 || tokKind1 == 212) && tokKind2 == 166) {
            retval = true;
        }
        return retval;
    }

    private static String aggName(Token token) {
        String retval = null;
        switch (token.kind) {
            case 174: {
                retval = "MAX";
                break;
            }
            case 71: {
                retval = "AVG";
                break;
            }
            case 175: {
                retval = "MIN";
                break;
            }
            case 229: {
                retval = "SUM";
                break;
            }
            case 99: {
                retval = "COUNT";
                break;
            }
            default: {
                SanityManager.THROWASSERT("Unexpected token type in aggName: " + token.kind);
            }
        }
        return retval;
    }

    private static Class aggClass(Token token) {
        Class retval = null;
        switch (token.kind) {
            case 174: 
            case 175: {
                retval = MaxMinAggregateDefinition.class;
                break;
            }
            case 71: 
            case 229: {
                retval = SumAvgAggregateDefinition.class;
                break;
            }
            case 99: {
                retval = CountAggregateDefinition.class;
                break;
            }
            default: {
                SanityManager.THROWASSERT("Unexpected token type in aggClass: " + token.kind);
            }
        }
        return retval;
    }

    private boolean anotherPropertyFollows() {
        boolean retval = false;
        if (this.getToken((int)1).kind == 424) {
            int tokKind;
            int i = 3;
            do {
                if ((tokKind = this.getToken((int)i).kind) == 433) {
                    retval = true;
                    break;
                }
                i += 2;
            } while (tokKind == 426);
        }
        return retval;
    }

    StatementNode getCreateAliasNode(Object aliasName, String fullStaticMethodName, Object aliasSpecificInfo, char aliasType, Boolean delimitedIdentifier) throws StandardException {
        StatementNode aliasNode = (StatementNode)this.getNodeFactory().getCreateAliasNode(aliasName, fullStaticMethodName, aliasSpecificInfo, aliasType, delimitedIdentifier, this.getContextManager());
        return aliasNode;
    }

    StatementNode dropAliasNode(Object aliasName, char type) throws StandardException {
        StatementNode stmt = (StatementNode)this.nodeFactory.getNode(156, aliasName, new Character(type), this.getContextManager());
        return stmt;
    }

    ValueNode getSubstringNode(ValueNode stringValue, ValueNode startPosition, ValueNode length, Boolean boolVal) throws StandardException {
        return (ValueNode)this.nodeFactory.getNode(154, stringValue, startPosition, length, ReuseFactory.getInteger(2), null, this.getContextManager());
    }

    public final TableName qualifiedName(int id_length_limit) throws ParseException, StandardException {
        return this.qualifiedName(34, id_length_limit);
    }

    private void initStatement(String statementSQLText, Object[] paramDefaults) throws StandardException {
        this.parameterNumber = 0;
        this.statementSQLText = statementSQLText;
        this.paramDefaults = paramDefaults;
        this.nodeFactory = this.getNodeFactory();
        this.initUnnamedParameterList();
    }

    private void checkIdentifierLengthLimit(String identifier, int identifier_length_limit) throws StandardException {
        if (identifier.length() > identifier_length_limit) {
            throw StandardException.newException("42622", (Object)identifier, (Object)String.valueOf(identifier_length_limit));
        }
    }

    private ValueNode getJdbcIntervalNode(int intervalType) throws StandardException {
        return (ValueNode)this.nodeFactory.getNode(70, ReuseFactory.getInteger(intervalType), this.getContextManager());
    }

    private void checkAuthorizationLength(String authorization) throws StandardException {
        this.checkIdentifierLengthLimit(authorization, 30);
    }

    void checkRequiredRoutineClause(int[] required, Object[] clauses) throws StandardException {
        for (int i = 0; i < required.length; ++i) {
            int re = required[i];
            if (clauses[re] != null) continue;
            throw StandardException.newException("42X01", ROUTINE_CLAUSE_NAMES[re]);
        }
    }

    public final StatementNode Statement(String statementSQLText, Object[] paramDefaults) throws ParseException, StandardException {
        this.initStatement(statementSQLText, paramDefaults);
        StatementNode statementNode = this.StatementPart(null);
        this.jj_consume_token(0);
        return statementNode;
    }

    public final StatementNode proceduralStatement(Token[] tokenHolder) throws ParseException, StandardException {
        StatementNode statementNode;
        tokenHolder[0] = this.getToken(1);
        switch (this.jj_nt.kind) {
            case 159: {
                statementNode = this.insertStatement();
                break;
            }
            case 247: {
                statementNode = this.preparableUpdateStatement();
                break;
            }
            case 115: {
                statementNode = this.preparableDeleteStatement();
                break;
            }
            case 218: 
            case 252: 
            case 420: {
                statementNode = this.preparableSelectStatement(true);
                break;
            }
            case 341: 
            case 418: 
            case 438: {
                statementNode = this.callStatement();
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return statementNode;
    }

    public final StatementNode StatementPart(Token[] tokenHolder) throws ParseException, StandardException {
        this.explicitNotNull = false;
        this.explicitNull = false;
        this.explicitlyNullableColumnsList = new Vector();
        if (tokenHolder != null) {
            tokenHolder[0] = this.getToken(1);
        }
        switch (this.jj_nt.kind) {
            case 375: 
            case 393: {
                StatementNode statementNode;
                switch (this.jj_nt.kind) {
                    case 393: {
                        statementNode = this.spsRenameStatement();
                        break;
                    }
                    case 375: {
                        statementNode = this.lockStatement();
                        break;
                    }
                    default: {
                        this.jj_la1[1] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return statementNode;
            }
        }
        this.jj_la1[4] = this.jj_gen;
        if (this.jj_2_2(1)) {
            StatementNode statementNode;
            block7 : switch (this.jj_nt.kind) {
                case 100: {
                    statementNode = this.createStatements();
                    break;
                }
                case 122: {
                    statementNode = this.dropStatements();
                    break;
                }
                case 62: {
                    statementNode = this.spsAlterStatement();
                    break;
                }
                case 111: {
                    statementNode = this.globalTemporaryTableDeclaration();
                    break;
                }
                case 115: 
                case 159: 
                case 213: 
                case 218: 
                case 247: 
                case 252: 
                case 309: 
                case 314: 
                case 341: 
                case 418: 
                case 420: 
                case 438: {
                    statementNode = this.preparableSQLDataStatement();
                    break;
                }
                default: {
                    this.jj_la1[2] = this.jj_gen;
                    if (this.jj_2_1(1)) {
                        statementNode = this.spsSetStatement();
                        break;
                    }
                    switch (this.jj_nt.kind) {
                        case 335: {
                            statementNode = this.truncateTableStatement();
                            break block7;
                        }
                        case 147: {
                            statementNode = this.grantStatement();
                            break block7;
                        }
                        case 211: {
                            statementNode = this.revokeStatement();
                            break block7;
                        }
                        case 130: {
                            statementNode = this.execStatement();
                            break block7;
                        }
                    }
                    this.jj_la1[3] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            return statementNode;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode createStatements() throws ParseException, StandardException {
        StatementNode statementNode;
        Token beginToken = this.jj_consume_token(100);
        block0 : switch (this.jj_nt.kind) {
            case 215: 
            case 256: 
            case 329: 
            case 410: {
                switch (this.jj_nt.kind) {
                    case 215: {
                        statementNode = this.schemaDefinition();
                        break block0;
                    }
                    case 256: {
                        statementNode = this.viewDefinition(beginToken);
                        break block0;
                    }
                    case 410: {
                        statementNode = this.triggerDefinition();
                        break block0;
                    }
                    case 329: {
                        statementNode = this.synonymDefinition();
                        break block0;
                    }
                }
                this.jj_la1[5] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            case 232: {
                statementNode = this.tableDefinition();
                break;
            }
            case 204: {
                statementNode = this.procedureDefinition();
                break;
            }
            case 142: {
                statementNode = this.functionDefinition();
                break;
            }
            case 245: 
            case 371: {
                statementNode = this.indexDefinition();
                break;
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return statementNode;
    }

    public final StatementNode dropStatements() throws ParseException, StandardException {
        StatementNode statementNode;
        this.jj_consume_token(122);
        switch (this.jj_nt.kind) {
            case 215: {
                statementNode = this.dropSchemaStatement();
                break;
            }
            case 232: {
                statementNode = this.dropTableStatement();
                break;
            }
            case 371: {
                statementNode = this.dropIndexStatement();
                break;
            }
            case 142: 
            case 204: 
            case 329: {
                statementNode = this.dropAliasStatement();
                break;
            }
            case 256: {
                statementNode = this.dropViewStatement();
                break;
            }
            case 410: {
                statementNode = this.dropTriggerStatement();
                break;
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return statementNode;
    }

    public final StatementNode spsAlterStatement() throws ParseException, StandardException {
        this.jj_consume_token(62);
        StatementNode statementNode = this.alterTableStatement();
        return statementNode;
    }

    public final StatementNode spsSetStatement() throws ParseException, StandardException {
        if (this.getToken((int)1).kind == 220 && this.getToken((int)2).kind != 101) {
            StatementNode statementNode;
            this.jj_consume_token(220);
            if (this.jj_2_3(1)) {
                statementNode = this.setIsolationStatement();
            } else if (this.jj_2_4(1)) {
                statementNode = this.setSchemaStatement();
            } else {
                switch (this.jj_nt.kind) {
                    case 376: {
                        statementNode = this.setMessageLocaleStatement();
                        break;
                    }
                    default: {
                        this.jj_la1[8] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
            return statementNode;
        }
        if (this.getToken((int)1).kind == 220 && this.getToken((int)2).kind == 101) {
            StatementNode statementNode;
            this.jj_consume_token(220);
            if (this.jj_2_5(1)) {
                statementNode = this.setSchemaStatement();
            } else if (this.jj_2_6(1)) {
                statementNode = this.setIsolationStatement();
            } else {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            return statementNode;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode preparableSQLDataStatement() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 115: {
                StatementNode dmlStatement = this.preparableDeleteStatement();
                return dmlStatement;
            }
            case 218: 
            case 252: 
            case 420: {
                CursorNode dmlStatement = this.preparableSelectStatement(true);
                return dmlStatement;
            }
            case 159: {
                StatementNode dmlStatement = this.insertStatement();
                return dmlStatement;
            }
            case 247: {
                StatementNode dmlStatement = this.preparableUpdateStatement();
                return dmlStatement;
            }
            case 341: 
            case 418: 
            case 438: {
                StatementNode dmlStatement = this.callStatement();
                return dmlStatement;
            }
            case 213: 
            case 309: 
            case 314: {
                StatementNode dmlStatement = this.savepointStatement();
                return dmlStatement;
            }
        }
        this.jj_la1[9] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode preparableDeleteStatement() throws ParseException, StandardException {
        this.jj_consume_token(115);
        StatementNode qtn = this.deleteBody();
        return qtn;
    }

    public final StatementNode deleteBody() throws ParseException, StandardException {
        JavaToSQLValueNode javaToSQLNode = null;
        String correlationName = null;
        TableName tableName = null;
        ValueNode whereClause = null;
        FromTable fromTable = null;
        Properties targetProperties = null;
        Token whereToken = null;
        if (this.fromNewInvocationFollows()) {
            this.jj_consume_token(140);
            javaToSQLNode = this.newInvocation();
            switch (this.jj_nt.kind) {
                case 258: {
                    whereToken = this.jj_consume_token(258);
                    whereClause = this.whereClause(whereToken);
                    break;
                }
                default: {
                    this.jj_la1[10] = this.jj_gen;
                }
            }
            fromTable = (FromTable)this.nodeFactory.getNode(120, javaToSQLNode.getJavaValueNode(), null, null, null, this.getContextManager());
            return this.getDeleteNode(fromTable, tableName, whereClause);
        }
        switch (this.jj_nt.kind) {
            case 140: {
                this.jj_consume_token(140);
                tableName = this.qualifiedName(128);
                if (this.getToken((int)1).kind != 0 && this.getToken((int)1).kind != 258 && !this.derbyPropertiesListFollows()) {
                    switch (this.jj_nt.kind) {
                        case 66: {
                            this.jj_consume_token(66);
                            break;
                        }
                        default: {
                            this.jj_la1[11] = this.jj_gen;
                        }
                    }
                    correlationName = this.identifier(128, true);
                }
                switch (this.jj_nt.kind) {
                    case 53: {
                        targetProperties = this.propertyList(false);
                        this.jj_consume_token(58);
                        break;
                    }
                    default: {
                        this.jj_la1[12] = this.jj_gen;
                    }
                }
                switch (this.jj_nt.kind) {
                    case 258: {
                        whereToken = this.jj_consume_token(258);
                        if (this.getToken((int)1).kind == 101 && this.getToken((int)2).kind == 187) {
                            fromTable = this.currentOfClause(correlationName);
                            break;
                        }
                        if (this.jj_2_7(1)) {
                            whereClause = this.whereClause(whereToken);
                            break;
                        }
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    default: {
                        this.jj_la1[13] = this.jj_gen;
                    }
                }
                if (fromTable == null) {
                    fromTable = (FromTable)this.nodeFactory.getNode(135, tableName, correlationName, ReuseFactory.getInteger(2), null, this.getContextManager());
                }
                if (targetProperties != null) {
                    if (((FromBaseTable)fromTable).getProperties() != null) {
                        SanityManager.THROWASSERT("Overwriting existing properties");
                    }
                    ((FromBaseTable)fromTable).setTableProperties(targetProperties);
                }
                return this.getDeleteNode(fromTable, tableName, whereClause);
            }
        }
        this.jj_la1[14] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final FromTable currentOfClause(String correlationName) throws ParseException, StandardException {
        String cursorName = null;
        this.jj_consume_token(101);
        this.jj_consume_token(187);
        cursorName = this.identifier(128, true);
        return (FromTable)this.nodeFactory.getNode(99, correlationName, cursorName, null, this.getContextManager());
    }

    public final CursorNode preparableSelectStatement(boolean checkParams) throws ParseException, StandardException {
        Vector updateColumns = new Vector();
        int forUpdateState = 0;
        int isolationLevel = 0;
        OrderByList orderCols = null;
        ResultSetNode queryExpression = this.queryExpression(null, 0);
        switch (this.jj_nt.kind) {
            case 193: {
                orderCols = this.orderByClause();
                break;
            }
            default: {
                this.jj_la1[15] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 137: {
                this.jj_consume_token(137);
                forUpdateState = this.forUpdateClause(updateColumns);
                break;
            }
            default: {
                this.jj_la1[16] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 259: {
                isolationLevel = this.atIsolationLevel();
                break;
            }
            default: {
                this.jj_la1[17] = this.jj_gen;
            }
        }
        CursorNode retval = (CursorNode)this.nodeFactory.getNode(147, "SELECT", queryExpression, null, orderCols, ReuseFactory.getInteger(forUpdateState), forUpdateState == 1 ? null : updateColumns, this.getContextManager());
        if (checkParams) {
            this.setUpAndLinkParameters();
        }
        if (isolationLevel != 0) {
            this.getCompilerContext().setScanIsolationLevel(isolationLevel);
        }
        return retval;
    }

    public final StatementNode insertStatement() throws ParseException, StandardException {
        this.jj_consume_token(159);
        this.jj_consume_token(163);
        QueryTreeNode targetTable = this.targetTable();
        StatementNode insertNode = this.insertColumnsAndSource(targetTable);
        this.setUpAndLinkParameters();
        return insertNode;
    }

    public final QueryTreeNode targetTable() throws ParseException, StandardException {
        JavaToSQLValueNode javaToSQLNode = null;
        Object correlationName = null;
        if (this.newInvocationFollows(1)) {
            javaToSQLNode = this.newInvocation();
            return this.nodeFactory.getNode(120, javaToSQLNode.getJavaValueNode(), correlationName, null, null, this.getContextManager());
        }
        switch (this.jj_nt.kind) {
            case 74: 
            case 87: 
            case 99: 
            case 107: 
            case 177: 
            case 231: 
            case 243: 
            case 251: 
            case 253: 
            case 263: 
            case 264: 
            case 265: 
            case 266: 
            case 267: 
            case 268: 
            case 269: 
            case 270: 
            case 271: 
            case 272: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 277: 
            case 279: 
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 284: 
            case 286: 
            case 288: 
            case 289: 
            case 290: 
            case 291: 
            case 292: 
            case 293: 
            case 294: 
            case 295: 
            case 296: 
            case 297: 
            case 298: 
            case 299: 
            case 300: 
            case 301: 
            case 302: 
            case 303: 
            case 304: 
            case 305: 
            case 306: 
            case 307: 
            case 308: 
            case 309: 
            case 310: 
            case 311: 
            case 312: 
            case 313: 
            case 314: 
            case 315: 
            case 317: 
            case 318: 
            case 319: 
            case 320: 
            case 321: 
            case 322: 
            case 323: 
            case 324: 
            case 325: 
            case 326: 
            case 327: 
            case 328: 
            case 329: 
            case 330: 
            case 331: 
            case 332: 
            case 333: 
            case 334: 
            case 335: 
            case 336: 
            case 337: 
            case 338: 
            case 339: 
            case 342: 
            case 343: 
            case 344: 
            case 348: 
            case 357: 
            case 358: 
            case 359: 
            case 360: 
            case 361: 
            case 362: 
            case 364: 
            case 365: 
            case 366: 
            case 367: 
            case 368: 
            case 369: 
            case 370: 
            case 371: 
            case 372: 
            case 373: 
            case 374: 
            case 375: 
            case 376: 
            case 377: 
            case 378: 
            case 379: 
            case 380: 
            case 382: 
            case 383: 
            case 384: 
            case 385: 
            case 387: 
            case 388: 
            case 389: 
            case 390: 
            case 391: 
            case 392: 
            case 393: 
            case 394: 
            case 395: 
            case 396: 
            case 397: 
            case 398: 
            case 399: 
            case 400: 
            case 401: 
            case 402: 
            case 403: 
            case 404: 
            case 405: 
            case 406: 
            case 407: 
            case 408: 
            case 409: 
            case 410: 
            case 411: 
            case 412: 
            case 413: 
            case 445: 
            case 451: {
                TableName tableName = this.qualifiedName(128);
                return tableName;
            }
        }
        this.jj_la1[18] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode preparableUpdateStatement() throws ParseException, StandardException {
        this.jj_consume_token(247);
        StatementNode qtn = this.updateBody();
        return qtn;
    }

    public final boolean tableOrIndex() throws ParseException {
        switch (this.jj_nt.kind) {
            case 232: {
                this.jj_consume_token(232);
                return true;
            }
            case 371: {
                this.jj_consume_token(371);
                return false;
            }
        }
        this.jj_la1[19] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode updateBody() throws ParseException, StandardException {
        String correlationName = null;
        JavaToSQLValueNode javaToSQLNode = null;
        TableName tableName = null;
        ValueNode whereClause = null;
        FromTable fromTable = null;
        Properties targetProperties = null;
        Token whereToken = null;
        if (this.newInvocationFollows(1)) {
            javaToSQLNode = this.newInvocation();
            this.jj_consume_token(220);
            ResultColumnList columnList = this.setClauseList();
            switch (this.jj_nt.kind) {
                case 258: {
                    whereToken = this.jj_consume_token(258);
                    whereClause = this.whereClause(whereToken);
                    break;
                }
                default: {
                    this.jj_la1[20] = this.jj_gen;
                }
            }
            fromTable = (FromTable)this.nodeFactory.getNode(120, javaToSQLNode.getJavaValueNode(), null, null, null, this.getContextManager());
            return this.getUpdateNode(fromTable, tableName, columnList, whereClause);
        }
        switch (this.jj_nt.kind) {
            case 74: 
            case 87: 
            case 99: 
            case 107: 
            case 177: 
            case 231: 
            case 243: 
            case 251: 
            case 253: 
            case 263: 
            case 264: 
            case 265: 
            case 266: 
            case 267: 
            case 268: 
            case 269: 
            case 270: 
            case 271: 
            case 272: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 277: 
            case 279: 
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 284: 
            case 286: 
            case 288: 
            case 289: 
            case 290: 
            case 291: 
            case 292: 
            case 293: 
            case 294: 
            case 295: 
            case 296: 
            case 297: 
            case 298: 
            case 299: 
            case 300: 
            case 301: 
            case 302: 
            case 303: 
            case 304: 
            case 305: 
            case 306: 
            case 307: 
            case 308: 
            case 309: 
            case 310: 
            case 311: 
            case 312: 
            case 313: 
            case 314: 
            case 315: 
            case 317: 
            case 318: 
            case 319: 
            case 320: 
            case 321: 
            case 322: 
            case 323: 
            case 324: 
            case 325: 
            case 326: 
            case 327: 
            case 328: 
            case 329: 
            case 330: 
            case 331: 
            case 332: 
            case 333: 
            case 334: 
            case 335: 
            case 336: 
            case 337: 
            case 338: 
            case 339: 
            case 342: 
            case 343: 
            case 344: 
            case 348: 
            case 357: 
            case 358: 
            case 359: 
            case 360: 
            case 361: 
            case 362: 
            case 364: 
            case 365: 
            case 366: 
            case 367: 
            case 368: 
            case 369: 
            case 370: 
            case 371: 
            case 372: 
            case 373: 
            case 374: 
            case 375: 
            case 376: 
            case 377: 
            case 378: 
            case 379: 
            case 380: 
            case 382: 
            case 383: 
            case 384: 
            case 385: 
            case 387: 
            case 388: 
            case 389: 
            case 390: 
            case 391: 
            case 392: 
            case 393: 
            case 394: 
            case 395: 
            case 396: 
            case 397: 
            case 398: 
            case 399: 
            case 400: 
            case 401: 
            case 402: 
            case 403: 
            case 404: 
            case 405: 
            case 406: 
            case 407: 
            case 408: 
            case 409: 
            case 410: 
            case 411: 
            case 412: 
            case 413: 
            case 445: 
            case 451: {
                tableName = this.qualifiedName(128);
                if (this.getToken((int)1).kind != 220 && !this.derbyPropertiesListFollows()) {
                    switch (this.jj_nt.kind) {
                        case 66: {
                            this.jj_consume_token(66);
                            break;
                        }
                        default: {
                            this.jj_la1[21] = this.jj_gen;
                        }
                    }
                    correlationName = this.identifier(128, true);
                }
                switch (this.jj_nt.kind) {
                    case 53: {
                        targetProperties = this.propertyList(false);
                        this.jj_consume_token(58);
                        break;
                    }
                    default: {
                        this.jj_la1[22] = this.jj_gen;
                    }
                }
                this.jj_consume_token(220);
                ResultColumnList columnList = this.setClauseList();
                block12 : switch (this.jj_nt.kind) {
                    case 258: {
                        whereToken = this.jj_consume_token(258);
                        if (this.jj_2_8(1)) {
                            whereClause = this.whereClause(whereToken);
                            break;
                        }
                        switch (this.jj_nt.kind) {
                            case 101: {
                                fromTable = this.currentOfClause(correlationName);
                                break block12;
                            }
                        }
                        this.jj_la1[23] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    default: {
                        this.jj_la1[24] = this.jj_gen;
                    }
                }
                if (fromTable == null) {
                    fromTable = (FromTable)this.nodeFactory.getNode(135, tableName, correlationName, ReuseFactory.getInteger(1), null, this.getContextManager());
                }
                if (targetProperties != null) {
                    if (((FromBaseTable)fromTable).getProperties() != null) {
                        SanityManager.THROWASSERT("Overwriting existing properties");
                    }
                    ((FromBaseTable)fromTable).setTableProperties(targetProperties);
                }
                return this.getUpdateNode(fromTable, tableName, columnList, whereClause);
            }
        }
        this.jj_la1[25] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode callStatement() throws ParseException, StandardException {
        StatementNode retval;
        switch (this.jj_nt.kind) {
            case 341: 
            case 438: {
                retval = this.bareCallStatement();
                break;
            }
            case 418: {
                this.jj_consume_token(418);
                retval = this.bareCallStatement();
                this.jj_consume_token(419);
                break;
            }
            default: {
                this.jj_la1[26] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return retval;
    }

    public final StatementNode bareCallStatement() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 341: {
                this.jj_consume_token(341);
                ValueNode value = this.primaryExpression(true);
                if (!(value instanceof JavaToSQLValueNode) || !(((JavaToSQLValueNode)value).getJavaValueNode() instanceof MethodCallNode)) {
                    throw StandardException.newException("42X74");
                }
                StatementNode callStatement = (StatementNode)this.nodeFactory.getNode(95, value, this.getContextManager());
                this.setUpAndLinkParameters();
                return callStatement;
            }
            case 438: {
                ParameterNode returnParam = this.dynamicParameterSpecification();
                this.getCompilerContext().setReturnParameterFlag();
                this.jj_consume_token(433);
                this.jj_consume_token(341);
                ResultSetNode resultSetNode = this.rowValueConstructor(null);
                ResultColumnList rcl = resultSetNode.getResultColumns();
                if (rcl == null || rcl.size() > 1) {
                    throw StandardException.newException("42X74");
                }
                ValueNode value = ((ResultColumn)rcl.elementAt(0)).getExpression();
                if (!(value instanceof JavaToSQLValueNode) || !(((JavaToSQLValueNode)value).getJavaValueNode() instanceof MethodCallNode)) {
                    throw StandardException.newException("42X74");
                }
                StatementNode cursorNode = (StatementNode)this.nodeFactory.getNode(147, "SELECT", resultSetNode, null, null, ReuseFactory.getInteger(1), null, this.getContextManager());
                returnParam.setReturnOutputParam(value);
                this.setUpAndLinkParameters();
                return cursorNode;
            }
        }
        this.jj_la1[27] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode primaryExpression(boolean inSelectClause) throws ParseException, StandardException {
        ValueNode value = null;
        if (this.getToken((int)2).kind == 426 && this.getToken((int)4).kind == 420) {
            value = this.routineInvocation();
            return value;
        }
        if (this.jj_2_9(1)) {
            value = this.primaryExpressionXX(inSelectClause);
            return value;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode savepointStatement() throws ParseException, StandardException {
        int savepointStatementType;
        String savepointName = null;
        Object[] savepointStatementClauses = new Object[3];
        switch (this.jj_nt.kind) {
            case 314: {
                this.jj_consume_token(314);
                savepointName = this.identifier(128, true);
                block17: while (true) {
                    this.savepointStatementClause(savepointStatementClauses);
                    switch (this.jj_nt.kind) {
                        case 188: 
                        case 245: {
                            continue block17;
                        }
                    }
                    break;
                }
                this.jj_la1[28] = this.jj_gen;
                if (savepointStatementClauses[2] == null) {
                    throw StandardException.newException("42X01", "MISSING ON ROLLBACK RETAIN CURSORS");
                }
                savepointStatementType = 1;
                break;
            }
            case 213: {
                this.jj_consume_token(213);
                switch (this.jj_nt.kind) {
                    case 260: {
                        this.jj_consume_token(260);
                        break;
                    }
                    default: {
                        this.jj_la1[29] = this.jj_gen;
                    }
                }
                this.jj_consume_token(236);
                this.jj_consume_token(314);
                switch (this.jj_nt.kind) {
                    case 74: 
                    case 87: 
                    case 99: 
                    case 107: 
                    case 177: 
                    case 231: 
                    case 243: 
                    case 251: 
                    case 253: 
                    case 263: 
                    case 264: 
                    case 265: 
                    case 266: 
                    case 267: 
                    case 268: 
                    case 269: 
                    case 270: 
                    case 271: 
                    case 272: 
                    case 273: 
                    case 274: 
                    case 275: 
                    case 276: 
                    case 277: 
                    case 279: 
                    case 280: 
                    case 281: 
                    case 282: 
                    case 283: 
                    case 284: 
                    case 286: 
                    case 288: 
                    case 289: 
                    case 290: 
                    case 291: 
                    case 292: 
                    case 293: 
                    case 294: 
                    case 295: 
                    case 296: 
                    case 297: 
                    case 298: 
                    case 299: 
                    case 300: 
                    case 301: 
                    case 302: 
                    case 303: 
                    case 304: 
                    case 305: 
                    case 306: 
                    case 307: 
                    case 308: 
                    case 309: 
                    case 310: 
                    case 311: 
                    case 312: 
                    case 313: 
                    case 314: 
                    case 315: 
                    case 317: 
                    case 318: 
                    case 319: 
                    case 320: 
                    case 321: 
                    case 322: 
                    case 323: 
                    case 324: 
                    case 325: 
                    case 326: 
                    case 327: 
                    case 328: 
                    case 329: 
                    case 330: 
                    case 331: 
                    case 332: 
                    case 333: 
                    case 334: 
                    case 335: 
                    case 336: 
                    case 337: 
                    case 338: 
                    case 339: 
                    case 342: 
                    case 343: 
                    case 344: 
                    case 348: 
                    case 357: 
                    case 358: 
                    case 359: 
                    case 360: 
                    case 361: 
                    case 362: 
                    case 364: 
                    case 365: 
                    case 366: 
                    case 367: 
                    case 368: 
                    case 369: 
                    case 370: 
                    case 371: 
                    case 372: 
                    case 373: 
                    case 374: 
                    case 375: 
                    case 376: 
                    case 377: 
                    case 378: 
                    case 379: 
                    case 380: 
                    case 382: 
                    case 383: 
                    case 384: 
                    case 385: 
                    case 387: 
                    case 388: 
                    case 389: 
                    case 390: 
                    case 391: 
                    case 392: 
                    case 393: 
                    case 394: 
                    case 395: 
                    case 396: 
                    case 397: 
                    case 398: 
                    case 399: 
                    case 400: 
                    case 401: 
                    case 402: 
                    case 403: 
                    case 404: 
                    case 405: 
                    case 406: 
                    case 407: 
                    case 408: 
                    case 409: 
                    case 410: 
                    case 411: 
                    case 412: 
                    case 413: 
                    case 445: 
                    case 451: {
                        savepointName = this.identifier(128, true);
                        break;
                    }
                    default: {
                        this.jj_la1[30] = this.jj_gen;
                    }
                }
                savepointStatementType = 2;
                break;
            }
            case 309: {
                this.jj_consume_token(309);
                switch (this.jj_nt.kind) {
                    case 236: {
                        this.jj_consume_token(236);
                        break;
                    }
                    default: {
                        this.jj_la1[31] = this.jj_gen;
                    }
                }
                this.jj_consume_token(314);
                savepointName = this.identifier(128, true);
                savepointStatementType = 3;
                break;
            }
            default: {
                this.jj_la1[32] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return (StatementNode)this.nodeFactory.getNode(198, savepointName, ReuseFactory.getInteger(savepointStatementType), this.getContextManager());
    }

    public final void savepointStatementClause(Object[] savepointStatementClauses) throws ParseException, StandardException {
        int clausePosition = -1;
        switch (this.jj_nt.kind) {
            case 245: {
                this.jj_consume_token(245);
                clausePosition = 0;
                break;
            }
            case 188: {
                this.jj_consume_token(188);
                this.jj_consume_token(213);
                this.jj_consume_token(396);
                clausePosition = this.LocksOrCursors();
                break;
            }
            default: {
                this.jj_la1[33] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (clausePosition != -1) {
            if (savepointStatementClauses[clausePosition] != null) {
                String which = SAVEPOINT_CLAUSE_NAMES[clausePosition];
                throw StandardException.newException("42613", which);
            }
            savepointStatementClauses[clausePosition] = Boolean.TRUE;
        }
    }

    public final int LocksOrCursors() throws ParseException {
        switch (this.jj_nt.kind) {
            case 292: {
                this.jj_consume_token(292);
                return 1;
            }
            case 363: {
                this.jj_consume_token(363);
                return 2;
            }
        }
        this.jj_la1[34] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode globalTemporaryTableDeclaration() throws ParseException, StandardException {
        Object[] declareTableClauses = new Object[3];
        this.jj_consume_token(111);
        this.jj_consume_token(144);
        this.jj_consume_token(233);
        this.jj_consume_token(232);
        TableName tableName = this.qualifiedName(128);
        TableElementList tableElementList = this.tableElementList();
        do {
            this.declareTableClause(declareTableClauses);
        } while (this.jj_2_10(1));
        if (declareTableClauses[0] == null) {
            throw StandardException.newException("42X01", "MISSING NOT LOGGED");
        }
        if (declareTableClauses[1] == null) {
            declareTableClauses[1] = Boolean.TRUE;
        }
        if (declareTableClauses[2] == null) {
            declareTableClauses[2] = Boolean.TRUE;
        }
        return (StatementNode)this.nodeFactory.getNode(141, tableName, tableElementList, null, (Boolean)declareTableClauses[1], (Boolean)declareTableClauses[2], this.getContextManager());
    }

    public final void declareTableClause(Object[] declareTableClauses) throws ParseException, StandardException {
        int clausePosition = -1;
        Boolean clauseValue = null;
        switch (this.jj_nt.kind) {
            case 183: {
                this.jj_consume_token(183);
                this.jj_consume_token(294);
                clauseValue = Boolean.TRUE;
                clausePosition = 0;
                break;
            }
            default: {
                this.jj_la1[35] = this.jj_gen;
                if (this.getToken((int)1).kind == 188 && this.getToken((int)2).kind == 91) {
                    this.jj_consume_token(188);
                    this.jj_consume_token(91);
                    clauseValue = this.onCommit();
                    this.jj_consume_token(214);
                    clausePosition = 1;
                    break;
                }
                if (this.getToken((int)1).kind == 188 && this.getToken((int)2).kind == 213) {
                    this.jj_consume_token(188);
                    this.jj_consume_token(213);
                    this.jj_consume_token(115);
                    this.jj_consume_token(214);
                    clauseValue = Boolean.TRUE;
                    clausePosition = 2;
                    break;
                }
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (clausePosition != -1) {
            if (declareTableClauses[clausePosition] != null) {
                String which = TEMPORARY_TABLE_CLAUSE_NAMES[clausePosition];
                throw StandardException.newException("42613", which);
            }
            declareTableClauses[clausePosition] = clauseValue;
        }
    }

    public final Boolean onCommit() throws ParseException {
        switch (this.jj_nt.kind) {
            case 200: {
                this.jj_consume_token(200);
                return Boolean.FALSE;
            }
            case 115: {
                this.jj_consume_token(115);
                return Boolean.TRUE;
            }
        }
        this.jj_la1[36] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final TableElementList tableElementList() throws ParseException, StandardException {
        TableElementList tableElementList = (TableElementList)this.nodeFactory.getNode(12, this.getContextManager());
        this.jj_consume_token(420);
        this.tableElement(tableElementList);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 424: {
                    break;
                }
                default: {
                    this.jj_la1[37] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(424);
            this.tableElement(tableElementList);
        }
        this.jj_consume_token(421);
        return tableElementList;
    }

    public final void tableElement(TableElementList tableElementList) throws ParseException, StandardException {
        this.explicitNotNull = false;
        this.explicitNull = false;
        switch (this.jj_nt.kind) {
            case 74: 
            case 87: 
            case 99: 
            case 107: 
            case 177: 
            case 231: 
            case 243: 
            case 251: 
            case 253: 
            case 263: 
            case 264: 
            case 265: 
            case 266: 
            case 267: 
            case 268: 
            case 269: 
            case 270: 
            case 271: 
            case 272: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 277: 
            case 279: 
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 284: 
            case 286: 
            case 288: 
            case 289: 
            case 290: 
            case 291: 
            case 292: 
            case 293: 
            case 294: 
            case 295: 
            case 296: 
            case 297: 
            case 298: 
            case 299: 
            case 300: 
            case 301: 
            case 302: 
            case 303: 
            case 304: 
            case 305: 
            case 306: 
            case 307: 
            case 308: 
            case 309: 
            case 310: 
            case 311: 
            case 312: 
            case 313: 
            case 314: 
            case 315: 
            case 317: 
            case 318: 
            case 319: 
            case 320: 
            case 321: 
            case 322: 
            case 323: 
            case 324: 
            case 325: 
            case 326: 
            case 327: 
            case 328: 
            case 329: 
            case 330: 
            case 331: 
            case 332: 
            case 333: 
            case 334: 
            case 335: 
            case 336: 
            case 337: 
            case 338: 
            case 339: 
            case 342: 
            case 343: 
            case 344: 
            case 348: 
            case 357: 
            case 358: 
            case 359: 
            case 360: 
            case 361: 
            case 362: 
            case 364: 
            case 365: 
            case 366: 
            case 367: 
            case 368: 
            case 369: 
            case 370: 
            case 371: 
            case 372: 
            case 373: 
            case 374: 
            case 375: 
            case 376: 
            case 377: 
            case 378: 
            case 379: 
            case 380: 
            case 382: 
            case 383: 
            case 384: 
            case 385: 
            case 387: 
            case 388: 
            case 389: 
            case 390: 
            case 391: 
            case 392: 
            case 393: 
            case 394: 
            case 395: 
            case 396: 
            case 397: 
            case 398: 
            case 399: 
            case 400: 
            case 401: 
            case 402: 
            case 403: 
            case 404: 
            case 405: 
            case 406: 
            case 407: 
            case 408: 
            case 409: 
            case 410: 
            case 411: 
            case 412: 
            case 413: 
            case 445: 
            case 451: {
                TableElementNode tableElement = this.columnDefinition(tableElementList);
                tableElementList.addTableElement(tableElement);
                break;
            }
            case 85: 
            case 94: 
            case 138: 
            case 201: 
            case 245: {
                TableElementNode tableElement = this.tableConstraintDefinition();
                tableElementList.addTableElement(tableElement);
                break;
            }
            default: {
                this.jj_la1[38] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final TableElementNode columnDefinition(TableElementList tableElementList) throws ParseException, StandardException {
        DataTypeDescriptor typeDescriptor = null;
        ValueNode defaultNode = null;
        long[] autoIncrementInfo = new long[4];
        String columnName = this.identifier(128, true);
        typeDescriptor = this.dataTypeDDL();
        switch (this.jj_nt.kind) {
            case 85: 
            case 94: 
            case 112: 
            case 183: 
            case 201: 
            case 208: 
            case 245: 
            case 259: 
            case 281: {
                defaultNode = this.defaultAndConstraints(typeDescriptor, tableElementList, columnName, autoIncrementInfo);
                break;
            }
            default: {
                this.jj_la1[39] = this.jj_gen;
            }
        }
        if (autoIncrementInfo[2] == 0L) {
            autoIncrementInfo = null;
        }
        return (TableElementNode)this.nodeFactory.getNode(116, columnName, defaultNode, typeDescriptor, autoIncrementInfo, this.getContextManager());
    }

    public final ValueNode defaultAndConstraints(DataTypeDescriptor typeDescriptor, TableElementList tableElementList, String columnName, long[] autoIncrementInfo) throws ParseException, StandardException {
        ValueNode defaultNode = null;
        switch (this.jj_nt.kind) {
            case 85: 
            case 94: 
            case 183: 
            case 201: 
            case 208: 
            case 245: {
                this.columnConstraintDefinition(typeDescriptor, tableElementList, columnName);
                block16: while (true) {
                    switch (this.jj_nt.kind) {
                        case 85: 
                        case 94: 
                        case 183: 
                        case 201: 
                        case 208: 
                        case 245: {
                            break;
                        }
                        default: {
                            this.jj_la1[40] = this.jj_gen;
                            break block16;
                        }
                    }
                    this.columnConstraintDefinition(typeDescriptor, tableElementList, columnName);
                }
                block7 : switch (this.jj_nt.kind) {
                    case 112: 
                    case 259: 
                    case 281: {
                        defaultNode = this.defaultClause(autoIncrementInfo, columnName);
                        while (true) {
                            switch (this.jj_nt.kind) {
                                case 85: 
                                case 94: 
                                case 183: 
                                case 201: 
                                case 208: 
                                case 245: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[41] = this.jj_gen;
                                    break block7;
                                }
                            }
                            this.columnConstraintDefinition(typeDescriptor, tableElementList, columnName);
                        }
                    }
                    default: {
                        this.jj_la1[42] = this.jj_gen;
                    }
                }
                return defaultNode;
            }
            case 112: 
            case 259: 
            case 281: {
                defaultNode = this.defaultClause(autoIncrementInfo, columnName);
                block18: while (true) {
                    switch (this.jj_nt.kind) {
                        case 85: 
                        case 94: 
                        case 183: 
                        case 201: 
                        case 208: 
                        case 245: {
                            break;
                        }
                        default: {
                            this.jj_la1[43] = this.jj_gen;
                            break block18;
                        }
                    }
                    this.columnConstraintDefinition(typeDescriptor, tableElementList, columnName);
                }
                return defaultNode;
            }
        }
        this.jj_la1[44] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final DataTypeDescriptor dataTypeDDL() throws ParseException, StandardException {
        if (!this.commonDatatypeName(false)) {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        DataTypeDescriptor typeDescriptor = this.dataTypeCommon();
        return typeDescriptor;
    }

    public final DataTypeDescriptor dataTypeCast() throws ParseException, StandardException {
        if (!this.commonDatatypeName(true)) {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        DataTypeDescriptor typeDescriptor = this.dataTypeCommon();
        return typeDescriptor;
    }

    public final DataTypeDescriptor dataTypeCommon() throws ParseException, StandardException {
        DataTypeDescriptor typeDescriptor;
        boolean checkCS = false;
        if (this.jj_2_11(1)) {
            if (this.getToken((int)2).kind == 289) {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            typeDescriptor = this.characterStringType();
        } else if (this.jj_2_12(1)) {
            if (this.getToken((int)3).kind == 289) {
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            typeDescriptor = this.nationalCharacterStringType();
        } else if (this.jj_2_13(1)) {
            typeDescriptor = this.numericType();
        } else {
            switch (this.jj_nt.kind) {
                case 276: 
                case 331: 
                case 332: {
                    typeDescriptor = this.datetimeType();
                    break;
                }
                case 340: {
                    this.jj_consume_token(340);
                    this.checkInternalFeature("BOOLEAN");
                    typeDescriptor = new DataTypeDescriptor(TypeId.BOOLEAN_ID, true);
                    break;
                }
                case 348: {
                    typeDescriptor = this.longType();
                    break;
                }
                case 74: 
                case 82: 
                case 83: 
                case 178: 
                case 267: 
                case 270: 
                case 302: {
                    typeDescriptor = this.LOBType();
                    break;
                }
                case 352: {
                    typeDescriptor = this.XMLType();
                    break;
                }
                default: {
                    this.jj_la1[45] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return typeDescriptor;
    }

    public final DataTypeDescriptor characterStringType() throws ParseException, StandardException {
        int type;
        int length = 1;
        Token varyingToken = null;
        switch (this.jj_nt.kind) {
            case 254: {
                this.jj_consume_token(254);
                length = this.charLength();
                type = 12;
                break;
            }
            case 82: 
            case 83: {
                this.charOrCharacter();
                block4 : switch (this.jj_nt.kind) {
                    case 255: {
                        varyingToken = this.jj_consume_token(255);
                        length = this.charLength();
                        break;
                    }
                    default: {
                        this.jj_la1[47] = this.jj_gen;
                        switch (this.jj_nt.kind) {
                            case 420: {
                                length = this.charLength();
                                break block4;
                            }
                        }
                        this.jj_la1[46] = this.jj_gen;
                    }
                }
                type = varyingToken == null ? 1 : 12;
                break;
            }
            default: {
                this.jj_la1[48] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        switch (this.jj_nt.kind) {
            case 137: {
                type = this.forBitData(type);
                break;
            }
            default: {
                this.jj_la1[49] = this.jj_gen;
            }
        }
        this.checkTypeLimits(type, length);
        DataTypeDescriptor charDTD = DataTypeDescriptor.getBuiltInDataTypeDescriptor(type, length);
        return charDTD;
    }

    public final void charOrCharacter() throws ParseException {
        switch (this.jj_nt.kind) {
            case 82: {
                this.jj_consume_token(82);
                break;
            }
            case 83: {
                this.jj_consume_token(83);
                break;
            }
            default: {
                this.jj_la1[50] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final int charLength() throws ParseException, StandardException {
        this.jj_consume_token(420);
        int length = this.length();
        this.jj_consume_token(421);
        return length;
    }

    public final int forBitData(int charType) throws ParseException {
        this.jj_consume_token(137);
        this.jj_consume_token(75);
        this.jj_consume_token(275);
        if (charType == 1) {
            charType = -2;
        } else if (charType == 12) {
            charType = -3;
        } else if (charType == -1) {
            charType = -4;
        }
        return charType;
    }

    public final DataTypeDescriptor nationalCharacterStringType() throws ParseException, StandardException {
        int length = 1;
        String type = null;
        Token varyingToken = null;
        switch (this.jj_nt.kind) {
            case 178: {
                this.jj_consume_token(178);
                this.charOrCharacter();
                block5 : switch (this.jj_nt.kind) {
                    case 255: {
                        varyingToken = this.jj_consume_token(255);
                        length = this.charLength();
                        break;
                    }
                    default: {
                        this.jj_la1[52] = this.jj_gen;
                        switch (this.jj_nt.kind) {
                            case 420: {
                                length = this.charLength();
                                break block5;
                            }
                        }
                        this.jj_la1[51] = this.jj_gen;
                    }
                }
                type = varyingToken == null ? "NATIONAL CHAR" : "NATIONAL CHAR VARYING";
                break;
            }
            case 180: {
                this.jj_consume_token(180);
                block11 : switch (this.jj_nt.kind) {
                    case 255: {
                        varyingToken = this.jj_consume_token(255);
                        length = this.charLength();
                        break;
                    }
                    default: {
                        this.jj_la1[54] = this.jj_gen;
                        switch (this.jj_nt.kind) {
                            case 420: {
                                length = this.charLength();
                                break block11;
                            }
                        }
                        this.jj_la1[53] = this.jj_gen;
                    }
                }
                type = varyingToken == null ? "NATIONAL CHAR" : "NATIONAL CHAR VARYING";
                break;
            }
            case 381: {
                this.jj_consume_token(381);
                length = this.charLength();
                type = "NATIONAL CHAR VARYING";
                break;
            }
            default: {
                this.jj_la1[55] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        throw StandardException.newException("0A000.S", type);
    }

    public final DataTypeDescriptor LOBType() throws ParseException, StandardException {
        String type2;
        int length = Integer.MAX_VALUE;
        switch (this.jj_nt.kind) {
            case 267: {
                this.jj_consume_token(267);
                switch (this.jj_nt.kind) {
                    case 420: {
                        length = this.lengthAndModifier();
                        break;
                    }
                    default: {
                        this.jj_la1[56] = this.jj_gen;
                    }
                }
                type2 = "BLOB";
                break;
            }
            case 270: {
                this.jj_consume_token(270);
                switch (this.jj_nt.kind) {
                    case 420: {
                        length = this.lengthAndModifier();
                        break;
                    }
                    default: {
                        this.jj_la1[57] = this.jj_gen;
                    }
                }
                type2 = "CLOB";
                break;
            }
            case 302: {
                this.jj_consume_token(302);
                length = this.lengthAndModifier();
                String type2 = "NCLOB";
                throw StandardException.newException("0A000.S", type2);
            }
            case 74: {
                this.jj_consume_token(74);
                this.jj_consume_token(289);
                this.jj_consume_token(305);
                switch (this.jj_nt.kind) {
                    case 420: {
                        length = this.lengthAndModifier();
                        break;
                    }
                    default: {
                        this.jj_la1[58] = this.jj_gen;
                    }
                }
                type2 = "BLOB";
                break;
            }
            case 82: 
            case 83: {
                this.charOrCharacter();
                this.jj_consume_token(289);
                this.jj_consume_token(305);
                switch (this.jj_nt.kind) {
                    case 420: {
                        length = this.lengthAndModifier();
                        break;
                    }
                    default: {
                        this.jj_la1[59] = this.jj_gen;
                    }
                }
                type2 = "CLOB";
                break;
            }
            case 178: {
                this.jj_consume_token(178);
                this.jj_consume_token(83);
                this.jj_consume_token(289);
                this.jj_consume_token(305);
                length = this.lengthAndModifier();
                String type2 = "NCLOB";
                throw StandardException.newException("0A000.S", type2);
            }
            default: {
                this.jj_la1[60] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        DataTypeDescriptor dtd = DataTypeDescriptor.getBuiltInDataTypeDescriptor(type2, length);
        return dtd;
    }

    public final DataTypeDescriptor numericType() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 109: 
            case 110: 
            case 160: 
            case 161: 
            case 186: 
            case 221: 
            case 347: {
                DataTypeDescriptor typeDescriptor = this.exactNumericType();
                return typeDescriptor;
            }
        }
        this.jj_la1[61] = this.jj_gen;
        if (this.jj_2_14(1)) {
            DataTypeDescriptor typeDescriptor = this.approximateNumericType();
            return typeDescriptor;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final DataTypeDescriptor exactNumericType() throws ParseException, StandardException {
        int precision = 5;
        int scale = 0;
        int type = 3;
        String typeStr = "DECIMAL";
        DataTypeDescriptor dtd = null;
        switch (this.jj_nt.kind) {
            case 109: 
            case 110: 
            case 186: {
                switch (this.jj_nt.kind) {
                    case 186: {
                        this.jj_consume_token(186);
                        type = 2;
                        typeStr = "NUMERIC";
                        break;
                    }
                    case 110: {
                        this.jj_consume_token(110);
                        break;
                    }
                    case 109: {
                        this.jj_consume_token(109);
                        break;
                    }
                    default: {
                        this.jj_la1[62] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                switch (this.jj_nt.kind) {
                    case 420: {
                        this.jj_consume_token(420);
                        precision = this.precision();
                        switch (this.jj_nt.kind) {
                            case 424: {
                                this.jj_consume_token(424);
                                scale = this.scale();
                                break;
                            }
                            default: {
                                this.jj_la1[63] = this.jj_gen;
                            }
                        }
                        this.jj_consume_token(421);
                        break;
                    }
                    default: {
                        this.jj_la1[64] = this.jj_gen;
                    }
                }
                if (precision <= 0 || precision > 31) {
                    throw StandardException.newException("42X48", (Object)typeStr, (Object)String.valueOf(precision));
                }
                if (scale < 0 || scale > 31) {
                    throw StandardException.newException("42Y42", (Object)typeStr, (Object)String.valueOf(scale));
                }
                if (scale > precision) {
                    throw StandardException.newException("42Y43", (Object)String.valueOf(scale), (Object)String.valueOf(precision));
                }
                int maxWidth = DataTypeUtilities.computeMaxWidth(precision, scale);
                return this.getDataTypeServices(type, precision, scale, maxWidth);
            }
            case 160: 
            case 161: 
            case 221: 
            case 347: {
                dtd = this.exactIntegerType();
                return dtd;
            }
        }
        this.jj_la1[65] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final DataTypeDescriptor exactIntegerType() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 160: 
            case 161: {
                switch (this.jj_nt.kind) {
                    case 161: {
                        this.jj_consume_token(161);
                        break;
                    }
                    case 160: {
                        this.jj_consume_token(160);
                        break;
                    }
                    default: {
                        this.jj_la1[66] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return DataTypeDescriptor.getBuiltInDataTypeDescriptor(4);
            }
            case 221: {
                this.jj_consume_token(221);
                return DataTypeDescriptor.getBuiltInDataTypeDescriptor(5);
            }
            case 347: {
                this.jj_consume_token(347);
                return DataTypeDescriptor.getBuiltInDataTypeDescriptor(-5);
            }
        }
        this.jj_la1[67] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final DataTypeDescriptor approximateNumericType() throws ParseException, StandardException {
        int type = 0;
        int scale = 0;
        int width = 0;
        int prec = -1;
        DataTypeDescriptor dts = null;
        switch (this.jj_nt.kind) {
            case 136: {
                this.jj_consume_token(136);
                switch (this.jj_nt.kind) {
                    case 420: {
                        this.jj_consume_token(420);
                        prec = this.precision();
                        this.jj_consume_token(421);
                        break;
                    }
                    default: {
                        this.jj_la1[68] = this.jj_gen;
                    }
                }
                if (prec == -1) {
                    prec = 52;
                }
                if (prec > 0 && prec <= 23) {
                    type = 7;
                    prec = 23;
                    scale = 0;
                    width = 4;
                } else if (prec > 23 && prec <= 52) {
                    type = 8;
                    prec = 52;
                    scale = 0;
                    width = 8;
                } else {
                    throw StandardException.newException("42X48", (Object)"FLOAT", (Object)String.valueOf(prec));
                }
                return this.getDataTypeServices(type, prec, scale, width);
            }
            case 207: {
                this.jj_consume_token(207);
                return DataTypeDescriptor.getBuiltInDataTypeDescriptor(7);
            }
        }
        this.jj_la1[69] = this.jj_gen;
        if (this.jj_2_15(1)) {
            dts = this.doubleType();
            return dts;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final DataTypeDescriptor doubleType() throws ParseException, StandardException {
        if (this.getToken((int)2).kind == 308) {
            this.jj_consume_token(121);
            this.jj_consume_token(308);
        } else {
            switch (this.jj_nt.kind) {
                case 121: {
                    this.jj_consume_token(121);
                    break;
                }
                default: {
                    this.jj_la1[70] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return DataTypeDescriptor.getBuiltInDataTypeDescriptor(8);
    }

    public final DataTypeDescriptor longType() throws ParseException, StandardException {
        this.jj_consume_token(348);
        DataTypeDescriptor dataTypeDescriptor = this.longSubType();
        return dataTypeDescriptor;
    }

    public final DataTypeDescriptor longSubType() throws ParseException, StandardException {
        int lvcType = -1;
        switch (this.jj_nt.kind) {
            case 254: {
                this.jj_consume_token(254);
                switch (this.jj_nt.kind) {
                    case 137: {
                        lvcType = this.forBitData(lvcType);
                        break;
                    }
                    default: {
                        this.jj_la1[71] = this.jj_gen;
                    }
                }
                return DataTypeDescriptor.getBuiltInDataTypeDescriptor(lvcType);
            }
            case 381: {
                this.jj_consume_token(381);
                throw StandardException.newException("0A000.S", "LONG NVARCHAR");
            }
        }
        this.jj_la1[72] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final DataTypeDescriptor XMLType() throws ParseException, StandardException {
        this.jj_consume_token(352);
        this.checkVersion(130, "XML");
        return DataTypeDescriptor.getBuiltInDataTypeDescriptor(456);
    }

    public final void xmlDocOrContent() throws ParseException, StandardException {
        if (this.getToken((int)1).kind != 366 && this.getToken((int)1).kind != 361) {
            throw StandardException.newException("42Z72", (Object)"DOCUMENT", (Object)ReuseFactory.getInteger(this.getToken((int)1).beginLine), (Object)ReuseFactory.getInteger(this.getToken((int)1).beginColumn));
        }
        if (this.getToken((int)1).kind == 361) {
            this.jj_consume_token(361);
            throw StandardException.newException("42Z74", "CONTENT");
        }
        if (this.getToken((int)1).kind == 366) {
            this.jj_consume_token(366);
            return;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final DataTypeDescriptor javaType() throws ParseException, StandardException {
        String javaClassName = this.javaClassName();
        return this.getJavaClassDataTypeDescriptor(javaClassName);
    }

    public final String javaDSL() throws ParseException {
        String dotSeparatedList = this.caseSensitiveIdentifierPlusReservedWords();
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 426: {
                    break;
                }
                default: {
                    this.jj_la1[73] = this.jj_gen;
                    break block3;
                }
            }
            dotSeparatedList = this.javaDSLNameExtender(dotSeparatedList);
        }
        return dotSeparatedList;
    }

    public final String javaClassName() throws ParseException {
        String javaClassName = this.javaDSL();
        return javaClassName;
    }

    public final String javaDSLNameExtender(String dotSeparatedList) throws ParseException {
        this.jj_consume_token(426);
        String extender = this.caseSensitiveIdentifierPlusReservedWords();
        return dotSeparatedList + "." + extender;
    }

    public final int lengthAndModifier() throws ParseException, StandardException {
        Token tok;
        Token tokmod = null;
        this.jj_consume_token(420);
        block1 : switch (this.jj_nt.kind) {
            case 454: {
                tok = this.jj_consume_token(454);
                break;
            }
            case 452: {
                tok = this.jj_consume_token(452);
                switch (this.jj_nt.kind) {
                    case 445: {
                        tokmod = this.jj_consume_token(445);
                        break block1;
                    }
                }
                this.jj_la1[74] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[75] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(421);
        String s = tok.image + (tokmod == null ? "" : tokmod.image);
        try {
            long mul;
            char modifier = s.charAt(s.length() - 1);
            String number = s.substring(0, s.length() - 1);
            switch (modifier) {
                case 'G': 
                case 'g': {
                    mul = 0x40000000L;
                    break;
                }
                case 'M': 
                case 'm': {
                    mul = 0x100000L;
                    break;
                }
                case 'K': 
                case 'k': {
                    mul = 1024L;
                    break;
                }
                default: {
                    mul = 1L;
                    number = s;
                }
            }
            long specifiedLength = Long.parseLong(number) * mul;
            if (specifiedLength > 0L && specifiedLength <= Integer.MAX_VALUE) {
                return (int)specifiedLength;
            }
            if (mul != 1L && specifiedLength == 0x80000000L) {
                return Integer.MAX_VALUE;
            }
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        throw StandardException.newException("42X44", s);
    }

    public final int length() throws ParseException, StandardException {
        Token tok = this.jj_consume_token(452);
        try {
            int retval = Integer.parseInt(tok.image);
            if (retval > 0) {
                return retval;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        throw StandardException.newException("42X44", tok.image);
    }

    public final long exactNumber() throws ParseException, StandardException {
        String sign = "";
        switch (this.jj_nt.kind) {
            case 423: 
            case 425: {
                sign = this.sign();
                break;
            }
            default: {
                this.jj_la1[76] = this.jj_gen;
            }
        }
        Token longToken = this.jj_consume_token(452);
        try {
            if (sign.equals("-")) {
                return Long.parseLong("-" + longToken.image);
            }
            return Long.parseLong(longToken.image);
        }
        catch (NumberFormatException nfe) {
            throw StandardException.newException("42X49", longToken.image);
        }
    }

    public final int precision() throws ParseException, StandardException {
        int uintValue = this.uint_value();
        return uintValue;
    }

    public final int uint_value() throws ParseException, StandardException {
        Token uintToken = this.jj_consume_token(452);
        try {
            return Integer.parseInt(uintToken.image);
        }
        catch (NumberFormatException nfe) {
            throw StandardException.newException("42X49", uintToken.image);
        }
    }

    public final int scale() throws ParseException, StandardException {
        int uintValue = this.uint_value();
        return uintValue;
    }

    public final DataTypeDescriptor datetimeType() throws ParseException, StandardException {
        Object tzTok = null;
        int prec = -1;
        switch (this.jj_nt.kind) {
            case 276: {
                this.jj_consume_token(276);
                return DataTypeDescriptor.getBuiltInDataTypeDescriptor(91);
            }
            case 331: {
                this.jj_consume_token(331);
                return DataTypeDescriptor.getBuiltInDataTypeDescriptor(92);
            }
            case 332: {
                this.jj_consume_token(332);
                return DataTypeDescriptor.getBuiltInDataTypeDescriptor(93);
            }
        }
        this.jj_la1[77] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final void qualifiedNameList(Vector list, int id_length_limit) throws ParseException, StandardException {
        this.qualifiedNameElement(list, id_length_limit);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 424: {
                    break;
                }
                default: {
                    this.jj_la1[78] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(424);
            this.qualifiedNameElement(list, id_length_limit);
        }
    }

    public final void qualifiedNameElement(Vector list, int id_length_limit) throws ParseException, StandardException {
        TableName qualifiedName = null;
        qualifiedName = this.qualifiedName(id_length_limit);
        list.addElement(qualifiedName);
    }

    public final TableName qualifiedName(int nodeType, int id_length_limit) throws ParseException, StandardException {
        String qualifiedId;
        String schemaName = null;
        String firstName = null;
        String secondName = null;
        firstName = this.identifier(128, false);
        if (this.getToken((int)1).kind == 426 && this.getToken((int)2).kind != 422) {
            this.jj_consume_token(426);
            secondName = this.identifier(128, false);
        }
        if (secondName == null) {
            qualifiedId = firstName;
        } else {
            schemaName = firstName;
            qualifiedId = secondName;
        }
        this.checkIdentifierLengthLimit(qualifiedId, id_length_limit);
        if (schemaName != null) {
            this.checkIdentifierLengthLimit(schemaName, 128);
        }
        return (TableName)this.nodeFactory.getNode(nodeType, schemaName, qualifiedId, new Integer(this.lastIdentifierToken.beginOffset), new Integer(this.lastIdentifierToken.endOffset), this.getContextManager());
    }

    public final ResultSetNode queryExpression(ResultSetNode leftSide, int operatorType) throws ParseException, StandardException {
        ResultSetNode term = this.nonJoinQueryTerm(leftSide, operatorType);
        switch (this.jj_nt.kind) {
            case 127: 
            case 244: {
                term = this.unionOrExcept(term);
                break;
            }
            default: {
                this.jj_la1[79] = this.jj_gen;
            }
        }
        return term;
    }

    public final ResultSetNode unionOrExcept(ResultSetNode term) throws ParseException, StandardException {
        Token tok = null;
        switch (this.jj_nt.kind) {
            case 244: {
                this.jj_consume_token(244);
                block4 : switch (this.jj_nt.kind) {
                    case 60: 
                    case 120: {
                        switch (this.jj_nt.kind) {
                            case 60: {
                                tok = this.jj_consume_token(60);
                                break block4;
                            }
                            case 120: {
                                this.jj_consume_token(120);
                                break block4;
                            }
                        }
                        this.jj_la1[80] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    default: {
                        this.jj_la1[81] = this.jj_gen;
                    }
                }
                ResultSetNode expression = this.queryExpression(term, tok != null ? 2 : 1);
                return expression;
            }
            case 127: {
                this.jj_consume_token(127);
                block11 : switch (this.jj_nt.kind) {
                    case 60: 
                    case 120: {
                        switch (this.jj_nt.kind) {
                            case 60: {
                                tok = this.jj_consume_token(60);
                                break block11;
                            }
                            case 120: {
                                this.jj_consume_token(120);
                                break block11;
                            }
                        }
                        this.jj_la1[82] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    default: {
                        this.jj_la1[83] = this.jj_gen;
                    }
                }
                ResultSetNode expression = this.queryExpression(term, tok != null ? 4 : 3);
                return expression;
            }
        }
        this.jj_la1[84] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ResultSetNode nonJoinQueryTerm(ResultSetNode leftSide, int operatorType) throws ParseException, StandardException {
        ResultSetNode term = this.nonJoinQueryPrimary();
        switch (this.jj_nt.kind) {
            case 162: {
                term = this.intersect(term);
                break;
            }
            default: {
                this.jj_la1[85] = this.jj_gen;
            }
        }
        switch (operatorType) {
            case 0: {
                return term;
            }
            case 1: {
                return (ResultSetNode)this.nodeFactory.getNode(142, leftSide, term, Boolean.FALSE, Boolean.FALSE, null, this.getContextManager());
            }
            case 2: {
                return (ResultSetNode)this.nodeFactory.getNode(142, leftSide, term, Boolean.TRUE, Boolean.FALSE, null, this.getContextManager());
            }
            case 3: {
                return (ResultSetNode)this.nodeFactory.getNode(157, ReuseFactory.getInteger(2), leftSide, term, Boolean.FALSE, null, this.getContextManager());
            }
            case 4: {
                return (ResultSetNode)this.nodeFactory.getNode(157, ReuseFactory.getInteger(2), leftSide, term, Boolean.TRUE, null, this.getContextManager());
            }
            case 5: {
                return (ResultSetNode)this.nodeFactory.getNode(157, ReuseFactory.getInteger(1), leftSide, term, Boolean.FALSE, null, this.getContextManager());
            }
            case 6: {
                return (ResultSetNode)this.nodeFactory.getNode(157, ReuseFactory.getInteger(1), leftSide, term, Boolean.TRUE, null, this.getContextManager());
            }
        }
        SanityManager.THROWASSERT("Invalid set operator type: " + operatorType);
        return null;
    }

    public final ResultSetNode intersect(ResultSetNode term) throws ParseException, StandardException {
        Token tok = null;
        this.jj_consume_token(162);
        block0 : switch (this.jj_nt.kind) {
            case 60: 
            case 120: {
                switch (this.jj_nt.kind) {
                    case 60: {
                        tok = this.jj_consume_token(60);
                        break block0;
                    }
                    case 120: {
                        this.jj_consume_token(120);
                        break block0;
                    }
                }
                this.jj_la1[86] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[87] = this.jj_gen;
            }
        }
        ResultSetNode expression = this.nonJoinQueryTerm(term, tok != null ? 6 : 5);
        return expression;
    }

    public final ResultSetNode nonJoinQueryPrimary() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 218: 
            case 252: {
                ResultSetNode primary = this.simpleTable();
                return primary;
            }
            case 420: {
                this.jj_consume_token(420);
                ResultSetNode primary = this.queryExpression(null, 0);
                this.jj_consume_token(421);
                return primary;
            }
        }
        this.jj_la1[88] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ResultSetNode simpleTable() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 218: {
                ResultSetNode resultSetNode = this.querySpecification();
                return resultSetNode;
            }
            case 252: {
                ResultSetNode resultSetNode = this.tableValueConstructor();
                return resultSetNode;
            }
        }
        this.jj_la1[89] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ResultSetNode querySpecification() throws ParseException, StandardException {
        boolean isDistinct = false;
        this.jj_consume_token(218);
        if (this.jj_2_16(1)) {
            isDistinct = this.setQuantifier();
        }
        ResultColumnList selectList = this.selectList();
        SelectNode selectNode = this.tableExpression(selectList);
        if (isDistinct) {
            selectNode.makeDistinct();
        }
        return selectNode;
    }

    public final boolean setQuantifier() throws ParseException {
        if (this.getToken((int)1).kind == 120 && this.getToken((int)2).kind != 426 && this.getToken((int)2).kind != 429) {
            this.jj_consume_token(120);
            return true;
        }
        if (this.getToken((int)1).kind == 60 && this.getToken((int)2).kind != 426 && this.getToken((int)2).kind != 429) {
            this.jj_consume_token(60);
            return false;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ResultColumnList selectList() throws ParseException, StandardException {
        ResultColumnList resultColumns = (ResultColumnList)this.nodeFactory.getNode(9, this.getContextManager());
        switch (this.jj_nt.kind) {
            case 422: {
                this.jj_consume_token(422);
                ResultColumn allResultColumn = (ResultColumn)this.nodeFactory.getNode(16, null, this.getContextManager());
                resultColumns.addResultColumn(allResultColumn);
                return resultColumns;
            }
        }
        this.jj_la1[90] = this.jj_gen;
        if (this.jj_2_17(1)) {
            this.selectColumnList(resultColumns);
            return resultColumns;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final void selectColumnList(ResultColumnList resultColumns) throws ParseException, StandardException {
        this.selectSublist(resultColumns);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 424: {
                    break;
                }
                default: {
                    this.jj_la1[91] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(424);
            this.selectSublist(resultColumns);
        }
    }

    public final void selectSublist(ResultColumnList resultColumns) throws ParseException, StandardException {
        if (this.getToken((int)2).kind == 426 && (this.getToken((int)3).kind == 422 || this.getToken((int)4).kind == 426 && this.getToken((int)5).kind == 422)) {
            TableName tableName = this.qualifiedName(128);
            this.jj_consume_token(426);
            this.jj_consume_token(422);
            ResultColumn allResultColumn = (ResultColumn)this.nodeFactory.getNode(16, tableName, this.getContextManager());
            resultColumns.addResultColumn(allResultColumn);
        } else if (this.jj_2_18(1)) {
            ResultColumn resultColumn = this.derivedColumn(resultColumns);
            resultColumns.addResultColumn(resultColumn);
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
    }

    public final ResultColumn derivedColumn(ResultColumnList resultColumns) throws ParseException, StandardException {
        String columnName = null;
        ValueNode columnExpression = this.additiveExpression(null, 0, true);
        switch (this.jj_nt.kind) {
            case 66: 
            case 74: 
            case 87: 
            case 99: 
            case 107: 
            case 177: 
            case 231: 
            case 243: 
            case 251: 
            case 253: 
            case 263: 
            case 264: 
            case 265: 
            case 266: 
            case 267: 
            case 268: 
            case 269: 
            case 270: 
            case 271: 
            case 272: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 277: 
            case 279: 
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 284: 
            case 286: 
            case 288: 
            case 289: 
            case 290: 
            case 291: 
            case 292: 
            case 293: 
            case 294: 
            case 295: 
            case 296: 
            case 297: 
            case 298: 
            case 299: 
            case 300: 
            case 301: 
            case 302: 
            case 303: 
            case 304: 
            case 305: 
            case 306: 
            case 307: 
            case 308: 
            case 309: 
            case 310: 
            case 311: 
            case 312: 
            case 313: 
            case 314: 
            case 315: 
            case 317: 
            case 318: 
            case 319: 
            case 320: 
            case 321: 
            case 322: 
            case 323: 
            case 324: 
            case 325: 
            case 326: 
            case 327: 
            case 328: 
            case 329: 
            case 330: 
            case 331: 
            case 332: 
            case 333: 
            case 334: 
            case 335: 
            case 336: 
            case 337: 
            case 338: 
            case 339: 
            case 342: 
            case 343: 
            case 344: 
            case 348: 
            case 357: 
            case 358: 
            case 359: 
            case 360: 
            case 361: 
            case 362: 
            case 364: 
            case 365: 
            case 366: 
            case 367: 
            case 368: 
            case 369: 
            case 370: 
            case 371: 
            case 372: 
            case 373: 
            case 374: 
            case 375: 
            case 376: 
            case 377: 
            case 378: 
            case 379: 
            case 380: 
            case 382: 
            case 383: 
            case 384: 
            case 385: 
            case 387: 
            case 388: 
            case 389: 
            case 390: 
            case 391: 
            case 392: 
            case 393: 
            case 394: 
            case 395: 
            case 396: 
            case 397: 
            case 398: 
            case 399: 
            case 400: 
            case 401: 
            case 402: 
            case 403: 
            case 404: 
            case 405: 
            case 406: 
            case 407: 
            case 408: 
            case 409: 
            case 410: 
            case 411: 
            case 412: 
            case 413: 
            case 445: 
            case 451: {
                columnName = this.asClause();
                break;
            }
            default: {
                this.jj_la1[92] = this.jj_gen;
            }
        }
        if (columnName == null && columnExpression instanceof ColumnReference) {
            columnName = ((ColumnReference)columnExpression).columnName;
        }
        return (ResultColumn)this.nodeFactory.getNode(80, columnName, columnExpression, this.getContextManager());
    }

    public final String asClause() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 66: {
                this.jj_consume_token(66);
                break;
            }
            default: {
                this.jj_la1[93] = this.jj_gen;
            }
        }
        String columnName = this.identifier(128, true);
        return columnName;
    }

    public final ValueNode valueExpression(boolean inSelectClause) throws ParseException, StandardException {
        ValueNode leftOperand = this.orExpression(null, inSelectClause);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 192: {
                    break;
                }
                default: {
                    this.jj_la1[94] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(192);
            leftOperand = this.orExpression(leftOperand, inSelectClause);
        }
        return leftOperand;
    }

    public final ValueNode orExpression(ValueNode farLeftOperand, boolean inSelectClause) throws ParseException, StandardException {
        ValueNode leftOperand = this.andExpression(null, inSelectClause);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 63: {
                    break;
                }
                default: {
                    this.jj_la1[95] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(63);
            leftOperand = this.andExpression(leftOperand, inSelectClause);
        }
        if (farLeftOperand == null) {
            return leftOperand;
        }
        return (ValueNode)this.nodeFactory.getNode(52, farLeftOperand, leftOperand, this.getContextManager());
    }

    public final ValueNode andExpression(ValueNode farLeftOperand, boolean inSelectClause) throws ParseException, StandardException {
        Token tok = null;
        if (this.getToken((int)1).kind == 183 && this.getToken((int)2).kind != 426 && this.getToken((int)2).kind != 429) {
            tok = this.jj_consume_token(183);
        }
        ValueNode test = this.isSearchCondition(inSelectClause);
        if (tok != null) {
            test = (ValueNode)this.nodeFactory.getNode(26, test, this.getContextManager());
        }
        if (farLeftOperand != null) {
            test = (ValueNode)this.nodeFactory.getNode(39, farLeftOperand, test, this.getContextManager());
        }
        return test;
    }

    public final ValueNode isSearchCondition(boolean inSelectClause) throws ParseException, StandardException {
        ValueNode result;
        Token isToken = null;
        Token notToken = null;
        Object truthValue = null;
        ValueNode booleanPrimary = this.booleanPrimary(inSelectClause);
        switch (this.jj_nt.kind) {
            case 164: {
                isToken = this.jj_consume_token(164);
                switch (this.jj_nt.kind) {
                    case 183: {
                        notToken = this.jj_consume_token(183);
                        break;
                    }
                    default: {
                        this.jj_la1[96] = this.jj_gen;
                    }
                }
                this.jj_consume_token(184);
                break;
            }
            default: {
                this.jj_la1[97] = this.jj_gen;
            }
        }
        if (isToken != null) {
            result = (ValueNode)this.nodeFactory.getNode(25, booleanPrimary, this.getContextManager());
            if (notToken != null) {
                result = (ValueNode)this.nodeFactory.getNode(26, result, this.getContextManager());
            }
        } else {
            result = booleanPrimary;
        }
        return result;
    }

    public final ValueNode booleanPrimary(boolean inSelectClause) throws ParseException, StandardException {
        ValueNode primary = this.predicate(inSelectClause);
        return primary;
    }

    public final ValueNode predicate(boolean inSelectClause) throws ParseException, StandardException {
        ValueNode value;
        if (this.jj_2_19(1)) {
            value = this.additiveExpression(null, 0, inSelectClause);
        } else {
            switch (this.jj_nt.kind) {
                case 131: {
                    value = this.existsExpression();
                    break;
                }
                default: {
                    this.jj_la1[98] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        while (this.remainingPredicateFollows()) {
            value = this.remainingPredicate(value, inSelectClause);
        }
        return value;
    }

    public final ValueNode remainingPredicate(ValueNode value, boolean inSelectClause) throws ParseException, StandardException {
        Token tok = null;
        switch (this.jj_nt.kind) {
            case 431: 
            case 432: 
            case 433: 
            case 434: 
            case 435: 
            case 436: 
            case 437: {
                value = this.remainingNonNegatablePredicate(value, inSelectClause);
                return value;
            }
            case 73: 
            case 153: 
            case 171: 
            case 183: {
                switch (this.jj_nt.kind) {
                    case 183: {
                        tok = this.jj_consume_token(183);
                        break;
                    }
                    default: {
                        this.jj_la1[99] = this.jj_gen;
                    }
                }
                value = this.remainingNegatablePredicate(value, inSelectClause);
                if (tok != null) {
                    value = (ValueNode)this.nodeFactory.getNode(26, value, this.getContextManager());
                }
                return value;
            }
        }
        this.jj_la1[100] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode remainingNonNegatablePredicate(ValueNode leftOperand, boolean inSelectClause) throws ParseException, StandardException {
        Object tok = null;
        Object tree = null;
        int operator = this.compOp();
        if ((this.getToken((int)1).kind == 60 || this.getToken((int)1).kind == 64 || this.getToken((int)1).kind == 222) && this.getToken((int)2).kind == 420) {
            operator = this.quantifier(operator);
            this.jj_consume_token(420);
            leftOperand = this.tableSubquery(operator, leftOperand);
            this.jj_consume_token(421);
        } else if (this.jj_2_20(1)) {
            leftOperand = this.additiveExpression(leftOperand, operator, inSelectClause);
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return leftOperand;
    }

    public final ValueNode remainingNegatablePredicate(ValueNode leftOperand, boolean inSelectClause) throws ParseException, StandardException {
        ValueNode tree = null;
        ValueNode escapeValue = null;
        switch (this.jj_nt.kind) {
            case 153: {
                this.jj_consume_token(153);
                tree = this.inPredicateValue(leftOperand);
                return tree;
            }
            case 171: {
                this.jj_consume_token(171);
                ValueNode likePattern = this.additiveExpression(null, 0, inSelectClause);
                block5 : switch (this.jj_nt.kind) {
                    case 126: 
                    case 418: {
                        switch (this.jj_nt.kind) {
                            case 126: {
                                this.jj_consume_token(126);
                                escapeValue = this.additiveExpression(null, 0, inSelectClause);
                                break block5;
                            }
                            case 418: {
                                this.jj_consume_token(418);
                                this.jj_consume_token(126);
                                escapeValue = this.additiveExpression(null, 0, inSelectClause);
                                this.jj_consume_token(419);
                                break block5;
                            }
                        }
                        this.jj_la1[101] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    default: {
                        this.jj_la1[102] = this.jj_gen;
                    }
                }
                tree = (ValueNode)this.nodeFactory.getNode(51, leftOperand, likePattern, escapeValue, this.getContextManager());
                return tree;
            }
            case 73: {
                this.jj_consume_token(73);
                ValueNode betweenLeft = this.additiveExpression(null, 0, inSelectClause);
                this.jj_consume_token(63);
                ValueNode betweenRight = this.additiveExpression(null, 0, inSelectClause);
                ValueNodeList betweenList = (ValueNodeList)this.nodeFactory.getNode(15, this.getContextManager());
                betweenList.addElement(betweenLeft);
                betweenList.addElement(betweenRight);
                tree = (ValueNode)this.nodeFactory.getNode(53, leftOperand, betweenList, this.getContextManager());
                return tree;
            }
        }
        this.jj_la1[103] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final int compOp() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 433: {
                this.jj_consume_token(433);
                return 6;
            }
            case 434: {
                this.jj_consume_token(434);
                return 7;
            }
            case 435: {
                this.jj_consume_token(435);
                return 7;
            }
            case 431: {
                this.jj_consume_token(431);
                return 10;
            }
            case 436: {
                this.jj_consume_token(436);
                return 8;
            }
            case 432: {
                this.jj_consume_token(432);
                return 11;
            }
            case 437: {
                this.jj_consume_token(437);
                return 9;
            }
        }
        this.jj_la1[104] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode additiveExpression(ValueNode farLeftOperand, int compOp, boolean inSelectClause) throws ParseException, StandardException {
        int nodeType;
        ValueNode leftOperand = this.multiplicativeExpression(null, 0, inSelectClause);
        block11: while (true) {
            switch (this.jj_nt.kind) {
                case 423: 
                case 425: {
                    break;
                }
                default: {
                    this.jj_la1[105] = this.jj_gen;
                    break block11;
                }
            }
            int operator = this.additiveOperator();
            leftOperand = this.multiplicativeExpression(leftOperand, operator, inSelectClause);
        }
        if (farLeftOperand == null) {
            return leftOperand;
        }
        switch (compOp) {
            case 6: {
                nodeType = 41;
                break;
            }
            case 7: {
                nodeType = 47;
                break;
            }
            case 10: {
                nodeType = 45;
                break;
            }
            case 8: {
                nodeType = 43;
                break;
            }
            case 11: {
                nodeType = 44;
                break;
            }
            case 9: {
                nodeType = 42;
                break;
            }
            default: {
                SanityManager.THROWASSERT("Unknown comparison operator " + compOp);
                nodeType = 0;
            }
        }
        return (ValueNode)this.nodeFactory.getNode(nodeType, farLeftOperand, leftOperand, this.getContextManager());
    }

    public final int additiveOperator() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 423: {
                Token tok = this.jj_consume_token(423);
                return 1;
            }
            case 425: {
                Token tok = this.jj_consume_token(425);
                return 2;
            }
        }
        this.jj_la1[106] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode multiplicativeExpression(ValueNode farLeftOperand, int additiveOperator, boolean inSelectClause) throws ParseException, StandardException {
        ValueNode leftOperand = this.unaryExpression(null, 0, inSelectClause);
        block7: while (true) {
            switch (this.jj_nt.kind) {
                case 422: 
                case 427: 
                case 443: {
                    break;
                }
                default: {
                    this.jj_la1[107] = this.jj_gen;
                    break block7;
                }
            }
            int multOp = this.multiplicativeOperator();
            leftOperand = this.unaryExpression(leftOperand, multOp, inSelectClause);
        }
        if (farLeftOperand == null) {
            return leftOperand;
        }
        switch (additiveOperator) {
            case 1: {
                return (ValueNode)this.nodeFactory.getNode(48, farLeftOperand, leftOperand, this.getContextManager());
            }
            case 2: {
                return (ValueNode)this.nodeFactory.getNode(46, farLeftOperand, leftOperand, this.getContextManager());
            }
        }
        SanityManager.THROWASSERT("Unexpected operator value of " + additiveOperator);
        return null;
    }

    public final int multiplicativeOperator() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 422: {
                this.jj_consume_token(422);
                return 3;
            }
            case 427: {
                this.jj_consume_token(427);
                return 4;
            }
            case 443: {
                this.jj_consume_token(443);
                return 5;
            }
        }
        this.jj_la1[108] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode unaryExpression(ValueNode farLeftOperand, int multiplicativeOperator, boolean inSelectClause) throws ParseException, StandardException {
        int tokKind2;
        String sign = null;
        int tokKind1 = this.getToken((int)1).kind;
        if ((tokKind1 == 423 || tokKind1 == 425) && (tokKind2 = this.getToken((int)2).kind) != 452 && tokKind2 != 457) {
            sign = this.sign();
        }
        ValueNode value = this.primaryExpression(inSelectClause);
        if ("-".equals(sign)) {
            value = (ValueNode)this.nodeFactory.getNode(29, value, this.getContextManager());
        } else if ("+".equals(sign)) {
            value = (ValueNode)this.nodeFactory.getNode(30, value, this.getContextManager());
        } else if (sign != null) {
            SanityManager.THROWASSERT("Unknown unary operator '" + sign + "'");
        }
        return this.multOp(farLeftOperand, value, multiplicativeOperator);
    }

    public final String sign() throws ParseException {
        switch (this.jj_nt.kind) {
            case 423: {
                Token s = this.jj_consume_token(423);
                return s.image;
            }
            case 425: {
                Token s = this.jj_consume_token(425);
                return s.image;
            }
        }
        this.jj_la1[109] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode primaryExpressionXX(boolean inSelectClause) throws ParseException, StandardException {
        ValueNode value = this.primary(inSelectClause);
        while (this.jj_2_21(1)) {
            value = this.nonStaticMethodCallOrFieldAccess(value);
        }
        return value;
    }

    public final ValueNode nonStaticMethodCallOrFieldAccess(ValueNode receiver) throws ParseException, StandardException {
        ValueNode value = this.nonStaticMethodInvocation(receiver);
        return value;
    }

    public final ValueNode nonStaticMethodInvocation(ValueNode receiver) throws ParseException, StandardException {
        Vector parameterList = new Vector();
        if (this.getToken((int)3).kind == 420) {
            switch (this.jj_nt.kind) {
                case 444: {
                    this.jj_consume_token(444);
                    break;
                }
                case 426: {
                    this.jj_consume_token(426);
                    break;
                }
                default: {
                    this.jj_la1[110] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            MethodCallNode methodNode = this.methodName(receiver);
            this.methodCallParameterList(parameterList);
            if (receiver instanceof ParameterNode) {
                throw StandardException.newException("42X54", methodNode.getMethodName());
            }
            methodNode.addParms(parameterList);
            return (ValueNode)this.nodeFactory.getNode(36, methodNode, this.getContextManager());
        }
        switch (this.jj_nt.kind) {
            case 426: {
                this.jj_consume_token(426);
                MethodCallNode methodNode = this.methodName(receiver);
                if (receiver instanceof ParameterNode) {
                    throw StandardException.newException("42X54", methodNode.getMethodName());
                }
                methodNode.addParms(parameterList);
                return (ValueNode)this.nodeFactory.getNode(36, methodNode, this.getContextManager());
            }
        }
        this.jj_la1[111] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final MethodCallNode methodName(ValueNode receiver) throws ParseException, StandardException {
        String methodName = this.caseSensitiveIdentifierPlusReservedWords();
        return (MethodCallNode)this.nodeFactory.getNode(98, methodName, receiver, this.getContextManager());
    }

    public final MethodCallNode staticMethodName(String javaClassName) throws ParseException, StandardException {
        String methodName = this.caseSensitiveIdentifierPlusReservedWords();
        return (MethodCallNode)this.nodeFactory.getNode(85, methodName, javaClassName, this.getContextManager());
    }

    public final void methodParameter(Vector parameterList) throws ParseException, StandardException {
        if (this.jj_2_22(1)) {
            ValueNode parameter = this.additiveExpression(null, 0, false);
            parameterList.addElement(parameter);
        } else {
            switch (this.jj_nt.kind) {
                case 184: {
                    ValueNode parameter = this.nullSpecification();
                    parameterList.addElement(parameter);
                    break;
                }
                default: {
                    this.jj_la1[112] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
    }

    public final ValueNode primary(boolean inSelectClause) throws ParseException, StandardException {
        if (this.javaClassFollows()) {
            ValueNode value = this.staticClassReference();
            return value;
        }
        if (this.jj_2_23(1)) {
            ValueNode value = this.valueExpressionPrimary(inSelectClause);
            return value;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode staticClassReference() throws ParseException, StandardException {
        String javaClassName = this.javaClass();
        this.jj_consume_token(429);
        ValueNode value = this.staticClassReferenceType(javaClassName);
        return value;
    }

    public final ValueNode staticClassReferenceType(String javaClassName) throws ParseException, StandardException {
        if (this.getToken((int)2).kind == 420) {
            ValueNode value = this.staticMethodInvocation(javaClassName);
            return value;
        }
        switch (this.jj_nt.kind) {
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 206: 
            case 207: 
            case 208: 
            case 209: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 214: 
            case 215: 
            case 216: 
            case 217: 
            case 218: 
            case 219: 
            case 220: 
            case 221: 
            case 222: 
            case 223: 
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 228: 
            case 229: 
            case 230: 
            case 231: 
            case 232: 
            case 233: 
            case 234: 
            case 235: 
            case 236: 
            case 237: 
            case 238: 
            case 239: 
            case 240: 
            case 241: 
            case 242: 
            case 243: 
            case 244: 
            case 245: 
            case 246: 
            case 247: 
            case 248: 
            case 249: 
            case 250: 
            case 251: 
            case 252: 
            case 253: 
            case 254: 
            case 255: 
            case 256: 
            case 257: 
            case 258: 
            case 259: 
            case 260: 
            case 261: 
            case 262: 
            case 263: 
            case 264: 
            case 265: 
            case 266: 
            case 267: 
            case 268: 
            case 269: 
            case 270: 
            case 271: 
            case 272: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 277: 
            case 279: 
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 284: 
            case 285: 
            case 286: 
            case 288: 
            case 289: 
            case 290: 
            case 291: 
            case 292: 
            case 293: 
            case 294: 
            case 295: 
            case 296: 
            case 297: 
            case 298: 
            case 299: 
            case 300: 
            case 301: 
            case 302: 
            case 303: 
            case 304: 
            case 305: 
            case 306: 
            case 307: 
            case 308: 
            case 309: 
            case 310: 
            case 311: 
            case 312: 
            case 313: 
            case 314: 
            case 315: 
            case 317: 
            case 318: 
            case 319: 
            case 320: 
            case 321: 
            case 322: 
            case 323: 
            case 324: 
            case 325: 
            case 326: 
            case 327: 
            case 328: 
            case 329: 
            case 330: 
            case 331: 
            case 332: 
            case 333: 
            case 334: 
            case 335: 
            case 336: 
            case 337: 
            case 338: 
            case 339: 
            case 340: 
            case 341: 
            case 342: 
            case 343: 
            case 344: 
            case 345: 
            case 346: 
            case 347: 
            case 348: 
            case 349: 
            case 350: 
            case 351: 
            case 352: 
            case 353: 
            case 354: 
            case 355: 
            case 356: 
            case 357: 
            case 358: 
            case 359: 
            case 360: 
            case 361: 
            case 362: 
            case 364: 
            case 365: 
            case 366: 
            case 367: 
            case 368: 
            case 369: 
            case 370: 
            case 371: 
            case 372: 
            case 373: 
            case 374: 
            case 375: 
            case 376: 
            case 377: 
            case 378: 
            case 379: 
            case 380: 
            case 381: 
            case 382: 
            case 383: 
            case 384: 
            case 385: 
            case 386: 
            case 387: 
            case 388: 
            case 389: 
            case 390: 
            case 391: 
            case 392: 
            case 393: 
            case 394: 
            case 395: 
            case 396: 
            case 397: 
            case 398: 
            case 399: 
            case 400: 
            case 401: 
            case 402: 
            case 403: 
            case 404: 
            case 405: 
            case 406: 
            case 407: 
            case 408: 
            case 409: 
            case 410: 
            case 411: 
            case 412: 
            case 413: 
            case 445: 
            case 451: {
                ValueNode value = this.staticClassFieldReference(javaClassName);
                return value;
            }
        }
        this.jj_la1[113] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode staticClassFieldReference(String javaClassName) throws ParseException, StandardException {
        String fieldName = null;
        fieldName = this.caseSensitiveIdentifierPlusReservedWords();
        return (ValueNode)this.nodeFactory.getNode(36, this.nodeFactory.getNode(84, javaClassName, fieldName, this.nextToLastTokenDelimitedIdentifier, this.getContextManager()), this.getContextManager());
    }

    public final int nonSecondDatetimeField() throws ParseException {
        switch (this.jj_nt.kind) {
            case 262: {
                this.jj_consume_token(262);
                return 0;
            }
            case 298: {
                this.jj_consume_token(298);
                return 1;
            }
            case 277: {
                this.jj_consume_token(277);
                return 2;
            }
            case 150: {
                this.jj_consume_token(150);
                return 3;
            }
            case 176: {
                this.jj_consume_token(176);
                return 4;
            }
        }
        this.jj_la1[114] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode escapedValueFunction() throws ParseException, StandardException {
        ValueNode length = null;
        if (this.jj_2_24(1)) {
            ValueNode value = this.miscBuiltinsCore(true);
            return value;
        }
        switch (this.jj_nt.kind) {
            case 228: {
                this.jj_consume_token(228);
                this.jj_consume_token(420);
                ValueNode value = this.additiveExpression(null, 0, false);
                this.jj_consume_token(424);
                ValueNode startPosition = this.additiveExpression(null, 0, false);
                switch (this.jj_nt.kind) {
                    case 424: {
                        this.jj_consume_token(424);
                        length = this.additiveExpression(null, 0, false);
                        break;
                    }
                    default: {
                        this.jj_la1[115] = this.jj_gen;
                    }
                }
                this.jj_consume_token(421);
                return this.getSubstringNode(value, startPosition, length, Boolean.FALSE);
            }
            case 342: {
                this.jj_consume_token(342);
                this.jj_consume_token(420);
                this.jj_consume_token(421);
                return (ValueNode)this.nodeFactory.getNode(108, ReuseFactory.getInteger(0), this.getContextManager());
            }
            case 343: {
                this.jj_consume_token(343);
                this.jj_consume_token(420);
                this.jj_consume_token(421);
                return (ValueNode)this.nodeFactory.getNode(108, ReuseFactory.getInteger(1), this.getContextManager());
            }
            case 273: {
                this.jj_consume_token(273);
                this.jj_consume_token(420);
                ValueNode str1 = this.additiveExpression(null, 0, false);
                this.jj_consume_token(424);
                ValueNode str2 = this.additiveExpression(null, 0, false);
                this.jj_consume_token(421);
                return (ValueNode)this.nodeFactory.getNode(50, str1, str2, this.getContextManager());
            }
            case 105: 
            case 219: 
            case 249: {
                ValueNode value = this.userNode();
                this.jj_consume_token(420);
                this.jj_consume_token(421);
                return value;
            }
            case 333: 
            case 334: {
                ValueNode value = this.timestampArithmeticFuncion();
                return value;
            }
        }
        this.jj_la1[116] = this.jj_gen;
        if (this.getEscapedSYSFUN(this.getToken((int)1).image) != null) {
            ValueNode value = this.escapedSYSFUNFunction();
            return value;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode escapedSYSFUNFunction() throws ParseException, StandardException {
        Vector parameterList = new Vector();
        Token tok = this.jj_consume_token(445);
        this.methodCallParameterList(parameterList);
        String sysFunName = this.getEscapedSYSFUN(tok.image);
        TableName functionName = (TableName)this.nodeFactory.getNode(34, "SYSFUN", sysFunName, new Integer(0), new Integer(0), this.getContextManager());
        MethodCallNode methodNode = (MethodCallNode)this.nodeFactory.getNode(85, functionName, null, this.getContextManager());
        methodNode.addParms(parameterList);
        return (ValueNode)this.nodeFactory.getNode(36, methodNode, this.getContextManager());
    }

    public final ValueNode timestampArithmeticFuncion() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 333: {
                this.jj_consume_token(333);
                this.jj_consume_token(420);
                ValueNode intervalType = this.jdbcIntervalType();
                this.jj_consume_token(424);
                ValueNode count = this.additiveExpression(null, 0, false);
                this.jj_consume_token(424);
                ValueNode tstamp1 = this.additiveExpression(null, 0, false);
                this.jj_consume_token(421);
                return (ValueNode)this.nodeFactory.getNode(184, tstamp1, intervalType, count, ReuseFactory.getInteger(4), null, this.getContextManager());
            }
            case 334: {
                this.jj_consume_token(334);
                this.jj_consume_token(420);
                ValueNode intervalType = this.jdbcIntervalType();
                this.jj_consume_token(424);
                ValueNode tstamp1 = this.additiveExpression(null, 0, false);
                this.jj_consume_token(424);
                ValueNode tstamp2 = this.additiveExpression(null, 0, false);
                this.jj_consume_token(421);
                return (ValueNode)this.nodeFactory.getNode(185, tstamp2, intervalType, tstamp1, ReuseFactory.getInteger(5), null, this.getContextManager());
            }
        }
        this.jj_la1[117] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode jdbcIntervalType() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 318: {
                this.jj_consume_token(318);
                return this.getJdbcIntervalNode(0);
            }
            case 319: {
                this.jj_consume_token(319);
                return this.getJdbcIntervalNode(1);
            }
            case 320: {
                this.jj_consume_token(320);
                return this.getJdbcIntervalNode(2);
            }
            case 321: {
                this.jj_consume_token(321);
                return this.getJdbcIntervalNode(3);
            }
            case 322: {
                this.jj_consume_token(322);
                return this.getJdbcIntervalNode(4);
            }
            case 323: {
                this.jj_consume_token(323);
                return this.getJdbcIntervalNode(5);
            }
            case 324: {
                this.jj_consume_token(324);
                return this.getJdbcIntervalNode(6);
            }
            case 325: {
                this.jj_consume_token(325);
                return this.getJdbcIntervalNode(7);
            }
            case 326: {
                this.jj_consume_token(326);
                return this.getJdbcIntervalNode(8);
            }
        }
        this.jj_la1[118] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode numericValueFunction() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 263: {
                this.jj_consume_token(263);
                ValueNode value = this.absFunction();
                return value;
            }
            case 264: {
                this.jj_consume_token(264);
                ValueNode value = this.absFunction();
                return value;
            }
            case 406: {
                this.jj_consume_token(406);
                this.jj_consume_token(420);
                ValueNode value = this.additiveExpression(null, 0, false);
                this.jj_consume_token(421);
                return (ValueNode)this.nodeFactory.getNode(189, value, this.getContextManager());
            }
            case 295: {
                this.jj_consume_token(295);
                ValueNode value = this.modFunction();
                return value;
            }
            case 282: {
                this.jj_consume_token(282);
                this.jj_consume_token(420);
                this.jj_consume_token(421);
                return (ValueNode)this.nodeFactory.getNode(5, this.getContextManager());
            }
        }
        this.jj_la1[119] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode coalesceFunction(String coalesceOrValue) throws ParseException, StandardException {
        ValueNodeList expressionList = (ValueNodeList)this.nodeFactory.getNode(15, this.getContextManager());
        this.jj_consume_token(420);
        this.coalesceExpression(expressionList);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 424: {
                    break;
                }
                default: {
                    this.jj_la1[120] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(424);
            this.coalesceExpression(expressionList);
        }
        this.jj_consume_token(421);
        return (ValueNode)this.nodeFactory.getNode(192, coalesceOrValue, expressionList, this.getContextManager());
    }

    public final void coalesceExpression(ValueNodeList expressionList) throws ParseException, StandardException {
        ValueNode expression = this.additiveExpression(null, 0, false);
        expressionList.addElement(expression);
    }

    public final ValueNode absFunction() throws ParseException, StandardException {
        this.jj_consume_token(420);
        ValueNode value = this.additiveExpression(null, 0, false);
        this.jj_consume_token(421);
        return (ValueNode)this.nodeFactory.getNode(188, value, this.getContextManager());
    }

    public final ValueNode modFunction() throws ParseException, StandardException {
        this.jj_consume_token(420);
        ValueNode int1 = this.additiveExpression(null, 0, false);
        this.jj_consume_token(424);
        ValueNode int2 = this.additiveExpression(null, 0, false);
        this.jj_consume_token(421);
        return (ValueNode)this.nodeFactory.getNode(194, int1, int2, this.getContextManager());
    }

    public final int datetimeField() throws ParseException {
        switch (this.jj_nt.kind) {
            case 150: 
            case 176: 
            case 262: 
            case 277: 
            case 298: {
                int field = this.nonSecondDatetimeField();
                return field;
            }
            case 217: {
                this.jj_consume_token(217);
                return 5;
            }
        }
        this.jj_la1[121] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode characterValueFunction() throws ParseException, StandardException {
        ValueNode value = null;
        Token upperTok = null;
        Token lowerTok = null;
        ValueNode length = null;
        switch (this.jj_nt.kind) {
            case 351: {
                this.jj_consume_token(351);
                this.jj_consume_token(420);
                value = this.additiveExpression(null, 0, false);
                this.jj_consume_token(424);
                ValueNode startPosition = this.additiveExpression(null, 0, false);
                switch (this.jj_nt.kind) {
                    case 424: {
                        this.jj_consume_token(424);
                        length = this.additiveExpression(null, 0, false);
                        break;
                    }
                    default: {
                        this.jj_la1[122] = this.jj_gen;
                    }
                }
                this.jj_consume_token(421);
                return this.getSubstringNode(value, startPosition, length, Boolean.FALSE);
            }
            case 172: 
            case 248: {
                switch (this.jj_nt.kind) {
                    case 248: {
                        upperTok = this.jj_consume_token(248);
                        break;
                    }
                    case 172: {
                        lowerTok = this.jj_consume_token(172);
                        break;
                    }
                    default: {
                        this.jj_la1[123] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_consume_token(420);
                value = this.additiveExpression(null, 0, false);
                this.jj_consume_token(421);
                return (ValueNode)this.nodeFactory.getNode(83, value, upperTok != null ? "upper" : "lower", this.getContextManager());
            }
            case 373: 
            case 411: {
                switch (this.jj_nt.kind) {
                    case 411: {
                        upperTok = this.jj_consume_token(411);
                        break;
                    }
                    case 373: {
                        lowerTok = this.jj_consume_token(373);
                        break;
                    }
                    default: {
                        this.jj_la1[124] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_consume_token(420);
                value = this.additiveExpression(null, 0, false);
                this.jj_consume_token(421);
                return (ValueNode)this.nodeFactory.getNode(83, value, upperTok != null ? "upper" : "lower", this.getContextManager());
            }
            case 241: 
            case 349: 
            case 350: {
                value = this.trimFunction();
                return value;
            }
            case 374: {
                this.jj_consume_token(374);
                this.jj_consume_token(420);
                ValueNode str1 = this.additiveExpression(null, 0, false);
                this.jj_consume_token(424);
                ValueNode str2 = this.additiveExpression(null, 0, false);
                switch (this.jj_nt.kind) {
                    case 424: {
                        this.jj_consume_token(424);
                        value = this.additiveExpression(null, 0, false);
                        break;
                    }
                    default: {
                        this.jj_la1[125] = this.jj_gen;
                    }
                }
                this.jj_consume_token(421);
                return (ValueNode)this.nodeFactory.getNode(190, str1, str2, value == null ? this.getNodeFactory().getNode(70, ReuseFactory.getInteger(1), this.getContextManager()) : value, ReuseFactory.getInteger(1), null, this.getContextManager());
            }
        }
        this.jj_la1[126] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode trimFunction() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 349: 
            case 350: {
                Integer trimType = this.trimType();
                this.jj_consume_token(420);
                ValueNode source = this.additiveExpression(null, 0, false);
                this.jj_consume_token(421);
                return this.getTrimOperatorNode(trimType, null, source, null);
            }
            case 241: {
                this.jj_consume_token(241);
                ValueNode ansiTrimNode = this.ansiTrim();
                return ansiTrimNode;
            }
        }
        this.jj_la1[127] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode ansiTrim() throws ParseException, StandardException {
        Integer trimSpec = ReuseFactory.getInteger(0);
        ValueNode trimChar = null;
        ValueNode trimSource = null;
        if (this.ansiTrimSpecFollows()) {
            this.jj_consume_token(420);
            trimSpec = this.ansiTrimSpec();
            if (this.jj_2_25(Integer.MAX_VALUE)) {
                this.jj_consume_token(140);
                trimSource = this.additiveExpression(null, 0, false);
                this.jj_consume_token(421);
                return this.getTrimOperatorNode(trimSpec, trimChar, trimSource, null);
            }
            if (this.jj_2_26(1)) {
                trimChar = this.additiveExpression(null, 0, false);
                this.jj_consume_token(140);
                trimSource = this.additiveExpression(null, 0, false);
                this.jj_consume_token(421);
                return this.getTrimOperatorNode(trimSpec, trimChar, trimSource, null);
            }
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        if (!this.ansiTrimSpecFollows()) {
            this.jj_consume_token(420);
            trimChar = this.additiveExpression(null, 0, false);
            switch (this.jj_nt.kind) {
                case 140: {
                    this.jj_consume_token(140);
                    trimSource = this.additiveExpression(null, 0, false);
                    this.jj_consume_token(421);
                    return this.getTrimOperatorNode(trimSpec, trimChar, trimSource, null);
                }
                case 421: {
                    this.jj_consume_token(421);
                    return this.getTrimOperatorNode(trimSpec, null, trimChar, null);
                }
            }
            this.jj_la1[128] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Integer ansiTrimSpec() throws ParseException {
        switch (this.jj_nt.kind) {
            case 240: {
                this.jj_consume_token(240);
                return ReuseFactory.getInteger(1);
            }
            case 169: {
                this.jj_consume_token(169);
                return ReuseFactory.getInteger(2);
            }
            case 76: {
                this.jj_consume_token(76);
                return ReuseFactory.getInteger(0);
            }
        }
        this.jj_la1[129] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Integer trimType() throws ParseException {
        switch (this.jj_nt.kind) {
            case 350: {
                this.jj_consume_token(350);
                return ReuseFactory.getInteger(1);
            }
            case 349: {
                this.jj_consume_token(349);
                return ReuseFactory.getInteger(2);
            }
        }
        this.jj_la1[130] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode valueExpressionPrimary(boolean inSelectClause) throws ParseException, StandardException {
        if (this.escapedValueFunctionFollows()) {
            this.jj_consume_token(418);
            this.jj_consume_token(370);
            ValueNode value = this.escapedValueFunction();
            this.jj_consume_token(419);
            return value;
        }
        if (this.getToken((int)2).kind == 215 || this.getToken((int)2).kind == 404) {
            this.jj_consume_token(101);
            switch (this.jj_nt.kind) {
                case 215: {
                    this.jj_consume_token(215);
                    break;
                }
                case 404: {
                    this.jj_consume_token(404);
                    break;
                }
                default: {
                    this.jj_la1[131] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            return (ValueNode)this.nodeFactory.getNode(6, this.getContextManager());
        }
        if (this.getToken((int)2).kind == 165) {
            this.jj_consume_token(101);
            this.jj_consume_token(165);
            return (ValueNode)this.nodeFactory.getNode(4, this.getContextManager());
        }
        switch (this.jj_nt.kind) {
            case 80: 
            case 105: 
            case 133: 
            case 185: 
            case 219: 
            case 242: 
            case 249: 
            case 418: 
            case 423: 
            case 425: 
            case 438: 
            case 452: 
            case 455: 
            case 456: 
            case 457: {
                ValueNode value = this.valueSpecification();
                return value;
            }
        }
        this.jj_la1[132] = this.jj_gen;
        if (this.newInvocationFollows(1)) {
            JavaToSQLValueNode value = this.newInvocation();
            return value;
        }
        if (this.aggregateFollows()) {
            ValueNode value = this.aggregateNode();
            return value;
        }
        if (this.miscBuiltinFollows()) {
            ValueNode value = this.miscBuiltins();
            return value;
        }
        switch (this.jj_nt.kind) {
            case 74: 
            case 87: 
            case 99: 
            case 107: 
            case 177: 
            case 231: 
            case 243: 
            case 251: 
            case 253: 
            case 263: 
            case 264: 
            case 265: 
            case 266: 
            case 267: 
            case 268: 
            case 269: 
            case 270: 
            case 271: 
            case 272: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 277: 
            case 279: 
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 284: 
            case 286: 
            case 288: 
            case 289: 
            case 290: 
            case 291: 
            case 292: 
            case 293: 
            case 294: 
            case 295: 
            case 296: 
            case 297: 
            case 298: 
            case 299: 
            case 300: 
            case 301: 
            case 302: 
            case 303: 
            case 304: 
            case 305: 
            case 306: 
            case 307: 
            case 308: 
            case 309: 
            case 310: 
            case 311: 
            case 312: 
            case 313: 
            case 314: 
            case 315: 
            case 317: 
            case 318: 
            case 319: 
            case 320: 
            case 321: 
            case 322: 
            case 323: 
            case 324: 
            case 325: 
            case 326: 
            case 327: 
            case 328: 
            case 329: 
            case 330: 
            case 331: 
            case 332: 
            case 333: 
            case 334: 
            case 335: 
            case 336: 
            case 337: 
            case 338: 
            case 339: 
            case 342: 
            case 343: 
            case 344: 
            case 348: 
            case 357: 
            case 358: 
            case 359: 
            case 360: 
            case 361: 
            case 362: 
            case 364: 
            case 365: 
            case 366: 
            case 367: 
            case 368: 
            case 369: 
            case 370: 
            case 371: 
            case 372: 
            case 373: 
            case 374: 
            case 375: 
            case 376: 
            case 377: 
            case 378: 
            case 379: 
            case 380: 
            case 382: 
            case 383: 
            case 384: 
            case 385: 
            case 387: 
            case 388: 
            case 389: 
            case 390: 
            case 391: 
            case 392: 
            case 393: 
            case 394: 
            case 395: 
            case 396: 
            case 397: 
            case 398: 
            case 399: 
            case 400: 
            case 401: 
            case 402: 
            case 403: 
            case 404: 
            case 405: 
            case 406: 
            case 407: 
            case 408: 
            case 409: 
            case 410: 
            case 411: 
            case 412: 
            case 413: 
            case 445: 
            case 451: {
                ColumnReference value = this.columnReference();
                return value;
            }
            case 420: {
                ValueNode value;
                this.jj_consume_token(420);
                if (this.getToken((int)1).kind == 218 || this.getToken((int)1).kind == 252) {
                    value = this.subquery(17, null);
                } else if (inSelectClause) {
                    value = this.additiveExpression(null, 0, inSelectClause);
                } else if (this.jj_2_27(1)) {
                    value = this.valueExpression(inSelectClause);
                } else {
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                this.jj_consume_token(421);
                return value;
            }
            case 81: {
                ValueNode value = this.castSpecification();
                return value;
            }
        }
        this.jj_la1[133] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode miscBuiltins() throws ParseException, StandardException {
        if ((this.getToken((int)1).kind == 345 || this.getToken((int)1).kind == 263 || this.getToken((int)1).kind == 264 || this.getToken((int)1).kind == 406 || this.getToken((int)1).kind == 295 || this.getToken((int)1).kind == 87 || this.getToken((int)1).kind == 251 || this.getToken((int)1).kind == 282 || this.getToken((int)1).kind == 228 || this.getToken((int)1).kind == 351 || this.getToken((int)1).kind == 248 || this.getToken((int)1).kind == 172 || this.getToken((int)1).kind == 411 || this.getToken((int)1).kind == 373 || this.getToken((int)1).kind == 349 || this.getToken((int)1).kind == 350 || this.getToken((int)1).kind == 241 || this.getToken((int)1).kind == 276 || this.getToken((int)1).kind == 331 || this.getToken((int)1).kind == 332 || this.getToken((int)1).kind == 121 || this.getToken((int)1).kind == 82 || this.getToken((int)1).kind == 254 || this.getToken((int)1).kind == 161 || this.getToken((int)1).kind == 160 || this.getToken((int)1).kind == 221 || this.getToken((int)1).kind == 347 || this.getToken((int)1).kind == 262 || this.getToken((int)1).kind == 298 || this.getToken((int)1).kind == 277 || this.getToken((int)1).kind == 150 || this.getToken((int)1).kind == 176 || this.getToken((int)1).kind == 217 || this.getToken((int)1).kind == 290 || this.getToken((int)1).kind == 374 || this.getToken((int)1).kind == 354 || this.getToken((int)1).kind == 356 || this.getToken((int)1).kind == 353 || this.getToken((int)1).kind == 355) && this.getToken((int)2).kind == 420) {
            ValueNode value = this.miscBuiltinsCore(false);
            return value;
        }
        if (this.jj_2_28(1)) {
            ValueNode value = this.datetimeValueFunction();
            return value;
        }
        switch (this.jj_nt.kind) {
            case 74: 
            case 87: 
            case 99: 
            case 107: 
            case 177: 
            case 231: 
            case 243: 
            case 251: 
            case 253: 
            case 263: 
            case 264: 
            case 265: 
            case 266: 
            case 267: 
            case 268: 
            case 269: 
            case 270: 
            case 271: 
            case 272: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 277: 
            case 279: 
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 284: 
            case 286: 
            case 288: 
            case 289: 
            case 290: 
            case 291: 
            case 292: 
            case 293: 
            case 294: 
            case 295: 
            case 296: 
            case 297: 
            case 298: 
            case 299: 
            case 300: 
            case 301: 
            case 302: 
            case 303: 
            case 304: 
            case 305: 
            case 306: 
            case 307: 
            case 308: 
            case 309: 
            case 310: 
            case 311: 
            case 312: 
            case 313: 
            case 314: 
            case 315: 
            case 317: 
            case 318: 
            case 319: 
            case 320: 
            case 321: 
            case 322: 
            case 323: 
            case 324: 
            case 325: 
            case 326: 
            case 327: 
            case 328: 
            case 329: 
            case 330: 
            case 331: 
            case 332: 
            case 333: 
            case 334: 
            case 335: 
            case 336: 
            case 337: 
            case 338: 
            case 339: 
            case 342: 
            case 343: 
            case 344: 
            case 348: 
            case 357: 
            case 358: 
            case 359: 
            case 360: 
            case 361: 
            case 362: 
            case 364: 
            case 365: 
            case 366: 
            case 367: 
            case 368: 
            case 369: 
            case 370: 
            case 371: 
            case 372: 
            case 373: 
            case 374: 
            case 375: 
            case 376: 
            case 377: 
            case 378: 
            case 379: 
            case 380: 
            case 382: 
            case 383: 
            case 384: 
            case 385: 
            case 387: 
            case 388: 
            case 389: 
            case 390: 
            case 391: 
            case 392: 
            case 393: 
            case 394: 
            case 395: 
            case 396: 
            case 397: 
            case 398: 
            case 399: 
            case 400: 
            case 401: 
            case 402: 
            case 403: 
            case 404: 
            case 405: 
            case 406: 
            case 407: 
            case 408: 
            case 409: 
            case 410: 
            case 411: 
            case 412: 
            case 413: 
            case 445: 
            case 451: {
                ValueNode value = this.routineInvocation();
                return value;
            }
        }
        this.jj_la1[134] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode miscBuiltinsCore(boolean isJDBCEscape) throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 345: {
                this.jj_consume_token(345);
                this.jj_consume_token(420);
                this.jj_consume_token(421);
                this.checkInternalFeature("GETCURRENTCONNECTION()");
                return (ValueNode)this.nodeFactory.getNode(36, this.nodeFactory.getNode(18, this.getContextManager()), this.getContextManager());
            }
            case 263: 
            case 264: 
            case 282: 
            case 295: 
            case 406: {
                ValueNode value = this.numericValueFunction();
                return value;
            }
            case 172: 
            case 241: 
            case 248: 
            case 349: 
            case 350: 
            case 351: 
            case 373: 
            case 374: 
            case 411: {
                ValueNode value = this.characterValueFunction();
                return value;
            }
        }
        this.jj_la1[135] = this.jj_gen;
        if (this.jj_2_29(1)) {
            ValueNode value = this.dataTypeScalarFunction();
            return value;
        }
        switch (this.jj_nt.kind) {
            case 87: {
                this.jj_consume_token(87);
                ValueNode value = this.coalesceFunction("COALESCE");
                return value;
            }
            case 251: {
                this.jj_consume_token(251);
                ValueNode value = this.coalesceFunction("VALUE");
                return value;
            }
            case 290: {
                this.jj_consume_token(290);
                this.jj_consume_token(420);
                ValueNode value = this.additiveExpression(null, 0, false);
                this.jj_consume_token(421);
                ContextManager localCM = this.getContextManager();
                if (isJDBCEscape) {
                    return (ValueNode)this.nodeFactory.getNode(23, this.getTrimOperatorNode(ReuseFactory.getInteger(1), null, value, localCM), localCM);
                }
                return (ValueNode)this.nodeFactory.getNode(20, value, localCM);
            }
            case 353: 
            case 354: 
            case 355: 
            case 356: {
                ValueNode value = this.xmlFunction();
                return value;
            }
        }
        this.jj_la1[136] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode dataTypeScalarFunction() throws ParseException, StandardException {
        int length = -1;
        switch (this.jj_nt.kind) {
            case 150: 
            case 176: 
            case 217: 
            case 262: 
            case 276: 
            case 277: 
            case 298: 
            case 331: 
            case 332: {
                ValueNode value = this.dateTimeScalarFunction();
                return value;
            }
        }
        this.jj_la1[138] = this.jj_gen;
        if (this.jj_2_30(1)) {
            DataTypeDescriptor dts = this.numericFunctionType();
            this.jj_consume_token(420);
            ValueNode operand = this.additiveExpression(null, 0, false);
            this.jj_consume_token(421);
            ValueNode value = (ValueNode)this.nodeFactory.getNode(60, operand, dts, this.getContextManager());
            ((CastNode)value).setForDataTypeFunction(true);
            ((CastNode)value).setForExternallyGeneratedCASTnode();
            return value;
        }
        switch (this.jj_nt.kind) {
            case 82: 
            case 254: {
                int charType = this.charOrVarchar();
                this.jj_consume_token(420);
                ValueNode operand = this.additiveExpression(null, 0, false);
                switch (this.jj_nt.kind) {
                    case 424: {
                        this.jj_consume_token(424);
                        length = this.length();
                        break;
                    }
                    default: {
                        this.jj_la1[137] = this.jj_gen;
                    }
                }
                this.jj_consume_token(421);
                this.checkTypeLimits(charType, length);
                ValueNode value = (ValueNode)this.nodeFactory.getNode(60, operand, new Integer(charType), new Integer(length), this.getContextManager());
                ((CastNode)value).setForDataTypeFunction(true);
                ((CastNode)value).setForExternallyGeneratedCASTnode();
                return value;
            }
        }
        this.jj_la1[139] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode xmlFunction() throws ParseException, StandardException {
        this.checkVersion(130, "XML");
        XML.checkXMLRequirements();
        switch (this.jj_nt.kind) {
            case 354: {
                this.jj_consume_token(354);
                this.jj_consume_token(420);
                this.xmlDocOrContent();
                ValueNode value = this.xmlParseValue();
                this.jj_consume_token(421);
                return value;
            }
            case 356: {
                this.jj_consume_token(356);
                this.jj_consume_token(420);
                ValueNode value = this.xmlSerializeValue();
                this.jj_consume_token(421);
                return value;
            }
            case 353: {
                this.jj_consume_token(353);
                this.jj_consume_token(420);
                ValueNode value = this.xmlQueryValue(true);
                this.jj_consume_token(421);
                return value;
            }
            case 355: {
                this.jj_consume_token(355);
                this.jj_consume_token(420);
                ValueNode value = this.xmlQueryValue(false);
                this.jj_consume_token(421);
                return value;
            }
        }
        this.jj_la1[140] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode xmlParseValue() throws ParseException, StandardException {
        ValueNode value = this.additiveExpression(null, 0, false);
        boolean wsOption = this.xmlPreserveWhitespace();
        return (ValueNode)this.nodeFactory.getNode(200, value, ReuseFactory.getInteger(0), new Object[]{wsOption ? Boolean.TRUE : Boolean.FALSE}, this.getContextManager());
    }

    public final boolean xmlPreserveWhitespace() throws ParseException, StandardException {
        if (this.getToken((int)1).kind != 408 && this.getToken((int)1).kind != 200) {
            throw StandardException.newException("42Z72", (Object)"PRESERVE WHITESPACE", (Object)ReuseFactory.getInteger(this.getToken((int)1).beginLine), (Object)ReuseFactory.getInteger(this.getToken((int)1).beginColumn));
        }
        switch (this.jj_nt.kind) {
            case 408: {
                this.jj_consume_token(408);
                this.jj_consume_token(413);
                throw StandardException.newException("42Z74", "STRIP WHITESPACE");
            }
            case 200: {
                this.jj_consume_token(200);
                this.jj_consume_token(413);
                return true;
            }
        }
        this.jj_la1[141] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode xmlSerializeValue() throws ParseException, StandardException {
        ValueNode value = this.additiveExpression(null, 0, false);
        DataTypeDescriptor targetType = this.xmlSerializeTargetType();
        return (ValueNode)this.nodeFactory.getNode(201, value, ReuseFactory.getInteger(1), new Object[]{targetType}, this.getContextManager());
    }

    public final DataTypeDescriptor xmlSerializeTargetType() throws ParseException, StandardException {
        if (this.getToken((int)1).kind != 66) {
            throw StandardException.newException("42Z72", (Object)"AS", (Object)ReuseFactory.getInteger(this.getToken((int)1).beginLine), (Object)ReuseFactory.getInteger(this.getToken((int)1).beginColumn));
        }
        switch (this.jj_nt.kind) {
            case 66: {
                this.jj_consume_token(66);
                DataTypeDescriptor targetType = this.dataTypeDDL();
                return targetType;
            }
        }
        this.jj_la1[142] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode xmlQueryValue(boolean existsOnly) throws ParseException, StandardException {
        ValueNode xqueryExpr = null;
        ValueNode xmlValue = null;
        int defaultPassingMech = -1;
        xqueryExpr = this.additiveExpression(null, 0, false);
        this.jj_consume_token(388);
        defaultPassingMech = this.xmlPassingMechanism();
        xmlValue = this.xqVarList();
        if (!existsOnly) {
            if (this.jj_2_32(1)) {
                this.xqReturningClause();
                if (this.jj_2_31(1)) {
                    this.xmlPassingMechanism();
                }
            }
            this.xqEmptyHandlingClause();
        } else if (!existsOnly) {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        ValueNode vNode = (ValueNode)this.nodeFactory.getNode(existsOnly ? 202 : 203, xqueryExpr, xmlValue, existsOnly ? ReuseFactory.getInteger(0) : ReuseFactory.getInteger(1), this.getContextManager());
        return vNode;
    }

    public final ValueNode xqVarList() throws ParseException, StandardException {
        ValueNode[] xmlValue = new ValueNode[]{null};
        this.xqVariable(xmlValue);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 424: {
                    break;
                }
                default: {
                    this.jj_la1[143] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(424);
            this.xqVariable(xmlValue);
        }
        return xmlValue[0];
    }

    public final void xqVariable(ValueNode[] xmlVal) throws ParseException, StandardException {
        String varName = null;
        int passingMech = -1;
        ValueNode curVal = this.additiveExpression(null, 0, false);
        if (this.getToken((int)1).kind == 66) {
            this.jj_consume_token(66);
            varName = this.identifier(128, true);
            throw StandardException.newException("42Z74", "PASSING ... AS");
        }
        if (this.jj_2_33(1)) {
            passingMech = this.xmlPassingMechanism();
        }
        if (varName == null) {
            if (xmlVal[0] != null) {
                throw StandardException.newException("42Z76");
            }
            xmlVal[0] = curVal;
        }
    }

    public final short xmlPassingMechanism() throws ParseException, StandardException {
        if (this.getToken((int)2).kind == 391) {
            this.jj_consume_token(77);
            this.jj_consume_token(391);
            return 1;
        }
        switch (this.jj_nt.kind) {
            case 77: {
                this.jj_consume_token(77);
                this.jj_consume_token(251);
                throw StandardException.newException("42Z74", "BY VALUE");
            }
        }
        this.jj_la1[144] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final short xqReturningClause() throws ParseException, StandardException {
        if (this.getToken((int)2).kind == 400) {
            this.jj_consume_token(397);
            this.jj_consume_token(400);
            return 3;
        }
        switch (this.jj_nt.kind) {
            case 397: {
                this.jj_consume_token(397);
                this.jj_consume_token(361);
                throw StandardException.newException("42Z74", "RETURNING CONTENT");
            }
        }
        this.jj_la1[145] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final short xqEmptyHandlingClause() throws ParseException, StandardException {
        if (this.getToken((int)1).kind == 368) {
            this.jj_consume_token(368);
            this.jj_consume_token(188);
            this.jj_consume_token(368);
            return 5;
        }
        switch (this.jj_nt.kind) {
            case 184: {
                this.jj_consume_token(184);
                this.jj_consume_token(188);
                this.jj_consume_token(368);
                throw StandardException.newException("42Z74", "NULL ON EMPTY");
            }
        }
        this.jj_la1[146] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final DataTypeDescriptor numericFunctionType() throws ParseException, StandardException {
        if (this.jj_2_34(1)) {
            DataTypeDescriptor dts = this.doubleType();
            return dts;
        }
        switch (this.jj_nt.kind) {
            case 160: 
            case 161: 
            case 221: 
            case 347: {
                DataTypeDescriptor dts = this.exactIntegerType();
                return dts;
            }
        }
        this.jj_la1[147] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode dateTimeScalarFunction() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 331: {
                this.jj_consume_token(331);
                this.jj_consume_token(420);
                ValueNode value = this.additiveExpression(null, 0, false);
                this.jj_consume_token(421);
                ValueNode castValue = (ValueNode)this.nodeFactory.getNode(60, value, DataTypeDescriptor.getBuiltInDataTypeDescriptor(92), this.getContextManager());
                ((CastNode)castValue).setForExternallyGeneratedCASTnode();
                return castValue;
            }
            case 276: {
                this.jj_consume_token(276);
                this.jj_consume_token(420);
                ValueNode value = this.additiveExpression(null, 0, false);
                this.jj_consume_token(421);
                return (ValueNode)this.nodeFactory.getNode(32, value, DataTypeDescriptor.getBuiltInDataTypeDescriptor(91), this.getContextManager());
            }
            case 332: {
                this.jj_consume_token(332);
                this.jj_consume_token(420);
                ValueNode value = this.additiveExpression(null, 0, false);
                ValueNode timestampNode = this.timestampFunctionCompletion(value);
                return timestampNode;
            }
            case 150: 
            case 176: 
            case 217: 
            case 262: 
            case 277: 
            case 298: {
                int field = this.datetimeField();
                this.jj_consume_token(420);
                ValueNode value = this.additiveExpression(null, 0, false);
                this.jj_consume_token(421);
                return (ValueNode)this.nodeFactory.getNode(87, ReuseFactory.getInteger(field), value, this.getContextManager());
            }
        }
        this.jj_la1[148] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode timestampFunctionCompletion(ValueNode firstArg) throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 421: {
                this.jj_consume_token(421);
                return (ValueNode)this.nodeFactory.getNode(32, firstArg, DataTypeDescriptor.getBuiltInDataTypeDescriptor(93), this.getContextManager());
            }
            case 424: {
                this.jj_consume_token(424);
                ValueNode timeValue = this.additiveExpression(null, 0, false);
                this.jj_consume_token(421);
                return (ValueNode)this.nodeFactory.getNode(33, firstArg, timeValue, this.getContextManager());
            }
        }
        this.jj_la1[149] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Token booleanLiteral() throws ParseException {
        switch (this.jj_nt.kind) {
            case 242: {
                Token tok = this.jj_consume_token(242);
                return tok;
            }
            case 133: {
                Token tok = this.jj_consume_token(133);
                return tok;
            }
        }
        this.jj_la1[150] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode generalValueSpecification() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 438: {
                ParameterNode parm = this.dynamicParameterSpecification();
                return parm;
            }
            case 105: 
            case 219: 
            case 249: {
                ValueNode parm = this.userNode();
                return parm;
            }
        }
        this.jj_la1[151] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode userNode() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 249: {
                this.jj_consume_token(249);
                return (ValueNode)this.nodeFactory.getNode(110, this.getContextManager());
            }
            case 105: {
                this.jj_consume_token(105);
                return (ValueNode)this.nodeFactory.getNode(109, this.getContextManager());
            }
            case 219: {
                this.jj_consume_token(219);
                return (ValueNode)this.nodeFactory.getNode(125, this.getContextManager());
            }
        }
        this.jj_la1[152] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final JavaToSQLValueNode newInvocation() throws ParseException, StandardException {
        Vector parameterList = new Vector();
        this.jj_consume_token(379);
        String javaClassName = this.javaClassName();
        this.methodCallParameterList(parameterList);
        if (!(javaClassName.startsWith("org.apache.derby.diag.") || javaClassName.startsWith("org.apache.derby.catalog.") || javaClassName.startsWith("com.ibm.db2j."))) {
            this.checkInternalFeature(javaClassName);
        }
        QueryTreeNode newNode = this.nodeFactory.getNode(133, javaClassName, parameterList, this.lastTokenDelimitedIdentifier, this.getContextManager());
        return (JavaToSQLValueNode)this.nodeFactory.getNode(36, newNode, this.getContextManager());
    }

    public final JavaToSQLValueNode vtiTableConstruct() throws ParseException, StandardException {
        QueryTreeNode newNode = null;
        Vector parameterList = new Vector();
        TableName vtiTableName = null;
        this.jj_consume_token(232);
        this.jj_consume_token(420);
        vtiTableName = this.qualifiedName(128);
        this.methodCallParameterList(parameterList);
        this.jj_consume_token(421);
        newNode = this.nodeFactory.getNode(133, vtiTableName, null, parameterList, this.lastTokenDelimitedIdentifier, this.getContextManager());
        return (JavaToSQLValueNode)this.nodeFactory.getNode(36, newNode, this.getContextManager());
    }

    public final ValueNode staticMethodInvocation(String javaClassName) throws ParseException, StandardException {
        Vector parameterList = new Vector();
        MethodCallNode methodNode = this.staticMethodName(javaClassName);
        this.methodCallParameterList(parameterList);
        methodNode.addParms(parameterList);
        return (ValueNode)this.nodeFactory.getNode(36, methodNode, this.getContextManager());
    }

    public final void methodCallParameterList(Vector parameterList) throws ParseException, StandardException {
        this.jj_consume_token(420);
        if (this.jj_2_35(1)) {
            this.methodParameter(parameterList);
            block3: while (true) {
                switch (this.jj_nt.kind) {
                    case 424: {
                        break;
                    }
                    default: {
                        this.jj_la1[153] = this.jj_gen;
                        break block3;
                    }
                }
                this.jj_consume_token(424);
                this.methodParameter(parameterList);
            }
        }
        this.jj_consume_token(421);
    }

    public final ValueNode routineInvocation() throws ParseException, StandardException {
        Vector parameterList = new Vector();
        TableName routineName = this.qualifiedName(128);
        this.methodCallParameterList(parameterList);
        MethodCallNode methodNode = (MethodCallNode)this.nodeFactory.getNode(85, routineName, null, this.getContextManager());
        methodNode.addParms(parameterList);
        return (ValueNode)this.nodeFactory.getNode(36, methodNode, this.getContextManager());
    }

    public final String javaClass() throws ParseException, StandardException {
        String javaClassName = this.javaClassName();
        return javaClassName;
    }

    public final ValueNode columnMethodInvocation() throws ParseException, StandardException {
        ValueNode columnReference = this.columnNameForInvocation();
        ValueNode methodNode = this.nonStaticMethodInvocation(columnReference);
        return methodNode;
    }

    public final ValueNode columnNameForInvocation() throws ParseException, StandardException {
        String secondName = null;
        String thirdName = null;
        String columnName = null;
        String tableName = null;
        String schemaName = null;
        TableName tabName = null;
        String firstName = this.identifier(128, true);
        if (this.getToken((int)1).kind == 426 && this.getToken((int)3).kind == 426) {
            this.jj_consume_token(426);
            secondName = this.identifier(128, true);
            if (this.getToken((int)1).kind == 426 && this.getToken((int)3).kind == 426) {
                this.jj_consume_token(426);
                thirdName = this.identifier(128, true);
            }
        }
        if (thirdName == null) {
            if (secondName == null) {
                columnName = firstName;
            } else {
                tableName = firstName;
                columnName = secondName;
            }
        } else {
            schemaName = firstName;
            tableName = secondName;
            columnName = thirdName;
        }
        if (tableName != null) {
            tabName = (TableName)this.nodeFactory.getNode(34, schemaName, tableName, new Integer(this.nextToLastIdentifierToken.beginOffset), new Integer(this.nextToLastIdentifierToken.endOffset), this.getContextManager());
        }
        ValueNode retval = (ValueNode)this.nodeFactory.getNode(62, columnName, tabName, new Integer(this.lastIdentifierToken.beginOffset), new Integer(this.lastIdentifierToken.endOffset), this.getContextManager());
        return retval;
    }

    public final ColumnReference columnReference() throws ParseException, StandardException {
        String secondName = null;
        String thirdName = null;
        String columnName = null;
        String tableName = null;
        String schemaName = null;
        TableName tabName = null;
        String firstName = this.identifier(128, false);
        if (this.getToken((int)1).kind == 426 && this.getToken((int)3).kind != 420) {
            this.jj_consume_token(426);
            secondName = this.identifier(128, false);
            if (this.getToken((int)1).kind == 426 && this.getToken((int)3).kind != 420) {
                this.jj_consume_token(426);
                thirdName = this.identifier(128, false);
            }
        }
        if (thirdName == null) {
            if (secondName == null) {
                columnName = firstName;
            } else {
                tableName = firstName;
                columnName = secondName;
            }
        } else {
            schemaName = firstName;
            tableName = secondName;
            columnName = thirdName;
        }
        this.checkIdentifierLengthLimit(columnName, 128);
        if (schemaName != null) {
            this.checkIdentifierLengthLimit(schemaName, 128);
        }
        if (tableName != null) {
            this.checkIdentifierLengthLimit(tableName, 128);
        }
        if (tableName != null) {
            tabName = (TableName)this.nodeFactory.getNode(34, schemaName, tableName, new Integer(this.nextToLastIdentifierToken.beginOffset), new Integer(this.nextToLastIdentifierToken.endOffset), this.getContextManager());
        }
        return (ColumnReference)this.nodeFactory.getNode(62, columnName, tabName, new Integer(this.lastIdentifierToken.beginOffset), new Integer(this.lastIdentifierToken.endOffset), this.getContextManager());
    }

    public final OrderByList orderByClause() throws ParseException, StandardException {
        this.jj_consume_token(193);
        this.jj_consume_token(77);
        OrderByList orderCols = this.sortSpecificationList();
        return orderCols;
    }

    public final int atIsolationLevel() throws ParseException, StandardException {
        this.jj_consume_token(259);
        int isolationLevel = this.isolationLevelDB2Abbrev();
        return isolationLevel;
    }

    public final OrderByList sortSpecificationList() throws ParseException, StandardException {
        OrderByList orderCols = (OrderByList)this.nodeFactory.getNode(7, this.getContextManager());
        this.sortSpecification(orderCols);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 424: {
                    break;
                }
                default: {
                    this.jj_la1[154] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(424);
            this.sortSpecification(orderCols);
        }
        return orderCols;
    }

    public final void sortSpecification(OrderByList orderCols) throws ParseException, StandardException {
        OrderByColumn orderCol = this.sortKey();
        switch (this.jj_nt.kind) {
            case 67: 
            case 116: {
                this.orderingSpecification(orderCol);
                break;
            }
            default: {
                this.jj_la1[155] = this.jj_gen;
            }
        }
        orderCols.addOrderByColumn(orderCol);
    }

    public final OrderByColumn sortKey() throws ParseException, StandardException {
        ValueNode columnExpression = this.additiveExpression(null, 0, true);
        return (OrderByColumn)this.nodeFactory.getNode(104, columnExpression, this.getContextManager());
    }

    public final void orderingSpecification(OrderByColumn orderCol) throws ParseException {
        switch (this.jj_nt.kind) {
            case 67: {
                this.jj_consume_token(67);
                break;
            }
            case 116: {
                this.jj_consume_token(116);
                orderCol.setDescending();
                break;
            }
            default: {
                this.jj_la1[156] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final int forUpdateClause(Vector columnList) throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 247: {
                this.jj_consume_token(247);
                switch (this.jj_nt.kind) {
                    case 187: {
                        this.jj_consume_token(187);
                        this.forUpdateColumnList(columnList);
                        break;
                    }
                    default: {
                        this.jj_la1[157] = this.jj_gen;
                    }
                }
                return 2;
            }
            case 206: {
                this.jj_consume_token(206);
                this.jj_consume_token(189);
                return 1;
            }
            case 134: {
                this.jj_consume_token(134);
                this.jj_consume_token(189);
                return 1;
            }
        }
        this.jj_la1[158] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final void forUpdateColumnList(Vector columnList) throws ParseException, StandardException {
        this.forUpdateColumn(columnList);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 424: {
                    break;
                }
                default: {
                    this.jj_la1[159] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(424);
            this.forUpdateColumn(columnList);
        }
    }

    public final void forUpdateColumn(Vector columnList) throws ParseException, StandardException {
        String columnName = this.identifier(128, true);
        columnList.addElement(columnName);
    }

    public final ResultColumnList setClauseList() throws ParseException, StandardException {
        ResultColumnList columnList = (ResultColumnList)this.nodeFactory.getNode(9, this.getContextManager());
        this.setClause(columnList);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 424: {
                    break;
                }
                default: {
                    this.jj_la1[160] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(424);
            this.setClause(columnList);
        }
        return columnList;
    }

    public final void setClause(ResultColumnList columnList) throws ParseException, StandardException {
        ColumnReference columnName = this.columnReference();
        this.jj_consume_token(433);
        ValueNode valueNode = this.updateSource(columnName.getColumnName());
        ResultColumn resultColumn = (ResultColumn)this.nodeFactory.getNode(80, columnName, valueNode, this.getContextManager());
        columnList.addResultColumn(resultColumn);
    }

    public final ValueNode updateSource(String columnName) throws ParseException, StandardException {
        if (this.jj_2_36(1)) {
            ValueNode valueNode = this.additiveExpression(null, 0, false);
            return valueNode;
        }
        switch (this.jj_nt.kind) {
            case 184: {
                ValueNode valueNode = this.nullSpecification();
                return valueNode;
            }
            case 112: {
                this.jj_consume_token(112);
                return (ValueNode)this.nodeFactory.getNode(100, columnName, this.getContextManager());
            }
        }
        this.jj_la1[161] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode nullSpecification() throws ParseException, StandardException {
        this.jj_consume_token(184);
        return (ValueNode)this.nodeFactory.getNode(13, this.getContextManager());
    }

    public final StatementNode insertColumnsAndSource(QueryTreeNode targetTable) throws ParseException, StandardException {
        Properties targetProperties = null;
        ResultColumnList columnList = null;
        if (this.getToken((int)1).kind == 420 && !this.subqueryFollows()) {
            this.jj_consume_token(420);
            columnList = this.insertColumnList();
            this.jj_consume_token(421);
        }
        switch (this.jj_nt.kind) {
            case 53: {
                targetProperties = this.propertyList(false);
                this.jj_consume_token(58);
                break;
            }
            default: {
                this.jj_la1[162] = this.jj_gen;
            }
        }
        ResultSetNode queryExpression = this.queryExpression(null, 0);
        return (StatementNode)this.nodeFactory.getNode(138, targetTable, columnList, queryExpression, targetProperties, this.getContextManager());
    }

    public final ResultColumnList insertColumnList() throws ParseException, StandardException {
        ResultColumnList columnList = (ResultColumnList)this.nodeFactory.getNode(9, this.getContextManager());
        this.columnQualifiedNameList(columnList);
        return columnList;
    }

    public final void columnQualifiedNameList(ResultColumnList columnList) throws ParseException, StandardException {
        this.columnQualifiedNameItem(columnList);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 424: {
                    break;
                }
                default: {
                    this.jj_la1[163] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(424);
            this.columnQualifiedNameItem(columnList);
        }
    }

    public final void columnQualifiedNameItem(ResultColumnList columnList) throws ParseException, StandardException {
        ColumnReference columnRef = this.columnReference();
        ResultColumn resultColumn = (ResultColumn)this.nodeFactory.getNode(80, columnRef, null, this.getContextManager());
        columnList.addResultColumn(resultColumn);
    }

    public final ResultSetNode rowValueConstructor(ResultSetNode leftRSN) throws ParseException, StandardException {
        ResultColumnList resultColumns = (ResultColumnList)this.nodeFactory.getNode(9, this.getContextManager());
        if (this.rowValueConstructorListFollows()) {
            this.jj_consume_token(420);
            this.rowValueConstructorList(resultColumns);
            this.jj_consume_token(421);
            ResultSetNode newRSN = (ResultSetNode)this.nodeFactory.getNode(105, resultColumns, null, this.getContextManager());
            if (leftRSN != null) {
                if (leftRSN.getResultColumns().size() != newRSN.getResultColumns().size()) {
                    throw StandardException.newException("42X59");
                }
                newRSN = (ResultSetNode)this.nodeFactory.getNode(142, leftRSN, newRSN, Boolean.TRUE, Boolean.TRUE, null, this.getContextManager());
            }
            return newRSN;
        }
        this.rowValueConstructorElement(resultColumns);
        ResultSetNode newRSN = (ResultSetNode)this.nodeFactory.getNode(105, resultColumns, null, this.getContextManager());
        if (leftRSN != null) {
            if (leftRSN.getResultColumns().size() != newRSN.getResultColumns().size()) {
                throw StandardException.newException("42X59");
            }
            newRSN = (ResultSetNode)this.nodeFactory.getNode(142, leftRSN, newRSN, Boolean.TRUE, Boolean.TRUE, null, this.getContextManager());
        }
        return newRSN;
    }

    public final void rowValueConstructorElement(ResultColumnList resultColumns) throws ParseException, StandardException {
        if (this.jj_2_37(1)) {
            ValueNode value = this.additiveExpression(null, 0, true);
            resultColumns.addResultColumn((ResultColumn)this.nodeFactory.getNode(80, null, value, this.getContextManager()));
        } else {
            switch (this.jj_nt.kind) {
                case 184: {
                    ValueNode value = this.nullSpecification();
                    resultColumns.addResultColumn((ResultColumn)this.nodeFactory.getNode(80, null, value, this.getContextManager()));
                    break;
                }
                case 112: {
                    this.jj_consume_token(112);
                    resultColumns.addResultColumn((ResultColumn)this.nodeFactory.getNode(80, null, (ValueNode)this.nodeFactory.getNode(100, null, this.getContextManager()), this.getContextManager()));
                    break;
                }
                default: {
                    this.jj_la1[164] = this.jj_gen;
                    throw StandardException.newException("42X80");
                }
            }
        }
    }

    public final void rowValueConstructorList(ResultColumnList resultColumns) throws ParseException, StandardException {
        this.rowValueConstructorElement(resultColumns);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 424: {
                    break;
                }
                default: {
                    this.jj_la1[165] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(424);
            this.rowValueConstructorElement(resultColumns);
        }
    }

    public final SubqueryNode tableSubquery(int subqueryType, ValueNode leftOperand) throws ParseException, StandardException {
        SubqueryNode subqueryNode = this.subquery(subqueryType, leftOperand);
        return subqueryNode;
    }

    public final SubqueryNode subquery(int subqueryType, ValueNode leftOperand) throws ParseException, StandardException {
        ResultSetNode queryExpression = this.queryExpression(null, 0);
        SubqueryNode subqueryNode = (SubqueryNode)this.nodeFactory.getNode(93, queryExpression, ReuseFactory.getInteger(subqueryType), leftOperand, this.getContextManager());
        return subqueryNode;
    }

    public final ValueNode inPredicateValue(ValueNode leftOperand) throws ParseException, StandardException {
        ValueNode retval;
        this.jj_consume_token(420);
        if (this.subqueryFollows()) {
            retval = this.tableSubquery(1, leftOperand);
        } else if (this.jj_2_38(1)) {
            retval = this.inValueList(leftOperand);
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(421);
        return retval;
    }

    public final ValueNode inValueList(ValueNode leftOperand) throws ParseException, StandardException {
        ValueNodeList inList = (ValueNodeList)this.nodeFactory.getNode(15, this.getContextManager());
        this.inElement(inList);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 424: {
                    break;
                }
                default: {
                    this.jj_la1[166] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(424);
            this.inElement(inList);
        }
        return (ValueNode)this.nodeFactory.getNode(55, leftOperand, inList, this.getContextManager());
    }

    public final void inElement(ValueNodeList inList) throws ParseException, StandardException {
        ValueNode valueNode = this.additiveExpression(null, 0, false);
        inList.addElement(valueNode);
    }

    public final int quantifier(int opType) throws ParseException, StandardException {
        int retval = 0;
        switch (this.jj_nt.kind) {
            case 60: {
                this.jj_consume_token(60);
                switch (opType) {
                    case 6: {
                        retval = 4;
                        break;
                    }
                    case 7: {
                        retval = 6;
                        break;
                    }
                    case 11: {
                        retval = 14;
                        break;
                    }
                    case 10: {
                        retval = 12;
                        break;
                    }
                    case 9: {
                        retval = 10;
                        break;
                    }
                    case 8: {
                        retval = 8;
                        break;
                    }
                    default: {
                        SanityManager.THROWASSERT("Invalid value for opType (" + opType + ") passed to quantifier()");
                    }
                }
                return retval;
            }
            case 64: 
            case 222: {
                this.some();
                switch (opType) {
                    case 6: {
                        retval = 3;
                        break;
                    }
                    case 7: {
                        retval = 5;
                        break;
                    }
                    case 11: {
                        retval = 13;
                        break;
                    }
                    case 10: {
                        retval = 11;
                        break;
                    }
                    case 9: {
                        retval = 9;
                        break;
                    }
                    case 8: {
                        retval = 7;
                        break;
                    }
                    default: {
                        SanityManager.THROWASSERT("Invalid value for opType (" + opType + ") passed to quantifier()");
                    }
                }
                return retval;
            }
        }
        this.jj_la1[167] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final void some() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 222: {
                this.jj_consume_token(222);
                break;
            }
            case 64: {
                this.jj_consume_token(64);
                break;
            }
            default: {
                this.jj_la1[168] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final SubqueryNode existsExpression() throws ParseException, StandardException {
        this.jj_consume_token(131);
        this.jj_consume_token(420);
        SubqueryNode subqueryNode = this.tableSubquery(15, null);
        this.jj_consume_token(421);
        return subqueryNode;
    }

    public final SelectNode tableExpression(ResultColumnList selectList) throws ParseException, StandardException {
        ValueNode whereClause = null;
        GroupByList groupByList = null;
        ValueNode havingClause = null;
        FromList fromList = this.fromClause();
        switch (this.jj_nt.kind) {
            case 258: {
                Token whereToken = this.jj_consume_token(258);
                whereClause = this.whereClause(whereToken);
                break;
            }
            default: {
                this.jj_la1[169] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 148: {
                groupByList = this.groupByClause();
                break;
            }
            default: {
                this.jj_la1[170] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 149: {
                havingClause = this.havingClause();
                break;
            }
            default: {
                this.jj_la1[171] = this.jj_gen;
            }
        }
        if (havingClause != null && groupByList == null) {
            ValueNode vn = (ValueNode)this.nodeFactory.getNode(115, null, CountAggregateDefinition.class, Boolean.FALSE, "COUNT(*)", this.getContextManager());
            AggregateNode n = (AggregateNode)vn;
            n.replaceAggregatesWithColumnReferences(selectList, 0);
        }
        SelectNode selectNode = (SelectNode)this.nodeFactory.getNode(129, selectList, null, fromList, whereClause, groupByList, havingClause, this.getContextManager());
        return selectNode;
    }

    public final FromList fromClause() throws ParseException, StandardException {
        FromList fromList = (FromList)this.nodeFactory.getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager());
        this.jj_consume_token(140);
        Token beginToken = this.getToken(1);
        switch (this.jj_nt.kind) {
            case 53: {
                this.fromListProperties(fromList);
                break;
            }
            default: {
                this.jj_la1[172] = this.jj_gen;
            }
        }
        this.dummyTableReferenceRule(fromList);
        block6: while (true) {
            switch (this.jj_nt.kind) {
                case 424: {
                    break;
                }
                default: {
                    this.jj_la1[173] = this.jj_gen;
                    break block6;
                }
            }
            this.jj_consume_token(424);
            this.dummyTableReferenceRule(fromList);
        }
        Token endToken = this.getToken(0);
        fromList.setBeginOffset(beginToken.beginOffset);
        fromList.setEndOffset(endToken.endOffset);
        return fromList;
    }

    public final void fromListProperties(FromList fromList) throws ParseException, StandardException {
        Properties properties = this.propertyList(true);
        this.jj_consume_token(58);
        fromList.setProperties(properties);
    }

    public final void dummyTableReferenceRule(FromList fromList) throws ParseException, StandardException {
        if (this.getToken((int)1).kind == 232 && this.getToken((int)2).kind == 420 && (this.getToken((int)3).kind == 218 || this.getToken((int)3).kind == 252)) {
            this.jj_consume_token(232);
            FromTable tableReference = this.tableReferenceTypes(false);
            fromList.addFromTable(tableReference);
        } else if (this.jj_2_39(1)) {
            FromTable tableReference = this.tableReferenceTypes(false);
            fromList.addFromTable(tableReference);
        } else {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
    }

    public final FromTable tableReferenceTypes(boolean nestedInParens) throws ParseException, StandardException {
        if (this.jj_2_40(1)) {
            FromTable tableReference = this.tableReference(nestedInParens);
            return tableReference;
        }
        switch (this.jj_nt.kind) {
            case 418: {
                this.jj_consume_token(418);
                this.jj_consume_token(382);
                FromTable tableReference = this.tableReference(nestedInParens);
                this.jj_consume_token(419);
                return tableReference;
            }
        }
        this.jj_la1[174] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Object[] optionalTableClauses() throws ParseException, StandardException {
        Object[] otc = null;
        Properties tableProperties = null;
        ResultColumnList derivedRCL = null;
        String correlationName = null;
        switch (this.jj_nt.kind) {
            case 53: {
                otc = this.optionalTableProperties();
                otc[1] = derivedRCL;
                otc[2] = correlationName;
                return otc;
            }
        }
        this.jj_la1[179] = this.jj_gen;
        block3 : switch (this.jj_nt.kind) {
            case 66: 
            case 74: 
            case 87: 
            case 99: 
            case 107: 
            case 177: 
            case 231: 
            case 243: 
            case 251: 
            case 253: 
            case 263: 
            case 264: 
            case 265: 
            case 266: 
            case 267: 
            case 268: 
            case 269: 
            case 270: 
            case 271: 
            case 272: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 277: 
            case 279: 
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 284: 
            case 286: 
            case 288: 
            case 289: 
            case 290: 
            case 291: 
            case 292: 
            case 293: 
            case 294: 
            case 295: 
            case 296: 
            case 297: 
            case 298: 
            case 299: 
            case 300: 
            case 301: 
            case 302: 
            case 303: 
            case 304: 
            case 305: 
            case 306: 
            case 307: 
            case 308: 
            case 309: 
            case 310: 
            case 311: 
            case 312: 
            case 313: 
            case 314: 
            case 315: 
            case 317: 
            case 318: 
            case 319: 
            case 320: 
            case 321: 
            case 322: 
            case 323: 
            case 324: 
            case 325: 
            case 326: 
            case 327: 
            case 328: 
            case 329: 
            case 330: 
            case 331: 
            case 332: 
            case 333: 
            case 334: 
            case 335: 
            case 336: 
            case 337: 
            case 338: 
            case 339: 
            case 342: 
            case 343: 
            case 344: 
            case 348: 
            case 357: 
            case 358: 
            case 359: 
            case 360: 
            case 361: 
            case 362: 
            case 364: 
            case 365: 
            case 366: 
            case 367: 
            case 368: 
            case 369: 
            case 370: 
            case 371: 
            case 372: 
            case 373: 
            case 374: 
            case 375: 
            case 376: 
            case 377: 
            case 378: 
            case 379: 
            case 380: 
            case 382: 
            case 383: 
            case 384: 
            case 385: 
            case 387: 
            case 388: 
            case 389: 
            case 390: 
            case 391: 
            case 392: 
            case 393: 
            case 394: 
            case 395: 
            case 396: 
            case 397: 
            case 398: 
            case 399: 
            case 400: 
            case 401: 
            case 402: 
            case 403: 
            case 404: 
            case 405: 
            case 406: 
            case 407: 
            case 408: 
            case 409: 
            case 410: 
            case 411: 
            case 412: 
            case 413: 
            case 445: 
            case 451: {
                switch (this.jj_nt.kind) {
                    case 66: {
                        this.jj_consume_token(66);
                        break;
                    }
                    default: {
                        this.jj_la1[175] = this.jj_gen;
                    }
                }
                correlationName = this.identifier(128, true);
                switch (this.jj_nt.kind) {
                    case 420: {
                        this.jj_consume_token(420);
                        derivedRCL = this.derivedColumnList();
                        this.jj_consume_token(421);
                        break;
                    }
                    default: {
                        this.jj_la1[176] = this.jj_gen;
                    }
                }
                switch (this.jj_nt.kind) {
                    case 53: {
                        tableProperties = this.propertyList(true);
                        this.jj_consume_token(58);
                        break block3;
                    }
                }
                this.jj_la1[177] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[178] = this.jj_gen;
            }
        }
        otc = new Object[]{tableProperties, derivedRCL, correlationName};
        return otc;
    }

    public final Object[] optionalTableProperties() throws ParseException, StandardException {
        Object[] otc = null;
        Properties tableProperties = null;
        tableProperties = this.propertyList(true);
        this.jj_consume_token(58);
        otc = new Object[3];
        otc[0] = tableProperties;
        return otc;
    }

    public final FromTable tableReference(boolean nestedInParens) throws ParseException, StandardException {
        JavaToSQLValueNode javaToSQLNode = null;
        String correlationName = null;
        ResultColumnList derivedRCL = null;
        TableOperatorNode joinTable = null;
        Object[] optionalTableClauses = new Object[3];
        Object tableProperties = null;
        if (this.jj_2_41(1)) {
            if (this.newInvocationFollows(1)) {
                javaToSQLNode = this.newInvocation();
            } else {
                switch (this.jj_nt.kind) {
                    case 232: {
                        javaToSQLNode = this.vtiTableConstruct();
                        break;
                    }
                    default: {
                        this.jj_la1[180] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
            switch (this.jj_nt.kind) {
                case 66: {
                    this.jj_consume_token(66);
                    break;
                }
                default: {
                    this.jj_la1[181] = this.jj_gen;
                }
            }
            correlationName = this.identifier(128, true);
            switch (this.jj_nt.kind) {
                case 420: {
                    this.jj_consume_token(420);
                    derivedRCL = this.derivedColumnList();
                    this.jj_consume_token(421);
                    break;
                }
                default: {
                    this.jj_la1[182] = this.jj_gen;
                }
            }
            switch (this.jj_nt.kind) {
                case 53: {
                    optionalTableClauses = this.optionalTableProperties();
                    break;
                }
                default: {
                    this.jj_la1[183] = this.jj_gen;
                }
            }
            while (this.joinedTableExpressionFollows()) {
                joinTable = this.joinedTableExpression(joinTable != null ? joinTable : (FromTable)this.nodeFactory.getNode(120, javaToSQLNode.getJavaValueNode(), correlationName, derivedRCL, optionalTableClauses != null ? (Properties)optionalTableClauses[0] : (Properties)null, this.getContextManager()), nestedInParens);
            }
            FromTable fromTable = joinTable == null ? (FromTable)this.nodeFactory.getNode(120, javaToSQLNode.getJavaValueNode(), correlationName, derivedRCL, optionalTableClauses != null ? (Properties)optionalTableClauses[0] : (Properties)null, this.getContextManager()) : joinTable;
            return fromTable;
        }
        switch (this.jj_nt.kind) {
            case 74: 
            case 87: 
            case 99: 
            case 107: 
            case 177: 
            case 231: 
            case 243: 
            case 251: 
            case 253: 
            case 263: 
            case 264: 
            case 265: 
            case 266: 
            case 267: 
            case 268: 
            case 269: 
            case 270: 
            case 271: 
            case 272: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 277: 
            case 279: 
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 284: 
            case 286: 
            case 288: 
            case 289: 
            case 290: 
            case 291: 
            case 292: 
            case 293: 
            case 294: 
            case 295: 
            case 296: 
            case 297: 
            case 298: 
            case 299: 
            case 300: 
            case 301: 
            case 302: 
            case 303: 
            case 304: 
            case 305: 
            case 306: 
            case 307: 
            case 308: 
            case 309: 
            case 310: 
            case 311: 
            case 312: 
            case 313: 
            case 314: 
            case 315: 
            case 317: 
            case 318: 
            case 319: 
            case 320: 
            case 321: 
            case 322: 
            case 323: 
            case 324: 
            case 325: 
            case 326: 
            case 327: 
            case 328: 
            case 329: 
            case 330: 
            case 331: 
            case 332: 
            case 333: 
            case 334: 
            case 335: 
            case 336: 
            case 337: 
            case 338: 
            case 339: 
            case 342: 
            case 343: 
            case 344: 
            case 348: 
            case 357: 
            case 358: 
            case 359: 
            case 360: 
            case 361: 
            case 362: 
            case 364: 
            case 365: 
            case 366: 
            case 367: 
            case 368: 
            case 369: 
            case 370: 
            case 371: 
            case 372: 
            case 373: 
            case 374: 
            case 375: 
            case 376: 
            case 377: 
            case 378: 
            case 379: 
            case 380: 
            case 382: 
            case 383: 
            case 384: 
            case 385: 
            case 387: 
            case 388: 
            case 389: 
            case 390: 
            case 391: 
            case 392: 
            case 393: 
            case 394: 
            case 395: 
            case 396: 
            case 397: 
            case 398: 
            case 399: 
            case 400: 
            case 401: 
            case 402: 
            case 403: 
            case 404: 
            case 405: 
            case 406: 
            case 407: 
            case 408: 
            case 409: 
            case 410: 
            case 411: 
            case 412: 
            case 413: 
            case 445: 
            case 451: {
                TableName tableName = this.qualifiedName(128);
                optionalTableClauses = this.optionalTableClauses();
                while (this.joinedTableExpressionFollows()) {
                    joinTable = this.joinedTableExpression(joinTable != null ? joinTable : (FromTable)this.nodeFactory.getNode(135, tableName, (String)optionalTableClauses[2], (ResultColumnList)optionalTableClauses[1], (Properties)optionalTableClauses[0], this.getContextManager()), nestedInParens);
                }
                FromTable fromTable = joinTable == null ? (FromTable)this.nodeFactory.getNode(135, tableName, (String)optionalTableClauses[2], (ResultColumnList)optionalTableClauses[1], (Properties)optionalTableClauses[0], this.getContextManager()) : joinTable;
                return fromTable;
            }
        }
        this.jj_la1[187] = this.jj_gen;
        if (this.getToken((int)1).kind == 420 && (this.getToken((int)2).kind == 218 || this.getToken((int)2).kind == 252)) {
            ResultSetNode derivedTable = this.derivedTable();
            switch (this.jj_nt.kind) {
                case 66: {
                    this.jj_consume_token(66);
                    break;
                }
                default: {
                    this.jj_la1[184] = this.jj_gen;
                }
            }
            correlationName = this.identifier(128, true);
            switch (this.jj_nt.kind) {
                case 420: {
                    this.jj_consume_token(420);
                    derivedRCL = this.derivedColumnList();
                    this.jj_consume_token(421);
                    break;
                }
                default: {
                    this.jj_la1[185] = this.jj_gen;
                }
            }
            switch (this.jj_nt.kind) {
                case 53: {
                    optionalTableClauses = this.optionalTableProperties();
                    break;
                }
                default: {
                    this.jj_la1[186] = this.jj_gen;
                }
            }
            while (this.joinedTableExpressionFollows()) {
                joinTable = this.joinedTableExpression(joinTable != null ? joinTable : (FromTable)this.nodeFactory.getNode(136, derivedTable, correlationName, derivedRCL, optionalTableClauses != null ? (Properties)optionalTableClauses[0] : (Properties)null, this.getContextManager()), nestedInParens);
            }
            FromTable fromTable = joinTable == null ? (FromTable)this.nodeFactory.getNode(136, derivedTable, correlationName, derivedRCL, optionalTableClauses != null ? (Properties)optionalTableClauses[0] : (Properties)null, this.getContextManager()) : joinTable;
            return fromTable;
        }
        switch (this.jj_nt.kind) {
            case 420: {
                this.jj_consume_token(420);
                FromTable tableReference = this.tableReferenceTypes(true);
                this.jj_consume_token(421);
                while (this.joinedTableExpressionFollows()) {
                    joinTable = this.joinedTableExpression(joinTable != null ? joinTable : tableReference, nestedInParens);
                }
                FromTable fromTable = joinTable == null ? tableReference : joinTable;
                return fromTable;
            }
        }
        this.jj_la1[188] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ResultColumnList derivedColumnList() throws ParseException, StandardException {
        ResultColumnList resultColumns = (ResultColumnList)this.nodeFactory.getNode(9, this.getContextManager());
        this.columnNameList(resultColumns);
        return resultColumns;
    }

    public final void columnNameList(ResultColumnList columnList) throws ParseException, StandardException {
        this.columnNameItem(columnList);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 424: {
                    break;
                }
                default: {
                    this.jj_la1[189] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(424);
            this.columnNameItem(columnList);
        }
    }

    public final void columnNameItem(ResultColumnList columnList) throws ParseException, StandardException {
        String columnName = this.identifier(128, true);
        ResultColumn resultColumn = (ResultColumn)this.nodeFactory.getNode(80, columnName, null, this.getContextManager());
        columnList.addResultColumn(resultColumn);
    }

    public final void indexColumnList(Vector columnList) throws ParseException, StandardException {
        this.indexColumnItem(columnList);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 424: {
                    break;
                }
                default: {
                    this.jj_la1[190] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(424);
            this.indexColumnItem(columnList);
        }
    }

    public final void indexColumnItem(Vector columnList) throws ParseException, StandardException {
        String columnName = this.identifier(128, true);
        block0 : switch (this.jj_nt.kind) {
            case 67: 
            case 116: {
                switch (this.jj_nt.kind) {
                    case 67: {
                        this.jj_consume_token(67);
                        break block0;
                    }
                    case 116: {
                        this.jj_consume_token(116);
                        columnName = columnName + ' ';
                        break block0;
                    }
                }
                this.jj_la1[191] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[192] = this.jj_gen;
            }
        }
        columnList.addElement(columnName);
    }

    public final ResultSetNode derivedTable() throws ParseException, StandardException {
        this.jj_consume_token(420);
        SubqueryNode tableSubquery = this.tableSubquery(0, null);
        this.jj_consume_token(421);
        return tableSubquery.getResultSet();
    }

    public final TableOperatorNode joinedTableExpression(ResultSetNode leftRSN, boolean nestedInParens) throws ParseException, StandardException {
        TableOperatorNode joinNode = this.qualifiedJoin(leftRSN, nestedInParens);
        return joinNode;
    }

    public final TableOperatorNode qualifiedJoin(ResultSetNode leftRSN, boolean nestedInParens) throws ParseException, StandardException {
        int joinType = 1;
        TableOperatorNode ton = null;
        Object[] onOrUsingClause = null;
        ResultColumnList usingClause = null;
        switch (this.jj_nt.kind) {
            case 156: 
            case 170: 
            case 212: {
                joinType = this.joinType();
                break;
            }
            default: {
                this.jj_la1[193] = this.jj_gen;
            }
        }
        this.jj_consume_token(166);
        FromTable rightRSN = this.tableReferenceTypes(nestedInParens);
        onOrUsingClause = this.joinSpecification(leftRSN, rightRSN);
        ValueNode onClause = (ValueNode)onOrUsingClause[0];
        usingClause = (ResultColumnList)onOrUsingClause[1];
        if (onClause == null && usingClause == null) {
            throw StandardException.newException("42Y11", JoinNode.joinTypeToString(joinType));
        }
        switch (joinType) {
            case 1: {
                ton = (TableOperatorNode)this.nodeFactory.getNode(139, leftRSN, rightRSN, onClause, usingClause, null, null, null, this.getContextManager());
                break;
            }
            case 3: {
                ton = (TableOperatorNode)this.nodeFactory.getNode(144, leftRSN, rightRSN, onClause, usingClause, Boolean.FALSE, null, this.getContextManager());
                break;
            }
            case 4: {
                ton = (TableOperatorNode)this.nodeFactory.getNode(144, leftRSN, rightRSN, onClause, usingClause, Boolean.TRUE, null, this.getContextManager());
                break;
            }
            default: {
                SanityManager.ASSERT(false, "Unexpected joinType");
                return null;
            }
        }
        ton.setNestedInParens(nestedInParens);
        return ton;
    }

    public final int joinType() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 156: {
                this.jj_consume_token(156);
                return 1;
            }
            case 170: 
            case 212: {
                int joinType = this.outerJoinType();
                switch (this.jj_nt.kind) {
                    case 194: {
                        this.jj_consume_token(194);
                        break;
                    }
                    default: {
                        this.jj_la1[194] = this.jj_gen;
                    }
                }
                return joinType;
            }
        }
        this.jj_la1[195] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final int outerJoinType() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 170: {
                this.jj_consume_token(170);
                return 3;
            }
            case 212: {
                this.jj_consume_token(212);
                return 4;
            }
        }
        this.jj_la1[196] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Object[] joinSpecification(ResultSetNode leftRSN, ResultSetNode rightRSN) throws ParseException, StandardException {
        Object[] onOrUsingClause = new Object[2];
        Object usingClause = null;
        ValueNode joinClause = null;
        joinClause = this.joinCondition();
        onOrUsingClause[0] = joinClause;
        onOrUsingClause[1] = usingClause;
        return onOrUsingClause;
    }

    public final ValueNode joinCondition() throws ParseException, StandardException {
        this.jj_consume_token(188);
        ValueNode joinClause = this.valueExpression(false);
        return joinClause;
    }

    public final ResultSetNode tableValueConstructor() throws ParseException, StandardException {
        this.jj_consume_token(252);
        ResultSetNode resultSetNode = this.tableValueConstructorList();
        return resultSetNode;
    }

    public final ResultSetNode tableValueConstructorList() throws ParseException, StandardException {
        ResultSetNode resultSetNode = this.rowValueConstructor(null);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 424: {
                    break;
                }
                default: {
                    this.jj_la1[197] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(424);
            resultSetNode = this.rowValueConstructor(resultSetNode);
        }
        if (resultSetNode instanceof UnionNode) {
            ((UnionNode)resultSetNode).markTopTableConstructor();
        }
        return resultSetNode;
    }

    public final ValueNode datetimeValueFunction() throws ParseException, StandardException {
        int prec = -1;
        if (this.getToken((int)1).kind == 101 && this.getToken((int)2).kind == 276) {
            this.jj_consume_token(101);
            this.jj_consume_token(276);
            return (ValueNode)this.nodeFactory.getNode(108, ReuseFactory.getInteger(0), this.getContextManager());
        }
        switch (this.jj_nt.kind) {
            case 102: {
                this.jj_consume_token(102);
                return (ValueNode)this.nodeFactory.getNode(108, ReuseFactory.getInteger(0), this.getContextManager());
            }
        }
        this.jj_la1[198] = this.jj_gen;
        if (this.getToken((int)1).kind == 101 && this.getToken((int)2).kind == 331) {
            this.jj_consume_token(101);
            this.jj_consume_token(331);
            return (ValueNode)this.nodeFactory.getNode(108, ReuseFactory.getInteger(1), this.getContextManager());
        }
        switch (this.jj_nt.kind) {
            case 103: {
                this.jj_consume_token(103);
                return (ValueNode)this.nodeFactory.getNode(108, ReuseFactory.getInteger(1), this.getContextManager());
            }
        }
        this.jj_la1[199] = this.jj_gen;
        if (this.getToken((int)1).kind == 101 && this.getToken((int)2).kind == 332) {
            this.jj_consume_token(101);
            this.jj_consume_token(332);
            return (ValueNode)this.nodeFactory.getNode(108, ReuseFactory.getInteger(2), this.getContextManager());
        }
        switch (this.jj_nt.kind) {
            case 104: {
                this.jj_consume_token(104);
                return (ValueNode)this.nodeFactory.getNode(108, ReuseFactory.getInteger(2), this.getContextManager());
            }
        }
        this.jj_la1[200] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode aggregateNode() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 99: {
                ValueNode agg;
                this.jj_consume_token(99);
                this.jj_consume_token(420);
                switch (this.jj_nt.kind) {
                    case 422: {
                        this.jj_consume_token(422);
                        agg = (ValueNode)this.nodeFactory.getNode(115, null, CountAggregateDefinition.class, Boolean.FALSE, "COUNT(*)", this.getContextManager());
                        break;
                    }
                    default: {
                        this.jj_la1[201] = this.jj_gen;
                        if (this.jj_2_42(1)) {
                            agg = this.aggregateExpression("COUNT", CountAggregateDefinition.class);
                            break;
                        }
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                this.jj_consume_token(421);
                return agg;
            }
            case 71: 
            case 174: 
            case 175: 
            case 229: {
                ValueNode agg = this.generalAggregate();
                return agg;
            }
        }
        this.jj_la1[202] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode aggregateExpression(String aggName, Class aggClass) throws ParseException, StandardException {
        boolean distinct = false;
        if (this.jj_2_43(1)) {
            distinct = this.setQuantifier();
        }
        ValueNode value = this.additiveExpression(null, 0, false);
        return (ValueNode)this.nodeFactory.getNode(115, value, aggClass, distinct ? Boolean.TRUE : Boolean.FALSE, aggName, this.getContextManager());
    }

    public final ValueNode generalAggregate() throws ParseException, StandardException {
        Token aggToken = this.builtInAggregateType();
        this.jj_consume_token(420);
        ValueNode aggExpr = this.aggregateExpression(SQLParser.aggName(aggToken), SQLParser.aggClass(aggToken));
        this.jj_consume_token(421);
        return aggExpr;
    }

    public final Token builtInAggregateType() throws ParseException, StandardException {
        Token retval;
        switch (this.jj_nt.kind) {
            case 174: {
                retval = this.jj_consume_token(174);
                break;
            }
            case 71: {
                retval = this.jj_consume_token(71);
                break;
            }
            case 175: {
                retval = this.jj_consume_token(175);
                break;
            }
            case 229: {
                retval = this.jj_consume_token(229);
                break;
            }
            default: {
                this.jj_la1[203] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return retval;
    }

    public final ValueNode castSpecification() throws ParseException, StandardException {
        int length = -1;
        this.jj_consume_token(81);
        this.jj_consume_token(420);
        ValueNode value = this.castOperand();
        this.jj_consume_token(66);
        DataTypeDescriptor dts = this.dataTypeCast();
        this.jj_consume_token(421);
        ValueNode treeTop = (ValueNode)this.nodeFactory.getNode(60, value, dts, this.getContextManager());
        ((CastNode)treeTop).setForExternallyGeneratedCASTnode();
        if (dts.getTypeId().userType()) {
            treeTop = (ValueNode)this.nodeFactory.getNode(36, this.nodeFactory.getNode(28, treeTop, this.getContextManager()), this.getContextManager());
        }
        return treeTop;
    }

    public final int charOrVarchar() throws ParseException {
        switch (this.jj_nt.kind) {
            case 82: {
                this.jj_consume_token(82);
                return 1;
            }
            case 254: {
                this.jj_consume_token(254);
                return 12;
            }
        }
        this.jj_la1[204] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode castOperand() throws ParseException, StandardException {
        if (this.jj_2_44(1)) {
            ValueNode value = this.additiveExpression(null, 0, false);
            return value;
        }
        switch (this.jj_nt.kind) {
            case 184: {
                this.jj_consume_token(184);
                return (ValueNode)this.nodeFactory.getNode(13, this.getContextManager());
            }
        }
        this.jj_la1[205] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ParameterNode dynamicParameterSpecification() throws ParseException, StandardException {
        this.jj_consume_token(438);
        return this.makeParameterNode();
    }

    public final ValueNode whereClause(Token beginToken) throws ParseException, StandardException {
        ValueNode value = this.valueExpression(false);
        Token endToken = this.getToken(0);
        value.setBeginOffset(beginToken.endOffset + 1);
        value.setEndOffset(endToken.endOffset);
        return value;
    }

    public final GroupByList groupByClause() throws ParseException, StandardException {
        this.jj_consume_token(148);
        this.jj_consume_token(77);
        GroupByList groupingCols = this.groupingColumnReferenceList();
        return groupingCols;
    }

    public final GroupByList groupingColumnReferenceList() throws ParseException, StandardException {
        GroupByList groupingCols = (GroupByList)this.nodeFactory.getNode(3, this.getContextManager());
        this.groupingColumnReference(groupingCols);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 424: {
                    break;
                }
                default: {
                    this.jj_la1[206] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(424);
            this.groupingColumnReference(groupingCols);
        }
        return groupingCols;
    }

    public final void groupingColumnReference(GroupByList groupingCols) throws ParseException, StandardException {
        ValueNode columnExpression = this.additiveExpression(null, 0, false);
        if (columnExpression.isParameterNode()) {
            throw StandardException.newException("42X01", "?");
        }
        if (columnExpression instanceof AggregateNode) {
            AggregateNode agNode = (AggregateNode)columnExpression;
            throw StandardException.newException("42Y26", agNode.getAggregateName());
        }
        groupingCols.addGroupByColumn((GroupByColumn)this.nodeFactory.getNode(35, columnExpression, this.getContextManager()));
    }

    public final ValueNode havingClause() throws ParseException, StandardException {
        this.jj_consume_token(149);
        ValueNode value = this.valueExpression(false);
        return value;
    }

    public final StatementNode schemaDefinition() throws ParseException, StandardException {
        String schemaName = null;
        String authName = null;
        this.jj_consume_token(215);
        switch (this.jj_nt.kind) {
            case 74: 
            case 87: 
            case 99: 
            case 107: 
            case 177: 
            case 231: 
            case 243: 
            case 251: 
            case 253: 
            case 263: 
            case 264: 
            case 265: 
            case 266: 
            case 267: 
            case 268: 
            case 269: 
            case 270: 
            case 271: 
            case 272: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 277: 
            case 279: 
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 284: 
            case 286: 
            case 288: 
            case 289: 
            case 290: 
            case 291: 
            case 292: 
            case 293: 
            case 294: 
            case 295: 
            case 296: 
            case 297: 
            case 298: 
            case 299: 
            case 300: 
            case 301: 
            case 302: 
            case 303: 
            case 304: 
            case 305: 
            case 306: 
            case 307: 
            case 308: 
            case 309: 
            case 310: 
            case 311: 
            case 312: 
            case 313: 
            case 314: 
            case 315: 
            case 317: 
            case 318: 
            case 319: 
            case 320: 
            case 321: 
            case 322: 
            case 323: 
            case 324: 
            case 325: 
            case 326: 
            case 327: 
            case 328: 
            case 329: 
            case 330: 
            case 331: 
            case 332: 
            case 333: 
            case 334: 
            case 335: 
            case 336: 
            case 337: 
            case 338: 
            case 339: 
            case 342: 
            case 343: 
            case 344: 
            case 348: 
            case 357: 
            case 358: 
            case 359: 
            case 360: 
            case 361: 
            case 362: 
            case 364: 
            case 365: 
            case 366: 
            case 367: 
            case 368: 
            case 369: 
            case 370: 
            case 371: 
            case 372: 
            case 373: 
            case 374: 
            case 375: 
            case 376: 
            case 377: 
            case 378: 
            case 379: 
            case 380: 
            case 382: 
            case 383: 
            case 384: 
            case 385: 
            case 387: 
            case 388: 
            case 389: 
            case 390: 
            case 391: 
            case 392: 
            case 393: 
            case 394: 
            case 395: 
            case 396: 
            case 397: 
            case 398: 
            case 399: 
            case 400: 
            case 401: 
            case 402: 
            case 403: 
            case 404: 
            case 405: 
            case 406: 
            case 407: 
            case 408: 
            case 409: 
            case 410: 
            case 411: 
            case 412: 
            case 413: 
            case 445: 
            case 451: {
                schemaName = this.identifier(128, true);
                switch (this.jj_nt.kind) {
                    case 70: {
                        this.jj_consume_token(70);
                        authName = this.identifier(128, true);
                        break;
                    }
                    default: {
                        this.jj_la1[207] = this.jj_gen;
                    }
                }
                if (authName != null) {
                    this.checkVersion(140, "AUTHORIZATION");
                }
                if (schemaName.startsWith("SYS")) {
                    throw StandardException.newException("42939", schemaName);
                }
                return (StatementNode)this.nodeFactory.getNode(134, schemaName, authName, this.getContextManager());
            }
            case 70: {
                this.jj_consume_token(70);
                authName = this.identifier(128, true);
                this.checkVersion(140, "AUTHORIZATION");
                if (authName.startsWith("SYS")) {
                    throw StandardException.newException("42939", authName);
                }
                return (StatementNode)this.nodeFactory.getNode(134, authName, authName, this.getContextManager());
            }
        }
        this.jj_la1[208] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode tableDefinition() throws ParseException, StandardException {
        char lockGranularity = 'R';
        Properties properties = null;
        ResultColumnList resultColumns = null;
        boolean withData = true;
        this.jj_consume_token(232);
        TableName tableName = this.qualifiedName(128);
        if (this.getToken((int)1).kind == 420 && this.getToken((int)3).kind != 424 && this.getToken((int)3).kind != 421) {
            TableElementList tableElementList = this.tableElementList();
            switch (this.jj_nt.kind) {
                case 53: {
                    properties = this.propertyList(false);
                    this.jj_consume_token(58);
                    break;
                }
                default: {
                    this.jj_la1[209] = this.jj_gen;
                }
            }
            return (StatementNode)this.nodeFactory.getNode(141, tableName, tableElementList, properties, new Character(lockGranularity), this.getContextManager());
        }
        switch (this.jj_nt.kind) {
            case 66: 
            case 420: {
                switch (this.jj_nt.kind) {
                    case 420: {
                        this.jj_consume_token(420);
                        resultColumns = this.tableColumnList();
                        this.jj_consume_token(421);
                        break;
                    }
                    default: {
                        this.jj_la1[210] = this.jj_gen;
                    }
                }
                this.jj_consume_token(66);
                ResultSetNode queryExpression = this.queryExpression(null, 0);
                this.jj_consume_token(259);
                switch (this.jj_nt.kind) {
                    case 182: {
                        this.jj_consume_token(182);
                        withData = false;
                        break;
                    }
                    default: {
                        this.jj_la1[211] = this.jj_gen;
                    }
                }
                this.jj_consume_token(275);
                if (withData) {
                    throw StandardException.newException("0A000.S", "WITH DATA");
                }
                HasNodeVisitor visitor = new HasNodeVisitor(ParameterNode.class);
                queryExpression.accept(visitor);
                if (visitor.hasNode()) {
                    throw StandardException.newException("42X99");
                }
                return (StatementNode)this.nodeFactory.getNode(141, tableName, resultColumns, queryExpression, this.getContextManager());
            }
        }
        this.jj_la1[212] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ResultColumnList tableColumnList() throws ParseException, StandardException {
        ResultColumnList resultColumns = (ResultColumnList)this.nodeFactory.getNode(9, this.getContextManager());
        this.columnNameList(resultColumns);
        return resultColumns;
    }

    public final Properties propertyList(boolean propertiesUseAllowed) throws ParseException, StandardException {
        FormatableProperties properties = new FormatableProperties();
        this.jj_consume_token(53);
        StringTokenizer commaSeparatedProperties = new StringTokenizer(this.getToken((int)1).image, ",");
        while (commaSeparatedProperties.hasMoreTokens()) {
            String currentProperty = commaSeparatedProperties.nextToken();
            StringTokenizer equalOperatorSeparatedProperty = new StringTokenizer(currentProperty, "=", true);
            if (equalOperatorSeparatedProperty.countTokens() != 3) {
                throw StandardException.newException("XCY04.S");
            }
            String key = equalOperatorSeparatedProperty.nextToken().trim();
            if (!equalOperatorSeparatedProperty.nextToken().equals("=")) {
                throw StandardException.newException("XCY04.S");
            }
            String value = equalOperatorSeparatedProperty.nextToken().trim();
            SQLParser.verifyImageLength(value);
            if (properties.put(key, value = value.startsWith("'") && value.endsWith("'") ? SQLParser.compressQuotes(value.substring(1, value.length() - 1), SINGLEQUOTES) : (value.startsWith("\"") && value.endsWith("\"") ? SQLParser.compressQuotes(value.substring(1, value.length() - 1), DOUBLEQUOTES) : value.toUpperCase())) == null) continue;
            throw StandardException.newException("42Y49", key);
        }
        if (!propertiesUseAllowed) {
            this.checkInternalFeature("DERBY-PROPERTIES");
        }
        return properties;
    }

    public final char DB2lockGranularityClause() throws ParseException, StandardException {
        this.jj_consume_token(293);
        char lockGranularity = this.lockGranularity();
        return lockGranularity;
    }

    public final char lockGranularity() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 232: {
                this.jj_consume_token(232);
                return 'T';
            }
            case 313: {
                this.jj_consume_token(313);
                return 'R';
            }
        }
        this.jj_la1[213] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode indexDefinition() throws ParseException, StandardException {
        Boolean unique = Boolean.FALSE;
        Properties properties = null;
        Vector indexColumnList = new Vector();
        switch (this.jj_nt.kind) {
            case 245: {
                unique = this.unique();
                break;
            }
            default: {
                this.jj_la1[214] = this.jj_gen;
            }
        }
        this.jj_consume_token(371);
        TableName indexName = this.qualifiedName(128);
        this.jj_consume_token(188);
        TableName tableName = this.qualifiedName(128);
        this.jj_consume_token(420);
        this.indexColumnList(indexColumnList);
        this.jj_consume_token(421);
        switch (this.jj_nt.kind) {
            case 53: {
                properties = this.propertyList(false);
                this.jj_consume_token(58);
                break;
            }
            default: {
                this.jj_la1[215] = this.jj_gen;
            }
        }
        if (indexName.getSchemaName() == null) {
            indexName.setSchemaName(tableName.getSchemaName());
        } else if (tableName.getSchemaName() == null) {
            tableName.setSchemaName(indexName.getSchemaName());
        } else if (!indexName.getSchemaName().equals(tableName.getSchemaName())) {
            throw StandardException.newException("X0Y26.S", (Object)indexName, (Object)tableName);
        }
        return (StatementNode)this.nodeFactory.getNode(146, unique, DEFAULT_INDEX_TYPE, indexName, tableName, indexColumnList, properties, this.getContextManager());
    }

    public final Boolean unique() throws ParseException, StandardException {
        this.jj_consume_token(245);
        return Boolean.TRUE;
    }

    public final StatementNode procedureDefinition() throws ParseException, StandardException {
        Object[] procedureElements = new Object[9];
        this.jj_consume_token(204);
        TableName procedureName = this.qualifiedName(128);
        procedureElements[0] = this.procedureParameterList();
        block3: while (true) {
            this.routineElement(true, procedureElements);
            switch (this.jj_nt.kind) {
                case 132: 
                case 182: 
                case 269: 
                case 274: 
                case 279: 
                case 288: 
                case 296: 
                case 312: 
                case 387: 
                case 390: 
                case 395: 
                case 405: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[216] = this.jj_gen;
        this.checkRequiredRoutineClause(JAVA_ROUTINE_CLAUSES, procedureElements);
        return this.getCreateAliasNode(procedureName, (String)procedureElements[4], procedureElements, 'P', Boolean.FALSE);
    }

    public final void routineElement(boolean isProcedure, Object[] routineElements) throws ParseException, StandardException {
        int clausePosition = -1;
        Object clauseValue = null;
        switch (this.jj_nt.kind) {
            case 405: {
                this.jj_consume_token(405);
                clauseValue = this.qualifiedName(128);
                clausePosition = 1;
                throw StandardException.newException("0A000.S", "SPECIFIC identifier");
            }
            case 279: 
            case 395: {
                switch (this.jj_nt.kind) {
                    case 279: {
                        this.jj_consume_token(279);
                        break;
                    }
                    default: {
                        this.jj_la1[217] = this.jj_gen;
                    }
                }
                this.jj_consume_token(395);
                this.jj_consume_token(402);
                int drs = this.uint_value();
                if (!isProcedure) {
                    throw StandardException.newException("42X01", "RESULT SETS");
                }
                clauseValue = ReuseFactory.getInteger(drs);
                clausePosition = 2;
                break;
            }
            case 288: {
                this.jj_consume_token(288);
                this.jj_consume_token(372);
                clauseValue = "JAVA";
                clausePosition = 3;
                break;
            }
            case 132: {
                this.jj_consume_token(132);
                this.jj_consume_token(301);
                clauseValue = this.string();
                clausePosition = 4;
                break;
            }
            case 387: {
                this.jj_consume_token(387);
                this.jj_consume_token(409);
                clauseValue = this.parameterStyle();
                clausePosition = 5;
                break;
            }
            case 182: {
                this.jj_consume_token(182);
                this.jj_consume_token(224);
                clauseValue = ReuseFactory.getShort((short)3);
                clausePosition = 6;
                break;
            }
            case 274: {
                this.jj_consume_token(274);
                this.jj_consume_token(224);
                clauseValue = ReuseFactory.getShort((short)2);
                clausePosition = 6;
                break;
            }
            case 390: {
                this.jj_consume_token(390);
                this.jj_consume_token(224);
                this.jj_consume_token(275);
                clauseValue = ReuseFactory.getShort((short)1);
                clausePosition = 6;
                break;
            }
            case 296: {
                this.jj_consume_token(296);
                this.jj_consume_token(224);
                this.jj_consume_token(275);
                if (!isProcedure) {
                    throw StandardException.newException("42X01", "MODIFIES SQL DATA");
                }
                clauseValue = ReuseFactory.getShort((short)0);
                clausePosition = 6;
                break;
            }
            case 269: 
            case 312: {
                clauseValue = this.calledOnNullInput(isProcedure);
                clausePosition = 7;
                break;
            }
            default: {
                this.jj_la1[218] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (clausePosition != -1) {
            if (routineElements[clausePosition] != null) {
                String which = ROUTINE_CLAUSE_NAMES[clausePosition];
                throw StandardException.newException("42613", which);
            }
            routineElements[clausePosition] = clauseValue;
        }
    }

    public final Boolean calledOnNullInput(boolean isProcedure) throws ParseException, StandardException {
        Boolean calledOnNull;
        switch (this.jj_nt.kind) {
            case 269: {
                this.jj_consume_token(269);
                calledOnNull = Boolean.TRUE;
                break;
            }
            case 312: {
                this.jj_consume_token(312);
                this.jj_consume_token(184);
                if (isProcedure) {
                    throw StandardException.newException("42X01", "RETURNS NULL ON NULL INPUT");
                }
                calledOnNull = Boolean.FALSE;
                break;
            }
            default: {
                this.jj_la1[219] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(188);
        this.jj_consume_token(184);
        this.jj_consume_token(157);
        return calledOnNull;
    }

    public final Short parameterStyle() throws ParseException {
        this.jj_consume_token(372);
        return ReuseFactory.getShort((short)0);
    }

    public final Object[] procedureParameterList() throws ParseException, StandardException {
        Object[] list = new Vector[]{new Vector(), new Vector(), new Vector()};
        this.jj_consume_token(420);
        if (this.jj_2_45(1)) {
            this.procedureParameterDefinition((Vector[])list);
            block3: while (true) {
                switch (this.jj_nt.kind) {
                    case 424: {
                        break;
                    }
                    default: {
                        this.jj_la1[220] = this.jj_gen;
                        break block3;
                    }
                }
                this.jj_consume_token(424);
                this.procedureParameterDefinition((Vector[])list);
            }
        }
        this.jj_consume_token(421);
        return list;
    }

    public final void procedureParameterDefinition(Vector[] list) throws ParseException, StandardException {
        String parameterName = "";
        Integer inout = this.inoutParameter();
        if (this.commonDatatypeName(2, false)) {
            parameterName = this.identifier(128, true);
        }
        DataTypeDescriptor typeDescriptor = this.dataTypeDDL();
        list[0].addElement(parameterName);
        list[1].addElement(typeDescriptor);
        list[2].addElement(inout);
    }

    public final Integer inoutParameter() throws ParseException {
        int mode = 1;
        block0 : switch (this.jj_nt.kind) {
            case 153: 
            case 285: 
            case 386: {
                switch (this.jj_nt.kind) {
                    case 153: {
                        this.jj_consume_token(153);
                        break block0;
                    }
                    case 386: {
                        this.jj_consume_token(386);
                        mode = 4;
                        break block0;
                    }
                    case 285: {
                        this.jj_consume_token(285);
                        mode = 2;
                        break block0;
                    }
                }
                this.jj_la1[221] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[222] = this.jj_gen;
            }
        }
        return ReuseFactory.getInteger(mode);
    }

    public final StatementNode functionDefinition() throws ParseException, StandardException {
        Object[] functionElements = new Object[9];
        this.jj_consume_token(142);
        TableName functionName = this.qualifiedName(128);
        functionElements[0] = this.functionParameterList();
        this.jj_consume_token(312);
        functionElements[8] = this.dataTypeCommon();
        block3: while (true) {
            this.routineElement(false, functionElements);
            switch (this.jj_nt.kind) {
                case 132: 
                case 182: 
                case 269: 
                case 274: 
                case 279: 
                case 288: 
                case 296: 
                case 312: 
                case 387: 
                case 390: 
                case 395: 
                case 405: {
                    continue block3;
                }
            }
            break;
        }
        this.jj_la1[223] = this.jj_gen;
        this.checkRequiredRoutineClause(JAVA_ROUTINE_CLAUSES, functionElements);
        return this.getCreateAliasNode(functionName, (String)functionElements[4], functionElements, 'F', Boolean.FALSE);
    }

    public final Object[] functionParameterList() throws ParseException, StandardException {
        Object[] list = new Vector[]{new Vector(), new Vector(), new Vector()};
        this.jj_consume_token(420);
        if (this.jj_2_46(1)) {
            this.functionParameterDefinition((Vector[])list);
            block3: while (true) {
                switch (this.jj_nt.kind) {
                    case 424: {
                        break;
                    }
                    default: {
                        this.jj_la1[224] = this.jj_gen;
                        break block3;
                    }
                }
                this.jj_consume_token(424);
                this.functionParameterDefinition((Vector[])list);
            }
        }
        this.jj_consume_token(421);
        return list;
    }

    public final void functionParameterDefinition(Vector[] list) throws ParseException, StandardException {
        String parameterName = "";
        if (this.commonDatatypeName(2, false)) {
            parameterName = this.identifier(128, true);
        }
        DataTypeDescriptor typeDescriptor = this.dataTypeDDL();
        list[0].addElement(parameterName);
        list[1].addElement(typeDescriptor);
        list[2].addElement(ReuseFactory.getInteger(1));
    }

    public final StatementNode viewDefinition(Token beginToken) throws ParseException, StandardException {
        ResultColumnList resultColumns = null;
        Object checkTok = null;
        this.jj_consume_token(256);
        TableName tableName = this.qualifiedName(128);
        switch (this.jj_nt.kind) {
            case 420: {
                this.jj_consume_token(420);
                resultColumns = this.viewColumnList();
                this.jj_consume_token(421);
                break;
            }
            default: {
                this.jj_la1[225] = this.jj_gen;
            }
        }
        this.jj_consume_token(66);
        ResultSetNode queryExpression = this.queryExpression(null, 0);
        int checkOptionType = 0;
        Token endToken = this.getToken(0);
        HasNodeVisitor visitor = new HasNodeVisitor(ParameterNode.class);
        queryExpression.accept(visitor);
        if (visitor.hasNode()) {
            throw StandardException.newException("42X98");
        }
        return (StatementNode)this.nodeFactory.getNode(130, tableName, resultColumns, queryExpression, ReuseFactory.getInteger(checkOptionType), StringUtil.slice(this.statementSQLText, beginToken.beginOffset, endToken.endOffset, false), this.getContextManager());
    }

    public final ResultColumnList viewColumnList() throws ParseException, StandardException {
        ResultColumnList resultColumns = (ResultColumnList)this.nodeFactory.getNode(9, this.getContextManager());
        this.columnNameList(resultColumns);
        return resultColumns;
    }

    public final StatementNode triggerDefinition() throws ParseException, StandardException {
        Boolean isRow = Boolean.FALSE;
        Token[] tokenHolder = new Token[1];
        Object checkTok = null;
        ResultColumnList triggerColumns = (ResultColumnList)this.nodeFactory.getNode(9, this.getContextManager());
        Vector refClause = null;
        this.jj_consume_token(410);
        TableName triggerName = this.qualifiedName(128);
        Boolean isBefore = this.beforeOrAfter();
        int triggerEvent = this.triggerEvent(triggerColumns);
        this.jj_consume_token(188);
        TableName tableName = this.qualifiedName(128);
        switch (this.jj_nt.kind) {
            case 392: {
                refClause = this.triggerReferencingClause();
                break;
            }
            default: {
                this.jj_la1[226] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 137: {
                this.jj_consume_token(137);
                this.jj_consume_token(367);
                isRow = this.rowOrStatement();
                break;
            }
            default: {
                this.jj_la1[227] = this.jj_gen;
            }
        }
        switch (this.jj_nt.kind) {
            case 378: {
                this.jj_consume_token(378);
                this.jj_consume_token(364);
                break;
            }
            default: {
                this.jj_la1[228] = this.jj_gen;
            }
        }
        StatementNode actionNode = this.proceduralStatement(tokenHolder);
        int actionEnd = this.getToken((int)0).endOffset;
        int actionBegin = tokenHolder[0].beginOffset;
        if (isBefore.booleanValue() && actionNode instanceof DMLModStatementNode) {
            throw StandardException.newException("42Z9D", (Object)actionNode.statementToString(), (Object)"BEFORE");
        }
        HasNodeVisitor visitor = new HasNodeVisitor(ParameterNode.class);
        actionNode.accept(visitor);
        if (visitor.hasNode()) {
            throw StandardException.newException("42Y27");
        }
        return (StatementNode)this.nodeFactory.getNode(143, triggerName, tableName, ReuseFactory.getInteger(triggerEvent), triggerColumns, isBefore, isRow, Boolean.TRUE, refClause, null, null, ReuseFactory.getInteger(0), actionNode, StringUtil.slice(this.statementSQLText, actionBegin, actionEnd, false), ReuseFactory.getInteger(actionBegin), this.getContextManager());
    }

    public final StatementNode synonymDefinition() throws ParseException, StandardException {
        this.jj_consume_token(329);
        TableName synonymName = this.qualifiedName(128);
        this.jj_consume_token(137);
        TableName targetName = this.qualifiedName(128);
        this.checkVersion(130, "CREATE SYNONYM");
        return (StatementNode)this.getNodeFactory().getCreateAliasNode(synonymName, targetName, null, 'S', Boolean.FALSE, this.getContextManager());
    }

    public final Boolean beforeOrAfter() throws ParseException {
        switch (this.jj_nt.kind) {
            case 182: {
                this.jj_consume_token(182);
                this.jj_consume_token(78);
                this.jj_consume_token(358);
                return Boolean.TRUE;
            }
            case 357: {
                this.jj_consume_token(357);
                return Boolean.FALSE;
            }
        }
        this.jj_la1[229] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final int triggerEvent(ResultColumnList rcl) throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 159: {
                this.jj_consume_token(159);
                return 4;
            }
            case 115: {
                this.jj_consume_token(115);
                return 2;
            }
            case 247: {
                this.jj_consume_token(247);
                switch (this.jj_nt.kind) {
                    case 187: {
                        this.jj_consume_token(187);
                        this.columnNameList(rcl);
                        break;
                    }
                    default: {
                        this.jj_la1[230] = this.jj_gen;
                    }
                }
                return 1;
            }
        }
        this.jj_la1[231] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Boolean rowOrStatement() throws ParseException {
        switch (this.jj_nt.kind) {
            case 313: {
                this.token = this.jj_consume_token(313);
                return Boolean.TRUE;
            }
            case 328: {
                this.token = this.jj_consume_token(328);
                return Boolean.FALSE;
            }
        }
        this.jj_la1[232] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Vector triggerReferencingClause() throws ParseException, StandardException {
        Vector vector = new Vector();
        this.jj_consume_token(392);
        this.triggerReferencingExpression(vector);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 379: 
                case 380: 
                case 384: 
                case 385: {
                    break;
                }
                default: {
                    this.jj_la1[233] = this.jj_gen;
                    break block3;
                }
            }
            this.triggerReferencingExpression(vector);
        }
        return vector;
    }

    public final void triggerReferencingExpression(Vector vector) throws ParseException, StandardException {
        boolean isNew = true;
        boolean isRow = true;
        switch (this.jj_nt.kind) {
            case 379: {
                this.jj_consume_token(379);
                break;
            }
            case 384: {
                this.jj_consume_token(384);
                isNew = false;
                break;
            }
            case 380: {
                this.jj_consume_token(380);
                isRow = false;
                break;
            }
            case 385: {
                this.jj_consume_token(385);
                isNew = false;
                isRow = false;
                break;
            }
            default: {
                this.jj_la1[234] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(66);
        String identifier = this.identifier(128, true);
        vector.addElement(new TriggerReferencingStruct(isRow, isNew, identifier));
    }

    public final ValueNode defaultClause(long[] autoIncrementInfo, String columnName) throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 112: 
            case 259: {
                switch (this.jj_nt.kind) {
                    case 259: {
                        this.jj_consume_token(259);
                        break;
                    }
                    default: {
                        this.jj_la1[235] = this.jj_gen;
                    }
                }
                Token beginToken = this.jj_consume_token(112);
                ValueNode value = this.defaultOption(beginToken, autoIncrementInfo, columnName);
                return value;
            }
            case 281: {
                ValueNode value = this.generatedColumnOption(autoIncrementInfo);
                return value;
            }
        }
        this.jj_la1[236] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode defaultNullOnlyClause() throws ParseException, StandardException {
        this.jj_consume_token(112);
        this.jj_consume_token(184);
        return (ValueNode)this.nodeFactory.getNode(13, this.getContextManager());
    }

    public final ValueNode generatedColumnOption(long[] autoIncrementInfo) throws ParseException, StandardException {
        ValueNode value = null;
        autoIncrementInfo[0] = 1L;
        autoIncrementInfo[1] = 1L;
        autoIncrementInfo[2] = 1L;
        autoIncrementInfo[3] = 0L;
        this.jj_consume_token(281);
        switch (this.jj_nt.kind) {
            case 266: {
                this.jj_consume_token(266);
                value = null;
                break;
            }
            case 77: {
                this.jj_consume_token(77);
                this.jj_consume_token(112);
                this.checkVersion(130, "GENERATED BY DEFAULT");
                value = (ValueNode)this.nodeFactory.getNode(100, this.getContextManager());
                break;
            }
            default: {
                this.jj_la1[237] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(66);
        this.jj_consume_token(151);
        switch (this.jj_nt.kind) {
            case 420: {
                this.jj_consume_token(420);
                this.autoIncrementBeginEnd(autoIncrementInfo);
                this.jj_consume_token(421);
                break;
            }
            default: {
                this.jj_la1[238] = this.jj_gen;
            }
        }
        return value;
    }

    public final void autoIncrementBeginEnd(long[] autoIncrementInfo) throws ParseException, StandardException {
        long autoIncrementInitial = 1L;
        long autoIncrementIncrement = 1L;
        switch (this.jj_nt.kind) {
            case 283: {
                this.jj_consume_token(283);
                this.jj_consume_token(77);
                autoIncrementInfo[1] = autoIncrementIncrement = this.exactNumber();
                autoIncrementInfo[3] = 0L;
                return;
            }
            case 327: {
                this.jj_consume_token(327);
                this.jj_consume_token(259);
                autoIncrementInitial = this.exactNumber();
                switch (this.jj_nt.kind) {
                    case 424: {
                        this.jj_consume_token(424);
                        this.jj_consume_token(283);
                        this.jj_consume_token(77);
                        autoIncrementIncrement = this.exactNumber();
                        break;
                    }
                    default: {
                        this.jj_la1[239] = this.jj_gen;
                    }
                }
                autoIncrementInfo[0] = autoIncrementInitial;
                autoIncrementInfo[1] = autoIncrementIncrement;
                autoIncrementInfo[3] = 0L;
                return;
            }
        }
        this.jj_la1[240] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode defaultOption(Token beginToken, long[] autoIncrementInfo, String columnName) throws ParseException, StandardException {
        Object errorTok = null;
        Object initialTok = null;
        if (this.getToken((int)1).kind == 184 && this.getToken((int)2).kind != 426 && this.getToken((int)2).kind != 429) {
            this.jj_consume_token(184);
            return (ValueNode)this.nodeFactory.getNode(13, this.getContextManager());
        }
        if (this.jj_2_47(1)) {
            ValueNode value = this.DB2DefaultOption(columnName);
            Token endToken = this.getToken(0);
            value.setBeginOffset(beginToken.beginOffset);
            value.setEndOffset(endToken.endOffset);
            value = (ValueNode)this.nodeFactory.getNode(100, value, StringUtil.slice(this.statementSQLText, beginToken.beginOffset + 7, endToken.endOffset, true), this.getContextManager());
            return value;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode DB2DefaultOption(String columnName) throws ParseException, StandardException {
        if (this.getToken((int)2).kind == 215 || this.getToken((int)2).kind == 404) {
            this.jj_consume_token(101);
            switch (this.jj_nt.kind) {
                case 215: {
                    this.jj_consume_token(215);
                    break;
                }
                case 404: {
                    this.jj_consume_token(404);
                    break;
                }
                default: {
                    this.jj_la1[241] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            return (ValueNode)this.nodeFactory.getNode(6, this.getContextManager());
        }
        switch (this.jj_nt.kind) {
            case 249: {
                this.jj_consume_token(249);
                return (ValueNode)this.nodeFactory.getNode(110, this.getContextManager());
            }
        }
        this.jj_la1[242] = this.jj_gen;
        if (this.getToken((int)1).kind == 276 || this.getToken((int)1).kind == 331 || this.getToken((int)1).kind == 332) {
            ValueNode value = this.miscBuiltins();
            return value;
        }
        if (this.getToken((int)2).kind == 420 || this.getToken((int)4).kind == 420 && this.getToken((int)2).kind != 424) {
            ValueNode value = this.miscBuiltins();
            throw StandardException.newException("42894", columnName);
        }
        if (this.jj_2_48(1)) {
            ValueNode value = this.datetimeValueFunction();
            return value;
        }
        switch (this.jj_nt.kind) {
            case 133: 
            case 242: 
            case 418: 
            case 423: 
            case 425: 
            case 452: 
            case 455: 
            case 456: 
            case 457: {
                ValueNode value = this.literal();
                return value;
            }
        }
        this.jj_la1[243] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode literal() throws ParseException, StandardException {
        String sign = "";
        switch (this.jj_nt.kind) {
            case 423: 
            case 425: 
            case 452: 
            case 457: {
                switch (this.jj_nt.kind) {
                    case 423: 
                    case 425: {
                        sign = this.sign();
                        break;
                    }
                    default: {
                        this.jj_la1[244] = this.jj_gen;
                    }
                }
                ValueNode constantNode = this.numericLiteral(sign);
                return constantNode;
            }
            case 455: {
                CharConstantNode constantNode = this.stringLiteral();
                return constantNode;
            }
            case 456: {
                ValueNode constantNode = this.hexLiteral();
                return constantNode;
            }
            case 418: {
                ValueNode constantNode = this.dateTimeLiteral();
                return constantNode;
            }
            case 133: 
            case 242: {
                Token tok = this.booleanLiteral();
                this.checkInternalFeature(tok.image);
                return (ValueNode)this.nodeFactory.getNode(38, StringUtil.SQLEqualsIgnoreCase(tok.image, "true") ? Boolean.TRUE : Boolean.FALSE, this.getContextManager());
            }
        }
        this.jj_la1[245] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode numericLiteral(String sign) throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 452: {
                Token tok = this.jj_consume_token(452);
                String num = tok.image;
                if (sign.equals("-")) {
                    num = sign.concat(num);
                }
                return this.getNumericNode(num);
            }
            case 457: {
                Double doubleValue;
                Token tok = this.jj_consume_token(457);
                StringBuffer doubleImage = new StringBuffer(sign);
                doubleImage.append(tok.image);
                String doubleString = doubleImage.toString();
                int ePosn = doubleString.indexOf(69);
                if (ePosn == -1) {
                    ePosn = doubleString.indexOf(101);
                }
                SanityManager.ASSERT(ePosn != -1, "no E or e in approximate numeric");
                if (doubleString.length() > 30) {
                    throw StandardException.newException("42820", (Object)doubleString, (Object)"DOUBLE");
                }
                int dotPosn = doubleString.substring(0, ePosn).indexOf(46);
                if (dotPosn == -1) {
                    doubleImage.insert(ePosn, '.');
                    doubleString = doubleImage.toString();
                    ++ePosn;
                }
                try {
                    doubleValue = Double.valueOf(doubleString);
                }
                catch (NumberFormatException nfe) {
                    throw StandardException.newException("22018", "DOUBLE");
                }
                double dv = doubleValue;
                if (dv == 0.0 && Double.parseDouble(doubleString.substring(0, ePosn - 1)) != 0.0) {
                    throw StandardException.newException("22003", "DOUBLE");
                }
                if (Double.isNaN(dv) || Double.isInfinite(dv)) {
                    throw StandardException.newException("22003", "DOUBLE");
                }
                return (ValueNode)this.nodeFactory.getNode(68, doubleValue, this.getContextManager());
            }
        }
        this.jj_la1[246] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode dateTimeLiteral() throws ParseException, StandardException {
        this.jj_consume_token(418);
        ValueNode constantNode = this.escapedDateTimeLiteral();
        this.jj_consume_token(419);
        return constantNode;
    }

    public final ValueNode escapedDateTimeLiteral() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 107: {
                this.jj_consume_token(107);
                ValueNode constantNode = this.bareDateLiteral();
                return constantNode;
            }
            case 231: {
                this.jj_consume_token(231);
                ValueNode constantNode = this.bareTimeLiteral();
                return constantNode;
            }
            case 243: {
                this.jj_consume_token(243);
                ValueNode constantNode = this.bareTimestampLiteral();
                return constantNode;
            }
        }
        this.jj_la1[247] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode bareDateLiteral() throws ParseException, StandardException {
        String dateString = this.string();
        return (ValueNode)this.nodeFactory.getNode(76, this.getLanguageConnectionContext().getDataValueFactory().getDateValue(dateString, true), this.getContextManager());
    }

    public final ValueNode bareTimeLiteral() throws ParseException, StandardException {
        String timeString = this.string();
        return (ValueNode)this.nodeFactory.getNode(76, this.getLanguageConnectionContext().getDataValueFactory().getTimeValue(timeString, true), this.getContextManager());
    }

    public final ValueNode bareTimestampLiteral() throws ParseException, StandardException {
        String timestampString = this.string();
        return (ValueNode)this.nodeFactory.getNode(76, this.getLanguageConnectionContext().getDataValueFactory().getTimestampValue(timestampString, true), this.getContextManager());
    }

    public final String string() throws ParseException, StandardException {
        Token tok = this.jj_consume_token(455);
        SQLParser.verifyImageLength(tok.image);
        return SQLParser.compressQuotes(tok.image.substring(1, tok.image.length() - 1), SINGLEQUOTES);
    }

    public final CharConstantNode stringLiteral() throws ParseException, StandardException {
        Token tok = this.jj_consume_token(455);
        if (tok.image.length() - 2 > 32672) {
            throw StandardException.newException("54002", StringUtil.formatForPrint(tok.image));
        }
        String string = SQLParser.compressQuotes(tok.image.substring(1, tok.image.length() - 1), SINGLEQUOTES);
        return (CharConstantNode)this.nodeFactory.getNode(61, string, this.getContextManager());
    }

    public final ValueNode hexLiteral() throws ParseException, StandardException {
        Token tok = this.jj_consume_token(456);
        String hexLiteral = tok.image;
        if (hexLiteral.length() - 3 > 16336) {
            throw StandardException.newException("54002", StringUtil.formatForPrint(hexLiteral));
        }
        if ((hexLiteral.length() - 3) % 2 == 1) {
            throw StandardException.newException("42606", StringUtil.formatForPrint(hexLiteral));
        }
        int bitLength = (hexLiteral.length() - 3) / 2;
        return (ValueNode)this.nodeFactory.getNode(59, hexLiteral.substring(2, hexLiteral.length() - 1), ReuseFactory.getInteger(bitLength), this.getContextManager());
    }

    public final TableName constraintNameDefinition() throws ParseException, StandardException {
        this.jj_consume_token(94);
        TableName constraintName = this.qualifiedName(128);
        return constraintName;
    }

    public final ConstraintDefinitionNode checkConstraintDefinition(TableName constraintName, String columnName) throws ParseException, StandardException {
        ResultColumnList rclList = null;
        this.jj_consume_token(85);
        Token beginToken = this.jj_consume_token(420);
        ValueNode value = this.valueExpression(false);
        Token endToken = this.jj_consume_token(421);
        if (columnName != null) {
            rclList = (ResultColumnList)this.nodeFactory.getNode(9, this.getContextManager());
            rclList.addElement((ResultColumn)this.nodeFactory.getNode(80, columnName, null, this.getContextManager()));
        }
        value.setBeginOffset(beginToken.beginOffset);
        value.setEndOffset(endToken.endOffset);
        return (ConstraintDefinitionNode)this.nodeFactory.getNode(131, constraintName, ReuseFactory.getInteger(4), rclList, null, value, StringUtil.slice(this.statementSQLText, beginToken.beginOffset, endToken.endOffset, true), this.getContextManager());
    }

    public final StatementNode spsRenameStatement() throws ParseException, StandardException {
        StatementNode qtn;
        this.jj_consume_token(393);
        switch (this.jj_nt.kind) {
            case 232: {
                qtn = this.renameTableStatement();
                break;
            }
            case 371: {
                qtn = this.renameIndexStatement();
                break;
            }
            case 90: {
                qtn = this.renameColumnStatement();
                break;
            }
            default: {
                this.jj_la1[248] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return qtn;
    }

    public final StatementNode renameTableStatement() throws ParseException, StandardException {
        this.jj_consume_token(232);
        TableName tableName = this.qualifiedName(128);
        this.jj_consume_token(236);
        String newTableName = this.identifier(128, true);
        return (StatementNode)this.nodeFactory.getNode(191, tableName, null, newTableName, Boolean.FALSE, ReuseFactory.getInteger(1), this.getContextManager());
    }

    public final StatementNode renameIndexStatement() throws ParseException, StandardException {
        this.jj_consume_token(371);
        String oldIndexName = this.identifier(128, true);
        this.jj_consume_token(236);
        String newIndexName = this.identifier(128, true);
        StatementNode qtn = (StatementNode)this.nodeFactory.getNode(191, null, oldIndexName, newIndexName, Boolean.FALSE, ReuseFactory.getInteger(3), this.getContextManager());
        return qtn;
    }

    public final StatementNode renameColumnStatement() throws ParseException, StandardException {
        this.jj_consume_token(90);
        ColumnReference oldColumnReference = this.columnReference();
        this.jj_consume_token(236);
        String newColumnName = this.identifier(128, true);
        if (oldColumnReference.getTableNameNode() == null) {
            throw StandardException.newException("42Y55", (Object)"RENAME COLUMN", (Object)oldColumnReference.getColumnName());
        }
        return (StatementNode)this.nodeFactory.getNode(191, oldColumnReference.getTableNameNode(), oldColumnReference.getColumnName(), newColumnName, Boolean.FALSE, ReuseFactory.getInteger(2), this.getContextManager());
    }

    public final StatementNode lockStatement() throws ParseException, StandardException {
        this.jj_consume_token(375);
        this.jj_consume_token(232);
        TableName tableName = this.qualifiedName(128);
        this.jj_consume_token(153);
        Boolean exclusiveMode = this.lockMode();
        this.jj_consume_token(378);
        return (StatementNode)this.nodeFactory.getNode(112, tableName, exclusiveMode, this.getContextManager());
    }

    public final Boolean lockMode() throws ParseException {
        switch (this.jj_nt.kind) {
            case 369: {
                this.jj_consume_token(369);
                return Boolean.TRUE;
            }
            case 403: {
                this.jj_consume_token(403);
                return Boolean.FALSE;
            }
        }
        this.jj_la1[249] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode execStatement() throws ParseException, StandardException {
        this.jj_consume_token(130);
        this.jj_consume_token(328);
        TableName stmtName = this.qualifiedName(128);
        return (StatementNode)this.nodeFactory.getNode(118, stmtName, this.getContextManager());
    }

    public final TransactionStatementNode setIsolationStatement() throws ParseException, StandardException {
        this.setIsolationHeader();
        block0 : switch (this.jj_nt.kind) {
            case 236: 
            case 433: {
                switch (this.jj_nt.kind) {
                    case 433: {
                        this.jj_consume_token(433);
                        break block0;
                    }
                    case 236: {
                        this.jj_consume_token(236);
                        break block0;
                    }
                }
                this.jj_la1[250] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[251] = this.jj_gen;
            }
        }
        TransactionStatementNode tranNode = this.transactionMode();
        return tranNode;
    }

    public final void setIsolationHeader() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 165: {
                this.jj_consume_token(165);
                break;
            }
            default: {
                this.jj_la1[252] = this.jj_gen;
                if (this.getToken((int)1).kind == 101 && this.getToken((int)2).kind == 165) {
                    this.jj_consume_token(101);
                    this.jj_consume_token(165);
                    break;
                }
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final TransactionStatementNode transactionMode() throws ParseException, StandardException {
        int isolationLevel = this.isolationLevelDB2OrReset();
        return (TransactionStatementNode)this.nodeFactory.getNode(21, ReuseFactory.getInteger(isolationLevel), this.getContextManager());
    }

    public final int isolationLevelDB2OrReset() throws ParseException {
        switch (this.jj_nt.kind) {
            case 394: {
                this.jj_consume_token(394);
                return 0;
            }
        }
        this.jj_la1[253] = this.jj_gen;
        if (this.jj_2_49(1)) {
            int isolationLevel = this.isolationLevelDB2();
            return isolationLevel;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final int isolationLevelDB2() throws ParseException {
        switch (this.jj_nt.kind) {
            case 362: 
            case 398: 
            case 399: 
            case 412: {
                int isolationLevel = this.isolationLevelDB2Abbrev();
                return isolationLevel;
            }
            case 310: 
            case 317: {
                switch (this.jj_nt.kind) {
                    case 310: {
                        this.jj_consume_token(310);
                        this.jj_consume_token(206);
                        break;
                    }
                    case 317: {
                        this.jj_consume_token(317);
                        break;
                    }
                    default: {
                        this.jj_la1[254] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                return 4;
            }
            case 106: {
                this.jj_consume_token(106);
                this.jj_consume_token(407);
                return 2;
            }
            case 365: {
                this.jj_consume_token(365);
                this.jj_consume_token(206);
                return 1;
            }
        }
        this.jj_la1[255] = this.jj_gen;
        if (this.getToken((int)1).kind == 206 && this.getToken((int)2).kind == 272) {
            this.jj_consume_token(206);
            this.jj_consume_token(272);
            return 2;
        }
        if (this.getToken((int)1).kind == 206 && this.getToken((int)2).kind == 337) {
            this.jj_consume_token(206);
            this.jj_consume_token(337);
            return 1;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final int isolationLevelDB2Abbrev() throws ParseException {
        switch (this.jj_nt.kind) {
            case 398: {
                this.jj_consume_token(398);
                return 4;
            }
            case 399: {
                this.jj_consume_token(399);
                return 3;
            }
            case 362: {
                this.jj_consume_token(362);
                return 2;
            }
            case 412: {
                this.jj_consume_token(412);
                return 1;
            }
        }
        this.jj_la1[256] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final int isolationLevel() throws ParseException {
        this.jj_consume_token(165);
        this.jj_consume_token(291);
        int isolationLevel = this.levelOfIsolation();
        return isolationLevel;
    }

    public final int levelOfIsolation() throws ParseException {
        switch (this.jj_nt.kind) {
            case 206: {
                this.jj_consume_token(206);
                return this.levelOfIsolationRead();
            }
            case 310: {
                this.jj_consume_token(310);
                this.jj_consume_token(206);
                return 3;
            }
            case 317: {
                this.jj_consume_token(317);
                return 4;
            }
        }
        this.jj_la1[257] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final int levelOfIsolationRead() throws ParseException {
        switch (this.jj_nt.kind) {
            case 337: {
                this.jj_consume_token(337);
                return 1;
            }
            case 272: {
                this.jj_consume_token(272);
                return 2;
            }
        }
        this.jj_la1[258] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode simpleValueSpecification() throws ParseException, StandardException {
        ValueNode value = this.literal();
        return value;
    }

    public final StatementNode setSchemaStatement() throws ParseException, StandardException {
        this.setSchemaHeader();
        switch (this.jj_nt.kind) {
            case 433: {
                this.jj_consume_token(433);
                break;
            }
            default: {
                this.jj_la1[259] = this.jj_gen;
            }
        }
        StatementNode setSchema = this.setSchemaValues();
        if (this.parameterList != null && this.parameterList.size() > 0) {
            this.setUpAndLinkParameters();
            ParameterNode p = (ParameterNode)this.parameterList.elementAt(0);
            p.setType(new DataTypeDescriptor(TypeId.getBuiltInTypeId(12), false, 128));
        }
        return setSchema;
    }

    public final void setSchemaHeader() throws ParseException, StandardException {
        block0 : switch (this.jj_nt.kind) {
            case 215: {
                this.jj_consume_token(215);
                break;
            }
            default: {
                this.jj_la1[261] = this.jj_gen;
                if (this.getToken((int)1).kind == 101 && (this.getToken((int)2).kind == 215 || this.getToken((int)2).kind == 404)) {
                    this.jj_consume_token(101);
                    switch (this.jj_nt.kind) {
                        case 215: {
                            this.jj_consume_token(215);
                            break block0;
                        }
                        case 404: {
                            this.jj_consume_token(404);
                            break block0;
                        }
                    }
                    this.jj_la1[260] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final StatementNode setSchemaValues() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 74: 
            case 87: 
            case 99: 
            case 107: 
            case 177: 
            case 231: 
            case 243: 
            case 251: 
            case 253: 
            case 263: 
            case 264: 
            case 265: 
            case 266: 
            case 267: 
            case 268: 
            case 269: 
            case 270: 
            case 271: 
            case 272: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 277: 
            case 279: 
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 284: 
            case 286: 
            case 288: 
            case 289: 
            case 290: 
            case 291: 
            case 292: 
            case 293: 
            case 294: 
            case 295: 
            case 296: 
            case 297: 
            case 298: 
            case 299: 
            case 300: 
            case 301: 
            case 302: 
            case 303: 
            case 304: 
            case 305: 
            case 306: 
            case 307: 
            case 308: 
            case 309: 
            case 310: 
            case 311: 
            case 312: 
            case 313: 
            case 314: 
            case 315: 
            case 317: 
            case 318: 
            case 319: 
            case 320: 
            case 321: 
            case 322: 
            case 323: 
            case 324: 
            case 325: 
            case 326: 
            case 327: 
            case 328: 
            case 329: 
            case 330: 
            case 331: 
            case 332: 
            case 333: 
            case 334: 
            case 335: 
            case 336: 
            case 337: 
            case 338: 
            case 339: 
            case 342: 
            case 343: 
            case 344: 
            case 348: 
            case 357: 
            case 358: 
            case 359: 
            case 360: 
            case 361: 
            case 362: 
            case 364: 
            case 365: 
            case 366: 
            case 367: 
            case 368: 
            case 369: 
            case 370: 
            case 371: 
            case 372: 
            case 373: 
            case 374: 
            case 375: 
            case 376: 
            case 377: 
            case 378: 
            case 379: 
            case 380: 
            case 382: 
            case 383: 
            case 384: 
            case 385: 
            case 387: 
            case 388: 
            case 389: 
            case 390: 
            case 391: 
            case 392: 
            case 393: 
            case 394: 
            case 395: 
            case 396: 
            case 397: 
            case 398: 
            case 399: 
            case 400: 
            case 401: 
            case 402: 
            case 403: 
            case 404: 
            case 405: 
            case 406: 
            case 407: 
            case 408: 
            case 409: 
            case 410: 
            case 411: 
            case 412: 
            case 413: 
            case 445: 
            case 451: {
                String schemaName = this.identifier(128, true);
                return (StatementNode)this.nodeFactory.getNode(81, schemaName, null, this.getContextManager());
            }
            case 249: {
                this.jj_consume_token(249);
                return (StatementNode)this.nodeFactory.getNode(81, null, ReuseFactory.getInteger(1), this.getContextManager());
            }
            case 438: {
                this.dynamicParameterSpecification();
                return (StatementNode)this.nodeFactory.getNode(81, null, ReuseFactory.getInteger(2), this.getContextManager());
            }
            case 455: {
                String schemaName = this.string();
                this.checkIdentifierLengthLimit(schemaName, 128);
                return (StatementNode)this.nodeFactory.getNode(81, schemaName, null, this.getContextManager());
            }
        }
        this.jj_la1[262] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode setMessageLocaleStatement() throws ParseException, StandardException {
        this.jj_consume_token(376);
        String messageLocale = this.string();
        this.getContextManager().setMessageLocale(messageLocale);
        return (StatementNode)this.nodeFactory.getNode(19, this.getContextManager());
    }

    public final ValueNode valueSpecification() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 133: 
            case 242: 
            case 418: 
            case 423: 
            case 425: 
            case 452: 
            case 455: 
            case 456: 
            case 457: {
                ValueNode value = this.literal();
                return value;
            }
            case 105: 
            case 219: 
            case 249: 
            case 438: {
                ValueNode value = this.generalValueSpecification();
                return value;
            }
            case 185: {
                this.jj_consume_token(185);
                this.jj_consume_token(420);
                ValueNode leftExpression = this.additiveExpression(null, 0, false);
                this.jj_consume_token(424);
                ValueNode rightExpression = this.additiveExpression(null, 0, false);
                this.jj_consume_token(421);
                ContextManager cm = this.getContextManager();
                ValueNodeList thenElseList = (ValueNodeList)this.nodeFactory.getNode(15, cm);
                thenElseList.addElement((ValueNode)this.nodeFactory.getNode(13, cm));
                thenElseList.addElement(leftExpression);
                return (ValueNode)this.nodeFactory.getNode(54, (ValueNode)this.nodeFactory.getNode(41, leftExpression, rightExpression, cm), thenElseList, Boolean.TRUE, cm);
            }
            case 80: {
                this.jj_consume_token(80);
                ValueNode value = this.whenThenExpression();
                return value;
            }
        }
        this.jj_la1[263] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode caseExpression() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 124: {
                this.jj_consume_token(124);
                ValueNode value = (ValueNode)this.nodeFactory.getNode(60, (ValueNode)this.nodeFactory.getNode(13, this.getContextManager()), DataTypeDescriptor.getBuiltInDataTypeDescriptor(1, 1), this.getContextManager());
                ((CastNode)value).setForExternallyGeneratedCASTnode();
                return value;
            }
            case 123: {
                this.jj_consume_token(123);
                ValueNode expr = this.thenElseExpression();
                this.jj_consume_token(124);
                return expr;
            }
            case 339: {
                ValueNode expr = this.whenThenExpression();
                return expr;
            }
        }
        this.jj_la1[264] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ValueNode whenThenExpression() throws ParseException, StandardException {
        this.jj_consume_token(339);
        ValueNode expr = this.orExpression(null, false);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 192: {
                    break;
                }
                default: {
                    this.jj_la1[265] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(192);
            expr = this.orExpression(expr, false);
        }
        this.jj_consume_token(330);
        ValueNode thenExpr = this.thenElseExpression();
        ValueNode elseExpr = this.caseExpression();
        ContextManager cm = this.getContextManager();
        ValueNodeList thenElseList = (ValueNodeList)this.nodeFactory.getNode(15, cm);
        thenElseList.addElement(thenExpr);
        thenElseList.addElement(elseExpr);
        return (ValueNode)this.nodeFactory.getNode(54, expr, thenElseList, Boolean.FALSE, cm);
    }

    public final ValueNode thenElseExpression() throws ParseException, StandardException {
        if (this.getToken((int)1).kind == 184) {
            this.jj_consume_token(184);
            ValueNode value = (ValueNode)this.nodeFactory.getNode(60, (ValueNode)this.nodeFactory.getNode(13, this.getContextManager()), DataTypeDescriptor.getBuiltInDataTypeDescriptor(1, 1), this.getContextManager());
            ((CastNode)value).setForExternallyGeneratedCASTnode();
            return value;
        }
        if (this.jj_2_50(1)) {
            ValueNode expr = this.additiveExpression(null, 0, false);
            return expr;
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final TableElementNode tableConstraintDefinition() throws ParseException, StandardException {
        Properties properties = null;
        TableName constraintName = null;
        this.explicitNotNull = false;
        this.explicitNull = false;
        switch (this.jj_nt.kind) {
            case 94: {
                constraintName = this.constraintNameDefinition();
                break;
            }
            default: {
                this.jj_la1[266] = this.jj_gen;
            }
        }
        ConstraintDefinitionNode tcdn = this.tableConstraint(constraintName);
        switch (this.jj_nt.kind) {
            case 53: {
                properties = this.propertyList(false);
                this.jj_consume_token(58);
                break;
            }
            default: {
                this.jj_la1[267] = this.jj_gen;
            }
        }
        if (properties != null) {
            tcdn.setProperties(properties);
        }
        return tcdn;
    }

    public final ConstraintDefinitionNode tableConstraint(TableName constraintName) throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 201: 
            case 245: {
                ConstraintDefinitionNode tcdn = this.uniqueConstraintDefinition(constraintName);
                return tcdn;
            }
            case 138: {
                ConstraintDefinitionNode tcdn = this.referentialConstraintDefinition(constraintName);
                return tcdn;
            }
            case 85: {
                ConstraintDefinitionNode tcdn = this.checkConstraintDefinition(constraintName, null);
                return tcdn;
            }
        }
        this.jj_la1[268] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ConstraintDefinitionNode uniqueConstraintDefinition(TableName constraintName) throws ParseException, StandardException {
        int constraintType = this.uniqueSpecification(null, null);
        this.jj_consume_token(420);
        ResultColumnList uniqueColumnList = this.uniqueColumnList();
        this.jj_consume_token(421);
        if (constraintType == 2) {
            for (int index = 0; index < uniqueColumnList.size(); ++index) {
                String primaryKeyColumnName = ((ResultColumn)uniqueColumnList.elementAt(index)).getName();
                if (!this.explicitlyNullableColumnsList.contains(primaryKeyColumnName)) continue;
                String errorState = "42831";
                throw StandardException.newException(errorState, primaryKeyColumnName);
            }
        }
        return (ConstraintDefinitionNode)this.nodeFactory.getNode(131, constraintName, ReuseFactory.getInteger(constraintType), uniqueColumnList, null, null, null, this.getContextManager());
    }

    public final int uniqueSpecification(DataTypeDescriptor dataTypeDescriptor, String columnName) throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 245: {
                this.jj_consume_token(245);
                return 3;
            }
            case 201: {
                this.jj_consume_token(201);
                this.jj_consume_token(167);
                if (this.explicitNull) {
                    String errorState = "42831";
                    throw StandardException.newException(errorState, columnName);
                }
                return 2;
            }
        }
        this.jj_la1[269] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ResultColumnList uniqueColumnList() throws ParseException, StandardException {
        ResultColumnList resultColumns = (ResultColumnList)this.nodeFactory.getNode(9, this.getContextManager());
        this.columnNameList(resultColumns);
        return resultColumns;
    }

    public final ConstraintDefinitionNode referentialConstraintDefinition(TableName constraintName) throws ParseException, StandardException {
        ResultColumnList fkRcl = (ResultColumnList)this.nodeFactory.getNode(9, this.getContextManager());
        ResultColumnList refRcl = (ResultColumnList)this.nodeFactory.getNode(9, this.getContextManager());
        int[] refActions = new int[]{2, 2};
        this.jj_consume_token(138);
        this.jj_consume_token(167);
        this.jj_consume_token(420);
        this.columnNameList(fkRcl);
        this.jj_consume_token(421);
        TableName referencedTable = this.referencesSpecification(refRcl, refActions);
        return (ConstraintDefinitionNode)this.nodeFactory.getNode(119, constraintName, referencedTable, fkRcl, refRcl, refActions, this.getContextManager());
    }

    public final TableName referencesSpecification(ResultColumnList rcl, int[] refActions) throws ParseException, StandardException {
        TableName tableName = null;
        this.jj_consume_token(208);
        tableName = this.referencedTableAndColumns(rcl);
        switch (this.jj_nt.kind) {
            case 188: {
                this.jj_consume_token(188);
                this.referentialTriggeredAction(refActions);
                break;
            }
            default: {
                this.jj_la1[270] = this.jj_gen;
            }
        }
        return tableName;
    }

    public final TableName referencedTableAndColumns(ResultColumnList rcl) throws ParseException, StandardException {
        TableName tableName = null;
        tableName = this.qualifiedName(128);
        switch (this.jj_nt.kind) {
            case 420: {
                this.jj_consume_token(420);
                this.columnNameList(rcl);
                this.jj_consume_token(421);
                break;
            }
            default: {
                this.jj_la1[271] = this.jj_gen;
            }
        }
        return tableName;
    }

    public final void referentialTriggeredAction(int[] refActions) throws ParseException, StandardException {
        block0 : switch (this.jj_nt.kind) {
            case 247: {
                refActions[1] = this.updateRule();
                switch (this.jj_nt.kind) {
                    case 188: {
                        this.jj_consume_token(188);
                        refActions[0] = this.deleteRule();
                        break block0;
                    }
                }
                this.jj_la1[272] = this.jj_gen;
                break;
            }
            case 115: {
                refActions[0] = this.deleteRule();
                switch (this.jj_nt.kind) {
                    case 188: {
                        this.jj_consume_token(188);
                        refActions[1] = this.updateRule();
                        break block0;
                    }
                }
                this.jj_la1[273] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[274] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final int updateRule() throws ParseException {
        this.jj_consume_token(247);
        int action = this.updateReferentialAction();
        return action;
    }

    public final int deleteRule() throws ParseException {
        this.jj_consume_token(115);
        int action = this.deleteReferentialAction();
        return action;
    }

    public final int updateReferentialAction() throws ParseException {
        switch (this.jj_nt.kind) {
            case 210: {
                this.jj_consume_token(210);
                return 1;
            }
            case 182: {
                this.jj_consume_token(182);
                this.jj_consume_token(265);
                return 2;
            }
        }
        this.jj_la1[275] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final int deleteReferentialAction() throws ParseException {
        switch (this.jj_nt.kind) {
            case 78: {
                this.jj_consume_token(78);
                return 0;
            }
            case 210: {
                this.jj_consume_token(210);
                return 1;
            }
            case 182: {
                this.jj_consume_token(182);
                this.jj_consume_token(265);
                return 2;
            }
            case 220: {
                this.jj_consume_token(220);
                switch (this.jj_nt.kind) {
                    case 184: {
                        this.jj_consume_token(184);
                        return 3;
                    }
                    case 112: {
                        this.jj_consume_token(112);
                        return 4;
                    }
                }
                this.jj_la1[276] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_la1[277] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final void columnConstraintDefinition(DataTypeDescriptor dataTypeDescriptor, TableElementList tableElementList, String columnName) throws ParseException, StandardException {
        TableName constraintName = null;
        switch (this.jj_nt.kind) {
            case 94: {
                constraintName = this.constraintNameDefinition();
                break;
            }
            default: {
                this.jj_la1[278] = this.jj_gen;
            }
        }
        ConstraintDefinitionNode tcdn = this.columnConstraint(constraintName, dataTypeDescriptor, columnName);
        if (tcdn == null) {
            return;
        }
        tableElementList.addTableElement(tcdn);
    }

    public final ConstraintDefinitionNode columnConstraint(TableName constraintName, DataTypeDescriptor dataTypeDescriptor, String columnName) throws ParseException, StandardException {
        Properties properties = null;
        ResultColumnList refRcl = (ResultColumnList)this.nodeFactory.getNode(9, this.getContextManager());
        int[] refActions = new int[]{2, 2};
        switch (this.jj_nt.kind) {
            case 183: {
                this.jj_consume_token(183);
                this.jj_consume_token(184);
                this.explicitNotNull = true;
                if (this.explicitNull) {
                    throw StandardException.newException("42X83", columnName);
                }
                dataTypeDescriptor.setNullability(false);
                return null;
            }
            case 201: 
            case 245: {
                int constraintType = this.uniqueSpecification(dataTypeDescriptor, columnName);
                switch (this.jj_nt.kind) {
                    case 53: {
                        properties = this.propertyList(false);
                        this.jj_consume_token(58);
                        break;
                    }
                    default: {
                        this.jj_la1[279] = this.jj_gen;
                    }
                }
                ResultColumnList uniqueColumnList = (ResultColumnList)this.nodeFactory.getNode(9, this.getContextManager());
                uniqueColumnList.addElement((ResultColumn)this.nodeFactory.getNode(80, columnName, null, this.getContextManager()));
                return (ConstraintDefinitionNode)this.nodeFactory.getNode(131, constraintName, ReuseFactory.getInteger(constraintType), uniqueColumnList, properties, null, null, this.getContextManager());
            }
            case 208: {
                TableName referencedTable = this.referencesSpecification(refRcl, refActions);
                switch (this.jj_nt.kind) {
                    case 53: {
                        properties = this.propertyList(false);
                        this.jj_consume_token(58);
                        break;
                    }
                    default: {
                        this.jj_la1[280] = this.jj_gen;
                    }
                }
                ResultColumnList fkRcl = (ResultColumnList)this.nodeFactory.getNode(9, this.getContextManager());
                fkRcl.addElement((ResultColumn)this.nodeFactory.getNode(80, columnName, null, this.getContextManager()));
                ConstraintDefinitionNode tcdn = (ConstraintDefinitionNode)this.nodeFactory.getNode(119, constraintName, referencedTable, fkRcl, refRcl, refActions, this.getContextManager());
                if (properties != null) {
                    tcdn.setProperties(properties);
                }
                return tcdn;
            }
            case 85: {
                ConstraintDefinitionNode tcdn = this.checkConstraintDefinition(constraintName, columnName);
                return tcdn;
            }
        }
        this.jj_la1[281] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode dropSchemaStatement() throws ParseException, StandardException {
        this.jj_consume_token(215);
        String schemaName = this.identifier(128, true);
        this.jj_consume_token(210);
        StatementNode stmt = (StatementNode)this.nodeFactory.getNode(90, schemaName, new Integer(1), this.getContextManager());
        return stmt;
    }

    public final StatementNode alterTableStatement() throws ParseException, StandardException {
        this.jj_consume_token(232);
        TableName tableName = this.qualifiedName(128);
        StatementNode node = this.alterTableBody(tableName);
        return node;
    }

    public final StatementNode alterTableBody(TableName tableName) throws ParseException, StandardException {
        char lockGranularity = '\u0000';
        TableElementList tableElementList = (TableElementList)this.nodeFactory.getNode(12, this.getContextManager());
        Token tok = null;
        int[] changeType = new int[1];
        int[] behavior = new int[1];
        boolean[] sequential = new boolean[1];
        switch (this.jj_nt.kind) {
            case 360: {
                this.jj_consume_token(360);
                switch (this.jj_nt.kind) {
                    case 401: {
                        tok = this.jj_consume_token(401);
                        break;
                    }
                    default: {
                        this.jj_la1[282] = this.jj_gen;
                    }
                }
                this.checkInternalFeature("COMPRESS");
                return (StatementNode)this.nodeFactory.getNode(114, tableName, new Boolean(tok != null), this.getContextManager());
            }
            case 59: 
            case 62: 
            case 122: 
            case 293: {
                lockGranularity = this.alterTableAction(tableElementList, changeType, behavior, sequential);
                return (StatementNode)this.nodeFactory.getNode(114, tableName, tableElementList, new Character(lockGranularity), changeType, behavior, sequential, this.getContextManager());
            }
        }
        this.jj_la1[283] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final char alterTableAction(TableElementList tableElementList, int[] changeType, int[] behavior, boolean[] sequential) throws ParseException, StandardException {
        char lockGranularity = '\u0000';
        Object tok = null;
        long[] autoIncrementInfo = new long[4];
        switch (this.jj_nt.kind) {
            case 59: {
                ColumnDefinitionNode cdn;
                TableElementNode tableElement;
                this.jj_consume_token(59);
                switch (this.jj_nt.kind) {
                    case 74: 
                    case 87: 
                    case 90: 
                    case 99: 
                    case 107: 
                    case 177: 
                    case 231: 
                    case 243: 
                    case 251: 
                    case 253: 
                    case 263: 
                    case 264: 
                    case 265: 
                    case 266: 
                    case 267: 
                    case 268: 
                    case 269: 
                    case 270: 
                    case 271: 
                    case 272: 
                    case 273: 
                    case 274: 
                    case 275: 
                    case 276: 
                    case 277: 
                    case 279: 
                    case 280: 
                    case 281: 
                    case 282: 
                    case 283: 
                    case 284: 
                    case 286: 
                    case 288: 
                    case 289: 
                    case 290: 
                    case 291: 
                    case 292: 
                    case 293: 
                    case 294: 
                    case 295: 
                    case 296: 
                    case 297: 
                    case 298: 
                    case 299: 
                    case 300: 
                    case 301: 
                    case 302: 
                    case 303: 
                    case 304: 
                    case 305: 
                    case 306: 
                    case 307: 
                    case 308: 
                    case 309: 
                    case 310: 
                    case 311: 
                    case 312: 
                    case 313: 
                    case 314: 
                    case 315: 
                    case 317: 
                    case 318: 
                    case 319: 
                    case 320: 
                    case 321: 
                    case 322: 
                    case 323: 
                    case 324: 
                    case 325: 
                    case 326: 
                    case 327: 
                    case 328: 
                    case 329: 
                    case 330: 
                    case 331: 
                    case 332: 
                    case 333: 
                    case 334: 
                    case 335: 
                    case 336: 
                    case 337: 
                    case 338: 
                    case 339: 
                    case 342: 
                    case 343: 
                    case 344: 
                    case 348: 
                    case 357: 
                    case 358: 
                    case 359: 
                    case 360: 
                    case 361: 
                    case 362: 
                    case 364: 
                    case 365: 
                    case 366: 
                    case 367: 
                    case 368: 
                    case 369: 
                    case 370: 
                    case 371: 
                    case 372: 
                    case 373: 
                    case 374: 
                    case 375: 
                    case 376: 
                    case 377: 
                    case 378: 
                    case 379: 
                    case 380: 
                    case 382: 
                    case 383: 
                    case 384: 
                    case 385: 
                    case 387: 
                    case 388: 
                    case 389: 
                    case 390: 
                    case 391: 
                    case 392: 
                    case 393: 
                    case 394: 
                    case 395: 
                    case 396: 
                    case 397: 
                    case 398: 
                    case 399: 
                    case 400: 
                    case 401: 
                    case 402: 
                    case 403: 
                    case 404: 
                    case 405: 
                    case 406: 
                    case 407: 
                    case 408: 
                    case 409: 
                    case 410: 
                    case 411: 
                    case 412: 
                    case 413: 
                    case 445: 
                    case 451: {
                        tableElement = this.addColumnDefinition(tableElementList);
                        break;
                    }
                    case 85: 
                    case 94: 
                    case 138: 
                    case 201: 
                    case 245: {
                        tableElement = this.tableConstraintDefinition();
                        break;
                    }
                    default: {
                        this.jj_la1[284] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                if (tableElement instanceof ColumnDefinitionNode && (cdn = (ColumnDefinitionNode)tableElement).isAutoincrementColumn()) {
                    throw StandardException.newException("42601.S.372");
                }
                changeType[0] = 1;
                tableElementList.addTableElement(tableElement);
                return lockGranularity;
            }
            case 62: {
                this.jj_consume_token(62);
                switch (this.jj_nt.kind) {
                    case 90: {
                        this.jj_consume_token(90);
                        break;
                    }
                    default: {
                        this.jj_la1[285] = this.jj_gen;
                    }
                }
                String columnName = this.identifier(128, true);
                TableElementNode tableElement = this.columnAlterClause(columnName);
                changeType[0] = 3;
                tableElementList.addTableElement(tableElement);
                return lockGranularity;
            }
            case 122: {
                TableElementNode tableElement;
                this.jj_consume_token(122);
                switch (this.jj_nt.kind) {
                    case 74: 
                    case 87: 
                    case 90: 
                    case 99: 
                    case 107: 
                    case 177: 
                    case 231: 
                    case 243: 
                    case 251: 
                    case 253: 
                    case 263: 
                    case 264: 
                    case 265: 
                    case 266: 
                    case 267: 
                    case 268: 
                    case 269: 
                    case 270: 
                    case 271: 
                    case 272: 
                    case 273: 
                    case 274: 
                    case 275: 
                    case 276: 
                    case 277: 
                    case 279: 
                    case 280: 
                    case 281: 
                    case 282: 
                    case 283: 
                    case 284: 
                    case 286: 
                    case 288: 
                    case 289: 
                    case 290: 
                    case 291: 
                    case 292: 
                    case 293: 
                    case 294: 
                    case 295: 
                    case 296: 
                    case 297: 
                    case 298: 
                    case 299: 
                    case 300: 
                    case 301: 
                    case 302: 
                    case 303: 
                    case 304: 
                    case 305: 
                    case 306: 
                    case 307: 
                    case 308: 
                    case 309: 
                    case 310: 
                    case 311: 
                    case 312: 
                    case 313: 
                    case 314: 
                    case 315: 
                    case 317: 
                    case 318: 
                    case 319: 
                    case 320: 
                    case 321: 
                    case 322: 
                    case 323: 
                    case 324: 
                    case 325: 
                    case 326: 
                    case 327: 
                    case 328: 
                    case 329: 
                    case 330: 
                    case 331: 
                    case 332: 
                    case 333: 
                    case 334: 
                    case 335: 
                    case 336: 
                    case 337: 
                    case 338: 
                    case 339: 
                    case 342: 
                    case 343: 
                    case 344: 
                    case 348: 
                    case 357: 
                    case 358: 
                    case 359: 
                    case 360: 
                    case 361: 
                    case 362: 
                    case 364: 
                    case 365: 
                    case 366: 
                    case 367: 
                    case 368: 
                    case 369: 
                    case 370: 
                    case 371: 
                    case 372: 
                    case 373: 
                    case 374: 
                    case 375: 
                    case 376: 
                    case 377: 
                    case 378: 
                    case 379: 
                    case 380: 
                    case 382: 
                    case 383: 
                    case 384: 
                    case 385: 
                    case 387: 
                    case 388: 
                    case 389: 
                    case 390: 
                    case 391: 
                    case 392: 
                    case 393: 
                    case 394: 
                    case 395: 
                    case 396: 
                    case 397: 
                    case 398: 
                    case 399: 
                    case 400: 
                    case 401: 
                    case 402: 
                    case 403: 
                    case 404: 
                    case 405: 
                    case 406: 
                    case 407: 
                    case 408: 
                    case 409: 
                    case 410: 
                    case 411: 
                    case 412: 
                    case 413: 
                    case 445: 
                    case 451: {
                        tableElement = this.dropColumnDefinition(behavior);
                        break;
                    }
                    default: {
                        this.jj_la1[286] = this.jj_gen;
                        if (this.jj_2_51(1)) {
                            tableElement = this.dropTableConstraintDefinition();
                            break;
                        }
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                changeType[0] = 2;
                tableElementList.addTableElement(tableElement);
                return lockGranularity;
            }
            case 293: {
                lockGranularity = this.DB2lockGranularityClause();
                changeType[0] = 4;
                return lockGranularity;
            }
        }
        this.jj_la1[287] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final TableElementNode dropColumnDefinition(int[] behavior) throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 90: {
                this.jj_consume_token(90);
                break;
            }
            default: {
                this.jj_la1[288] = this.jj_gen;
            }
        }
        String columnName = this.identifier(128, true);
        this.dropColumnReferentialAction(behavior);
        return (TableElementNode)this.nodeFactory.getNode(113, columnName, null, null, null, this.getContextManager());
    }

    public final void dropColumnReferentialAction(int[] behavior) throws ParseException {
        int refBehavior = 0;
        block0 : switch (this.jj_nt.kind) {
            case 78: 
            case 210: {
                switch (this.jj_nt.kind) {
                    case 78: {
                        this.jj_consume_token(78);
                        refBehavior = 0;
                        break block0;
                    }
                    case 210: {
                        this.jj_consume_token(210);
                        refBehavior = 1;
                        break block0;
                    }
                }
                this.jj_la1[289] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[290] = this.jj_gen;
            }
        }
        behavior[0] = refBehavior;
    }

    public final TableElementNode addColumnDefinition(TableElementList tableElementList) throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 90: {
                this.jj_consume_token(90);
                break;
            }
            default: {
                this.jj_la1[291] = this.jj_gen;
            }
        }
        TableElementNode tableElement = this.columnDefinition(tableElementList);
        return tableElement;
    }

    public final TableElementNode columnAlterClause(String columnName) throws ParseException, StandardException {
        long[] autoIncrementInfo = new long[4];
        long autoIncrementIncrement = 1L;
        long autoIncrementRestartWith = 1L;
        DataTypeDescriptor typeDescriptor = null;
        if (this.getToken((int)2).kind == 275) {
            this.jj_consume_token(220);
            this.jj_consume_token(275);
            this.jj_consume_token(336);
            typeDescriptor = this.dataTypeDDL();
            return (TableElementNode)this.nodeFactory.getNode(186, columnName, null, typeDescriptor, null, this.getContextManager());
        }
        if (this.getToken((int)2).kind == 283) {
            this.jj_consume_token(220);
            this.jj_consume_token(283);
            this.jj_consume_token(77);
            autoIncrementInfo[1] = autoIncrementIncrement = this.exactNumber();
            autoIncrementInfo[3] = 2L;
            return (TableElementNode)this.nodeFactory.getNode(97, columnName, null, null, autoIncrementInfo, this.getContextManager());
        }
        switch (this.jj_nt.kind) {
            case 311: {
                this.jj_consume_token(311);
                this.jj_consume_token(259);
                autoIncrementInfo[0] = autoIncrementRestartWith = this.exactNumber();
                autoIncrementInfo[3] = 1L;
                return (TableElementNode)this.nodeFactory.getNode(97, columnName, null, null, autoIncrementInfo, this.getContextManager());
            }
        }
        this.jj_la1[292] = this.jj_gen;
        if (this.getToken((int)1).kind == 259 || this.getToken((int)1).kind == 112) {
            ValueNode defaultNode = this.defaultClause(autoIncrementInfo, columnName);
            if (autoIncrementInfo[2] == 0L) {
                autoIncrementInfo = null;
            }
            return (TableElementNode)this.nodeFactory.getNode(97, columnName, defaultNode, null, autoIncrementInfo, this.getContextManager());
        }
        if (this.getToken((int)1).kind == 184) {
            this.jj_consume_token(184);
            return (TableElementNode)this.nodeFactory.getNode(187, columnName, null, null, null, this.getContextManager());
        }
        if (this.getToken((int)1).kind == 183) {
            this.jj_consume_token(183);
            this.jj_consume_token(184);
            return (TableElementNode)this.nodeFactory.getNode(193, columnName, null, null, null, this.getContextManager());
        }
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final TableElementNode dropTableConstraintDefinition() throws ParseException, StandardException {
        if (this.getToken((int)1).kind == 94) {
            this.jj_consume_token(94);
            TableName constraintName = this.qualifiedName(128);
            return (TableElementNode)this.nodeFactory.getNode(131, constraintName, ReuseFactory.getInteger(5), null, null, null, null, ReuseFactory.getInteger(2), this.getContextManager());
        }
        if (this.getToken((int)1).kind == 201) {
            this.jj_consume_token(201);
            this.jj_consume_token(167);
            return (TableElementNode)this.nodeFactory.getNode(131, null, ReuseFactory.getInteger(5), null, null, null, null, ReuseFactory.getInteger(2), this.getContextManager());
        }
        if (this.getToken((int)1).kind == 138) {
            this.jj_consume_token(138);
            this.jj_consume_token(167);
            TableName constraintName = this.qualifiedName(128);
            return (TableElementNode)this.nodeFactory.getNode(131, constraintName, ReuseFactory.getInteger(5), null, null, null, null, ReuseFactory.getInteger(2), ReuseFactory.getInteger(6), this.getContextManager());
        }
        if (this.getToken((int)1).kind == 245) {
            this.jj_consume_token(245);
            TableName constraintName = this.qualifiedName(128);
            return (TableElementNode)this.nodeFactory.getNode(131, constraintName, ReuseFactory.getInteger(5), null, null, null, null, ReuseFactory.getInteger(2), ReuseFactory.getInteger(3), this.getContextManager());
        }
        switch (this.jj_nt.kind) {
            case 85: {
                this.jj_consume_token(85);
                TableName constraintName = this.qualifiedName(128);
                return (TableElementNode)this.nodeFactory.getNode(131, constraintName, ReuseFactory.getInteger(5), null, null, null, null, ReuseFactory.getInteger(2), ReuseFactory.getInteger(4), this.getContextManager());
            }
        }
        this.jj_la1[293] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode dropTableStatement() throws ParseException, StandardException {
        this.jj_consume_token(232);
        TableName tableName = this.qualifiedName(128);
        return (StatementNode)this.nodeFactory.getNode(91, tableName, new Integer(2), this.getContextManager());
    }

    public final StatementNode dropIndexStatement() throws ParseException, StandardException {
        this.jj_consume_token(371);
        TableName indexName = this.qualifiedName(128);
        return (StatementNode)this.nodeFactory.getNode(63, indexName, this.getContextManager());
    }

    public final StatementNode dropAliasStatement() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 204: {
                this.jj_consume_token(204);
                TableName aliasName = this.qualifiedName(128);
                return this.dropAliasNode(aliasName, 'P');
            }
            case 142: {
                this.jj_consume_token(142);
                TableName aliasName = this.qualifiedName(128);
                return this.dropAliasNode(aliasName, 'F');
            }
            case 329: {
                this.jj_consume_token(329);
                TableName aliasName = this.qualifiedName(128);
                this.checkVersion(130, "DROP SYNONYM");
                return this.dropAliasNode(aliasName, 'S');
            }
        }
        this.jj_la1[294] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode dropViewStatement() throws ParseException, StandardException {
        this.jj_consume_token(256);
        TableName viewName = this.qualifiedName(128);
        return (StatementNode)this.nodeFactory.getNode(92, viewName, this.getContextManager());
    }

    public final StatementNode dropTriggerStatement() throws ParseException, StandardException {
        this.jj_consume_token(410);
        TableName triggerName = this.qualifiedName(128);
        return (StatementNode)this.nodeFactory.getNode(65, triggerName, this.getContextManager());
    }

    public final StatementNode truncateTableStatement() throws ParseException, StandardException {
        this.jj_consume_token(335);
        this.jj_consume_token(232);
        TableName tableName = this.qualifiedName(128);
        return (StatementNode)this.nodeFactory.getNode(114, tableName, this.getContextManager());
    }

    public final StatementNode grantStatement() throws ParseException, StandardException {
        StatementNode node;
        this.jj_consume_token(147);
        this.checkVersion(140, "GRANT");
        this.checkSqlStandardAccess("GRANT");
        switch (this.jj_nt.kind) {
            case 60: 
            case 115: 
            case 159: 
            case 208: 
            case 218: 
            case 247: 
            case 410: {
                node = this.tableGrantStatement();
                break;
            }
            case 130: {
                node = this.routineGrantStatement();
                break;
            }
            default: {
                this.jj_la1[295] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return node;
    }

    public final StatementNode tableGrantStatement() throws ParseException, StandardException {
        PrivilegeNode privileges = this.tablePrivileges();
        this.jj_consume_token(236);
        List grantees = this.granteeList();
        return (StatementNode)this.nodeFactory.getNode(89, privileges, grantees, this.getContextManager());
    }

    public final PrivilegeNode tablePrivileges() throws ParseException, StandardException {
        TablePrivilegesNode tablePrivilegesNode = null;
        TableName objectName = null;
        tablePrivilegesNode = this.tableActions();
        this.jj_consume_token(188);
        switch (this.jj_nt.kind) {
            case 232: {
                this.jj_consume_token(232);
                break;
            }
            default: {
                this.jj_la1[296] = this.jj_gen;
            }
        }
        objectName = this.qualifiedName(128);
        return (PrivilegeNode)this.nodeFactory.getNode(103, ReuseFactory.getInteger(0), objectName, tablePrivilegesNode, this.getContextManager());
    }

    public final TablePrivilegesNode tableActions() throws ParseException, StandardException {
        TablePrivilegesNode tableActionsNode = (TablePrivilegesNode)this.nodeFactory.getNode(106, this.getContextManager());
        switch (this.jj_nt.kind) {
            case 60: {
                this.jj_consume_token(60);
                this.jj_consume_token(203);
                tableActionsNode.addAll();
                return tableActionsNode;
            }
            case 115: 
            case 159: 
            case 208: 
            case 218: 
            case 247: 
            case 410: {
                this.tableAction(tableActionsNode);
                block7: while (true) {
                    switch (this.jj_nt.kind) {
                        case 424: {
                            break;
                        }
                        default: {
                            this.jj_la1[297] = this.jj_gen;
                            break block7;
                        }
                    }
                    this.jj_consume_token(424);
                    this.tableAction(tableActionsNode);
                }
                return tableActionsNode;
            }
        }
        this.jj_la1[298] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final StatementNode routineGrantStatement() throws ParseException, StandardException {
        this.jj_consume_token(130);
        this.jj_consume_token(188);
        RoutineDesignator routine = this.routineDesignator();
        this.jj_consume_token(236);
        List grantees = this.granteeList();
        PrivilegeNode routinePrivilege = (PrivilegeNode)this.nodeFactory.getNode(103, ReuseFactory.getInteger(1), routine, null, this.getContextManager());
        return (StatementNode)this.nodeFactory.getNode(89, routinePrivilege, grantees, this.getContextManager());
    }

    public final RoutineDesignator routineDesignator() throws ParseException, StandardException {
        Token procOrFunction;
        Object routine = null;
        TableName name = null;
        List paramTypeList = null;
        switch (this.jj_nt.kind) {
            case 142: {
                procOrFunction = this.jj_consume_token(142);
                break;
            }
            case 204: {
                procOrFunction = this.jj_consume_token(204);
                break;
            }
            default: {
                this.jj_la1[299] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        name = this.qualifiedName(128);
        switch (this.jj_nt.kind) {
            case 420: {
                this.jj_consume_token(420);
                paramTypeList = this.parameterTypeList();
                this.jj_consume_token(421);
                break;
            }
            default: {
                this.jj_la1[300] = this.jj_gen;
            }
        }
        return new RoutineDesignator(false, name, procOrFunction.kind == 142, paramTypeList);
    }

    public final List parameterTypeList() throws ParseException, StandardException {
        ArrayList<DataTypeDescriptor> list = new ArrayList<DataTypeDescriptor>();
        if (this.jj_2_52(1)) {
            DataTypeDescriptor dtd = this.dataTypeCommon();
            list.add(dtd);
            block3: while (true) {
                switch (this.jj_nt.kind) {
                    case 424: {
                        break;
                    }
                    default: {
                        this.jj_la1[301] = this.jj_gen;
                        break block3;
                    }
                }
                this.jj_consume_token(424);
                dtd = this.dataTypeCommon();
                list.add(dtd);
            }
        }
        return list;
    }

    public final void tableAction(TablePrivilegesNode tablePrivilegesNode) throws ParseException, StandardException {
        ResultColumnList columnList = null;
        switch (this.jj_nt.kind) {
            case 218: {
                this.jj_consume_token(218);
                switch (this.jj_nt.kind) {
                    case 420: {
                        columnList = this.privilegeColumnList();
                        break;
                    }
                    default: {
                        this.jj_la1[302] = this.jj_gen;
                    }
                }
                tablePrivilegesNode.addAction(0, columnList);
                break;
            }
            case 115: {
                this.jj_consume_token(115);
                tablePrivilegesNode.addAction(1, null);
                break;
            }
            case 159: {
                this.jj_consume_token(159);
                tablePrivilegesNode.addAction(2, null);
                break;
            }
            case 247: {
                this.jj_consume_token(247);
                switch (this.jj_nt.kind) {
                    case 420: {
                        columnList = this.privilegeColumnList();
                        break;
                    }
                    default: {
                        this.jj_la1[303] = this.jj_gen;
                    }
                }
                tablePrivilegesNode.addAction(3, columnList);
                break;
            }
            case 208: {
                this.jj_consume_token(208);
                switch (this.jj_nt.kind) {
                    case 420: {
                        columnList = this.privilegeColumnList();
                        break;
                    }
                    default: {
                        this.jj_la1[304] = this.jj_gen;
                    }
                }
                tablePrivilegesNode.addAction(4, columnList);
                break;
            }
            case 410: {
                this.jj_consume_token(410);
                tablePrivilegesNode.addAction(5, null);
                break;
            }
            default: {
                this.jj_la1[305] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final ResultColumnList privilegeColumnList() throws ParseException, StandardException {
        ResultColumnList cl = (ResultColumnList)this.nodeFactory.getNode(9, this.getContextManager());
        this.jj_consume_token(420);
        this.columnNameList(cl);
        this.jj_consume_token(421);
        return cl;
    }

    public final List granteeList() throws ParseException, StandardException {
        ArrayList list = new ArrayList();
        this.grantee(list);
        block3: while (true) {
            switch (this.jj_nt.kind) {
                case 424: {
                    break;
                }
                default: {
                    this.jj_la1[306] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(424);
            this.grantee(list);
        }
        return list;
    }

    public final void grantee(List list) throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 74: 
            case 87: 
            case 99: 
            case 107: 
            case 177: 
            case 231: 
            case 243: 
            case 251: 
            case 253: 
            case 263: 
            case 264: 
            case 265: 
            case 266: 
            case 267: 
            case 268: 
            case 269: 
            case 270: 
            case 271: 
            case 272: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 277: 
            case 279: 
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 284: 
            case 286: 
            case 288: 
            case 289: 
            case 290: 
            case 291: 
            case 292: 
            case 293: 
            case 294: 
            case 295: 
            case 296: 
            case 297: 
            case 298: 
            case 299: 
            case 300: 
            case 301: 
            case 302: 
            case 303: 
            case 304: 
            case 305: 
            case 306: 
            case 307: 
            case 308: 
            case 309: 
            case 310: 
            case 311: 
            case 312: 
            case 313: 
            case 314: 
            case 315: 
            case 317: 
            case 318: 
            case 319: 
            case 320: 
            case 321: 
            case 322: 
            case 323: 
            case 324: 
            case 325: 
            case 326: 
            case 327: 
            case 328: 
            case 329: 
            case 330: 
            case 331: 
            case 332: 
            case 333: 
            case 334: 
            case 335: 
            case 336: 
            case 337: 
            case 338: 
            case 339: 
            case 342: 
            case 343: 
            case 344: 
            case 348: 
            case 357: 
            case 358: 
            case 359: 
            case 360: 
            case 361: 
            case 362: 
            case 364: 
            case 365: 
            case 366: 
            case 367: 
            case 368: 
            case 369: 
            case 370: 
            case 371: 
            case 372: 
            case 373: 
            case 374: 
            case 375: 
            case 376: 
            case 377: 
            case 378: 
            case 379: 
            case 380: 
            case 382: 
            case 383: 
            case 384: 
            case 385: 
            case 387: 
            case 388: 
            case 389: 
            case 390: 
            case 391: 
            case 392: 
            case 393: 
            case 394: 
            case 395: 
            case 396: 
            case 397: 
            case 398: 
            case 399: 
            case 400: 
            case 401: 
            case 402: 
            case 403: 
            case 404: 
            case 405: 
            case 406: 
            case 407: 
            case 408: 
            case 409: 
            case 410: 
            case 411: 
            case 412: 
            case 413: 
            case 445: 
            case 451: {
                String str = this.identifier(128, true);
                this.checkAuthorizationLength(str);
                list.add(str);
                break;
            }
            case 205: {
                this.jj_consume_token(205);
                list.add("PUBLIC");
                break;
            }
            default: {
                this.jj_la1[307] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final StatementNode revokeStatement() throws ParseException, StandardException {
        StatementNode node;
        this.jj_consume_token(211);
        this.checkVersion(140, "REVOKE");
        this.checkSqlStandardAccess("REVOKE");
        switch (this.jj_nt.kind) {
            case 60: 
            case 115: 
            case 159: 
            case 208: 
            case 218: 
            case 247: 
            case 410: {
                node = this.tableRevokeStatement();
                break;
            }
            case 130: {
                node = this.routineRevokeStatement();
                break;
            }
            default: {
                this.jj_la1[308] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return node;
    }

    public final StatementNode tableRevokeStatement() throws ParseException, StandardException {
        PrivilegeNode privileges = null;
        privileges = this.tablePrivileges();
        this.jj_consume_token(140);
        List grantees = this.granteeList();
        return (StatementNode)this.nodeFactory.getNode(86, privileges, grantees, this.getContextManager());
    }

    public final StatementNode routineRevokeStatement() throws ParseException, StandardException {
        RoutineDesignator routine = null;
        this.jj_consume_token(130);
        this.jj_consume_token(188);
        routine = this.routineDesignator();
        this.jj_consume_token(140);
        List grantees = this.granteeList();
        this.jj_consume_token(210);
        PrivilegeNode routinePrivilege = (PrivilegeNode)this.nodeFactory.getNode(103, ReuseFactory.getInteger(1), routine, null, this.getContextManager());
        return (StatementNode)this.nodeFactory.getNode(86, routinePrivilege, grantees, this.getContextManager());
    }

    public final String internalIdentifier(int id_length_limit, boolean checkLength) throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 445: {
                Token tok = this.jj_consume_token(445);
                String str = StringUtil.SQLToUpperCase(tok.image);
                if (checkLength) {
                    this.checkIdentifierLengthLimit(str, id_length_limit);
                }
                this.nextToLastTokenDelimitedIdentifier = this.lastTokenDelimitedIdentifier;
                this.lastTokenDelimitedIdentifier = Boolean.FALSE;
                this.nextToLastIdentifierToken = this.lastIdentifierToken;
                this.lastIdentifierToken = tok;
                return str;
            }
            case 451: {
                String str = this.delimitedIdentifier();
                if (checkLength) {
                    this.checkIdentifierLengthLimit(str, id_length_limit);
                }
                return str;
            }
            case 74: 
            case 87: 
            case 99: 
            case 107: 
            case 177: 
            case 231: 
            case 243: 
            case 251: 
            case 253: 
            case 263: 
            case 264: 
            case 265: 
            case 266: 
            case 267: 
            case 268: 
            case 269: 
            case 270: 
            case 271: 
            case 272: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 277: 
            case 279: 
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 284: 
            case 286: 
            case 288: 
            case 289: 
            case 290: 
            case 291: 
            case 292: 
            case 293: 
            case 294: 
            case 295: 
            case 296: 
            case 297: 
            case 298: 
            case 299: 
            case 300: 
            case 301: 
            case 302: 
            case 303: 
            case 304: 
            case 305: 
            case 306: 
            case 307: 
            case 308: 
            case 309: 
            case 310: 
            case 311: 
            case 312: 
            case 313: 
            case 314: 
            case 315: 
            case 317: 
            case 318: 
            case 319: 
            case 320: 
            case 321: 
            case 322: 
            case 323: 
            case 324: 
            case 325: 
            case 326: 
            case 327: 
            case 328: 
            case 329: 
            case 330: 
            case 331: 
            case 332: 
            case 333: 
            case 334: 
            case 335: 
            case 336: 
            case 337: 
            case 338: 
            case 339: 
            case 342: 
            case 343: 
            case 344: 
            case 348: 
            case 357: 
            case 358: 
            case 359: 
            case 360: 
            case 361: 
            case 362: 
            case 364: 
            case 365: 
            case 366: 
            case 367: 
            case 368: 
            case 369: 
            case 370: 
            case 371: 
            case 372: 
            case 373: 
            case 374: 
            case 375: 
            case 376: 
            case 377: 
            case 378: 
            case 379: 
            case 380: 
            case 382: 
            case 383: 
            case 384: 
            case 385: 
            case 387: 
            case 388: 
            case 389: 
            case 390: 
            case 391: 
            case 392: 
            case 393: 
            case 394: 
            case 395: 
            case 396: 
            case 397: 
            case 398: 
            case 399: 
            case 400: 
            case 401: 
            case 402: 
            case 403: 
            case 404: 
            case 405: 
            case 406: 
            case 407: 
            case 408: 
            case 409: 
            case 410: 
            case 411: 
            case 412: 
            case 413: {
                String str = this.nonReservedKeyword();
                return StringUtil.SQLToUpperCase(str);
            }
        }
        this.jj_la1[309] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String identifier(int id_length_limit, boolean checkLength) throws ParseException, StandardException {
        String id = this.internalIdentifier(id_length_limit, checkLength);
        return id;
    }

    public final String delimitedIdentifier() throws ParseException {
        Token tok = this.jj_consume_token(451);
        String str = tok.image.substring(1, tok.image.length() - 1);
        str = SQLParser.normalizeDelimitedID(str);
        this.nextToLastTokenDelimitedIdentifier = this.lastTokenDelimitedIdentifier;
        this.lastTokenDelimitedIdentifier = Boolean.TRUE;
        this.nextToLastIdentifierToken = this.lastIdentifierToken;
        this.lastIdentifierToken = tok;
        return str;
    }

    public final String reservedKeyword() throws ParseException {
        Token tok;
        switch (this.jj_nt.kind) {
            case 59: {
                tok = this.jj_consume_token(59);
                break;
            }
            case 60: {
                tok = this.jj_consume_token(60);
                break;
            }
            case 61: {
                tok = this.jj_consume_token(61);
                break;
            }
            case 62: {
                tok = this.jj_consume_token(62);
                break;
            }
            case 63: {
                tok = this.jj_consume_token(63);
                break;
            }
            case 64: {
                tok = this.jj_consume_token(64);
                break;
            }
            case 65: {
                tok = this.jj_consume_token(65);
                break;
            }
            case 66: {
                tok = this.jj_consume_token(66);
                break;
            }
            case 67: {
                tok = this.jj_consume_token(67);
                break;
            }
            case 68: {
                tok = this.jj_consume_token(68);
                break;
            }
            case 69: {
                tok = this.jj_consume_token(69);
                break;
            }
            case 70: {
                tok = this.jj_consume_token(70);
                break;
            }
            case 71: {
                tok = this.jj_consume_token(71);
                break;
            }
            case 72: {
                tok = this.jj_consume_token(72);
                break;
            }
            case 73: {
                tok = this.jj_consume_token(73);
                break;
            }
            case 75: {
                tok = this.jj_consume_token(75);
                break;
            }
            case 76: {
                tok = this.jj_consume_token(76);
                break;
            }
            case 77: {
                tok = this.jj_consume_token(77);
                break;
            }
            case 78: {
                tok = this.jj_consume_token(78);
                break;
            }
            case 79: {
                tok = this.jj_consume_token(79);
                break;
            }
            case 80: {
                tok = this.jj_consume_token(80);
                break;
            }
            case 81: {
                tok = this.jj_consume_token(81);
                break;
            }
            case 82: {
                tok = this.jj_consume_token(82);
                break;
            }
            case 83: {
                tok = this.jj_consume_token(83);
                break;
            }
            case 85: {
                tok = this.jj_consume_token(85);
                break;
            }
            case 86: {
                tok = this.jj_consume_token(86);
                break;
            }
            case 88: {
                tok = this.jj_consume_token(88);
                break;
            }
            case 89: {
                tok = this.jj_consume_token(89);
                break;
            }
            case 90: {
                tok = this.jj_consume_token(90);
                break;
            }
            case 91: {
                tok = this.jj_consume_token(91);
                break;
            }
            case 92: {
                tok = this.jj_consume_token(92);
                break;
            }
            case 93: {
                tok = this.jj_consume_token(93);
                break;
            }
            case 94: {
                tok = this.jj_consume_token(94);
                break;
            }
            case 95: {
                tok = this.jj_consume_token(95);
                break;
            }
            case 96: {
                tok = this.jj_consume_token(96);
                break;
            }
            case 97: {
                tok = this.jj_consume_token(97);
                break;
            }
            case 98: {
                tok = this.jj_consume_token(98);
                break;
            }
            case 100: {
                tok = this.jj_consume_token(100);
                break;
            }
            case 101: {
                tok = this.jj_consume_token(101);
                break;
            }
            case 102: {
                tok = this.jj_consume_token(102);
                break;
            }
            case 103: {
                tok = this.jj_consume_token(103);
                break;
            }
            case 104: {
                tok = this.jj_consume_token(104);
                break;
            }
            case 105: {
                tok = this.jj_consume_token(105);
                break;
            }
            case 106: {
                tok = this.jj_consume_token(106);
                break;
            }
            case 108: {
                tok = this.jj_consume_token(108);
                break;
            }
            case 109: {
                tok = this.jj_consume_token(109);
                break;
            }
            case 110: {
                tok = this.jj_consume_token(110);
                break;
            }
            case 111: {
                tok = this.jj_consume_token(111);
                break;
            }
            case 112: {
                tok = this.jj_consume_token(112);
                break;
            }
            case 113: {
                tok = this.jj_consume_token(113);
                break;
            }
            case 114: {
                tok = this.jj_consume_token(114);
                break;
            }
            case 115: {
                tok = this.jj_consume_token(115);
                break;
            }
            case 116: {
                tok = this.jj_consume_token(116);
                break;
            }
            case 117: {
                tok = this.jj_consume_token(117);
                break;
            }
            case 118: {
                tok = this.jj_consume_token(118);
                break;
            }
            case 119: {
                tok = this.jj_consume_token(119);
                break;
            }
            case 120: {
                tok = this.jj_consume_token(120);
                break;
            }
            case 121: {
                tok = this.jj_consume_token(121);
                break;
            }
            case 122: {
                tok = this.jj_consume_token(122);
                break;
            }
            case 123: {
                tok = this.jj_consume_token(123);
                break;
            }
            case 124: {
                tok = this.jj_consume_token(124);
                break;
            }
            case 125: {
                tok = this.jj_consume_token(125);
                break;
            }
            case 126: {
                tok = this.jj_consume_token(126);
                break;
            }
            case 127: {
                tok = this.jj_consume_token(127);
                break;
            }
            case 128: {
                tok = this.jj_consume_token(128);
                break;
            }
            case 129: {
                tok = this.jj_consume_token(129);
                break;
            }
            case 130: {
                tok = this.jj_consume_token(130);
                break;
            }
            case 131: {
                tok = this.jj_consume_token(131);
                break;
            }
            case 132: {
                tok = this.jj_consume_token(132);
                break;
            }
            case 133: {
                tok = this.jj_consume_token(133);
                break;
            }
            case 134: {
                tok = this.jj_consume_token(134);
                break;
            }
            case 135: {
                tok = this.jj_consume_token(135);
                break;
            }
            case 136: {
                tok = this.jj_consume_token(136);
                break;
            }
            case 137: {
                tok = this.jj_consume_token(137);
                break;
            }
            case 138: {
                tok = this.jj_consume_token(138);
                break;
            }
            case 139: {
                tok = this.jj_consume_token(139);
                break;
            }
            case 140: {
                tok = this.jj_consume_token(140);
                break;
            }
            case 141: {
                tok = this.jj_consume_token(141);
                break;
            }
            case 142: {
                tok = this.jj_consume_token(142);
                break;
            }
            case 143: {
                tok = this.jj_consume_token(143);
                break;
            }
            case 345: {
                tok = this.jj_consume_token(345);
                break;
            }
            case 144: {
                tok = this.jj_consume_token(144);
                break;
            }
            case 145: {
                tok = this.jj_consume_token(145);
                break;
            }
            case 146: {
                tok = this.jj_consume_token(146);
                break;
            }
            case 147: {
                tok = this.jj_consume_token(147);
                break;
            }
            case 148: {
                tok = this.jj_consume_token(148);
                break;
            }
            case 149: {
                tok = this.jj_consume_token(149);
                break;
            }
            case 150: {
                tok = this.jj_consume_token(150);
                break;
            }
            case 151: {
                tok = this.jj_consume_token(151);
                break;
            }
            case 152: {
                tok = this.jj_consume_token(152);
                break;
            }
            case 153: {
                tok = this.jj_consume_token(153);
                break;
            }
            case 154: {
                tok = this.jj_consume_token(154);
                break;
            }
            case 155: {
                tok = this.jj_consume_token(155);
                break;
            }
            case 156: {
                tok = this.jj_consume_token(156);
                break;
            }
            case 285: {
                tok = this.jj_consume_token(285);
                break;
            }
            case 157: {
                tok = this.jj_consume_token(157);
                break;
            }
            case 158: {
                tok = this.jj_consume_token(158);
                break;
            }
            case 159: {
                tok = this.jj_consume_token(159);
                break;
            }
            case 160: {
                tok = this.jj_consume_token(160);
                break;
            }
            case 161: {
                tok = this.jj_consume_token(161);
                break;
            }
            case 162: {
                tok = this.jj_consume_token(162);
                break;
            }
            case 163: {
                tok = this.jj_consume_token(163);
                break;
            }
            case 164: {
                tok = this.jj_consume_token(164);
                break;
            }
            case 165: {
                tok = this.jj_consume_token(165);
                break;
            }
            case 166: {
                tok = this.jj_consume_token(166);
                break;
            }
            case 167: {
                tok = this.jj_consume_token(167);
                break;
            }
            case 168: {
                tok = this.jj_consume_token(168);
                break;
            }
            case 169: {
                tok = this.jj_consume_token(169);
                break;
            }
            case 170: {
                tok = this.jj_consume_token(170);
                break;
            }
            case 171: {
                tok = this.jj_consume_token(171);
                break;
            }
            case 172: {
                tok = this.jj_consume_token(172);
                break;
            }
            case 173: {
                tok = this.jj_consume_token(173);
                break;
            }
            case 174: {
                tok = this.jj_consume_token(174);
                break;
            }
            case 175: {
                tok = this.jj_consume_token(175);
                break;
            }
            case 176: {
                tok = this.jj_consume_token(176);
                break;
            }
            case 178: {
                tok = this.jj_consume_token(178);
                break;
            }
            case 179: {
                tok = this.jj_consume_token(179);
                break;
            }
            case 180: {
                tok = this.jj_consume_token(180);
                break;
            }
            case 381: {
                tok = this.jj_consume_token(381);
                break;
            }
            case 181: {
                tok = this.jj_consume_token(181);
                break;
            }
            case 182: {
                tok = this.jj_consume_token(182);
                break;
            }
            case 183: {
                tok = this.jj_consume_token(183);
                break;
            }
            case 184: {
                tok = this.jj_consume_token(184);
                break;
            }
            case 185: {
                tok = this.jj_consume_token(185);
                break;
            }
            case 186: {
                tok = this.jj_consume_token(186);
                break;
            }
            case 187: {
                tok = this.jj_consume_token(187);
                break;
            }
            case 188: {
                tok = this.jj_consume_token(188);
                break;
            }
            case 189: {
                tok = this.jj_consume_token(189);
                break;
            }
            case 190: {
                tok = this.jj_consume_token(190);
                break;
            }
            case 191: {
                tok = this.jj_consume_token(191);
                break;
            }
            case 192: {
                tok = this.jj_consume_token(192);
                break;
            }
            case 193: {
                tok = this.jj_consume_token(193);
                break;
            }
            case 386: {
                tok = this.jj_consume_token(386);
                break;
            }
            case 194: {
                tok = this.jj_consume_token(194);
                break;
            }
            case 195: {
                tok = this.jj_consume_token(195);
                break;
            }
            case 196: {
                tok = this.jj_consume_token(196);
                break;
            }
            case 197: {
                tok = this.jj_consume_token(197);
                break;
            }
            case 198: {
                tok = this.jj_consume_token(198);
                break;
            }
            case 199: {
                tok = this.jj_consume_token(199);
                break;
            }
            case 200: {
                tok = this.jj_consume_token(200);
                break;
            }
            case 201: {
                tok = this.jj_consume_token(201);
                break;
            }
            case 202: {
                tok = this.jj_consume_token(202);
                break;
            }
            case 203: {
                tok = this.jj_consume_token(203);
                break;
            }
            case 204: {
                tok = this.jj_consume_token(204);
                break;
            }
            case 205: {
                tok = this.jj_consume_token(205);
                break;
            }
            case 206: {
                tok = this.jj_consume_token(206);
                break;
            }
            case 207: {
                tok = this.jj_consume_token(207);
                break;
            }
            case 208: {
                tok = this.jj_consume_token(208);
                break;
            }
            case 209: {
                tok = this.jj_consume_token(209);
                break;
            }
            case 210: {
                tok = this.jj_consume_token(210);
                break;
            }
            case 211: {
                tok = this.jj_consume_token(211);
                break;
            }
            case 212: {
                tok = this.jj_consume_token(212);
                break;
            }
            case 213: {
                tok = this.jj_consume_token(213);
                break;
            }
            case 214: {
                tok = this.jj_consume_token(214);
                break;
            }
            case 215: {
                tok = this.jj_consume_token(215);
                break;
            }
            case 216: {
                tok = this.jj_consume_token(216);
                break;
            }
            case 217: {
                tok = this.jj_consume_token(217);
                break;
            }
            case 218: {
                tok = this.jj_consume_token(218);
                break;
            }
            case 219: {
                tok = this.jj_consume_token(219);
                break;
            }
            case 220: {
                tok = this.jj_consume_token(220);
                break;
            }
            case 221: {
                tok = this.jj_consume_token(221);
                break;
            }
            case 222: {
                tok = this.jj_consume_token(222);
                break;
            }
            case 223: {
                tok = this.jj_consume_token(223);
                break;
            }
            case 224: {
                tok = this.jj_consume_token(224);
                break;
            }
            case 225: {
                tok = this.jj_consume_token(225);
                break;
            }
            case 226: {
                tok = this.jj_consume_token(226);
                break;
            }
            case 227: {
                tok = this.jj_consume_token(227);
                break;
            }
            case 228: {
                tok = this.jj_consume_token(228);
                break;
            }
            case 229: {
                tok = this.jj_consume_token(229);
                break;
            }
            case 230: {
                tok = this.jj_consume_token(230);
                break;
            }
            case 232: {
                tok = this.jj_consume_token(232);
                break;
            }
            case 233: {
                tok = this.jj_consume_token(233);
                break;
            }
            case 234: {
                tok = this.jj_consume_token(234);
                break;
            }
            case 235: {
                tok = this.jj_consume_token(235);
                break;
            }
            case 236: {
                tok = this.jj_consume_token(236);
                break;
            }
            case 240: {
                tok = this.jj_consume_token(240);
                break;
            }
            case 237: {
                tok = this.jj_consume_token(237);
                break;
            }
            case 238: {
                tok = this.jj_consume_token(238);
                break;
            }
            case 239: {
                tok = this.jj_consume_token(239);
                break;
            }
            case 242: {
                tok = this.jj_consume_token(242);
                break;
            }
            case 244: {
                tok = this.jj_consume_token(244);
                break;
            }
            case 245: {
                tok = this.jj_consume_token(245);
                break;
            }
            case 246: {
                tok = this.jj_consume_token(246);
                break;
            }
            case 247: {
                tok = this.jj_consume_token(247);
                break;
            }
            case 248: {
                tok = this.jj_consume_token(248);
                break;
            }
            case 249: {
                tok = this.jj_consume_token(249);
                break;
            }
            case 250: {
                tok = this.jj_consume_token(250);
                break;
            }
            case 252: {
                tok = this.jj_consume_token(252);
                break;
            }
            case 254: {
                tok = this.jj_consume_token(254);
                break;
            }
            case 255: {
                tok = this.jj_consume_token(255);
                break;
            }
            case 256: {
                tok = this.jj_consume_token(256);
                break;
            }
            case 257: {
                tok = this.jj_consume_token(257);
                break;
            }
            case 258: {
                tok = this.jj_consume_token(258);
                break;
            }
            case 259: {
                tok = this.jj_consume_token(259);
                break;
            }
            case 260: {
                tok = this.jj_consume_token(260);
                break;
            }
            case 261: {
                tok = this.jj_consume_token(261);
                break;
            }
            case 262: {
                tok = this.jj_consume_token(262);
                break;
            }
            case 340: {
                tok = this.jj_consume_token(340);
                break;
            }
            case 341: {
                tok = this.jj_consume_token(341);
                break;
            }
            case 346: {
                tok = this.jj_consume_token(346);
                break;
            }
            case 347: {
                tok = this.jj_consume_token(347);
                break;
            }
            case 349: {
                tok = this.jj_consume_token(349);
                break;
            }
            case 350: {
                tok = this.jj_consume_token(350);
                break;
            }
            case 241: {
                tok = this.jj_consume_token(241);
                break;
            }
            case 351: {
                tok = this.jj_consume_token(351);
                break;
            }
            case 352: {
                tok = this.jj_consume_token(352);
                break;
            }
            case 354: {
                tok = this.jj_consume_token(354);
                break;
            }
            case 356: {
                tok = this.jj_consume_token(356);
                break;
            }
            case 353: {
                tok = this.jj_consume_token(353);
                break;
            }
            case 355: {
                tok = this.jj_consume_token(355);
                break;
            }
            default: {
                this.jj_la1[310] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.nextToLastTokenDelimitedIdentifier = this.lastTokenDelimitedIdentifier;
        this.lastTokenDelimitedIdentifier = Boolean.FALSE;
        return tok.image;
    }

    public final String nonReservedKeyword() throws ParseException {
        Token tok;
        switch (this.jj_nt.kind) {
            case 263: {
                tok = this.jj_consume_token(263);
                break;
            }
            case 264: {
                tok = this.jj_consume_token(264);
                break;
            }
            case 265: {
                tok = this.jj_consume_token(265);
                break;
            }
            case 357: {
                tok = this.jj_consume_token(357);
                break;
            }
            case 266: {
                tok = this.jj_consume_token(266);
                break;
            }
            case 358: {
                tok = this.jj_consume_token(358);
                break;
            }
            case 74: {
                tok = this.jj_consume_token(74);
                break;
            }
            case 267: {
                tok = this.jj_consume_token(267);
                break;
            }
            case 268: {
                tok = this.jj_consume_token(268);
                break;
            }
            case 269: {
                tok = this.jj_consume_token(269);
                break;
            }
            case 359: {
                tok = this.jj_consume_token(359);
                break;
            }
            case 270: {
                tok = this.jj_consume_token(270);
                break;
            }
            case 87: {
                tok = this.jj_consume_token(87);
                break;
            }
            case 271: {
                tok = this.jj_consume_token(271);
                break;
            }
            case 272: {
                tok = this.jj_consume_token(272);
                break;
            }
            case 360: {
                tok = this.jj_consume_token(360);
                break;
            }
            case 273: {
                tok = this.jj_consume_token(273);
                break;
            }
            case 274: {
                tok = this.jj_consume_token(274);
                break;
            }
            case 361: {
                tok = this.jj_consume_token(361);
                break;
            }
            case 99: {
                tok = this.jj_consume_token(99);
                break;
            }
            case 362: {
                tok = this.jj_consume_token(362);
                break;
            }
            case 342: {
                tok = this.jj_consume_token(342);
                break;
            }
            case 343: {
                tok = this.jj_consume_token(343);
                break;
            }
            case 107: {
                tok = this.jj_consume_token(107);
                break;
            }
            case 275: {
                tok = this.jj_consume_token(275);
                break;
            }
            case 276: {
                tok = this.jj_consume_token(276);
                break;
            }
            case 277: {
                tok = this.jj_consume_token(277);
                break;
            }
            case 365: {
                tok = this.jj_consume_token(365);
                break;
            }
            case 279: {
                tok = this.jj_consume_token(279);
                break;
            }
            case 344: {
                tok = this.jj_consume_token(344);
                break;
            }
            case 364: {
                tok = this.jj_consume_token(364);
                break;
            }
            case 366: {
                tok = this.jj_consume_token(366);
                break;
            }
            case 367: {
                tok = this.jj_consume_token(367);
                break;
            }
            case 368: {
                tok = this.jj_consume_token(368);
                break;
            }
            case 369: {
                tok = this.jj_consume_token(369);
                break;
            }
            case 370: {
                tok = this.jj_consume_token(370);
                break;
            }
            case 280: {
                tok = this.jj_consume_token(280);
                break;
            }
            case 281: {
                tok = this.jj_consume_token(281);
                break;
            }
            case 282: {
                tok = this.jj_consume_token(282);
                break;
            }
            case 283: {
                tok = this.jj_consume_token(283);
                break;
            }
            case 371: {
                tok = this.jj_consume_token(371);
                break;
            }
            case 284: {
                tok = this.jj_consume_token(284);
                break;
            }
            case 286: {
                tok = this.jj_consume_token(286);
                break;
            }
            case 372: {
                tok = this.jj_consume_token(372);
                break;
            }
            case 288: {
                tok = this.jj_consume_token(288);
                break;
            }
            case 289: {
                tok = this.jj_consume_token(289);
                break;
            }
            case 373: {
                tok = this.jj_consume_token(373);
                break;
            }
            case 290: {
                tok = this.jj_consume_token(290);
                break;
            }
            case 291: {
                tok = this.jj_consume_token(291);
                break;
            }
            case 374: {
                tok = this.jj_consume_token(374);
                break;
            }
            case 375: {
                tok = this.jj_consume_token(375);
                break;
            }
            case 292: {
                tok = this.jj_consume_token(292);
                break;
            }
            case 293: {
                tok = this.jj_consume_token(293);
                break;
            }
            case 294: {
                tok = this.jj_consume_token(294);
                break;
            }
            case 348: {
                tok = this.jj_consume_token(348);
                break;
            }
            case 376: {
                tok = this.jj_consume_token(376);
                break;
            }
            case 377: {
                tok = this.jj_consume_token(377);
                break;
            }
            case 295: {
                tok = this.jj_consume_token(295);
                break;
            }
            case 378: {
                tok = this.jj_consume_token(378);
                break;
            }
            case 296: {
                tok = this.jj_consume_token(296);
                break;
            }
            case 297: {
                tok = this.jj_consume_token(297);
                break;
            }
            case 177: {
                tok = this.jj_consume_token(177);
                break;
            }
            case 298: {
                tok = this.jj_consume_token(298);
                break;
            }
            case 299: {
                tok = this.jj_consume_token(299);
                break;
            }
            case 300: {
                tok = this.jj_consume_token(300);
                break;
            }
            case 301: {
                tok = this.jj_consume_token(301);
                break;
            }
            case 302: {
                tok = this.jj_consume_token(302);
                break;
            }
            case 379: {
                tok = this.jj_consume_token(379);
                break;
            }
            case 380: {
                tok = this.jj_consume_token(380);
                break;
            }
            case 303: {
                tok = this.jj_consume_token(303);
                break;
            }
            case 304: {
                tok = this.jj_consume_token(304);
                break;
            }
            case 305: {
                tok = this.jj_consume_token(305);
                break;
            }
            case 383: {
                tok = this.jj_consume_token(383);
                break;
            }
            case 384: {
                tok = this.jj_consume_token(384);
                break;
            }
            case 385: {
                tok = this.jj_consume_token(385);
                break;
            }
            case 382: {
                tok = this.jj_consume_token(382);
                break;
            }
            case 306: {
                tok = this.jj_consume_token(306);
                break;
            }
            case 388: {
                tok = this.jj_consume_token(388);
                break;
            }
            case 307: {
                tok = this.jj_consume_token(307);
                break;
            }
            case 308: {
                tok = this.jj_consume_token(308);
                break;
            }
            case 389: {
                tok = this.jj_consume_token(389);
                break;
            }
            case 390: {
                tok = this.jj_consume_token(390);
                break;
            }
            case 391: {
                tok = this.jj_consume_token(391);
                break;
            }
            case 309: {
                tok = this.jj_consume_token(309);
                break;
            }
            case 393: {
                tok = this.jj_consume_token(393);
                break;
            }
            case 310: {
                tok = this.jj_consume_token(310);
                break;
            }
            case 392: {
                tok = this.jj_consume_token(392);
                break;
            }
            case 394: {
                tok = this.jj_consume_token(394);
                break;
            }
            case 311: {
                tok = this.jj_consume_token(311);
                break;
            }
            case 395: {
                tok = this.jj_consume_token(395);
                break;
            }
            case 396: {
                tok = this.jj_consume_token(396);
                break;
            }
            case 397: {
                tok = this.jj_consume_token(397);
                break;
            }
            case 312: {
                tok = this.jj_consume_token(312);
                break;
            }
            case 313: {
                tok = this.jj_consume_token(313);
                break;
            }
            case 398: {
                tok = this.jj_consume_token(398);
                break;
            }
            case 399: {
                tok = this.jj_consume_token(399);
                break;
            }
            case 315: {
                tok = this.jj_consume_token(315);
                break;
            }
            case 314: {
                tok = this.jj_consume_token(314);
                break;
            }
            case 400: {
                tok = this.jj_consume_token(400);
                break;
            }
            case 401: {
                tok = this.jj_consume_token(401);
                break;
            }
            case 317: {
                tok = this.jj_consume_token(317);
                break;
            }
            case 402: {
                tok = this.jj_consume_token(402);
                break;
            }
            case 403: {
                tok = this.jj_consume_token(403);
                break;
            }
            case 405: {
                tok = this.jj_consume_token(405);
                break;
            }
            case 404: {
                tok = this.jj_consume_token(404);
                break;
            }
            case 318: {
                tok = this.jj_consume_token(318);
                break;
            }
            case 319: {
                tok = this.jj_consume_token(319);
                break;
            }
            case 320: {
                tok = this.jj_consume_token(320);
                break;
            }
            case 321: {
                tok = this.jj_consume_token(321);
                break;
            }
            case 322: {
                tok = this.jj_consume_token(322);
                break;
            }
            case 323: {
                tok = this.jj_consume_token(323);
                break;
            }
            case 324: {
                tok = this.jj_consume_token(324);
                break;
            }
            case 325: {
                tok = this.jj_consume_token(325);
                break;
            }
            case 326: {
                tok = this.jj_consume_token(326);
                break;
            }
            case 406: {
                tok = this.jj_consume_token(406);
                break;
            }
            case 407: {
                tok = this.jj_consume_token(407);
                break;
            }
            case 327: {
                tok = this.jj_consume_token(327);
                break;
            }
            case 328: {
                tok = this.jj_consume_token(328);
                break;
            }
            case 408: {
                tok = this.jj_consume_token(408);
                break;
            }
            case 329: {
                tok = this.jj_consume_token(329);
                break;
            }
            case 409: {
                tok = this.jj_consume_token(409);
                break;
            }
            case 231: {
                tok = this.jj_consume_token(231);
                break;
            }
            case 330: {
                tok = this.jj_consume_token(330);
                break;
            }
            case 331: {
                tok = this.jj_consume_token(331);
                break;
            }
            case 332: {
                tok = this.jj_consume_token(332);
                break;
            }
            case 333: {
                tok = this.jj_consume_token(333);
                break;
            }
            case 334: {
                tok = this.jj_consume_token(334);
                break;
            }
            case 410: {
                tok = this.jj_consume_token(410);
                break;
            }
            case 335: {
                tok = this.jj_consume_token(335);
                break;
            }
            case 243: {
                tok = this.jj_consume_token(243);
                break;
            }
            case 336: {
                tok = this.jj_consume_token(336);
                break;
            }
            case 411: {
                tok = this.jj_consume_token(411);
                break;
            }
            case 337: {
                tok = this.jj_consume_token(337);
                break;
            }
            case 412: {
                tok = this.jj_consume_token(412);
                break;
            }
            case 338: {
                tok = this.jj_consume_token(338);
                break;
            }
            case 251: {
                tok = this.jj_consume_token(251);
                break;
            }
            case 253: {
                tok = this.jj_consume_token(253);
                break;
            }
            case 387: {
                tok = this.jj_consume_token(387);
                break;
            }
            case 339: {
                tok = this.jj_consume_token(339);
                break;
            }
            case 413: {
                tok = this.jj_consume_token(413);
                break;
            }
            default: {
                this.jj_la1[311] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.nextToLastTokenDelimitedIdentifier = this.lastTokenDelimitedIdentifier;
        this.lastTokenDelimitedIdentifier = Boolean.FALSE;
        this.nextToLastIdentifierToken = this.lastIdentifierToken;
        this.lastIdentifierToken = tok;
        return tok.image;
    }

    public final String caseSensitiveIdentifierPlusReservedWords() throws ParseException {
        switch (this.jj_nt.kind) {
            case 74: 
            case 87: 
            case 99: 
            case 107: 
            case 177: 
            case 231: 
            case 243: 
            case 251: 
            case 253: 
            case 263: 
            case 264: 
            case 265: 
            case 266: 
            case 267: 
            case 268: 
            case 269: 
            case 270: 
            case 271: 
            case 272: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 277: 
            case 279: 
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 284: 
            case 286: 
            case 288: 
            case 289: 
            case 290: 
            case 291: 
            case 292: 
            case 293: 
            case 294: 
            case 295: 
            case 296: 
            case 297: 
            case 298: 
            case 299: 
            case 300: 
            case 301: 
            case 302: 
            case 303: 
            case 304: 
            case 305: 
            case 306: 
            case 307: 
            case 308: 
            case 309: 
            case 310: 
            case 311: 
            case 312: 
            case 313: 
            case 314: 
            case 315: 
            case 317: 
            case 318: 
            case 319: 
            case 320: 
            case 321: 
            case 322: 
            case 323: 
            case 324: 
            case 325: 
            case 326: 
            case 327: 
            case 328: 
            case 329: 
            case 330: 
            case 331: 
            case 332: 
            case 333: 
            case 334: 
            case 335: 
            case 336: 
            case 337: 
            case 338: 
            case 339: 
            case 342: 
            case 343: 
            case 344: 
            case 348: 
            case 357: 
            case 358: 
            case 359: 
            case 360: 
            case 361: 
            case 362: 
            case 364: 
            case 365: 
            case 366: 
            case 367: 
            case 368: 
            case 369: 
            case 370: 
            case 371: 
            case 372: 
            case 373: 
            case 374: 
            case 375: 
            case 376: 
            case 377: 
            case 378: 
            case 379: 
            case 380: 
            case 382: 
            case 383: 
            case 384: 
            case 385: 
            case 387: 
            case 388: 
            case 389: 
            case 390: 
            case 391: 
            case 392: 
            case 393: 
            case 394: 
            case 395: 
            case 396: 
            case 397: 
            case 398: 
            case 399: 
            case 400: 
            case 401: 
            case 402: 
            case 403: 
            case 404: 
            case 405: 
            case 406: 
            case 407: 
            case 408: 
            case 409: 
            case 410: 
            case 411: 
            case 412: 
            case 413: 
            case 445: 
            case 451: {
                String str = this.caseSensitiveIdentifier();
                return str;
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 85: 
            case 86: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 206: 
            case 207: 
            case 208: 
            case 209: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 214: 
            case 215: 
            case 216: 
            case 217: 
            case 218: 
            case 219: 
            case 220: 
            case 221: 
            case 222: 
            case 223: 
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 228: 
            case 229: 
            case 230: 
            case 232: 
            case 233: 
            case 234: 
            case 235: 
            case 236: 
            case 237: 
            case 238: 
            case 239: 
            case 240: 
            case 241: 
            case 242: 
            case 244: 
            case 245: 
            case 246: 
            case 247: 
            case 248: 
            case 249: 
            case 250: 
            case 252: 
            case 254: 
            case 255: 
            case 256: 
            case 257: 
            case 258: 
            case 259: 
            case 260: 
            case 261: 
            case 262: 
            case 285: 
            case 340: 
            case 341: 
            case 345: 
            case 346: 
            case 347: 
            case 349: 
            case 350: 
            case 351: 
            case 352: 
            case 353: 
            case 354: 
            case 355: 
            case 356: 
            case 381: 
            case 386: {
                String str = this.reservedKeyword();
                return str;
            }
        }
        this.jj_la1[312] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String caseInsensitiveIdentifierPlusReservedWords() throws ParseException, StandardException {
        switch (this.jj_nt.kind) {
            case 74: 
            case 87: 
            case 99: 
            case 107: 
            case 177: 
            case 231: 
            case 243: 
            case 251: 
            case 253: 
            case 263: 
            case 264: 
            case 265: 
            case 266: 
            case 267: 
            case 268: 
            case 269: 
            case 270: 
            case 271: 
            case 272: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 277: 
            case 279: 
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 284: 
            case 286: 
            case 288: 
            case 289: 
            case 290: 
            case 291: 
            case 292: 
            case 293: 
            case 294: 
            case 295: 
            case 296: 
            case 297: 
            case 298: 
            case 299: 
            case 300: 
            case 301: 
            case 302: 
            case 303: 
            case 304: 
            case 305: 
            case 306: 
            case 307: 
            case 308: 
            case 309: 
            case 310: 
            case 311: 
            case 312: 
            case 313: 
            case 314: 
            case 315: 
            case 317: 
            case 318: 
            case 319: 
            case 320: 
            case 321: 
            case 322: 
            case 323: 
            case 324: 
            case 325: 
            case 326: 
            case 327: 
            case 328: 
            case 329: 
            case 330: 
            case 331: 
            case 332: 
            case 333: 
            case 334: 
            case 335: 
            case 336: 
            case 337: 
            case 338: 
            case 339: 
            case 342: 
            case 343: 
            case 344: 
            case 348: 
            case 357: 
            case 358: 
            case 359: 
            case 360: 
            case 361: 
            case 362: 
            case 364: 
            case 365: 
            case 366: 
            case 367: 
            case 368: 
            case 369: 
            case 370: 
            case 371: 
            case 372: 
            case 373: 
            case 374: 
            case 375: 
            case 376: 
            case 377: 
            case 378: 
            case 379: 
            case 380: 
            case 382: 
            case 383: 
            case 384: 
            case 385: 
            case 387: 
            case 388: 
            case 389: 
            case 390: 
            case 391: 
            case 392: 
            case 393: 
            case 394: 
            case 395: 
            case 396: 
            case 397: 
            case 398: 
            case 399: 
            case 400: 
            case 401: 
            case 402: 
            case 403: 
            case 404: 
            case 405: 
            case 406: 
            case 407: 
            case 408: 
            case 409: 
            case 410: 
            case 411: 
            case 412: 
            case 413: 
            case 445: 
            case 451: {
                String str = this.identifier(128, true);
                return str;
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 85: 
            case 86: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 146: 
            case 147: 
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 153: 
            case 154: 
            case 155: 
            case 156: 
            case 157: 
            case 158: 
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 167: 
            case 168: 
            case 169: 
            case 170: 
            case 171: 
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 178: 
            case 179: 
            case 180: 
            case 181: 
            case 182: 
            case 183: 
            case 184: 
            case 185: 
            case 186: 
            case 187: 
            case 188: 
            case 189: 
            case 190: 
            case 191: 
            case 192: 
            case 193: 
            case 194: 
            case 195: 
            case 196: 
            case 197: 
            case 198: 
            case 199: 
            case 200: 
            case 201: 
            case 202: 
            case 203: 
            case 204: 
            case 205: 
            case 206: 
            case 207: 
            case 208: 
            case 209: 
            case 210: 
            case 211: 
            case 212: 
            case 213: 
            case 214: 
            case 215: 
            case 216: 
            case 217: 
            case 218: 
            case 219: 
            case 220: 
            case 221: 
            case 222: 
            case 223: 
            case 224: 
            case 225: 
            case 226: 
            case 227: 
            case 228: 
            case 229: 
            case 230: 
            case 232: 
            case 233: 
            case 234: 
            case 235: 
            case 236: 
            case 237: 
            case 238: 
            case 239: 
            case 240: 
            case 241: 
            case 242: 
            case 244: 
            case 245: 
            case 246: 
            case 247: 
            case 248: 
            case 249: 
            case 250: 
            case 252: 
            case 254: 
            case 255: 
            case 256: 
            case 257: 
            case 258: 
            case 259: 
            case 260: 
            case 261: 
            case 262: 
            case 285: 
            case 340: 
            case 341: 
            case 345: 
            case 346: 
            case 347: 
            case 349: 
            case 350: 
            case 351: 
            case 352: 
            case 353: 
            case 354: 
            case 355: 
            case 356: 
            case 381: 
            case 386: {
                String str = this.reservedKeyword();
                return StringUtil.SQLToUpperCase(str);
            }
        }
        this.jj_la1[313] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String caseSensitiveIdentifier() throws ParseException {
        switch (this.jj_nt.kind) {
            case 445: {
                Token tok = this.jj_consume_token(445);
                this.nextToLastTokenDelimitedIdentifier = this.lastTokenDelimitedIdentifier;
                this.lastTokenDelimitedIdentifier = Boolean.FALSE;
                return tok.image;
            }
            case 451: {
                String str = this.delimitedIdentifier();
                return str;
            }
            case 74: 
            case 87: 
            case 99: 
            case 107: 
            case 177: 
            case 231: 
            case 243: 
            case 251: 
            case 253: 
            case 263: 
            case 264: 
            case 265: 
            case 266: 
            case 267: 
            case 268: 
            case 269: 
            case 270: 
            case 271: 
            case 272: 
            case 273: 
            case 274: 
            case 275: 
            case 276: 
            case 277: 
            case 279: 
            case 280: 
            case 281: 
            case 282: 
            case 283: 
            case 284: 
            case 286: 
            case 288: 
            case 289: 
            case 290: 
            case 291: 
            case 292: 
            case 293: 
            case 294: 
            case 295: 
            case 296: 
            case 297: 
            case 298: 
            case 299: 
            case 300: 
            case 301: 
            case 302: 
            case 303: 
            case 304: 
            case 305: 
            case 306: 
            case 307: 
            case 308: 
            case 309: 
            case 310: 
            case 311: 
            case 312: 
            case 313: 
            case 314: 
            case 315: 
            case 317: 
            case 318: 
            case 319: 
            case 320: 
            case 321: 
            case 322: 
            case 323: 
            case 324: 
            case 325: 
            case 326: 
            case 327: 
            case 328: 
            case 329: 
            case 330: 
            case 331: 
            case 332: 
            case 333: 
            case 334: 
            case 335: 
            case 336: 
            case 337: 
            case 338: 
            case 339: 
            case 342: 
            case 343: 
            case 344: 
            case 348: 
            case 357: 
            case 358: 
            case 359: 
            case 360: 
            case 361: 
            case 362: 
            case 364: 
            case 365: 
            case 366: 
            case 367: 
            case 368: 
            case 369: 
            case 370: 
            case 371: 
            case 372: 
            case 373: 
            case 374: 
            case 375: 
            case 376: 
            case 377: 
            case 378: 
            case 379: 
            case 380: 
            case 382: 
            case 383: 
            case 384: 
            case 385: 
            case 387: 
            case 388: 
            case 389: 
            case 390: 
            case 391: 
            case 392: 
            case 393: 
            case 394: 
            case 395: 
            case 396: 
            case 397: 
            case 398: 
            case 399: 
            case 400: 
            case 401: 
            case 402: 
            case 403: 
            case 404: 
            case 405: 
            case 406: 
            case 407: 
            case 408: 
            case 409: 
            case 410: 
            case 411: 
            case 412: 
            case 413: {
                String str = this.nonReservedKeyword();
                return str;
            }
        }
        this.jj_la1[314] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_8();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(7, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_9(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_9();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(8, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_10(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_10();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(9, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_11(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_11();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(10, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_12(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_12();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(11, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_13(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_13();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(12, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_14(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_14();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(13, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_15(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_15();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(14, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_16(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_16();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(15, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_17(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_17();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(16, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_18(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_18();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(17, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_19(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_19();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(18, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_20(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_20();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(19, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_21(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_21();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(20, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_22(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_22();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(21, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_23(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_23();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(22, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_24(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_24();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(23, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_25(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_25();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(24, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_26(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_26();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(25, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_27(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_27();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(26, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_28(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_28();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(27, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_29(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_29();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(28, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_30(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_30();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(29, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_31(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_31();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(30, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_32(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_32();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(31, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_33(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_33();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(32, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_34(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_34();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(33, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_35(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_35();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(34, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_36(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_36();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(35, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_37(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_37();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(36, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_38(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_38();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(37, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_39(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_39();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(38, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_40(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_40();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(39, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_41(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_41();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(40, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_42(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_42();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(41, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_43(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_43();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(42, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_44(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_44();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(43, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_45(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_45();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(44, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_46(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_46();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(45, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_47(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_47();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(46, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_48(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_48();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(47, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_49(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_49();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(48, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_50(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_50();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(49, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_51(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_51();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(50, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_52(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_52();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(51, xla);
        }
    }

    private final boolean jj_3R_144() {
        return this.jj_scan_token(101);
    }

    private final boolean jj_3R_271() {
        return this.jj_scan_token(285);
    }

    private final boolean jj_3R_270() {
        return this.jj_scan_token(386);
    }

    private final boolean jj_3R_216() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_269()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_270()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_271()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_269() {
        return this.jj_scan_token(153);
    }

    private final boolean jj_3R_143() {
        return this.jj_scan_token(103);
    }

    private final boolean jj_3R_249() {
        return this.jj_scan_token(282);
    }

    private final boolean jj_3R_68() {
        return this.jj_3R_120();
    }

    private final boolean jj_3R_161() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_216()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private final boolean jj_3R_248() {
        return this.jj_scan_token(295);
    }

    private final boolean jj_3R_142() {
        return this.jj_scan_token(101);
    }

    private final boolean jj_3R_195() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(82)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(83)) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_141() {
        return this.jj_scan_token(102);
    }

    private final boolean jj_3R_162() {
        return this.jj_3R_217();
    }

    private final boolean jj_3R_247() {
        return this.jj_scan_token(406);
    }

    private final boolean jj_3R_246() {
        return this.jj_scan_token(264);
    }

    private final boolean jj_3R_85() {
        if (this.jj_3R_161()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_162()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_163();
    }

    private final boolean jj_3R_73() {
        Token xsp = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.getToken((int)1).kind == 101 && this.getToken((int)2).kind == 276;
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_140()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_141()) {
                this.jj_scanpos = xsp;
                this.lookingAhead = true;
                this.jj_semLA = this.getToken((int)1).kind == 101 && this.getToken((int)2).kind == 331;
                this.lookingAhead = false;
                if (!this.jj_semLA || this.jj_3R_142()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_143()) {
                        this.jj_scanpos = xsp;
                        this.lookingAhead = true;
                        this.jj_semLA = this.getToken((int)1).kind == 101 && this.getToken((int)2).kind == 332;
                        this.lookingAhead = false;
                        if (!this.jj_semLA || this.jj_3R_144()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_145()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_140() {
        return this.jj_scan_token(101);
    }

    private final boolean jj_3R_206() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_245()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_246()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_247()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_248()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_249()) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_245() {
        return this.jj_scan_token(263);
    }

    private final boolean jj_3_45() {
        return this.jj_3R_85();
    }

    private final boolean jj_3R_109() {
        return this.jj_3R_195();
    }

    private final boolean jj_3R_214() {
        return this.jj_3R_217();
    }

    private final boolean jj_3_7() {
        return this.jj_3R_55();
    }

    private final boolean jj_3R_108() {
        return this.jj_scan_token(254);
    }

    private final boolean jj_3R_59() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_108()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_109()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_366() {
        return this.jj_scan_token(252);
    }

    private final boolean jj_3R_154() {
        return this.jj_3R_68();
    }

    private final boolean jj_3R_185() {
        return this.jj_3R_225();
    }

    private final boolean jj_3R_184() {
        return this.jj_3R_224();
    }

    private final boolean jj_3R_314() {
        return this.jj_scan_token(418);
    }

    private final boolean jj_3R_183() {
        return this.jj_3R_223();
    }

    private final boolean jj_3R_60() {
        return false;
    }

    private final boolean jj_3R_58() {
        return false;
    }

    private final boolean jj_3R_181() {
        return this.jj_3R_222();
    }

    private final boolean jj_3R_180() {
        return this.jj_scan_token(85);
    }

    private final boolean jj_3_13() {
        return this.jj_3R_62();
    }

    private final boolean jj_3_50() {
        return this.jj_3R_68();
    }

    private final boolean jj_3R_182() {
        return this.jj_scan_token(340);
    }

    private final boolean jj_3R_330() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(263)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(264)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(265)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(357)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(266)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(358)) {
                                this.jj_scanpos = xsp;
                                if (this.jj_scan_token(74)) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_scan_token(267)) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_scan_token(268)) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_scan_token(269)) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_scan_token(359)) {
                                                    this.jj_scanpos = xsp;
                                                    if (this.jj_scan_token(270)) {
                                                        this.jj_scanpos = xsp;
                                                        if (this.jj_scan_token(87)) {
                                                            this.jj_scanpos = xsp;
                                                            if (this.jj_scan_token(271)) {
                                                                this.jj_scanpos = xsp;
                                                                if (this.jj_scan_token(272)) {
                                                                    this.jj_scanpos = xsp;
                                                                    if (this.jj_scan_token(360)) {
                                                                        this.jj_scanpos = xsp;
                                                                        if (this.jj_scan_token(273)) {
                                                                            this.jj_scanpos = xsp;
                                                                            if (this.jj_scan_token(274)) {
                                                                                this.jj_scanpos = xsp;
                                                                                if (this.jj_scan_token(361)) {
                                                                                    this.jj_scanpos = xsp;
                                                                                    if (this.jj_scan_token(99)) {
                                                                                        this.jj_scanpos = xsp;
                                                                                        if (this.jj_scan_token(362)) {
                                                                                            this.jj_scanpos = xsp;
                                                                                            if (this.jj_scan_token(342)) {
                                                                                                this.jj_scanpos = xsp;
                                                                                                if (this.jj_scan_token(343)) {
                                                                                                    this.jj_scanpos = xsp;
                                                                                                    if (this.jj_scan_token(107)) {
                                                                                                        this.jj_scanpos = xsp;
                                                                                                        if (this.jj_scan_token(275)) {
                                                                                                            this.jj_scanpos = xsp;
                                                                                                            if (this.jj_scan_token(276)) {
                                                                                                                this.jj_scanpos = xsp;
                                                                                                                if (this.jj_scan_token(277)) {
                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                    if (this.jj_scan_token(365)) {
                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                        if (this.jj_scan_token(279)) {
                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                            if (this.jj_scan_token(344)) {
                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                if (this.jj_scan_token(364)) {
                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                    if (this.jj_scan_token(366)) {
                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                        if (this.jj_scan_token(367)) {
                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                            if (this.jj_scan_token(368)) {
                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                if (this.jj_scan_token(369)) {
                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                    if (this.jj_scan_token(370)) {
                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                        if (this.jj_scan_token(280)) {
                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                            if (this.jj_scan_token(281)) {
                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                if (this.jj_scan_token(282)) {
                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                    if (this.jj_scan_token(283)) {
                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                        if (this.jj_scan_token(371)) {
                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                            if (this.jj_scan_token(284)) {
                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                if (this.jj_scan_token(286)) {
                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                    if (this.jj_scan_token(372)) {
                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                        if (this.jj_scan_token(288)) {
                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                            if (this.jj_scan_token(289)) {
                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                if (this.jj_scan_token(373)) {
                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                    if (this.jj_scan_token(290)) {
                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                        if (this.jj_scan_token(291)) {
                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                            if (this.jj_scan_token(374)) {
                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                if (this.jj_scan_token(375)) {
                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                    if (this.jj_scan_token(292)) {
                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                        if (this.jj_scan_token(293)) {
                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                            if (this.jj_scan_token(294)) {
                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                if (this.jj_scan_token(348)) {
                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                    if (this.jj_scan_token(376)) {
                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                        if (this.jj_scan_token(377)) {
                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                            if (this.jj_scan_token(295)) {
                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                if (this.jj_scan_token(378)) {
                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                    if (this.jj_scan_token(296)) {
                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                        if (this.jj_scan_token(297)) {
                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                            if (this.jj_scan_token(177)) {
                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                if (this.jj_scan_token(298)) {
                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                    if (this.jj_scan_token(299)) {
                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                        if (this.jj_scan_token(300)) {
                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                            if (this.jj_scan_token(301)) {
                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                if (this.jj_scan_token(302)) {
                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(379)) {
                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(380)) {
                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(303)) {
                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(304)) {
                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(305)) {
                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(383)) {
                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(384)) {
                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(385)) {
                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(382)) {
                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(306)) {
                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(388)) {
                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(307)) {
                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(308)) {
                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(389)) {
                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(390)) {
                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(391)) {
                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(309)) {
                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(393)) {
                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(310)) {
                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(392)) {
                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(394)) {
                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(311)) {
                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(395)) {
                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(396)) {
                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(397)) {
                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(312)) {
                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(313)) {
                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(398)) {
                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(399)) {
                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(315)) {
                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(314)) {
                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(400)) {
                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(401)) {
                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(317)) {
                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(402)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(403)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(405)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(404)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(318)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(319)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(320)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(321)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(322)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(323)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(324)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(325)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(326)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(406)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(407)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(327)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(328)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(408)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(329)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(409)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(231)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(330)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(331)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(332)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(333)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(334)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(410)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(335)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(243)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(336)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(411)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(337)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(412)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(338)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(251)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(253)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(387)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(339)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(413)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        return true;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                }
                                                                                                                                                                                                            }
                                                                                                                                                                                                        }
                                                                                                                                                                                                    }
                                                                                                                                                                                                }
                                                                                                                                                                                            }
                                                                                                                                                                                        }
                                                                                                                                                                                    }
                                                                                                                                                                                }
                                                                                                                                                                            }
                                                                                                                                                                        }
                                                                                                                                                                    }
                                                                                                                                                                }
                                                                                                                                                            }
                                                                                                                                                        }
                                                                                                                                                    }
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3_12() {
        Token xsp = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.getToken((int)3).kind != 289;
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_60()) {
            return true;
        }
        return this.jj_3R_61();
    }

    private final boolean jj_3R_79() {
        return this.jj_3R_154();
    }

    private final boolean jj_3R_297() {
        return this.jj_3R_318();
    }

    private final boolean jj_3R_284() {
        return this.jj_scan_token(332);
    }

    private final boolean jj_3_11() {
        Token xsp = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.getToken((int)2).kind != 289;
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_58()) {
            return true;
        }
        return this.jj_3R_59();
    }

    private final boolean jj_3_38() {
        return this.jj_3R_79();
    }

    private final boolean jj_3R_179() {
        return this.jj_scan_token(245);
    }

    private final boolean jj_3R_283() {
        return this.jj_scan_token(331);
    }

    private final boolean jj_3R_90() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_11()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_12()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_13()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_181()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_182()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_183()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_184()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_185()) {
                                        return true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_282() {
        return this.jj_scan_token(276);
    }

    private final boolean jj_3R_222() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_282()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_283()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_284()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_178() {
        return this.jj_scan_token(138);
    }

    private final boolean jj_3_20() {
        return this.jj_3R_68();
    }

    private final boolean jj_3R_303() {
        return this.jj_3R_214();
    }

    private final boolean jj_3R_218() {
        return false;
    }

    private final boolean jj_3R_226() {
        return this.jj_scan_token(115);
    }

    private final boolean jj_3_35() {
        return this.jj_3R_78();
    }

    private final boolean jj_3R_177() {
        return this.jj_scan_token(201);
    }

    private final boolean jj_3R_163() {
        Token xsp = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.commonDatatypeName(false);
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_218()) {
            return true;
        }
        return this.jj_3R_90();
    }

    private final boolean jj_3R_191() {
        return this.jj_3R_231();
    }

    private final boolean jj_3R_258() {
        return this.jj_scan_token(355);
    }

    private final boolean jj_3R_332() {
        return this.jj_scan_token(457);
    }

    private final boolean jj_3R_190() {
        return this.jj_3R_230();
    }

    private final boolean jj_3R_89() {
        Token xsp = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.getToken((int)1).kind == 94;
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_176()) {
            this.jj_scanpos = xsp;
            this.lookingAhead = true;
            this.jj_semLA = this.getToken((int)1).kind == 201;
            this.lookingAhead = false;
            if (!this.jj_semLA || this.jj_3R_177()) {
                this.jj_scanpos = xsp;
                this.lookingAhead = true;
                this.jj_semLA = this.getToken((int)1).kind == 138;
                this.lookingAhead = false;
                if (!this.jj_semLA || this.jj_3R_178()) {
                    this.jj_scanpos = xsp;
                    this.lookingAhead = true;
                    this.jj_semLA = this.getToken((int)1).kind == 245;
                    this.lookingAhead = false;
                    if (!this.jj_semLA || this.jj_3R_179()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_180()) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_176() {
        return this.jj_scan_token(94);
    }

    private final boolean jj_3R_257() {
        return this.jj_scan_token(353);
    }

    private final boolean jj_3R_189() {
        return this.jj_3R_229();
    }

    private final boolean jj_3R_256() {
        return this.jj_scan_token(356);
    }

    private final boolean jj_3R_188() {
        return this.jj_3R_228();
    }

    private final boolean jj_3R_331() {
        return this.jj_scan_token(452);
    }

    private final boolean jj_3R_311() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_331()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_332()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_187() {
        return this.jj_3R_227();
    }

    private final boolean jj_3R_208() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_255()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_256()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_257()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_258()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_255() {
        return this.jj_scan_token(354);
    }

    private final boolean jj_3R_97() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_186()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_187()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_188()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_189()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_190()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_191()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_186() {
        return this.jj_3R_226();
    }

    private final boolean jj_3R_240() {
        return this.jj_scan_token(80);
    }

    private final boolean jj_3_6() {
        return this.jj_3R_53();
    }

    private final boolean jj_3_5() {
        return this.jj_3R_54();
    }

    private final boolean jj_3R_277() {
        return this.jj_3R_315();
    }

    private final boolean jj_3R_147() {
        return this.jj_3R_211();
    }

    private final boolean jj_3_4() {
        return this.jj_3R_54();
    }

    private final boolean jj_3R_92() {
        return this.jj_scan_token(220);
    }

    private final boolean jj_3_3() {
        return this.jj_3R_53();
    }

    private final boolean jj_3R_276() {
        return this.jj_3R_314();
    }

    private final boolean jj_3R_239() {
        return this.jj_scan_token(185);
    }

    private final boolean jj_3R_275() {
        return this.jj_3R_313();
    }

    private final boolean jj_3R_238() {
        return this.jj_3R_301();
    }

    private final boolean jj_3R_342() {
        return this.jj_3R_352();
    }

    private final boolean jj_3_19() {
        return this.jj_3R_68();
    }

    private final boolean jj_3R_91() {
        return this.jj_scan_token(220);
    }

    private final boolean jj_3R_43() {
        Token xsp = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.getToken((int)1).kind == 220 && this.getToken((int)2).kind != 101;
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_91()) {
            this.jj_scanpos = xsp;
            this.lookingAhead = true;
            this.jj_semLA = this.getToken((int)1).kind == 220 && this.getToken((int)2).kind == 101;
            this.lookingAhead = false;
            if (!this.jj_semLA || this.jj_3R_92()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3_30() {
        return this.jj_3R_75();
    }

    private final boolean jj_3R_160() {
        return this.jj_scan_token(232);
    }

    private final boolean jj_3R_274() {
        return this.jj_3R_312();
    }

    private final boolean jj_3R_201() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_237()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_238()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_239()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_240()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_237() {
        return this.jj_3R_219();
    }

    private final boolean jj_3R_310() {
        return this.jj_3R_299();
    }

    private final boolean jj_3R_219() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_273()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_274()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_275()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_276()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_277()) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_273() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_310()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_311();
    }

    private final boolean jj_3R_74() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_146()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_30()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_147()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_146() {
        return this.jj_3R_210();
    }

    private final boolean jj_3R_326() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_19()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_342()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3_37() {
        return this.jj_3R_68();
    }

    private final boolean jj_3R_95() {
        return this.jj_scan_token(62);
    }

    private final boolean jj_3R_169() {
        return this.jj_3R_219();
    }

    private final boolean jj_3R_305() {
        return this.jj_3R_326();
    }

    private final boolean jj_3R_138() {
        return this.jj_3R_208();
    }

    private final boolean jj_3_48() {
        return this.jj_3R_73();
    }

    private final boolean jj_3_24() {
        return this.jj_3R_71();
    }

    private final boolean jj_3R_94() {
        return this.jj_scan_token(122);
    }

    private final boolean jj_3R_215() {
        return this.jj_scan_token(420);
    }

    private final boolean jj_3R_137() {
        return this.jj_scan_token(290);
    }

    private final boolean jj_3R_136() {
        return this.jj_scan_token(251);
    }

    private final boolean jj_3R_168() {
        return this.jj_3R_203();
    }

    private final boolean jj_3R_159() {
        return this.jj_scan_token(379);
    }

    private final boolean jj_3R_357() {
        return this.jj_scan_token(176);
    }

    private final boolean jj_3R_135() {
        return this.jj_scan_token(87);
    }

    private final boolean jj_3R_356() {
        return this.jj_scan_token(150);
    }

    private final boolean jj_3_29() {
        return this.jj_3R_74();
    }

    private final boolean jj_3R_355() {
        return this.jj_scan_token(277);
    }

    private final boolean jj_3R_167() {
        return this.jj_3R_203();
    }

    private final boolean jj_3R_259() {
        return this.jj_3R_305();
    }

    private final boolean jj_3R_134() {
        return this.jj_3R_207();
    }

    private final boolean jj_3R_354() {
        return this.jj_scan_token(298);
    }

    private final boolean jj_3R_166() {
        return this.jj_scan_token(249);
    }

    private final boolean jj_3R_133() {
        return this.jj_3R_206();
    }

    private final boolean jj_3R_353() {
        return this.jj_scan_token(262);
    }

    private final boolean jj_3R_343() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_353()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_354()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_355()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_356()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_357()) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_349() {
        return this.jj_scan_token(219);
    }

    private final boolean jj_3R_107() {
        return this.jj_scan_token(188);
    }

    private final boolean jj_3R_93() {
        return this.jj_scan_token(100);
    }

    private final boolean jj_3R_106() {
        return this.jj_scan_token(188);
    }

    private final boolean jj_3R_87() {
        Token xsp = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.getToken((int)2).kind == 215 || this.getToken((int)2).kind == 404;
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_165()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_166()) {
                this.jj_scanpos = xsp;
                this.lookingAhead = true;
                this.jj_semLA = this.getToken((int)1).kind == 276 || this.getToken((int)1).kind == 331 || this.getToken((int)1).kind == 332;
                this.lookingAhead = false;
                if (!this.jj_semLA || this.jj_3R_167()) {
                    this.jj_scanpos = xsp;
                    this.lookingAhead = true;
                    this.jj_semLA = this.getToken((int)2).kind == 420 || this.getToken((int)4).kind == 420 && this.getToken((int)2).kind != 424;
                    this.lookingAhead = false;
                    if (!this.jj_semLA || this.jj_3R_168()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3_48()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_169()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_165() {
        return this.jj_scan_token(101);
    }

    private final boolean jj_3R_105() {
        return this.jj_scan_token(183);
    }

    private final boolean jj_3R_348() {
        return this.jj_scan_token(105);
    }

    private final boolean jj_3R_193() {
        return this.jj_scan_token(101);
    }

    private final boolean jj_3R_132() {
        return this.jj_scan_token(345);
    }

    private final boolean jj_3R_71() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_132()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_133()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_134()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3_29()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_135()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_136()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_137()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_138()) {
                                        return true;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_103() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(215)) {
            this.jj_scanpos = xsp;
            this.lookingAhead = true;
            this.jj_semLA = this.getToken((int)1).kind == 101 && (this.getToken((int)2).kind == 215 || this.getToken((int)2).kind == 404);
            this.lookingAhead = false;
            if (!this.jj_semLA || this.jj_3R_193()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_52() {
        return this.jj_3R_101();
    }

    private final boolean jj_3R_51() {
        return this.jj_3R_100();
    }

    private final boolean jj_3R_347() {
        return this.jj_scan_token(249);
    }

    private final boolean jj_3R_340() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_347()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_348()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_349()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_50() {
        return this.jj_3R_99();
    }

    private final boolean jj_3R_57() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_105()) {
            this.jj_scanpos = xsp;
            this.lookingAhead = true;
            this.jj_semLA = this.getToken((int)1).kind == 188 && this.getToken((int)2).kind == 91;
            this.lookingAhead = false;
            if (!this.jj_semLA || this.jj_3R_106()) {
                this.jj_scanpos = xsp;
                this.lookingAhead = true;
                this.jj_semLA = this.getToken((int)1).kind == 188 && this.getToken((int)2).kind == 213;
                this.lookingAhead = false;
                if (!this.jj_semLA || this.jj_3R_107()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_49() {
        return this.jj_3R_98();
    }

    private final boolean jj_3_1() {
        return this.jj_3R_43();
    }

    private final boolean jj_3R_322() {
        return this.jj_3R_340();
    }

    private final boolean jj_3R_48() {
        return this.jj_3R_97();
    }

    private final boolean jj_3R_47() {
        return this.jj_3R_96();
    }

    private final boolean jj_3R_54() {
        return this.jj_3R_103();
    }

    private final boolean jj_3R_46() {
        return this.jj_3R_95();
    }

    private final boolean jj_3R_45() {
        return this.jj_3R_94();
    }

    private final boolean jj_3_51() {
        return this.jj_3R_89();
    }

    private final boolean jj_3R_44() {
        return this.jj_3R_93();
    }

    private final boolean jj_3R_321() {
        return this.jj_3R_339();
    }

    private final boolean jj_3R_301() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_321()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_322()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_244() {
        return this.jj_3R_303();
    }

    private final boolean jj_3_10() {
        return this.jj_3R_57();
    }

    private final boolean jj_3R_209() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(183)) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_259();
    }

    private final boolean jj_3_2() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_44()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_45()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_46()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_47()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_48()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3_1()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_49()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_50()) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3R_51()) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_3R_52()) {
                                                return true;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3_28() {
        return this.jj_3R_73();
    }

    private final boolean jj_3_47() {
        return this.jj_3R_87();
    }

    private final boolean jj_3R_96() {
        return this.jj_scan_token(111);
    }

    private final boolean jj_3R_364() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(59)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(60)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(61)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(62)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(63)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(64)) {
                                this.jj_scanpos = xsp;
                                if (this.jj_scan_token(65)) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_scan_token(66)) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_scan_token(67)) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_scan_token(68)) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_scan_token(69)) {
                                                    this.jj_scanpos = xsp;
                                                    if (this.jj_scan_token(70)) {
                                                        this.jj_scanpos = xsp;
                                                        if (this.jj_scan_token(71)) {
                                                            this.jj_scanpos = xsp;
                                                            if (this.jj_scan_token(72)) {
                                                                this.jj_scanpos = xsp;
                                                                if (this.jj_scan_token(73)) {
                                                                    this.jj_scanpos = xsp;
                                                                    if (this.jj_scan_token(75)) {
                                                                        this.jj_scanpos = xsp;
                                                                        if (this.jj_scan_token(76)) {
                                                                            this.jj_scanpos = xsp;
                                                                            if (this.jj_scan_token(77)) {
                                                                                this.jj_scanpos = xsp;
                                                                                if (this.jj_scan_token(78)) {
                                                                                    this.jj_scanpos = xsp;
                                                                                    if (this.jj_scan_token(79)) {
                                                                                        this.jj_scanpos = xsp;
                                                                                        if (this.jj_scan_token(80)) {
                                                                                            this.jj_scanpos = xsp;
                                                                                            if (this.jj_scan_token(81)) {
                                                                                                this.jj_scanpos = xsp;
                                                                                                if (this.jj_scan_token(82)) {
                                                                                                    this.jj_scanpos = xsp;
                                                                                                    if (this.jj_scan_token(83)) {
                                                                                                        this.jj_scanpos = xsp;
                                                                                                        if (this.jj_scan_token(85)) {
                                                                                                            this.jj_scanpos = xsp;
                                                                                                            if (this.jj_scan_token(86)) {
                                                                                                                this.jj_scanpos = xsp;
                                                                                                                if (this.jj_scan_token(88)) {
                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                    if (this.jj_scan_token(89)) {
                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                        if (this.jj_scan_token(90)) {
                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                            if (this.jj_scan_token(91)) {
                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                if (this.jj_scan_token(92)) {
                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                    if (this.jj_scan_token(93)) {
                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                        if (this.jj_scan_token(94)) {
                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                            if (this.jj_scan_token(95)) {
                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                if (this.jj_scan_token(96)) {
                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                    if (this.jj_scan_token(97)) {
                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                        if (this.jj_scan_token(98)) {
                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                            if (this.jj_scan_token(100)) {
                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                if (this.jj_scan_token(101)) {
                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                    if (this.jj_scan_token(102)) {
                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                        if (this.jj_scan_token(103)) {
                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                            if (this.jj_scan_token(104)) {
                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                if (this.jj_scan_token(105)) {
                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                    if (this.jj_scan_token(106)) {
                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                        if (this.jj_scan_token(108)) {
                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                            if (this.jj_scan_token(109)) {
                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                if (this.jj_scan_token(110)) {
                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                    if (this.jj_scan_token(111)) {
                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                        if (this.jj_scan_token(112)) {
                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                            if (this.jj_scan_token(113)) {
                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                if (this.jj_scan_token(114)) {
                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                    if (this.jj_scan_token(115)) {
                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                        if (this.jj_scan_token(116)) {
                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                            if (this.jj_scan_token(117)) {
                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                if (this.jj_scan_token(118)) {
                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                    if (this.jj_scan_token(119)) {
                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                        if (this.jj_scan_token(120)) {
                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                            if (this.jj_scan_token(121)) {
                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                if (this.jj_scan_token(122)) {
                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                    if (this.jj_scan_token(123)) {
                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                        if (this.jj_scan_token(124)) {
                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                            if (this.jj_scan_token(125)) {
                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                if (this.jj_scan_token(126)) {
                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                    if (this.jj_scan_token(127)) {
                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                        if (this.jj_scan_token(128)) {
                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                            if (this.jj_scan_token(129)) {
                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                if (this.jj_scan_token(130)) {
                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(131)) {
                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(132)) {
                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(133)) {
                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(134)) {
                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(135)) {
                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(136)) {
                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(137)) {
                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(138)) {
                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(139)) {
                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(140)) {
                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(141)) {
                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(142)) {
                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(143)) {
                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(345)) {
                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(144)) {
                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(145)) {
                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(146)) {
                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(147)) {
                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(148)) {
                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(149)) {
                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(150)) {
                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(151)) {
                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(152)) {
                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(153)) {
                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(154)) {
                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(155)) {
                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(156)) {
                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(285)) {
                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(157)) {
                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(158)) {
                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(159)) {
                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(160)) {
                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(161)) {
                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(162)) {
                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(163)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(164)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(165)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(166)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(167)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(168)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(169)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(170)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(171)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(172)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(173)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(174)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(175)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(176)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(178)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(179)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(180)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(381)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(181)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(182)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(183)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(184)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(185)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(186)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(187)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(188)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(189)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(190)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(191)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(192)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(193)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(386)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(194)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(195)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(196)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(197)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(198)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(199)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(200)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(201)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(202)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(203)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(204)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(205)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(206)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(207)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(208)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(209)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(210)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(211)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(212)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(213)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(214)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(215)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(216)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(217)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(218)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(219)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(220)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(221)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(222)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(223)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(224)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(225)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(226)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(227)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(228)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(229)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(230)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(232)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(233)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(234)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(235)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(236)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(240)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(237)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(238)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(239)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(242)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(244)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(245)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(246)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(247)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(248)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(249)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(250)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(252)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(254)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(255)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(256)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(257)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(258)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(259)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(260)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(261)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(262)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(340)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(341)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(346)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(347)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(349)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(350)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(241)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(351)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(352)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                if (this.jj_scan_token(354)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    if (this.jj_scan_token(356)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        if (this.jj_scan_token(353)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            this.jj_scanpos = xsp;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            if (this.jj_scan_token(355)) {
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                return true;
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                                }
                                                                                                                                                                                                                                            }
                                                                                                                                                                                                                                        }
                                                                                                                                                                                                                                    }
                                                                                                                                                                                                                                }
                                                                                                                                                                                                                            }
                                                                                                                                                                                                                        }
                                                                                                                                                                                                                    }
                                                                                                                                                                                                                }
                                                                                                                                                                                                            }
                                                                                                                                                                                                        }
                                                                                                                                                                                                    }
                                                                                                                                                                                                }
                                                                                                                                                                                            }
                                                                                                                                                                                        }
                                                                                                                                                                                    }
                                                                                                                                                                                }
                                                                                                                                                                            }
                                                                                                                                                                        }
                                                                                                                                                                    }
                                                                                                                                                                }
                                                                                                                                                            }
                                                                                                                                                        }
                                                                                                                                                    }
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                        }
                                                                                                                                    }
                                                                                                                                }
                                                                                                                            }
                                                                                                                        }
                                                                                                                    }
                                                                                                                }
                                                                                                            }
                                                                                                        }
                                                                                                    }
                                                                                                }
                                                                                            }
                                                                                        }
                                                                                    }
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_334() {
        return this.jj_scan_token(133);
    }

    private final boolean jj_3R_318() {
        return this.jj_3R_338();
    }

    private final boolean jj_3R_333() {
        return this.jj_scan_token(242);
    }

    private final boolean jj_3R_315() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_333()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_334()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_232() {
        return this.jj_3R_297();
    }

    private final boolean jj_3R_139() {
        return this.jj_3R_209();
    }

    private final boolean jj_3R_338() {
        return this.jj_3R_346();
    }

    private final boolean jj_3_23() {
        return this.jj_3R_70();
    }

    private final boolean jj_3R_329() {
        return this.jj_scan_token(451);
    }

    private final boolean jj_3R_104() {
        Token xsp = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.javaClassFollows();
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_194()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_23()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_194() {
        return this.jj_3R_232();
    }

    private final boolean jj_3R_72() {
        return this.jj_3R_139();
    }

    private final boolean jj_3R_158() {
        return this.jj_scan_token(420);
    }

    private final boolean jj_3R_281() {
        return this.jj_scan_token(412);
    }

    private final boolean jj_3R_203() {
        Token xsp = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = (this.getToken((int)1).kind == 345 || this.getToken((int)1).kind == 263 || this.getToken((int)1).kind == 264 || this.getToken((int)1).kind == 406 || this.getToken((int)1).kind == 295 || this.getToken((int)1).kind == 87 || this.getToken((int)1).kind == 251 || this.getToken((int)1).kind == 282 || this.getToken((int)1).kind == 228 || this.getToken((int)1).kind == 351 || this.getToken((int)1).kind == 248 || this.getToken((int)1).kind == 172 || this.getToken((int)1).kind == 411 || this.getToken((int)1).kind == 373 || this.getToken((int)1).kind == 349 || this.getToken((int)1).kind == 350 || this.getToken((int)1).kind == 241 || this.getToken((int)1).kind == 276 || this.getToken((int)1).kind == 331 || this.getToken((int)1).kind == 332 || this.getToken((int)1).kind == 121 || this.getToken((int)1).kind == 82 || this.getToken((int)1).kind == 254 || this.getToken((int)1).kind == 161 || this.getToken((int)1).kind == 160 || this.getToken((int)1).kind == 221 || this.getToken((int)1).kind == 347 || this.getToken((int)1).kind == 262 || this.getToken((int)1).kind == 298 || this.getToken((int)1).kind == 277 || this.getToken((int)1).kind == 150 || this.getToken((int)1).kind == 176 || this.getToken((int)1).kind == 217 || this.getToken((int)1).kind == 290 || this.getToken((int)1).kind == 374 || this.getToken((int)1).kind == 354 || this.getToken((int)1).kind == 356 || this.getToken((int)1).kind == 353 || this.getToken((int)1).kind == 355) && this.getToken((int)2).kind == 420;
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_243()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_28()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_244()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_243() {
        return this.jj_3R_71();
    }

    private final boolean jj_3R_280() {
        return this.jj_scan_token(362);
    }

    private final boolean jj_3R_263() {
        return this.jj_3R_306();
    }

    private final boolean jj_3R_217() {
        return this.jj_3R_272();
    }

    private final boolean jj_3R_279() {
        return this.jj_scan_token(399);
    }

    private final boolean jj_3R_153() {
        return this.jj_3R_213();
    }

    private final boolean jj_3R_262() {
        return this.jj_scan_token(332);
    }

    private final boolean jj_3R_278() {
        return this.jj_scan_token(398);
    }

    private final boolean jj_3R_309() {
        return this.jj_3R_330();
    }

    private final boolean jj_3R_78() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_22()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_153()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3_22() {
        return this.jj_3R_68();
    }

    private final boolean jj_3R_175() {
        return this.jj_scan_token(206);
    }

    private final boolean jj_3_27() {
        return this.jj_3R_72();
    }

    private final boolean jj_3R_131() {
        return this.jj_3R_205();
    }

    private final boolean jj_3R_261() {
        return this.jj_scan_token(276);
    }

    private final boolean jj_3R_174() {
        return this.jj_scan_token(206);
    }

    private final boolean jj_3R_220() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_278()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_279()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_280()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_281()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_308() {
        return this.jj_3R_329();
    }

    private final boolean jj_3R_296() {
        return this.jj_scan_token(309);
    }

    private final boolean jj_3R_295() {
        return this.jj_scan_token(213);
    }

    private final boolean jj_3R_210() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_260()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_261()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_262()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_263()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_260() {
        return this.jj_scan_token(331);
    }

    private final boolean jj_3R_173() {
        return this.jj_scan_token(365);
    }

    private final boolean jj_3R_172() {
        return this.jj_scan_token(106);
    }

    private final boolean jj_3R_221() {
        return this.jj_scan_token(310);
    }

    private final boolean jj_3R_171() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_221()) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(317)) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_294() {
        return this.jj_scan_token(314);
    }

    private final boolean jj_3R_231() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_294()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_295()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_296()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_307() {
        return this.jj_scan_token(445);
    }

    private final boolean jj_3R_170() {
        return this.jj_3R_220();
    }

    private final boolean jj_3R_272() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_307()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_308()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_309()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_157() {
        return this.jj_3R_215();
    }

    private final boolean jj_3R_225() {
        return this.jj_scan_token(352);
    }

    private final boolean jj_3R_67() {
        return this.jj_3R_68();
    }

    private final boolean jj_3R_213() {
        return this.jj_scan_token(184);
    }

    private final boolean jj_3R_130() {
        return this.jj_scan_token(420);
    }

    private final boolean jj_3R_88() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_170()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_171()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_172()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_173()) {
                        this.jj_scanpos = xsp;
                        this.lookingAhead = true;
                        this.jj_semLA = this.getToken((int)1).kind == 206 && this.getToken((int)2).kind == 272;
                        this.lookingAhead = false;
                        if (!this.jj_semLA || this.jj_3R_174()) {
                            this.jj_scanpos = xsp;
                            this.lookingAhead = true;
                            this.jj_semLA = this.getToken((int)1).kind == 206 && this.getToken((int)2).kind == 337;
                            this.lookingAhead = false;
                            if (!this.jj_semLA || this.jj_3R_175()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3_49() {
        return this.jj_3R_88();
    }

    private final boolean jj_3R_148() {
        return this.jj_3R_212();
    }

    private final boolean jj_3R_129() {
        return this.jj_3R_204();
    }

    private final boolean jj_3R_75() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_34()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_148()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3_34() {
        return this.jj_3R_64();
    }

    private final boolean jj_3R_128() {
        return this.jj_3R_203();
    }

    private final boolean jj_3_18() {
        return this.jj_3R_67();
    }

    private final boolean jj_3_9() {
        return this.jj_3R_56();
    }

    private final boolean jj_3R_127() {
        return this.jj_3R_202();
    }

    private final boolean jj_3_36() {
        return this.jj_3R_68();
    }

    private final boolean jj_3R_300() {
        return this.jj_3R_303();
    }

    private final boolean jj_3R_236() {
        Token xsp = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.getToken((int)2).kind == 426 && this.getToken((int)4).kind == 420;
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_300()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_9()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_126() {
        return this.jj_3R_159();
    }

    private final boolean jj_3R_223() {
        return this.jj_scan_token(348);
    }

    private final boolean jj_3R_119() {
        Token xsp = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.getToken((int)2).kind == 426 && (this.getToken((int)3).kind == 422 || this.getToken((int)4).kind == 426 && this.getToken((int)5).kind == 422);
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_197()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_18()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_197() {
        return this.jj_3R_214();
    }

    private final boolean jj_3R_125() {
        return this.jj_3R_201();
    }

    private final boolean jj_3R_192() {
        return this.jj_scan_token(101);
    }

    private final boolean jj_3R_102() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(165)) {
            this.jj_scanpos = xsp;
            this.lookingAhead = true;
            this.jj_semLA = this.getToken((int)1).kind == 101 && this.getToken((int)2).kind == 165;
            this.lookingAhead = false;
            if (!this.jj_semLA || this.jj_3R_192()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_156() {
        return this.jj_3R_214();
    }

    private final boolean jj_3R_116() {
        return this.jj_scan_token(121);
    }

    private final boolean jj_3R_64() {
        Token xsp = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.getToken((int)2).kind == 308;
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_116()) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(121)) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_124() {
        return this.jj_scan_token(101);
    }

    private final boolean jj_3R_53() {
        return this.jj_3R_102();
    }

    private final boolean jj_3R_66() {
        return this.jj_3R_119();
    }

    private final boolean jj_3_15() {
        return this.jj_3R_64();
    }

    private final boolean jj_3R_123() {
        return this.jj_scan_token(101);
    }

    private final boolean jj_3R_200() {
        return this.jj_scan_token(426);
    }

    private final boolean jj_3R_152() {
        return this.jj_scan_token(397);
    }

    private final boolean jj_3R_122() {
        return this.jj_scan_token(418);
    }

    private final boolean jj_3R_70() {
        Token xsp = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.escapedValueFunctionFollows();
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_122()) {
            this.jj_scanpos = xsp;
            this.lookingAhead = true;
            this.jj_semLA = this.getToken((int)2).kind == 215 || this.getToken((int)2).kind == 404;
            this.lookingAhead = false;
            if (!this.jj_semLA || this.jj_3R_123()) {
                this.jj_scanpos = xsp;
                this.lookingAhead = true;
                this.jj_semLA = this.getToken((int)2).kind == 165;
                this.lookingAhead = false;
                if (!this.jj_semLA || this.jj_3R_124()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_125()) {
                        this.jj_scanpos = xsp;
                        this.lookingAhead = true;
                        this.jj_semLA = this.newInvocationFollows(1);
                        this.lookingAhead = false;
                        if (!this.jj_semLA || this.jj_3R_126()) {
                            this.jj_scanpos = xsp;
                            this.lookingAhead = true;
                            this.jj_semLA = this.aggregateFollows();
                            this.lookingAhead = false;
                            if (!this.jj_semLA || this.jj_3R_127()) {
                                this.jj_scanpos = xsp;
                                this.lookingAhead = true;
                                this.jj_semLA = this.miscBuiltinFollows();
                                this.lookingAhead = false;
                                if (!this.jj_semLA || this.jj_3R_128()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_129()) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3R_130()) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_3R_131()) {
                                                return true;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_100() {
        return this.jj_scan_token(211);
    }

    private final boolean jj_3_17() {
        return this.jj_3R_66();
    }

    private final boolean jj_3R_77() {
        Token xsp = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.getToken((int)2).kind == 400;
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_151()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_152()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_151() {
        return this.jj_scan_token(397);
    }

    private final boolean jj_3R_115() {
        return this.jj_scan_token(207);
    }

    private final boolean jj_3R_101() {
        return this.jj_scan_token(130);
    }

    private final boolean jj_3R_337() {
        return this.jj_3R_339();
    }

    private final boolean jj_3R_83() {
        return this.jj_3R_160();
    }

    private final boolean jj_3R_351() {
        return this.jj_scan_token(349);
    }

    private final boolean jj_3R_82() {
        return this.jj_3R_159();
    }

    private final boolean jj_3R_81() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_41()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_156()) {
                this.jj_scanpos = xsp;
                this.lookingAhead = true;
                this.jj_semLA = this.getToken((int)1).kind == 420 && (this.getToken((int)2).kind == 218 || this.getToken((int)2).kind == 252);
                this.lookingAhead = false;
                if (!this.jj_semLA || this.jj_3R_157()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_158()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3_41() {
        Token xsp = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.newInvocationFollows(1);
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_82()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_83()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_350() {
        return this.jj_scan_token(350);
    }

    private final boolean jj_3R_341() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_350()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_351()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_121() {
        Token xsp = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.getToken((int)3).kind == 420;
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_199()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_200()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_199() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(444)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(426)) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_336() {
        return this.jj_scan_token(341);
    }

    private final boolean jj_3R_317() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_336()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_337()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_114() {
        return this.jj_scan_token(136);
    }

    private final boolean jj_3R_63() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_114()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_115()) {
                this.jj_scanpos = xsp;
                if (this.jj_3_15()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_118() {
        return this.jj_scan_token(60);
    }

    private final boolean jj_3R_150() {
        return this.jj_scan_token(77);
    }

    private final boolean jj_3R_69() {
        return this.jj_3R_121();
    }

    private final boolean jj_3R_76() {
        Token xsp = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.getToken((int)2).kind == 391;
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_149()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_150()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_149() {
        return this.jj_scan_token(77);
    }

    private final boolean jj_3R_293() {
        return this.jj_scan_token(418);
    }

    private final boolean jj_3R_292() {
        return this.jj_3R_317();
    }

    private final boolean jj_3_21() {
        return this.jj_3R_69();
    }

    private final boolean jj_3R_55() {
        return this.jj_3R_72();
    }

    private final boolean jj_3R_268() {
        return this.jj_scan_token(347);
    }

    private final boolean jj_3R_117() {
        return this.jj_scan_token(120);
    }

    private final boolean jj_3R_65() {
        Token xsp = this.jj_scanpos;
        this.lookingAhead = true;
        this.jj_semLA = this.getToken((int)1).kind == 120 && this.getToken((int)2).kind != 426 && this.getToken((int)2).kind != 429;
        this.lookingAhead = false;
        if (!this.jj_semLA || this.jj_3R_117()) {
            this.jj_scanpos = xsp;
            this.lookingAhead = true;
            this.jj_semLA = this.getToken((int)1).kind == 60 && this.getToken((int)2).kind != 426 && this.getToken((int)2).kind != 429;
            this.lookingAhead = false;
            if (!this.jj_semLA || this.jj_3R_118()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_56() {
        return this.jj_3R_104();
    }

    private final boolean jj_3R_230() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_292()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_293()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_267() {
        return this.jj_scan_token(221);
    }

    private final boolean jj_3_16() {
        return this.jj_3R_65();
    }

    private final boolean jj_3R_212() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_266()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_267()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_268()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_266() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(161)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(160)) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3_25() {
        return this.jj_scan_token(140);
    }

    private final boolean jj_3R_339() {
        return this.jj_scan_token(438);
    }

    private final boolean jj_3R_234() {
        return this.jj_3R_212();
    }

    private final boolean jj_3_26() {
        return this.jj_3R_68();
    }

    private final boolean jj_3R_365() {
        return this.jj_scan_token(218);
    }

    private final boolean jj_3R_320() {
        return this.jj_scan_token(425);
    }

    private final boolean jj_3R_319() {
        return this.jj_scan_token(423);
    }

    private final boolean jj_3R_299() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_319()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_320()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3_8() {
        return this.jj_3R_55();
    }

    private final boolean jj_3R_362() {
        return this.jj_3R_366();
    }

    private final boolean jj_3_44() {
        return this.jj_3R_68();
    }

    private final boolean jj_3R_155() {
        return this.jj_scan_token(418);
    }

    private final boolean jj_3R_361() {
        return this.jj_3R_365();
    }

    private final boolean jj_3R_358() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_361()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_362()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_80() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_40()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_155()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3_40() {
        return this.jj_3R_81();
    }

    private final boolean jj_3_33() {
        return this.jj_3R_76();
    }

    private final boolean jj_3R_325() {
        return this.jj_scan_token(241);
    }

    private final boolean jj_3R_265() {
        return this.jj_scan_token(254);
    }

    private final boolean jj_3_52() {
        return this.jj_3R_90();
    }

    private final boolean jj_3R_324() {
        return this.jj_3R_341();
    }

    private final boolean jj_3R_304() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_324()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_325()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_211() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_264()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_265()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_264() {
        return this.jj_scan_token(82);
    }

    private final boolean jj_3R_345() {
        return this.jj_scan_token(420);
    }

    private final boolean jj_3_39() {
        return this.jj_3R_80();
    }

    private final boolean jj_3R_344() {
        return this.jj_3R_358();
    }

    private final boolean jj_3R_335() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_344()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_345()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_298() {
        return this.jj_scan_token(186);
    }

    private final boolean jj_3R_196() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_233()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_234()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_233() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_298()) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(110)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(109)) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_235() {
        return this.jj_3R_299();
    }

    private final boolean jj_3R_198() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_235()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_236();
    }

    private final boolean jj_3_14() {
        return this.jj_3R_63();
    }

    private final boolean jj_3R_254() {
        return this.jj_scan_token(374);
    }

    private final boolean jj_3R_113() {
        return this.jj_3R_196();
    }

    private final boolean jj_3R_62() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_113()) {
            this.jj_scanpos = xsp;
            if (this.jj_3_14()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_253() {
        return this.jj_3R_304();
    }

    private final boolean jj_3R_205() {
        return this.jj_scan_token(81);
    }

    private final boolean jj_3R_369() {
        return this.jj_3R_330();
    }

    private final boolean jj_3R_252() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(411)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(373)) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_368() {
        return this.jj_3R_329();
    }

    private final boolean jj_3R_290() {
        return this.jj_scan_token(178);
    }

    private final boolean jj_3R_251() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(248)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(172)) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_367() {
        return this.jj_scan_token(445);
    }

    private final boolean jj_3R_363() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_367()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_368()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_369()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_289() {
        return this.jj_3R_195();
    }

    private final boolean jj_3R_323() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(174)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(71)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(175)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(229)) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_207() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_250()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_251()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_252()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_253()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_254()) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_250() {
        return this.jj_scan_token(351);
    }

    private final boolean jj_3R_288() {
        return this.jj_scan_token(74);
    }

    private final boolean jj_3R_229() {
        return this.jj_scan_token(247);
    }

    private final boolean jj_3R_287() {
        return this.jj_scan_token(302);
    }

    private final boolean jj_3R_286() {
        return this.jj_scan_token(270);
    }

    private final boolean jj_3R_285() {
        return this.jj_scan_token(267);
    }

    private final boolean jj_3R_328() {
        return this.jj_scan_token(217);
    }

    private final boolean jj_3_31() {
        return this.jj_3R_76();
    }

    private final boolean jj_3R_327() {
        return this.jj_3R_343();
    }

    private final boolean jj_3R_306() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_327()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_328()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_302() {
        return this.jj_3R_323();
    }

    private final boolean jj_3R_224() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_285()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_286()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_287()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_288()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_289()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_290()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_360() {
        return this.jj_3R_364();
    }

    private final boolean jj_3R_359() {
        return this.jj_3R_363();
    }

    private final boolean jj_3R_346() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_359()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_360()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_120() {
        return this.jj_3R_198();
    }

    private final boolean jj_3R_164() {
        return this.jj_3R_217();
    }

    private final boolean jj_3_43() {
        return this.jj_3R_65();
    }

    private final boolean jj_3_32() {
        return this.jj_3R_77();
    }

    private final boolean jj_3R_86() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_164()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_163();
    }

    private final boolean jj_3R_84() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_43()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_68();
    }

    private final boolean jj_3R_313() {
        return this.jj_scan_token(456);
    }

    private final boolean jj_3R_316() {
        return this.jj_3R_335();
    }

    private final boolean jj_3R_112() {
        return this.jj_scan_token(381);
    }

    private final boolean jj_3_46() {
        return this.jj_3R_86();
    }

    private final boolean jj_3R_228() {
        return this.jj_scan_token(159);
    }

    private final boolean jj_3_42() {
        return this.jj_3R_84();
    }

    private final boolean jj_3R_242() {
        return this.jj_3R_302();
    }

    private final boolean jj_3R_99() {
        return this.jj_scan_token(147);
    }

    private final boolean jj_3R_111() {
        return this.jj_scan_token(180);
    }

    private final boolean jj_3R_352() {
        return this.jj_scan_token(131);
    }

    private final boolean jj_3R_204() {
        return this.jj_3R_217();
    }

    private final boolean jj_3R_312() {
        return this.jj_scan_token(455);
    }

    private final boolean jj_3R_110() {
        return this.jj_scan_token(178);
    }

    private final boolean jj_3R_202() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_241()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_242()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_241() {
        return this.jj_scan_token(99);
    }

    private final boolean jj_3R_98() {
        return this.jj_scan_token(335);
    }

    private final boolean jj_3R_61() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_110()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_111()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_112()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_145() {
        return this.jj_scan_token(104);
    }

    private final boolean jj_3R_291() {
        return this.jj_3R_316();
    }

    private final boolean jj_3R_227() {
        return this.jj_3R_291();
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }

    private static void jj_la1_1() {
        jj_la1_1 = new int[]{0, 0, 0x40000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x200000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x200000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x10000000, 0x10000000, 0x10000000, 0x10000000, 0, 0, 0x10000000, 0x10000000, 0, 0, 0, 0, 0, 0, 0, Integer.MIN_VALUE, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -134217728, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x200000, 0, 0, 0, 0, 0x10000000, 0, 0, 0, 0, 0x200000, 0, 0, 0, 0, 0x200000, 0, 0x200000, 0, 0, 0, 0x200000, 0, 0, 0x200000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x200000, 0, 0, 0, 0, 0, 0x200000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x200000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x200000, 0x200000, 0, 0, 0x48000000, 0, 0, 0, 0x48000000, 0, 0, 0, 0, 0, 0, 0, 0x10000000, 0, 0, 0x10000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x10000000, 0, -134217728, 0, -134217728, -134217728, 0};
    }

    private static void jj_la1_2() {
        jj_la1_2 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0x800400, 0, 0, 4, 0, 0, 0, 0x800400, 0, 0, 0, 0, 0x800400, 0, 0, 0, 0, 0, 0, 0, 0x40A00400, 0x40200000, 0x40200000, 0x40200000, 0, 0x40200000, 0x40200000, 787456, 0, 0, 786432, 0, 786432, 0, 0, 0, 0, 0, 0, 0, 0, 0, 787456, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x800404, 4, 0, 0, 0, 0, 0, 0, 512, 0, 0, 512, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1048577, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4096, 0, 0, 65536, 8520704, 0x800400, 0, 0x800000, 0, 0, 262144, 0, 0, 4, 0, 8192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0x800404, 0, 0, 4, 0, 0, 4, 0, 0, 0x800400, 0, 0, 0, 8, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128, 128, 262144, 0, 0, 64, 0x800440, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x4000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x800400, 65536, 0, 0, 0x40000000, 0, 0x200000, 0, 0, 0, 0, 0, 0, 0, 0, 16384, 0x40000000, 0, 0, 0x200000, 0, 0, 0x44A00400, 0x4000000, 0x4800400, 0, 0x4000000, 16384, 16384, 0x4000000, 0, 0x200000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x800400, 0, 0x800400, -9438209, 0x800400, -1048577, -1048577, 0x800400};
    }

    private static void jj_la1_3() {
        jj_la1_3 = new int[]{524288, 0, 67665936, 0, 0, 0, 0, 0, 0, 524288, 0, 0, 0, 0, 0, 0, 0, 0, 2056, 0, 0, 0, 0, 32, 0, 2056, 0, 0, 0, 0, 2056, 0, 0, 0, 0, 0, 524288, 0, 2056, 65536, 0, 0, 65536, 0, 65536, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 24576, 24576, 0, 0, 24576, 0, 0, 0, 0, 0x2000000, 0, 0, 0, 0, 0, 0, 0, 0, Integer.MIN_VALUE, 0x1000000, 0x1000000, 0x1000000, 0x1000000, Integer.MIN_VALUE, 0, 0x1000000, 0x1000000, 0, 0, 0, 0, 2056, 0, 0, 0, 0, 0, 0, 0, 0, 0x40000000, 0x40000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 512, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 512, 2056, 2056, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 512, 512, 0, 0, 0x100000, 0x100000, 0, 0, 0, 0, 65536, 0, 0, 65536, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2056, 0, 0, 0, 0, 0, 0, 0, 0, 2056, 0, 0, 0, 0x100000, 0x100000, 0, 0, 0, 0, 0, 64, 128, 256, 0, 8, 0, 0, 0, 0, 0, 2056, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 524288, 0, 0, 0, 0, 65536, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2048, 0, 0, 0, 0, 0, 0, 0, 1024, 0, 0, 0, 0, 0, 0, 2056, 512, 0x18000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 524288, 0, 65536, 0, 0, 0, 0, 0, 0, 0x4000000, 2056, 0, 2056, 0x4000000, 0, 0, 0, 0, 0, 0, 0, 524288, 0, 0, 524288, 0, 0, 0, 0, 0, 0, 524288, 0, 2056, 524288, 2056, -2057, 2056, -1, -1, 2056};
    }

    private static void jj_la1_4() {
        jj_la1_4 = new int[]{Integer.MIN_VALUE, 0, Integer.MIN_VALUE, 524292, 0, 0, 16384, 16384, 0, Integer.MIN_VALUE, 0, 0, 0, 0, 4096, 0, 512, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1024, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 512, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 256, 0, 512, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0x2000000, 0, 0, 0x2000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0x400000, 0, 0, 0, 0, 0, 0, 0x400000, 0, 0, 0, 0, 0, 0, 4096, 0, 0, 0, 32, 0, 0, 0, 0, 0, 0x400000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x400000, 0, 32, 0, 0, 0, 0, 0, 0, 0, 64, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x100000, 0x200000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x10000000, 0, 0x10000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 16, 0, 0, 0x2000000, 0x2000000, 16, 0, 0, 0, 512, 0, 0, 0, Integer.MIN_VALUE, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, 0, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, 0, 0, 0, 0, 1024, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1024, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16384, -2147483644, 0, 0, Integer.MIN_VALUE, 16384, 0, 0, 0, 0, 0, Integer.MIN_VALUE, 0, 0, -2147483644, 0, -1, 0, -1, -1, 0};
    }

    private static void jj_la1_5() {
        jj_la1_5 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 131072, 0, 0, 0, 0, 0, 0, 131072, 0, 0, 0x10000000, 0, 131072, 0, 0, 0x10000000, 0, 0x800000, 0, 0, 131072, 0x800000, 0x800000, 0x800000, 0, 0x800000, 0x800000, 262144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x140000, 0, 0, 0, 0, 262144, 0x4000003, 0x4000000, 0, 0, 0x4000003, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 131072, 0, 0, 0, 0x800000, 16, 0, 0x800000, 0x800800, 0, 0, 2048, 0, 0, 0, 0, 0, 0, 0, 0, 0x1000000, -1, 65536, 0, 0, 0, 0, 0, 0, 65536, 0, 4096, 0, 0, 4096, 0, 0, 512, 0, 0, 0x2000000, 131072, 131072, 4096, 0, 0, 65536, 0, 0, 0, 0, 0, 0, 0, 0x1000000, 3, 65536, 0, 0, 0, 0, 0, 0, 0, 0, 0x8000000, 0, 0, 0, 0x1000000, 0, 0, 0x1000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 131072, 0, 0, 0, 0, 0, 0, 0, 0, 131072, 0, 0, 0, 0, 0, 1024, 0, 1024, 1024, 0, 0, 0, 0, 0, 49152, 49152, 0, 0x1000000, 0, 0, 131072, 0, 0, 0x400000, 0, 0, 0, 0, 0x400000, 0, 0x400000, 0, 0, 0, 0, 0x400000, 0, 0, 0, 0, 0, 0x400000, 0x8000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, 0, 0, 0, 0, 0, 0, 0, 0, 0, 131072, 0x2000000, 0, 0, 0, 0, 0, 0, 0x10000000, 0, 0x10000000, 0x10000000, 0, 0x400000, 0x1000000, 0x400000, 0, 0, 0, 0x800000, 0, 0, 131072, 0, 131072, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 131072, 0, 131072, -131073, 131072, -1, -1, 131072};
    }

    private static void jj_la1_6() {
        jj_la1_6 = new int[]{0x4000000, 0, 0x4200000, 524288, 0, 0x800000, 0x801000, 0x801000, 0, 0x4200000, 0, 0, 0, 0, 0, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x200000, 0, 0, 0, 256, 0, 512, 66048, 66048, 66048, 0, 66048, 66048, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x20000000, 0, 0, 0, 0x20000000, 0, 0x20000000, 0, 32768, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x4000000, 0x4000000, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0x8000000, 0, 0, 0, 0, 0x2000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x800000, 0x8000000, 0, 0, 0, 0, 0, 0x2000000, 0, 0, 256, 0, 0, 0, 0, 0, 0x20000000, 0x2000000, 0, 0, 0x8000000, 0x8000000, 0, 0, 0, 0, 0, 16384, 0, 0, 0, 0, 0, 0, 0, 0, 0x40000000, 0x40000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x100000, 4, 0x100000, 0x100000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x800000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16384, 0, 0, 0x800000, 0x800000, 0, 0x8000000, 0, 1, 0, 0, 512, 512, 0, 0, 0, 0, 0, 262144, 0, 0x10040000, 0, 0, 0, 66048, 0, 0, 512, 0, 0, 0, 0, 262144, 262144, 0, 0, 0, 4096, 0x4010000, 0, 0, 0x4010000, 4096, 0, 0, 0, 0, 0, 0x4010000, 0, 8192, 0x4010000, 0, -1, 0, -1, -1, 0};
    }

    private static void jj_la1_7() {
        jj_la1_7 = new int[]{0x10800000, 0, 0x10800000, 0, 0, 0, 0x200100, 256, 0, 0x10800000, 0, 0, 0, 0, 0, 0, 0, 0, 0x28080080, 256, 0, 0, 0, 0, 0, 0x28080080, 0, 0, 0x200000, 0, 0x28080080, 4096, 0, 0x200000, 0, 0, 0, 0, 0x28280080, 0x200000, 0x200000, 0x200000, 0, 0x200000, 0x200000, 0, 0, Integer.MIN_VALUE, 0x40000000, 0, 0, 0, Integer.MIN_VALUE, 0, Integer.MIN_VALUE, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x40000000, 0, 0, 0, 0, 0, 0, 0x100000, 0, 0, 0, 0, 0x100000, 0, 0, 0, 0x10000000, 0x10000000, 0, 0, 0x28080080, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0x2000010, 0, 0, 0, 0, 0, 0, 0x1000000, 0, 0, 0x1020000, 131072, 0, 65536, 0, 0, 0x2040000, 0x28080080, 0x28080080, 0x1020000, 0x8000000, 0, 0, 0x40000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 262144, 0x2000000, 0x2000000, 0, 0, 0, 0, 0, 0x800000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x28080080, 0, 256, 0, 0, 0, 0, 0, 0, 0x28080080, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, 32, 0x40000000, 0, 0, 0, 0x28080080, 0, 0, 0, 0, 256, 0x200000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x800000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x2000000, 262144, 0, 262144, 0, 524416, 256, 0, 4096, 4096, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 705167488, 0x2040000, 0, 0, 0, 0, 0x200000, 0x200000, 0, 0, 0, 0, 0x800000, 0, 0, 0, 0, 0, 0, 0x200000, 0, 0, 0x28280080, 0, 0x28080080, 0, 0, 0, 0, 0, 0, 0, 0, 0x800000, 256, 0, 0x800000, 0, 0, 0, 0, 0, 0, 0x800000, 0, 0x28080080, 0x800000, 0x28080080, -671613057, 0x28080080, -1, -1, 0x28080080};
    }

    private static void jj_la1_8() {
        jj_la1_8 = new int[]{0, 0, 0, 0, 0, 1, 1, 1, 0, 0, 4, 0, 0, 4, 0, 0, 0, 8, 1606418304, 0, 4, 0, 0, 0, 4, 1606418304, 0, 0, 0, 16, 1606418304, 0, 0, 0, 0, 0, 0, 0, 1606418304, 0x2000008, 0, 0, 0x2000008, 0, 0x2000008, 1067008, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 18432, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x100000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1606418304, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x7FBFFFFF, 0x200040, 0, 131072, 0, 0, 67109248, 0, 0x200040, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1606418304, 1606418304, 67109248, 0, 0, 0x300040, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x300040, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 4, 0, 0, 0, 0, 0, 0, 0, 0, 1606418304, 0, 0, 0, 0, 0, 0, 0, 0, 1606418304, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1606418304, 0, 0, 0, 0, 0, 0, 0, 8658944, 0x800000, 8658944, 8192, 0, 0x20000000, 0x20000000, 8658944, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0x2000008, 1024, 0, 0, 0x8000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 65536, 0, 0, 0, 1606418304, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1606418304, 0, 1606418304, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1606418304, 0, 1606418304, 536871039, 1606418304, 0x7FBFFFFF, 0x7FBFFFFF, 1606418304};
    }

    private static void jj_la1_9() {
        jj_la1_9 = new int[]{0, 0, 0x4200000, 0, 0, 0, 0, 0, 0, 0x4200000, 0, 0, 0, 0, 0, 0, 0, 0, -268435457, 0, 0, 0, 0, 0, 0, -268435457, 0, 0, 0, 0, -268435457, 0, 0x4200000, 0, 16, 0, 0, 0, -268435457, 0, 0, 0, 0, 0, 0, 16384, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16384, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -268435457, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -268435457, 1024, 0, 0, 0, -1073741824, 128, 0, 1024, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -268435457, -268435457, 128, 4, 0, 1024, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1024, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -268435457, 0, 0, 0, 0, 0, 0, 0, 0, -268435457, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -268435457, 0, 0, 0, 0, 0x2000000, 0, 0, 0x1000101, 0, 0x1000101, 0x1000000, 0, 0, 0, 0x1000101, 0, 0, 0, 0, 0, 0, 0, 0, 0x2000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x20400000, 0x20400000, 0, 0x20400000, 0, 0, 0, 0, -268435457, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 32, -268435457, 0, -268435457, 32, 0, 0, 0, 0, 0x800000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -268435457, 0, -268435457, 0, -268435457, -268435457, -268435457, -268435457};
    }

    private static void jj_la1_10() {
        jj_la1_10 = new int[]{0x200000, 0, 0x200000, 32768, 0, 512, 512, 512, 0, 0x200000, 0, 0, 0, 0, 0, 0, 0, 0, 0x11CFFFFF, 0, 0, 0, 0, 0, 0, 0x11CFFFFF, 0x200000, 0x200000, 0, 0, 0x11CFFFFF, 0, 0, 0, 0, 0, 0, 0, 0x11CFFFFF, 0, 0, 0, 0, 0, 0, 0x10101800, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x8000000, 0, 0, 0, 0x8000000, 0, 0x8000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x11CFFFFF, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0xC06000, 24576, 127, 0, 0, 0, 0, 0, 0, 0, -536870912, 0x60000000, 0, 0, 0x60000000, 0, 0, 0x11CFFFFF, 0x11CFFFFF, -503316480, 0, 0, 6144, 0, 0, 0, 0, 0, 0, 0, 0, 0x8000000, 6144, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x11CFFFFF, 0, 0, 0, 0, 0, 0, 0, 0, 0x11CFFFFF, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x11CFFFFF, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 256, 0, 0, 0, 0, 0, 0, 0, 128, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 131072, 0, 0, 0, 0x11CFFFFF, 0, 524288, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x11CFFFFF, 0, 0x11CFFFFF, 0, 0, 0, 0, 0, 0, 0, 512, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x11CFFFFF, 0, 0x11CFFFFF, -298844160, 0x11CFFFFF, -1, -1, 0x11CFFFFF};
    }

    private static void jj_la1_11() {
        jj_la1_11 = new int[]{0, 0x800000, 0, 0, 0x800000, 0, 524288, 524288, 0x1000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, -536872992, 524288, 0, 0, 0, 0, 0, -536872992, 0, 0, 0, 0, -536872992, 0, 0, 0, 2048, 0, 0, 0, -536872992, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x20000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x20000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -536872992, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -2049, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x200000, 0, 0x600000, 0, 0, 0, 0, 0, 0, -536872992, -536872992, 0x600000, 30, 0, 0, 0, 30, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -536872992, 0, 0, 0, 0, 0, 0, 0, 0, -536872992, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -536872992, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x4000000, 32, 0, 0, 0, 0x18000000, 0x18000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 524288, 131072, 0, 0, 0, 0, 0, 9216, 1024, 0, 0, 0, 0, 0, -536872992, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 256, -536872992, 0, -536872992, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -536872992, 0, -536872992, 536870943, -536872992, -2049, -2049, -536872992};
    }

    private static void jj_la1_12() {
        jj_la1_12 = new int[]{0, 512, 0, 0, 512, 0x4000000, 0x4000000, 0x4000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x3FFFFFFB, 0, 0, 0, 0, 0, 0, 0x3FFFFFFB, 0, 0, 0, 0, 0x3FFFFFFB, 0, 0, 0, 0, 0, 0, 0, 0x3FFFFFFB, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x3FFFFFFB, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x3FFFFFFF, 0, 0, 0, 0, 0, 0x400000, 0, 0, 0, 0, 0x8000000, 0, 0x8000000, 0, 0, 0, 0, 0x100000, 0, 0x3FFFFFFB, 0x3FFFFFFB, 0x8400000, 0, 0, 0, 0, 0, 0x1000000, 0, 0, 0, 8192, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x3FFFFFFB, 0, 0, 0, 0, 0, 0, 0, 0, 0x3FFFFFFB, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x3FFFFFFB, 0, 0, 0, 0, 0, 0, 0, 2099272, 0, 2099272, 0, 0, 4, 4, 2099272, 0, 0, 256, 0, 0, 0, 0, 0, 0, 3, 3, 0, 0, 0, 0, 0, 0, 0x100000, 0, 0, 0, 0, 0, 0, 0, 524288, 0, 0, 0, 1024, 0, 0x1000C000, 0x1000C000, 0, 0, 0, 0x100000, 0, 0x3FFFFFFB, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 131072, 0, 0x3FFFFFFB, 0, 0x3FFFFFFB, 0, 0, 0, 0, 0, 0, 0, 0, 0x4000000, 0, 0, 0x4000000, 0, 0, 0, 0, 0, 0, 0x4000000, 0, 0x3FFFFFFB, 0x4000000, 0x3FFFFFFB, 4, 0x3FFFFFFB, 0x3FFFFFFF, 0x3FFFFFFF, 0x3FFFFFFB};
    }

    private static void jj_la1_13() {
        jj_la1_13 = new int[]{0x400014, 0, 0x400014, 0, 0, 0, 0, 0, 0, 0x400014, 0, 0, 0, 0, 0, 0, 0, 0, 0x20000000, 0, 0, 0, 0, 0, 0, 0x20000000, 0x400004, 0x400000, 0, 0, 0x20000000, 0, 0, 0, 0, 0, 0, 256, 0x20000000, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 16, 0, 16, 0, 0, 16, 16, 16, 16, 0, 0, 0, 256, 16, 0, 0, 0, 16, 0, 0, 0, 0, 1024, 0x20000000, 0, 640, 0, 256, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 0, 64, 256, 0x20000000, 0, 0, 0, 0, 0, 0, 0, 4161536, 4, 4, 0, 4161536, 640, 640, 0x8000840, 0x8000840, 640, 0x10000400, 1024, 0, 0x20000000, 0, 256, 0, 0, 0, 0, 256, 0, 256, 0, 0, 256, 0, 0, 32, 0, 0, 0, 4194948, 0x20000010, 0x20000000, 0, 0, 256, 0, 0, 0, 0, 0, 256, 0, 0, 0, 0, 0, 288, 0, 0x400000, 0, 256, 256, 0, 0, 0, 0, 256, 256, 0, 0, 256, 0, 256, 256, 0, 0, 0, 0, 0, 0, 256, 4, 0, 16, 0, 0x20000000, 0, 0, 0, 16, 0, 0, 16, 0, 0x20000000, 16, 256, 256, 0, 0, 0, 0, 0, 0, 256, 0, 0, 0, 64, 0, 0, 0, 0, 256, 0, 0x20000000, 0, 16, 0, 16, 0, 0, 0, 0, 0, 0, 0, 256, 0, 0, 0, 256, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 16, 256, 0, 0, 0, 644, 640, 644, 0, 0, 0, 0, 131072, 131072, 0, 0, 0, 0, 0, 0, 0, 131072, 0, 0, 0x20400000, 4194948, 0, 0, 0, 0, 0, 0, 0, 16, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x20000000, 0, 0x20000000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 256, 0, 0, 16, 256, 16, 16, 16, 0, 256, 0x20000000, 0, 0x20000000, 0, 0, 0x20000000, 0x20000000, 0x20000000};
    }

    private static void jj_la1_14() {
        jj_la1_14 = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 80, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 912, 8, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 912, 0, 912, 528, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 136, 912, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 8, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 8, 0, 0, 8, 8, 8};
    }

    public SQLParser(CharStream stream) {
        int i;
        this.token_source = new SQLParserTokenManager(stream);
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (i = 0; i < 315; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(CharStream stream) {
        int i;
        this.token_source.ReInit(stream);
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (i = 0; i < 315; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public SQLParser(SQLParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (i = 0; i < 315; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(SQLParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.token.next = this.jj_nt = this.token_source.getNextToken();
        this.jj_gen = 0;
        for (i = 0; i < 315; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = this.jj_nt;
        this.jj_nt = this.token.next != null ? this.jj_nt.next : (this.jj_nt.next = this.token_source.getNextToken());
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.jj_nt = this.token;
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private final boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.jj_nt;
        this.jj_nt = this.token.next != null ? this.jj_nt.next : (this.jj_nt.next = this.token_source.getNextToken());
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.lookingAhead ? this.jj_scanpos : this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            boolean exists = false;
            Enumeration e = this.jj_expentries.elements();
            while (e.hasMoreElements()) {
                int[] oldentry = (int[])e.nextElement();
                if (oldentry.length != this.jj_expentry.length) continue;
                exists = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    exists = false;
                    break;
                }
                if (!exists) continue;
                break;
            }
            if (!exists) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[470];
        for (i = 0; i < 470; ++i) {
            la1tokens[i] = false;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 315; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) != 0) {
                    la1tokens[64 + j] = true;
                }
                if ((jj_la1_3[i] & 1 << j) != 0) {
                    la1tokens[96 + j] = true;
                }
                if ((jj_la1_4[i] & 1 << j) != 0) {
                    la1tokens[128 + j] = true;
                }
                if ((jj_la1_5[i] & 1 << j) != 0) {
                    la1tokens[160 + j] = true;
                }
                if ((jj_la1_6[i] & 1 << j) != 0) {
                    la1tokens[192 + j] = true;
                }
                if ((jj_la1_7[i] & 1 << j) != 0) {
                    la1tokens[224 + j] = true;
                }
                if ((jj_la1_8[i] & 1 << j) != 0) {
                    la1tokens[256 + j] = true;
                }
                if ((jj_la1_9[i] & 1 << j) != 0) {
                    la1tokens[288 + j] = true;
                }
                if ((jj_la1_10[i] & 1 << j) != 0) {
                    la1tokens[320 + j] = true;
                }
                if ((jj_la1_11[i] & 1 << j) != 0) {
                    la1tokens[352 + j] = true;
                }
                if ((jj_la1_12[i] & 1 << j) != 0) {
                    la1tokens[384 + j] = true;
                }
                if ((jj_la1_13[i] & 1 << j) != 0) {
                    la1tokens[416 + j] = true;
                }
                if ((jj_la1_14[i] & 1 << j) == 0) continue;
                la1tokens[448 + j] = true;
            }
        }
        for (i = 0; i < 470; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = (int[])this.jj_expentries.elementAt(i2);
        }
        return new ParseException(this.token, exptokseq, SQLParserConstants.tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 52; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                            break;
                        }
                        case 5: {
                            this.jj_3_6();
                            break;
                        }
                        case 6: {
                            this.jj_3_7();
                            break;
                        }
                        case 7: {
                            this.jj_3_8();
                            break;
                        }
                        case 8: {
                            this.jj_3_9();
                            break;
                        }
                        case 9: {
                            this.jj_3_10();
                            break;
                        }
                        case 10: {
                            this.jj_3_11();
                            break;
                        }
                        case 11: {
                            this.jj_3_12();
                            break;
                        }
                        case 12: {
                            this.jj_3_13();
                            break;
                        }
                        case 13: {
                            this.jj_3_14();
                            break;
                        }
                        case 14: {
                            this.jj_3_15();
                            break;
                        }
                        case 15: {
                            this.jj_3_16();
                            break;
                        }
                        case 16: {
                            this.jj_3_17();
                            break;
                        }
                        case 17: {
                            this.jj_3_18();
                            break;
                        }
                        case 18: {
                            this.jj_3_19();
                            break;
                        }
                        case 19: {
                            this.jj_3_20();
                            break;
                        }
                        case 20: {
                            this.jj_3_21();
                            break;
                        }
                        case 21: {
                            this.jj_3_22();
                            break;
                        }
                        case 22: {
                            this.jj_3_23();
                            break;
                        }
                        case 23: {
                            this.jj_3_24();
                            break;
                        }
                        case 24: {
                            this.jj_3_25();
                            break;
                        }
                        case 25: {
                            this.jj_3_26();
                            break;
                        }
                        case 26: {
                            this.jj_3_27();
                            break;
                        }
                        case 27: {
                            this.jj_3_28();
                            break;
                        }
                        case 28: {
                            this.jj_3_29();
                            break;
                        }
                        case 29: {
                            this.jj_3_30();
                            break;
                        }
                        case 30: {
                            this.jj_3_31();
                            break;
                        }
                        case 31: {
                            this.jj_3_32();
                            break;
                        }
                        case 32: {
                            this.jj_3_33();
                            break;
                        }
                        case 33: {
                            this.jj_3_34();
                            break;
                        }
                        case 34: {
                            this.jj_3_35();
                            break;
                        }
                        case 35: {
                            this.jj_3_36();
                            break;
                        }
                        case 36: {
                            this.jj_3_37();
                            break;
                        }
                        case 37: {
                            this.jj_3_38();
                            break;
                        }
                        case 38: {
                            this.jj_3_39();
                            break;
                        }
                        case 39: {
                            this.jj_3_40();
                            break;
                        }
                        case 40: {
                            this.jj_3_41();
                            break;
                        }
                        case 41: {
                            this.jj_3_42();
                            break;
                        }
                        case 42: {
                            this.jj_3_43();
                            break;
                        }
                        case 43: {
                            this.jj_3_44();
                            break;
                        }
                        case 44: {
                            this.jj_3_45();
                            break;
                        }
                        case 45: {
                            this.jj_3_46();
                            break;
                        }
                        case 46: {
                            this.jj_3_47();
                            break;
                        }
                        case 47: {
                            this.jj_3_48();
                            break;
                        }
                        case 48: {
                            this.jj_3_49();
                            break;
                        }
                        case 49: {
                            this.jj_3_50();
                            break;
                        }
                        case 50: {
                            this.jj_3_51();
                            break;
                        }
                        case 51: {
                            this.jj_3_52();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        SQLParser.jj_la1_0();
        SQLParser.jj_la1_1();
        SQLParser.jj_la1_2();
        SQLParser.jj_la1_3();
        SQLParser.jj_la1_4();
        SQLParser.jj_la1_5();
        SQLParser.jj_la1_6();
        SQLParser.jj_la1_7();
        SQLParser.jj_la1_8();
        SQLParser.jj_la1_9();
        SQLParser.jj_la1_10();
        SQLParser.jj_la1_11();
        SQLParser.jj_la1_12();
        SQLParser.jj_la1_13();
        SQLParser.jj_la1_14();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

