/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.ReuseFactory;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;

public class SQLBooleanConstantNode
extends ConstantNode {
    public void init(Object newValue) throws StandardException {
        String strVal = (String)newValue;
        Boolean val = null;
        SanityManager.ASSERT(StringUtil.SQLEqualsIgnoreCase(strVal, "true") || StringUtil.SQLEqualsIgnoreCase(strVal, "false") || StringUtil.SQLEqualsIgnoreCase(strVal, "unknown"), "String \"" + strVal + "\" cannot be converted to a SQLBoolean");
        if (StringUtil.SQLEqualsIgnoreCase(strVal, "true")) {
            val = Boolean.TRUE;
        } else if (StringUtil.SQLEqualsIgnoreCase(strVal, "false")) {
            val = Boolean.FALSE;
        }
        super.init(TypeId.BOOLEAN_ID, Boolean.TRUE, ReuseFactory.getInteger(1));
        if (val == null) {
            this.setValue(this.getTypeServices().getNull());
        } else {
            this.setValue(this.getDataValueFactory().getDataValue((boolean)val));
        }
    }

    void generateConstant(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        mb.push(this.value.getBoolean());
    }
}

