/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.RowOrdering;
import org.apache.derby.impl.sql.compile.ColumnOrdering;

class RowOrderingImpl
implements RowOrdering {
    Vector ordering = new Vector();
    ColumnOrdering columnsAlwaysOrdered;
    Vector alwaysOrderedOptimizables;
    ColumnOrdering currentColumnOrdering;
    Vector unorderedOptimizables = new Vector();

    RowOrderingImpl() {
        this.columnsAlwaysOrdered = new ColumnOrdering(3);
        this.alwaysOrderedOptimizables = new Vector();
    }

    public boolean orderedOnColumn(int direction, int orderPosition, int tableNumber, int columnNumber) throws StandardException {
        if (this.vectorContainsOptimizable(tableNumber, this.alwaysOrderedOptimizables)) {
            return true;
        }
        if (this.columnsAlwaysOrdered.contains(tableNumber, columnNumber)) {
            return true;
        }
        if (orderPosition >= this.ordering.size()) {
            return false;
        }
        ColumnOrdering co = (ColumnOrdering)this.ordering.elementAt(orderPosition);
        return co.ordered(direction, tableNumber, columnNumber);
    }

    public boolean orderedOnColumn(int direction, int tableNumber, int columnNumber) throws StandardException {
        if (this.vectorContainsOptimizable(tableNumber, this.alwaysOrderedOptimizables)) {
            return true;
        }
        if (this.columnsAlwaysOrdered.contains(tableNumber, columnNumber)) {
            return true;
        }
        boolean ordered = false;
        for (int i = 0; i < this.ordering.size(); ++i) {
            ColumnOrdering co = (ColumnOrdering)this.ordering.elementAt(i);
            boolean thisOrdered = co.ordered(direction, tableNumber, columnNumber);
            if (!thisOrdered) continue;
            ordered = true;
            break;
        }
        return ordered;
    }

    private boolean vectorContainsOptimizable(int tableNumber, Vector vec) {
        for (int i = vec.size() - 1; i >= 0; --i) {
            Optimizable optTable = (Optimizable)vec.elementAt(i);
            if (!optTable.hasTableNumber() || optTable.getTableNumber() != tableNumber) continue;
            return true;
        }
        return false;
    }

    public void addOrderedColumn(int direction, int tableNumber, int columnNumber) {
        ColumnOrdering currentColumnOrdering;
        if (this.unorderedOptimizables.size() > 0) {
            return;
        }
        if (this.ordering.size() == 0) {
            currentColumnOrdering = new ColumnOrdering(direction);
            this.ordering.addElement(currentColumnOrdering);
        } else {
            currentColumnOrdering = (ColumnOrdering)this.ordering.elementAt(this.ordering.size() - 1);
        }
        if (currentColumnOrdering.direction() != direction) {
            SanityManager.THROWASSERT("direction == " + direction + ", currentColumnOrdering.direction() == " + currentColumnOrdering.direction());
        }
        currentColumnOrdering.addColumn(tableNumber, columnNumber);
    }

    public void nextOrderPosition(int direction) {
        if (this.unorderedOptimizables.size() > 0) {
            return;
        }
        this.currentColumnOrdering = new ColumnOrdering(direction);
        this.ordering.addElement(this.currentColumnOrdering);
    }

    public void optimizableAlwaysOrdered(Optimizable optimizable) {
        int tableNumber;
        if (this.unorderedOptimizablesOtherThan(optimizable)) {
            return;
        }
        boolean hasTableNumber = optimizable.hasTableNumber();
        int n = tableNumber = hasTableNumber ? optimizable.getTableNumber() : 0;
        if ((this.ordering.size() == 0 || hasTableNumber && ((ColumnOrdering)this.ordering.elementAt(0)).hasTable(tableNumber)) && hasTableNumber && !this.columnsAlwaysOrdered.hasAnyOtherTable(tableNumber)) {
            if (optimizable.hasTableNumber()) {
                this.removeOptimizable(optimizable.getTableNumber());
            }
            this.alwaysOrderedOptimizables.addElement(optimizable);
        }
    }

    public void columnAlwaysOrdered(Optimizable optimizable, int columnNumber) {
        this.columnsAlwaysOrdered.addColumn(optimizable.getTableNumber(), columnNumber);
    }

    public boolean alwaysOrdered(int tableNumber) {
        return this.vectorContainsOptimizable(tableNumber, this.alwaysOrderedOptimizables);
    }

    public void removeOptimizable(int tableNumber) {
        for (int i = this.ordering.size() - 1; i >= 0; --i) {
            ColumnOrdering ord = (ColumnOrdering)this.ordering.elementAt(i);
            ord.removeColumns(tableNumber);
            if (!ord.empty()) continue;
            this.ordering.removeElementAt(i);
        }
        this.columnsAlwaysOrdered.removeColumns(tableNumber);
        this.removeOptimizableFromVector(tableNumber, this.unorderedOptimizables);
        this.removeOptimizableFromVector(tableNumber, this.alwaysOrderedOptimizables);
    }

    private void removeOptimizableFromVector(int tableNumber, Vector vec) {
        for (int i = vec.size() - 1; i >= 0; --i) {
            Optimizable optTable = (Optimizable)vec.elementAt(i);
            if (!optTable.hasTableNumber() || optTable.getTableNumber() != tableNumber) continue;
            vec.removeElementAt(i);
        }
    }

    public void addUnorderedOptimizable(Optimizable optimizable) {
        this.unorderedOptimizables.addElement(optimizable);
    }

    public void copy(RowOrdering copyTo) {
        int i;
        if (!(copyTo instanceof RowOrderingImpl)) {
            SanityManager.THROWASSERT("copyTo should be a RowOrderingImpl, is a " + copyTo.getClass().getName());
        }
        RowOrderingImpl dest = (RowOrderingImpl)copyTo;
        dest.ordering.removeAllElements();
        dest.currentColumnOrdering = null;
        dest.unorderedOptimizables.removeAllElements();
        for (i = 0; i < this.unorderedOptimizables.size(); ++i) {
            dest.unorderedOptimizables.addElement(this.unorderedOptimizables.elementAt(i));
        }
        dest.alwaysOrderedOptimizables.removeAllElements();
        for (i = 0; i < this.alwaysOrderedOptimizables.size(); ++i) {
            dest.alwaysOrderedOptimizables.addElement(this.alwaysOrderedOptimizables.elementAt(i));
        }
        for (i = 0; i < this.ordering.size(); ++i) {
            ColumnOrdering co = (ColumnOrdering)this.ordering.elementAt(i);
            dest.ordering.addElement(co.cloneMe());
            if (co != this.currentColumnOrdering) continue;
            dest.rememberCurrentColumnOrdering(i);
        }
        dest.columnsAlwaysOrdered = null;
        if (this.columnsAlwaysOrdered != null) {
            dest.columnsAlwaysOrdered = this.columnsAlwaysOrdered.cloneMe();
        }
    }

    private void rememberCurrentColumnOrdering(int posn) {
        this.currentColumnOrdering = (ColumnOrdering)this.ordering.elementAt(posn);
    }

    public String toString() {
        Optimizable opt;
        int i;
        String retval = null;
        retval = "Unordered optimizables: ";
        for (i = 0; i < this.unorderedOptimizables.size(); ++i) {
            opt = (Optimizable)this.unorderedOptimizables.elementAt(i);
            retval = opt.getBaseTableName() != null ? retval + opt.getBaseTableName() : retval + this.unorderedOptimizables.elementAt(i).toString();
            retval = retval + " ";
        }
        retval = retval + "\n";
        retval = retval + "\nAlways ordered optimizables: ";
        for (i = 0; i < this.alwaysOrderedOptimizables.size(); ++i) {
            opt = (Optimizable)this.alwaysOrderedOptimizables.elementAt(i);
            retval = opt.getBaseTableName() != null ? retval + opt.getBaseTableName() : retval + this.alwaysOrderedOptimizables.elementAt(i).toString();
            retval = retval + " ";
        }
        retval = retval + "\n";
        for (i = 0; i < this.ordering.size(); ++i) {
            retval = retval + " ColumnOrdering " + i + ": " + this.ordering.elementAt(i);
        }
        return retval;
    }

    private boolean unorderedOptimizablesOtherThan(Optimizable optimizable) {
        for (int i = 0; i < this.unorderedOptimizables.size(); ++i) {
            Optimizable thisOpt = (Optimizable)this.unorderedOptimizables.elementAt(i);
            if (thisOpt == optimizable) continue;
            return true;
        }
        return false;
    }
}

