/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.sql.ResultSetMetaData;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.derby.catalog.types.DefaultInfoImpl;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.sql.compile.NodeFactory;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.DefaultDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.ConglomerateController;
import org.apache.derby.iapi.store.access.StoreCostController;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.iapi.util.ReuseFactory;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.AggregateNode;
import org.apache.derby.impl.sql.compile.AllResultColumn;
import org.apache.derby.impl.sql.compile.BaseColumnNode;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.CurrentRowLocationNode;
import org.apache.derby.impl.sql.compile.DMLStatementNode;
import org.apache.derby.impl.sql.compile.DefaultNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromVTI;
import org.apache.derby.impl.sql.compile.InsertNode;
import org.apache.derby.impl.sql.compile.OrderByColumn;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.QueryTreeNodeVector;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.TableElementList;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.UpdateNode;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.compile.VirtualColumnNode;

public class ResultColumnList
extends QueryTreeNodeVector {
    protected boolean indexRow;
    protected long conglomerateId;
    int orderBySelect = 0;
    protected boolean forUpdate;
    private boolean countMismatchAllowed;
    private int initialListSize = 0;

    public void addResultColumn(ResultColumn resultColumn) {
        resultColumn.setVirtualColumnId(this.size() + 1);
        this.addElement(resultColumn);
    }

    public void appendResultColumns(ResultColumnList resultColumns, boolean destructiveCopy) {
        int oldSize = this.size();
        int newID = oldSize + 1;
        int otherSize = resultColumns.size();
        for (int index = 0; index < otherSize; ++index) {
            ((ResultColumn)resultColumns.elementAt(index)).setVirtualColumnId(newID);
            ++newID;
        }
        if (destructiveCopy) {
            this.destructiveAppend(resultColumns);
        } else {
            this.nondestructiveAppend(resultColumns);
        }
    }

    public ResultColumn getResultColumn(int position) {
        ResultColumn rc;
        if (position <= this.size() && (rc = (ResultColumn)this.elementAt(position - 1)).getColumnPosition() == position) {
            return rc;
        }
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ResultColumn rc2 = (ResultColumn)this.elementAt(index);
            if (rc2.getColumnPosition() != position) continue;
            return rc2;
        }
        return null;
    }

    public ResultColumn getResultColumn(int colNum, ResultSetNode rsn, int[] whichRC) throws StandardException {
        if (colNum == -1) {
            return null;
        }
        ResultColumn rc = null;
        ColumnReference colRef = null;
        int[] crColNum = new int[]{-1};
        for (int index = this.size() - 1; index >= 0; --index) {
            rc = (ResultColumn)this.elementAt(index);
            if (!(rc.getExpression() instanceof ColumnReference) || rsn != (colRef = (ColumnReference)rc.getExpression()).getSourceResultSet(crColNum) || crColNum[0] != colNum) continue;
            whichRC[0] = index + 1;
            return rc;
        }
        return null;
    }

    public ResultColumn getOrderByColumn(int position) {
        if (position == 0) {
            return null;
        }
        return this.getResultColumn(position);
    }

    public ResultColumn getResultColumn(String columnName) {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(index);
            if (!columnName.equals(resultColumn.getName())) continue;
            resultColumn.setReferenced();
            return resultColumn;
        }
        return null;
    }

    public ResultColumn getResultColumn(String columnsTableName, String columnName) {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(index);
            if (columnsTableName != null && (resultColumn.getTableName() == null || !columnsTableName.equals(resultColumn.getTableName())) || !columnName.equals(resultColumn.getName())) continue;
            resultColumn.setReferenced();
            return resultColumn;
        }
        return null;
    }

    public ResultColumn getAtMostOneResultColumn(ColumnReference cr, String exposedTableName, boolean considerGeneratedColumns) throws StandardException {
        int size = this.size();
        ResultColumn retRC = null;
        String columnName = cr.getColumnName();
        for (int index = 0; index < size; ++index) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(index);
            if (!columnName.equals(resultColumn.getName()) || resultColumn.isGenerated() && !considerGeneratedColumns) continue;
            if (retRC != null) {
                throw StandardException.newException("42Y34", (Object)columnName, (Object)exposedTableName);
            }
            resultColumn.setReferenced();
            retRC = resultColumn;
        }
        return retRC;
    }

    public ResultColumn getOrderByColumnToBind(String columnName, TableName tableName, int tableNumber, OrderByColumn obc) throws StandardException {
        int size = this.size();
        ResultColumn retVal = null;
        for (int index = 0; index < size; ++index) {
            ColumnReference cr;
            ValueNode rcExpr;
            ResultColumn resultColumn = (ResultColumn)this.elementAt(index);
            if (tableName != null && (!((rcExpr = resultColumn.getExpression()) instanceof ColumnReference) || !tableName.equals((cr = (ColumnReference)rcExpr).getTableNameNode()) && tableNumber != cr.getTableNumber()) || !columnName.equals(resultColumn.getName())) continue;
            if (retVal == null) {
                retVal = resultColumn;
                continue;
            }
            if (!retVal.isEquivalent(resultColumn)) {
                throw StandardException.newException("42X79", columnName);
            }
            if (index < size - this.orderBySelect) continue;
            this.removeElement(resultColumn);
            this.decOrderBySelect();
            obc.clearAddedColumnOffset();
            this.collapseVirtualColumnIdGap(resultColumn.getColumnPosition());
            break;
        }
        return retVal;
    }

    private void collapseVirtualColumnIdGap(int gap) {
        for (int index = 0; index < this.size(); ++index) {
            ((ResultColumn)this.elementAt(index)).collapseVirtualColumnIdGap(gap);
        }
    }

    public ResultColumn findResultColumnForOrderBy(String columnName, TableName tableName) throws StandardException {
        int size = this.size();
        ResultColumn retVal = null;
        for (int index = 0; index < size; ++index) {
            ColumnReference cr;
            ValueNode rcExpr;
            ResultColumn resultColumn = (ResultColumn)this.elementAt(index);
            if (tableName != null && ((rcExpr = resultColumn.getExpression()) == null || !(rcExpr instanceof ColumnReference) || !tableName.equals((cr = (ColumnReference)rcExpr).getTableNameNode())) || !columnName.equals(resultColumn.getName())) continue;
            if (retVal == null) {
                retVal = resultColumn;
                continue;
            }
            if (!retVal.isEquivalent(resultColumn)) {
                throw StandardException.newException("42X79", columnName);
            }
            if (index < size - this.orderBySelect) continue;
            SanityManager.THROWASSERT("Unexpectedly found ORDER BY column '" + columnName + "' pulled up at position " + index);
        }
        return retVal;
    }

    void copyResultColumnNames(ResultColumnList nameList) {
        if (!this.countMismatchAllowed && this.size() != nameList.size()) {
            SanityManager.THROWASSERT("The size of the 2 lists is expected to be the same. size() = " + this.size() + ", nameList.size() = " + nameList.size());
        }
        int size = this.countMismatchAllowed ? nameList.size() : this.size();
        for (int index = 0; index < size; ++index) {
            ResultColumn thisResultColumn = (ResultColumn)this.elementAt(index);
            ResultColumn nameListResultColumn = (ResultColumn)nameList.elementAt(index);
            thisResultColumn.setName(nameListResultColumn.getName());
            thisResultColumn.setNameGenerated(nameListResultColumn.isNameGenerated());
        }
    }

    public void treePrint(int depth) {
        for (int index = 0; index < this.size(); ++index) {
            ((ResultColumn)this.elementAt(index)).treePrint(depth);
        }
    }

    public void bindExpressions(FromList fromList, SubqueryList subqueryList, Vector aggregateVector) throws StandardException {
        this.expandAllsAndNameColumns(fromList);
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ValueNode vn = (ValueNode)this.elementAt(index);
            vn = ((ResultColumn)vn).bindExpression(fromList, subqueryList, aggregateVector);
            this.setElementAt(vn, index);
        }
    }

    public void bindResultColumnsToExpressions() throws StandardException {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ((ResultColumn)this.elementAt(index)).bindResultColumnToExpression();
        }
    }

    public void bindResultColumnsByName(TableDescriptor targetTableDescriptor) throws StandardException {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ResultColumn rc = (ResultColumn)this.elementAt(index);
            rc.bindResultColumnByName(targetTableDescriptor, index + 1);
        }
    }

    public FormatableBitSet bindResultColumnsByName(TableDescriptor targetTableDescriptor, DMLStatementNode statement) throws StandardException {
        int size = this.size();
        FormatableBitSet columnBitSet = new FormatableBitSet(targetTableDescriptor.getNumberOfColumns());
        for (int index = 0; index < size; ++index) {
            ResultColumn rc = (ResultColumn)this.elementAt(index);
            rc.bindResultColumnByName(targetTableDescriptor, index + 1);
            int colIdx = rc.getColumnPosition() - 1;
            SanityManager.ASSERT(colIdx >= 0 && colIdx < targetTableDescriptor.getNumberOfColumns(), "Invalid column position found for " + rc.getName());
            if (statement != null && columnBitSet.isSet(colIdx)) {
                String colName = rc.getName();
                if (statement instanceof UpdateNode) {
                    throw StandardException.newException("42X16", colName);
                }
                throw StandardException.newException("42X13", colName);
            }
            columnBitSet.set(colIdx);
        }
        return columnBitSet;
    }

    public void bindResultColumnsByName(ResultColumnList fullRCL, FromVTI targetVTI, DMLStatementNode statement) throws StandardException {
        int size = this.size();
        Hashtable<String, String> ht = new Hashtable<String, String>(size + 2, 0.999f);
        for (int index = 0; index < size; ++index) {
            ResultColumn rc = (ResultColumn)this.elementAt(index);
            String colName = rc.getName();
            String object = ht.put(colName, colName);
            if (object != null && object.equals(colName)) {
                SanityManager.ASSERT(statement instanceof UpdateNode || statement instanceof InsertNode, "statement is expected to be instanceof UpdateNode or InsertNode");
                if (statement instanceof UpdateNode) {
                    throw StandardException.newException("42X16", colName);
                }
                throw StandardException.newException("42X13", colName);
            }
            ResultColumn matchRC = fullRCL.getResultColumn(null, rc.getName());
            if (matchRC == null) {
                throw StandardException.newException("42X14", (Object)rc.getName(), (Object)targetVTI.getNewInvocation().getJavaClassName());
            }
            ColumnDescriptor cd = new ColumnDescriptor(rc.getName(), matchRC.getVirtualColumnId(), matchRC.getType(), null, null, null, null, 0L, 0L);
            rc.setColumnDescriptor(null, cd);
            rc.setVirtualColumnId(index + 1);
        }
    }

    public void bindResultColumnsByPosition(TableDescriptor targetTableDescriptor) throws StandardException {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ((ResultColumn)this.elementAt(index)).bindResultColumnByPosition(targetTableDescriptor, index + 1);
        }
    }

    public void preprocess(int numTables, FromList outerFromList, SubqueryList outerSubqueryList, PredicateList outerPredicateList) throws StandardException {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(index);
            this.setElementAt(resultColumn.preprocess(numTables, outerFromList, outerSubqueryList, outerPredicateList), index);
        }
    }

    void checkStorableExpressions(ResultColumnList toStore) throws StandardException {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ResultColumn otherRC = (ResultColumn)toStore.elementAt(index);
            ((ResultColumn)this.elementAt(index)).checkStorableExpression(otherRC);
        }
    }

    public int[] getStreamStorableColIds(int heapColCount) throws StandardException {
        int ssCount = 0;
        boolean[] isSS = new boolean[heapColCount];
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ResultColumn rc = (ResultColumn)this.elementAt(index);
            if (!rc.getTypeId().streamStorable()) continue;
            ColumnDescriptor cd = rc.getTableColumnDescriptor();
            isSS[cd.getPosition() - 1] = true;
        }
        for (int ix = 0; ix < isSS.length; ++ix) {
            if (!isSS[ix]) continue;
            ++ssCount;
        }
        if (ssCount == 0) {
            return null;
        }
        int[] result = new int[ssCount];
        int resultOffset = 0;
        for (int heapOffset = 0; heapOffset < isSS.length; ++heapOffset) {
            if (!isSS[heapOffset]) continue;
            result[resultOffset++] = heapOffset;
        }
        return result;
    }

    void checkStorableExpressions() throws StandardException {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ((ResultColumn)this.elementAt(index)).checkStorableExpression();
        }
    }

    public void generate(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        this.generateCore(acb, mb, false);
    }

    void generateNulls(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        this.generateCore(acb, mb, true);
    }

    void generateCore(ExpressionClassBuilder acb, MethodBuilder mb, boolean genNulls) throws StandardException {
        MethodBuilder userExprFun = acb.newUserExprFun();
        LocalField field = acb.newFieldDeclaration(2, "org.apache.derby.iapi.sql.execute.ExecRow");
        this.genCreateRow(acb, field, "getValueRow", "org.apache.derby.iapi.sql.execute.ExecRow", this.size());
        int size = this.size();
        MethodBuilder cb = acb.getConstructor();
        for (int index = 0; index < size; ++index) {
            ValueNode sourceExpr;
            ResultColumn rc = (ResultColumn)this.elementAt(index);
            if (!genNulls && ((sourceExpr = rc.getExpression()) instanceof VirtualColumnNode && !((VirtualColumnNode)sourceExpr).getCorrelated() || sourceExpr instanceof ColumnReference && !((ColumnReference)sourceExpr).getCorrelated())) continue;
            if (index + 1 != rc.getVirtualColumnId()) {
                SanityManager.THROWASSERT("VirtualColumnId (" + rc.getVirtualColumnId() + ") does not agree with position within Vector (" + (index + 1) + ")");
            }
            if (!genNulls && rc.getExpression() instanceof ConstantNode && !((ConstantNode)rc.getExpression()).isNull() && !cb.statementNumHitLimit(1)) {
                cb.getField(field);
                cb.push(index + 1);
                rc.generateExpression(acb, cb);
                cb.cast("org.apache.derby.iapi.types.DataValueDescriptor");
                cb.callMethod((short)185, "org.apache.derby.iapi.sql.Row", "setColumn", "void", 2);
                continue;
            }
            userExprFun.getField(field);
            userExprFun.push(index + 1);
            boolean needDVDCast = true;
            if (rc.isAutoincrementGenerated()) {
                userExprFun.pushThis();
                userExprFun.push(rc.getColumnPosition());
                userExprFun.push(rc.getTableColumnDescriptor().getAutoincInc());
                userExprFun.callMethod((short)182, "org.apache.derby.impl.sql.execute.BaseActivation", "getSetAutoincrementValue", "org.apache.derby.iapi.types.DataValueDescriptor", 2);
                needDVDCast = false;
            } else if (genNulls || rc.getExpression() instanceof ConstantNode && ((ConstantNode)rc.getExpression()).isNull()) {
                userExprFun.getField(field);
                userExprFun.push(index + 1);
                userExprFun.callMethod((short)185, "org.apache.derby.iapi.sql.Row", "getColumn", "org.apache.derby.iapi.types.DataValueDescriptor", 1);
                acb.generateNullWithExpress(userExprFun, rc.getTypeCompiler(), rc.getTypeServices().getCollationType());
            } else {
                rc.generateExpression(acb, userExprFun);
            }
            if (needDVDCast) {
                userExprFun.cast("org.apache.derby.iapi.types.DataValueDescriptor");
            }
            userExprFun.callMethod((short)185, "org.apache.derby.iapi.sql.Row", "setColumn", "void", 2);
        }
        userExprFun.getField(field);
        userExprFun.methodReturn();
        userExprFun.complete();
        acb.pushMethodReference(mb, userExprFun);
    }

    public ExecRow buildEmptyRow() throws StandardException {
        int columnCount = this.size();
        ExecRow row = this.getExecutionFactory().getValueRow(columnCount);
        int position = 1;
        for (int index = 0; index < columnCount; ++index) {
            ResultColumn rc = (ResultColumn)this.elementAt(index);
            DataTypeDescriptor dataType = rc.getTypeServices();
            DataValueDescriptor dataValue = dataType.getNull();
            row.setColumn(position++, dataValue);
        }
        return row;
    }

    public ExecRow buildEmptyIndexRow(TableDescriptor td, ConglomerateDescriptor cd, StoreCostController scc, DataDictionary dd) throws StandardException {
        if (!cd.isIndex()) {
            SanityManager.THROWASSERT("ConglomerateDescriptor expected to be for index: " + cd);
        }
        int[] baseCols = cd.getIndexDescriptor().baseColumnPositions();
        ExecRow row = this.getExecutionFactory().getValueRow(baseCols.length + 1);
        for (int i = 0; i < baseCols.length; ++i) {
            ColumnDescriptor coldes = td.getColumnDescriptor(baseCols[i]);
            DataTypeDescriptor dataType = coldes.getType();
            DataValueDescriptor dataValue = dataType.getNull();
            row.setColumn(i + 1, dataValue);
        }
        RowLocation rlTemplate = scc.newRowLocationTemplate();
        row.setColumn(baseCols.length + 1, rlTemplate);
        return row;
    }

    void generateHolder(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        this.generateHolder(acb, mb, null, null);
    }

    void generateHolder(ExpressionClassBuilder acb, MethodBuilder mb, FormatableBitSet referencedCols, FormatableBitSet propagatedCols) throws StandardException {
        acb.pushMethodReference(mb, this.generateHolderMethod(acb, referencedCols, propagatedCols));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MethodBuilder generateHolderMethod(ExpressionClassBuilder acb, FormatableBitSet referencedCols, FormatableBitSet propagatedCols) throws StandardException {
        String rowAllocatorType;
        String rowAllocatorMethod;
        int highestColumnNumber = -1;
        if (referencedCols != null) {
            int i = referencedCols.anySetBit();
            while (i != -1) {
                highestColumnNumber = i;
                i = referencedCols.anySetBit(i);
            }
        } else {
            highestColumnNumber = this.size() - 1;
        }
        MethodBuilder exprFun = acb.newExprFun();
        if (this.indexRow) {
            rowAllocatorMethod = "getIndexableRow";
            rowAllocatorType = "org.apache.derby.iapi.sql.execute.ExecIndexRow";
        } else {
            rowAllocatorMethod = "getValueRow";
            rowAllocatorType = "org.apache.derby.iapi.sql.execute.ExecRow";
        }
        int numCols = this.size();
        LocalField lf = acb.newFieldDeclaration(2, "org.apache.derby.iapi.sql.execute.ExecRow");
        this.genCreateRow(acb, lf, rowAllocatorMethod, rowAllocatorType, highestColumnNumber + 1);
        int colNum = referencedCols != null ? referencedCols.anySetBit() : 0;
        for (int index = 0; index < numCols; ++index) {
            ValueNode sourceExpr;
            ResultColumn rc = (ResultColumn)this.elementAt(index);
            if (rc.getExpression() instanceof CurrentRowLocationNode) {
                RowLocation rl;
                ConglomerateController cc = null;
                cc = this.getLanguageConnectionContext().getTransactionCompile().openConglomerate(this.conglomerateId, false, 0, 6, 2);
                try {
                    rl = cc.newRowLocationTemplate();
                }
                finally {
                    if (cc != null) {
                        cc.close();
                    }
                }
                int savedItem = acb.addItem(rl);
                exprFun.getField(lf);
                exprFun.push(highestColumnNumber + 1);
                exprFun.pushThis();
                exprFun.push(savedItem);
                exprFun.callMethod((short)185, "org.apache.derby.iapi.sql.Activation", "getRowLocationTemplate", "org.apache.derby.iapi.types.RowLocation", 1);
                exprFun.upCast("org.apache.derby.iapi.types.DataValueDescriptor");
                exprFun.callMethod((short)185, "org.apache.derby.iapi.sql.Row", "setColumn", "void", 2);
                continue;
            }
            if (propagatedCols != null && propagatedCols.getNumBitsSet() != 0 && (sourceExpr = rc.getExpression()) instanceof VirtualColumnNode) continue;
            exprFun.getField(lf);
            exprFun.push(colNum + 1);
            rc.generateHolder(acb, exprFun);
            exprFun.callMethod((short)185, "org.apache.derby.iapi.sql.Row", "setColumn", "void", 2);
            if (referencedCols != null) {
                colNum = referencedCols.anySetBit(colNum);
                continue;
            }
            ++colNum;
        }
        exprFun.getField(lf);
        exprFun.methodReturn();
        exprFun.complete();
        return exprFun;
    }

    private void genCreateRow(ExpressionClassBuilder acb, LocalField field, String rowAllocatorMethod, String rowAllocatorType, int numCols) throws StandardException {
        MethodBuilder cb = acb.getConstructor();
        acb.pushGetExecutionFactoryExpression(cb);
        cb.push(numCols);
        cb.callMethod((short)185, null, rowAllocatorMethod, rowAllocatorType, 1);
        cb.setField(field);
        cb.statementNumHitLimit(1);
    }

    public ResultColumnDescriptor[] makeResultDescriptors() {
        ResultColumnDescriptor[] colDescs = new ResultColumnDescriptor[this.size()];
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            colDescs[index] = this.getExecutionFactory().getResultColumnDescriptor((ResultColumnDescriptor)((Object)this.elementAt(index)));
        }
        return colDescs;
    }

    public void expandAllsAndNameColumns(FromList fromList) throws StandardException {
        boolean expanded = false;
        for (int index = 0; index < this.size(); ++index) {
            ResultColumn rc = (ResultColumn)this.elementAt(index);
            if (rc instanceof AllResultColumn) {
                TableName fullTableName;
                expanded = true;
                TableName temp = rc.getTableNameObject();
                if (temp != null) {
                    String sName = temp.getSchemaName();
                    String tName = temp.getTableName();
                    fullTableName = this.makeTableName(sName, tName);
                } else {
                    fullTableName = null;
                }
                ResultColumnList allExpansion = fromList.expandAll(fullTableName);
                allExpansion.nameAllResultColumns();
                this.removeElementAt(index);
                for (int inner = 0; inner < allExpansion.size(); ++inner) {
                    this.insertElementAt(allExpansion.elementAt(inner), index + inner);
                }
                this.markInitialSize();
                continue;
            }
            rc.guaranteeColumnName();
        }
        if (expanded) {
            int size = this.size();
            for (int index = 0; index < size; ++index) {
                ((ResultColumn)this.elementAt(index)).setVirtualColumnId(index + 1);
            }
        }
    }

    public void nameAllResultColumns() throws StandardException {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(index);
            resultColumn.guaranteeColumnName();
        }
    }

    public void copyTypesAndLengthsToSource(ResultColumnList sourceRCL) throws StandardException {
        int size = Math.min(this.size(), sourceRCL.size());
        for (int index = 0; index < size; ++index) {
            ResultColumn sourceRC = (ResultColumn)sourceRCL.elementAt(index);
            ResultColumn resultColumn = (ResultColumn)this.elementAt(index);
            sourceRC.setType(resultColumn.getTypeServices());
            sourceRC.getExpression().setType(resultColumn.getTypeServices());
        }
    }

    boolean columnTypesAndLengthsMatch() throws StandardException {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(index);
            if (resultColumn.isGenerated() || resultColumn.columnTypeAndLengthMatch()) continue;
            return false;
        }
        return true;
    }

    boolean columnTypesAndLengthsMatch(ResultColumnList otherRCL) throws StandardException {
        boolean retval = true;
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(index);
            ResultColumn otherResultColumn = (ResultColumn)otherRCL.elementAt(index);
            if (resultColumn.isGenerated() || otherResultColumn.isGenerated() || resultColumn.columnTypeAndLengthMatch(otherResultColumn)) continue;
            retval = false;
        }
        return retval;
    }

    public boolean nopProjection(ResultColumnList childRCL) {
        if (this.size() != childRCL.size()) {
            return false;
        }
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ResultColumn thisColumn = (ResultColumn)this.elementAt(index);
            ResultColumn referencedColumn = null;
            if (thisColumn.getExpression() instanceof VirtualColumnNode) {
                referencedColumn = ((VirtualColumnNode)thisColumn.getExpression()).getSourceColumn();
            } else if (thisColumn.getExpression() instanceof ColumnReference) {
                referencedColumn = ((ColumnReference)thisColumn.getExpression()).getSource();
            } else {
                return false;
            }
            ResultColumn childColumn = (ResultColumn)childRCL.elementAt(index);
            if (referencedColumn == childColumn) continue;
            return false;
        }
        return true;
    }

    public ResultColumnList copyListAndObjects() throws StandardException {
        ResultColumnList newList = (ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager());
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ResultColumn origResultColumn = (ResultColumn)this.elementAt(index);
            ResultColumn newResultColumn = origResultColumn.cloneMe();
            newList.addResultColumn(newResultColumn);
        }
        newList.copyOrderBySelect(this);
        return newList;
    }

    public void removeOrderByColumns() {
        int idx = this.size() - 1;
        int i = 0;
        while (i < this.orderBySelect) {
            this.removeElementAt(idx);
            ++i;
            --idx;
        }
        this.orderBySelect = 0;
    }

    public void genVirtualColumnNodes(ResultSetNode sourceResultSet, ResultColumnList sourceResultColumnList) throws StandardException {
        this.genVirtualColumnNodes(sourceResultSet, sourceResultColumnList, true);
    }

    public void genVirtualColumnNodes(ResultSetNode sourceResultSet, ResultColumnList sourceResultColumnList, boolean markReferenced) throws StandardException {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(index);
            DataTypeDescriptor dts = resultColumn.getTypeServices();
            resultColumn.expression = (ValueNode)this.getNodeFactory().getNode(107, sourceResultSet, sourceResultColumnList.elementAt(index), ReuseFactory.getInteger(index + 1), this.getContextManager());
            if (!markReferenced) continue;
            resultColumn.setReferenced();
        }
    }

    public void adjustVirtualColumnIds(int adjust) {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(index);
            resultColumn.adjustVirtualColumnId(adjust);
            if (!(resultColumn.getExpression() instanceof VirtualColumnNode)) {
                SanityManager.THROWASSERT("resultColumn.getExpression() is expected to be instanceof VirtualColumnNode not " + resultColumn.getExpression().getClass().getName());
            }
            ((VirtualColumnNode)resultColumn.getExpression()).columnId += adjust;
        }
    }

    public void doProjection() throws StandardException {
        int index;
        int numDeleted = 0;
        int size = this.size();
        ResultColumnList deletedRCL = new ResultColumnList();
        for (index = 0; index < size; ++index) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(index);
            if (!resultColumn.isReferenced() && resultColumn.getExpression() instanceof VirtualColumnNode && !((VirtualColumnNode)resultColumn.getExpression()).getSourceColumn().isReferenced()) {
                deletedRCL.addElement(resultColumn);
                ++numDeleted;
                continue;
            }
            if (numDeleted >= 1) {
                resultColumn.adjustVirtualColumnId(-numDeleted);
            }
            resultColumn.setReferenced();
        }
        for (index = 0; index < deletedRCL.size(); ++index) {
            this.removeElement((ResultColumn)deletedRCL.elementAt(index));
        }
    }

    public String verifyUniqueNames(boolean errForGenCols) throws StandardException {
        int size = this.size();
        Hashtable<String, String> ht = new Hashtable<String, String>(size + 2, 0.999f);
        for (int index = 0; index < size; ++index) {
            ResultColumn rc = (ResultColumn)this.elementAt(index);
            if (errForGenCols && rc.isNameGenerated()) {
                throw StandardException.newException("42908");
            }
            String colName = ((ResultColumn)this.elementAt(index)).getName();
            String object = ht.put(colName, colName);
            if (object == null || !object.equals(colName)) continue;
            return colName;
        }
        return null;
    }

    public void propagateDCLInfo(ResultColumnList derivedRCL, String tableName) throws StandardException {
        if (derivedRCL.size() != this.size() && !derivedRCL.getCountMismatchAllowed() && this.visibleSize() != derivedRCL.size()) {
            throw StandardException.newException("42X32", tableName);
        }
        String duplicateColName = derivedRCL.verifyUniqueNames(false);
        if (duplicateColName != null) {
            throw StandardException.newException("42X33", duplicateColName);
        }
        this.copyResultColumnNames(derivedRCL);
    }

    void rejectParameters() throws StandardException {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ResultColumn rc = (ResultColumn)this.elementAt(index);
            rc.rejectParameter();
        }
    }

    void rejectXMLValues() throws StandardException {
        int sz = this.size();
        ResultColumn rc = null;
        for (int i = 1; i <= sz; ++i) {
            if (i > this.initialListSize || (rc = this.getResultColumn(i)) == null || rc.getType() == null || !rc.getType().getTypeId().isXMLTypeId()) continue;
            throw StandardException.newException("42Z71");
        }
    }

    public void setResultSetNumber(int resultSetNumber) {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ((ResultColumn)this.elementAt(index)).setResultSetNumber(resultSetNumber);
        }
    }

    public void setRedundant() {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ((ResultColumn)this.elementAt(index)).setRedundant();
        }
    }

    public void checkColumnUpdateability(String[] ucl, String cursorName) throws StandardException {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(index);
            if (!resultColumn.updated() || resultColumn.foundInList(ucl)) continue;
            throw StandardException.newException("42X31", (Object)resultColumn.getName(), (Object)cursorName);
        }
    }

    public void setUnionResultExpression(ResultColumnList otherRCL, int tableNumber, int level, String operatorName) throws StandardException {
        if (this.visibleSize() != otherRCL.visibleSize()) {
            SanityManager.THROWASSERT("size() = (" + this.size() + ") is expected to equal otherRCL.size (" + otherRCL.size() + ")");
        }
        TableName dummyTN = (TableName)this.getNodeFactory().getNode(34, null, null, this.getContextManager());
        ContextManager cm = this.getContextManager();
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            TypeId otherTypeId;
            TypeId thisTypeId;
            ResultColumn thisRC = (ResultColumn)this.elementAt(index);
            ResultColumn otherRC = (ResultColumn)otherRCL.elementAt(index);
            ValueNode thisExpr = thisRC.getExpression();
            ValueNode otherExpr = otherRC.getExpression();
            if (!otherRC.isAutoincrementGenerated() && thisRC.isAutoincrementGenerated()) {
                thisRC.resetAutoincrementGenerated();
            }
            if ((thisTypeId = thisExpr.getTypeId()) == null || (otherTypeId = otherExpr.getTypeId()) == null) continue;
            ClassFactory cf = this.getClassFactory();
            if (!thisExpr.getTypeCompiler().storable(otherTypeId, cf) && !otherExpr.getTypeCompiler().storable(thisTypeId, cf)) {
                throw StandardException.newException("42X61", (Object)thisTypeId.getSQLTypeName(), (Object)otherTypeId.getSQLTypeName(), (Object)operatorName);
            }
            DataTypeDescriptor resultType = thisExpr.getTypeServices().getDominantType(otherExpr.getTypeServices(), cf);
            ColumnReference newCR = (ColumnReference)this.getNodeFactory().getNode(62, thisRC.getName(), dummyTN, this.getContextManager());
            newCR.setType(resultType);
            if (thisExpr instanceof ColumnReference) {
                newCR.copyFields((ColumnReference)thisExpr);
            } else {
                newCR.setNestingLevel(level);
                newCR.setSourceLevel(level);
            }
            newCR.setTableNumber(tableNumber);
            thisRC.setExpression(newCR);
            thisRC.setType(thisRC.getTypeServices().getDominantType(otherRC.getTypeServices(), cf));
            if (thisRC.getName() == null || thisRC.isNameGenerated() || otherRC.getName() == null) continue;
            if (otherRC.isNameGenerated()) {
                thisRC.setName(otherRC.getName());
                thisRC.setNameGenerated(true);
                continue;
            }
            if (thisRC.getName().equals(otherRC.getName())) continue;
            thisRC.setName(null);
            thisRC.guaranteeColumnName();
            thisRC.setNameGenerated(true);
        }
    }

    public boolean isExactTypeAndLengthMatch(ResultColumnList otherRCL) throws StandardException {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ResultColumn thisRC = (ResultColumn)this.elementAt(index);
            ResultColumn otherRC = (ResultColumn)otherRCL.elementAt(index);
            if (thisRC.getTypeServices().isExactTypeAndLengthMatch(otherRC.getTypeServices())) continue;
            return false;
        }
        return true;
    }

    public boolean updateOverlaps(int[] columns) {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ResultColumn rc = (ResultColumn)this.elementAt(index);
            if (!rc.updated()) continue;
            int column = rc.getColumnPosition();
            for (int i = 0; i < columns.length; ++i) {
                if (columns[i] != column) continue;
                return true;
            }
        }
        return false;
    }

    ResultColumn[] getSortedByPosition() {
        int size = this.size();
        Object[] result = new ResultColumn[size];
        for (int index = 0; index < size; ++index) {
            result[index] = (ResultColumn)this.elementAt(index);
        }
        Arrays.sort(result);
        return result;
    }

    public int[] sortMe() {
        ResultColumn[] sortedResultColumns = this.getSortedByPosition();
        int[] sortedColumnIds = new int[sortedResultColumns.length];
        for (int ix = 0; ix < sortedResultColumns.length; ++ix) {
            sortedColumnIds[ix] = sortedResultColumns[ix].getColumnPosition();
        }
        return sortedColumnIds;
    }

    public ResultColumnList expandToAll(TableDescriptor td, TableName tableName) throws StandardException {
        ResultColumnList retval = (ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager());
        ResultColumn[] originalRCS = this.getSortedByPosition();
        int posn = 0;
        ColumnDescriptorList cdl = td.getColumnDescriptorList();
        int cdlSize = cdl.size();
        for (int index = 0; index < cdlSize; ++index) {
            ResultColumn rc;
            ColumnDescriptor cd = cdl.elementAt(index);
            if (posn < originalRCS.length && cd.getPosition() == originalRCS[posn].getColumnPosition()) {
                rc = originalRCS[posn];
                ++posn;
            } else {
                rc = this.makeColumnReferenceFromName(tableName, cd.getColumnName());
                rc.bindResultColumnByPosition(td, cd.getPosition());
            }
            retval.addResultColumn(rc);
        }
        SanityManager.ASSERT(posn == originalRCS.length, "ResultColumns in original list not added to expanded ResultColumnList");
        return retval;
    }

    public void bindUntypedNullsToResultColumns(ResultColumnList bindingRCL) throws StandardException {
        if (bindingRCL == null) {
            throw StandardException.newException("42X07");
        }
        SanityManager.ASSERT(bindingRCL.size() >= this.size(), "More columns in result column list than in base table");
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ResultColumn bindingRC = (ResultColumn)bindingRCL.elementAt(index);
            ResultColumn thisRC = (ResultColumn)this.elementAt(index);
            thisRC.typeUntypedNullExpression(bindingRC);
        }
    }

    void markUpdated() {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ((ResultColumn)this.elementAt(index)).markUpdated();
        }
    }

    void markUpdatableByCursor() {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            if (((ResultColumn)this.elementAt(index)).getSourceTableName() == null) continue;
            ((ResultColumn)this.elementAt(index)).markUpdatableByCursor();
        }
    }

    public void disablePrivilegeCollection() {
        super.disablePrivilegeCollection();
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ((ResultColumn)this.elementAt(index)).disablePrivilegeCollection();
        }
    }

    public String verifyCreateConstraintColumnList(TableElementList tel) {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            String colName = ((ResultColumn)this.elementAt(index)).getName();
            if (tel.containsColumnName(colName)) continue;
            return colName;
        }
        return null;
    }

    public void exportNames(String[] columnNames) {
        if (this.size() != columnNames.length) {
            SanityManager.THROWASSERT("size() (" + this.size() + ") is expected to equal columnNames.length (" + columnNames.length + ")");
        }
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            columnNames[index] = ((ResultColumn)this.elementAt(index)).getName();
        }
    }

    public ResultColumn findParentResultColumn(ResultColumn childRC) {
        ResultColumn parentRC = null;
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            VirtualColumnNode vcn;
            ResultColumn rc = (ResultColumn)this.elementAt(index);
            if (rc.getExpression() instanceof ColumnReference) {
                ColumnReference cr = (ColumnReference)rc.getExpression();
                if (cr.getSource() != childRC) continue;
                parentRC = rc;
                break;
            }
            if (!(rc.getExpression() instanceof VirtualColumnNode) || (vcn = (VirtualColumnNode)rc.getExpression()).getSourceColumn() != childRC) continue;
            parentRC = rc;
            break;
        }
        return parentRC;
    }

    void markUpdated(ResultColumnList updateColumns) {
        int size = updateColumns.size();
        for (int index = 0; index < size; ++index) {
            ResultColumn updateColumn = (ResultColumn)updateColumns.elementAt(index);
            ResultColumn resultColumn = this.getResultColumn(updateColumn.getName());
            if (resultColumn == null) continue;
            resultColumn.markUpdated();
        }
    }

    void markColumnsInSelectListUpdatableByCursor(Vector updateColumns) {
        this.commonCodeForUpdatableByCursor(updateColumns, true);
    }

    private void commonCodeForUpdatableByCursor(Vector updateColumns, boolean dealingWithSelectResultColumnList) {
        if (updateColumns == null || updateColumns.size() == 0) {
            this.markUpdatableByCursor();
        } else {
            int ucSize = updateColumns.size();
            for (int index = 0; index < ucSize; ++index) {
                String columnName = (String)updateColumns.elementAt(index);
                ResultColumn resultColumn = this.getResultColumn(columnName);
                if (resultColumn == null && !dealingWithSelectResultColumnList) {
                    SanityManager.THROWASSERT("No result column found with name " + columnName);
                }
                if (resultColumn == null && dealingWithSelectResultColumnList) continue;
                resultColumn.markUpdatableByCursor();
            }
        }
    }

    void markUpdatableByCursor(Vector updateColumns) {
        this.commonCodeForUpdatableByCursor(updateColumns, false);
    }

    boolean updatableByCursor(int columnPosition) {
        return this.getResultColumn(columnPosition).updatableByCursor();
    }

    public boolean isCloneable() {
        boolean retcode = true;
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ResultColumn rc = (ResultColumn)this.elementAt(index);
            if (rc.getExpression().isCloneable()) continue;
            retcode = false;
            break;
        }
        return retcode;
    }

    public void remapColumnReferencesToExpressions() throws StandardException {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ResultColumn rc = (ResultColumn)this.elementAt(index);
            if (rc.getExpression() == null) continue;
            rc.setExpression(rc.getExpression().remapColumnReferencesToExpressions());
        }
    }

    void setIndexRow(long cid, boolean forUpdate) {
        this.indexRow = true;
        this.conglomerateId = cid;
        this.forUpdate = forUpdate;
    }

    public boolean hasConsistentTypeInfo() throws StandardException {
        boolean isConsistent = true;
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ResultColumn rc = (ResultColumn)this.elementAt(index);
            ValueNode expr = rc.getExpression();
            DataTypeDescriptor rcDTS = rc.getTypeServices();
            DataTypeDescriptor exDTS = expr.getTypeServices();
            if (rcDTS == null || exDTS == null) {
                isConsistent = false;
                break;
            }
            if (rcDTS.getClass().getName() == exDTS.getClass().getName()) continue;
            isConsistent = false;
            break;
        }
        return isConsistent;
    }

    public boolean containsAllResultColumn() {
        boolean containsAllResultColumn = false;
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            if (!(this.elementAt(index) instanceof AllResultColumn)) continue;
            containsAllResultColumn = true;
            break;
        }
        return containsAllResultColumn;
    }

    public int countReferencedColumns() {
        int numReferenced = 0;
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ResultColumn rc = (ResultColumn)this.elementAt(index);
            if (!rc.isReferenced()) continue;
            ++numReferenced;
        }
        return numReferenced;
    }

    public void recordColumnReferences(int[] idArray, int basis) {
        int currArrayElement = 0;
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ResultColumn rc = (ResultColumn)this.elementAt(index);
            if (!rc.isReferenced()) continue;
            idArray[currArrayElement++] = index + basis;
        }
    }

    public void recordColumnReferences(boolean[] colArray1, JBitSet[] tableColMap, int tableNumber) {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ResultColumn rc = (ResultColumn)this.elementAt(index);
            if (!(rc.getExpression() instanceof ColumnReference)) continue;
            int columnNumber = ((ColumnReference)rc.getExpression()).getColumnNumber();
            colArray1[columnNumber] = true;
            tableColMap[tableNumber].set(columnNumber);
        }
    }

    int allTopCRsFromSameTable() {
        int tableNumber = -1;
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ResultColumn rc = (ResultColumn)this.elementAt(index);
            ValueNode vn = rc.getExpression();
            if (!(vn instanceof ColumnReference)) continue;
            ColumnReference cr = (ColumnReference)vn;
            if (tableNumber == -1) {
                tableNumber = cr.getTableNumber();
                continue;
            }
            if (tableNumber == cr.getTableNumber()) continue;
            return -1;
        }
        return tableNumber;
    }

    public void clearColumnReferences() {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ResultColumn rc = (ResultColumn)this.elementAt(index);
            if (!rc.isReferenced()) continue;
            rc.setUnreferenced();
        }
    }

    public void copyReferencedColumnsToNewList(ResultColumnList targetList) {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ResultColumn rc = (ResultColumn)this.elementAt(index);
            if (!rc.isReferenced()) continue;
            targetList.addElement(rc);
        }
    }

    public void copyColumnsToNewList(ResultColumnList targetList, FormatableBitSet copyList) {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ResultColumn rc = (ResultColumn)this.elementAt(index);
            if (!copyList.isSet(rc.getColumnPosition())) continue;
            targetList.addElement(rc);
        }
    }

    public FormatableBitSet getColumnReferenceMap() {
        FormatableBitSet colMap = new FormatableBitSet(this.size());
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ResultColumn rc = (ResultColumn)this.elementAt(index);
            if (!rc.isReferenced()) continue;
            colMap.set(index);
        }
        return colMap;
    }

    void pullVirtualIsReferenced() {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ResultColumn rc = (ResultColumn)this.elementAt(index);
            rc.pullVirtualIsReferenced();
        }
    }

    public void clearTableNames() {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ResultColumn rc = (ResultColumn)this.elementAt(index);
            rc.clearTableName();
        }
    }

    protected void setCountMismatchAllowed(boolean allowed) {
        this.countMismatchAllowed = allowed;
    }

    protected boolean getCountMismatchAllowed() {
        return this.countMismatchAllowed;
    }

    public int getTotalColumnSize() {
        int colSize = 0;
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            colSize += ((ResultColumn)this.elementAt(index)).getMaximumColumnSize();
        }
        return colSize;
    }

    public void createListFromResultSetMetaData(ResultSetMetaData rsmd, TableName tableName, String javaClassName) throws StandardException {
        try {
            int numColumns = rsmd.getColumnCount();
            if (numColumns <= 0) {
                throw StandardException.newException("42X57", (Object)javaClassName, (Object)String.valueOf(numColumns));
            }
            for (int index = 1; index <= numColumns; ++index) {
                TypeId cti;
                boolean nullableResult = rsmd.isNullable(index) != 0;
                int jdbcColumnType = rsmd.getColumnType(index);
                switch (jdbcColumnType) {
                    case 1111: 
                    case 2000: {
                        cti = TypeId.getUserDefinedTypeId(rsmd.getColumnTypeName(index), false);
                        break;
                    }
                    default: {
                        cti = TypeId.getBuiltInTypeId(jdbcColumnType);
                    }
                }
                if (cti == null) {
                    throw StandardException.newException("42Y23", Integer.toString(index));
                }
                int maxWidth = cti.variableLength() ? rsmd.getColumnDisplaySize(index) : (jdbcColumnType == -1 || jdbcColumnType == -4 ? Integer.MAX_VALUE : 0);
                int precision = cti.isDecimalTypeId() ? rsmd.getPrecision(index) : 0;
                int scale = cti.isDecimalTypeId() ? rsmd.getScale(index) : 0;
                DataTypeDescriptor dts = new DataTypeDescriptor(cti, precision, scale, nullableResult, maxWidth);
                ValueNode bcn = (ValueNode)this.getNodeFactory().getNode(94, rsmd.getColumnName(index), tableName, dts, this.getContextManager());
                ResultColumn rc = (ResultColumn)this.getNodeFactory().getNode(80, rsmd.getColumnName(index), bcn, this.getContextManager());
                rc.setType(dts);
                this.addResultColumn(rc);
            }
        }
        catch (Throwable t) {
            if (t instanceof StandardException) {
                throw (StandardException)t;
            }
            throw StandardException.unexpectedUserException(t);
        }
    }

    public void addRCForRID() throws StandardException {
        CurrentRowLocationNode rowLocationNode = (CurrentRowLocationNode)this.getNodeFactory().getNode(2, this.getContextManager());
        ResultColumn rowLocationColumn = (ResultColumn)this.getNodeFactory().getNode(80, "", rowLocationNode, this.getContextManager());
        rowLocationColumn.markGenerated();
        this.addResultColumn(rowLocationColumn);
    }

    public void markAllUnreferenced() throws StandardException {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(index);
            resultColumn.setUnreferenced();
        }
    }

    boolean allExpressionsAreColumns(ResultSetNode sourceRS) {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ColumnReference cr;
            VirtualColumnNode vcn;
            ResultColumn resultColumn = (ResultColumn)this.elementAt(index);
            ValueNode expr = resultColumn.getExpression();
            if (!(expr instanceof VirtualColumnNode) && !(expr instanceof ColumnReference)) {
                return false;
            }
            if (expr instanceof VirtualColumnNode && (vcn = (VirtualColumnNode)expr).getSourceResultSet() != sourceRS) {
                vcn.setCorrelated();
                return false;
            }
            if (!(expr instanceof ColumnReference) || !(cr = (ColumnReference)expr).getCorrelated()) continue;
            return false;
        }
        return true;
    }

    int[] mapSourceColumns() {
        int[] mapArray = new int[this.size()];
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(index);
            if (resultColumn.getExpression() instanceof VirtualColumnNode) {
                VirtualColumnNode vcn = (VirtualColumnNode)resultColumn.getExpression();
                if (vcn.getCorrelated()) {
                    mapArray[index] = -1;
                    continue;
                }
                mapArray[index] = vcn.getSourceColumn().getVirtualColumnId();
                continue;
            }
            if (resultColumn.getExpression() instanceof ColumnReference) {
                ColumnReference cr = (ColumnReference)resultColumn.getExpression();
                if (cr.getCorrelated()) {
                    mapArray[index] = -1;
                    continue;
                }
                mapArray[index] = cr.getSource().getVirtualColumnId();
                continue;
            }
            mapArray[index] = -1;
        }
        return mapArray;
    }

    public void setNullability(boolean nullability) {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(index);
            resultColumn.setNullability(nullability);
        }
    }

    FormatableBitSet getReferencedFormatableBitSet(boolean positionedUpdate, boolean always, boolean onlyBCNs) {
        int index;
        int colsAdded = 0;
        int size = this.size();
        FormatableBitSet newReferencedCols = new FormatableBitSet(size);
        if (positionedUpdate) {
            if (always) {
                for (int index2 = 0; index2 < size; ++index2) {
                    newReferencedCols.set(index2);
                }
                return newReferencedCols;
            }
            return null;
        }
        for (index = 0; index < size; ++index) {
            ResultColumn oldCol = (ResultColumn)this.elementAt(index);
            if (!oldCol.isReferenced() || onlyBCNs && !(oldCol.getExpression() instanceof BaseColumnNode)) continue;
            newReferencedCols.set(index);
            ++colsAdded;
        }
        if (colsAdded != index || always) {
            return newReferencedCols;
        }
        return null;
    }

    ResultColumnList compactColumns(boolean positionedUpdate, boolean always) throws StandardException {
        int index;
        int colsAdded = 0;
        if (positionedUpdate) {
            return this;
        }
        ResultColumnList newCols = (ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager());
        int size = this.size();
        for (index = 0; index < size; ++index) {
            ResultColumn oldCol = (ResultColumn)this.elementAt(index);
            if (!oldCol.isReferenced()) continue;
            newCols.addResultColumn(oldCol);
            ++colsAdded;
        }
        if (colsAdded != index || always) {
            return newCols;
        }
        return this;
    }

    void removeJoinColumns(ResultColumnList joinColumns) {
        int jcSize = joinColumns.size();
        for (int index = 0; index < jcSize; ++index) {
            ResultColumn joinRC = (ResultColumn)joinColumns.elementAt(index);
            String columnName = joinRC.getName();
            SanityManager.ASSERT(columnName != null, "columnName should be non-null");
            ResultColumn rightRC = this.getResultColumn(columnName);
            if (rightRC == null) continue;
            this.removeElement(rightRC);
        }
    }

    ResultColumnList getJoinColumns(ResultColumnList joinColumns) {
        ResultColumnList newRCL = new ResultColumnList();
        int jcSize = joinColumns.size();
        for (int index = 0; index < jcSize; ++index) {
            ResultColumn joinRC = (ResultColumn)joinColumns.elementAt(index);
            String columnName = joinRC.getName();
            SanityManager.ASSERT(columnName != null, "columnName should be non-null");
            ResultColumn xferRC = this.getResultColumn(columnName);
            newRCL.addElement(xferRC);
        }
        return newRCL;
    }

    void resetVirtualColumnIds() {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ((ResultColumn)this.elementAt(index)).setVirtualColumnId(index + 1);
        }
    }

    boolean reusableResult() {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ResultColumn rc = (ResultColumn)this.elementAt(index);
            if (rc.getExpression() instanceof ConstantNode || rc.getExpression() instanceof AggregateNode) continue;
            return false;
        }
        return true;
    }

    public int[] getColumnPositions(TableDescriptor td) throws StandardException {
        int size = this.size();
        int[] myPositions = new int[size];
        for (int index = 0; index < size; ++index) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(index);
            String columnName = resultColumn.getName();
            ColumnDescriptor cd = td.getColumnDescriptor(columnName);
            if (cd == null) {
                throw StandardException.newException("42X14", (Object)columnName, (Object)td.getQualifiedName());
            }
            myPositions[index] = cd.getPosition();
        }
        return myPositions;
    }

    public String[] getColumnNames() {
        String[] strings = new String[this.size()];
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ResultColumn resultColumn = (ResultColumn)this.elementAt(index);
            strings[index] = resultColumn.getName();
        }
        return strings;
    }

    void replaceDefaults(TableDescriptor ttd, ResultColumnList tcl) throws StandardException {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            DefaultInfoImpl defaultInfo;
            ColumnDescriptor cd;
            ResultColumn rc = (ResultColumn)this.elementAt(index);
            if (!rc.isDefaultColumn()) continue;
            if (tcl == null) {
                cd = ttd.getColumnDescriptor(index + 1);
            } else {
                ResultColumn trc = (ResultColumn)tcl.elementAt(index);
                cd = ttd.getColumnDescriptor(trc.getName());
            }
            if (cd == null) {
                throw StandardException.newException("42X06", ttd.getQualifiedName());
            }
            if (cd.isAutoincrement()) {
                rc.setAutoincrementGenerated();
            }
            if ((defaultInfo = (DefaultInfoImpl)cd.getDefaultInfo()) != null) {
                DefaultDescriptor defaultDescriptor = cd.getDefaultDescriptor(this.getDataDictionary());
                this.getCompilerContext().createDependency(defaultDescriptor);
                rc.setExpression(DefaultNode.parseDefault(defaultInfo.getDefaultText(), this.getLanguageConnectionContext(), this.getCompilerContext()));
            } else {
                rc.setExpression((ValueNode)this.getNodeFactory().getNode(13, this.getContextManager()));
            }
            rc.setDefaultColumn(false);
        }
    }

    void checkForInvalidDefaults() throws StandardException {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ResultColumn rc = (ResultColumn)this.elementAt(index);
            if (rc.isAutoincrementGenerated() || !rc.isDefaultColumn()) continue;
            throw StandardException.newException("42Y85");
        }
    }

    void verifyAllOrderable() throws StandardException {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ResultColumn rc = (ResultColumn)this.elementAt(index);
            rc.verifyOrderable();
        }
    }

    public void populate(TableDescriptor table, int[] columnIDs) throws StandardException {
        if (columnIDs == null) {
            return;
        }
        int count = columnIDs.length;
        TableName tableName = this.makeTableName(table.getSchemaName(), table.getName());
        for (int i = 0; i < count; ++i) {
            int columnPosition = columnIDs[i];
            String columnName = table.getColumnDescriptor(columnPosition).getColumnName();
            ResultColumn rc = this.makeColumnFromName(columnName);
            this.addResultColumn(rc);
        }
    }

    private ResultColumn makeColumnFromName(String columnName) throws StandardException {
        ResultColumn resultColumn = (ResultColumn)this.getNodeFactory().getNode(80, columnName, null, this.getContextManager());
        return resultColumn;
    }

    private ResultColumn makeColumnReferenceFromName(TableName tableName, String columnName) throws StandardException {
        ContextManager cm = this.getContextManager();
        NodeFactory nodeFactory = this.getNodeFactory();
        ResultColumn rc = (ResultColumn)nodeFactory.getNode(80, null, nodeFactory.getNode(62, columnName, tableName, cm), cm);
        return rc;
    }

    public void checkAutoincrement(ResultColumnList sourceRSRCL) throws StandardException {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ResultColumn rc = (ResultColumn)this.elementAt(index);
            ResultColumn sourceRC = (ResultColumn)(sourceRSRCL == null ? null : sourceRSRCL.elementAt(index));
            ColumnDescriptor cd = rc.getTableColumnDescriptor();
            if (cd == null || !cd.isAutoincrement()) continue;
            if (sourceRC != null && sourceRC.isAutoincrementGenerated()) {
                sourceRC.setColumnDescriptor(cd.getTableDescriptor(), cd);
                continue;
            }
            if (!cd.isAutoincAlways()) continue;
            throw StandardException.newException("42Z23", rc.getName());
        }
    }

    public void incOrderBySelect() {
        ++this.orderBySelect;
    }

    private void decOrderBySelect() {
        --this.orderBySelect;
    }

    public int getOrderBySelect() {
        return this.orderBySelect;
    }

    public void copyOrderBySelect(ResultColumnList src) {
        this.orderBySelect = src.orderBySelect;
    }

    protected void markInitialSize() {
        this.initialListSize = this.size();
    }

    private int numGeneratedColumns() {
        int numGenerated = 0;
        int sz = this.size();
        for (int i = sz - 1; i >= 0; --i) {
            ResultColumn rc = (ResultColumn)this.elementAt(i);
            if (!rc.isGenerated()) continue;
            ++numGenerated;
        }
        return numGenerated;
    }

    int numGeneratedColumnsForGroupBy() {
        int numGenerated = 0;
        int sz = this.size();
        for (int i = sz - 1; i >= 0; --i) {
            ResultColumn rc = (ResultColumn)this.elementAt(i);
            if (!rc.isGenerated() || !rc.isGroupingColumn()) continue;
            ++numGenerated;
        }
        return numGenerated;
    }

    void removeGeneratedGroupingColumns() {
        int sz = this.size();
        for (int i = sz - 1; i >= 0; --i) {
            ResultColumn rc = (ResultColumn)this.elementAt(i);
            if (!rc.isGenerated() || !rc.isGroupingColumn()) continue;
            this.removeElementAt(i);
        }
    }

    public int visibleSize() {
        return this.size() - this.orderBySelect - this.numGeneratedColumns();
    }
}

