/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.types.StringDataValue;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.sql.compile.BaseColumnNode;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.compile.UntypedNullConstantNode;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.compile.VirtualColumnNode;

public class ResultColumn
extends ValueNode
implements ResultColumnDescriptor,
Comparable {
    String name;
    String exposedName;
    String tableName;
    String sourceTableName;
    String sourceSchemaName;
    ValueNode expression;
    ColumnDescriptor columnDescriptor;
    boolean isGenerated;
    boolean isGeneratedForUnmatchedColumnInInsert;
    boolean isGroupingColumn;
    boolean isReferenced;
    boolean isRedundant;
    boolean isNameGenerated;
    boolean updated;
    boolean updatableByCursor;
    private boolean defaultColumn;
    boolean autoincrementGenerated;
    boolean autoincrement;
    private int resultSetNumber = -1;
    ColumnReference reference;
    private int virtualColumnId;

    public void init(Object arg1, Object arg2) throws StandardException {
        if (arg1 instanceof String || arg1 == null) {
            this.exposedName = this.name = (String)arg1;
            this.expression = (ValueNode)arg2;
        } else if (arg1 instanceof ColumnReference) {
            ColumnReference ref = (ColumnReference)arg1;
            this.name = ref.getColumnName();
            this.exposedName = ref.getColumnName();
            this.reference = ref;
            this.expression = (ValueNode)arg2;
        } else if (arg1 instanceof ColumnDescriptor) {
            ColumnDescriptor coldes = (ColumnDescriptor)arg1;
            DataTypeDescriptor colType = coldes.getType();
            this.exposedName = this.name = coldes.getColumnName();
            this.setType(new DataTypeDescriptor(colType, colType.isNullable()));
            this.columnDescriptor = coldes;
            this.expression = (ValueNode)arg2;
            this.autoincrement = coldes.isAutoincrement();
        } else {
            this.setType((DataTypeDescriptor)arg1);
            this.expression = (ValueNode)arg2;
            if (arg2 instanceof ColumnReference) {
                this.reference = (ColumnReference)arg2;
            }
        }
        if (this.expression != null && this.expression.isInstanceOf(100)) {
            this.defaultColumn = true;
        }
    }

    public boolean isDefaultColumn() {
        return this.defaultColumn;
    }

    public void setDefaultColumn(boolean value) {
        this.defaultColumn = value;
    }

    public String getName() {
        return this.exposedName;
    }

    public String getSchemaName() throws StandardException {
        if (this.columnDescriptor != null && this.columnDescriptor.getTableDescriptor() != null) {
            return this.columnDescriptor.getTableDescriptor().getSchemaName();
        }
        if (this.expression != null) {
            return this.expression.getSchemaName();
        }
        return null;
    }

    public String getTableName() {
        if (this.tableName != null) {
            return this.tableName;
        }
        if (this.columnDescriptor != null && this.columnDescriptor.getTableDescriptor() != null) {
            return this.columnDescriptor.getTableDescriptor().getName();
        }
        return this.expression.getTableName();
    }

    public String getSourceTableName() {
        return this.sourceTableName;
    }

    public String getSourceSchemaName() {
        return this.sourceSchemaName;
    }

    public void clearTableName() {
        if (this.expression instanceof ColumnReference) {
            ((ColumnReference)this.expression).setTableNameNode(null);
        }
    }

    public DataTypeDescriptor getType() {
        return this.dataTypeServices;
    }

    public DataTypeDescriptor getExpressionType() throws StandardException {
        return this.expression == null ? this.dataTypeServices : this.expression.getTypeServices();
    }

    public int getColumnPosition() {
        if (this.columnDescriptor != null) {
            return this.columnDescriptor.getPosition();
        }
        return this.virtualColumnId;
    }

    public void setExpression(ValueNode expression) {
        this.expression = expression;
    }

    public ValueNode getExpression() {
        return this.expression;
    }

    void setExpressionToNullNode() throws StandardException {
        this.expression = this.getNullNode(this.getTypeId(), this.getContextManager(), this.getTypeServices().getCollationType(), this.getTypeServices().getCollationDerivation());
    }

    public void setName(String name) {
        if (this.name == null) {
            this.name = name;
        } else {
            SanityManager.ASSERT(this.reference == null || name.equals(this.reference.getColumnName()), "don't change name from reference name");
        }
        this.exposedName = name;
    }

    public boolean isNameGenerated() {
        return this.isNameGenerated;
    }

    public void setNameGenerated(boolean value) {
        this.isNameGenerated = value;
    }

    public void setResultSetNumber(int resultSetNumber) {
        this.resultSetNumber = resultSetNumber;
    }

    public int getResultSetNumber() {
        return this.resultSetNumber;
    }

    public void adjustVirtualColumnId(int adjust) {
        this.virtualColumnId += adjust;
    }

    public void setVirtualColumnId(int id) {
        this.virtualColumnId = id;
    }

    public int getVirtualColumnId() {
        return this.virtualColumnId;
    }

    public void collapseVirtualColumnIdGap(int removedColumnId) {
        if (this.columnDescriptor == null && this.virtualColumnId > removedColumnId) {
            --this.virtualColumnId;
        }
    }

    public void guaranteeColumnName() throws StandardException {
        if (this.exposedName == null) {
            this.exposedName = "SQLCol" + this.getCompilerContext().getNextColumnNumber();
            this.isNameGenerated = true;
        }
    }

    public String toString() {
        return "exposedName: " + this.exposedName + "\n" + "name: " + this.name + "\n" + "tableName: " + this.tableName + "\n" + "isNameGenerated: " + this.isNameGenerated + "\n" + "sourceTableName: " + this.sourceTableName + "\n" + "type: " + this.dataTypeServices + "\n" + "columnDescriptor: " + this.columnDescriptor + "\n" + "isGenerated: " + this.isGenerated + "\n" + "isGeneratedForUnmatchedColumnInInsert: " + this.isGeneratedForUnmatchedColumnInInsert + "\n" + "isGroupingColumn: " + this.isGroupingColumn + "\n" + "isReferenced: " + this.isReferenced + "\n" + "isRedundant: " + this.isRedundant + "\n" + "virtualColumnId: " + this.virtualColumnId + "\n" + "resultSetNumber: " + this.resultSetNumber + "\n" + super.toString();
    }

    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.expression != null) {
            this.printLabel(depth, "expression: ");
            this.expression.treePrint(depth + 1);
        }
        if (this.reference != null) {
            this.printLabel(depth, "reference: ");
            this.reference.treePrint(depth + 1);
        }
    }

    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector aggregateVector) throws StandardException {
        if (this.expression.requiresTypeFromContext() && this.getTypeServices() != null) {
            this.expression.setType(this.getTypeServices());
        }
        this.expression = this.expression.bindExpression(fromList, subqueryList, aggregateVector);
        if (this.expression instanceof ColumnReference) {
            this.autoincrement = ((ColumnReference)this.expression).getSource().isAutoincrement();
        }
        return this;
    }

    void bindResultColumnByPosition(TableDescriptor tableDescriptor, int columnId) throws StandardException {
        ColumnDescriptor columnDescriptor = tableDescriptor.getColumnDescriptor(columnId);
        if (columnDescriptor == null) {
            String errorString = "";
            String schemaName = tableDescriptor.getSchemaName();
            if (schemaName != null) {
                errorString = errorString + schemaName + ".";
            }
            errorString = errorString + tableDescriptor.getName();
            throw StandardException.newException("42X06", errorString);
        }
        this.setColumnDescriptor(tableDescriptor, columnDescriptor);
        this.setVirtualColumnId(columnId);
    }

    public void bindResultColumnByName(TableDescriptor tableDescriptor, int columnId) throws StandardException {
        ColumnDescriptor columnDescriptor = tableDescriptor.getColumnDescriptor(this.exposedName);
        if (columnDescriptor == null) {
            String errorString = "";
            String schemaName = tableDescriptor.getSchemaName();
            if (schemaName != null) {
                errorString = errorString + schemaName + ".";
            }
            errorString = errorString + tableDescriptor.getName();
            throw StandardException.newException("42X14", (Object)this.exposedName, (Object)errorString);
        }
        this.setColumnDescriptor(tableDescriptor, columnDescriptor);
        this.setVirtualColumnId(columnId);
        if (this.isPrivilegeCollectionRequired()) {
            this.getCompilerContext().addRequiredColumnPriv(columnDescriptor);
        }
    }

    public void typeUntypedNullExpression(ResultColumn bindingRC) throws StandardException {
        TypeId typeId = bindingRC.getTypeId();
        if (typeId == null) {
            throw StandardException.newException("42X07");
        }
        if (this.expression instanceof UntypedNullConstantNode) {
            this.expression = this.getNullNode(typeId, this.getContextManager(), 0, 1);
        } else if (this.expression instanceof ColumnReference && this.expression.getTypeServices() == null) {
            this.expression.setType(bindingRC.getType());
        }
    }

    void setColumnDescriptor(TableDescriptor tableDescriptor, ColumnDescriptor columnDescriptor) throws StandardException {
        SanityManager.ASSERT(columnDescriptor != null, "Caller is responsible for verifying that column exists");
        this.setType(columnDescriptor.getType());
        this.columnDescriptor = columnDescriptor;
        if (this.reference != null && this.reference.getTableName() != null && !tableDescriptor.getName().equals(this.reference.getTableName())) {
            String realName = tableDescriptor.getName();
            String refName = this.reference.getTableName();
            throw StandardException.newException("42X55", (Object)realName, (Object)refName);
        }
    }

    public void bindResultColumnToExpression() throws StandardException {
        this.setType(this.expression.getTypeServices());
        if (this.expression instanceof ColumnReference) {
            ColumnReference cr = (ColumnReference)this.expression;
            this.tableName = cr.getTableName();
            this.sourceTableName = cr.getSourceTableName();
            this.sourceSchemaName = cr.getSourceSchemaName();
        }
    }

    public ValueNode preprocess(int numTables, FromList outerFromList, SubqueryList outerSubqueryList, PredicateList outerPredicateList) throws StandardException {
        if (this.expression == null) {
            return this;
        }
        this.expression = this.expression.preprocess(numTables, outerFromList, outerSubqueryList, outerPredicateList);
        return this;
    }

    public void checkStorableExpression(ResultColumn toStore) throws StandardException {
        TypeId toStoreTypeId = toStore.getTypeId();
        if (toStoreTypeId == null) {
            return;
        }
        TypeId columnTypeId = this.getTypeId();
        if (!this.getTypeCompiler().storable(toStoreTypeId, this.getClassFactory())) {
            throw StandardException.newException("42821", (Object)columnTypeId.getSQLTypeName(), (Object)toStoreTypeId.getSQLTypeName());
        }
    }

    public void checkStorableExpression() throws StandardException {
        TypeId columnTypeId = this.getTypeId();
        TypeId toStoreTypeId = this.getExpressionType().getTypeId();
        if (!this.getTypeCompiler().storable(toStoreTypeId, this.getClassFactory())) {
            throw StandardException.newException("42821", (Object)columnTypeId.getSQLTypeName(), (Object)toStoreTypeId.getSQLTypeName());
        }
    }

    public void generateExpression(ExpressionClassBuilder ecb, MethodBuilder mb) throws StandardException {
        this.expression.generateExpression(ecb, mb);
    }

    public void generateHolder(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        acb.generateNull(mb, this.getTypeCompiler(), this.getTypeServices().getCollationType());
        mb.upCast("org.apache.derby.iapi.types.DataValueDescriptor");
    }

    boolean columnTypeAndLengthMatch() throws StandardException {
        DataTypeDescriptor expressionType = this.expression.getTypeServices();
        if (this.expression.requiresTypeFromContext()) {
            return false;
        }
        DataTypeDescriptor resultColumnType = this.getType();
        if (resultColumnType == null) {
            SanityManager.THROWASSERT("Type is null for column " + this);
        }
        if (resultColumnType.getTypeId().isXMLTypeId()) {
            return false;
        }
        if (!resultColumnType.getTypeId().getSQLTypeName().equals(expressionType.getTypeId().getSQLTypeName())) {
            return false;
        }
        if (resultColumnType.getPrecision() != expressionType.getPrecision()) {
            return false;
        }
        if (resultColumnType.getScale() != expressionType.getScale()) {
            return false;
        }
        if (resultColumnType.getMaximumWidth() != expressionType.getMaximumWidth()) {
            return false;
        }
        return resultColumnType.isNullable() || !expressionType.isNullable();
    }

    boolean columnTypeAndLengthMatch(ResultColumn otherColumn) throws StandardException {
        ValueNode otherExpression = otherColumn.getExpression();
        DataTypeDescriptor resultColumnType = this.getType();
        DataTypeDescriptor otherResultColumnType = otherColumn.getType();
        SanityManager.ASSERT(resultColumnType != null, "Type is null for column " + this);
        SanityManager.ASSERT(otherResultColumnType != null, "Type is null for column " + otherColumn);
        if (otherExpression != null && otherExpression.requiresTypeFromContext() || this.expression.requiresTypeFromContext()) {
            return false;
        }
        if (resultColumnType.getTypeId().isXMLTypeId()) {
            return false;
        }
        if (!resultColumnType.getTypeId().equals(otherResultColumnType.getTypeId())) {
            if (otherExpression instanceof ConstantNode) {
                DataValueDescriptor newValue;
                ConstantNode constant = (ConstantNode)otherColumn.getExpression();
                DataValueDescriptor oldValue = constant.getValue();
                if (oldValue != (newValue = this.convertConstant(resultColumnType.getTypeId(), resultColumnType.getMaximumWidth(), oldValue)) && oldValue instanceof StringDataValue == newValue instanceof StringDataValue) {
                    constant.setValue(newValue);
                    constant.setType(this.getTypeServices());
                    otherColumn.bindResultColumnToExpression();
                    otherResultColumnType = otherColumn.getType();
                }
                if (newValue instanceof StringDataValue) {
                    constant.getTypeServices().setCollationDerivation(resultColumnType.getCollationDerivation());
                    constant.getTypeServices().setCollationType(resultColumnType.getCollationType());
                    DataValueFactory dvf = this.getDataValueFactory();
                    newValue = ((StringDataValue)newValue).getValue(dvf.getCharacterCollator(constant.getTypeServices().getCollationType()));
                    constant.setValue(newValue);
                }
            }
            if (!resultColumnType.getTypeId().equals(otherResultColumnType.getTypeId())) {
                return false;
            }
        }
        if (resultColumnType.getPrecision() != otherResultColumnType.getPrecision()) {
            return false;
        }
        if (resultColumnType.getScale() != otherResultColumnType.getScale()) {
            return false;
        }
        if (resultColumnType.getMaximumWidth() != otherResultColumnType.getMaximumWidth()) {
            return false;
        }
        return resultColumnType.isNullable() || !otherResultColumnType.isNullable() && !otherColumn.isGeneratedForUnmatchedColumnInInsert();
    }

    public boolean isGenerated() {
        return this.isGenerated;
    }

    public boolean isGeneratedForUnmatchedColumnInInsert() {
        return this.isGeneratedForUnmatchedColumnInInsert;
    }

    public void markGenerated() {
        this.isGenerated = true;
        this.isReferenced = true;
    }

    public void markGeneratedForUnmatchedColumnInInsert() {
        this.isGeneratedForUnmatchedColumnInInsert = true;
        this.isReferenced = true;
    }

    public boolean isReferenced() {
        return this.isReferenced;
    }

    public void setReferenced() {
        this.isReferenced = true;
    }

    void pullVirtualIsReferenced() {
        if (this.isReferenced()) {
            return;
        }
        ValueNode expr = this.expression;
        while (expr != null && expr instanceof VirtualColumnNode) {
            VirtualColumnNode vcn = (VirtualColumnNode)expr;
            ResultColumn src = vcn.getSourceColumn();
            if (src.isReferenced()) {
                this.setReferenced();
                return;
            }
            expr = src.getExpression();
        }
    }

    public void setUnreferenced() {
        this.isReferenced = false;
    }

    void markAllRCsInChainReferenced() {
        this.setReferenced();
        ValueNode vn = this.expression;
        while (vn instanceof VirtualColumnNode) {
            VirtualColumnNode vcn = (VirtualColumnNode)vn;
            ResultColumn rc = vcn.getSourceColumn();
            rc.setReferenced();
            vn = rc.getExpression();
        }
    }

    public boolean isRedundant() {
        return this.isRedundant;
    }

    public void setRedundant() {
        this.isRedundant = true;
    }

    public void markAsGroupingColumn() {
        this.isGroupingColumn = true;
    }

    void rejectParameter() throws StandardException {
        if (this.expression != null && this.expression.isParameterNode()) {
            throw StandardException.newException("42X34");
        }
    }

    public int compareTo(Object other) {
        ResultColumn otherResultColumn = (ResultColumn)other;
        return this.getColumnPosition() - otherResultColumn.getColumnPosition();
    }

    void markUpdated() {
        this.updated = true;
    }

    void markUpdatableByCursor() {
        this.updatableByCursor = true;
    }

    boolean updated() {
        return this.updated;
    }

    public boolean updatableByCursor() {
        return this.updatableByCursor;
    }

    public void disablePrivilegeCollection() {
        super.disablePrivilegeCollection();
        if (this.expression != null) {
            this.expression.disablePrivilegeCollection();
        }
    }

    ResultColumn cloneMe() throws StandardException {
        ResultColumn newResultColumn;
        ValueNode cloneExpr = this.expression instanceof ColumnReference ? ((ColumnReference)this.expression).getClone() : this.expression;
        if (this.columnDescriptor != null) {
            newResultColumn = (ResultColumn)this.getNodeFactory().getNode(80, this.columnDescriptor, this.expression, this.getContextManager());
            newResultColumn.setExpression(cloneExpr);
        } else {
            newResultColumn = (ResultColumn)this.getNodeFactory().getNode(80, this.getName(), cloneExpr, this.getContextManager());
        }
        newResultColumn.setVirtualColumnId(this.getVirtualColumnId());
        newResultColumn.setName(this.getName());
        newResultColumn.setType(this.getTypeServices());
        newResultColumn.setNameGenerated(this.isNameGenerated());
        if (this.isGeneratedForUnmatchedColumnInInsert()) {
            newResultColumn.markGeneratedForUnmatchedColumnInInsert();
        }
        if (this.isReferenced()) {
            newResultColumn.setReferenced();
        }
        if (this.updated()) {
            newResultColumn.markUpdated();
        }
        if (this.updatableByCursor()) {
            newResultColumn.markUpdatableByCursor();
        }
        if (this.isAutoincrementGenerated()) {
            newResultColumn.setAutoincrementGenerated();
        }
        if (this.isAutoincrement()) {
            newResultColumn.setAutoincrement();
        }
        if (this.isGroupingColumn()) {
            newResultColumn.markAsGroupingColumn();
        }
        if (this.isGenerated()) {
            newResultColumn.markGenerated();
        }
        return newResultColumn;
    }

    public int getMaximumColumnSize() {
        return this.dataTypeServices.getTypeId().getApproximateLengthInBytes(this.dataTypeServices);
    }

    protected int getOrderableVariantType() throws StandardException {
        int expType = this.expression != null ? this.expression.getOrderableVariantType() : (this.isAutoincrementGenerated() ? 0 : 3);
        switch (expType) {
            case 0: {
                return 0;
            }
            case 1: 
            case 2: {
                return 1;
            }
        }
        return 3;
    }

    public Visitable accept(Visitor v) throws StandardException {
        Visitable returnNode = v.visit(this);
        if (v.skipChildren(this)) {
            return returnNode;
        }
        if (this.expression != null && !v.stopTraversal()) {
            this.expression = (ValueNode)this.expression.accept(v);
        }
        return returnNode;
    }

    public void setNullability(boolean nullability) {
        this.dataTypeServices.setNullability(nullability);
    }

    public boolean foundInList(String[] list) {
        return this.foundString(list, this.name);
    }

    void verifyOrderable() throws StandardException {
        if (!this.getTypeId().orderable(this.getClassFactory())) {
            throw StandardException.newException("X0X67.S", this.getTypeId().getSQLTypeName());
        }
    }

    ColumnDescriptor getTableColumnDescriptor() {
        return this.columnDescriptor;
    }

    public boolean isAutoincrementGenerated() {
        return this.autoincrementGenerated;
    }

    public void setAutoincrementGenerated() {
        this.autoincrementGenerated = true;
    }

    public void resetAutoincrementGenerated() {
        this.autoincrementGenerated = false;
    }

    public boolean isAutoincrement() {
        return this.autoincrement;
    }

    public void setAutoincrement() {
        this.autoincrement = true;
    }

    public boolean isGroupingColumn() {
        return this.isGroupingColumn;
    }

    private DataValueDescriptor convertConstant(TypeId toTypeId, int maxWidth, DataValueDescriptor constantValue) throws StandardException {
        int formatId = toTypeId.getTypeFormatId();
        DataValueFactory dvf = this.getDataValueFactory();
        switch (formatId) {
            default: {
                return constantValue;
            }
            case 13: 
            case 369: 
            case 370: {
                String sourceValue = constantValue.getString();
                int sourceWidth = sourceValue.length();
                if (sourceWidth <= maxWidth) {
                    switch (formatId) {
                        case 370: {
                            if (sourceWidth < maxWidth) {
                                StringBuffer stringBuffer = new StringBuffer(sourceValue);
                                int needed = maxWidth - sourceWidth;
                                char[] blankArray = new char[needed];
                                for (int i = 0; i < needed; ++i) {
                                    blankArray[i] = 32;
                                }
                                stringBuffer.append(blankArray, 0, maxWidth - sourceWidth);
                                sourceValue = stringBuffer.toString();
                            }
                            return dvf.getNationalCharDataValue(sourceValue);
                        }
                        case 369: {
                            return dvf.getNationalVarcharDataValue(sourceValue);
                        }
                        case 13: {
                            return dvf.getVarcharDataValue(sourceValue);
                        }
                    }
                }
                for (int posn = maxWidth; posn < sourceWidth; ++posn) {
                    if (sourceValue.charAt(posn) == ' ') continue;
                    String typeName = null;
                    switch (formatId) {
                        case 370: {
                            typeName = "NATIONAL CHAR";
                            break;
                        }
                        case 369: {
                            typeName = "NATIONAL CHAR VARYING";
                            break;
                        }
                        case 13: {
                            typeName = "VARCHAR";
                        }
                    }
                    throw StandardException.newException("22001", (Object)typeName, (Object)StringUtil.formatForPrint(sourceValue), (Object)String.valueOf(maxWidth));
                }
                switch (formatId) {
                    case 370: {
                        return dvf.getNationalCharDataValue(sourceValue.substring(0, maxWidth));
                    }
                    case 369: {
                        return dvf.getNationalVarcharDataValue(sourceValue.substring(0, maxWidth));
                    }
                    case 13: {
                        return dvf.getVarcharDataValue(sourceValue.substring(0, maxWidth));
                    }
                }
            }
            case 230: {
                return dvf.getLongvarcharDataValue(constantValue.getString());
            }
            case 362: 
        }
        return dvf.getNationalLongvarcharDataValue(constantValue.getString());
    }

    public DataTypeDescriptor getTypeServices() throws StandardException {
        DataTypeDescriptor dtd = super.getTypeServices();
        if (dtd == null && this.expression != null && (dtd = this.expression.getTypeServices()) != null) {
            this.setType(dtd);
        }
        return dtd;
    }

    public TableName getTableNameObject() {
        return null;
    }

    public ColumnReference getReference() {
        return this.reference;
    }

    public BaseColumnNode getBaseColumnNode() {
        ValueNode vn = this.expression;
        while (true) {
            if (vn instanceof ResultColumn) {
                vn = ((ResultColumn)vn).expression;
                continue;
            }
            if (vn instanceof ColumnReference) {
                vn = ((ColumnReference)vn).getSource();
                continue;
            }
            if (!(vn instanceof VirtualColumnNode)) break;
            vn = ((VirtualColumnNode)vn).getSourceColumn();
        }
        if (vn instanceof BaseColumnNode) {
            return (BaseColumnNode)vn;
        }
        return null;
    }

    public int getTableNumber() throws StandardException {
        if (this.expression instanceof ColumnReference) {
            return ((ColumnReference)this.expression).getTableNumber();
        }
        if (this.expression instanceof VirtualColumnNode) {
            VirtualColumnNode vcn = (VirtualColumnNode)this.expression;
            if (vcn.getSourceResultSet() instanceof FromBaseTable) {
                return ((FromBaseTable)vcn.getSourceResultSet()).getTableNumber();
            }
            return vcn.getSourceColumn().getTableNumber();
        }
        return -1;
    }

    public boolean isEquivalent(ValueNode o) throws StandardException {
        if (o.getNodeType() == this.getNodeType()) {
            ResultColumn other = (ResultColumn)o;
            if (this.expression != null) {
                return this.expression.isEquivalent(other.expression);
            }
        }
        return false;
    }
}

