/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.Predicate;
import org.apache.derby.impl.sql.compile.ResultSetNode;

public class ReferencedTablesVisitor
implements Visitor {
    private JBitSet tableMap;

    public ReferencedTablesVisitor(JBitSet tableMap) {
        this.tableMap = tableMap;
    }

    public Visitable visit(Visitable node) throws StandardException {
        if (node instanceof ColumnReference) {
            ((ColumnReference)node).getTablesReferenced(this.tableMap);
        } else if (node instanceof Predicate) {
            Predicate pred = (Predicate)node;
            this.tableMap.or(pred.getReferencedSet());
        } else if (node instanceof ResultSetNode) {
            ResultSetNode rs = (ResultSetNode)node;
            this.tableMap.or(rs.getReferencedTableMap());
        }
        return node;
    }

    public boolean skipChildren(Visitable node) {
        return node instanceof Predicate || node instanceof ResultSetNode;
    }

    public boolean stopTraversal() {
        return false;
    }

    JBitSet getTableMap() {
        return this.tableMap;
    }
}

