/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.catalog.types.SynonymAliasInfo;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.services.loader.ClassInspector;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.NodeFactory;
import org.apache.derby.iapi.sql.compile.Parser;
import org.apache.derby.iapi.sql.compile.TypeCompiler;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.dictionary.AliasDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.StatementNode;
import org.apache.derby.impl.sql.compile.TableName;
import org.apache.derby.impl.sql.execute.GenericConstantActionFactory;
import org.apache.derby.impl.sql.execute.GenericExecutionFactory;

public abstract class QueryTreeNode
implements Visitable {
    public static final int AUTOINCREMENT_START_INDEX = 0;
    public static final int AUTOINCREMENT_INC_INDEX = 1;
    public static final int AUTOINCREMENT_IS_AUTOINCREMENT_INDEX = 2;
    public static final int AUTOINCREMENT_CREATE_MODIFY = 3;
    private int beginOffset = -1;
    private int endOffset = -1;
    private int nodeType;
    private ContextManager cm;
    private LanguageConnectionContext lcc;
    private GenericConstantActionFactory constantActionFactory;
    boolean isPrivilegeCollectionRequired = true;

    public void setContextManager(ContextManager cm) {
        this.cm = cm;
        SanityManager.ASSERT(cm != null, "cm not expected to be null");
    }

    public final ContextManager getContextManager() {
        if (this.cm == null) {
            SanityManager.THROWASSERT("Null context manager in QueryTreeNode of type :" + this.getClass());
        }
        return this.cm;
    }

    public final NodeFactory getNodeFactory() {
        return this.getLanguageConnectionContext().getLanguageConnectionFactory().getNodeFactory();
    }

    public final GenericConstantActionFactory getGenericConstantActionFactory() {
        if (this.constantActionFactory == null) {
            GenericExecutionFactory execFactory = (GenericExecutionFactory)this.getExecutionFactory();
            this.constantActionFactory = execFactory.getConstantActionFactory();
        }
        return this.constantActionFactory;
    }

    public final ExecutionFactory getExecutionFactory() {
        ExecutionFactory ef = this.getLanguageConnectionContext().getLanguageConnectionFactory().getExecutionFactory();
        return ef;
    }

    protected final ClassFactory getClassFactory() {
        return this.getLanguageConnectionContext().getLanguageConnectionFactory().getClassFactory();
    }

    protected final LanguageConnectionContext getLanguageConnectionContext() {
        if (this.lcc == null) {
            this.lcc = (LanguageConnectionContext)this.getContextManager().getContext("LanguageConnectionContext");
        }
        return this.lcc;
    }

    public int getBeginOffset() {
        return this.beginOffset;
    }

    public void setBeginOffset(int beginOffset) {
        this.beginOffset = beginOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public void setEndOffset(int endOffset) {
        this.endOffset = endOffset;
    }

    protected String nodeHeader() {
        return "\n" + this.getClass().getName() + '@' + Integer.toHexString(this.hashCode()) + "\n";
    }

    public static String formatNodeString(String nodeString, int depth) {
        StringBuffer nodeStringBuffer = new StringBuffer(nodeString);
        char[] indent = new char[depth];
        while (depth > 0) {
            indent[depth - 1] = 9;
            --depth;
        }
        nodeStringBuffer.insert(0, indent);
        for (int pos = 0; pos < nodeStringBuffer.length() - 1; ++pos) {
            char c = nodeStringBuffer.charAt(pos);
            if (c != '\n') continue;
            nodeStringBuffer.insert(pos + 1, indent);
        }
        return nodeStringBuffer.toString();
    }

    public void treePrint() {
        QueryTreeNode.debugPrint(this.nodeHeader());
        QueryTreeNode.debugPrint(QueryTreeNode.formatNodeString(this.toString(), 0));
        this.printSubNodes(0);
        QueryTreeNode.debugFlush();
    }

    public void treePrint(int depth) {
        QueryTreeNode.debugPrint(QueryTreeNode.formatNodeString(this.nodeHeader(), depth));
        QueryTreeNode.debugPrint(QueryTreeNode.formatNodeString(this.toString(), depth));
        this.printSubNodes(depth);
    }

    public static void debugPrint(String outputString) {
        SanityManager.GET_DEBUG_STREAM().print(outputString);
    }

    protected static void debugFlush() {
        SanityManager.GET_DEBUG_STREAM().flush();
    }

    public void printSubNodes(int depth) {
    }

    public String toString() {
        return "";
    }

    public void printLabel(int depth, String label) {
        QueryTreeNode.debugPrint(QueryTreeNode.formatNodeString(label, depth));
    }

    public boolean referencesSessionSchema() throws StandardException {
        return false;
    }

    final boolean isSessionSchema(SchemaDescriptor sd) {
        return this.isSessionSchema(sd.getSchemaName());
    }

    final boolean isSessionSchema(String schemaName) {
        return "SESSION".equals(schemaName);
    }

    public void disablePrivilegeCollection() {
        this.isPrivilegeCollectionRequired = false;
    }

    public boolean isPrivilegeCollectionRequired() {
        return this.isPrivilegeCollectionRequired;
    }

    public long getRowEstimate() {
        return 0L;
    }

    protected void generate(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        throw StandardException.newException("42Z50", this.nodeHeader());
    }

    public DataTypeDescriptor[] getParameterTypes() throws StandardException {
        return this.getCompilerContext().getParameterTypes();
    }

    public ConstantAction makeConstantAction() throws StandardException {
        return null;
    }

    public void setNodeType(int nodeType) {
        this.nodeType = nodeType;
    }

    protected int getNodeType() {
        return this.nodeType;
    }

    protected boolean isInstanceOf(int nodeType) {
        return this.nodeType == nodeType;
    }

    public final DataDictionary getDataDictionary() {
        return this.getLanguageConnectionContext().getDataDictionary();
    }

    public final DependencyManager getDependencyManager() {
        return this.getDataDictionary().getDependencyManager();
    }

    protected final CompilerContext getCompilerContext() {
        return (CompilerContext)this.getContextManager().getContext("CompilerContext");
    }

    protected final TypeCompiler getTypeCompiler(TypeId typeId) {
        return this.getCompilerContext().getTypeCompilerFactory().getTypeCompiler(typeId);
    }

    public Visitable accept(Visitor v) throws StandardException {
        return v.visit(this);
    }

    protected int getIntProperty(String value, String key) throws StandardException {
        int intVal = -1;
        try {
            intVal = Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            throw StandardException.newException("42Y58", (Object)value, (Object)key);
        }
        return intVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    StatementNode parseStatement(String sql, boolean internalSQL) throws StandardException {
        LanguageConnectionContext lcc = this.getLanguageConnectionContext();
        CompilerContext newCC = lcc.pushCompilerContext();
        if (internalSQL) {
            newCC.setReliability(0);
        }
        try {
            Parser p = newCC.getParser();
            StatementNode statementNode = p.parseStatement(sql);
            return statementNode;
        }
        finally {
            lcc.popCompilerContext(newCC);
        }
    }

    protected int getStatementType() {
        return 0;
    }

    public boolean foundString(String[] list, String search) {
        if (list == null) {
            return false;
        }
        for (int i = 0; i < list.length; ++i) {
            if (!list[i].equals(search)) continue;
            return true;
        }
        return false;
    }

    public ConstantNode getNullNode(TypeId typeId, ContextManager cm, int collationType, int collationDerivation) throws StandardException {
        QueryTreeNode constantNode = null;
        NodeFactory nf = this.getNodeFactory();
        switch (typeId.getJDBCTypeId()) {
            case 12: {
                constantNode = nf.getNode(77, typeId, cm);
                break;
            }
            case 1: {
                constantNode = nf.getNode(61, typeId, cm);
                break;
            }
            case -6: {
                constantNode = nf.getNode(75, typeId, cm);
                break;
            }
            case 5: {
                constantNode = nf.getNode(74, typeId, cm);
                break;
            }
            case 4: {
                constantNode = nf.getNode(70, typeId, cm);
                break;
            }
            case -5: {
                constantNode = nf.getNode(71, typeId, cm);
                break;
            }
            case 7: {
                constantNode = nf.getNode(69, typeId, cm);
                break;
            }
            case 8: {
                constantNode = nf.getNode(68, typeId, cm);
                break;
            }
            case 2: 
            case 3: {
                constantNode = nf.getNode(67, typeId, cm);
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                constantNode = nf.getNode(76, typeId, cm);
                break;
            }
            case -2: {
                constantNode = nf.getNode(58, typeId, cm);
                break;
            }
            case -3: {
                constantNode = nf.getNode(59, typeId, cm);
                break;
            }
            case -1: {
                constantNode = nf.getNode(73, typeId, cm);
                break;
            }
            case 2005: {
                constantNode = nf.getNode(196, typeId, cm);
                break;
            }
            case -4: {
                constantNode = nf.getNode(72, typeId, cm);
                break;
            }
            case 2004: {
                constantNode = nf.getNode(195, typeId, cm);
                break;
            }
            case 456: {
                constantNode = nf.getNode(199, typeId, cm);
                break;
            }
            default: {
                if (typeId.getSQLTypeName().equals("BOOLEAN")) {
                    constantNode = nf.getNode(38, typeId, cm);
                    break;
                }
                if (typeId.userType()) {
                    constantNode = nf.getNode(76, typeId, cm);
                    break;
                }
                SanityManager.THROWASSERT("Unknown type " + typeId.getSQLTypeName() + " in getNullNode");
                return null;
            }
        }
        ConstantNode cn = (ConstantNode)constantNode;
        cn.getTypeServices().setCollationType(collationType);
        cn.getTypeServices().setCollationDerivation(collationDerivation);
        return cn;
    }

    public DataValueDescriptor convertDefaultNode(DataTypeDescriptor typeDescriptor) throws StandardException {
        return null;
    }

    public void init(Object arg1) throws StandardException {
        SanityManager.THROWASSERT("Single-argument init() not implemented for " + this.getClass().getName());
    }

    public void init(Object arg1, Object arg2) throws StandardException {
        SanityManager.THROWASSERT("Two-argument init() not implemented for " + this.getClass().getName());
    }

    public void init(Object arg1, Object arg2, Object arg3) throws StandardException {
        SanityManager.THROWASSERT("Three-argument init() not implemented for " + this.getClass().getName());
    }

    public void init(Object arg1, Object arg2, Object arg3, Object arg4) throws StandardException {
        SanityManager.THROWASSERT("Four-argument init() not implemented for " + this.getClass().getName());
    }

    public void init(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) throws StandardException {
        SanityManager.THROWASSERT("Five-argument init() not implemented for " + this.getClass().getName());
    }

    public void init(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6) throws StandardException {
        SanityManager.THROWASSERT("Six-argument init() not implemented for " + this.getClass().getName());
    }

    public void init(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7) throws StandardException {
        SanityManager.THROWASSERT("Seven-argument init() not implemented for " + this.getClass().getName());
    }

    public void init(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8) throws StandardException {
        SanityManager.THROWASSERT("Eight-argument init() not implemented for " + this.getClass().getName());
    }

    public void init(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9) throws StandardException {
        SanityManager.THROWASSERT("Nine-argument init() not implemented for " + this.getClass().getName());
    }

    public void init(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10) throws StandardException {
        SanityManager.THROWASSERT("Ten-argument init() not implemented for " + this.getClass().getName());
    }

    public void init(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11) throws StandardException {
        SanityManager.THROWASSERT("Eleven-argument init() not implemented for " + this.getClass().getName());
    }

    public void init(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12) throws StandardException {
        SanityManager.THROWASSERT("Twelve-argument init() not implemented for " + this.getClass().getName());
    }

    public void init(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13) throws StandardException {
        SanityManager.THROWASSERT("Thirteen-argument init() not implemented for " + this.getClass().getName());
    }

    public void init(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, Object arg6, Object arg7, Object arg8, Object arg9, Object arg10, Object arg11, Object arg12, Object arg13, Object arg14) throws StandardException {
        SanityManager.THROWASSERT("Fourteen-argument init() not implemented for " + this.getClass().getName());
    }

    public TableName makeTableName(String schemaName, String flatName) throws StandardException {
        return (TableName)this.getNodeFactory().getNode(34, schemaName, flatName, this.getContextManager());
    }

    public boolean isAtomic() throws StandardException {
        SanityManager.THROWASSERT("isAtomic should not be called for this  class: " + this.getClass().getName());
        return false;
    }

    public Object getCursorInfo() throws StandardException {
        return null;
    }

    protected final TableDescriptor getTableDescriptor(String tableName, SchemaDescriptor schema) throws StandardException {
        TableDescriptor retval;
        if (this.isSessionSchema(schema) && (retval = this.getLanguageConnectionContext().getTableDescriptorForDeclaredGlobalTempTable(tableName)) != null) {
            return retval;
        }
        if (schema.getUUID() == null) {
            return null;
        }
        TableDescriptor td = this.getDataDictionary().getTableDescriptor(tableName, schema);
        if (td == null || td.isSynonymDescriptor()) {
            return null;
        }
        return td;
    }

    final SchemaDescriptor getSchemaDescriptor(String schemaName) throws StandardException {
        return this.getSchemaDescriptor(schemaName, true);
    }

    final SchemaDescriptor getSchemaDescriptor(String schemaName, boolean raiseError) throws StandardException {
        SchemaDescriptor sd = null;
        boolean isCurrent = false;
        boolean isCompilation = false;
        if (schemaName == null) {
            CompilerContext cc = this.getCompilerContext();
            sd = cc.getCompilationSchema();
            if (sd == null) {
                sd = this.getLanguageConnectionContext().getDefaultSchema();
                isCurrent = true;
                cc.setCompilationSchema(sd);
            } else {
                isCompilation = true;
            }
            schemaName = sd.getSchemaName();
        }
        DataDictionary dataDictionary = this.getDataDictionary();
        SchemaDescriptor sdCatalog = dataDictionary.getSchemaDescriptor(schemaName, this.getLanguageConnectionContext().getTransactionCompile(), raiseError);
        if (isCurrent || isCompilation) {
            if (sdCatalog != null && sdCatalog.getUUID() != null) {
                if (!sdCatalog.getUUID().equals(sd.getUUID())) {
                    if (isCurrent) {
                        this.getLanguageConnectionContext().setDefaultSchema(sdCatalog);
                    }
                    this.getCompilerContext().setCompilationSchema(sdCatalog);
                }
            } else {
                sd.setUUID(null);
                sdCatalog = sd;
            }
        }
        return sdCatalog;
    }

    public TableName resolveTableToSynonym(TableName tabName) throws StandardException {
        AliasDescriptor nextAD;
        SchemaDescriptor nextSD;
        DataDictionary dd = this.getDataDictionary();
        String nextSynonymTable = tabName.getTableName();
        String nextSynonymSchema = tabName.getSchemaName();
        boolean found = false;
        CompilerContext cc = this.getCompilerContext();
        while ((nextSD = this.getSchemaDescriptor(nextSynonymSchema, false)) != null && nextSD.getUUID() != null && (nextAD = dd.getAliasDescriptor(nextSD.getUUID().toString(), nextSynonymTable, 'S')) != null) {
            cc.createDependency(nextAD);
            found = true;
            SynonymAliasInfo info = (SynonymAliasInfo)nextAD.getAliasInfo();
            nextSynonymTable = info.getSynonymTable();
            nextSynonymSchema = info.getSynonymSchema();
        }
        if (!found) {
            return null;
        }
        TableName tableName = new TableName();
        tableName.init(nextSynonymSchema, nextSynonymTable);
        return tableName;
    }

    void verifyClassExist(String javaClassName) throws StandardException {
        ClassInspector classInspector = this.getClassFactory().getClassInspector();
        ClassNotFoundException reason = null;
        boolean foundMatch = false;
        try {
            foundMatch = classInspector.accessible(javaClassName);
        }
        catch (ClassNotFoundException cnfe) {
            reason = cnfe;
        }
        if (!foundMatch) {
            throw StandardException.newException("42X51", reason, (Object)javaClassName);
        }
        if (ClassInspector.primitiveType(javaClassName)) {
            throw StandardException.newException("42Y37", javaClassName);
        }
    }

    public void setRefActionInfo(long fkIndexConglomId, int[] fkColArray, String parentResultSetId, boolean dependentScan) {
        SanityManager.THROWASSERT("setRefActionInfo() not expected to be called for " + this.getClass().getName());
    }

    void generateAuthorizeCheck(ActivationClassBuilder acb, MethodBuilder mb, int sqlOperation) {
        acb.pushThisAsActivation(mb);
        mb.callMethod((short)185, null, "getLanguageConnectionContext", "org.apache.derby.iapi.sql.conn.LanguageConnectionContext", 0);
        mb.callMethod((short)185, null, "getAuthorizer", "org.apache.derby.iapi.sql.conn.Authorizer", 0);
        acb.pushThisAsActivation(mb);
        mb.push(sqlOperation);
        mb.callMethod((short)185, null, "authorize", "void", 2);
    }
}

