/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.LocalField;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.compile.AccessPath;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.ExpressionClassBuilderInterface;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.OptimizablePredicate;
import org.apache.derby.iapi.sql.compile.OptimizablePredicateList;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.AndNode;
import org.apache.derby.impl.sql.compile.BinaryComparisonOperatorNode;
import org.apache.derby.impl.sql.compile.BinaryOperatorNode;
import org.apache.derby.impl.sql.compile.BinaryRelationalOperatorNode;
import org.apache.derby.impl.sql.compile.BooleanConstantNode;
import org.apache.derby.impl.sql.compile.CollectNodesVisitor;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.ConstantNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.InListOperatorNode;
import org.apache.derby.impl.sql.compile.OrNode;
import org.apache.derby.impl.sql.compile.ParameterNode;
import org.apache.derby.impl.sql.compile.Predicate;
import org.apache.derby.impl.sql.compile.QueryTreeNodeVector;
import org.apache.derby.impl.sql.compile.RelationalOperator;
import org.apache.derby.impl.sql.compile.RemapCRsVisitor;
import org.apache.derby.impl.sql.compile.SelectNode;
import org.apache.derby.impl.sql.compile.UnaryComparisonOperatorNode;
import org.apache.derby.impl.sql.compile.UnaryOperatorNode;
import org.apache.derby.impl.sql.compile.ValueNode;

public class PredicateList
extends QueryTreeNodeVector
implements OptimizablePredicateList {
    private int numberOfStartPredicates;
    private int numberOfStopPredicates;
    private int numberOfQualifiers;
    private static final int QUALIFIER_ORDER_EQUALS = 0;
    private static final int QUALIFIER_ORDER_OTHER_RELOP = 1;
    private static final int QUALIFIER_ORDER_NOT_EQUALS = 2;
    private static final int QUALIFIER_ORDER_NON_QUAL = 3;
    private static final int QUALIFIER_ORDER_OR_CLAUSE = 4;
    private static final int QUALIFIER_NUM_CATEGORIES = 5;

    public OptimizablePredicate getOptPredicate(int index) {
        return (OptimizablePredicate)((Object)this.elementAt(index));
    }

    public final void removeOptPredicate(int predCtr) throws StandardException {
        Predicate predicate = (Predicate)this.remove(predCtr);
        if (predicate.isStartKey()) {
            --this.numberOfStartPredicates;
        }
        if (predicate.isStopKey()) {
            --this.numberOfStopPredicates;
        }
        if (predicate.isQualifier()) {
            --this.numberOfQualifiers;
        }
    }

    public final void removeOptPredicate(OptimizablePredicate pred) {
        this.removeElement((Predicate)pred);
        if (pred.isStartKey()) {
            --this.numberOfStartPredicates;
        }
        if (pred.isStopKey()) {
            --this.numberOfStopPredicates;
        }
        if (pred.isQualifier()) {
            --this.numberOfQualifiers;
        }
    }

    public void addOptPredicate(OptimizablePredicate optPredicate) {
        this.addElement((Predicate)optPredicate);
        if (optPredicate.isStartKey()) {
            ++this.numberOfStartPredicates;
        }
        if (optPredicate.isStopKey()) {
            ++this.numberOfStopPredicates;
        }
        if (optPredicate.isQualifier()) {
            ++this.numberOfQualifiers;
        }
    }

    public void addOptPredicate(OptimizablePredicate optPredicate, int position) {
        this.insertElementAt((Predicate)optPredicate, position);
        if (optPredicate.isStartKey()) {
            ++this.numberOfStartPredicates;
        }
        if (optPredicate.isStopKey()) {
            ++this.numberOfStopPredicates;
        }
        if (optPredicate.isQualifier()) {
            ++this.numberOfQualifiers;
        }
    }

    public boolean useful(Optimizable optTable, ConglomerateDescriptor cd) throws StandardException {
        boolean retval = false;
        if (!cd.isIndex()) {
            return false;
        }
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            boolean isIn;
            Predicate pred = (Predicate)this.elementAt(index);
            RelationalOperator relop = pred.getRelop();
            InListOperatorNode inNode = pred.getSourceInList();
            boolean bl = isIn = inNode != null;
            if (!isIn && relop == null || !isIn && !relop.usefulStartKey(optTable) && !relop.usefulStopKey(optTable)) continue;
            ColumnReference indexCol = null;
            if (isIn) {
                if (inNode.getLeftOperand() instanceof ColumnReference && (indexCol = (ColumnReference)inNode.getLeftOperand()).getColumnNumber() != cd.getIndexDescriptor().baseColumnPositions()[0]) {
                    indexCol = null;
                }
            } else {
                indexCol = relop.getColumnOperand(optTable, cd.getIndexDescriptor().baseColumnPositions()[0]);
            }
            if (indexCol == null || isIn && inNode.selfReference(indexCol) || !isIn && relop.selfComparison(indexCol)) continue;
            retval = true;
            break;
        }
        return retval;
    }

    public void pushUsefulPredicates(Optimizable optTable) throws StandardException {
        AccessPath ap = optTable.getTrulyTheBestAccessPath();
        this.orderUsefulPredicates(optTable, ap.getConglomerateDescriptor(), true, ap.getNonMatchingIndexScan(), ap.getCoveringIndexScan());
    }

    public void classify(Optimizable optTable, ConglomerateDescriptor cd) throws StandardException {
        this.orderUsefulPredicates(optTable, cd, false, false, false);
    }

    public void markAllPredicatesQualifiers() {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ((Predicate)this.elementAt(index)).markQualifier();
        }
        this.numberOfQualifiers = size;
    }

    public boolean hasOptimizableEqualityPredicate(Optimizable optTable, int columnNumber, boolean isNullOkay) throws StandardException {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            Predicate predicate = (Predicate)this.elementAt(index);
            AndNode andNode = predicate.getAndNode();
            ValueNode opNode = andNode.getLeftOperand();
            if (!opNode.optimizableEqualityNode(optTable, columnNumber, isNullOkay)) continue;
            return true;
        }
        return false;
    }

    public boolean hasOptimizableEquijoin(Optimizable optTable, int columnNumber) throws StandardException {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            AndNode andNode;
            ValueNode opNode;
            Predicate predicate = (Predicate)this.elementAt(index);
            if (predicate.isScopedForPush() || !(opNode = (andNode = predicate.getAndNode()).getLeftOperand()).optimizableEqualityNode(optTable, columnNumber, false) || !((RelationalOperator)((Object)opNode)).isQualifier(optTable, false) || predicate.getReferencedMap().hasSingleBitSet()) continue;
            return true;
        }
        return false;
    }

    public void putOptimizableEqualityPredicateFirst(Optimizable optTable, int columnNumber) throws StandardException {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            Predicate predicate = (Predicate)this.elementAt(index);
            AndNode andNode = predicate.getAndNode();
            ValueNode opNode = andNode.getLeftOperand();
            if (!opNode.optimizableEqualityNode(optTable, columnNumber, false)) continue;
            if (index != 0) {
                this.removeElementAt(index);
                this.insertElementAt(predicate, 0);
            }
            return;
        }
        SanityManager.THROWASSERT("Could  not find the expected equality predicate on column #" + columnNumber);
    }

    private void orderUsefulPredicates(Optimizable optTable, ConglomerateDescriptor cd, boolean pushPreds, boolean nonMatchingIndexScan, boolean coveringIndexScan) throws StandardException {
        int size = this.size();
        Object[] usefulPredicates = new Predicate[size];
        int usefulCount = 0;
        for (int index = 0; index < size; ++index) {
            Predicate predicate = (Predicate)this.elementAt(index);
            predicate.clearScanFlags();
        }
        if (cd == null || !cd.isIndex() || nonMatchingIndexScan && coveringIndexScan) {
            Predicate[] preds = new Predicate[size];
            for (int index = 0; index < size; ++index) {
                Predicate pred = (Predicate)this.elementAt(index);
                if (!pred.isRelationalOpPredicate() ? !pred.isPushableOrClause(optTable) : !pred.getRelop().isQualifier(optTable, pushPreds)) continue;
                pred.markQualifier();
                if (pred.isInListProbePredicate()) {
                    SanityManager.THROWASSERT("Found an IN-list probe predicate (" + pred.binaryRelOpColRefsToString() + ") that was marked as a qualifier, which should " + "not happen.");
                }
                if (!pushPreds || !optTable.pushOptPredicate(pred)) continue;
                preds[index] = pred;
            }
            for (int inner = size - 1; inner >= 0; --inner) {
                if (preds[inner] == null) continue;
                this.removeOptPredicate(preds[inner]);
            }
            return;
        }
        int[] baseColumnPositions = cd.getIndexDescriptor().baseColumnPositions();
        boolean[] isAscending = cd.getIndexDescriptor().isAscending();
        boolean skipProbePreds = pushPreds && optTable.getTrulyTheBestAccessPath().getJoinStrategy().isHashJoin();
        for (int index = 0; index < size; ++index) {
            int indexPosition;
            boolean isIn;
            Predicate pred = (Predicate)this.elementAt(index);
            ColumnReference indexCol = null;
            RelationalOperator relop = pred.getRelop();
            InListOperatorNode inNode = pred.getSourceInList();
            boolean bl = isIn = inNode != null;
            if (!isIn && (relop == null || !relop.isQualifier(optTable, pushPreds)) || skipProbePreds && pred.isInListProbePredicate()) continue;
            for (indexPosition = 0; indexPosition < baseColumnPositions.length; ++indexPosition) {
                if (isIn) {
                    if (inNode.getLeftOperand() instanceof ColumnReference) {
                        indexCol = (ColumnReference)inNode.getLeftOperand();
                        if (optTable.getTableNumber() != indexCol.getTableNumber() || indexCol.getColumnNumber() != baseColumnPositions[indexPosition] || inNode.selfReference(indexCol)) {
                            indexCol = null;
                        } else if (pred.isInListProbePredicate() && indexPosition > 0) {
                            indexCol = null;
                        }
                    }
                } else {
                    indexCol = relop.getColumnOperand(optTable, baseColumnPositions[indexPosition]);
                }
                if (indexCol != null) break;
            }
            if (indexCol == null) continue;
            pred.setIndexPosition(indexPosition);
            usefulPredicates[usefulCount++] = pred;
        }
        if (usefulCount == 0) {
            return;
        }
        if (usefulPredicates.length > usefulCount) {
            Predicate[] shrink = new Predicate[usefulCount];
            System.arraycopy(usefulPredicates, 0, shrink, 0, usefulCount);
            usefulPredicates = shrink;
        }
        Arrays.sort(usefulPredicates);
        int currentStartPosition = -1;
        boolean gapInStartPositions = false;
        int currentStopPosition = -1;
        boolean gapInStopPositions = false;
        boolean seenNonEquals = false;
        int firstNonEqualsPosition = -1;
        int lastStartEqualsPosition = -1;
        boolean seenGE = false;
        boolean seenGT = false;
        for (int i = 0; i < usefulCount; ++i) {
            boolean isIn;
            Object thisPred = usefulPredicates[i];
            int thisIndexPosition = ((Predicate)thisPred).getIndexPosition();
            boolean thisPredMarked = false;
            RelationalOperator relop = ((Predicate)thisPred).getRelop();
            int thisOperator = -1;
            boolean bl = isIn = ((Predicate)thisPred).getSourceInList() != null;
            if (relop != null) {
                thisOperator = relop.getOperator();
            }
            if (currentStartPosition != thisIndexPosition) {
                if (thisIndexPosition - currentStartPosition > 1) {
                    gapInStartPositions = true;
                } else if (thisOperator == 1 || thisOperator == 7) {
                    lastStartEqualsPosition = thisIndexPosition;
                }
                if (!gapInStartPositions && !seenGT && (isIn || relop.usefulStartKey(optTable) && isAscending[thisIndexPosition] || relop.usefulStopKey(optTable) && !isAscending[thisIndexPosition])) {
                    ((Predicate)thisPred).markStartKey();
                    currentStartPosition = thisIndexPosition;
                    thisPredMarked = true;
                    boolean bl2 = seenGT = ((Predicate)thisPred).getStartOperator(optTable) == -1;
                }
            }
            if (currentStopPosition != thisIndexPosition) {
                if (thisIndexPosition - currentStopPosition > 1) {
                    gapInStopPositions = true;
                }
                if (!gapInStopPositions && !seenGE && (isIn || relop.usefulStopKey(optTable) && isAscending[thisIndexPosition] || relop.usefulStartKey(optTable) && !isAscending[thisIndexPosition])) {
                    ((Predicate)thisPred).markStopKey();
                    currentStopPosition = thisIndexPosition;
                    thisPredMarked = true;
                    boolean bl3 = seenGE = ((Predicate)thisPred).getStopOperator(optTable) == 1;
                }
            }
            if (!isIn && (!thisPredMarked || seenNonEquals && thisIndexPosition != firstNonEqualsPosition)) {
                ((Predicate)thisPred).markQualifier();
            }
            if (lastStartEqualsPosition != thisIndexPosition && firstNonEqualsPosition == -1 && thisOperator != 1 && thisOperator != 7) {
                seenNonEquals = true;
                firstNonEqualsPosition = thisIndexPosition;
            }
            if (pushPreds) {
                Object predToPush;
                if (isIn && !thisPredMarked) continue;
                if (isIn && !((Predicate)thisPred).isInListProbePredicate()) {
                    AndNode andCopy = (AndNode)this.getNodeFactory().getNode(39, ((Predicate)thisPred).getAndNode().getLeftOperand(), ((Predicate)thisPred).getAndNode().getRightOperand(), this.getContextManager());
                    andCopy.copyFields(((Predicate)thisPred).getAndNode());
                    Predicate predCopy = (Predicate)this.getNodeFactory().getNode(78, andCopy, ((Predicate)thisPred).getReferencedSet(), this.getContextManager());
                    predCopy.copyFields((Predicate)thisPred);
                    predToPush = predCopy;
                } else {
                    predToPush = thisPred;
                }
                if (optTable.pushOptPredicate((OptimizablePredicate)predToPush)) {
                    if (isIn && !((Predicate)thisPred).isInListProbePredicate()) continue;
                    this.removeOptPredicate((OptimizablePredicate)thisPred);
                    continue;
                }
                SanityManager.ASSERT(false, "pushOptPredicate expected to be true");
                continue;
            }
            this.removeOptPredicate((OptimizablePredicate)thisPred);
            this.addOptPredicate((OptimizablePredicate)thisPred, i);
        }
    }

    public void addPredicate(Predicate predicate) throws StandardException {
        if (predicate.isStartKey()) {
            ++this.numberOfStartPredicates;
        }
        if (predicate.isStopKey()) {
            ++this.numberOfStopPredicates;
        }
        if (predicate.isQualifier()) {
            ++this.numberOfQualifiers;
        }
        this.addElement(predicate);
    }

    protected void transferNonQualifiers(Optimizable optTable, PredicateList otherPL) throws StandardException {
        for (int index = this.size() - 1; index >= 0; --index) {
            Predicate pred = (Predicate)this.elementAt(index);
            if (pred.isRelationalOpPredicate() && pred.getRelop().isQualifier(optTable, false)) continue;
            pred.clearScanFlags();
            this.removeElementAt(index);
            otherPL.addElement(pred);
        }
        this.markAllPredicatesQualifiers();
    }

    public void categorize() throws StandardException {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ((Predicate)this.elementAt(index)).categorize();
        }
    }

    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
        for (int index = 0; index < this.size(); ++index) {
            Predicate predicate = (Predicate)this.elementAt(index);
            predicate.treePrint(depth + 1);
        }
    }

    public void eliminateBooleanTrueAndBooleanTrue() {
        for (int index = this.size() - 1; index >= 0; --index) {
            AndNode nextAnd = ((Predicate)this.elementAt(index)).getAndNode();
            if (!nextAnd.getLeftOperand().isBooleanTrue() || !nextAnd.getRightOperand().isBooleanTrue()) continue;
            this.removeElementAt(index);
        }
    }

    public ValueNode restoreConstantPredicates() throws StandardException {
        BinaryOperatorNode falseAnd = null;
        ValueNode restriction = null;
        for (int index = this.size() - 1; index >= 0; --index) {
            AndNode nextAnd = ((Predicate)this.elementAt(index)).getAndNode();
            if (!nextAnd.isConstantExpression()) continue;
            this.removeElementAt(index);
            if (nextAnd.getLeftOperand().isBooleanTrue() && nextAnd.getRightOperand().isBooleanTrue()) continue;
            if (nextAnd.getLeftOperand().isBooleanFalse()) {
                falseAnd = nextAnd;
            }
            if (restriction != null) {
                nextAnd.setRightOperand(restriction);
                if (restriction.getTypeServices().isNullable()) {
                    nextAnd.getTypeServices().setNullability(true);
                }
            }
            restriction = nextAnd;
        }
        if (restriction != null && ((AndNode)restriction).getRightOperand().isBooleanTrue()) {
            restriction = ((AndNode)restriction).getLeftOperand();
        } else if (falseAnd != null) {
            restriction = falseAnd.getLeftOperand();
        }
        return restriction;
    }

    public ValueNode restorePredicates() throws StandardException {
        BinaryOperatorNode falseAnd = null;
        ValueNode restriction = null;
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            AndNode nextAnd = ((Predicate)this.elementAt(index)).getAndNode();
            if (nextAnd.getLeftOperand().isBooleanTrue() && nextAnd.getRightOperand().isBooleanTrue()) continue;
            if (nextAnd.getLeftOperand().isBooleanFalse()) {
                falseAnd = nextAnd;
            }
            if (restriction != null) {
                nextAnd.setRightOperand(restriction);
                if (restriction.getTypeServices().isNullable()) {
                    nextAnd.getTypeServices().setNullability(true);
                }
            }
            restriction = nextAnd;
        }
        if (restriction != null && ((AndNode)restriction).getRightOperand().isBooleanTrue()) {
            restriction = ((AndNode)restriction).getLeftOperand();
        } else if (falseAnd != null) {
            restriction = falseAnd.getLeftOperand();
        }
        this.removeAllElements();
        return restriction;
    }

    public void remapColumnReferencesToExpressions() throws StandardException {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            Predicate pred = (Predicate)this.elementAt(index);
            pred.setAndNode((AndNode)pred.getAndNode().remapColumnReferencesToExpressions());
        }
    }

    void pullExpressions(int numTables, ValueNode searchClause) throws StandardException {
        BooleanConstantNode trueNode = null;
        if (searchClause != null) {
            Predicate newPred;
            JBitSet newJBitSet;
            AndNode topAnd = (AndNode)searchClause;
            searchClause = null;
            trueNode = (BooleanConstantNode)this.getNodeFactory().getNode(38, Boolean.TRUE, this.getContextManager());
            while (topAnd.getRightOperand() instanceof AndNode) {
                AndNode thisAnd = topAnd;
                topAnd = (AndNode)topAnd.getRightOperand();
                thisAnd.setRightOperand(null);
                thisAnd.setRightOperand(trueNode);
                newJBitSet = new JBitSet(numTables);
                newPred = (Predicate)this.getNodeFactory().getNode(78, thisAnd, newJBitSet, this.getContextManager());
                this.addPredicate(newPred);
            }
            newJBitSet = new JBitSet(numTables);
            newPred = (Predicate)this.getNodeFactory().getNode(78, topAnd, newJBitSet, this.getContextManager());
            this.addPredicate(newPred);
        }
    }

    public void xorReferencedSet(JBitSet fromMap) {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            Predicate predicate = (Predicate)this.elementAt(index);
            SanityManager.ASSERT(fromMap.size() == predicate.getReferencedSet().size(), "fromMap.size() (" + fromMap.size() + ") does not equal predicate.getReferencedSet().size() (" + predicate.getReferencedSet().size());
            predicate.getReferencedSet().xor(fromMap);
        }
    }

    private void countScanFlags() {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            Predicate predicate = (Predicate)this.elementAt(index);
            if (predicate.isStartKey()) {
                ++this.numberOfStartPredicates;
            }
            if (predicate.isStopKey()) {
                ++this.numberOfStopPredicates;
            }
            if (!predicate.isQualifier()) continue;
            ++this.numberOfQualifiers;
        }
    }

    void pushExpressionsIntoSelect(SelectNode select, boolean copyPredicate) throws StandardException {
        for (int index = this.size() - 1; index >= 0; --index) {
            boolean state;
            Predicate predicate = (Predicate)this.elementAt(index);
            CollectNodesVisitor getCRs = new CollectNodesVisitor(class$org$apache$derby$impl$sql$compile$ColumnReference == null ? PredicateList.class$("org.apache.derby.impl.sql.compile.ColumnReference") : class$org$apache$derby$impl$sql$compile$ColumnReference);
            predicate.getAndNode().accept(getCRs);
            Vector colRefs = getCRs.getList();
            boolean bl = state = colRefs.size() > 0;
            if (state) {
                Enumeration e = colRefs.elements();
                while (e.hasMoreElements()) {
                    ColumnReference ref = (ColumnReference)e.nextElement();
                    if (ref.pointsToColumnReference()) continue;
                    state = false;
                    break;
                }
            }
            if (!state) continue;
            if (copyPredicate) {
                ValueNode leftOperand;
                ColumnReference crNode;
                AndNode andNode = predicate.getAndNode();
                BinaryRelationalOperatorNode opNode = null;
                InListOperatorNode inNode = null;
                if (andNode.getLeftOperand() instanceof BinaryRelationalOperatorNode) {
                    opNode = (BinaryRelationalOperatorNode)andNode.getLeftOperand();
                    if (!(opNode.getLeftOperand() instanceof ColumnReference) || !(opNode.getRightOperand() instanceof ConstantNode) && !(opNode.getRightOperand() instanceof ParameterNode)) continue;
                    crNode = (ColumnReference)opNode.getLeftOperand();
                } else {
                    if (!(andNode.getLeftOperand() instanceof InListOperatorNode) || !(inNode = (InListOperatorNode)andNode.getLeftOperand()).getRightOperandList().isConstantExpression()) continue;
                    crNode = (ColumnReference)inNode.getLeftOperand();
                }
                ColumnReference newCRNode = select.findColumnReferenceInResult(crNode.columnName);
                if (newCRNode == null) continue;
                if (andNode.getLeftOperand() instanceof BinaryRelationalOperatorNode) {
                    inNode = opNode.getInListOp();
                    if (inNode != null) {
                        inNode = inNode.shallowCopy();
                        inNode.setLeftOperand(newCRNode);
                    }
                    BinaryRelationalOperatorNode newRelop = (BinaryRelationalOperatorNode)this.getNodeFactory().getNode(opNode.getNodeType(), newCRNode, opNode.getRightOperand(), inNode, this.getContextManager());
                    newRelop.bindComparisonOperator();
                    leftOperand = newRelop;
                } else {
                    InListOperatorNode newInNode = (InListOperatorNode)this.getNodeFactory().getNode(55, newCRNode, inNode.getRightOperandList(), this.getContextManager());
                    newInNode.setType(inNode.getTypeServices());
                    leftOperand = newInNode;
                }
                ValueNode trueNode = (ValueNode)this.getNodeFactory().getNode(38, Boolean.TRUE, this.getContextManager());
                AndNode newAnd = (AndNode)this.getNodeFactory().getNode(39, leftOperand, trueNode, this.getContextManager());
                newAnd.postBindFixup();
                JBitSet tableMap = new JBitSet(select.referencedTableMap.size());
                predicate = (Predicate)this.getNodeFactory().getNode(78, newAnd, tableMap, this.getContextManager());
            } else {
                if (predicate.isStartKey()) {
                    --this.numberOfStartPredicates;
                }
                if (predicate.isStopKey()) {
                    --this.numberOfStopPredicates;
                }
                if (predicate.isQualifier()) {
                    --this.numberOfQualifiers;
                }
                predicate.clearScanFlags();
                this.removeElementAt(index);
            }
            select.pushExpressionsIntoSelect(predicate);
        }
    }

    void markReferencedColumns() throws StandardException {
        CollectNodesVisitor collectCRs = new CollectNodesVisitor(ColumnReference.class);
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            Predicate predicate = (Predicate)this.elementAt(index);
            predicate.getAndNode().accept(collectCRs);
        }
        Vector colRefs = collectCRs.getList();
        Enumeration e = colRefs.elements();
        while (e.hasMoreElements()) {
            ColumnReference ref = (ColumnReference)e.nextElement();
            ref.getSource().markAllRCsInChainReferenced();
        }
    }

    void checkTopPredicatesForEqualsConditions(int tableNumber, boolean[] eqOuterCols, int[] tableNumbers, JBitSet[] tableColMap, boolean resultColTable) throws StandardException {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            AndNode and = ((Predicate)this.elementAt(index)).getAndNode();
            and.checkTopPredicatesForEqualsConditions(tableNumber, eqOuterCols, tableNumbers, tableColMap, resultColTable);
        }
    }

    boolean allPushable() {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            Predicate predicate = (Predicate)this.elementAt(index);
            if (predicate.getPushable()) continue;
            return false;
        }
        return true;
    }

    PredicateList getPushablePredicates(JBitSet referencedTableMap) throws StandardException {
        PredicateList pushPList = null;
        for (int index = this.size() - 1; index >= 0; --index) {
            JBitSet curBitSet;
            Predicate predicate = (Predicate)this.elementAt(index);
            if (!predicate.getPushable() || !referencedTableMap.contains(curBitSet = predicate.getReferencedSet())) continue;
            if (pushPList == null) {
                pushPList = (PredicateList)this.getNodeFactory().getNode(8, this.getContextManager());
            }
            pushPList.addPredicate(predicate);
            RemapCRsVisitor rcrv = new RemapCRsVisitor(true);
            predicate.getAndNode().accept(rcrv);
            this.removeElementAt(index);
        }
        return pushPList;
    }

    void decrementLevel(FromList fromList, int decrement) {
        int[] tableNumbers = fromList.getTableNumbers();
        int size = this.size();
        block0: for (int index = 0; index < size; ++index) {
            int inner;
            UnaryOperatorNode uon;
            ColumnReference cr1 = null;
            ColumnReference cr2 = null;
            Predicate predicate = (Predicate)this.elementAt(index);
            ValueNode vn = predicate.getAndNode().getLeftOperand();
            if (vn instanceof BinaryOperatorNode) {
                BinaryOperatorNode bon = (BinaryOperatorNode)vn;
                if (bon.getLeftOperand() instanceof ColumnReference) {
                    cr1 = (ColumnReference)bon.getLeftOperand();
                }
                if (bon.getRightOperand() instanceof ColumnReference) {
                    cr2 = (ColumnReference)bon.getRightOperand();
                }
            } else if (vn instanceof UnaryOperatorNode && (uon = (UnaryOperatorNode)vn).getOperand() instanceof ColumnReference) {
                cr1 = (ColumnReference)uon.getOperand();
            }
            if (cr1 != null) {
                int sourceTable = cr1.getTableNumber();
                for (inner = 0; inner < tableNumbers.length; ++inner) {
                    if (tableNumbers[inner] != sourceTable) continue;
                    cr1.setSourceLevel(cr1.getSourceLevel() - decrement);
                    break;
                }
            }
            if (cr2 == null) continue;
            int sourceTable = cr2.getTableNumber();
            for (inner = 0; inner < tableNumbers.length; ++inner) {
                if (tableNumbers[inner] != sourceTable) continue;
                cr2.setSourceLevel(cr2.getSourceLevel() - decrement);
                continue block0;
            }
        }
    }

    void joinClauseTransitiveClosure(int numTables, FromList fromList, CompilerContext cc) throws StandardException {
        int index;
        if (fromList.size() < 3) {
            return;
        }
        PredicateList[] joinClauses = new PredicateList[numTables];
        for (int index2 = 0; index2 < numTables; ++index2) {
            joinClauses[index2] = new PredicateList();
        }
        int size = this.size();
        for (index = 0; index < size; ++index) {
            Predicate predicate = (Predicate)this.elementAt(index);
            ValueNode vn = predicate.getAndNode().getLeftOperand();
            if (!vn.isBinaryEqualsOperatorNode()) continue;
            BinaryRelationalOperatorNode equals = (BinaryRelationalOperatorNode)vn;
            ValueNode left = equals.getLeftOperand();
            ValueNode right = equals.getRightOperand();
            if (!(left instanceof ColumnReference) || !(right instanceof ColumnReference)) continue;
            ColumnReference leftCR = (ColumnReference)left;
            ColumnReference rightCR = (ColumnReference)right;
            if (leftCR.getSourceLevel() != rightCR.getSourceLevel() || leftCR.getTableNumber() == rightCR.getTableNumber() || fromList.tableNumberIsNotExists(leftCR.getTableNumber()) || fromList.tableNumberIsNotExists(rightCR.getTableNumber())) continue;
            joinClauses[leftCR.getTableNumber()].addElement(predicate);
            joinClauses[rightCR.getTableNumber()].addElement(predicate);
        }
        for (index = 0; index < numTables; ++index) {
            PredicateList outerJCL = joinClauses[index];
            if (outerJCL.size() == 0) continue;
            Vector<Predicate> movePreds = new Vector<Predicate>();
            for (int jcIndex = outerJCL.size() - 1; jcIndex >= 0; --jcIndex) {
                Predicate predicate = (Predicate)outerJCL.elementAt(jcIndex);
                if (predicate.getEquivalenceClass() == -1) continue;
                outerJCL.removeElementAt(jcIndex);
                movePreds.addElement(predicate);
            }
            for (int mpIndex = 0; mpIndex < movePreds.size(); ++mpIndex) {
                outerJCL.insertElementAt((Predicate)movePreds.elementAt(mpIndex), 0);
            }
            for (int outerIndex = 0; outerIndex < outerJCL.size(); ++outerIndex) {
                int middleColumnNumber;
                int middleTableNumber;
                int outerColumnNumber;
                ColumnReference innerCR = null;
                ColumnReference outerCR = null;
                int outerTableNumber = index;
                Predicate outerP = (Predicate)outerJCL.elementAt(outerIndex);
                if (outerP.getEquivalenceClass() == -1) {
                    outerP.setEquivalenceClass(cc.getNextEquivalenceClass());
                }
                int outerEC = outerP.getEquivalenceClass();
                BinaryRelationalOperatorNode equals = (BinaryRelationalOperatorNode)outerP.getAndNode().getLeftOperand();
                ColumnReference leftCR = (ColumnReference)equals.getLeftOperand();
                ColumnReference rightCR = (ColumnReference)equals.getRightOperand();
                if (leftCR.getTableNumber() == outerTableNumber) {
                    outerColumnNumber = leftCR.getColumnNumber();
                    middleTableNumber = rightCR.getTableNumber();
                    middleColumnNumber = rightCR.getColumnNumber();
                    outerCR = leftCR;
                } else {
                    outerColumnNumber = rightCR.getColumnNumber();
                    middleTableNumber = leftCR.getTableNumber();
                    middleColumnNumber = leftCR.getColumnNumber();
                    outerCR = rightCR;
                }
                PredicateList middleJCL = joinClauses[middleTableNumber];
                for (int middleIndex = 0; middleIndex < middleJCL.size(); ++middleIndex) {
                    int innerIndex;
                    int innerColumnNumber;
                    int innerTableNumber;
                    Predicate middleP = (Predicate)middleJCL.elementAt(middleIndex);
                    if (middleP.getEquivalenceClass() != -1 && middleP.getEquivalenceClass() != outerEC) continue;
                    BinaryRelationalOperatorNode middleEquals = (BinaryRelationalOperatorNode)middleP.getAndNode().getLeftOperand();
                    ColumnReference mLeftCR = (ColumnReference)middleEquals.getLeftOperand();
                    ColumnReference mRightCR = (ColumnReference)middleEquals.getRightOperand();
                    if (mLeftCR.getTableNumber() == middleTableNumber) {
                        if (mLeftCR.getColumnNumber() != middleColumnNumber) continue;
                        innerTableNumber = mRightCR.getTableNumber();
                        innerColumnNumber = mRightCR.getColumnNumber();
                    } else {
                        if (mRightCR.getColumnNumber() != middleColumnNumber) continue;
                        innerTableNumber = mLeftCR.getTableNumber();
                        innerColumnNumber = mLeftCR.getColumnNumber();
                    }
                    if (outerTableNumber == innerTableNumber && outerColumnNumber == innerColumnNumber) continue;
                    middleP.setEquivalenceClass(outerEC);
                    Predicate innerP = null;
                    PredicateList innerJCL = joinClauses[innerTableNumber];
                    for (innerIndex = 0; innerIndex < innerJCL.size(); ++innerIndex) {
                        int newColumnNumber;
                        int newTableNumber;
                        innerP = (Predicate)innerJCL.elementAt(innerIndex);
                        if (innerP.getEquivalenceClass() != -1 && innerP.getEquivalenceClass() != outerEC) continue;
                        BinaryRelationalOperatorNode innerEquals = (BinaryRelationalOperatorNode)innerP.getAndNode().getLeftOperand();
                        ColumnReference iLeftCR = (ColumnReference)innerEquals.getLeftOperand();
                        ColumnReference iRightCR = (ColumnReference)innerEquals.getRightOperand();
                        if (iLeftCR.getTableNumber() == innerTableNumber) {
                            if (iLeftCR.getColumnNumber() != innerColumnNumber) continue;
                            newTableNumber = iRightCR.getTableNumber();
                            newColumnNumber = iRightCR.getColumnNumber();
                            innerCR = iLeftCR;
                        } else {
                            if (iRightCR.getColumnNumber() != innerColumnNumber) continue;
                            newTableNumber = iLeftCR.getTableNumber();
                            newColumnNumber = iLeftCR.getColumnNumber();
                            innerCR = iRightCR;
                        }
                        if (newTableNumber == outerTableNumber && newColumnNumber == outerColumnNumber) break;
                    }
                    if (innerIndex != innerJCL.size()) {
                        innerP.setEquivalenceClass(outerEC);
                        continue;
                    }
                    BinaryRelationalOperatorNode newEquals = (BinaryRelationalOperatorNode)this.getNodeFactory().getNode(41, outerCR.getClone(), innerCR.getClone(), this.getContextManager());
                    newEquals.bindComparisonOperator();
                    ValueNode trueNode = (ValueNode)this.getNodeFactory().getNode(38, Boolean.TRUE, this.getContextManager());
                    AndNode newAnd = (AndNode)this.getNodeFactory().getNode(39, newEquals, trueNode, this.getContextManager());
                    newAnd.postBindFixup();
                    JBitSet tableMap = new JBitSet(numTables);
                    newAnd.categorize(tableMap, false);
                    Predicate newPred = (Predicate)this.getNodeFactory().getNode(78, newAnd, tableMap, this.getContextManager());
                    newPred.setEquivalenceClass(outerEC);
                    this.addPredicate(newPred);
                    if (outerIndex != outerJCL.size() - 1) {
                        outerJCL.insertElementAt(newPred, outerIndex + 1);
                    } else {
                        outerJCL.addElement(newPred);
                    }
                    innerJCL.addElement(newPred);
                }
            }
        }
    }

    void searchClauseTransitiveClosure(int numTables, boolean hashJoinSpecified) throws StandardException {
        Predicate predicate;
        int index;
        PredicateList equijoinClauses = new PredicateList();
        PredicateList searchClauses = new PredicateList();
        BinaryRelationalOperatorNode equalsNode = null;
        int size = this.size();
        for (index = 0; index < size; ++index) {
            ValueNode right;
            ValueNode left;
            predicate = (Predicate)this.elementAt(index);
            AndNode andNode = predicate.getAndNode();
            if (!predicate.isRelationalOpPredicate()) continue;
            RelationalOperator operator = (RelationalOperator)((Object)andNode.getLeftOperand());
            if (((ValueNode)((Object)operator)).isBinaryEqualsOperatorNode()) {
                BinaryRelationalOperatorNode equals;
                equalsNode = equals = (BinaryRelationalOperatorNode)operator;
                left = equals.getLeftOperand();
                right = equals.getRightOperand();
                if (left instanceof ColumnReference && right instanceof ColumnReference) {
                    ColumnReference leftCR = (ColumnReference)left;
                    ColumnReference rightCR = (ColumnReference)right;
                    if (leftCR.getSourceLevel() != rightCR.getSourceLevel() || leftCR.getTableNumber() == rightCR.getTableNumber()) continue;
                    equijoinClauses.addElement(predicate);
                    continue;
                }
            }
            if (operator instanceof UnaryComparisonOperatorNode) {
                if (!(((UnaryComparisonOperatorNode)((Object)operator)).getOperand() instanceof ColumnReference)) continue;
                searchClauses.addElement(predicate);
                continue;
            }
            if (!(operator instanceof BinaryComparisonOperatorNode)) continue;
            BinaryComparisonOperatorNode bcon = (BinaryComparisonOperatorNode)((Object)operator);
            left = bcon.getLeftOperand();
            right = bcon.getRightOperand();
            if (left instanceof ColumnReference && (right instanceof ConstantNode || right instanceof ParameterNode)) {
                searchClauses.addElement(predicate);
                continue;
            }
            if (!(right instanceof ConstantNode) || !(left instanceof ColumnReference)) continue;
            bcon.swapOperands();
            searchClauses.addElement(predicate);
        }
        if (equijoinClauses.size() == 0 || searchClauses.size() == 0) {
            return;
        }
        for (int scIndex = 0; scIndex < searchClauses.size(); ++scIndex) {
            ColumnReference searchCR;
            DataValueDescriptor searchODV = null;
            RelationalOperator ro = (RelationalOperator)((Object)((Predicate)searchClauses.elementAt(scIndex)).getAndNode().getLeftOperand());
            if (ro instanceof UnaryComparisonOperatorNode) {
                searchCR = (ColumnReference)((UnaryComparisonOperatorNode)((Object)ro)).getOperand();
            } else {
                searchCR = (ColumnReference)((BinaryComparisonOperatorNode)((Object)ro)).getLeftOperand();
                if (((BinaryComparisonOperatorNode)((Object)ro)).getRightOperand() instanceof ConstantNode) {
                    ConstantNode currCN = (ConstantNode)((BinaryComparisonOperatorNode)((Object)ro)).getRightOperand();
                    searchODV = currCN.getValue();
                } else {
                    searchODV = null;
                }
            }
            int tableNumber = searchCR.getTableNumber();
            int colNumber = searchCR.getColumnNumber();
            int ejcSize = equijoinClauses.size();
            for (int ejcIndex = 0; ejcIndex < ejcSize; ++ejcIndex) {
                ColumnReference otherCR;
                Predicate predicate2 = (Predicate)equijoinClauses.elementAt(ejcIndex);
                if (predicate2.transitiveSearchClauseAdded(ro)) continue;
                BinaryRelationalOperatorNode equals = (BinaryRelationalOperatorNode)predicate2.getAndNode().getLeftOperand();
                ColumnReference leftCR = (ColumnReference)equals.getLeftOperand();
                ColumnReference rightCR = (ColumnReference)equals.getRightOperand();
                if (leftCR.getTableNumber() == tableNumber && leftCR.getColumnNumber() == colNumber) {
                    otherCR = rightCR;
                } else {
                    if (rightCR.getTableNumber() != tableNumber || rightCR.getColumnNumber() != colNumber) continue;
                    otherCR = leftCR;
                }
                predicate2.setTransitiveSearchClauseAdded(ro);
                boolean match = false;
                ColumnReference searchCR2 = null;
                RelationalOperator ro2 = null;
                int scSize = searchClauses.size();
                for (int scIndex2 = 0; scIndex2 < scSize; ++scIndex2) {
                    DataValueDescriptor currODV = null;
                    ro2 = (RelationalOperator)((Object)((Predicate)searchClauses.elementAt(scIndex2)).getAndNode().getLeftOperand());
                    if (ro2 instanceof UnaryComparisonOperatorNode) {
                        searchCR2 = (ColumnReference)((UnaryComparisonOperatorNode)((Object)ro2)).getOperand();
                    } else {
                        searchCR2 = (ColumnReference)((BinaryComparisonOperatorNode)((Object)ro2)).getLeftOperand();
                        if (((BinaryComparisonOperatorNode)((Object)ro2)).getRightOperand() instanceof ConstantNode) {
                            ConstantNode currCN = (ConstantNode)((BinaryComparisonOperatorNode)((Object)ro2)).getRightOperand();
                            currODV = currCN.getValue();
                        } else {
                            currODV = null;
                        }
                    }
                    if (searchCR2.getTableNumber() != otherCR.getTableNumber() || searchCR2.getColumnNumber() != otherCR.getColumnNumber() || (currODV == null || searchODV == null || currODV.compare(searchODV) != 0) && (currODV != null || searchODV != null) || ro2.getOperator() != ro.getOperator() || !ro2.getClass().getName().equals(ro.getClass().getName())) continue;
                    match = true;
                    break;
                }
                if (match) continue;
                RelationalOperator roClone = ro.getTransitiveSearchClause((ColumnReference)otherCR.getClone());
                if (roClone instanceof BinaryComparisonOperatorNode) {
                    ((BinaryComparisonOperatorNode)((Object)roClone)).bindComparisonOperator();
                } else {
                    ((UnaryComparisonOperatorNode)((Object)roClone)).bindComparisonOperator();
                }
                ValueNode trueNode = (ValueNode)this.getNodeFactory().getNode(38, Boolean.TRUE, this.getContextManager());
                AndNode newAnd = (AndNode)this.getNodeFactory().getNode(39, roClone, trueNode, this.getContextManager());
                newAnd.postBindFixup();
                JBitSet tableMap = new JBitSet(numTables);
                newAnd.categorize(tableMap, false);
                Predicate newPred = (Predicate)this.getNodeFactory().getNode(78, newAnd, tableMap, this.getContextManager());
                this.addPredicate(newPred);
                searchClauses.addElement(newPred);
            }
        }
        if (hashJoinSpecified) {
            return;
        }
        for (index = this.size() - 1; index >= 0; --index) {
            predicate = (Predicate)this.elementAt(index);
            if (!predicate.transitiveSearchClauseAdded(equalsNode)) continue;
            this.removeElementAt(index);
        }
    }

    void removeRedundantPredicates() {
        int outer = this.size() - 1;
        while (outer >= 0) {
            Predicate predicate = (Predicate)this.elementAt(outer);
            int equivalenceClass = predicate.getEquivalenceClass();
            if (equivalenceClass == -1) {
                --outer;
                continue;
            }
            for (int inner = outer - 1; inner >= 0; --inner) {
                Predicate innerPredicate = (Predicate)this.elementAt(inner);
                if (innerPredicate.getEquivalenceClass() != equivalenceClass) continue;
                if (innerPredicate.isStartKey()) {
                    predicate.markStartKey();
                }
                if (innerPredicate.isStopKey()) {
                    predicate.markStopKey();
                }
                if ((innerPredicate.isStartKey() || innerPredicate.isStopKey()) && innerPredicate.isQualifier() && !predicate.isQualifier()) {
                    predicate.markQualifier();
                    ++this.numberOfQualifiers;
                }
                if (innerPredicate.isQualifier()) {
                    --this.numberOfQualifiers;
                }
                this.removeElementAt(inner);
                --outer;
            }
            --outer;
        }
    }

    public void transferPredicates(OptimizablePredicateList otherList, JBitSet referencedTableMap, Optimizable table) throws StandardException {
        PredicateList theOtherList = (PredicateList)otherList;
        for (int index = this.size() - 1; index >= 0; --index) {
            Predicate predicate = (Predicate)this.elementAt(index);
            if (referencedTableMap.size() != predicate.getReferencedSet().size()) {
                SanityManager.THROWASSERT("referencedTableMap.size() (" + referencedTableMap.size() + ") does not equal predicate.getReferencedSet().size() (" + predicate.getReferencedSet().size());
            }
            if (!referencedTableMap.contains(predicate.getReferencedSet())) continue;
            if (predicate.isStartKey()) {
                --this.numberOfStartPredicates;
            }
            if (predicate.isStopKey()) {
                --this.numberOfStopPredicates;
            }
            if (predicate.isQualifier()) {
                --this.numberOfQualifiers;
            }
            predicate.clearScanFlags();
            theOtherList.addPredicate(predicate);
            this.removeElementAt(index);
        }
        AccessPath ap = table.getTrulyTheBestAccessPath();
        theOtherList.orderUsefulPredicates(table, ap.getConglomerateDescriptor(), false, ap.getNonMatchingIndexScan(), ap.getCoveringIndexScan());
        theOtherList.countScanFlags();
    }

    public void transferAllPredicates(OptimizablePredicateList otherList) throws StandardException {
        PredicateList theOtherList = (PredicateList)otherList;
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            Predicate predicate = (Predicate)this.elementAt(index);
            predicate.clearScanFlags();
            theOtherList.addPredicate(predicate);
        }
        this.removeAllElements();
        this.numberOfStartPredicates = 0;
        this.numberOfStopPredicates = 0;
        this.numberOfQualifiers = 0;
    }

    public void copyPredicatesToOtherList(OptimizablePredicateList otherList) throws StandardException {
        for (int i = 0; i < this.size(); ++i) {
            otherList.addOptPredicate(this.getOptPredicate(i));
        }
    }

    public boolean isRedundantPredicate(int predNum) {
        Predicate pred = (Predicate)this.elementAt(predNum);
        if (pred.getEquivalenceClass() == -1) {
            return false;
        }
        for (int index = 0; index < predNum; ++index) {
            if (((Predicate)this.elementAt(index)).getEquivalenceClass() != pred.getEquivalenceClass()) continue;
            return true;
        }
        return false;
    }

    public void setPredicatesAndProperties(OptimizablePredicateList otherList) throws StandardException {
        PredicateList theOtherList = (PredicateList)otherList;
        theOtherList.removeAllElements();
        for (int i = 0; i < this.size(); ++i) {
            theOtherList.addOptPredicate(this.getOptPredicate(i));
        }
        theOtherList.numberOfStartPredicates = this.numberOfStartPredicates;
        theOtherList.numberOfStopPredicates = this.numberOfStopPredicates;
        theOtherList.numberOfQualifiers = this.numberOfQualifiers;
    }

    public int startOperator(Optimizable optTable) {
        int startOperator = -1;
        int size = this.size();
        for (int index = size - 1; index >= 0; --index) {
            Predicate pred = (Predicate)this.elementAt(index);
            if (!pred.isStartKey()) continue;
            startOperator = pred.getStartOperator(optTable);
            break;
        }
        return startOperator;
    }

    public void generateStopKey(ExpressionClassBuilderInterface acbi, MethodBuilder mb, Optimizable optTable) throws StandardException {
        ExpressionClassBuilder acb = (ExpressionClassBuilder)acbi;
        if (this.numberOfStopPredicates != 0) {
            MethodBuilder exprFun = acb.newExprFun();
            LocalField rowField = this.generateIndexableRow(acb, this.numberOfStopPredicates);
            int colNum = 0;
            int size = this.size();
            for (int index = 0; index < size; ++index) {
                Predicate pred = (Predicate)this.elementAt(index);
                if (!pred.isStopKey()) continue;
                this.generateSetColumn(acb, exprFun, colNum, pred, optTable, rowField, false);
                ++colNum;
            }
            SanityManager.ASSERT(colNum == this.numberOfStopPredicates, "Number of stop predicates does not match");
            this.finishKey(acb, mb, exprFun, rowField);
            return;
        }
        mb.pushNull("org.apache.derby.iapi.services.loader.GeneratedMethod");
    }

    public int stopOperator(Optimizable optTable) {
        int stopOperator = -1;
        int size = this.size();
        for (int index = size - 1; index >= 0; --index) {
            Predicate pred = (Predicate)this.elementAt(index);
            if (!pred.isStopKey()) continue;
            stopOperator = pred.getStopOperator(optTable);
            break;
        }
        return stopOperator;
    }

    private void generateSingleQualifierCode(MethodBuilder consMB, Optimizable optTable, boolean absolute, ExpressionClassBuilder acb, RelationalOperator or_node, LocalField qualField, int array_idx_1, int array_idx_2) throws StandardException {
        consMB.getField(qualField);
        consMB.pushThis();
        consMB.callMethod((short)182, acb.getBaseClassName(), "getExecutionFactory", "org.apache.derby.iapi.sql.execute.ExecutionFactory", 0);
        if (absolute) {
            or_node.generateAbsoluteColumnId(consMB, optTable);
        } else {
            or_node.generateRelativeColumnId(consMB, optTable);
        }
        or_node.generateOperator(consMB, optTable);
        or_node.generateQualMethod(acb, consMB, optTable);
        acb.pushThisAsActivation(consMB);
        or_node.generateOrderedNulls(consMB);
        or_node.generateNegate(consMB, optTable);
        or_node.generateNegate(consMB, optTable);
        consMB.push(or_node.getOrderableVariantType(optTable));
        consMB.callMethod((short)185, "org.apache.derby.iapi.sql.execute.ExecutionFactory", "getQualifier", "org.apache.derby.iapi.store.access.Qualifier", 8);
        consMB.push(array_idx_1);
        consMB.push(array_idx_2);
        consMB.callMethod((short)184, acb.getBaseClassName(), "setQualifier", "void", 4);
    }

    protected void generateInListValues(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        for (int index = this.size() - 1; index >= 0; --index) {
            Predicate pred = (Predicate)this.elementAt(index);
            if (!pred.isInListProbePredicate()) continue;
            this.removeOptPredicate(pred);
            for (int i = 0; i < index; ++i) {
                if (!((Predicate)this.elementAt(i)).isInListProbePredicate()) continue;
                SanityManager.THROWASSERT("Found multiple probe predicates for IN-list when only one was expected.");
            }
            InListOperatorNode ilon = pred.getSourceInList();
            mb.getField(ilon.generateListAsArray(acb, mb));
            mb.push(ilon.isOrdered());
            return;
        }
        SanityManager.THROWASSERT("Attempted to generate IN-list valuesfor multi-probing but no probe predicates were found.");
    }

    public void generateQualifiers(ExpressionClassBuilderInterface acbi, MethodBuilder mb, Optimizable optTable, boolean absolute) throws StandardException {
        ExpressionClassBuilder acb = (ExpressionClassBuilder)acbi;
        String retvalType = "org.apache.derby.iapi.store.access.Qualifier[][]";
        MethodBuilder consMB = acb.getConstructor();
        MethodBuilder executeMB = acb.getExecuteMethod();
        LocalField qualField = acb.newFieldDeclaration(2, retvalType);
        executeMB.getField(qualField);
        executeMB.callMethod((short)184, acb.getBaseClassName(), "reinitializeQualifiers", "void", 1);
        if (this.numberOfQualifiers != 0) {
            if (this.numberOfQualifiers > this.size()) {
                SanityManager.THROWASSERT("numberOfQualifiers(" + this.numberOfQualifiers + ") > size(" + this.size() + ")." + ":" + this.hashCode());
            }
            int num_of_or_conjunctions = 0;
            for (int i = 0; i < this.numberOfQualifiers; ++i) {
                if (!((Predicate)this.elementAt(i)).isOrList()) continue;
                ++num_of_or_conjunctions;
            }
            consMB.pushNewArray("org.apache.derby.iapi.store.access.Qualifier[]", num_of_or_conjunctions + 1);
            consMB.setField(qualField);
            consMB.getField(qualField);
            consMB.push(0);
            consMB.push(this.numberOfQualifiers - num_of_or_conjunctions);
            consMB.callMethod((short)184, acb.getBaseClassName(), "allocateQualArray", "void", 3);
        }
        if (this.numberOfQualifiers > 0) {
            this.orderQualifiers();
        }
        int qualNum = 0;
        int size = this.size();
        boolean gotOrQualifier = false;
        for (int index = 0; index < size; ++index) {
            Predicate pred = (Predicate)this.elementAt(index);
            if (!pred.isQualifier()) continue;
            if (pred.isOrList()) {
                gotOrQualifier = true;
                break;
            }
            this.generateSingleQualifierCode(consMB, optTable, absolute, acb, pred.getRelop(), qualField, 0, qualNum);
            ++qualNum;
        }
        if (gotOrQualifier) {
            int and_idx = 1;
            int index = qualNum;
            while (index < size) {
                Predicate pred = (Predicate)this.elementAt(index);
                SanityManager.ASSERT(pred.isOrList());
                ArrayList<ValueNode> a_list = new ArrayList<ValueNode>();
                ValueNode node = pred.getAndNode().getLeftOperand();
                while (node instanceof OrNode) {
                    OrNode or_node = (OrNode)node;
                    if (or_node.getLeftOperand() instanceof RelationalOperator) {
                        a_list.add(or_node.getLeftOperand());
                    }
                    node = or_node.getRightOperand();
                }
                consMB.getField(qualField);
                consMB.push(and_idx);
                consMB.push(a_list.size());
                consMB.callMethod((short)184, acb.getBaseClassName(), "allocateQualArray", "void", 3);
                for (int i = 0; i < a_list.size(); ++i) {
                    this.generateSingleQualifierCode(consMB, optTable, absolute, acb, (RelationalOperator)a_list.get(i), qualField, and_idx, i);
                }
                ++qualNum;
                ++index;
                ++and_idx;
            }
        }
        SanityManager.ASSERT(qualNum == this.numberOfQualifiers, qualNum + " Qualifiers found, " + this.numberOfQualifiers + " expected.");
        mb.getField(qualField);
    }

    private void orderQualifiers() {
        int predIndex;
        PredicateList[] sortList = new PredicateList[5];
        for (int i = sortList.length - 1; i >= 0; --i) {
            sortList[i] = new PredicateList();
        }
        int size = this.size();
        for (predIndex = 0; predIndex < size; ++predIndex) {
            Predicate pred = (Predicate)this.elementAt(predIndex);
            if (!pred.isQualifier()) {
                sortList[3].addElement(pred);
                continue;
            }
            AndNode node = pred.getAndNode();
            if (!(node.getLeftOperand() instanceof OrNode)) {
                RelationalOperator relop = (RelationalOperator)((Object)node.getLeftOperand());
                int op = relop.getOperator();
                switch (op) {
                    case 1: 
                    case 7: {
                        sortList[0].addElement(pred);
                        break;
                    }
                    case 2: 
                    case 8: {
                        sortList[2].addElement(pred);
                        break;
                    }
                    default: {
                        sortList[1].addElement(pred);
                        break;
                    }
                }
                continue;
            }
            sortList[4].addElement(pred);
        }
        predIndex = 0;
        for (int index = 0; index < 5; ++index) {
            for (int items = 0; items < sortList[index].size(); ++items) {
                this.setElementAt(sortList[index].elementAt(items), predIndex++);
            }
        }
    }

    public void generateStartKey(ExpressionClassBuilderInterface acbi, MethodBuilder mb, Optimizable optTable) throws StandardException {
        ExpressionClassBuilder acb = (ExpressionClassBuilder)acbi;
        if (this.numberOfStartPredicates != 0) {
            MethodBuilder exprFun = acb.newExprFun();
            LocalField rowField = this.generateIndexableRow(acb, this.numberOfStartPredicates);
            int colNum = 0;
            int size = this.size();
            for (int index = 0; index < size; ++index) {
                Predicate pred = (Predicate)this.elementAt(index);
                if (!pred.isStartKey()) continue;
                this.generateSetColumn(acb, exprFun, colNum, pred, optTable, rowField, true);
                ++colNum;
            }
            SanityManager.ASSERT(colNum == this.numberOfStartPredicates, "Number of start predicates does not match");
            this.finishKey(acb, mb, exprFun, rowField);
            return;
        }
        mb.pushNull("org.apache.derby.iapi.services.loader.GeneratedMethod");
    }

    public boolean sameStartStopPosition() throws StandardException {
        if (this.numberOfStartPredicates != this.numberOfStopPredicates) {
            return false;
        }
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            Predicate pred = (Predicate)this.elementAt(index);
            if (pred.isStartKey() && !pred.isStopKey() || pred.isStopKey() && !pred.isStartKey()) {
                return false;
            }
            if (!(pred.getAndNode().getLeftOperand() instanceof InListOperatorNode)) continue;
            return false;
        }
        return true;
    }

    private LocalField generateIndexableRow(ExpressionClassBuilder acb, int numberOfColumns) {
        MethodBuilder mb = acb.getConstructor();
        acb.pushGetExecutionFactoryExpression(mb);
        mb.push(numberOfColumns);
        mb.callMethod((short)185, "org.apache.derby.iapi.sql.execute.ExecutionFactory", "getIndexableRow", "org.apache.derby.iapi.sql.execute.ExecIndexRow", 1);
        LocalField field = acb.newFieldDeclaration(2, "org.apache.derby.iapi.sql.execute.ExecIndexRow");
        mb.setField(field);
        return field;
    }

    private void generateSetColumn(ExpressionClassBuilder acb, MethodBuilder exprFun, int columnNumber, Predicate pred, Optimizable optTable, LocalField rowField, boolean isStartKey) throws StandardException {
        MethodBuilder mb;
        boolean withKnownConstant = false;
        if (pred.compareWithKnownConstant(optTable, false)) {
            withKnownConstant = true;
            mb = acb.getConstructor();
        } else {
            mb = exprFun;
        }
        int[] baseColumns = optTable.getTrulyTheBestAccessPath().getConglomerateDescriptor().getIndexDescriptor().baseColumnPositions();
        boolean[] isAscending = optTable.getTrulyTheBestAccessPath().getConglomerateDescriptor().getIndexDescriptor().isAscending();
        boolean isIn = pred.getAndNode().getLeftOperand() instanceof InListOperatorNode;
        mb.getField(rowField);
        mb.push(columnNumber + 1);
        if (isIn) {
            pred.getSourceInList().generateStartStopKey(isAscending[columnNumber], isStartKey, acb, mb);
        } else {
            pred.generateExpressionOperand(optTable, baseColumns[columnNumber], acb, mb);
        }
        mb.upCast("org.apache.derby.iapi.types.DataValueDescriptor");
        mb.callMethod((short)185, "org.apache.derby.iapi.sql.Row", "setColumn", "void", 2);
        if (!isIn) {
            RelationalOperator relop = pred.getRelop();
            boolean setOrderedNulls = relop.orderedNulls();
            if (!setOrderedNulls && !relop.getColumnOperand(optTable).getTypeServices().isNullable()) {
                if (withKnownConstant) {
                    setOrderedNulls = true;
                } else {
                    ValueNode keyExp = relop.getExpressionOperand(optTable.getTableNumber(), baseColumns[columnNumber], (FromTable)optTable);
                    if (keyExp instanceof ColumnReference) {
                        boolean bl = setOrderedNulls = !((ColumnReference)keyExp).getTypeServices().isNullable();
                    }
                }
            }
            if (setOrderedNulls) {
                mb.getField(rowField);
                mb.push(columnNumber);
                mb.callMethod((short)185, "org.apache.derby.iapi.sql.execute.ExecIndexRow", "orderedNulls", "void", 1);
            }
        }
    }

    private void finishKey(ExpressionClassBuilder acb, MethodBuilder mb, MethodBuilder exprFun, LocalField rowField) {
        exprFun.getField(rowField);
        exprFun.methodReturn();
        exprFun.complete();
        acb.pushMethodReference(mb, exprFun);
    }

    boolean constantColumn(ColumnReference colRef) {
        boolean retval = false;
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            ColumnReference columnOp;
            Predicate pred = (Predicate)this.elementAt(index);
            RelationalOperator relop = pred.getRelop();
            if (!pred.isRelationalOpPredicate()) continue;
            if (relop.getOperator() == 1) {
                ValueNode exprOp = relop.getOperand(colRef, pred.getReferencedSet().size(), true);
                if (exprOp == null || !exprOp.isConstantExpression()) continue;
                retval = true;
                break;
            }
            if (relop.getOperator() != 7 || (columnOp = (ColumnReference)relop.getOperand(colRef, pred.getReferencedSet().size(), false)) == null) continue;
            retval = true;
        }
        return retval;
    }

    public double selectivity(Optimizable optTable) throws StandardException {
        TableDescriptor td = optTable.getTableDescriptor();
        ConglomerateDescriptor[] conglomerates = td.getConglomerateDescriptors();
        int numPredicates = this.size();
        int numConglomerates = conglomerates.length;
        if (numConglomerates == 1) {
            return -1.0;
        }
        if (numPredicates == 0) {
            return -1.0;
        }
        boolean nothingYet = true;
        PredicateList workingPredicates = new PredicateList();
        for (int i = 0; i < numPredicates; ++i) {
            if (this.isRedundantPredicate(i)) continue;
            workingPredicates.addOptPredicate((Predicate)this.elementAt(i));
        }
        int numWorkingPredicates = workingPredicates.size();
        PredicateWrapperList[] predsForConglomerates = new PredicateWrapperList[numConglomerates];
        for (int i = 0; i < numConglomerates; ++i) {
            ConglomerateDescriptor cd = conglomerates[i];
            if (!cd.isIndex() || !td.statisticsExist(cd)) continue;
            int[] baseColumnList = cd.getIndexDescriptor().baseColumnPositions();
            for (int j = 0; j < numWorkingPredicates; ++j) {
                Predicate pred = (Predicate)workingPredicates.elementAt(j);
                int ip = pred.hasEqualOnColumnList(baseColumnList, optTable);
                if (ip < 0) continue;
                nothingYet = false;
                if (predsForConglomerates[i] == null) {
                    predsForConglomerates[i] = new PredicateWrapperList(numWorkingPredicates);
                }
                PredicateWrapper newpw = new PredicateWrapper(ip, pred, j);
                predsForConglomerates[i].insert(newpw);
            }
        }
        if (nothingYet) {
            return -1.0;
        }
        int maxOverlap = -1;
        for (int i = 0; i < numConglomerates; ++i) {
            if (predsForConglomerates[i] == null) continue;
            predsForConglomerates[i].retainLeadingContiguous();
        }
        this.calculateWeight(predsForConglomerates, numWorkingPredicates);
        Vector statistics = new Vector(numWorkingPredicates);
        double selectivity = 1.0;
        Vector maxPreds = new Vector();
        do {
            maxPreds.removeAllElements();
            int conglomIndex = this.chooseLongestMatch(predsForConglomerates, maxPreds, numWorkingPredicates);
            if (conglomIndex == -1) break;
            selectivity *= td.selectivityForConglomerate(conglomerates[conglomIndex], maxPreds.size());
            for (int i = 0; i < maxPreds.size(); ++i) {
                Predicate p = (Predicate)maxPreds.elementAt(i);
                workingPredicates.removeOptPredicate(p);
            }
        } while (workingPredicates.size() != 0);
        if (workingPredicates.size() != 0) {
            selectivity *= workingPredicates.selectivityNoStatistics(optTable);
        }
        return selectivity;
    }

    private void calculateWeight(PredicateWrapperList[] pwList, int numUsefulPredicates) {
        int i;
        int[] s = new int[numUsefulPredicates];
        for (i = 0; i < pwList.length; ++i) {
            if (pwList[i] == null) continue;
            for (int j = 0; j < pwList[i].size(); ++j) {
                int n = pwList[i].elementAt(j).getPredicateID();
                s[n] = s[n] + (numUsefulPredicates - j);
            }
        }
        for (i = 0; i < pwList.length; ++i) {
            int w = 0;
            if (pwList[i] == null) continue;
            for (int j = 0; j < pwList[i].size(); ++j) {
                w += s[pwList[i].elementAt(j).getPredicateID()];
            }
            pwList[i].setWeight(w);
        }
    }

    private int chooseLongestMatch(PredicateWrapperList[] predArray, Vector ret, int numWorkingPredicates) {
        int i;
        int max = 0;
        int maxWeight = 0;
        int position = -1;
        for (int i2 = 0; i2 < predArray.length; ++i2) {
            if (predArray[i2] == null || predArray[i2].uniqueSize() == 0) continue;
            if (predArray[i2].uniqueSize() > max) {
                max = predArray[i2].uniqueSize();
                position = i2;
                maxWeight = predArray[i2].getWeight();
            }
            if (predArray[i2].uniqueSize() != max || predArray[i2].getWeight() > maxWeight) continue;
            position = i2;
            max = predArray[i2].uniqueSize();
            maxWeight = predArray[i2].getWeight();
        }
        if (position == -1) {
            return -1;
        }
        PredicateWrapperList pwl = predArray[position];
        Vector uniquepreds = pwl.createLeadingUnique();
        for (i = 0; i < uniquepreds.size(); ++i) {
            Predicate p = ((PredicateWrapper)uniquepreds.elementAt(i)).getPredicate();
            ret.addElement(p);
            for (int j = 0; j < predArray.length; ++j) {
                if (predArray[j] == null) continue;
                pwl = predArray[j];
                pwl.removeElement(p);
            }
        }
        for (i = 0; i < predArray.length; ++i) {
            if (predArray[i] == null) continue;
            predArray[i].retainLeadingContiguous();
        }
        this.calculateWeight(predArray, numWorkingPredicates);
        return position;
    }

    private double selectivityNoStatistics(Optimizable optTable) throws StandardException {
        double selectivity = 1.0;
        for (int i = 0; i < this.size(); ++i) {
            OptimizablePredicate pred = (OptimizablePredicate)((Object)this.elementAt(i));
            selectivity *= pred.selectivity(optTable);
        }
        return selectivity;
    }

    private class PredicateWrapperList {
        Vector pwList;
        int numPreds;
        int numDuplicates;
        int weight;

        PredicateWrapperList(int maxValue) {
            this.pwList = new Vector(maxValue);
        }

        void removeElement(PredicateWrapper pw) {
            int index = this.pwList.indexOf(pw);
            if (index >= 0) {
                this.removeElementAt(index);
            }
        }

        void removeElement(Predicate p) {
            for (int i = this.numPreds - 1; i >= 0; --i) {
                Predicate predOnList = this.elementAt(i).getPredicate();
                if (predOnList != p) continue;
                this.removeElementAt(i);
            }
        }

        void removeElementAt(int index) {
            PredicateWrapper nextPW;
            if (index < this.numPreds - 1 && (nextPW = this.elementAt(index + 1)).getIndexPosition() == index) {
                --this.numDuplicates;
            }
            this.pwList.removeElementAt(index);
            --this.numPreds;
        }

        PredicateWrapper elementAt(int i) {
            return (PredicateWrapper)this.pwList.elementAt(i);
        }

        void insert(PredicateWrapper pw) {
            int i;
            for (i = 0; i < this.pwList.size(); ++i) {
                if (pw.getIndexPosition() == this.elementAt(i).getIndexPosition()) {
                    ++this.numDuplicates;
                }
                if (pw.before(this.elementAt(i))) break;
            }
            ++this.numPreds;
            this.pwList.insertElementAt(pw, i);
        }

        int size() {
            return this.numPreds;
        }

        int uniqueSize() {
            if (this.numPreds > 0) {
                return this.numPreds - this.numDuplicates;
            }
            return 0;
        }

        void retainLeadingContiguous() {
            int j;
            if (this.pwList == null) {
                return;
            }
            if (this.pwList.size() == 0) {
                return;
            }
            if (this.elementAt(0).getIndexPosition() != 0) {
                this.pwList.removeAllElements();
                this.numDuplicates = 0;
                this.numPreds = 0;
                return;
            }
            for (j = 0; j < this.numPreds - 1 && this.elementAt(j).contiguous(this.elementAt(j + 1)); ++j) {
            }
            for (int k = this.numPreds - 1; k > j; --k) {
                if (this.elementAt(k).getIndexPosition() == this.elementAt(k - 1).getIndexPosition()) {
                    --this.numDuplicates;
                }
                this.pwList.removeElementAt(k);
            }
            this.numPreds = j + 1;
        }

        Vector createLeadingUnique() {
            Vector<PredicateWrapper> scratch = new Vector<PredicateWrapper>();
            if (this.numPreds == 0) {
                return null;
            }
            int lastIndexPosition = this.elementAt(0).getIndexPosition();
            if (lastIndexPosition != 0) {
                return null;
            }
            scratch.addElement(this.elementAt(0));
            for (int i = 1; i < this.numPreds; ++i) {
                if (this.elementAt(i).getIndexPosition() == lastIndexPosition) continue;
                lastIndexPosition = this.elementAt(i).getIndexPosition();
                scratch.addElement(this.elementAt(i));
            }
            return scratch;
        }

        void setWeight(int weight) {
            this.weight = weight;
        }

        int getWeight() {
            return this.weight;
        }
    }

    private class PredicateWrapper {
        int indexPosition;
        Predicate pred;
        int predicateID;

        PredicateWrapper(int ip, Predicate p, int predicateID) {
            this.indexPosition = ip;
            this.pred = p;
            this.predicateID = predicateID;
        }

        int getIndexPosition() {
            return this.indexPosition;
        }

        Predicate getPredicate() {
            return this.pred;
        }

        int getPredicateID() {
            return this.predicateID;
        }

        boolean before(PredicateWrapper other) {
            return this.indexPosition < other.getIndexPosition();
        }

        boolean contiguous(PredicateWrapper other) {
            int otherIP = other.getIndexPosition();
            return this.indexPosition == otherIP || this.indexPosition - otherIP == 1 || this.indexPosition - otherIP == -1;
        }
    }
}

