/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Hashtable;
import org.apache.derby.impl.sql.compile.OrderedColumn;
import org.apache.derby.impl.sql.compile.QueryTreeNodeVector;
import org.apache.derby.impl.sql.execute.IndexColumnOrder;

public abstract class OrderedColumnList
extends QueryTreeNodeVector {
    public IndexColumnOrder[] getColumnOrdering() {
        int numCols = this.size();
        IndexColumnOrder[] ordering = new IndexColumnOrder[numCols];
        Hashtable<Integer, Integer> hashColumns = new Hashtable<Integer, Integer>();
        int actualCols = 0;
        for (int i = 0; i < numCols; ++i) {
            OrderedColumn oc = (OrderedColumn)this.elementAt(i);
            int position = oc.getColumnPosition() - 1;
            Integer posInt = new Integer(position);
            if (hashColumns.containsKey(posInt)) continue;
            ordering[i] = new IndexColumnOrder(position, oc.isAscending());
            ++actualCols;
            hashColumns.put(posInt, posInt);
        }
        if (actualCols < numCols) {
            IndexColumnOrder[] newOrdering = new IndexColumnOrder[actualCols];
            System.arraycopy(ordering, 0, newOrdering, 0, actualCols);
            ordering = newOrdering;
        }
        return ordering;
    }
}

