/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.RequiredRowOrdering;
import org.apache.derby.iapi.sql.compile.RowOrdering;
import org.apache.derby.iapi.store.access.ColumnOrdering;
import org.apache.derby.iapi.store.access.SortCostController;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.OrderByColumn;
import org.apache.derby.impl.sql.compile.OrderedColumnList;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.ValueNode;

public class OrderByList
extends OrderedColumnList
implements RequiredRowOrdering {
    private boolean allAscending = true;
    private boolean alwaysSort;
    private ResultSetNode resultToSort;
    private SortCostController scc;
    private Object[] resultRow;
    private ColumnOrdering[] columnOrdering;
    private int estimatedRowSize;
    private boolean sortNeeded = true;

    public void addOrderByColumn(OrderByColumn column) {
        this.addElement(column);
        if (!column.isAscending()) {
            this.allAscending = false;
        }
    }

    boolean allAscending() {
        return this.allAscending;
    }

    public OrderByColumn getOrderByColumn(int position) {
        SanityManager.ASSERT(position >= 0 && position < this.size());
        return (OrderByColumn)this.elementAt(position);
    }

    public void printSubNodes(int depth) {
        for (int index = 0; index < this.size(); ++index) {
            ((OrderByColumn)this.elementAt(index)).treePrint(depth);
        }
    }

    public void bindOrderByColumns(ResultSetNode target) throws StandardException {
        this.resultToSort = target;
        int size = this.size();
        if (size > 1012) {
            throw StandardException.newException("54004");
        }
        for (int index = 0; index < size; ++index) {
            OrderByColumn obc = (OrderByColumn)this.elementAt(index);
            obc.bindOrderByColumn(target, this);
            if (obc.getResultColumn().getExpression() instanceof ColumnReference) continue;
            this.alwaysSort = true;
        }
    }

    void closeGap(int gap) {
        for (int index = 0; index < this.size(); ++index) {
            OrderByColumn obc = (OrderByColumn)this.elementAt(index);
            obc.collapseAddedColumnGap(gap);
        }
    }

    public void pullUpOrderByColumns(ResultSetNode target) throws StandardException {
        this.resultToSort = target;
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            OrderByColumn obc = (OrderByColumn)this.elementAt(index);
            obc.pullUpOrderByColumn(target);
        }
    }

    boolean isInOrderPrefix(ResultColumnList sourceRCL) {
        boolean inOrderPrefix = true;
        int rclSize = sourceRCL.size();
        if (this.size() > sourceRCL.size()) {
            SanityManager.THROWASSERT("size() (" + this.size() + ") expected to be <= sourceRCL.size() (" + sourceRCL.size() + ")");
        }
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            if (((OrderByColumn)this.elementAt(index)).getResultColumn() == (ResultColumn)sourceRCL.elementAt(index)) continue;
            return false;
        }
        return true;
    }

    void resetToSourceRCs() {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            OrderByColumn obc = (OrderByColumn)this.elementAt(index);
            obc.resetToSourceRC();
        }
    }

    ResultColumnList reorderRCL(ResultColumnList resultColumns) throws StandardException {
        ResultColumnList newRCL = (ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager());
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            OrderByColumn obc = (OrderByColumn)this.elementAt(index);
            newRCL.addElement(obc.getResultColumn());
            resultColumns.removeElement(obc.getResultColumn());
        }
        newRCL.destructiveAppend(resultColumns);
        newRCL.resetVirtualColumnIds();
        newRCL.copyOrderBySelect(resultColumns);
        return newRCL;
    }

    void removeConstantColumns(PredicateList whereClause) {
        for (int loc = this.size() - 1; loc >= 0; --loc) {
            OrderByColumn obc = (OrderByColumn)this.elementAt(loc);
            if (!obc.constantColumn(whereClause)) continue;
            this.removeElementAt(loc);
        }
    }

    void removeDupColumns() {
        block0: for (int loc = this.size() - 1; loc > 0; --loc) {
            OrderByColumn obc = (OrderByColumn)this.elementAt(loc);
            int colPosition = obc.getColumnPosition();
            for (int inner = 0; inner < loc; ++inner) {
                OrderByColumn prev_obc = (OrderByColumn)this.elementAt(inner);
                if (colPosition != prev_obc.getColumnPosition()) continue;
                this.removeElementAt(loc);
                continue block0;
            }
        }
    }

    public void generate(ActivationClassBuilder acb, MethodBuilder mb, ResultSetNode child) throws StandardException {
        if (!this.sortNeeded) {
            child.generate(acb, mb);
            return;
        }
        CompilerContext cc = this.getCompilerContext();
        int orderItem = acb.addItem(acb.getColumnOrdering(this));
        acb.pushGetResultSetFactoryExpression(mb);
        child.generate(acb, mb);
        int resultSetNumber = cc.getNextResultSetNumber();
        mb.push(false);
        mb.push(false);
        mb.push(orderItem);
        child.getResultColumns().generateHolder(acb, mb);
        mb.push(child.getResultColumns().getTotalColumnSize());
        mb.push(resultSetNumber);
        CostEstimate costEstimate = child.getFinalCostEstimate();
        mb.push(costEstimate.rowCount());
        mb.push(costEstimate.getEstimatedCost());
        mb.callMethod((short)185, null, "getSortResultSet", "org.apache.derby.iapi.sql.execute.NoPutResultSet", 9);
    }

    public int sortRequired(RowOrdering rowOrdering) throws StandardException {
        return this.sortRequired(rowOrdering, null);
    }

    public int sortRequired(RowOrdering rowOrdering, JBitSet tableMap) throws StandardException {
        if (this.alwaysSort) {
            return 1;
        }
        int position = 0;
        int size = this.size();
        for (int loc = 0; loc < size; ++loc) {
            OrderByColumn obc = this.getOrderByColumn(loc);
            ValueNode expr = obc.getResultColumn().getExpression();
            if (!(expr instanceof ColumnReference)) {
                return 1;
            }
            ColumnReference cr = (ColumnReference)expr;
            if (tableMap != null && !tableMap.get(cr.getTableNumber())) {
                for (int remainingPosition = loc + 1; remainingPosition < this.size(); ++remainingPosition) {
                    ColumnReference remainingcr;
                    OrderByColumn remainingobc = this.getOrderByColumn(loc);
                    ResultColumn remainingrc = remainingobc.getResultColumn();
                    ValueNode remainingexpr = remainingrc.getExpression();
                    if (!(remainingexpr instanceof ColumnReference) || !tableMap.get((remainingcr = (ColumnReference)remainingexpr).getTableNumber())) continue;
                    return 1;
                }
                return 3;
            }
            if (rowOrdering.alwaysOrdered(cr.getTableNumber())) continue;
            if (!rowOrdering.orderedOnColumn(obc.isAscending() ? 1 : 2, position, cr.getTableNumber(), cr.getColumnNumber())) {
                return 1;
            }
            ++position;
        }
        return 3;
    }

    public void estimateCost(double estimatedInputRows, RowOrdering rowOrdering, CostEstimate resultCost) throws StandardException {
        long inputRows;
        if (this.scc == null) {
            this.scc = this.getCompilerContext().getSortCostController();
            this.resultRow = this.resultToSort.getResultColumns().buildEmptyRow().getRowArray();
            this.columnOrdering = this.getColumnOrdering();
            this.estimatedRowSize = this.resultToSort.getResultColumns().getTotalColumnSize();
        }
        long exportRows = inputRows = (long)estimatedInputRows;
        double sortCost = this.scc.getSortCost((DataValueDescriptor[])this.resultRow, this.columnOrdering, false, inputRows, exportRows, this.estimatedRowSize);
        resultCost.setCost(sortCost, estimatedInputRows, estimatedInputRows);
    }

    public void sortNeeded() {
        this.sortNeeded = true;
    }

    public void sortNotNeeded() {
        this.sortNeeded = false;
    }

    void remapColumnReferencesToExpressions() throws StandardException {
    }

    public boolean getSortNeeded() {
        return this.sortNeeded;
    }
}

