/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.catalog.UUID;
import org.apache.derby.catalog.types.DefaultInfoImpl;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConstraintDescriptorList;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.DefaultDescriptor;
import org.apache.derby.iapi.sql.dictionary.KeyConstraintDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.impl.sql.compile.ColumnDefinitionNode;

public class ModifyColumnNode
extends ColumnDefinitionNode {
    int columnPosition = -1;
    UUID oldDefaultUUID;

    UUID getOldDefaultUUID() {
        return this.oldDefaultUUID;
    }

    public int getColumnPosition() {
        SanityManager.ASSERT(this.columnPosition > 0, "columnPosition expected to be > 0");
        return this.columnPosition;
    }

    public void checkUserType(TableDescriptor td) throws StandardException {
        if (this.getNodeType() != 186) {
            return;
        }
        ColumnDescriptor cd = td.getColumnDescriptor(this.name);
        if (cd == null) {
            throw StandardException.newException("42X14", (Object)this.name, (Object)td.getName());
        }
        DataTypeDescriptor oldType = cd.getType();
        this.dataTypeServices = this.getDataTypeServices().getNullabilityType(oldType.isNullable());
        if (!oldType.getTypeId().equals(this.getDataTypeServices().getTypeId())) {
            throw StandardException.newException("42Z15", this.name);
        }
        String typeName = this.getDataTypeServices().getTypeName();
        if (!(typeName.equals("NATIONAL CHAR VARYING") || typeName.equals("VARCHAR") || typeName.equals("VARCHAR () FOR BIT DATA"))) {
            throw StandardException.newException("42Z16");
        }
        if (this.getDataTypeServices().getMaximumWidth() < oldType.getMaximumWidth()) {
            throw StandardException.newException("42Z17", this.name);
        }
    }

    public void checkExistingConstraints(TableDescriptor td) throws StandardException {
        if (this.getNodeType() != 186 && this.getNodeType() != 187 && this.getNodeType() != 193) {
            return;
        }
        DataDictionary dd = this.getDataDictionary();
        ConstraintDescriptorList cdl = dd.getConstraintDescriptors(td);
        int[] intArray = new int[]{this.columnPosition};
        for (int index = 0; index < cdl.size(); ++index) {
            ConstraintDescriptor existingConstraint = cdl.elementAt(index);
            if (!(existingConstraint instanceof KeyConstraintDescriptor) || !existingConstraint.columnIntersects(intArray)) continue;
            int constraintType = existingConstraint.getConstraintType();
            if (constraintType == 6 && this.getNodeType() == 186) {
                throw StandardException.newException("42Z18", (Object)this.name, (Object)existingConstraint.getConstraintName());
            }
            if (this.getNodeType() == 187 && (existingConstraint.getConstraintType() == 2 || existingConstraint.getConstraintType() == 3)) {
                throw StandardException.newException("42Z20", this.name);
            }
            ConstraintDescriptorList refcdl = dd.getForeignKeys(existingConstraint.getUUID());
            if (refcdl.size() > 0) {
                throw StandardException.newException("42Z19", (Object)this.name, (Object)refcdl.elementAt(0).getConstraintName());
            }
            this.getCompilerContext().createDependency(existingConstraint);
        }
    }

    public void useExistingCollation(TableDescriptor td) throws StandardException {
        ColumnDescriptor cd = td.getColumnDescriptor(this.name);
        if (cd == null) {
            throw StandardException.newException("42X14", (Object)this.name, (Object)td.getName());
        }
        if (this.getDataTypeServices() != null && this.getDataTypeServices().getTypeId().isStringTypeId()) {
            this.getDataTypeServices().setCollationType(cd.getType().getCollationType());
            this.getDataTypeServices().setCollationDerivation(1);
        }
    }

    int getAction() {
        switch (this.getNodeType()) {
            case 97: {
                if (this.autoinc_create_or_modify_Start_Increment == 1L) {
                    return 5;
                }
                if (this.autoinc_create_or_modify_Start_Increment == 2L) {
                    return 6;
                }
                return 7;
            }
            case 186: {
                return 2;
            }
            case 187: {
                return 3;
            }
            case 193: {
                return 4;
            }
            case 113: {
                return 1;
            }
        }
        SanityManager.THROWASSERT("Unexpected nodeType = " + this.getNodeType());
        return 0;
    }

    void bindAndValidateDefault(DataDictionary dd, TableDescriptor td) throws StandardException {
        ColumnDescriptor cd = td.getColumnDescriptor(this.name);
        if (cd == null) {
            throw StandardException.newException("42X14", (Object)this.name, (Object)td.getName());
        }
        DefaultDescriptor defaultDescriptor = cd.getDefaultDescriptor(dd);
        this.oldDefaultUUID = defaultDescriptor == null ? null : defaultDescriptor.getUUID();
        this.columnPosition = cd.getPosition();
        if (this.getNodeType() != 97) {
            return;
        }
        if (this.defaultNode == null) {
            this.defaultInfo = (DefaultInfoImpl)cd.getDefaultInfo();
        }
        if (this.autoinc_create_or_modify_Start_Increment == 1L) {
            this.autoincrementIncrement = cd.getAutoincInc();
        }
        if (this.autoinc_create_or_modify_Start_Increment == 2L) {
            this.autoincrementStart = cd.getAutoincStart();
        }
        this.dataTypeServices = cd.getType();
        this.validateDefault(dd, td);
    }

    private ColumnDescriptor getLocalColumnDescriptor(String name, TableDescriptor td) throws StandardException {
        ColumnDescriptor cd = td.getColumnDescriptor(name);
        if (cd == null) {
            throw StandardException.newException("42X14", (Object)name, (Object)td.getName());
        }
        return cd;
    }

    public void validateAutoincrement(DataDictionary dd, TableDescriptor td, int tableType) throws StandardException {
        ColumnDescriptor cd;
        if (this.getNodeType() == 187 && (cd = this.getLocalColumnDescriptor(this.name, td)).isAutoincrement()) {
            throw StandardException.newException("42Z26", this.getColumnName());
        }
        if (this.autoincrementVerify && !(cd = this.getLocalColumnDescriptor(this.name, td)).isAutoincrement()) {
            throw StandardException.newException("42837", (Object)td.getQualifiedName(), (Object)this.name);
        }
        if (!this.isAutoincrement) {
            return;
        }
        super.validateAutoincrement(dd, td, tableType);
        if (this.getDataTypeServices().isNullable()) {
            throw StandardException.newException("42Z27", this.getColumnName());
        }
    }
}

