/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.sql.compile.TypeCompiler;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.Like;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.iapi.util.ReuseFactory;
import org.apache.derby.impl.sql.compile.AndNode;
import org.apache.derby.impl.sql.compile.BinaryComparisonOperatorNode;
import org.apache.derby.impl.sql.compile.CastNode;
import org.apache.derby.impl.sql.compile.CharConstantNode;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.StaticMethodCallNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.TernaryOperatorNode;
import org.apache.derby.impl.sql.compile.ValueNode;

public final class LikeEscapeOperatorNode
extends TernaryOperatorNode {
    boolean addedEquals;
    String escape;

    public void init(Object receiver, Object leftOperand, Object rightOperand) {
        super.init(receiver, leftOperand, rightOperand, ReuseFactory.getInteger(3), null);
    }

    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector aggregateVector) throws StandardException {
        boolean rightConstant;
        boolean leftConstant;
        super.bindExpression(fromList, subqueryList, aggregateVector);
        String pattern = null;
        if (!this.leftOperand.requiresTypeFromContext() && !this.leftOperand.getTypeId().isStringTypeId()) {
            throw StandardException.newException("42884", (Object)"LIKE", (Object)"FUNCTION");
        }
        if (this.rightOperand != null && !this.rightOperand.requiresTypeFromContext() && !this.rightOperand.getTypeId().isStringTypeId()) {
            throw StandardException.newException("42884", (Object)"LIKE", (Object)"FUNCTION");
        }
        if (this.receiver.requiresTypeFromContext()) {
            this.receiver.setType(new DataTypeDescriptor(TypeId.getBuiltInTypeId(12), true));
            if (!this.leftOperand.requiresTypeFromContext()) {
                this.receiver.getTypeServices().setCollationDerivation(this.leftOperand.getTypeServices().getCollationDerivation());
                this.receiver.getTypeServices().setCollationType(this.leftOperand.getTypeServices().getCollationType());
            } else if (this.rightOperand != null && !this.rightOperand.requiresTypeFromContext()) {
                this.receiver.getTypeServices().setCollationDerivation(this.rightOperand.getTypeServices().getCollationDerivation());
                this.receiver.getTypeServices().setCollationType(this.rightOperand.getTypeServices().getCollationType());
            } else {
                this.receiver.setCollationUsingCompilationSchema(1);
            }
        }
        if (this.leftOperand.requiresTypeFromContext()) {
            if (this.receiver.getTypeId().isStringTypeId()) {
                this.leftOperand.setType(this.receiver.getTypeServices());
            } else {
                this.leftOperand.setType(new DataTypeDescriptor(TypeId.getBuiltInTypeId(12), true));
            }
            this.leftOperand.getTypeServices().setCollationDerivation(this.receiver.getTypeServices().getCollationDerivation());
            this.leftOperand.getTypeServices().setCollationType(this.receiver.getTypeServices().getCollationType());
        }
        if (this.rightOperand != null && this.rightOperand.requiresTypeFromContext()) {
            if (this.receiver.getTypeId().isStringTypeId()) {
                this.rightOperand.setType(this.receiver.getTypeServices());
            } else {
                this.rightOperand.setType(new DataTypeDescriptor(TypeId.getBuiltInTypeId(12), true));
            }
            this.rightOperand.getTypeServices().setCollationDerivation(this.receiver.getTypeServices().getCollationDerivation());
            this.rightOperand.getTypeServices().setCollationType(this.receiver.getTypeServices().getCollationType());
        }
        this.bindToBuiltIn();
        TypeCompiler receiverTC = this.receiver.getTypeCompiler();
        TypeCompiler leftTC = this.leftOperand.getTypeCompiler();
        if (!this.receiver.getTypeId().isStringTypeId()) {
            throw StandardException.newException("42884", (Object)"LIKE", (Object)"FUNCTION");
        }
        if (!this.leftOperand.getTypeId().isStringTypeId()) {
            this.leftOperand = this.castArgToString(this.leftOperand);
            leftTC = this.leftOperand.getTypeCompiler();
        }
        if (this.rightOperand != null) {
            this.rightOperand = this.castArgToString(this.rightOperand);
        }
        if (leftConstant = this.leftOperand instanceof CharConstantNode) {
            pattern = ((CharConstantNode)this.leftOperand).getString();
        }
        if (rightConstant = this.rightOperand instanceof CharConstantNode) {
            this.escape = ((CharConstantNode)this.rightOperand).getString();
            if (this.escape.length() != 1) {
                throw StandardException.newException("22019", this.escape);
            }
        } else if (this.rightOperand == null) {
            rightConstant = true;
        }
        if (!this.receiver.getTypeServices().compareCollationInfo(this.leftOperand.getTypeServices())) {
            throw StandardException.newException("42ZA2", this.receiver.getTypeServices().getSQLstring(), (Object)this.receiver.getTypeServices().getCollationName(), (Object)this.leftOperand.getTypeServices().getSQLstring(), (Object)this.leftOperand.getTypeServices().getCollationName());
        }
        if (this.receiver instanceof ColumnReference && leftConstant && rightConstant && Like.isOptimizable(pattern)) {
            String newPattern = null;
            if (this.escape != null) {
                newPattern = Like.stripEscapesNoPatternChars(pattern, this.escape.charAt(0));
            } else if (pattern.indexOf(95) == -1 && pattern.indexOf(37) == -1) {
                newPattern = pattern;
            }
            if (newPattern != null) {
                ValueNode leftClone = this.receiver.getClone();
                this.addedEquals = true;
                BinaryComparisonOperatorNode equals = (BinaryComparisonOperatorNode)this.getNodeFactory().getNode(41, leftClone, (ValueNode)this.getNodeFactory().getNode(61, newPattern, this.getContextManager()), this.getContextManager());
                equals.setForQueryRewrite(true);
                equals = (BinaryComparisonOperatorNode)equals.bindExpression(fromList, subqueryList, aggregateVector);
                AndNode newAnd = (AndNode)this.getNodeFactory().getNode(39, this, equals, this.getContextManager());
                this.finishBindExpr();
                newAnd.postBindFixup();
                return newAnd;
            }
        }
        this.finishBindExpr();
        return this;
    }

    private void finishBindExpr() throws StandardException {
        boolean nullableResult;
        this.bindComparisonOperator();
        boolean bl = nullableResult = this.receiver.getTypeServices().isNullable() || this.leftOperand.getTypeServices().isNullable();
        if (this.rightOperand != null) {
            nullableResult |= this.rightOperand.getTypeServices().isNullable();
        }
        this.setType(new DataTypeDescriptor(TypeId.BOOLEAN_ID, nullableResult));
    }

    public void bindComparisonOperator() throws StandardException {
        TypeId receiverType = this.receiver.getTypeId();
        TypeId leftType = this.leftOperand.getTypeId();
        if (!receiverType.isStringTypeId()) {
            throw StandardException.newException("42X53", receiverType.getSQLTypeName());
        }
        if (!leftType.isStringTypeId()) {
            throw StandardException.newException("42X53", leftType.getSQLTypeName());
        }
        if (this.rightOperand != null && !this.rightOperand.getTypeId().isStringTypeId()) {
            throw StandardException.newException("42X53", this.rightOperand.getTypeId().getSQLTypeName());
        }
    }

    public ValueNode preprocess(int numTables, FromList outerFromList, SubqueryList outerSubqueryList, PredicateList outerPredicateList) throws StandardException {
        boolean eliminateLikeComparison = false;
        String greaterEqualString = null;
        String lessThanString = null;
        super.preprocess(numTables, outerFromList, outerSubqueryList, outerPredicateList);
        if (this.receiver.getTypeId().getSQLTypeName().equals("CLOB")) {
            return this;
        }
        if (this.addedEquals) {
            return this;
        }
        if (!(this.leftOperand instanceof CharConstantNode) && !this.leftOperand.requiresTypeFromContext()) {
            return this;
        }
        if (!(this.receiver instanceof ColumnReference)) {
            return this;
        }
        if (this.receiver.getTypeServices().getCollationType() != 0) {
            return this;
        }
        if (this.leftOperand instanceof CharConstantNode) {
            String pattern = ((CharConstantNode)this.leftOperand).getString();
            if (!Like.isOptimizable(pattern)) {
                return this;
            }
            int maxWidth = this.receiver.getTypeServices().getMaximumWidth();
            greaterEqualString = Like.greaterEqualString(pattern, this.escape, maxWidth);
            if (!this.receiver.getTypeId().isNationalStringTypeId()) {
                lessThanString = Like.lessThanString(pattern, this.escape, maxWidth);
                eliminateLikeComparison = !Like.isLikeComparisonNeeded(pattern);
            }
        }
        AndNode newAnd = null;
        ValueNode trueNode = (ValueNode)this.getNodeFactory().getNode(38, Boolean.TRUE, this.getContextManager());
        if (lessThanString != null || this.leftOperand.requiresTypeFromContext() && !this.receiver.getTypeId().isNationalStringTypeId()) {
            QueryTreeNode likeLTopt = this.leftOperand.requiresTypeFromContext() ? this.setupOptimizeStringFromParameter(this.leftOperand, this.rightOperand, "lessThanStringFromParameter", this.receiver.getTypeServices().getMaximumWidth()) : this.getNodeFactory().getNode(61, lessThanString, this.getContextManager());
            BinaryComparisonOperatorNode lessThan = (BinaryComparisonOperatorNode)this.getNodeFactory().getNode(45, this.receiver.getClone(), likeLTopt, this.getContextManager());
            lessThan.setForQueryRewrite(true);
            lessThan.bindComparisonOperator();
            lessThan.setBetweenSelectivity();
            newAnd = (AndNode)this.getNodeFactory().getNode(39, lessThan, trueNode, this.getContextManager());
            newAnd.postBindFixup();
        }
        ValueNode likeGEopt = this.leftOperand.requiresTypeFromContext() ? this.setupOptimizeStringFromParameter(this.leftOperand, this.rightOperand, "greaterEqualStringFromParameter", this.receiver.getTypeServices().getMaximumWidth()) : (ValueNode)this.getNodeFactory().getNode(61, greaterEqualString, this.getContextManager());
        BinaryComparisonOperatorNode greaterEqual = (BinaryComparisonOperatorNode)this.getNodeFactory().getNode(42, this.receiver.getClone(), likeGEopt, this.getContextManager());
        greaterEqual.setForQueryRewrite(true);
        greaterEqual.bindComparisonOperator();
        greaterEqual.setBetweenSelectivity();
        newAnd = newAnd == null ? (AndNode)this.getNodeFactory().getNode(39, greaterEqual, trueNode, this.getContextManager()) : (AndNode)this.getNodeFactory().getNode(39, greaterEqual, newAnd, this.getContextManager());
        newAnd.postBindFixup();
        if (!eliminateLikeComparison) {
            newAnd = (AndNode)this.getNodeFactory().getNode(39, this, newAnd, this.getContextManager());
            newAnd.postBindFixup();
        }
        this.setTransformed();
        return newAnd;
    }

    public void generateExpression(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        this.receiver.generateExpression(acb, mb);
        this.receiverInterfaceType = this.receiver.getTypeCompiler().interfaceName();
        mb.upCast(this.receiverInterfaceType);
        this.leftOperand.generateExpression(acb, mb);
        mb.upCast(this.leftInterfaceType);
        if (this.rightOperand != null) {
            this.rightOperand.generateExpression(acb, mb);
            mb.upCast(this.rightInterfaceType);
        }
        mb.callMethod((short)185, null, this.methodName, this.resultInterfaceType, this.rightOperand == null ? 1 : 2);
    }

    private ValueNode setupOptimizeStringFromParameter(ValueNode parameterNode, ValueNode escapeNode, String methodName, int maxWidth) throws StandardException {
        Vector<QueryTreeNode> param;
        if (escapeNode != null) {
            param = new Vector<QueryTreeNode>(2);
            methodName = methodName + "WithEsc";
        } else {
            param = new Vector(1);
        }
        StaticMethodCallNode methodCall = (StaticMethodCallNode)this.getNodeFactory().getNode(85, methodName, "org.apache.derby.iapi.types.Like", this.getContextManager());
        methodCall.internalCall = true;
        param.addElement(parameterNode);
        if (escapeNode != null) {
            param.addElement(escapeNode);
        }
        QueryTreeNode maxWidthNode = this.getNodeFactory().getNode(70, new Integer(maxWidth), this.getContextManager());
        param.addElement(maxWidthNode);
        methodCall.addParms(param);
        ValueNode java2SQL = (ValueNode)this.getNodeFactory().getNode(36, methodCall, this.getContextManager());
        java2SQL = java2SQL.bindExpression(null, null, null);
        CastNode likeOpt = (CastNode)this.getNodeFactory().getNode(60, java2SQL, parameterNode.getTypeServices(), this.getContextManager());
        likeOpt.bindCastNodeOnly();
        return likeOpt;
    }
}

