/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.types.DataTypeDescriptor;
import org.apache.derby.iapi.types.TypeId;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.UnaryOperatorNode;
import org.apache.derby.impl.sql.compile.ValueNode;

public final class LengthOperatorNode
extends UnaryOperatorNode {
    private int parameterType;
    private int parameterWidth;

    public void setNodeType(int nodeType) {
        String operator = null;
        String methodName = null;
        if (nodeType == 23) {
            operator = "char_length";
            methodName = "charLength";
            this.parameterType = 12;
            this.parameterWidth = 32672;
        } else {
            SanityManager.THROWASSERT("Unexpected nodeType = " + nodeType);
        }
        this.setOperator(operator);
        this.setMethodName(methodName);
        super.setNodeType(nodeType);
    }

    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector aggregateVector) throws StandardException {
        this.bindOperand(fromList, subqueryList, aggregateVector);
        TypeId operandType = this.operand.getTypeId();
        switch (operandType.getJDBCTypeId()) {
            case -4: 
            case -3: 
            case -2: 
            case -1: 
            case 1: 
            case 12: 
            case 2004: 
            case 2005: {
                break;
            }
            default: {
                throw StandardException.newException("42X25", (Object)this.getOperatorString(), (Object)operandType.getSQLTypeName());
            }
        }
        this.setType(new DataTypeDescriptor(TypeId.INTEGER_ID, this.operand.getTypeServices().isNullable()));
        return this;
    }

    void bindParameter() throws StandardException {
        this.operand.setType(DataTypeDescriptor.getBuiltInDataTypeDescriptor(this.parameterType, true, this.parameterWidth));
    }

    public String getReceiverInterfaceName() {
        return "org.apache.derby.iapi.types.ConcatableDataValue";
    }
}

