/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.compile.CompilerContext;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.IndexLister;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.types.RowLocation;
import org.apache.derby.iapi.util.ReuseFactory;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.DMLModStatementNode;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromVTI;
import org.apache.derby.impl.sql.compile.QueryTreeNode;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.SingleChildResultSetNode;
import org.apache.derby.impl.sql.compile.TableOperatorNode;
import org.apache.derby.impl.sql.compile.UnionNode;
import org.apache.derby.impl.sql.compile.VTIDeferModPolicy;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.execute.FKInfo;

public final class InsertNode
extends DMLModStatementNode {
    public ResultColumnList targetColumnList;
    public boolean deferred;
    public ValueNode checkConstraints;
    public Properties targetProperties;
    public FKInfo fkInfo;
    protected boolean bulkInsert;
    private boolean bulkInsertReplace;
    protected RowLocation[] autoincRowLocation;

    public void init(Object targetName, Object insertColumns, Object queryExpression, Object targetProperties) {
        super.init(queryExpression, ReuseFactory.getInteger(InsertNode.getStatementType((Properties)targetProperties)));
        this.setTarget((QueryTreeNode)targetName);
        this.targetColumnList = (ResultColumnList)insertColumns;
        this.targetProperties = (Properties)targetProperties;
        this.getResultSetNode().setInsertSource();
    }

    public String toString() {
        try {
            return (this.targetTableName != null ? this.targetTableName : this.targetVTI.getTableName()).toString() + "\n" + this.targetProperties + "\n" + super.toString();
        }
        catch (StandardException e) {
            return "tableName: <not_known>\n" + this.targetProperties + "\n" + super.toString();
        }
    }

    public String statementToString() {
        return "INSERT";
    }

    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.targetTableName != null) {
            this.printLabel(depth, "targetTableName: ");
            this.targetTableName.treePrint(depth + 1);
        }
        if (this.targetColumnList != null) {
            this.printLabel(depth, "targetColumnList: ");
            this.targetColumnList.treePrint(depth + 1);
        }
    }

    public void bindStatement() throws StandardException {
        this.getCompilerContext().pushCurrentPrivType(0);
        FromList fromList = (FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager());
        DataDictionary dataDictionary = this.getDataDictionary();
        super.bindResultSetsWithTables(dataDictionary);
        this.verifyTargetTable();
        if (this.targetProperties != null) {
            this.verifyTargetProperties(dataDictionary);
        }
        this.getResultColumnList();
        if (this.targetColumnList != null) {
            if (this.synonymTableName != null) {
                this.normalizeSynonymColumns(this.targetColumnList, this.targetTableName);
            }
            this.getCompilerContext().pushCurrentPrivType(this.getPrivType());
            if (this.targetTableDescriptor != null) {
                this.targetColumnList.bindResultColumnsByName(this.targetTableDescriptor, this);
            } else {
                this.targetColumnList.bindResultColumnsByName(this.targetVTI.getResultColumns(), this.targetVTI, this);
            }
            this.getCompilerContext().popCurrentPrivType();
        }
        SanityManager.ASSERT(fromList.size() == 0, "fromList.size() is expected to be 0, not " + fromList.size() + " on return from RS.bindExpressions()");
        this.resultSet.replaceDefaults(this.targetTableDescriptor, this.targetColumnList);
        super.bindExpressions();
        if (this.targetColumnList != null) {
            if (this.resultSet.getResultColumns().visibleSize() > this.targetColumnList.size()) {
                throw StandardException.newException("42802");
            }
            this.resultSet.bindUntypedNullsToResultColumns(this.targetColumnList);
            this.resultSet.setTableConstructorTypes(this.targetColumnList);
        } else {
            if (this.resultSet.getResultColumns().visibleSize() > this.resultColumnList.size()) {
                throw StandardException.newException("42802");
            }
            this.resultSet.bindUntypedNullsToResultColumns(this.resultColumnList);
            this.resultSet.setTableConstructorTypes(this.resultColumnList);
        }
        this.resultSet.bindResultColumns(fromList);
        int resCols = this.resultSet.getResultColumns().visibleSize();
        DataDictionary dd = this.getDataDictionary();
        if (this.targetColumnList != null ? this.targetColumnList.size() != resCols : this.targetTableDescriptor != null && this.targetTableDescriptor.getNumberOfColumns() != resCols) {
            throw StandardException.newException("42802");
        }
        boolean inOrder = true;
        int numTableColumns = this.resultColumnList.size();
        int[] colMap = new int[numTableColumns];
        for (int i = 0; i < colMap.length; ++i) {
            colMap[i] = -1;
        }
        if (this.targetColumnList != null) {
            int targetSize = this.targetColumnList.size();
            int index = 0;
            while (index < targetSize) {
                int position = ((ResultColumn)this.targetColumnList.elementAt((int)index)).columnDescriptor.getPosition();
                if (index != position - 1) {
                    inOrder = false;
                }
                colMap[position - 1] = index++;
            }
        } else {
            for (int position = 0; position < this.resultSet.getResultColumns().visibleSize(); ++position) {
                colMap[position] = position;
            }
        }
        this.enhanceAndCheckForAutoincrement(this.resultSet, inOrder, numTableColumns, colMap, dataDictionary, this.targetTableDescriptor, this.targetVTI);
        this.resultColumnList.checkStorableExpressions(this.resultSet.getResultColumns());
        if (!this.resultColumnList.columnTypesAndLengthsMatch(this.resultSet.getResultColumns())) {
            this.resultSet = this.resultSet.genNormalizeResultSetNode(this.resultSet, false);
            this.resultColumnList.copyTypesAndLengthsToSource(this.resultSet.getResultColumns());
        }
        if (this.targetTableDescriptor != null) {
            ResultColumnList sourceRCL = this.resultSet.getResultColumns();
            sourceRCL.copyResultColumnNames(this.resultColumnList);
            this.checkConstraints = this.bindConstraints(dataDictionary, this.getNodeFactory(), this.targetTableDescriptor, null, sourceRCL, null, null, false, true);
            if (this.resultSet.referencesTarget(this.targetTableDescriptor.getName(), true) || this.requiresDeferredProcessing()) {
                this.deferred = true;
                if (this.bulkInsertReplace && this.resultSet.referencesTarget(this.targetTableDescriptor.getName(), true)) {
                    throw StandardException.newException("42Y38", this.targetTableDescriptor.getQualifiedName());
                }
            }
            this.getAffectedIndexes(this.targetTableDescriptor);
            TransactionController tc = this.getLanguageConnectionContext().getTransactionCompile();
            this.autoincRowLocation = dd.computeAutoincRowLocations(tc, this.targetTableDescriptor);
            if (this.isPrivilegeCollectionRequired()) {
                this.getCompilerContext().pushCurrentPrivType(this.getPrivType());
                this.getCompilerContext().addRequiredTablePriv(this.targetTableDescriptor);
                this.getCompilerContext().popCurrentPrivType();
            }
        } else {
            this.deferred = VTIDeferModPolicy.deferIt(1, this.targetVTI, null, this.resultSet);
        }
        this.getCompilerContext().popCurrentPrivType();
    }

    private void enhanceAndCheckForAutoincrement(ResultSetNode resultSet, boolean inOrder, int numTableColumns, int[] colMap, DataDictionary dataDictionary, TableDescriptor targetTableDescriptor, FromVTI targetVTI) throws StandardException {
        if (resultSet instanceof SingleChildResultSetNode) {
            this.enhanceAndCheckForAutoincrement(((SingleChildResultSetNode)resultSet).getChildResult(), inOrder, numTableColumns, colMap, dataDictionary, targetTableDescriptor, targetVTI);
            if (!inOrder || resultSet.resultColumns.size() < numTableColumns) {
                resultSet.enhanceRCLForInsert(numTableColumns, colMap, dataDictionary, targetTableDescriptor, targetVTI);
            }
        } else if (resultSet instanceof UnionNode) {
            this.enhanceAndCheckForAutoincrement(((TableOperatorNode)resultSet).getLeftResultSet(), inOrder, numTableColumns, colMap, dataDictionary, targetTableDescriptor, targetVTI);
            this.enhanceAndCheckForAutoincrement(((TableOperatorNode)resultSet).getRightResultSet(), inOrder, numTableColumns, colMap, dataDictionary, targetTableDescriptor, targetVTI);
            if (!inOrder || resultSet.resultColumns.size() < numTableColumns) {
                resultSet.enhanceRCLForInsert(numTableColumns, colMap, dataDictionary, targetTableDescriptor, targetVTI);
            }
        } else {
            if (!inOrder || resultSet.resultColumns.size() < numTableColumns) {
                resultSet.enhanceRCLForInsert(numTableColumns, colMap, dataDictionary, targetTableDescriptor, targetVTI);
            }
            this.resultColumnList.checkAutoincrement(resultSet.getResultColumns());
        }
    }

    int getPrivType() {
        return 3;
    }

    public boolean referencesSessionSchema() throws StandardException {
        boolean returnValue = false;
        if (this.targetTableDescriptor != null) {
            returnValue = this.isSessionSchema(this.targetTableDescriptor.getSchemaDescriptor());
        }
        if (!returnValue) {
            returnValue = this.resultSet.referencesSessionSchema();
        }
        return returnValue;
    }

    private void verifyTargetProperties(DataDictionary dd) throws StandardException {
        String insertMode = this.targetProperties.getProperty("insertMode");
        if (insertMode != null) {
            String upperValue = StringUtil.SQLToUpperCase(insertMode);
            if (!upperValue.equals("BULKINSERT") && !upperValue.equals("REPLACE")) {
                throw StandardException.newException("42X60", (Object)insertMode, (Object)this.targetTableName);
            }
            if (!this.verifyBulkInsert(dd, upperValue)) {
                this.targetProperties.remove("insertMode");
            } else {
                int bulkFetch;
                String bulkFetchStr;
                this.bulkInsert = true;
                if (upperValue.equals("REPLACE")) {
                    this.bulkInsertReplace = true;
                }
                if ((bulkFetchStr = this.targetProperties.getProperty("bulkFetch")) != null && (bulkFetch = this.getIntProperty(bulkFetchStr, "bulkFetch")) <= 0) {
                    throw StandardException.newException("42Y64", String.valueOf(bulkFetch));
                }
            }
        }
    }

    private boolean verifyBulkInsert(DataDictionary dd, String mode) throws StandardException {
        return true;
    }

    public ConstantAction makeConstantAction() throws StandardException {
        if (this.targetTableDescriptor != null) {
            long heapConglomId = this.targetTableDescriptor.getHeapConglomerateId();
            TransactionController tc = this.getLanguageConnectionContext().getTransactionCompile();
            int numIndexes = this.targetTableDescriptor != null ? this.indexConglomerateNumbers.length : 0;
            StaticCompiledOpenConglomInfo[] indexSCOCIs = new StaticCompiledOpenConglomInfo[numIndexes];
            for (int index = 0; index < numIndexes; ++index) {
                indexSCOCIs[index] = tc.getStaticCompiledConglomInfo(this.indexConglomerateNumbers[index]);
            }
            if (this.bulkInsert || this.targetTableDescriptor.getLockGranularity() == 'T') {
                this.lockMode = 7;
            }
            return this.getGenericConstantActionFactory().getInsertConstantAction(this.targetTableDescriptor, heapConglomId, tc.getStaticCompiledConglomInfo(heapConglomId), this.indicesToMaintain, this.indexConglomerateNumbers, indexSCOCIs, this.indexNames, this.deferred, false, this.targetTableDescriptor.getUUID(), this.lockMode, null, null, this.targetProperties, this.getFKInfo(), this.getTriggerInfo(), this.resultColumnList.getStreamStorableColIds(this.targetTableDescriptor.getNumberOfColumns()), this.getIndexedCols(), null, null, null, this.resultSet.isOneRowResultSet(), this.autoincRowLocation);
        }
        return this.getGenericConstantActionFactory().getUpdatableVTIConstantAction(1, this.deferred);
    }

    public boolean[] getIndexedCols() throws StandardException {
        boolean[] indexedCols = new boolean[this.targetTableDescriptor.getNumberOfColumns()];
        for (int index = 0; index < this.indicesToMaintain.length; ++index) {
            int[] colIds = this.indicesToMaintain[index].getIndexDescriptor().baseColumnPositions();
            for (int index2 = 0; index2 < colIds.length; ++index2) {
                indexedCols[colIds[index2] - 1] = true;
            }
        }
        return indexedCols;
    }

    public void generate(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        this.generateCodeForTemporaryTable(acb, acb.getExecuteMethod());
        this.generateParameterValueSet(acb);
        if (this.targetTableDescriptor != null) {
            acb.pushGetResultSetFactoryExpression(mb);
            this.resultSet.generate(acb, mb);
            this.generateCheckConstraints(this.checkConstraints, acb, mb);
            mb.callMethod((short)185, null, "getInsertResultSet", "org.apache.derby.iapi.sql.ResultSet", 2);
        } else {
            this.targetVTI.assignCostEstimate(this.resultSet.getNewCostEstimate());
            acb.pushGetResultSetFactoryExpression(mb);
            this.resultSet.generate(acb, mb);
            this.targetVTI.generate(acb, mb);
            mb.callMethod((short)185, null, "getInsertVTIResultSet", "org.apache.derby.iapi.sql.ResultSet", 2);
        }
    }

    protected final int getStatementType() {
        return 1;
    }

    static final int getStatementType(Properties targetProperties) {
        String upperValue;
        String insertMode;
        int retval = 1;
        String string = insertMode = targetProperties == null ? null : targetProperties.getProperty("insertMode");
        if (insertMode != null && (upperValue = StringUtil.SQLToUpperCase(insertMode)).equals("REPLACE")) {
            retval = 2;
        }
        return retval;
    }

    private void getAffectedIndexes(TableDescriptor td) throws StandardException {
        IndexLister indexLister = td.getIndexLister();
        this.indicesToMaintain = indexLister.getDistinctIndexRowGenerators();
        this.indexConglomerateNumbers = indexLister.getDistinctIndexConglomerateNumbers();
        this.indexNames = indexLister.getDistinctIndexNames();
        ConglomerateDescriptor[] cds = td.getConglomerateDescriptors();
        CompilerContext cc = this.getCompilerContext();
        for (int index = 0; index < cds.length; ++index) {
            cc.createDependency(cds[index]);
        }
    }
}

