/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.catalog.types.ReferencedColumnsDescriptorImpl;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.compile.AccessPath;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.store.access.StaticCompiledOpenConglomInfo;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ValueNode;
import org.apache.derby.impl.sql.compile.VirtualColumnNode;

public class IndexToBaseRowNode
extends FromTable {
    protected FromBaseTable source;
    protected ConglomerateDescriptor baseCD;
    protected boolean cursorTargetTable;
    protected PredicateList restrictionList;
    protected boolean forUpdate;
    private FormatableBitSet heapReferencedCols;
    private FormatableBitSet indexReferencedCols;
    private FormatableBitSet allReferencedCols;
    private FormatableBitSet heapOnlyReferencedCols;

    public void init(Object source, Object baseCD, Object resultColumns, Object cursorTargetTable, Object heapReferencedCols, Object indexReferencedCols, Object restrictionList, Object forUpdate, Object tableProperties) {
        super.init(null, tableProperties);
        this.source = (FromBaseTable)source;
        this.baseCD = (ConglomerateDescriptor)baseCD;
        this.resultColumns = (ResultColumnList)resultColumns;
        this.cursorTargetTable = (Boolean)cursorTargetTable;
        this.restrictionList = (PredicateList)restrictionList;
        this.forUpdate = (Boolean)forUpdate;
        this.heapReferencedCols = (FormatableBitSet)heapReferencedCols;
        this.indexReferencedCols = (FormatableBitSet)indexReferencedCols;
        if (this.indexReferencedCols == null) {
            this.allReferencedCols = this.heapReferencedCols;
            this.heapOnlyReferencedCols = this.heapReferencedCols;
        } else {
            this.allReferencedCols = new FormatableBitSet(this.heapReferencedCols);
            this.allReferencedCols.or(this.indexReferencedCols);
            this.heapOnlyReferencedCols = new FormatableBitSet(this.allReferencedCols);
            this.heapOnlyReferencedCols.xor(this.indexReferencedCols);
        }
    }

    public boolean forUpdate() {
        return this.source.forUpdate();
    }

    public AccessPath getTrulyTheBestAccessPath() {
        return this.source.getTrulyTheBestAccessPath();
    }

    public CostEstimate getCostEstimate() {
        return this.source.getTrulyTheBestAccessPath().getCostEstimate();
    }

    public CostEstimate getFinalCostEstimate() {
        return this.source.getFinalCostEstimate();
    }

    boolean isOrderedOn(ColumnReference[] crs, boolean permuteOrdering, Vector fbtVector) throws StandardException {
        return this.source.isOrderedOn(crs, permuteOrdering, fbtVector);
    }

    public void generate(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        ValueNode restriction = null;
        this.assignResultSetNumber();
        this.costEstimate = this.getFinalCostEstimate();
        if (this.restrictionList != null) {
            restriction = this.restrictionList.restorePredicates();
            this.restrictionList = null;
        }
        int heapColRefItem = -1;
        if (this.heapReferencedCols != null) {
            heapColRefItem = acb.addItem(this.heapReferencedCols);
        }
        int allColRefItem = -1;
        if (this.allReferencedCols != null) {
            allColRefItem = acb.addItem(this.allReferencedCols);
        }
        int heapOnlyColRefItem = -1;
        if (this.heapOnlyReferencedCols != null) {
            heapOnlyColRefItem = acb.addItem(this.heapOnlyReferencedCols);
        }
        int indexColMapItem = acb.addItem(new ReferencedColumnsDescriptorImpl(this.getIndexColMapping()));
        long heapConglomNumber = this.baseCD.getConglomerateNumber();
        StaticCompiledOpenConglomInfo scoci = this.getLanguageConnectionContext().getTransactionCompile().getStaticCompiledConglomInfo(heapConglomNumber);
        acb.pushGetResultSetFactoryExpression(mb);
        mb.push(heapConglomNumber);
        mb.push(acb.addItem(scoci));
        this.source.generate(acb, mb);
        mb.upCast("org.apache.derby.iapi.sql.execute.NoPutResultSet");
        this.resultColumns.generateHolder(acb, mb, this.heapReferencedCols, this.indexReferencedCols);
        mb.push(this.resultSetNumber);
        mb.push(this.source.getBaseTableName());
        mb.push(heapColRefItem);
        mb.push(allColRefItem);
        mb.push(heapOnlyColRefItem);
        mb.push(indexColMapItem);
        if (restriction == null) {
            mb.pushNull("org.apache.derby.iapi.services.loader.GeneratedMethod");
        } else {
            MethodBuilder userExprFun = acb.newUserExprFun();
            restriction.generate(acb, userExprFun);
            userExprFun.methodReturn();
            userExprFun.complete();
            acb.pushMethodReference(mb, userExprFun);
        }
        mb.push(this.forUpdate);
        mb.push(this.costEstimate.rowCount());
        mb.push(this.costEstimate.getEstimatedCost());
        mb.callMethod((short)185, null, "getIndexRowToBaseRowResultSet", "org.apache.derby.iapi.sql.execute.NoPutResultSet", 14);
        if (this.cursorTargetTable) {
            acb.rememberCursorTarget(mb);
        }
    }

    public boolean isOneRowResultSet() throws StandardException {
        return this.source.isOneRowResultSet();
    }

    public boolean isNotExists() {
        return this.source.isNotExists();
    }

    void decrementLevel(int decrement) {
        this.source.decrementLevel(decrement);
    }

    public int updateTargetLockMode() {
        return this.source.updateTargetLockMode();
    }

    void adjustForSortElimination() {
        this.source.disableBulkFetch();
    }

    private int[] getIndexColMapping() {
        int rclSize = this.resultColumns.size();
        int[] indexColMapping = new int[rclSize];
        for (int index = 0; index < rclSize; ++index) {
            ResultColumn rc = (ResultColumn)this.resultColumns.elementAt(index);
            if (this.indexReferencedCols != null && rc.getExpression() instanceof VirtualColumnNode) {
                VirtualColumnNode vcn = (VirtualColumnNode)rc.getExpression();
                indexColMapping[index] = vcn.getSourceColumn().getVirtualColumnId() - 1;
                continue;
            }
            indexColMapping[index] = -1;
        }
        return indexColMapping;
    }
}

