/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.catalog.types.ReferencedColumnsDescriptorImpl;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.io.FormatableArrayHolder;
import org.apache.derby.iapi.services.io.FormatableIntHolder;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.Optimizable;
import org.apache.derby.iapi.sql.compile.Optimizer;
import org.apache.derby.iapi.sql.compile.Visitable;
import org.apache.derby.iapi.sql.compile.Visitor;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.AccessPathImpl;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.SingleChildResultSetNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;

public class HashTableNode
extends SingleChildResultSetNode {
    PredicateList searchPredicateList;
    PredicateList joinPredicateList;
    SubqueryList pSubqueryList;
    SubqueryList rSubqueryList;

    public void init(Object childResult, Object tableProperties, Object resultColumns, Object searchPredicateList, Object joinPredicateList, Object accessPath, Object costEstimate, Object pSubqueryList, Object rSubqueryList, Object hashKeyColumns) {
        super.init(childResult, tableProperties);
        this.resultColumns = (ResultColumnList)resultColumns;
        this.searchPredicateList = (PredicateList)searchPredicateList;
        this.joinPredicateList = (PredicateList)joinPredicateList;
        this.trulyTheBestAccessPath = (AccessPathImpl)accessPath;
        this.costEstimate = (CostEstimate)costEstimate;
        this.pSubqueryList = (SubqueryList)pSubqueryList;
        this.rSubqueryList = (SubqueryList)rSubqueryList;
        this.setHashKeyColumns((int[])hashKeyColumns);
    }

    public Optimizable modifyAccessPath(JBitSet outerTables, Optimizer optimizer) throws StandardException {
        return this;
    }

    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.searchPredicateList != null) {
            this.printLabel(depth, "searchPredicateList: ");
            this.searchPredicateList.treePrint(depth + 1);
        }
        if (this.joinPredicateList != null) {
            this.printLabel(depth, "joinPredicateList: ");
            this.joinPredicateList.treePrint(depth + 1);
        }
    }

    public void generate(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        SanityManager.ASSERT(this.resultColumns != null, "Tree structure bad");
        this.generateMinion(acb, mb, false);
    }

    public void generateResultSet(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        this.generateMinion(acb, mb, true);
    }

    private void generateMinion(ExpressionClassBuilder acb, MethodBuilder mb, boolean genChildResultSet) throws StandardException {
        ValueNode searchClause = null;
        Object equijoinClause = null;
        this.verifyProperties(this.getDataDictionary());
        if (this.searchPredicateList != null) {
            this.searchPredicateList.removeRedundantPredicates();
            searchClause = this.searchPredicateList.restorePredicates();
            this.searchPredicateList = null;
        }
        int[] mapArray = this.resultColumns.mapSourceColumns();
        int mapArrayItem = acb.addItem(new ReferencedColumnsDescriptorImpl(mapArray));
        Object[] fihArray = FormatableIntHolder.getFormatableIntHolders(this.hashKeyColumns());
        FormatableArrayHolder hashKeyHolder = new FormatableArrayHolder(fihArray);
        int hashKeyItem = acb.addItem(hashKeyHolder);
        acb.pushGetResultSetFactoryExpression(mb);
        if (genChildResultSet) {
            this.childResult.generateResultSet(acb, mb);
        } else {
            this.childResult.generate((ActivationClassBuilder)acb, mb);
        }
        this.assignResultSetNumber();
        if (this.pSubqueryList != null && this.pSubqueryList.size() > 0) {
            this.pSubqueryList.setPointOfAttachment(this.resultSetNumber);
            SanityManager.ASSERT(this.pSubqueryList.size() == 0, "pSubqueryList.size() expected to be 0");
        }
        if (this.rSubqueryList != null && this.rSubqueryList.size() > 0) {
            this.rSubqueryList.setPointOfAttachment(this.resultSetNumber);
            SanityManager.ASSERT(this.rSubqueryList.size() == 0, "rSubqueryList.size() expected to be 0");
        }
        this.costEstimate = this.childResult.getFinalCostEstimate();
        if (searchClause == null) {
            mb.pushNull("org.apache.derby.iapi.services.loader.GeneratedMethod");
        } else {
            MethodBuilder userExprFun = acb.newUserExprFun();
            searchClause.generateExpression(acb, userExprFun);
            userExprFun.methodReturn();
            userExprFun.complete();
            acb.pushMethodReference(mb, userExprFun);
        }
        this.joinPredicateList.generateQualifiers(acb, mb, (Optimizable)((Object)this.childResult), false);
        if (this.reflectionNeededForProjection()) {
            this.resultColumns.generateCore(acb, mb, false);
        } else {
            mb.pushNull("org.apache.derby.iapi.services.loader.GeneratedMethod");
        }
        mb.push(this.resultSetNumber);
        mb.push(mapArrayItem);
        mb.push(this.resultColumns.reusableResult());
        mb.push(hashKeyItem);
        mb.push(false);
        mb.push(-1L);
        mb.push(this.initialCapacity);
        mb.push(this.loadFactor);
        mb.push(this.costEstimate.singleScanRowCount());
        mb.push(this.costEstimate.getEstimatedCost());
        mb.callMethod((short)185, null, "getHashTableResultSet", "org.apache.derby.iapi.sql.execute.NoPutResultSet", 14);
    }

    public Visitable accept(Visitor v) throws StandardException {
        if (v.skipChildren(this)) {
            return v.visit(this);
        }
        Visitable returnNode = super.accept(v);
        if (this.searchPredicateList != null && !v.stopTraversal()) {
            this.searchPredicateList = (PredicateList)this.searchPredicateList.accept(v);
        }
        if (this.joinPredicateList != null && !v.stopTraversal()) {
            this.joinPredicateList = (PredicateList)this.joinPredicateList.accept(v);
        }
        return returnNode;
    }
}

