/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.compile.CostEstimate;
import org.apache.derby.iapi.sql.compile.OptimizablePredicate;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.AndNode;
import org.apache.derby.impl.sql.compile.BinaryRelationalOperatorNode;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.FromBaseTable;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.FromTable;
import org.apache.derby.impl.sql.compile.GroupByList;
import org.apache.derby.impl.sql.compile.JoinNode;
import org.apache.derby.impl.sql.compile.Predicate;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.RelationalOperator;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.ValueNode;

public class HalfOuterJoinNode
extends JoinNode {
    private boolean rightOuterJoin;
    private boolean transformed = false;

    public void init(Object leftResult, Object rightResult, Object onClause, Object usingClause, Object rightOuterJoin, Object tableProperties) throws StandardException {
        super.init(leftResult, rightResult, onClause, usingClause, null, tableProperties, null);
        this.rightOuterJoin = (Boolean)rightOuterJoin;
        this.flattenableJoin = false;
    }

    public boolean pushOptPredicate(OptimizablePredicate optimizablePredicate) throws StandardException {
        FromTable leftFromTable = (FromTable)this.leftResultSet;
        if (leftFromTable.getReferencedTableMap().contains(optimizablePredicate.getReferencedMap())) {
            return leftFromTable.pushOptPredicate(optimizablePredicate);
        }
        return false;
    }

    public String toString() {
        return "rightOuterJoin: " + this.rightOuterJoin + "\n" + "transformed: " + this.transformed + "\n" + super.toString();
    }

    public ResultSetNode preprocess(int numTables, GroupByList gbl, FromList fromList) throws StandardException {
        if (this.rightOuterJoin) {
            SanityManager.ASSERT(!this.transformed, "Attempting to transform a right outer join multiple times");
            ResultSetNode tmp = this.leftResultSet;
            this.leftResultSet = this.rightResultSet;
            this.rightResultSet = tmp;
            this.transformed = true;
        }
        ResultSetNode newTreeTop = super.preprocess(numTables, gbl, fromList);
        return newTreeTop;
    }

    public void pushExpressions(PredicateList outerPredicateList) throws StandardException {
        FromTable leftFromTable = (FromTable)this.leftResultSet;
        FromTable rightFromTable = (FromTable)this.rightResultSet;
        this.pushExpressionsToLeft(outerPredicateList);
        for (int index = this.joinPredicates.size() - 1; index >= 0; --index) {
            Predicate predicate = (Predicate)this.joinPredicates.elementAt(index);
            if (!predicate.getPushable()) continue;
            this.getRightPredicateList().addPredicate(predicate);
            this.joinPredicates.removeElementAt(index);
        }
        PredicateList noPredicates = (PredicateList)this.getNodeFactory().getNode(8, this.getContextManager());
        leftFromTable.pushExpressions(this.getLeftPredicateList());
        rightFromTable.pushExpressions(noPredicates);
    }

    public boolean LOJ_reorderable(int numTables) throws StandardException {
        ValueNode rightCol;
        ValueNode leftCol;
        BinaryRelationalOperatorNode equals;
        ValueNode left;
        AndNode and;
        ResultSetNode logicalRightResultSet;
        ResultSetNode logicalLeftResultSet;
        boolean anyChange = false;
        if (this.rightOuterJoin) {
            logicalLeftResultSet = this.rightResultSet;
            logicalRightResultSet = this.leftResultSet;
        } else {
            logicalLeftResultSet = this.leftResultSet;
            logicalRightResultSet = this.rightResultSet;
        }
        super.normExpressions();
        if (logicalLeftResultSet instanceof FromBaseTable && logicalRightResultSet instanceof FromBaseTable) {
            return anyChange;
        }
        if (logicalLeftResultSet instanceof HalfOuterJoinNode) {
            anyChange = ((HalfOuterJoinNode)logicalLeftResultSet).LOJ_reorderable(numTables) || anyChange;
        } else if (!(logicalLeftResultSet instanceof FromBaseTable)) {
            return anyChange;
        }
        if (logicalRightResultSet instanceof HalfOuterJoinNode) {
            anyChange = ((HalfOuterJoinNode)logicalRightResultSet).LOJ_reorderable(numTables) || anyChange;
        } else if (!(logicalRightResultSet instanceof FromBaseTable)) {
            return anyChange;
        }
        if (this.rightOuterJoin || logicalRightResultSet instanceof HalfOuterJoinNode && ((HalfOuterJoinNode)logicalRightResultSet).rightOuterJoin) {
            return this.LOJ_bindResultColumns(anyChange);
        }
        JBitSet RPReferencedTableMap = logicalLeftResultSet.LOJgetReferencedTables(numTables);
        JBitSet NPReferencedTableMap = logicalRightResultSet.LOJgetReferencedTables(numTables);
        if ((RPReferencedTableMap == null || NPReferencedTableMap == null) && anyChange) {
            return this.LOJ_bindResultColumns(anyChange);
        }
        ValueNode vn = this.joinClause;
        while (vn instanceof AndNode) {
            and = (AndNode)vn;
            left = and.getLeftOperand();
            if (left instanceof RelationalOperator && left.isBinaryEqualsOperatorNode()) {
                equals = (BinaryRelationalOperatorNode)left;
                leftCol = equals.getLeftOperand();
                rightCol = equals.getRightOperand();
                if (!(leftCol instanceof ColumnReference) || !(rightCol instanceof ColumnReference)) {
                    return this.LOJ_bindResultColumns(anyChange);
                }
                boolean refCheck = false;
                boolean leftOperandCheck = false;
                if (RPReferencedTableMap.get(((ColumnReference)leftCol).getTableNumber())) {
                    refCheck = true;
                    leftOperandCheck = true;
                } else if (NPReferencedTableMap.get(((ColumnReference)leftCol).getTableNumber())) {
                    refCheck = true;
                }
                if (!refCheck) {
                    return this.LOJ_bindResultColumns(anyChange);
                }
                refCheck = false;
                if (!leftOperandCheck && RPReferencedTableMap.get(((ColumnReference)rightCol).getTableNumber())) {
                    refCheck = true;
                } else if (leftOperandCheck && NPReferencedTableMap.get(((ColumnReference)rightCol).getTableNumber())) {
                    refCheck = true;
                }
                if (!refCheck) {
                    return this.LOJ_bindResultColumns(anyChange);
                }
            } else {
                return this.LOJ_bindResultColumns(anyChange);
            }
            vn = and.getRightOperand();
        }
        boolean push = false;
        if (logicalRightResultSet instanceof HalfOuterJoinNode) {
            JBitSet logicalNPRefTableMap = ((HalfOuterJoinNode)logicalRightResultSet).LOJgetNPReferencedTables(numTables);
            vn = this.joinClause;
            push = true;
            while (vn instanceof AndNode) {
                and = (AndNode)vn;
                left = and.getLeftOperand();
                equals = (BinaryRelationalOperatorNode)left;
                leftCol = equals.getLeftOperand();
                rightCol = equals.getRightOperand();
                if (logicalNPRefTableMap.get(((ColumnReference)leftCol).getTableNumber()) || logicalNPRefTableMap.get(((ColumnReference)rightCol).getTableNumber())) {
                    push = false;
                    break;
                }
                vn = and.getRightOperand();
            }
        }
        if (push) {
            if (this.subqueryList.size() != 0 || ((JoinNode)logicalRightResultSet).subqueryList.size() != 0 || this.joinPredicates.size() != 0 || ((JoinNode)logicalRightResultSet).joinPredicates.size() != 0 || this.usingClause != null || ((JoinNode)logicalRightResultSet).usingClause != null) {
                return this.LOJ_bindResultColumns(anyChange);
            }
            anyChange = true;
            ResultSetNode tmp = logicalLeftResultSet;
            ResultSetNode LChild = ((HalfOuterJoinNode)logicalRightResultSet).leftResultSet;
            ResultSetNode RChild = ((HalfOuterJoinNode)logicalRightResultSet).rightResultSet;
            ((HalfOuterJoinNode)logicalRightResultSet).rightResultSet = LChild;
            ((HalfOuterJoinNode)logicalRightResultSet).leftResultSet = tmp;
            vn = this.joinClause;
            this.joinClause = ((HalfOuterJoinNode)logicalRightResultSet).joinClause;
            ((HalfOuterJoinNode)logicalRightResultSet).joinClause = vn;
            FromList localFromList = (FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager());
            this.leftResultSet = logicalRightResultSet;
            this.rightResultSet = RChild;
            ((HalfOuterJoinNode)this.leftResultSet).resultColumns = null;
            ((JoinNode)this.leftResultSet).bindResultColumns(localFromList);
            boolean localChange = ((HalfOuterJoinNode)this.leftResultSet).LOJ_reorderable(numTables);
            return this.LOJ_bindResultColumns(anyChange);
        }
        return this.LOJ_bindResultColumns(anyChange);
    }

    public boolean LOJ_bindResultColumns(boolean anyChange) throws StandardException {
        if (anyChange) {
            this.resultColumns = null;
            FromList localFromList = (FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager());
            this.bindResultColumns(localFromList);
        }
        return anyChange;
    }

    public FromTable transformOuterJoins(ValueNode predicateTree, int numTables) throws StandardException {
        ResultSetNode innerRS;
        if (predicateTree == null) {
            this.leftResultSet.notFlattenableJoin();
            this.rightResultSet.notFlattenableJoin();
            return this;
        }
        super.transformOuterJoins(predicateTree, numTables);
        JBitSet innerMap = new JBitSet(numTables);
        if (this.rightOuterJoin) {
            SanityManager.ASSERT(!this.transformed, "right OJ not expected to be transformed into left OJ yet");
            innerRS = this.leftResultSet;
        } else {
            innerRS = this.rightResultSet;
        }
        innerRS.fillInReferencedTableMap(innerMap);
        ValueNode vn = predicateTree;
        while (vn instanceof AndNode) {
            AndNode and = (AndNode)vn;
            ValueNode left = and.getLeftOperand();
            if (left.isInstanceOf(25)) {
                vn = and.getRightOperand();
                continue;
            }
            if (left instanceof RelationalOperator) {
                JBitSet refMap = new JBitSet(numTables);
                if (!left.categorize(refMap, true)) {
                    vn = and.getRightOperand();
                    continue;
                }
                for (int bit = 0; bit < numTables; ++bit) {
                    if (!refMap.get(bit) || !innerMap.get(bit)) continue;
                    JoinNode ij = (JoinNode)this.getNodeFactory().getNode(139, this.leftResultSet, this.rightResultSet, this.joinClause, null, this.resultColumns, null, null, this.getContextManager());
                    ij.setTableNumber(this.tableNumber);
                    ij.setSubqueryList(this.subqueryList);
                    ij.setAggregateVector(this.aggregateVector);
                    return ij;
                }
            }
            vn = and.getRightOperand();
        }
        this.leftResultSet.notFlattenableJoin();
        this.rightResultSet.notFlattenableJoin();
        return this;
    }

    protected void adjustNumberOfRowsReturned(CostEstimate costEstimate) {
        CostEstimate outerCost = this.getLeftResultSet().getCostEstimate();
        if (costEstimate.rowCount() < outerCost.rowCount()) {
            costEstimate.setCost(costEstimate.getEstimatedCost(), outerCost.rowCount(), outerCost.rowCount());
        }
    }

    public void generate(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        SanityManager.ASSERT(this.rightOuterJoin == this.transformed, "rightOuterJoin (" + this.rightOuterJoin + ") is expected to equal transformed (" + this.transformed + ")");
        super.generateCore(acb, mb, 3);
    }

    protected int addOuterJoinArguments(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        this.rightResultSet.getResultColumns().generateNulls(acb, mb);
        mb.push(this.rightOuterJoin);
        return 2;
    }

    protected int getNumJoinArguments() {
        return super.getNumJoinArguments() + 2;
    }

    protected void oneRowRightSide(ActivationClassBuilder acb, MethodBuilder mb) {
        mb.push(false);
        mb.push(false);
    }

    ResultSetNode getLogicalLeftResultSet() {
        if (this.rightOuterJoin) {
            return this.rightResultSet;
        }
        return this.leftResultSet;
    }

    ResultSetNode getLogicalRightResultSet() {
        if (this.rightOuterJoin) {
            return this.leftResultSet;
        }
        return this.rightResultSet;
    }

    public boolean isRightOuterJoin() {
        return this.rightOuterJoin;
    }

    public JBitSet LOJgetNPReferencedTables(int numTables) throws StandardException {
        if (this.rightOuterJoin && !this.transformed) {
            return this.leftResultSet.LOJgetReferencedTables(numTables);
        }
        return this.rightResultSet.LOJgetReferencedTables(numTables);
    }
}

