/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.GroupByColumn;
import org.apache.derby.impl.sql.compile.OrderedColumnList;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.SelectNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;

public class GroupByList
extends OrderedColumnList {
    int numGroupingColsAdded = 0;

    public void addGroupByColumn(GroupByColumn column) {
        this.addElement(column);
    }

    public GroupByColumn getGroupByColumn(int position) {
        SanityManager.ASSERT(position >= 0 && position < this.size(), "position (" + position + ") expected to be between 0 and " + this.size());
        return (GroupByColumn)this.elementAt(position);
    }

    public void printSubNodes(int depth) {
        for (int index = 0; index < this.size(); ++index) {
            ((GroupByColumn)this.elementAt(index)).treePrint(depth);
        }
    }

    public int getNumNeedToAddGroupingCols() {
        return this.numGroupingColsAdded;
    }

    public void bindGroupByColumns(SelectNode select, Vector aggregateVector) throws StandardException {
        FromList fromList = select.getFromList();
        ResultColumnList selectRCL = select.getResultColumns();
        SubqueryList dummySubqueryList = (SubqueryList)this.getNodeFactory().getNode(11, this.getContextManager());
        int numColsAddedHere = 0;
        int size = this.size();
        if (size > 32677) {
            throw StandardException.newException("54004");
        }
        for (int index = 0; index < size; ++index) {
            GroupByColumn groupByCol = (GroupByColumn)this.elementAt(index);
            groupByCol.bindExpression(fromList, dummySubqueryList, aggregateVector);
        }
        int rclSize = selectRCL.size();
        for (int index = 0; index < size; ++index) {
            boolean matchFound = false;
            GroupByColumn groupingCol = (GroupByColumn)this.elementAt(index);
            for (int inner = 0; inner < rclSize; ++inner) {
                ColumnReference selectListCR;
                ResultColumn selectListRC = (ResultColumn)selectRCL.elementAt(inner);
                if (!(selectListRC.getExpression() instanceof ColumnReference) || !(selectListCR = (ColumnReference)selectListRC.getExpression()).isEquivalent(groupingCol.getColumnExpression())) continue;
                groupingCol.setColumnPosition(inner + 1);
                selectListRC.markAsGroupingColumn();
                matchFound = true;
                break;
            }
            if (matchFound || !(groupingCol.getColumnExpression() instanceof ColumnReference)) continue;
            ResultColumn newRC = (ResultColumn)this.getNodeFactory().getNode(80, groupingCol.getColumnName(), groupingCol.getColumnExpression().getClone(), this.getContextManager());
            newRC.setVirtualColumnId(selectRCL.size() + 1);
            newRC.markGenerated();
            newRC.markAsGroupingColumn();
            selectRCL.addElement(newRC);
            groupingCol.setColumnPosition(selectRCL.size());
            selectRCL.setCountMismatchAllowed(true);
            ++numColsAddedHere;
        }
        SanityManager.ASSERT(dummySubqueryList.size() == 0, "dummySubqueryList.size() is expected to be 0");
        this.numGroupingColsAdded += numColsAddedHere;
    }

    public GroupByColumn findGroupingColumn(ValueNode node) throws StandardException {
        int sz = this.size();
        for (int i = 0; i < sz; ++i) {
            GroupByColumn gbc = (GroupByColumn)this.elementAt(i);
            if (!gbc.getColumnExpression().isEquivalent(node)) continue;
            return gbc;
        }
        return null;
    }

    public void remapColumnReferencesToExpressions() throws StandardException {
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            GroupByColumn gbc = (GroupByColumn)this.elementAt(index);
            ValueNode retVN = gbc.getColumnExpression().remapColumnReferencesToExpressions();
            SanityManager.ASSERT(retVN instanceof ColumnReference, "retVN expected to be instanceof ColumnReference, not " + retVN.getClass().getName());
            gbc.setColumnExpression(retVN);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (int index = 0; index < this.size(); ++index) {
            GroupByColumn groupingCol = (GroupByColumn)this.elementAt(index);
            buf.append(groupingCol.toString());
        }
        return buf.toString();
    }

    public void preprocess(int numTables, FromList fromList, SubqueryList whereSubquerys, PredicateList wherePredicates) throws StandardException {
        for (int index = 0; index < this.size(); ++index) {
            GroupByColumn groupingCol = (GroupByColumn)this.elementAt(index);
            groupingCol.setColumnExpression(groupingCol.getColumnExpression().preprocess(numTables, fromList, whereSubquerys, wherePredicates));
        }
    }
}

